/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pg.tool;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;

public class PgOssUtils {
    protected static final SupperLogUtil logger = new SupperLogUtil(PgOssUtils.class);
    public static String fileType = "";

    public static String uploadOssFile(String endpoint, String accessKeyId, String accessKeySecret, String goodsUrl, String bucketName, String objectName, String ossUrl, Boolean flg) {
        OSS ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);
        byte[] bytes = PgOssUtils.getFileStream(goodsUrl, flg);
        if (null == bytes) {
            return null;
        }
        String fileName = UUID.randomUUID().toString();
        ossClient.putObject(bucketName, objectName + fileName + fileType, (InputStream)new ByteArrayInputStream(bytes));
        String resultUrl = "https://" + bucketName + "." + ossUrl + "/" + objectName + fileName + fileType;
        return resultUrl;
    }

    public static byte[] getFileStream(String url, Boolean flg) {
        try {
            String contentType;
            BufferedImage tag = null;
            BufferedImage image = null;
            URL httpUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)httpUrl.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            int contentLength = conn.getContentLength();
            if (contentLength < 0) {
                return null;
            }
            if (flg.booleanValue()) {
                image = ImageIO.read(httpUrl);
                tag = new BufferedImage(1250, 1250, 1);
                tag.getGraphics().drawImage(image.getScaledInstance(1250, 1250, 4), 0, 0, null);
            }
            if (StringUtils.isBlank((String)(fileType = PgOssUtils.checkFileType(contentType = conn.getContentType())))) {
                logger.error("PgOssUtils.getFileStream-contentType", (Object)contentType);
                return null;
            }
            if (flg.booleanValue()) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)tag, fileType.substring(1, fileType.length()), out);
                return out.toByteArray();
            }
            InputStream inStream = conn.getInputStream();
            byte[] btImg = PgOssUtils.readInputStream(inStream);
            return btImg;
        }
        catch (Exception e) {
            fileType = "";
            logger.error("PgOssUtils.getFileStream-contentType", (Throwable)e);
            return null;
        }
    }

    public static String checkFileType(String contentType) {
        if (StringUtils.isNotBlank((String)contentType) && contentType.equals("image/png")) {
            return ".png";
        }
        if (StringUtils.isNotBlank((String)contentType) && contentType.equals("image/jpeg")) {
            return ".jpeg";
        }
        if (StringUtils.isNotBlank((String)contentType) && contentType.equals("image/jpg")) {
            return ".jpg";
        }
        return "";
    }

    public static byte[] readInputStream(InputStream inStream) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, len);
        }
        inStream.close();
        return outStream.toByteArray();
    }

    public static String checkParam(Map<String, Object> map) {
        if (EmptyUtil.isEmpty((Object)map.get("accessKeyId"))) {
            return "accessKeyId-null";
        }
        if (EmptyUtil.isEmpty((Object)map.get("accessKeySecret"))) {
            return "accessKeySecret-null";
        }
        if (EmptyUtil.isEmpty((Object)map.get("endpoint"))) {
            return "endpoint-null";
        }
        if (EmptyUtil.isEmpty((Object)map.get("bucketName"))) {
            return "bucketName-null";
        }
        if (EmptyUtil.isEmpty((Object)map.get("objectName"))) {
            return "objectName-null";
        }
        if (EmptyUtil.isEmpty((Object)map.get("realmName"))) {
            return "realmName-null";
        }
        if (EmptyUtil.isEmpty((Object)map.get("goodsUrl"))) {
            return "goodsUrl-null";
        }
        if (EmptyUtil.isEmpty((Object)map.get("labelCode"))) {
            return "labelCode-null";
        }
        if (EmptyUtil.isEmpty((Object)map.get("tenantCode"))) {
            return "tenantCode-null";
        }
        return null;
    }
}

