/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.pg.tool.ws.model;

import com.yqbsoft.laser.service.pg.tool.ws.entity.Instance;
import com.yqbsoft.laser.service.pg.tool.ws.entity.PlacePoint;
import com.yqbsoft.laser.service.pg.tool.ws.entity.PlaceSquare;
import com.yqbsoft.laser.service.pg.tool.ws.entity.Solution;
import com.yqbsoft.laser.service.pg.tool.ws.entity.Square;
import com.yqbsoft.laser.service.pg.tool.ws.model.TabuMapTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

public class TabuSearch {
    public final int MAX_GEN = 100;
    public final int N = 10;
    public int sqNum;
    public HashMap<String, TabuMapTree> tabuTreeMap = new HashMap();
    public List<Square> initGhh;
    public List<Square> bestGh;
    public List<Square> LocalGh;
    public List<Square> tempGh;
    public int bestT;
    public Solution bestSolution;
    public Solution LocalSolution;
    public Solution tempSolution;
    public int t;
    public Random random;
    public Instance instance;
    double length;
    double wide;

    public TabuSearch(Instance instance) throws Exception {
        this.instance = instance;
        this.initGhh = new ArrayList<Square>(instance.getSquareList());
        this.random = new Random(System.currentTimeMillis());
        this.length = instance.getL();
        this.wide = instance.getW();
        this.sqNum = this.initGhh.size();
    }

    public Solution search() throws Exception {
        long start = System.currentTimeMillis();
        this.getInitSolution();
        System.out.println(this.bestSolution.getRate());
        while (this.t <= 100) {
            this.LocalSolution = new Solution();
            this.LocalSolution.setRate(0.0);
            for (int n = 0; n <= 10; ++n) {
                this.tempGh = this.generateNewGh(new ArrayList<Square>(this.initGhh), new ArrayList<Square>(this.tempGh));
                if (this.judge(this.tempGh)) continue;
                this.enterTabooList(this.tempGh);
                this.tempSolution = this.evaluate(this.tempGh);
                if (!this.tempSolution.isSuccess() || !(this.tempSolution.getRate() >= this.LocalSolution.getRate())) continue;
                this.LocalGh = new ArrayList<Square>(this.tempGh);
                this.LocalSolution = this.tempSolution;
            }
            if (this.tempSolution.isSuccess() && this.LocalSolution.getRate() >= this.bestSolution.getRate()) {
                this.bestT = this.t;
                this.bestGh = new ArrayList<Square>(this.LocalGh);
                this.bestSolution = this.LocalSolution;
            }
            this.initGhh = new ArrayList<Square>(this.LocalGh);
            ++this.t;
        }
        System.out.println("\u6700\u4f73\u8fed\u4ee3\u6b21\u6570:" + this.bestT);
        System.out.println("\u6700\u4f73\u5229\u7528\u7387\u4e3a:" + this.bestSolution.getRate());
        System.out.println("\u7528\u65f6\uff1a" + (System.currentTimeMillis() - start) + "ms");
        return this.bestSolution;
    }

    public Solution evaluate(List<Square> squareList) {
        Solution solution = new Solution();
        solution.setInstance(this.instance);
        solution.setSquareList(new ArrayList<Square>(squareList));
        ArrayList<PlaceSquare> placeSquareList = new ArrayList<PlaceSquare>();
        ArrayList<PlacePoint> placePointList = new ArrayList<PlacePoint>();
        placePointList.add(new PlacePoint(0.0, 0.0));
        for (int i = 0; i < squareList.size(); ++i) {
            PlacePoint placePoint = null;
            boolean b = false;
            Square square = squareList.get(i);
            for (int j = 0; j < placePointList.size(); ++j) {
                placePoint = (PlacePoint)placePointList.get(j);
                PlaceSquare placeSquare = new PlaceSquare(placePoint.getX(), placePoint.getY(), square.getL(), square.getW());
                if (this.isOverlap(placeSquareList, placeSquare)) continue;
                b = true;
                placePointList.remove(j);
                placeSquareList.add(new PlaceSquare(placePoint.getX(), placePoint.getY(), square.getL(), square.getW()));
                placePointList.add(new PlacePoint(placePoint.getX() + square.getL(), placePoint.getY()));
                placePointList.add(new PlacePoint(placePoint.getX(), placePoint.getY() + square.getW()));
                Collections.sort(placePointList);
                j = placePointList.size();
                solution.setSuccess(true);
            }
            if (b || !this.instance.isRotateEnable()) continue;
            double l = square.getL();
            double w = square.getW();
            square.setL(w);
            square.setW(l);
            for (int j = 0; j < placePointList.size(); ++j) {
                placePoint = (PlacePoint)placePointList.get(j);
                PlaceSquare placeSquare = new PlaceSquare(placePoint.getX(), placePoint.getY(), square.getL(), square.getW());
                if (this.isOverlap(placeSquareList, placeSquare)) continue;
                b = true;
                placePointList.remove(j);
                placeSquareList.add(new PlaceSquare(placePoint.getX(), placePoint.getY(), square.getL(), square.getW()));
                placePointList.add(new PlacePoint(placePoint.getX() + square.getL(), placePoint.getY()));
                placePointList.add(new PlacePoint(placePoint.getX(), placePoint.getY() + square.getW()));
                Collections.sort(placePointList);
                j = placePointList.size();
                solution.setSuccess(true);
            }
            square.setL(l);
            square.setW(w);
            if (b || i == placeSquareList.size() - 1) continue;
            solution.setSuccess(false);
            solution.setRate(0.0);
            return solution;
        }
        this.length = placePointList.stream().mapToDouble(p -> p.getX()).max().getAsDouble();
        this.wide = placePointList.stream().mapToDouble(p -> p.getY()).max().getAsDouble();
        solution.getInstance().setL(this.length);
        solution.getInstance().setW(this.wide);
        solution.setPlaceSquareList(new ArrayList<PlaceSquare>(placeSquareList));
        double rate = 0.0;
        double s = 0.0;
        for (PlaceSquare placeSquare : placeSquareList) {
            s += placeSquare.getL() * placeSquare.getW();
        }
        rate = s / (this.length * this.wide);
        solution.setRate(rate);
        return solution;
    }

    private void setPlaceSquareList(boolean b, Square square, PlacePoint placePoint, List<PlaceSquare> placeSquareList, List<PlacePoint> placePointList) {
    }

    public boolean isOverlap(List<PlaceSquare> placeSquareList, PlaceSquare tempPlaceSquare) {
        if (tempPlaceSquare.getL() > this.length || tempPlaceSquare.getW() > this.wide) {
            return true;
        }
        if (tempPlaceSquare.getX() + tempPlaceSquare.getL() > this.length || tempPlaceSquare.getY() + tempPlaceSquare.getW() > this.wide) {
            return true;
        }
        for (PlaceSquare placeSquare : placeSquareList) {
            if (placeSquare.getX() != tempPlaceSquare.getX() || placeSquare.getY() == tempPlaceSquare.getY()) {
                // empty if block
            }
            if (!this.isOverlap2(placeSquare, tempPlaceSquare)) continue;
            return true;
        }
        return false;
    }

    public boolean isOverlap2(PlaceSquare placeSquare, PlaceSquare tempPlaceSquare) {
        double x1 = Math.max(placeSquare.getX(), tempPlaceSquare.getX());
        double y1 = Math.max(placeSquare.getY(), tempPlaceSquare.getY());
        double x2 = Math.min(placeSquare.getX() + placeSquare.getL(), tempPlaceSquare.getX() + tempPlaceSquare.getL());
        double y2 = Math.min(placeSquare.getY() + placeSquare.getW(), tempPlaceSquare.getY() + tempPlaceSquare.getW());
        return !(x1 >= x2) && !(y1 >= y2);
    }

    public void getInitSolution() throws Exception {
        this.tempSolution = this.bestSolution = this.evaluate(new ArrayList<Square>(this.initGhh));
        this.bestGh = new ArrayList<Square>(this.initGhh);
        this.tempGh = new ArrayList<Square>(this.initGhh);
        this.LocalGh = new ArrayList<Square>(this.initGhh);
    }

    public void enterTabooList(List<Square> squareList) {
        Square square;
        String id;
        if (this.tabuTreeMap == null) {
            this.tabuTreeMap = new HashMap();
        }
        if (this.tabuTreeMap.containsKey(id = (square = squareList.get(0)).getId())) {
            this.tabuTreeMap.get(id).add(new ArrayList<Square>(squareList), 1);
        } else {
            TabuMapTree tabuMapTree = new TabuMapTree();
            tabuMapTree.setNodeSquare(square);
            tabuMapTree.add(new ArrayList<Square>(squareList), 1);
            this.tabuTreeMap.put(id, tabuMapTree);
        }
    }

    public List<Square> generateNewGh(List<Square> localGh, List<Square> tempGh) {
        tempGh = new ArrayList<Square>(localGh);
        Collections.shuffle(tempGh);
        return tempGh;
    }

    public boolean judge(List<Square> Gh) {
        Square square = Gh.get(0);
        if (this.tabuTreeMap.containsKey(square.getId())) {
            return this.tabuTreeMap.get(square.getId()).contains(Gh, 1);
        }
        return false;
    }

    public boolean isEq(Square square1, Square square2) {
        return square1.getId().equals(square2.getId());
    }

    public int getMAX_GEN() {
        return this.MAX_GEN;
    }

    public int getN() {
        return this.N;
    }

    public int getSqNum() {
        return this.sqNum;
    }

    public HashMap<String, TabuMapTree> getTabuTreeMap() {
        return this.tabuTreeMap;
    }

    public List<Square> getInitGhh() {
        return this.initGhh;
    }

    public List<Square> getBestGh() {
        return this.bestGh;
    }

    public List<Square> getLocalGh() {
        return this.LocalGh;
    }

    public List<Square> getTempGh() {
        return this.tempGh;
    }

    public int getBestT() {
        return this.bestT;
    }

    public Solution getBestSolution() {
        return this.bestSolution;
    }

    public Solution getLocalSolution() {
        return this.LocalSolution;
    }

    public Solution getTempSolution() {
        return this.tempSolution;
    }

    public int getT() {
        return this.t;
    }

    public Random getRandom() {
        return this.random;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public double getLength() {
        return this.length;
    }

    public double getWide() {
        return this.wide;
    }

    public void setSqNum(int sqNum) {
        this.sqNum = sqNum;
    }

    public void setTabuTreeMap(HashMap<String, TabuMapTree> tabuTreeMap) {
        this.tabuTreeMap = tabuTreeMap;
    }

    public void setInitGhh(List<Square> initGhh) {
        this.initGhh = initGhh;
    }

    public void setBestGh(List<Square> bestGh) {
        this.bestGh = bestGh;
    }

    public void setLocalGh(List<Square> LocalGh) {
        this.LocalGh = LocalGh;
    }

    public void setTempGh(List<Square> tempGh) {
        this.tempGh = tempGh;
    }

    public void setBestT(int bestT) {
        this.bestT = bestT;
    }

    public void setBestSolution(Solution bestSolution) {
        this.bestSolution = bestSolution;
    }

    public void setLocalSolution(Solution LocalSolution) {
        this.LocalSolution = LocalSolution;
    }

    public void setTempSolution(Solution tempSolution) {
        this.tempSolution = tempSolution;
    }

    public void setT(int t) {
        this.t = t;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public void setInstance(Instance instance) {
        this.instance = instance;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public void setWide(double wide) {
        this.wide = wide;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TabuSearch)) {
            return false;
        }
        TabuSearch other = (TabuSearch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMAX_GEN() != other.getMAX_GEN()) {
            return false;
        }
        if (this.getN() != other.getN()) {
            return false;
        }
        if (this.getSqNum() != other.getSqNum()) {
            return false;
        }
        HashMap<String, TabuMapTree> this$tabuTreeMap = this.getTabuTreeMap();
        HashMap<String, TabuMapTree> other$tabuTreeMap = other.getTabuTreeMap();
        if (this$tabuTreeMap == null ? other$tabuTreeMap != null : !((Object)this$tabuTreeMap).equals(other$tabuTreeMap)) {
            return false;
        }
        List<Square> this$initGhh = this.getInitGhh();
        List<Square> other$initGhh = other.getInitGhh();
        if (this$initGhh == null ? other$initGhh != null : !((Object)this$initGhh).equals(other$initGhh)) {
            return false;
        }
        List<Square> this$bestGh = this.getBestGh();
        List<Square> other$bestGh = other.getBestGh();
        if (this$bestGh == null ? other$bestGh != null : !((Object)this$bestGh).equals(other$bestGh)) {
            return false;
        }
        List<Square> this$LocalGh = this.getLocalGh();
        List<Square> other$LocalGh = other.getLocalGh();
        if (this$LocalGh == null ? other$LocalGh != null : !((Object)this$LocalGh).equals(other$LocalGh)) {
            return false;
        }
        List<Square> this$tempGh = this.getTempGh();
        List<Square> other$tempGh = other.getTempGh();
        if (this$tempGh == null ? other$tempGh != null : !((Object)this$tempGh).equals(other$tempGh)) {
            return false;
        }
        if (this.getBestT() != other.getBestT()) {
            return false;
        }
        Solution this$bestSolution = this.getBestSolution();
        Solution other$bestSolution = other.getBestSolution();
        if (this$bestSolution == null ? other$bestSolution != null : !((Object)this$bestSolution).equals(other$bestSolution)) {
            return false;
        }
        Solution this$LocalSolution = this.getLocalSolution();
        Solution other$LocalSolution = other.getLocalSolution();
        if (this$LocalSolution == null ? other$LocalSolution != null : !((Object)this$LocalSolution).equals(other$LocalSolution)) {
            return false;
        }
        Solution this$tempSolution = this.getTempSolution();
        Solution other$tempSolution = other.getTempSolution();
        if (this$tempSolution == null ? other$tempSolution != null : !((Object)this$tempSolution).equals(other$tempSolution)) {
            return false;
        }
        if (this.getT() != other.getT()) {
            return false;
        }
        Random this$random = this.getRandom();
        Random other$random = other.getRandom();
        if (this$random == null ? other$random != null : !this$random.equals(other$random)) {
            return false;
        }
        Instance this$instance = this.getInstance();
        Instance other$instance = other.getInstance();
        if (this$instance == null ? other$instance != null : !((Object)this$instance).equals(other$instance)) {
            return false;
        }
        if (Double.compare(this.getLength(), other.getLength()) != 0) {
            return false;
        }
        return Double.compare(this.getWide(), other.getWide()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof TabuSearch;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMAX_GEN();
        result = result * 59 + this.getN();
        result = result * 59 + this.getSqNum();
        HashMap<String, TabuMapTree> $tabuTreeMap = this.getTabuTreeMap();
        result = result * 59 + ($tabuTreeMap == null ? 43 : ((Object)$tabuTreeMap).hashCode());
        List<Square> $initGhh = this.getInitGhh();
        result = result * 59 + ($initGhh == null ? 43 : ((Object)$initGhh).hashCode());
        List<Square> $bestGh = this.getBestGh();
        result = result * 59 + ($bestGh == null ? 43 : ((Object)$bestGh).hashCode());
        List<Square> $LocalGh = this.getLocalGh();
        result = result * 59 + ($LocalGh == null ? 43 : ((Object)$LocalGh).hashCode());
        List<Square> $tempGh = this.getTempGh();
        result = result * 59 + ($tempGh == null ? 43 : ((Object)$tempGh).hashCode());
        result = result * 59 + this.getBestT();
        Solution $bestSolution = this.getBestSolution();
        result = result * 59 + ($bestSolution == null ? 43 : ((Object)$bestSolution).hashCode());
        Solution $LocalSolution = this.getLocalSolution();
        result = result * 59 + ($LocalSolution == null ? 43 : ((Object)$LocalSolution).hashCode());
        Solution $tempSolution = this.getTempSolution();
        result = result * 59 + ($tempSolution == null ? 43 : ((Object)$tempSolution).hashCode());
        result = result * 59 + this.getT();
        Random $random = this.getRandom();
        result = result * 59 + ($random == null ? 43 : $random.hashCode());
        Instance $instance = this.getInstance();
        result = result * 59 + ($instance == null ? 43 : ((Object)$instance).hashCode());
        long $length = Double.doubleToLongBits(this.getLength());
        result = result * 59 + (int)($length >>> 32 ^ $length);
        long $wide = Double.doubleToLongBits(this.getWide());
        result = result * 59 + (int)($wide >>> 32 ^ $wide);
        return result;
    }

    public String toString() {
        return "TabuSearch(MAX_GEN=" + this.getMAX_GEN() + ", N=" + this.getN() + ", sqNum=" + this.getSqNum() + ", tabuTreeMap=" + this.getTabuTreeMap() + ", initGhh=" + this.getInitGhh() + ", bestGh=" + this.getBestGh() + ", LocalGh=" + this.getLocalGh() + ", tempGh=" + this.getTempGh() + ", bestT=" + this.getBestT() + ", bestSolution=" + this.getBestSolution() + ", LocalSolution=" + this.getLocalSolution() + ", tempSolution=" + this.getTempSolution() + ", t=" + this.getT() + ", random=" + this.getRandom() + ", instance=" + this.getInstance() + ", length=" + this.getLength() + ", wide=" + this.getWide() + ")";
    }
}

