/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.portal.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.portal.dao.CmsContlistGoodsMapper;
import com.yqbsoft.laser.service.portal.domain.CmsContlistGoodsDomain;
import com.yqbsoft.laser.service.portal.domain.CmsContlistGoodsReDomain;
import com.yqbsoft.laser.service.portal.model.CmsContlistGoods;
import com.yqbsoft.laser.service.portal.service.CmsContlistGoodsService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CmsContlistGoodsServiceImpl
extends BaseServiceImpl
implements CmsContlistGoodsService {
    private static final String SYS_CODE = "cms.CmsContlistGoodsServiceImpl";
    private CmsContlistGoodsMapper cmsContlistGoodsMapper;

    public void setCmsContlistGoodsMapper(CmsContlistGoodsMapper cmsContlistGoodsMapper) {
        this.cmsContlistGoodsMapper = cmsContlistGoodsMapper;
    }

    private Date getSysDate() {
        try {
            return this.cmsContlistGoodsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsContlistGoodsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkContlistGoods(CmsContlistGoodsDomain cmsContlistGoodsDomain) {
        if (null == cmsContlistGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)cmsContlistGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setContlistGoodsDefault(CmsContlistGoods cmsContlistGoods) {
        if (null == cmsContlistGoods) {
            return;
        }
        if (null == cmsContlistGoods.getDataState()) {
            cmsContlistGoods.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == cmsContlistGoods.getGmtCreate()) {
            cmsContlistGoods.setGmtCreate(date);
        }
        cmsContlistGoods.setGmtModified(date);
        if (StringUtils.isBlank((String)cmsContlistGoods.getGoodsCode())) {
            cmsContlistGoods.setGoodsCode(this.getNo(null, "CmsContlistGoods", "cmsContlistGoods", cmsContlistGoods.getTenantCode()));
        }
    }

    private int getContlistGoodsMaxCode() {
        int code = 0;
        try {
            return this.cmsContlistGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsContlistGoodsServiceImpl.getContlistGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContlistGoodsUpdataDefault(CmsContlistGoods cmsContlistGoods) {
        if (null == cmsContlistGoods) {
            return;
        }
        cmsContlistGoods.setGmtModified(this.getSysDate());
    }

    private void saveContlistGoodsModel(CmsContlistGoods cmsContlistGoods) throws ApiException {
        if (null == cmsContlistGoods) {
            return;
        }
        try {
            this.cmsContlistGoodsMapper.insert(cmsContlistGoods);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsContlistGoodsServiceImpl.saveContlistGoodsModel.ex", (Throwable)e);
        }
    }

    private void saveContlistGoodsBatchModel(List<CmsContlistGoods> cmsContlistGoodsList) throws ApiException {
        if (null == cmsContlistGoodsList || cmsContlistGoodsList.isEmpty()) {
            return;
        }
        try {
            this.cmsContlistGoodsMapper.insertBatch(cmsContlistGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsContlistGoodsServiceImpl.saveContlistGoodsBatchModel.ex", (Throwable)e);
        }
    }

    private CmsContlistGoods getContlistGoodsModelById(Integer contlistGoodsId) {
        if (null == contlistGoodsId) {
            return null;
        }
        try {
            return this.cmsContlistGoodsMapper.selectByPrimaryKey(contlistGoodsId);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsContlistGoodsServiceImpl.getContlistGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private CmsContlistGoods getContlistGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cmsContlistGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsContlistGoodsServiceImpl.getContlistGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delContlistGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsContlistGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsContlistGoodsServiceImpl.delContlistGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsContlistGoodsServiceImpl.delContlistGoodsModelByCode.num");
        }
    }

    private void deleteContlistGoodsModel(Integer contlistGoodsId) throws ApiException {
        if (null == contlistGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsContlistGoodsMapper.deleteByPrimaryKey(contlistGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsContlistGoodsServiceImpl.deleteContlistGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsContlistGoodsServiceImpl.deleteContlistGoodsModel.num");
        }
    }

    private void updateContlistGoodsModel(CmsContlistGoods cmsContlistGoods) throws ApiException {
        if (null == cmsContlistGoods) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsContlistGoodsMapper.updateByPrimaryKey(cmsContlistGoods);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsContlistGoodsServiceImpl.updateContlistGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsContlistGoodsServiceImpl.updateContlistGoodsModel.num");
        }
    }

    private void updateStateContlistGoodsModel(Integer contlistGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == contlistGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsId", contlistGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.cmsContlistGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsContlistGoodsServiceImpl.updateStateContlistGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsContlistGoodsServiceImpl.updateStateContlistGoodsModel.null");
        }
    }

    private void updateStateContlistGoodsModelByCode(String tenantCode, String contlistGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)contlistGoodsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsCode", contlistGoodsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.cmsContlistGoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsContlistGoodsServiceImpl.updateStateContlistGoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsContlistGoodsServiceImpl.updateStateContlistGoodsModelByCode.null");
        }
    }

    private CmsContlistGoods makeContlistGoods(CmsContlistGoodsDomain cmsContlistGoodsDomain, CmsContlistGoods cmsContlistGoods) {
        if (null == cmsContlistGoodsDomain) {
            return null;
        }
        if (null == cmsContlistGoods) {
            cmsContlistGoods = new CmsContlistGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmsContlistGoods, (Object)cmsContlistGoodsDomain);
            return cmsContlistGoods;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsContlistGoodsServiceImpl.makeContlistGoods", (Throwable)e);
            return null;
        }
    }

    private CmsContlistGoodsReDomain makeCmsContlistGoodsReDomain(CmsContlistGoods cmsContlistGoods) {
        if (null == cmsContlistGoods) {
            return null;
        }
        CmsContlistGoodsReDomain cmsContlistGoodsReDomain = new CmsContlistGoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cmsContlistGoodsReDomain, (Object)cmsContlistGoods);
            return cmsContlistGoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsContlistGoodsServiceImpl.makeCmsContlistGoodsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CmsContlistGoods> queryContlistGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.cmsContlistGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsContlistGoodsServiceImpl.queryContlistGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countContlistGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmsContlistGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsContlistGoodsServiceImpl.countContlistGoods", (Throwable)e);
        }
        return i;
    }

    private CmsContlistGoods createCmsContlistGoods(CmsContlistGoodsDomain cmsContlistGoodsDomain) {
        String msg = this.checkContlistGoods(cmsContlistGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsContlistGoodsServiceImpl.saveContlistGoods.checkContlistGoods", msg);
        }
        CmsContlistGoods cmsContlistGoods = this.makeContlistGoods(cmsContlistGoodsDomain, null);
        this.setContlistGoodsDefault(cmsContlistGoods);
        return cmsContlistGoods;
    }

    @Override
    public String saveContlistGoods(CmsContlistGoodsDomain cmsContlistGoodsDomain) throws ApiException {
        CmsContlistGoods cmsContlistGoods = this.createCmsContlistGoods(cmsContlistGoodsDomain);
        this.saveContlistGoodsModel(cmsContlistGoods);
        return cmsContlistGoods.getGoodsCode();
    }

    @Override
    public String saveContlistGoodsBatch(List<CmsContlistGoodsDomain> cmsContlistGoodsDomainList) throws ApiException {
        if (null == cmsContlistGoodsDomainList || cmsContlistGoodsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CmsContlistGoods> cmsContlistGoodsList = new ArrayList<CmsContlistGoods>();
        String code = "";
        for (CmsContlistGoodsDomain cmsContlistGoodsDomain : cmsContlistGoodsDomainList) {
            CmsContlistGoods cmsContlistGoods = this.createCmsContlistGoods(cmsContlistGoodsDomain);
            code = cmsContlistGoods.getGoodsCode();
            cmsContlistGoodsList.add(cmsContlistGoods);
        }
        this.saveContlistGoodsBatchModel(cmsContlistGoodsList);
        return code;
    }

    @Override
    public void updateContlistGoodsState(Integer contlistGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == contlistGoodsId) {
            return;
        }
        this.updateStateContlistGoodsModel(contlistGoodsId, dataState, oldDataState, map);
    }

    @Override
    public void updateContlistGoodsStateByCode(String tenantCode, String contlistGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)contlistGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateContlistGoodsModelByCode(tenantCode, contlistGoodsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateContlistGoods(CmsContlistGoodsDomain cmsContlistGoodsDomain) throws ApiException {
        String msg = this.checkContlistGoods(cmsContlistGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsContlistGoodsServiceImpl.updateContlistGoods.checkContlistGoods", msg);
        }
        CmsContlistGoods oldCmsContlistGoods = this.getContlistGoodsModelById(cmsContlistGoodsDomain.getGoodsId());
        if (null == oldCmsContlistGoods) {
            throw new ApiException("cms.CmsContlistGoodsServiceImpl.updateContlistGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CmsContlistGoods cmsContlistGoods = this.makeContlistGoods(cmsContlistGoodsDomain, oldCmsContlistGoods);
        this.setContlistGoodsUpdataDefault(cmsContlistGoods);
        this.updateContlistGoodsModel(cmsContlistGoods);
    }

    @Override
    public CmsContlistGoods getContlistGoods(Integer contlistGoodsId) {
        if (null == contlistGoodsId) {
            return null;
        }
        return this.getContlistGoodsModelById(contlistGoodsId);
    }

    @Override
    public void deleteContlistGoods(Integer contlistGoodsId) throws ApiException {
        if (null == contlistGoodsId) {
            return;
        }
        this.deleteContlistGoodsModel(contlistGoodsId);
    }

    @Override
    public QueryResult<CmsContlistGoods> queryContlistGoodsPage(Map<String, Object> map) {
        List<CmsContlistGoods> cmsContlistGoodsList = this.queryContlistGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContlistGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmsContlistGoodsList);
        return queryResult;
    }

    @Override
    public CmsContlistGoods getContlistGoodsByCode(String tenantCode, String contlistGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)contlistGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsCode", contlistGoodsCode);
        return this.getContlistGoodsModelByCode(map);
    }

    @Override
    public void deleteContlistGoodsByCode(String tenantCode, String contlistGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)contlistGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsCode", contlistGoodsCode);
        this.delContlistGoodsModelByCode(map);
    }
}

