/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.portal.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.portal.PortalConstants;
import com.yqbsoft.laser.service.portal.dao.CmsDoclistMapper;
import com.yqbsoft.laser.service.portal.domain.CmsDoclistDomainBean;
import com.yqbsoft.laser.service.portal.model.CmsDoclist;
import com.yqbsoft.laser.service.portal.model.CmsTginfoRmenu;
import com.yqbsoft.laser.service.portal.service.CmsDoclistService;
import com.yqbsoft.laser.service.portal.service.CmsTginfoMenuService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.helper.StringUtil;

public class CmsDoclistServiceImpl
extends BaseServiceImpl
implements CmsDoclistService {
    public static final String SYS_CODE = "cms.CmsDoclistServiceImpl";
    private CmsDoclistMapper cmsDoclistMapper;
    private CmsTginfoMenuService cmsTginfoMenuService;

    public void setCmsDoclistMapper(CmsDoclistMapper cmsDoclistMapper) {
        this.cmsDoclistMapper = cmsDoclistMapper;
    }

    public CmsTginfoMenuService getCmsTginfoMenuService() {
        return this.cmsTginfoMenuService;
    }

    public void setCmsTginfoMenuService(CmsTginfoMenuService cmsTginfoMenuService) {
        this.cmsTginfoMenuService = cmsTginfoMenuService;
    }

    private Date getSysDate() {
        try {
            return this.cmsDoclistMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsDoclistServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkDoclist(CmsDoclistDomainBean cmsDoclistDomainBean) {
        if (null == cmsDoclistDomainBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)cmsDoclistDomainBean.getTginfoMenuCode())) {
            msg = msg + "\u83dc\u5355\u4ee3\u7801\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDoclistDefault(CmsDoclist cmsDoclist) {
        if (null == cmsDoclist) {
            return;
        }
        if (null == cmsDoclist.getDataState()) {
            cmsDoclist.setDataState(0);
        }
        if (null == cmsDoclist.getGmtCreate()) {
            cmsDoclist.setGmtCreate(this.getSysDate());
        }
        cmsDoclist.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cmsDoclist.getDoclistCode())) {
            cmsDoclist.setDoclistCode(this.createUUIDString());
        }
    }

    private int getDoclistMaxCode() {
        int code = 0;
        try {
            return this.cmsDoclistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsDoclistServiceImpl.getDoclistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDoclistUpdataDefault(CmsDoclist cmsDoclist) {
        if (null == cmsDoclist) {
            return;
        }
        cmsDoclist.setDataState(0);
        cmsDoclist.setGmtModified(this.getSysDate());
    }

    private void saveDoclistModel(CmsDoclist cmsDoclist) throws ApiException {
        if (null == cmsDoclist) {
            return;
        }
        try {
            this.cmsDoclistMapper.insert(cmsDoclist);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsDoclistServiceImpl.saveDoclistModel.ex", (Throwable)e);
        }
    }

    private CmsDoclist getDoclistModelById(Integer doclistId) {
        if (null == doclistId) {
            return null;
        }
        try {
            return this.cmsDoclistMapper.selectByPrimaryKey(doclistId);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsDoclistServiceImpl.getDoclistModelById", (Throwable)e);
            return null;
        }
    }

    private List<CmsDoclist> getDoclistBy(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        try {
            return this.cmsDoclistMapper.getByMenuCode(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsDoclistServiceImpl.getDoclistModelById", (Throwable)e);
            return null;
        }
    }

    public CmsDoclist getDoclistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cmsDoclistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsDoclistServiceImpl.getDoclistModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delDoclistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsDoclistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsDoclistServiceImpl.delDoclistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsDoclistServiceImpl.delDoclistModelByCode.num");
        }
    }

    private void deleteDoclistModel(Integer doclistId) throws ApiException {
        if (null == doclistId) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsDoclistMapper.deleteByPrimaryKey(doclistId);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsDoclistServiceImpl.deleteDoclistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsDoclistServiceImpl.deleteDoclistModel.num");
        }
    }

    private void updateDoclistModel(CmsDoclist cmsDoclist) throws ApiException {
        if (null == cmsDoclist) {
            return;
        }
        try {
            this.cmsDoclistMapper.updateByPrimaryKeySelective(cmsDoclist);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsDoclistServiceImpl.updateDoclistModel.ex", (Throwable)e);
        }
    }

    private void updateStateDoclistModel(Integer doclistId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == doclistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("doclistId", doclistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cmsDoclistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsDoclistServiceImpl.updateStateDoclistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsDoclistServiceImpl.updateStateDoclistModel.null");
        }
    }

    private CmsDoclist makeDoclist(CmsDoclistDomainBean cmsDoclistDomainBean, CmsDoclist cmsDoclist) {
        if (null == cmsDoclistDomainBean) {
            return null;
        }
        if (null == cmsDoclist) {
            cmsDoclist = new CmsDoclist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmsDoclist, (Object)cmsDoclistDomainBean);
            return cmsDoclist;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsDoclistServiceImpl.makeDoclist", (Throwable)e);
            return null;
        }
    }

    private List<CmsDoclist> queryDoclistModelPage(Map<String, Object> parammap) {
        try {
            return this.cmsDoclistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsDoclistServiceImpl.queryDoclistModel", (Throwable)e);
            return null;
        }
    }

    private int countDoclist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmsDoclistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsDoclistServiceImpl.countDoclist", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveDoclist(CmsDoclistDomainBean cmsDoclistDomainBean) throws ApiException {
        String msg = this.checkDoclist(cmsDoclistDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsDoclistServiceImpl.saveDoclist.checkDoclist", msg);
        }
        CmsDoclist cmsDoclist = this.makeDoclist(cmsDoclistDomainBean, null);
        this.setDoclistDefault(cmsDoclist);
        this.saveDoclistModel(cmsDoclist);
    }

    @Override
    public void updateDoclistState(Integer doclistId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateDoclistModel(doclistId, dataState, oldDataState);
        CmsDoclist cmsDoclist = this.getDoclistModelById(doclistId);
        this.updateReleaseHtml(cmsDoclist);
    }

    @Override
    public void updateDoclist(CmsDoclistDomainBean cmsDoclistDomainBean) throws ApiException {
        String msg = this.checkDoclist(cmsDoclistDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsDoclistServiceImpl.updateDoclist.checkDoclist", msg);
        }
        CmsDoclist oldCmsDoclist = this.getDoclistModelById(cmsDoclistDomainBean.getDoclistId());
        if (null == oldCmsDoclist) {
            throw new ApiException("cms.CmsDoclistServiceImpl.updateDoclist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CmsDoclist cmsDoclist = this.makeDoclist(cmsDoclistDomainBean, oldCmsDoclist);
        this.setDoclistUpdataDefault(cmsDoclist);
        this.updateDoclistModel(cmsDoclist);
    }

    @Override
    public CmsDoclist getDoclist(Integer doclistId) {
        return this.getDoclistModelById(doclistId);
    }

    @Override
    public CmsDoclist getDoclistByCode(Map<String, Object> map) {
        return this.getDoclistModelByCode(map);
    }

    @Override
    public void deleteDoclist(Integer doclistId) throws ApiException {
        CmsDoclist cmsDoclist = this.getDoclistModelById(doclistId);
        this.deleteDoclistModel(doclistId);
        if (cmsDoclist != null && cmsDoclist.getDataOpbillstate() == PortalConstants.DATA_OPBILLSTATE_1) {
            this.updateReleaseHtml(cmsDoclist);
        }
    }

    @Override
    public QueryResult<CmsDoclist> queryDoclistPage(Map<String, Object> map) {
        List<CmsDoclist> cmsDoclistList = this.queryDoclistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDoclist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmsDoclistList);
        return queryResult;
    }

    @Override
    public void updateReleaseDoclist(Integer doclistId, String userCode, Integer dataState) throws ApiException {
        CmsDoclist oldCmsDoclist = this.getDoclistModelById(doclistId);
        if (null == oldCmsDoclist) {
            throw new ApiException("cms.CmsDoclistServiceImpl.updateReleaseDoclist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.makeReleaseDoclist(oldCmsDoclist);
        oldCmsDoclist.setDoclistAuditUser(userCode);
        oldCmsDoclist.setGmtModified(this.getSysDate());
        oldCmsDoclist.setDoclistAuditDate(this.getSysDate());
        oldCmsDoclist.setDataState(dataState);
        oldCmsDoclist.setDataOpbillstate(PortalConstants.DATA_OPBILLSTATE_1);
        Date gmtCreate = oldCmsDoclist.getGmtCreate();
        String separator = "/";
        String docPath = DateUtils.getDateString((Date)gmtCreate, (String)"yyyyMM") + separator + DateUtils.getDateString((Date)gmtCreate, (String)"dd") + separator;
        oldCmsDoclist.setDoclistUrl(docPath + oldCmsDoclist.getDoclistCode() + ".html");
        this.updateDoclistModel(oldCmsDoclist);
        this.updateReleaseHtml(oldCmsDoclist);
    }

    private void updateReleaseHtml(CmsDoclist cmsDoclist) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("htmldataMenutype", "TG");
        params.put("htmldataMenu", cmsDoclist.getTginfoMenuCode());
        params.put("htmldataCode", "CmsDoclist");
        params.put("tenantCode", cmsDoclist.getTenantCode());
        params.put("htmldataFilename", cmsDoclist.getDoclistCode() + ".html");
        params.put("htmlcontOpparam", JsonUtil.buildNormalBinder().toJson((Object)cmsDoclist));
        Date gmtCreate = cmsDoclist.getGmtCreate();
        String separator = "/";
        String docPath = separator + DateUtils.getDateString((Date)gmtCreate, (String)"yyyyMM") + separator + DateUtils.getDateString((Date)gmtCreate, (String)"dd") + separator;
        params.put("htmldataFilepath", docPath);
        map.put("htmlRelease", JsonUtil.buildNormalBinder().toJson(params));
        this.internalInvoke("pfs.htmlcont.sendHtmlcontOpData", map);
    }

    private void makeReleaseDoclist(CmsDoclist oldCmsDoclist) {
        oldCmsDoclist.setDoclistTitleNew(oldCmsDoclist.getDoclistTitle());
        oldCmsDoclist.setDoclistTitle1New(oldCmsDoclist.getDoclistTitle1());
        oldCmsDoclist.setDoclistTitle2New(oldCmsDoclist.getDoclistTitle2());
        oldCmsDoclist.setDoclistTitle3New(oldCmsDoclist.getDoclistTitle3());
        oldCmsDoclist.setDoclistTitle4New(oldCmsDoclist.getDoclistTitle4());
        oldCmsDoclist.setDoclistDateNew(oldCmsDoclist.getDoclistDate());
        oldCmsDoclist.setDoclistDate1New(oldCmsDoclist.getDoclistDate1());
        oldCmsDoclist.setDoclistDate2New(oldCmsDoclist.getDoclistDate2());
        oldCmsDoclist.setDoclistDate3New(oldCmsDoclist.getDoclistDate3());
        oldCmsDoclist.setDoclistDate4New(oldCmsDoclist.getDoclistDate4());
        oldCmsDoclist.setDoclistSubsidiarymenuNew(oldCmsDoclist.getDoclistSubsidiarymenu());
        oldCmsDoclist.setDoclistContentNew(oldCmsDoclist.getDoclistContent());
        oldCmsDoclist.setDoclistInfoconNew(oldCmsDoclist.getDoclistInfocon());
        oldCmsDoclist.setDoclistUrl(oldCmsDoclist.getDoclistOldurl());
        oldCmsDoclist.setDoclistInfopicNew(oldCmsDoclist.getDoclistInfopic());
        oldCmsDoclist.setDoclistInfopic1New(oldCmsDoclist.getDoclistInfopic1());
        oldCmsDoclist.setDoclistInfopic2New(oldCmsDoclist.getDoclistInfopic2());
        oldCmsDoclist.setDoclistInfopic3New(oldCmsDoclist.getDoclistInfopic3());
        oldCmsDoclist.setDoclistInfopic4New(oldCmsDoclist.getDoclistInfopic4());
        oldCmsDoclist.setDoclistInfopicpatheNew(oldCmsDoclist.getDoclistInfopicpathe());
        oldCmsDoclist.setDoclistInfopicpathe1New(oldCmsDoclist.getDoclistInfopicpathe1());
        oldCmsDoclist.setDoclistInfopicpathe2New(oldCmsDoclist.getDoclistInfopicpathe2());
        oldCmsDoclist.setDoclistInfopicpathe3New(oldCmsDoclist.getDoclistInfopicpathe3());
        oldCmsDoclist.setDoclistInfopicpathe4New(oldCmsDoclist.getDoclistInfopicpathe4());
    }

    @Override
    public List<CmsDoclist> getDoclistbyMenuCode(Map<String, Object> map) {
        if (null == map) {
            throw new ApiException("cms.CmsDoclistServiceImpl.getDoclist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        return this.getDoclistBy(map);
    }

    @Override
    public CmsDoclist getPreDoclist(Integer doclistId, String tenantCode) {
        if (doclistId == null) {
            return null;
        }
        return this.getPreDoclistByID(doclistId, tenantCode);
    }

    @Override
    public CmsDoclist getnextDoclist(Integer doclistId, String tenantCode) {
        if (doclistId == null) {
            return null;
        }
        return this.getNextDoclistByID(doclistId, tenantCode);
    }

    private CmsDoclist getPreDoclistByID(Integer doclistId, String tenantCode) {
        try {
            return this.cmsDoclistMapper.getPreDoclist(doclistId, tenantCode);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsDoclistServiceImpl.getDoclistMaxCode", (Throwable)e);
            return null;
        }
    }

    private CmsDoclist getNextDoclistByID(Integer doclistId, String tenantCode) {
        try {
            return this.cmsDoclistMapper.getNextDoclist(doclistId, tenantCode);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsDoclistServiceImpl.getDoclistMaxCode", (Throwable)e);
            return null;
        }
    }

    @Override
    public void updateReleaseDoclistByMenuCode(String menuCode, String tenantCode) throws ApiException {
        List<CmsDoclist> doclistList;
        if (StringUtil.isBlank((String)menuCode) || StringUtil.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("menuCode", menuCode);
        map.put("tenantCode", tenantCode);
        map.put("dataOpbillstate", PortalConstants.DATA_OPBILLSTATE_1);
        String falgValue = DisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-cms-docQueryTime"));
        Date nowDate = this.getSysDate();
        if (StringUtils.isNotBlank((String)falgValue)) {
            int days = Integer.parseInt(falgValue);
            String lastDate = DateUtils.getAfterDate((Date)nowDate, (int)(-days), (String)"yyyy-MM-dd HH:mm:ss");
            map.put("startDate", lastDate);
        }
        if ((doclistList = this.queryDoclistModelPage(map)) == null || doclistList.isEmpty()) {
            return;
        }
        for (CmsDoclist cmsDoclist : doclistList) {
            this.updateReleaseHtml(cmsDoclist);
        }
    }

    @Override
    public List<CmsDoclist> getDoclistbyTginfoMenuCode(Map<String, Object> map) {
        String tginfoMenuCode = map.get("tginfoMenuCode").toString();
        List<CmsDoclist> cmsDoclists = this.cmsDoclistMapper.query(map);
        HashMap<String, Object> menuMap = new HashMap<String, Object>();
        menuMap.put("tginfoMenuPCode", tginfoMenuCode);
        QueryResult<CmsTginfoRmenu> cmsTginfoRmenuQueryResult = this.cmsTginfoMenuService.queryTginfoRmenuPage(menuMap);
        List list = cmsTginfoRmenuQueryResult.getList();
        if (null != list && list.size() > 0) {
            for (CmsTginfoRmenu cmsTginfoRmenu : list) {
                HashMap<String, Object> tgmenuMap = new HashMap<String, Object>();
                tgmenuMap.put("tginfoMenuCode", cmsTginfoRmenu.getTginfoRmenuCode());
                List<CmsDoclist> doclists = this.cmsDoclistMapper.query(tgmenuMap);
                cmsDoclists.addAll(doclists);
            }
        }
        return cmsDoclists;
    }
}

