/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.portal.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.portal.dao.CmsPlayPlanMapper;
import com.yqbsoft.laser.service.portal.domain.CmsPlayPlanDomain;
import com.yqbsoft.laser.service.portal.model.CmsPlayPlan;
import com.yqbsoft.laser.service.portal.service.CmsPlayPlanService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CmsPlayPlanServiceImpl
extends BaseServiceImpl
implements CmsPlayPlanService {
    public static final String SYS_CODE = "cms.CmsPlayPlanServiceImpl";
    private CmsPlayPlanMapper cmsPlayPlanMapper;

    public void setCmsPlayPlanMapper(CmsPlayPlanMapper cmsPlayPlanMapper) {
        this.cmsPlayPlanMapper = cmsPlayPlanMapper;
    }

    private Date getSysDate() {
        try {
            return this.cmsPlayPlanMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsPlayPlanServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPlayPlan(CmsPlayPlanDomain cmsPlayPlanDomain) {
        if (null == cmsPlayPlanDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setPlayPlanDefault(CmsPlayPlan cmsPlayPlan) {
        if (null == cmsPlayPlan) {
            return;
        }
        if (null == cmsPlayPlan.getDataState()) {
            cmsPlayPlan.setDataState(0);
        }
        if (null == cmsPlayPlan.getGmtCreate()) {
            cmsPlayPlan.setGmtCreate(this.getSysDate());
        }
        cmsPlayPlan.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cmsPlayPlan.getPlayPlanCode())) {
            cmsPlayPlan.setPlayPlanCode(this.createUUIDString());
        }
    }

    private int getPlayPlanMaxCode() {
        int code = 0;
        try {
            return this.cmsPlayPlanMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsPlayPlanServiceImpl.getPlayPlanMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPlayPlanUpdataDefault(CmsPlayPlan cmsPlayPlan) {
        if (null == cmsPlayPlan) {
            return;
        }
        cmsPlayPlan.setGmtModified(this.getSysDate());
    }

    private void savePlayPlanModel(CmsPlayPlan cmsPlayPlan) throws ApiException {
        if (null == cmsPlayPlan) {
            return;
        }
        try {
            this.cmsPlayPlanMapper.insert(cmsPlayPlan);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsPlayPlanServiceImpl.savePlayPlanModel.ex", (Throwable)e);
        }
    }

    private CmsPlayPlan getPlayPlanModelById(Integer playPlanId) {
        if (null == playPlanId) {
            return null;
        }
        try {
            return this.cmsPlayPlanMapper.selectByPrimaryKey(playPlanId);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsPlayPlanServiceImpl.getPlayPlanModelById", (Throwable)e);
            return null;
        }
    }

    public CmsPlayPlan getPlayPlanModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cmsPlayPlanMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsPlayPlanServiceImpl.getPlayPlanModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delPlayPlanModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsPlayPlanMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsPlayPlanServiceImpl.delPlayPlanModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsPlayPlanServiceImpl.delPlayPlanModelByCode.num");
        }
    }

    private void deletePlayPlanModel(Integer playPlanId) throws ApiException {
        if (null == playPlanId) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsPlayPlanMapper.deleteByPrimaryKey(playPlanId);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsPlayPlanServiceImpl.deletePlayPlanModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsPlayPlanServiceImpl.deletePlayPlanModel.num");
        }
    }

    private void updatePlayPlanModel(CmsPlayPlan cmsPlayPlan) throws ApiException {
        if (null == cmsPlayPlan) {
            return;
        }
        try {
            this.cmsPlayPlanMapper.updateByPrimaryKeySelective(cmsPlayPlan);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsPlayPlanServiceImpl.updatePlayPlanModel.ex", (Throwable)e);
        }
    }

    private void updateStatePlayPlanModel(Integer playPlanId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == playPlanId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("playPlanId", playPlanId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cmsPlayPlanMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsPlayPlanServiceImpl.updateStatePlayPlanModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsPlayPlanServiceImpl.updateStatePlayPlanModel.null");
        }
    }

    private CmsPlayPlan makePlayPlan(CmsPlayPlanDomain cmsPlayPlanDomain, CmsPlayPlan cmsPlayPlan) {
        if (null == cmsPlayPlanDomain) {
            return null;
        }
        if (null == cmsPlayPlan) {
            cmsPlayPlan = new CmsPlayPlan();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmsPlayPlan, (Object)cmsPlayPlanDomain);
            return cmsPlayPlan;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsPlayPlanServiceImpl.makePlayPlan", (Throwable)e);
            return null;
        }
    }

    private List<CmsPlayPlan> queryPlayPlanModelPage(Map<String, Object> parammap) {
        try {
            return this.cmsPlayPlanMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsPlayPlanServiceImpl.queryPlayPlanModel", (Throwable)e);
            return null;
        }
    }

    private int countPlayPlan(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmsPlayPlanMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsPlayPlanServiceImpl.countPlayPlan", (Throwable)e);
        }
        return i;
    }

    @Override
    public String savePlayPlan(CmsPlayPlanDomain cmsPlayPlanDomain) throws ApiException {
        String msg = this.checkPlayPlan(cmsPlayPlanDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsPlayPlanServiceImpl.savePlayPlan.checkPlayPlan", msg);
        }
        CmsPlayPlan cmsPlayPlan = this.makePlayPlan(cmsPlayPlanDomain, null);
        this.setPlayPlanDefault(cmsPlayPlan);
        this.savePlayPlanModel(cmsPlayPlan);
        return cmsPlayPlan.getPlayPlanCode();
    }

    @Override
    public void updatePlayPlanState(Integer playPlanId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePlayPlanModel(playPlanId, dataState, oldDataState);
    }

    @Override
    public void updatePlayPlan(CmsPlayPlanDomain cmsPlayPlanDomain) throws ApiException {
        String msg = this.checkPlayPlan(cmsPlayPlanDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsPlayPlanServiceImpl.updatePlayPlan.checkPlayPlan", msg);
        }
        CmsPlayPlan oldCmsPlayPlan = this.getPlayPlanModelById(cmsPlayPlanDomain.getPlayPlanId());
        if (null == oldCmsPlayPlan) {
            throw new ApiException("cms.CmsPlayPlanServiceImpl.updatePlayPlan.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CmsPlayPlan cmsPlayPlan = this.makePlayPlan(cmsPlayPlanDomain, oldCmsPlayPlan);
        this.setPlayPlanUpdataDefault(cmsPlayPlan);
        this.updatePlayPlanModel(cmsPlayPlan);
    }

    @Override
    public CmsPlayPlan getPlayPlan(Integer playPlanId) {
        return this.getPlayPlanModelById(playPlanId);
    }

    @Override
    public void deletePlayPlan(Integer playPlanId) throws ApiException {
        this.deletePlayPlanModel(playPlanId);
    }

    @Override
    public QueryResult<CmsPlayPlan> queryPlayPlanPage(Map<String, Object> map) {
        List<CmsPlayPlan> cmsPlayPlanList = this.queryPlayPlanModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPlayPlan(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmsPlayPlanList);
        return queryResult;
    }

    @Override
    public CmsPlayPlan getPlayPlanByCode(Map<String, Object> map) {
        return this.getPlayPlanModelByCode(map);
    }

    @Override
    public void delPlayPlanByCode(Map<String, Object> map) throws ApiException {
        this.delPlayPlanModelByCode(map);
    }

    @Override
    public List<CmsPlayPlan> queryPlayPlanList(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        List<CmsPlayPlan> cmsPlayPlanList = this.queryPlayPlanModelPage(map);
        return cmsPlayPlanList;
    }
}

