/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.portal.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.portal.dao.CmsContlistMapper;
import com.yqbsoft.laser.service.portal.domain.CmsContlistDomain;
import com.yqbsoft.laser.service.portal.domain.CmsContlistReDomain;
import com.yqbsoft.laser.service.portal.model.CmsContlist;
import com.yqbsoft.laser.service.portal.service.CmsContlistService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CmsContlistServiceImpl
extends BaseServiceImpl
implements CmsContlistService {
    private static final String SYS_CODE = "cms.CmsContlistServiceImpl";
    private CmsContlistMapper cmsContlistMapper;

    public void setCmsContlistMapper(CmsContlistMapper cmsContlistMapper) {
        this.cmsContlistMapper = cmsContlistMapper;
    }

    private Date getSysDate() {
        try {
            return this.cmsContlistMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsContlistServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkContlist(CmsContlistDomain cmsContlistDomain) {
        if (null == cmsContlistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)cmsContlistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setContlistDefault(CmsContlist cmsContlist) {
        if (null == cmsContlist) {
            return;
        }
        if (null == cmsContlist.getDataState()) {
            cmsContlist.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == cmsContlist.getGmtCreate()) {
            cmsContlist.setGmtCreate(date);
        }
        cmsContlist.setGmtModified(date);
        if (StringUtils.isBlank((String)cmsContlist.getContlistCode())) {
            cmsContlist.setContlistCode(this.getNo(null, "CmsContlist", "cmsContlist", cmsContlist.getTenantCode()));
        }
    }

    private int getContlistMaxCode() {
        int code = 0;
        try {
            return this.cmsContlistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cms.CmsContlistServiceImpl.getContlistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContlistUpdataDefault(CmsContlist cmsContlist) {
        if (null == cmsContlist) {
            return;
        }
        cmsContlist.setGmtModified(this.getSysDate());
    }

    private void saveContlistModel(CmsContlist cmsContlist) throws ApiException {
        if (null == cmsContlist) {
            return;
        }
        try {
            this.cmsContlistMapper.insert(cmsContlist);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsContlistServiceImpl.saveContlistModel.ex", (Throwable)e);
        }
    }

    private void saveContlistBatchModel(List<CmsContlist> cmsContlistList) throws ApiException {
        if (null == cmsContlistList || cmsContlistList.isEmpty()) {
            return;
        }
        try {
            this.cmsContlistMapper.insertBatch(cmsContlistList);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsContlistServiceImpl.saveContlistBatchModel.ex", (Throwable)e);
        }
    }

    private CmsContlist getContlistModelById(Integer contlistId) {
        if (null == contlistId) {
            return null;
        }
        try {
            return this.cmsContlistMapper.selectByPrimaryKey(contlistId);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsContlistServiceImpl.getContlistModelById", (Throwable)e);
            return null;
        }
    }

    private CmsContlist getContlistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cmsContlistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsContlistServiceImpl.getContlistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delContlistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsContlistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsContlistServiceImpl.delContlistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsContlistServiceImpl.delContlistModelByCode.num");
        }
    }

    private void deleteContlistModel(Integer contlistId) throws ApiException {
        if (null == contlistId) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsContlistMapper.deleteByPrimaryKey(contlistId);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsContlistServiceImpl.deleteContlistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsContlistServiceImpl.deleteContlistModel.num");
        }
    }

    private void updateContlistModel(CmsContlist cmsContlist) throws ApiException {
        if (null == cmsContlist) {
            return;
        }
        int i = 0;
        try {
            i = this.cmsContlistMapper.updateByPrimaryKey(cmsContlist);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsContlistServiceImpl.updateContlistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cms.CmsContlistServiceImpl.updateContlistModel.num");
        }
    }

    private void updateStateContlistModel(Integer contlistId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == contlistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contlistId", contlistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.cmsContlistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsContlistServiceImpl.updateStateContlistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsContlistServiceImpl.updateStateContlistModel.null");
        }
    }

    private void updateStateContlistModelByCode(String tenantCode, String contlistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)contlistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contlistCode", contlistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.cmsContlistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cms.CmsContlistServiceImpl.updateStateContlistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cms.CmsContlistServiceImpl.updateStateContlistModelByCode.null");
        }
    }

    private CmsContlist makeContlist(CmsContlistDomain cmsContlistDomain, CmsContlist cmsContlist) {
        if (null == cmsContlistDomain) {
            return null;
        }
        if (null == cmsContlist) {
            cmsContlist = new CmsContlist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmsContlist, (Object)cmsContlistDomain);
            return cmsContlist;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsContlistServiceImpl.makeContlist", (Throwable)e);
            return null;
        }
    }

    private CmsContlistReDomain makeCmsContlistReDomain(CmsContlist cmsContlist) {
        if (null == cmsContlist) {
            return null;
        }
        CmsContlistReDomain cmsContlistReDomain = new CmsContlistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cmsContlistReDomain, (Object)cmsContlist);
            return cmsContlistReDomain;
        }
        catch (Exception e) {
            this.logger.error("cms.CmsContlistServiceImpl.makeCmsContlistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CmsContlist> queryContlistModelPage(Map<String, Object> parammap) {
        try {
            return this.cmsContlistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsContlistServiceImpl.queryContlistModel", (Throwable)e);
            return null;
        }
    }

    private int countContlist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmsContlistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cms.CmsContlistServiceImpl.countContlist", (Throwable)e);
        }
        return i;
    }

    private CmsContlist createCmsContlist(CmsContlistDomain cmsContlistDomain) {
        String msg = this.checkContlist(cmsContlistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsContlistServiceImpl.saveContlist.checkContlist", msg);
        }
        CmsContlist cmsContlist = this.makeContlist(cmsContlistDomain, null);
        this.setContlistDefault(cmsContlist);
        return cmsContlist;
    }

    @Override
    public String saveContlist(CmsContlistDomain cmsContlistDomain) throws ApiException {
        CmsContlist cmsContlist = this.createCmsContlist(cmsContlistDomain);
        this.saveContlistModel(cmsContlist);
        return cmsContlist.getContlistCode();
    }

    @Override
    public String saveContlistBatch(List<CmsContlistDomain> cmsContlistDomainList) throws ApiException {
        if (null == cmsContlistDomainList || cmsContlistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CmsContlist> cmsContlistList = new ArrayList<CmsContlist>();
        String code = "";
        for (CmsContlistDomain cmsContlistDomain : cmsContlistDomainList) {
            CmsContlist cmsContlist = this.createCmsContlist(cmsContlistDomain);
            code = cmsContlist.getContlistCode();
            cmsContlistList.add(cmsContlist);
        }
        this.saveContlistBatchModel(cmsContlistList);
        return code;
    }

    @Override
    public void updateContlistState(Integer contlistId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == contlistId) {
            return;
        }
        this.updateStateContlistModel(contlistId, dataState, oldDataState, map);
    }

    @Override
    public void updateContlistStateByCode(String tenantCode, String contlistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)contlistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateContlistModelByCode(tenantCode, contlistCode, dataState, oldDataState, map);
    }

    @Override
    public void updateContlist(CmsContlistDomain cmsContlistDomain) throws ApiException {
        String msg = this.checkContlist(cmsContlistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cms.CmsContlistServiceImpl.updateContlist.checkContlist", msg);
        }
        CmsContlist oldCmsContlist = this.getContlistModelById(cmsContlistDomain.getContlistId());
        if (null == oldCmsContlist) {
            throw new ApiException("cms.CmsContlistServiceImpl.updateContlist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CmsContlist cmsContlist = this.makeContlist(cmsContlistDomain, oldCmsContlist);
        this.setContlistUpdataDefault(cmsContlist);
        this.updateContlistModel(cmsContlist);
    }

    @Override
    public CmsContlist getContlist(Integer contlistId) {
        if (null == contlistId) {
            return null;
        }
        return this.getContlistModelById(contlistId);
    }

    @Override
    public void deleteContlist(Integer contlistId) throws ApiException {
        if (null == contlistId) {
            return;
        }
        this.deleteContlistModel(contlistId);
    }

    @Override
    public QueryResult<CmsContlist> queryContlistPage(Map<String, Object> map) {
        List<CmsContlist> cmsContlistList = this.queryContlistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContlist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmsContlistList);
        return queryResult;
    }

    @Override
    public CmsContlist getContlistByCode(String tenantCode, String contlistCode) throws ApiException {
        if (StringUtils.isBlank((String)contlistCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contlistCode", contlistCode);
        return this.getContlistModelByCode(map);
    }

    @Override
    public void deleteContlistByCode(String tenantCode, String contlistCode) throws ApiException {
        if (StringUtils.isBlank((String)contlistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contlistCode", contlistCode);
        this.delContlistModelByCode(map);
    }
}

