/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.salesplan.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.salesplan.domain.SpScontractDomain;
import com.yqbsoft.laser.service.salesplan.engine.SendPutThread;
import com.yqbsoft.laser.service.salesplan.model.SpChannelsend;
import com.yqbsoft.laser.service.salesplan.service.SpScontractBaseService;
import com.yqbsoft.laser.service.salesplan.service.SpScontractService;
import com.yqbsoft.laser.service.salesplan.service.impl.SpChannelsendServiceImpl;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import java.util.List;
import java.util.Map;

public class SpScontractBaseServiceImpl
extends BaseServiceImpl
implements SpScontractBaseService {
    private static final String SYS_CODE = "sp.SpScontractBaseServiceImpl";
    SpScontractService spScontractService;

    public SpScontractService getSpScontractService() {
        return this.spScontractService;
    }

    public void setSpScontractService(SpScontractService spScontractService) {
        this.spScontractService = spScontractService;
    }

    @Override
    public String sendSaveScontract(SpScontractDomain spScontractDomain) throws ApiException {
        if (null == spScontractDomain) {
            return null;
        }
        List<SpChannelsend> cpRechargeSendList = this.spScontractService.saveScontract(spScontractDomain);
        if (!ListUtil.isNotEmpty(cpRechargeSendList)) {
            return null;
        }
        SpChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(SpChannelsendServiceImpl.getSendService(), cpRechargeSendList));
        return cpRechargeSendList.get(0).getChannelsendOpcode();
    }

    @Override
    public String sendSaveScontractBatch(List<SpScontractDomain> spScontractDomainList) throws ApiException {
        if (ListUtil.isEmpty(spScontractDomainList)) {
            return null;
        }
        List<SpChannelsend> cpRechargeSendList = this.spScontractService.saveScontractBatch(spScontractDomainList);
        if (!ListUtil.isNotEmpty(cpRechargeSendList)) {
            return null;
        }
        SpChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(SpChannelsendServiceImpl.getSendService(), cpRechargeSendList));
        return cpRechargeSendList.get(0).getChannelsendOpcode();
    }

    @Override
    public void sendUpdateScontractState(Integer scontractId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        List<SpChannelsend> cpRechargeSendList = this.spScontractService.updateScontractState(scontractId, dataState, oldDataState, map);
        if (ListUtil.isNotEmpty(cpRechargeSendList)) {
            SpChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(SpChannelsendServiceImpl.getSendService(), cpRechargeSendList));
        }
    }

    @Override
    public void sendUpdateScontractStateByCode(String tenantCode, String scontractCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        List<SpChannelsend> cpRechargeSendList = this.spScontractService.updateScontractStateByCode(tenantCode, scontractCode, dataState, oldDataState, map);
        if (ListUtil.isNotEmpty(cpRechargeSendList)) {
            SpChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(SpChannelsendServiceImpl.getSendService(), cpRechargeSendList));
        }
    }

    @Override
    public void sendUpdateScontract(SpScontractDomain spScontractDomain) throws ApiException {
        List<SpChannelsend> cpRechargeSendList = this.spScontractService.updateScontract(spScontractDomain);
        if (ListUtil.isNotEmpty(cpRechargeSendList)) {
            SpChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(SpChannelsendServiceImpl.getSendService(), cpRechargeSendList));
        }
    }

    @Override
    public void sendUpdateScontractKey(SpScontractDomain spScontractDomain) throws ApiException {
        List<SpChannelsend> cpRechargeSendList = this.spScontractService.updateScontractKey(spScontractDomain);
        if (ListUtil.isNotEmpty(cpRechargeSendList)) {
            SpChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(SpChannelsendServiceImpl.getSendService(), cpRechargeSendList));
        }
    }

    @Override
    public void sendDeleteScontract(Integer scontractId) throws ApiException {
        List<SpChannelsend> cpRechargeSendList = this.spScontractService.deleteScontract(scontractId);
        if (ListUtil.isNotEmpty(cpRechargeSendList)) {
            SpChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(SpChannelsendServiceImpl.getSendService(), cpRechargeSendList));
        }
    }

    @Override
    public void sendSeleteScontractByCode(String tenantCode, String scontractCode) throws ApiException {
        List<SpChannelsend> cpRechargeSendList = this.spScontractService.deleteScontractByCode(tenantCode, scontractCode);
        if (ListUtil.isNotEmpty(cpRechargeSendList)) {
            SpChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(SpChannelsendServiceImpl.getSendService(), cpRechargeSendList));
        }
    }
}

