/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.userpointsmanager.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.userpointsmanager.UserPointsManagerConstants;
import com.yqbsoft.laser.service.userpointsmanager.dao.UpmPointsRuleconfMapper;
import com.yqbsoft.laser.service.userpointsmanager.domain.UpmPointsRuleconfDomain;
import com.yqbsoft.laser.service.userpointsmanager.domain.UpmPointsRuleconfReDomain;
import com.yqbsoft.laser.service.userpointsmanager.model.UpmPointsRuleconf;
import com.yqbsoft.laser.service.userpointsmanager.service.UpmPointsRuleconfService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class UpmPointsRuleconfServiceImpl
extends BaseServiceImpl
implements UpmPointsRuleconfService {
    private static final String SYS_CODE = "upm.UpmPointsRuleconfServiceImpl";
    private UpmPointsRuleconfMapper upmPointsRuleconfMapper;
    private String cachekey = "UpmPointsRuleConf-api";

    public void setUpmPointsRuleconfMapper(UpmPointsRuleconfMapper upmPointsRuleconfMapper) {
        this.upmPointsRuleconfMapper = upmPointsRuleconfMapper;
    }

    private Date getSysDate() {
        try {
            return this.upmPointsRuleconfMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsRuleconfServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPointsRuleconf(UpmPointsRuleconfDomain upmPointsRuleconfDomain) {
        if (null == upmPointsRuleconfDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)upmPointsRuleconfDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPointsRuleconfDefault(UpmPointsRuleconf upmPointsRuleconf) {
        if (null == upmPointsRuleconf) {
            return;
        }
        if (null == upmPointsRuleconf.getDataState()) {
            upmPointsRuleconf.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == upmPointsRuleconf.getGmtCreate()) {
            upmPointsRuleconf.setGmtCreate(date);
        }
        upmPointsRuleconf.setGmtModified(date);
        if (StringUtils.isBlank((String)upmPointsRuleconf.getPointsRuleconfCode())) {
            upmPointsRuleconf.setPointsRuleconfCode(this.getNo(null, "UpmPointsRuleconf", "upmPointsRuleconf", upmPointsRuleconf.getTenantCode()));
        }
    }

    private int getPointsRuleconfMaxCode() {
        int code = 0;
        try {
            return this.upmPointsRuleconfMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsRuleconfServiceImpl.getPointsRuleconfMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPointsRuleconfUpdataDefault(UpmPointsRuleconf upmPointsRuleconf) {
        if (null == upmPointsRuleconf) {
            return;
        }
        upmPointsRuleconf.setGmtModified(this.getSysDate());
    }

    private void savePointsRuleconfModel(UpmPointsRuleconf upmPointsRuleconf) throws ApiException {
        if (null == upmPointsRuleconf) {
            return;
        }
        try {
            this.upmPointsRuleconfMapper.insert(upmPointsRuleconf);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsRuleconfServiceImpl.savePointsRuleconfModel.ex", (Throwable)e);
        }
    }

    private void savePointsRuleconfBatchModel(List<UpmPointsRuleconf> upmPointsRuleconfList) throws ApiException {
        if (null == upmPointsRuleconfList || upmPointsRuleconfList.isEmpty()) {
            return;
        }
        try {
            this.upmPointsRuleconfMapper.insertBatch(upmPointsRuleconfList);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsRuleconfServiceImpl.savePointsRuleconfBatchModel.ex", (Throwable)e);
        }
    }

    private UpmPointsRuleconf getPointsRuleconfModelById(Integer pointsRuleconfId) {
        if (null == pointsRuleconfId) {
            return null;
        }
        try {
            return this.upmPointsRuleconfMapper.selectByPrimaryKey(pointsRuleconfId);
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsRuleconfServiceImpl.getPointsRuleconfModelById", (Throwable)e);
            return null;
        }
    }

    private UpmPointsRuleconf getPointsRuleconfModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.upmPointsRuleconfMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsRuleconfServiceImpl.getPointsRuleconfModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPointsRuleconfModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.upmPointsRuleconfMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsRuleconfServiceImpl.delPointsRuleconfModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("upm.UpmPointsRuleconfServiceImpl.delPointsRuleconfModelByCode.num");
        }
    }

    private void deletePointsRuleconfModel(Integer pointsRuleconfId) throws ApiException {
        if (null == pointsRuleconfId) {
            return;
        }
        int i = 0;
        try {
            i = this.upmPointsRuleconfMapper.deleteByPrimaryKey(pointsRuleconfId);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsRuleconfServiceImpl.deletePointsRuleconfModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("upm.UpmPointsRuleconfServiceImpl.deletePointsRuleconfModel.num");
        }
    }

    private void updatePointsRuleconfModel(UpmPointsRuleconf upmPointsRuleconf) throws ApiException {
        if (null == upmPointsRuleconf) {
            return;
        }
        int i = 0;
        try {
            i = this.upmPointsRuleconfMapper.updateByPrimaryKey(upmPointsRuleconf);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsRuleconfServiceImpl.updatePointsRuleconfModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("upm.UpmPointsRuleconfServiceImpl.updatePointsRuleconfModel.num");
        }
    }

    private void updateStatePointsRuleconfModel(Integer pointsRuleconfId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == pointsRuleconfId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pointsRuleconfId", pointsRuleconfId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.upmPointsRuleconfMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsRuleconfServiceImpl.updateStatePointsRuleconfModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("upm.UpmPointsRuleconfServiceImpl.updateStatePointsRuleconfModel.null");
        }
    }

    private void updateStatePointsRuleconfModelByCode(String tenantCode, String pointsRuleconfCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)pointsRuleconfCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsRuleconfCode", pointsRuleconfCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.upmPointsRuleconfMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("upm.UpmPointsRuleconfServiceImpl.updateStatePointsRuleconfModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("upm.UpmPointsRuleconfServiceImpl.updateStatePointsRuleconfModelByCode.null");
        }
    }

    private UpmPointsRuleconf makePointsRuleconf(UpmPointsRuleconfDomain upmPointsRuleconfDomain, UpmPointsRuleconf upmPointsRuleconf) {
        if (null == upmPointsRuleconfDomain) {
            return null;
        }
        if (null == upmPointsRuleconf) {
            upmPointsRuleconf = new UpmPointsRuleconf();
        }
        try {
            BeanUtils.copyAllPropertys((Object)upmPointsRuleconf, (Object)upmPointsRuleconfDomain);
            return upmPointsRuleconf;
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsRuleconfServiceImpl.makePointsRuleconf", (Throwable)e);
            return null;
        }
    }

    private UpmPointsRuleconfReDomain makeUpmPointsRuleconfReDomain(UpmPointsRuleconf upmPointsRuleconf) {
        if (null == upmPointsRuleconf) {
            return null;
        }
        UpmPointsRuleconfReDomain upmPointsRuleconfReDomain = new UpmPointsRuleconfReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)upmPointsRuleconfReDomain, (Object)upmPointsRuleconf);
            return upmPointsRuleconfReDomain;
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsRuleconfServiceImpl.makeUpmPointsRuleconfReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UpmPointsRuleconf> queryPointsRuleconfModelPage(Map<String, Object> parammap) {
        try {
            return this.upmPointsRuleconfMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsRuleconfServiceImpl.queryPointsRuleconfModel", (Throwable)e);
            return null;
        }
    }

    private int countPointsRuleconf(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.upmPointsRuleconfMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("upm.UpmPointsRuleconfServiceImpl.countPointsRuleconf", (Throwable)e);
        }
        return i;
    }

    private UpmPointsRuleconf createUpmPointsRuleconf(UpmPointsRuleconfDomain upmPointsRuleconfDomain) {
        String msg = this.checkPointsRuleconf(upmPointsRuleconfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("upm.UpmPointsRuleconfServiceImpl.savePointsRuleconf.checkPointsRuleconf", msg);
        }
        UpmPointsRuleconf upmPointsRuleconf = this.makePointsRuleconf(upmPointsRuleconfDomain, null);
        this.setPointsRuleconfDefault(upmPointsRuleconf);
        return upmPointsRuleconf;
    }

    @Override
    public String savePointsRuleconf(UpmPointsRuleconfDomain upmPointsRuleconfDomain) throws ApiException {
        UpmPointsRuleconf upmPointsRuleconf = this.createUpmPointsRuleconf(upmPointsRuleconfDomain);
        this.savePointsRuleconfModel(upmPointsRuleconf);
        this.queryPointsRuleConfCache();
        return upmPointsRuleconf.getPointsRuleconfCode();
    }

    @Override
    public String savePointsRuleconfBatch(List<UpmPointsRuleconfDomain> upmPointsRuleconfDomainList) throws ApiException {
        if (null == upmPointsRuleconfDomainList || upmPointsRuleconfDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UpmPointsRuleconf> upmPointsRuleconfList = new ArrayList<UpmPointsRuleconf>();
        String code = "";
        for (UpmPointsRuleconfDomain upmPointsRuleconfDomain : upmPointsRuleconfDomainList) {
            UpmPointsRuleconf upmPointsRuleconf = this.createUpmPointsRuleconf(upmPointsRuleconfDomain);
            code = upmPointsRuleconf.getPointsRuleconfCode();
            upmPointsRuleconfList.add(upmPointsRuleconf);
        }
        this.savePointsRuleconfBatchModel(upmPointsRuleconfList);
        this.queryPointsRuleConfCache();
        return code;
    }

    @Override
    public void updatePointsRuleconfState(Integer pointsRuleconfId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == pointsRuleconfId) {
            return;
        }
        this.updateStatePointsRuleconfModel(pointsRuleconfId, dataState, oldDataState, map);
        this.queryPointsRuleConfCache();
    }

    @Override
    public void updatePointsRuleconfStateByCode(String tenantCode, String pointsRuleconfCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)pointsRuleconfCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePointsRuleconfModelByCode(tenantCode, pointsRuleconfCode, dataState, oldDataState, map);
        this.queryPointsRuleConfCache();
    }

    @Override
    public void updatePointsRuleconf(UpmPointsRuleconfDomain upmPointsRuleconfDomain) throws ApiException {
        String msg = this.checkPointsRuleconf(upmPointsRuleconfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("upm.UpmPointsRuleconfServiceImpl.updatePointsRuleconf.checkPointsRuleconf", msg);
        }
        UpmPointsRuleconf oldUpmPointsRuleconf = this.getPointsRuleconfModelById(upmPointsRuleconfDomain.getPointsRuleconfId());
        if (null == oldUpmPointsRuleconf) {
            throw new ApiException("upm.UpmPointsRuleconfServiceImpl.updatePointsRuleconf.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UpmPointsRuleconf upmPointsRuleconf = this.makePointsRuleconf(upmPointsRuleconfDomain, oldUpmPointsRuleconf);
        this.setPointsRuleconfUpdataDefault(upmPointsRuleconf);
        this.updatePointsRuleconfModel(upmPointsRuleconf);
        this.queryPointsRuleConfCache();
    }

    @Override
    public UpmPointsRuleconf getPointsRuleconf(Integer pointsRuleconfId) {
        if (null == pointsRuleconfId) {
            return null;
        }
        return this.getPointsRuleconfModelById(pointsRuleconfId);
    }

    @Override
    public void deletePointsRuleconf(Integer pointsRuleconfId) throws ApiException {
        if (null == pointsRuleconfId) {
            return;
        }
        this.deletePointsRuleconfModel(pointsRuleconfId);
        this.queryPointsRuleConfCache();
    }

    @Override
    public QueryResult<UpmPointsRuleconf> queryPointsRuleconfPage(Map<String, Object> map) {
        List<UpmPointsRuleconf> upmPointsRuleconfList = this.queryPointsRuleconfModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        int count = 0;
        if (ListUtil.isNotEmpty(upmPointsRuleconfList)) {
            count = this.countPointsRuleconf(map);
        }
        pageTools.setRecordCount(count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(upmPointsRuleconfList);
        return queryResult;
    }

    @Override
    public UpmPointsRuleconf getPointsRuleconfByCode(String tenantCode, String pointsRuleconfCode) throws ApiException {
        if (StringUtils.isBlank((String)pointsRuleconfCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsRuleconfCode", pointsRuleconfCode);
        return this.getPointsRuleconfModelByCode(map);
    }

    @Override
    public void deletePointsRuleconfByCode(String tenantCode, String pointsRuleconfCode) throws ApiException {
        if (StringUtils.isBlank((String)pointsRuleconfCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pointsRuleconfCode", pointsRuleconfCode);
        this.delPointsRuleconfModelByCode(map);
        this.queryPointsRuleConfCache();
    }

    @Override
    public void queryPointsRuleConfCache() {
        this.logger.info("UpmPointsRuleServiceImpl.queryPointsRuleConfCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", UserPointsManagerConstants.dataState0);
        List<UpmPointsRuleconf> list = this.queryPointsRuleconfModelPage(parammap);
        if (null == list || list.isEmpty()) {
            DisUtil.delVer((String)this.cachekey);
            this.logger.info("UpmPointsRuleServiceImpl.queryPointsRuleConfCache", (Object)"===========del-end==========");
            return;
        }
        Map<String, List<UpmPointsRuleconf>> groupParam = list.stream().collect(Collectors.groupingBy(u -> u.getPointsRuleCode() + "-" + u.getLevelUserqua() + "-" + u.getTenantCode()));
        ConcurrentHashMap map = new ConcurrentHashMap();
        groupParam.forEach((k, v) -> map.put(k, JsonUtil.buildNormalBinder().toJson(v)));
        DisUtil.setMapVer((String)this.cachekey, map);
    }
}

