/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.warehouse.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.warehouse.dao.WhStoreSkusafeMapper;
import com.yqbsoft.laser.service.warehouse.domain.WhStoreSkusafeDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhStoreSkusafeReDomain;
import com.yqbsoft.laser.service.warehouse.model.WhStoreSkusafe;
import com.yqbsoft.laser.service.warehouse.service.WhStoreSkusafeService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WhStoreSkusafeImpl
extends BaseServiceImpl
implements WhStoreSkusafeService {
    private static final String SYS_CODE = "wh.WhStoreSkusafeImpl";
    private WhStoreSkusafeMapper whStoreSkusafeMapper;

    public void setWhStoreSkusafeMapper(WhStoreSkusafeMapper whStoreSkusafeMapper) {
        this.whStoreSkusafeMapper = whStoreSkusafeMapper;
    }

    private Date getSysDate() {
        try {
            return this.whStoreSkusafeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreSkusafeImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkstoreSkusafe(WhStoreSkusafeDomain whStoreSkusafeDomain) {
        if (null == whStoreSkusafeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)whStoreSkusafeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setstoreSkusafeDefault(WhStoreSkusafe whStoreSkusafe) {
        if (null == whStoreSkusafe) {
            return;
        }
        if (null == whStoreSkusafe.getDataState()) {
            whStoreSkusafe.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == whStoreSkusafe.getGmtCreate()) {
            whStoreSkusafe.setGmtCreate(date);
        }
        whStoreSkusafe.setGmtModified(date);
        if (StringUtils.isBlank((String)whStoreSkusafe.getStoreSkusafeCode())) {
            whStoreSkusafe.setStoreSkusafeCode(this.getNo(null, "WhStoreSkusafe", "whStoreSkusafe", whStoreSkusafe.getTenantCode()));
        }
    }

    private int getstoreSkusafeMaxCode() {
        int code = 0;
        try {
            return this.whStoreSkusafeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreSkusafeImpl.getstoreSkusafeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setstoreSkusafeUpdataDefault(WhStoreSkusafe whStoreSkusafe) {
        if (null == whStoreSkusafe) {
            return;
        }
        whStoreSkusafe.setGmtModified(this.getSysDate());
    }

    private void savestoreSkusafeModel(WhStoreSkusafe whStoreSkusafe) throws ApiException {
        if (null == whStoreSkusafe) {
            return;
        }
        try {
            this.whStoreSkusafeMapper.insert(whStoreSkusafe);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreSkusafeImpl.savestoreSkusafeModel.ex", (Throwable)e);
        }
    }

    private void savestoreSkusafeBatchModel(List<WhStoreSkusafe> whStoreSkusafeList) throws ApiException {
        if (null == whStoreSkusafeList || whStoreSkusafeList.isEmpty()) {
            return;
        }
        try {
            this.whStoreSkusafeMapper.insertBatch(whStoreSkusafeList);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreSkusafeImpl.savestoreSkusafeBatchModel.ex", (Throwable)e);
        }
    }

    private WhStoreSkusafe getstoreSkusafeModelById(Integer storeSkusafeId) {
        if (null == storeSkusafeId) {
            return null;
        }
        try {
            return this.whStoreSkusafeMapper.selectByPrimaryKey(storeSkusafeId);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreSkusafeImpl.getstoreSkusafeModelById", (Throwable)e);
            return null;
        }
    }

    private WhStoreSkusafe getstoreSkusafeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.whStoreSkusafeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreSkusafeImpl.getstoreSkusafeModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delstoreSkusafeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.whStoreSkusafeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreSkusafeImpl.delstoreSkusafeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhStoreSkusafeImpl.delstoreSkusafeModelByCode.num");
        }
    }

    private void deletestoreSkusafeModel(Integer storeSkusafeId) throws ApiException {
        if (null == storeSkusafeId) {
            return;
        }
        int i = 0;
        try {
            i = this.whStoreSkusafeMapper.deleteByPrimaryKey(storeSkusafeId);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreSkusafeImpl.deletestoreSkusafeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhStoreSkusafeImpl.deletestoreSkusafeModel.num");
        }
    }

    private void updatestoreSkusafeModel(WhStoreSkusafe whStoreSkusafe) throws ApiException {
        if (null == whStoreSkusafe) {
            return;
        }
        int i = 0;
        try {
            i = this.whStoreSkusafeMapper.updateByPrimaryKey(whStoreSkusafe);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreSkusafeImpl.updatestoreSkusafeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhStoreSkusafeImpl.updatestoreSkusafeModel.num");
        }
    }

    private void updateStatestoreSkusafeModel(Integer storeSkusafeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == storeSkusafeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("storeSkusafeId", storeSkusafeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.whStoreSkusafeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreSkusafeImpl.updateStatestoreSkusafeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhStoreSkusafeImpl.updateStatestoreSkusafeModel.null");
        }
    }

    private void updateStatestoreSkusafeModelByCode(String tenantCode, String storeSkusafeCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)storeSkusafeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeSkusafeCode", storeSkusafeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.whStoreSkusafeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhStoreSkusafeImpl.updateStatestoreSkusafeModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhStoreSkusafeImpl.updateStatestoreSkusafeModelByCode.null");
        }
    }

    private WhStoreSkusafe makestoreSkusafe(WhStoreSkusafeDomain whStoreSkusafeDomain, WhStoreSkusafe whStoreSkusafe) {
        if (null == whStoreSkusafeDomain) {
            return null;
        }
        if (null == whStoreSkusafe) {
            whStoreSkusafe = new WhStoreSkusafe();
        }
        try {
            BeanUtils.copyAllPropertys((Object)whStoreSkusafe, (Object)whStoreSkusafeDomain);
            return whStoreSkusafe;
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreSkusafeImpl.makestoreSkusafe", (Throwable)e);
            return null;
        }
    }

    private WhStoreSkusafeReDomain makeWhStoreSkusafeReDomain(WhStoreSkusafe whStoreSkusafe) {
        if (null == whStoreSkusafe) {
            return null;
        }
        WhStoreSkusafeReDomain whStoreSkusafeReDomain = new WhStoreSkusafeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whStoreSkusafeReDomain, (Object)whStoreSkusafe);
            return whStoreSkusafeReDomain;
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreSkusafeImpl.makeWhStoreSkusafeReDomain", (Throwable)e);
            return null;
        }
    }

    private List<WhStoreSkusafe> querystoreSkusafeModelPage(Map<String, Object> parammap) {
        try {
            return this.whStoreSkusafeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreSkusafeImpl.querystoreSkusafeModel", (Throwable)e);
            return null;
        }
    }

    private int countstoreSkusafe(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.whStoreSkusafeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhStoreSkusafeImpl.countstoreSkusafe", (Throwable)e);
        }
        return i;
    }

    private WhStoreSkusafe createWhStoreSkusafe(WhStoreSkusafeDomain whStoreSkusafeDomain) {
        String msg = this.checkstoreSkusafe(whStoreSkusafeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhStoreSkusafeImpl.savestoreSkusafe.checkstoreSkusafe", msg);
        }
        WhStoreSkusafe whStoreSkusafe = this.makestoreSkusafe(whStoreSkusafeDomain, null);
        this.setstoreSkusafeDefault(whStoreSkusafe);
        return whStoreSkusafe;
    }

    @Override
    public String savestoreSkusafe(WhStoreSkusafeDomain whStoreSkusafeDomain) throws ApiException {
        WhStoreSkusafe whStoreSkusafe = this.createWhStoreSkusafe(whStoreSkusafeDomain);
        String tenantCode = whStoreSkusafe.getTenantCode();
        this.savestoreSkusafeModel(whStoreSkusafe);
        this.saveOrUpdateSkuSafeDis(whStoreSkusafe);
        return whStoreSkusafe.getStoreSkusafeCode();
    }

    private void saveOrUpdateSkuSafeDis(WhStoreSkusafe whStoreSkusafe) {
        if (null == whStoreSkusafe) {
            return;
        }
        String key = whStoreSkusafe.getTenantCode();
        String json = DisUtil.getRemotMap((String)"wh_store_skusafe", (String)key);
        if (StringUtils.isNotBlank((String)json)) {
            List mlist = JsonUtil.buildNormalBinder().getJsonToList(json, WhStoreSkusafe.class);
            ArrayList<WhStoreSkusafe> mprlist = new ArrayList<WhStoreSkusafe>();
            if (ListUtil.isNotEmpty((Collection)mlist)) {
                boolean flag = false;
                for (WhStoreSkusafe skusafe : mlist) {
                    if (StringUtils.isBlank((String)skusafe.getStoreSkusafeCode())) continue;
                    if (skusafe.getStoreSkusafeCode().equals(whStoreSkusafe.getStoreSkusafeCode())) {
                        flag = true;
                        mprlist.add(whStoreSkusafe);
                        continue;
                    }
                    mprlist.add(skusafe);
                }
                if (!flag) {
                    mprlist.add(whStoreSkusafe);
                }
            } else {
                mprlist.add(whStoreSkusafe);
            }
            DisUtil.setMapVer((String)"wh_store_skusafe", (String)key, (String)JsonUtil.buildNormalBinder().toJson(mprlist));
        } else {
            ArrayList<WhStoreSkusafe> mlist = new ArrayList<WhStoreSkusafe>();
            mlist.add(whStoreSkusafe);
            DisUtil.setMapVer((String)"wh_store_skusafe", (String)key, (String)JsonUtil.buildNormalBinder().toJson(mlist));
        }
    }

    @Override
    public String savestoreSkusafeBatch(List<WhStoreSkusafeDomain> whStoreSkusafeDomainList) throws ApiException {
        if (null == whStoreSkusafeDomainList || whStoreSkusafeDomainList.isEmpty()) {
            return null;
        }
        ArrayList<WhStoreSkusafe> whStoreSkusafeList = new ArrayList<WhStoreSkusafe>();
        String code = "";
        for (WhStoreSkusafeDomain whStoreSkusafeDomain : whStoreSkusafeDomainList) {
            WhStoreSkusafe whStoreSkusafe = this.createWhStoreSkusafe(whStoreSkusafeDomain);
            code = whStoreSkusafe.getStoreSkusafeCode();
            whStoreSkusafeList.add(whStoreSkusafe);
        }
        this.savestoreSkusafeBatchModel(whStoreSkusafeList);
        for (WhStoreSkusafe skusafe : whStoreSkusafeList) {
            this.saveOrUpdateSkuSafeDis(skusafe);
        }
        return code;
    }

    @Override
    public void updatestoreSkusafeState(Integer storeSkusafeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == storeSkusafeId) {
            return;
        }
        this.updateStatestoreSkusafeModel(storeSkusafeId, dataState, oldDataState, map);
    }

    @Override
    public void updatestoreSkusafeStateByCode(String tenantCode, String storeSkusafeCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)storeSkusafeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatestoreSkusafeModelByCode(tenantCode, storeSkusafeCode, dataState, oldDataState, map);
    }

    @Override
    public void updatestoreSkusafe(WhStoreSkusafeDomain whStoreSkusafeDomain) throws ApiException {
        String msg = this.checkstoreSkusafe(whStoreSkusafeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhStoreSkusafeImpl.updatestoreSkusafe.checkstoreSkusafe", msg);
        }
        WhStoreSkusafe oldWhStoreSkusafe = this.getstoreSkusafeModelById(whStoreSkusafeDomain.getStoreSkusafeId());
        if (null == oldWhStoreSkusafe) {
            throw new ApiException("wh.WhStoreSkusafeImpl.updatestoreSkusafe.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WhStoreSkusafe whStoreSkusafe = this.makestoreSkusafe(whStoreSkusafeDomain, oldWhStoreSkusafe);
        this.setstoreSkusafeUpdataDefault(whStoreSkusafe);
        this.updatestoreSkusafeModel(whStoreSkusafe);
        this.saveOrUpdateSkuSafeDis(whStoreSkusafe);
    }

    @Override
    public WhStoreSkusafe getstoreSkusafe(Integer storeSkusafeId) {
        if (null == storeSkusafeId) {
            return null;
        }
        return this.getstoreSkusafeModelById(storeSkusafeId);
    }

    @Override
    public void deletestoreSkusafe(Integer storeSkusafeId) throws ApiException {
        if (null == storeSkusafeId) {
            return;
        }
        this.deletestoreSkusafeModel(storeSkusafeId);
    }

    @Override
    public QueryResult<WhStoreSkusafe> querystoreSkusafePage(Map<String, Object> map) {
        List<WhStoreSkusafe> whStoreSkusafeList = this.querystoreSkusafeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countstoreSkusafe(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(whStoreSkusafeList);
        return queryResult;
    }

    @Override
    public WhStoreSkusafe getstoreSkusafeByCode(String tenantCode, String storeSkusafeCode) throws ApiException {
        if (StringUtils.isBlank((String)storeSkusafeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeSkusafeCode", storeSkusafeCode);
        return this.getstoreSkusafeModelByCode(map);
    }

    @Override
    public void deletestoreSkusafeByCode(String tenantCode, String storeSkusafeCode) throws ApiException {
        if (StringUtils.isBlank((String)storeSkusafeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeSkusafeCode", storeSkusafeCode);
        this.delstoreSkusafeModelByCode(map);
    }
}

