/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.warehouse.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.warehouse.dao.WhUserwhConfMapper;
import com.yqbsoft.laser.service.warehouse.domain.WhUserwhConfDomain;
import com.yqbsoft.laser.service.warehouse.domain.WhUserwhConfReDomain;
import com.yqbsoft.laser.service.warehouse.model.WhUserwhConf;
import com.yqbsoft.laser.service.warehouse.service.WhUserwhConfService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WhUserwhConfServiceImpl
extends BaseServiceImpl
implements WhUserwhConfService {
    private static final String SYS_CODE = "wh.WhUserwhConfServiceImpl";
    private WhUserwhConfMapper whUserwhConfMapper;

    public void setWhUserwhConfMapper(WhUserwhConfMapper whUserwhConfMapper) {
        this.whUserwhConfMapper = whUserwhConfMapper;
    }

    private Date getSysDate() {
        try {
            return this.whUserwhConfMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhConfServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUserwhConf(WhUserwhConfDomain whUserwhConfDomain) {
        if (null == whUserwhConfDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)whUserwhConfDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUserwhConfDefault(WhUserwhConf whUserwhConf) {
        if (null == whUserwhConf) {
            return;
        }
        if (null == whUserwhConf.getDataState()) {
            whUserwhConf.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == whUserwhConf.getGmtCreate()) {
            whUserwhConf.setGmtCreate(date);
        }
        whUserwhConf.setGmtModified(date);
        if (StringUtils.isBlank((String)whUserwhConf.getUserwhConfCode())) {
            whUserwhConf.setUserwhConfCode(this.getNo(null, "WhUserwhConf", "whUserwhConf", whUserwhConf.getTenantCode()));
        }
    }

    private int getUserwhConfMaxCode() {
        int code = 0;
        try {
            return this.whUserwhConfMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhConfServiceImpl.getUserwhConfMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUserwhConfUpdataDefault(WhUserwhConf whUserwhConf) {
        if (null == whUserwhConf) {
            return;
        }
        whUserwhConf.setGmtModified(this.getSysDate());
    }

    private void saveUserwhConfModel(WhUserwhConf whUserwhConf) throws ApiException {
        if (null == whUserwhConf) {
            return;
        }
        try {
            this.whUserwhConfMapper.insert(whUserwhConf);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhConfServiceImpl.saveUserwhConfModel.ex", (Throwable)e);
        }
    }

    private void saveUserwhConfBatchModel(List<WhUserwhConf> whUserwhConfList) throws ApiException {
        if (null == whUserwhConfList || whUserwhConfList.isEmpty()) {
            return;
        }
        try {
            this.whUserwhConfMapper.insertBatch(whUserwhConfList);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhConfServiceImpl.saveUserwhConfBatchModel.ex", (Throwable)e);
        }
    }

    private WhUserwhConf getUserwhConfModelById(Integer userwhConfId) {
        if (null == userwhConfId) {
            return null;
        }
        try {
            return this.whUserwhConfMapper.selectByPrimaryKey(userwhConfId);
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhConfServiceImpl.getUserwhConfModelById", (Throwable)e);
            return null;
        }
    }

    private WhUserwhConf getUserwhConfModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.whUserwhConfMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhConfServiceImpl.getUserwhConfModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUserwhConfModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.whUserwhConfMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhConfServiceImpl.delUserwhConfModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhUserwhConfServiceImpl.delUserwhConfModelByCode.num");
        }
    }

    private void delUserwhConfModelByuserwhCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.whUserwhConfMapper.delByUserwhCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhConfServiceImpl.delUserwhConfModelByuserwhCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhUserwhConfServiceImpl.delUserwhConfModelByuserwhCode.num");
        }
    }

    private void deleteUserwhConfModel(Integer userwhConfId) throws ApiException {
        if (null == userwhConfId) {
            return;
        }
        int i = 0;
        try {
            i = this.whUserwhConfMapper.deleteByPrimaryKey(userwhConfId);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhConfServiceImpl.deleteUserwhConfModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhUserwhConfServiceImpl.deleteUserwhConfModel.num");
        }
    }

    private void updateUserwhConfModel(WhUserwhConf whUserwhConf) throws ApiException {
        if (null == whUserwhConf) {
            return;
        }
        int i = 0;
        try {
            i = this.whUserwhConfMapper.updateByPrimaryKey(whUserwhConf);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhConfServiceImpl.updateUserwhConfModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wh.WhUserwhConfServiceImpl.updateUserwhConfModel.num");
        }
    }

    private void updateStateUserwhConfModel(Integer userwhConfId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == userwhConfId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userwhConfId", userwhConfId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.whUserwhConfMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhConfServiceImpl.updateStateUserwhConfModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhUserwhConfServiceImpl.updateStateUserwhConfModel.null");
        }
    }

    private void updateStateUserwhConfModelByCode(String tenantCode, String userwhConfCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)userwhConfCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userwhConfCode", userwhConfCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.whUserwhConfMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wh.WhUserwhConfServiceImpl.updateStateUserwhConfModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wh.WhUserwhConfServiceImpl.updateStateUserwhConfModelByCode.null");
        }
    }

    private WhUserwhConf makeUserwhConf(WhUserwhConfDomain whUserwhConfDomain, WhUserwhConf whUserwhConf) {
        if (null == whUserwhConfDomain) {
            return null;
        }
        if (null == whUserwhConf) {
            whUserwhConf = new WhUserwhConf();
        }
        try {
            BeanUtils.copyAllPropertys((Object)whUserwhConf, (Object)whUserwhConfDomain);
            return whUserwhConf;
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhConfServiceImpl.makeUserwhConf", (Throwable)e);
            return null;
        }
    }

    private WhUserwhConfReDomain makeWhUserwhConfReDomain(WhUserwhConf whUserwhConf) {
        if (null == whUserwhConf) {
            return null;
        }
        WhUserwhConfReDomain whUserwhConfReDomain = new WhUserwhConfReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)whUserwhConfReDomain, (Object)whUserwhConf);
            return whUserwhConfReDomain;
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhConfServiceImpl.makeWhUserwhConfReDomain", (Throwable)e);
            return null;
        }
    }

    private List<WhUserwhConf> queryUserwhConfModelPage(Map<String, Object> parammap) {
        try {
            return this.whUserwhConfMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhConfServiceImpl.queryUserwhConfModel", (Throwable)e);
            return null;
        }
    }

    private int countUserwhConf(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.whUserwhConfMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wh.WhUserwhConfServiceImpl.countUserwhConf", (Throwable)e);
        }
        return i;
    }

    private WhUserwhConf createWhUserwhConf(WhUserwhConfDomain whUserwhConfDomain) {
        String msg = this.checkUserwhConf(whUserwhConfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhUserwhConfServiceImpl.saveUserwhConf.checkUserwhConf", msg);
        }
        WhUserwhConf whUserwhConf = this.makeUserwhConf(whUserwhConfDomain, null);
        this.setUserwhConfDefault(whUserwhConf);
        return whUserwhConf;
    }

    @Override
    public String saveUserwhConf(WhUserwhConfDomain whUserwhConfDomain) throws ApiException {
        WhUserwhConf whUserwhConf = this.createWhUserwhConf(whUserwhConfDomain);
        this.saveUserwhConfModel(whUserwhConf);
        return whUserwhConf.getUserwhConfCode();
    }

    @Override
    public String saveUserwhConfBatch(List<WhUserwhConfDomain> whUserwhConfDomainList) throws ApiException {
        if (null == whUserwhConfDomainList || whUserwhConfDomainList.isEmpty()) {
            return null;
        }
        ArrayList<WhUserwhConf> whUserwhConfList = new ArrayList<WhUserwhConf>();
        String code = "";
        for (WhUserwhConfDomain whUserwhConfDomain : whUserwhConfDomainList) {
            WhUserwhConf whUserwhConf = this.createWhUserwhConf(whUserwhConfDomain);
            code = whUserwhConf.getUserwhConfCode();
            whUserwhConfList.add(whUserwhConf);
        }
        this.saveUserwhConfBatchModel(whUserwhConfList);
        return code;
    }

    @Override
    public void updateUserwhConfState(Integer userwhConfId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == userwhConfId) {
            return;
        }
        this.updateStateUserwhConfModel(userwhConfId, dataState, oldDataState, map);
    }

    @Override
    public void updateUserwhConfStateByCode(String tenantCode, String userwhConfCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)userwhConfCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUserwhConfModelByCode(tenantCode, userwhConfCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUserwhConf(WhUserwhConfDomain whUserwhConfDomain) throws ApiException {
        String msg = this.checkUserwhConf(whUserwhConfDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wh.WhUserwhConfServiceImpl.updateUserwhConf.checkUserwhConf", msg);
        }
        WhUserwhConf oldWhUserwhConf = this.getUserwhConfModelById(whUserwhConfDomain.getUserwhConfId());
        if (null == oldWhUserwhConf) {
            throw new ApiException("wh.WhUserwhConfServiceImpl.updateUserwhConf.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WhUserwhConf whUserwhConf = this.makeUserwhConf(whUserwhConfDomain, oldWhUserwhConf);
        this.setUserwhConfUpdataDefault(whUserwhConf);
        this.updateUserwhConfModel(whUserwhConf);
    }

    @Override
    public WhUserwhConf getUserwhConf(Integer userwhConfId) {
        if (null == userwhConfId) {
            return null;
        }
        return this.getUserwhConfModelById(userwhConfId);
    }

    @Override
    public void deleteUserwhConf(Integer userwhConfId) throws ApiException {
        if (null == userwhConfId) {
            return;
        }
        this.deleteUserwhConfModel(userwhConfId);
    }

    @Override
    public QueryResult<WhUserwhConf> queryUserwhConfPage(Map<String, Object> map) {
        List<WhUserwhConf> whUserwhConfList = this.queryUserwhConfModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUserwhConf(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(whUserwhConfList);
        return queryResult;
    }

    @Override
    public WhUserwhConf getUserwhConfByCode(String tenantCode, String userwhConfCode) throws ApiException {
        if (StringUtils.isBlank((String)userwhConfCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userwhConfCode", userwhConfCode);
        return this.getUserwhConfModelByCode(map);
    }

    @Override
    public void deleteUserwhConfByCode(String tenantCode, String userwhConfCode) throws ApiException {
        if (StringUtils.isBlank((String)userwhConfCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userwhConfCode", userwhConfCode);
        this.delUserwhConfModelByCode(map);
    }

    @Override
    public void deleteUserwhConfByUserwhCode(String tenantCode, String userwhCode) throws ApiException {
        if (StringUtils.isBlank((String)userwhCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userwhCode", userwhCode);
        this.delUserwhConfModelByuserwhCode(map);
    }
}

