/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.evaluate.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.evaluate.dao.ResTemplateMapper;
import com.yqbsoft.laser.service.evaluate.dao.ResTemplateValuesMapper;
import com.yqbsoft.laser.service.evaluate.domain.ResTemplateDomain;
import com.yqbsoft.laser.service.evaluate.domain.ResTemplateReDomain;
import com.yqbsoft.laser.service.evaluate.domain.ResTemplateValuesDomain;
import com.yqbsoft.laser.service.evaluate.domain.ResTemplateValuesReDomain;
import com.yqbsoft.laser.service.evaluate.model.ResTemplate;
import com.yqbsoft.laser.service.evaluate.model.ResTemplateValues;
import com.yqbsoft.laser.service.evaluate.service.ResTemplateService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResTemplateServiceImpl
extends BaseServiceImpl
implements ResTemplateService {
    private static final String SYS_CODE = "res.ResTemplateServiceImpl";
    private ResTemplateMapper resTemplateMapper;
    private ResTemplateValuesMapper resTemplateValuesMapper;

    public void setResTemplateMapper(ResTemplateMapper resTemplateMapper) {
        this.resTemplateMapper = resTemplateMapper;
    }

    public void setResTemplateValuesMapper(ResTemplateValuesMapper resTemplateValuesMapper) {
        this.resTemplateValuesMapper = resTemplateValuesMapper;
    }

    private Date getSysDate() {
        try {
            return this.resTemplateMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("res.ResTemplateServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkTemplate(ResTemplateDomain resTemplateDomain) {
        if (null == resTemplateDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)resTemplateDomain.getTemplateTitle())) {
            msg = msg + "templateTitle\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resTemplateDomain.getTemplateApplyTarget())) {
            msg = msg + "templateApplyTarget\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resTemplateDomain.getTemplateContentType())) {
            msg = msg + "templateContentType\u4e3a\u7a7a;";
        }
        if (resTemplateDomain.getTemplateSort() == null) {
            msg = msg + "templateSort\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resTemplateDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setTemplateDefault(ResTemplate resTemplate) {
        if (null == resTemplate) {
            return;
        }
        if (null == resTemplate.getDataState()) {
            resTemplate.setDataState(0);
        }
        if (null == resTemplate.getGmtCreate()) {
            resTemplate.setGmtCreate(this.getSysDate());
        }
        resTemplate.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)resTemplate.getTemplateCode())) {
            resTemplate.setTemplateCode(this.createUUIDString());
        }
    }

    private int getTemplateMaxCode() {
        int code = 0;
        try {
            return this.resTemplateMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("res.ResTemplateServiceImpl.getTemplateMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTemplateUpdataDefault(ResTemplate resTemplate) {
        if (null == resTemplate) {
            return;
        }
        resTemplate.setGmtModified(this.getSysDate());
    }

    private void saveTemplateModel(ResTemplate resTemplate) throws ApiException {
        if (null == resTemplate) {
            return;
        }
        try {
            this.resTemplateMapper.insert(resTemplate);
        }
        catch (Exception e) {
            throw new ApiException("res.ResTemplateServiceImpl.saveTemplateModel.ex", (Throwable)e);
        }
    }

    private ResTemplate getTemplateModelById(Integer templateId) {
        if (null == templateId) {
            return null;
        }
        try {
            ResTemplate template = this.resTemplateMapper.selectByPrimaryKey(templateId);
            template.setResTemplateValuesList(this.resTemplateValuesMapper.selectByTemplateCode(template.getTemplateCode()));
            return template;
        }
        catch (Exception e) {
            throw new ApiException("res.ResTemplateServiceImpl.getTemplateModelById", (Throwable)e);
        }
    }

    private ResTemplate getTemplateModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.resTemplateMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("res.ResTemplateServiceImpl.getTemplateModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delTemplateModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.resTemplateMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("res.ResTemplateServiceImpl.delTemplateModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("res.ResTemplateServiceImpl.delTemplateModelByCode.num");
        }
    }

    private void deleteTemplateModel(Integer templateId) throws ApiException {
        if (null == templateId) {
            return;
        }
        int i = 0;
        try {
            i = this.resTemplateMapper.deleteByPrimaryKey(templateId);
        }
        catch (Exception e) {
            throw new ApiException("res.ResTemplateServiceImpl.deleteTemplateModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("res.ResTemplateServiceImpl.deleteTemplateModel.num");
        }
    }

    private void updateTemplateModel(ResTemplate resTemplate) throws ApiException {
        if (null == resTemplate) {
            return;
        }
        int i = 0;
        try {
            i = this.resTemplateMapper.updateByPrimaryKeySelective(resTemplate);
        }
        catch (Exception e) {
            throw new ApiException("res.ResTemplateServiceImpl.updateTemplateModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("res.ResTemplateServiceImpl.updateTemplateModel.num");
        }
    }

    private void updateStateTemplateModel(Integer templateId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == templateId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("templateId", templateId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.resTemplateMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("res.ResTemplateServiceImpl.updateStateTemplateModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("res.ResTemplateServiceImpl.updateStateTemplateModel.null");
        }
    }

    private ResTemplate makeTemplate(ResTemplateDomain resTemplateDomain, ResTemplate resTemplate) {
        if (null == resTemplateDomain) {
            return null;
        }
        if (null == resTemplate) {
            resTemplate = new ResTemplate();
        }
        try {
            BeanUtils.copyAllPropertys((Object)resTemplate, (Object)resTemplateDomain);
            return resTemplate;
        }
        catch (Exception e) {
            this.logger.error("res.ResTemplateServiceImpl.makeTemplate", (Throwable)e);
            return null;
        }
    }

    private List<ResTemplate> queryTemplateModelPage(Map<String, Object> parammap) {
        try {
            return this.resTemplateMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("res.ResTemplateServiceImpl.queryTemplateModel", (Throwable)e);
            return null;
        }
    }

    private int countTemplate(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.resTemplateMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("res.ResTemplateServiceImpl.countTemplate", (Throwable)e);
        }
        return i;
    }

    private String checkTemplateValues(ResTemplateValuesDomain resTemplateValuesDomain) {
        if (null == resTemplateValuesDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)resTemplateValuesDomain.getTemplateCode())) {
            msg = msg + "TemplateCode\u4e3a\u7a7a;";
        }
        if (resTemplateValuesDomain.getTemplateValuesScope() == null) {
            msg = msg + "TemplateValuesScope\u4e3a\u7a7a";
        }
        if (resTemplateValuesDomain.getTemplateValuesDel() == null) {
            msg = msg + "TemplateValuesDel\u4e3a\u7a7a";
        }
        if (resTemplateValuesDomain.getTemplateValuesDefault() == null) {
            msg = msg + "TemplateValuesDefault\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((Integer)resTemplateValuesDomain.getTemplateValuesSort())) {
            msg = msg + "TemplateValuesSort\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resTemplateValuesDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setTemplateValuesDefault(ResTemplateValues resTemplateValues) {
        if (null == resTemplateValues) {
            return;
        }
        if (null == resTemplateValues.getDataState()) {
            resTemplateValues.setDataState(0);
        }
        if (null == resTemplateValues.getGmtCreate()) {
            resTemplateValues.setGmtCreate(this.getSysDate());
        }
        resTemplateValues.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)resTemplateValues.getTemplateValuesCode())) {
            resTemplateValues.setTemplateValuesCode(this.createUUIDString());
        }
    }

    private int getTemplateValuesMaxCode() {
        int code = 0;
        try {
            return this.resTemplateValuesMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("res.ResTemplateServiceImpl.getTemplateValuesMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTemplateValuesUpdataDefault(ResTemplateValues resTemplateValues) {
        if (null == resTemplateValues) {
            return;
        }
        resTemplateValues.setGmtModified(this.getSysDate());
        if (resTemplateValues.getTemplateValuesDel() == null) {
            resTemplateValues.setTemplateValuesDel(false);
        }
        if (resTemplateValues.getTemplateValuesDefault() == null) {
            resTemplateValues.setTemplateValuesDefault(false);
        }
    }

    private void saveTemplateValuesModel(ResTemplateValues resTemplateValues) throws ApiException {
        if (null == resTemplateValues) {
            return;
        }
        try {
            this.resTemplateValuesMapper.insert(resTemplateValues);
        }
        catch (Exception e) {
            throw new ApiException("res.ResTemplateServiceImpl.saveTemplateValuesModel.ex", (Throwable)e);
        }
    }

    private ResTemplateValues getTemplateValuesModelById(Integer templateValuesId) {
        if (null == templateValuesId) {
            return null;
        }
        try {
            return this.resTemplateValuesMapper.selectByPrimaryKey(templateValuesId);
        }
        catch (Exception e) {
            this.logger.error("res.ResTemplateServiceImpl.getTemplateValuesModelById", (Throwable)e);
            return null;
        }
    }

    private ResTemplateValues getTemplateValuesModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.resTemplateValuesMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("res.ResTemplateServiceImpl.getTemplateValuesModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delTemplateValuesModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.resTemplateValuesMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("res.ResTemplateServiceImpl.delTemplateValuesModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("res.ResTemplateServiceImpl.delTemplateValuesModelByCode.num");
        }
    }

    private void deleteTemplateValuesModel(Integer templateValuesId) throws ApiException {
        if (null == templateValuesId) {
            return;
        }
        int i = 0;
        try {
            i = this.resTemplateValuesMapper.deleteByPrimaryKey(templateValuesId);
        }
        catch (Exception e) {
            throw new ApiException("res.ResTemplateServiceImpl.deleteTemplateValuesModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("res.ResTemplateServiceImpl.deleteTemplateValuesModel.num");
        }
    }

    private void updateTemplateValuesModel(ResTemplateValues resTemplateValues) throws ApiException {
        if (null == resTemplateValues) {
            return;
        }
        int i = 0;
        try {
            i = this.resTemplateValuesMapper.updateByPrimaryKeySelective(resTemplateValues);
        }
        catch (Exception e) {
            throw new ApiException("res.ResTemplateServiceImpl.updateTemplateValuesModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("res.ResTemplateServiceImpl.updateTemplateValuesModel.num");
        }
    }

    private void updateStateTemplateValuesModel(Integer templateValuesId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == templateValuesId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("templateValuesId", templateValuesId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.resTemplateValuesMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("res.ResTemplateServiceImpl.updateStateTemplateValuesModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("res.ResTemplateServiceImpl.updateStateTemplateValuesModel.null");
        }
    }

    private ResTemplateValues makeTemplateValues(ResTemplateValuesDomain resTemplateValuesDomain, ResTemplateValues resTemplateValues) {
        if (null == resTemplateValuesDomain) {
            return null;
        }
        if (null == resTemplateValues) {
            resTemplateValues = new ResTemplateValues();
        }
        try {
            BeanUtils.copyAllPropertys((Object)resTemplateValues, (Object)resTemplateValuesDomain);
            return resTemplateValues;
        }
        catch (Exception e) {
            this.logger.error("res.ResTemplateServiceImpl.makeTemplateValues", (Throwable)e);
            return null;
        }
    }

    private List<ResTemplateValues> queryTemplateValuesModelPage(Map<String, Object> parammap) {
        try {
            return this.resTemplateValuesMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("res.ResTemplateServiceImpl.queryTemplateValuesModel", (Throwable)e);
            return null;
        }
    }

    private int countTemplateValues(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.resTemplateValuesMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("res.ResTemplateServiceImpl.countTemplateValues", (Throwable)e);
        }
        return i;
    }

    private ResTemplateValues createResTemplateValues(ResTemplateValuesDomain resTemplateValuesDomain) {
        String msg = this.checkTemplateValues(resTemplateValuesDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("res.ResTemplateServiceImpl.createResTemplateValues", msg);
        }
        ResTemplateValues resTemplateValues = this.makeTemplateValues(resTemplateValuesDomain, null);
        this.setTemplateValuesDefault(resTemplateValues);
        return resTemplateValues;
    }

    private void saveTemplateValuesBatchModel(List<ResTemplateValues> resTemplateValuesList) {
        if (resTemplateValuesList == null || resTemplateValuesList.isEmpty()) {
            return;
        }
        try {
            this.resTemplateValuesMapper.insertBatch(resTemplateValuesList);
        }
        catch (Exception e) {
            throw new ApiException("res.ResTemplateServiceImplsaveTemplateValuesBarchModel.ex", (Throwable)e);
        }
    }

    @Override
    public String saveTemplate(ResTemplateDomain resTemplateDomain) throws ApiException {
        String msg = this.checkTemplate(resTemplateDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("res.ResTemplateServiceImpl.saveTemplate.checkTemplate", msg);
        }
        ResTemplate resTemplate = this.makeTemplate(resTemplateDomain, null);
        this.setTemplateDefault(resTemplate);
        this.saveTemplateModel(resTemplate);
        this.saveBatchTemplateValues(resTemplateDomain.getTemplateValuesList(), resTemplate.getTemplateCode(), resTemplate.getAppmanageIcode(), resTemplate.getTenantCode());
        return resTemplate.getTemplateCode();
    }

    @Override
    public void updateTemplateState(Integer templateId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateTemplateModel(templateId, dataState, oldDataState);
    }

    @Override
    public void updateTemplate(ResTemplateDomain resTemplateDomain) throws ApiException {
        String msg = this.checkTemplate(resTemplateDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("res.ResTemplateServiceImpl.updateTemplate.checkTemplate", msg);
        }
        ResTemplate oldResTemplate = this.getTemplateModelById(resTemplateDomain.getTemplateId());
        if (null == oldResTemplate) {
            throw new ApiException("res.ResTemplateServiceImpl.updateTemplate.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ResTemplate resTemplate = this.makeTemplate(resTemplateDomain, oldResTemplate);
        this.setTemplateUpdataDefault(resTemplate);
        this.updateTemplateModel(resTemplate);
    }

    @Override
    public ResTemplate getTemplate(Integer templateId) {
        return this.getTemplateModelById(templateId);
    }

    @Override
    public void deleteTemplate(Integer templateId) throws ApiException {
        this.deleteTemplateModel(templateId);
    }

    private void upTemplateEnavledById(Integer templateId, Boolean templateEnable) throws ApiException {
        if (templateId == null) {
            throw new ApiException("res.ResTemplateServiceImpl.upTemplateEnavledById.templateId.null", "templateId\u4e3a\u7a7a");
        }
        if (templateEnable == null) {
            throw new ApiException("res.ResTemplateServiceImpl.upTemplateEnavledById.templateEnable.null", "templateEnable\u4e3a\u7a7a");
        }
        int i = 0;
        try {
            i = this.resTemplateMapper.updateEnableById(templateId, templateEnable);
        }
        catch (Exception e) {
            throw new ApiException("res.ResTemplateServiceImpl.upTemplateEnavledById.ex", (Throwable)e);
        }
        if (i == 0) {
            throw new ApiException("res.ResTemplateServiceImpl.upTemplateEnavledById.num");
        }
    }

    @Override
    public void updateTemplateEnableById(Integer templateId, Boolean templateEnable) throws ApiException {
        this.upTemplateEnavledById(templateId, templateEnable);
    }

    @Override
    public QueryResult<ResTemplate> queryTemplatePage(Map<String, Object> map) {
        List<ResTemplate> resTemplateList = this.queryTemplateModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTemplate(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(resTemplateList);
        return queryResult;
    }

    @Override
    public ResTemplate getTemplateByCode(Map<String, Object> map) {
        ResTemplate template = this.getTemplateModelByCode(map);
        template.setResTemplateValuesList(this.resTemplateValuesMapper.selectByTemplateCode(template.getTemplateCode()));
        return template;
    }

    @Override
    public void deleteTemplateByCode(Map<String, Object> map) throws ApiException {
        this.delTemplateModelByCode(map);
    }

    private ResTemplateReDomain makeTemplateReDomain(ResTemplate template) {
        if (template == null) {
            return null;
        }
        ResTemplateReDomain templateReDomain = new ResTemplateReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)templateReDomain, (Object)template);
            return templateReDomain;
        }
        catch (Exception e) {
            this.logger.error("res.ResTemplateServiceImpl.makeTemplateReDomain.ex", (Throwable)e);
            return null;
        }
    }

    private List<ResTemplateValuesReDomain> queryValuesListReDomainByTemCode(Map<String, Object> parammap) {
        if (null == parammap || parammap.isEmpty()) {
            throw new ApiException("res.ResTemplateServiceImpl.queryValuesListReDomainByTemCode.templateCode", "templateCode is null");
        }
        List<ResTemplateValues> templateValueList = this.queryTemplateValuesModelPage(parammap);
        if (ListUtil.isEmpty(templateValueList)) {
            return Collections.emptyList();
        }
        ArrayList<ResTemplateValuesReDomain> valuesReDomainList = new ArrayList<ResTemplateValuesReDomain>();
        for (ResTemplateValues resTemplateValues : templateValueList) {
            ResTemplateValuesReDomain valuesReDomain = new ResTemplateValuesReDomain();
            try {
                BeanUtils.copyAllPropertys((Object)valuesReDomain, (Object)resTemplateValues);
                valuesReDomainList.add(valuesReDomain);
            }
            catch (Exception e) {
                this.logger.error("res.ResTemplateServiceImpl.queryValuesListReDomainByTemCode.ex", (Throwable)e);
                return null;
            }
        }
        return valuesReDomainList;
    }

    @Override
    public List<ResTemplateReDomain> queryUseTemplate(Map<String, Object> map) {
        map.put("templateEnable", true);
        List<ResTemplate> templateList = this.queryTemplateModelPage(map);
        if (templateList == null || templateList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ResTemplateReDomain> resTemplateReDomainList = new ArrayList<ResTemplateReDomain>();
        for (ResTemplate resTemplate : templateList) {
            ResTemplateReDomain templateReDomain = this.makeTemplateReDomain(resTemplate);
            map.put("templateCode", resTemplate.getTemplateCode());
            if (templateReDomain != null) {
                templateReDomain.setTemplateValuesReList(this.queryValuesListReDomainByTemCode(map));
            }
            resTemplateReDomainList.add(templateReDomain);
        }
        return resTemplateReDomainList;
    }

    private void upTemplateValuesDelById(Integer templateValuesId, Boolean del) {
        if (templateValuesId == null) {
            throw new ApiException("res.ResTemplateServiceImpl.upTemplateValuesDelById.templateValuesId.null", "templateValuesId\u4e3a\u7a7a");
        }
        if (del == null) {
            throw new ApiException("res.ResTemplateServiceImpl.upTemplateValuesDelById.del.null", "del\u4e3a\u7a7a");
        }
        int i = 0;
        try {
            i = this.resTemplateValuesMapper.updateDelById(templateValuesId, del);
        }
        catch (Exception e) {
            throw new ApiException("res.ResTemplateServiceImpl.upTemplateValuesDelById.ex", (Throwable)e);
        }
        if (i == 0) {
            throw new ApiException("res.ResTemplateServiceImpl.upTemplateValuesDelById.num");
        }
    }

    @Override
    public String saveTemplateValues(ResTemplateValuesDomain resTemplateValuesDomain) throws ApiException {
        String msg = this.checkTemplateValues(resTemplateValuesDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("res.ResTemplateServiceImpl.saveTemplateValues.checkTemplateValues", msg);
        }
        ResTemplateValues resTemplateValues = this.makeTemplateValues(resTemplateValuesDomain, null);
        this.setTemplateValuesDefault(resTemplateValues);
        this.saveTemplateValuesModel(resTemplateValues);
        return resTemplateValues.getTemplateValuesCode();
    }

    @Override
    public void updateTemplateValuesState(Integer templateValuesId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateTemplateValuesModel(templateValuesId, dataState, oldDataState);
    }

    @Override
    public void updateTemplateValues(ResTemplateValuesDomain resTemplateValuesDomain) throws ApiException {
        String msg = this.checkTemplateValues(resTemplateValuesDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("res.ResTemplateServiceImpl.updateTemplateValues.checkTemplateValues", msg);
        }
        ResTemplateValues oldResTemplateValues = this.getTemplateValuesModelById(resTemplateValuesDomain.getTemplateValuesId());
        if (null == oldResTemplateValues) {
            throw new ApiException("res.ResTemplateServiceImpl.updateTemplateValues.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ResTemplateValues resTemplateValues = this.makeTemplateValues(resTemplateValuesDomain, oldResTemplateValues);
        this.setTemplateValuesUpdataDefault(resTemplateValues);
        this.updateTemplateValuesModel(resTemplateValues);
    }

    @Override
    public ResTemplateValues getTemplateValues(Integer templateValuesId) {
        return this.getTemplateValuesModelById(templateValuesId);
    }

    @Override
    public void deleteTemplateValues(Integer templateValuesId) throws ApiException {
        this.deleteTemplateValuesModel(templateValuesId);
    }

    @Override
    public QueryResult<ResTemplateValues> queryTemplateValuesPage(Map<String, Object> map) {
        List<ResTemplateValues> resTemplateValuesList = this.queryTemplateValuesModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTemplateValues(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(resTemplateValuesList);
        return queryResult;
    }

    @Override
    public ResTemplateValues getTemplateValuesByCode(Map<String, Object> map) {
        return this.getTemplateValuesModelByCode(map);
    }

    @Override
    public void deleteTemplateValuesByCode(Map<String, Object> map) throws ApiException {
        this.delTemplateValuesModelByCode(map);
    }

    @Override
    public void updateTemplateValuesDelById(Integer templateValuesId, Boolean del) {
        this.upTemplateValuesDelById(templateValuesId, del);
    }

    @Override
    public void saveBatchTemplateValues(List<ResTemplateValuesDomain> resTemplateValuesDomainList, String templateCode, String appmanageIcode, String tenantCode) {
        if (resTemplateValuesDomainList == null || resTemplateValuesDomainList.isEmpty()) {
            return;
        }
        ArrayList<ResTemplateValues> valuesList = new ArrayList<ResTemplateValues>();
        for (ResTemplateValuesDomain valueDomain : resTemplateValuesDomainList) {
            valueDomain.setTemplateCode(templateCode);
            valueDomain.setAppmanageIcode(appmanageIcode);
            valueDomain.setTenantCode(tenantCode);
            ResTemplateValues resTemplateValues = this.createResTemplateValues(valueDomain);
            valuesList.add(resTemplateValues);
        }
        this.saveTemplateValuesBatchModel(valuesList);
    }
}

