/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.organize.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.organize.dao.OrgDepartMapper;
import com.yqbsoft.laser.service.organize.dao.OrgDepartempMapper;
import com.yqbsoft.laser.service.organize.domain.OrgChannelsendDomain;
import com.yqbsoft.laser.service.organize.domain.OrgDepartDomain;
import com.yqbsoft.laser.service.organize.domain.OrgDepartReDomain;
import com.yqbsoft.laser.service.organize.domain.OrgDepartempDomain;
import com.yqbsoft.laser.service.organize.domain.OrgDepartempReDomain;
import com.yqbsoft.laser.service.organize.domain.OrgEmployeeDomain;
import com.yqbsoft.laser.service.organize.model.OrgChannelsend;
import com.yqbsoft.laser.service.organize.model.OrgDepart;
import com.yqbsoft.laser.service.organize.model.OrgDepartemp;
import com.yqbsoft.laser.service.organize.model.OrgEmployee;
import com.yqbsoft.laser.service.organize.service.OrgChannelsendService;
import com.yqbsoft.laser.service.organize.service.OrgDepartService;
import com.yqbsoft.laser.service.organize.service.OrgEmployeeService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OrgDepartServiceImpl
extends BaseServiceImpl
implements OrgDepartService {
    private static final String SYS_CODE = "org.OrgDepartServiceImpl";
    private OrgDepartMapper orgDepartMapper;
    private OrgDepartempMapper orgDepartempMapper;
    private OrgChannelsendService orgChannelsendService;
    private OrgEmployeeService orgEmployeeService;
    private String cachekeydomain = "OrgDepart-departCode";
    private String cachekeyempdomain = "OrgDepartEmp-orgUsercode";
    private String cachekeyinfoDomain = "OrgDepart-userinfoCode";

    public void setOrgEmployeeService(OrgEmployeeService orgEmployeeService) {
        this.orgEmployeeService = orgEmployeeService;
    }

    public void setOrgDepartMapper(OrgDepartMapper orgDepartMapper) {
        this.orgDepartMapper = orgDepartMapper;
    }

    public OrgChannelsendService getOrgChannelsendService() {
        return this.orgChannelsendService;
    }

    public void setOrgChannelsendService(OrgChannelsendService orgChannelsendService) {
        this.orgChannelsendService = orgChannelsendService;
    }

    public void setOrgDepartempMapper(OrgDepartempMapper orgDepartempMapper) {
        this.orgDepartempMapper = orgDepartempMapper;
    }

    private Date getSysDate() {
        try {
            return this.orgDepartMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkDepart(OrgDepartDomain orgDepartDomain) {
        if (null == orgDepartDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)orgDepartDomain.getCompanyCode())) {
            msg = msg + "CompanyCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)orgDepartDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDepartDefault(OrgDepart orgDepart) {
        if (null == orgDepart) {
            return;
        }
        if (null == orgDepart.getDataState()) {
            orgDepart.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == orgDepart.getGmtCreate()) {
            orgDepart.setGmtCreate(date);
        }
        orgDepart.setGmtModified(date);
        if (StringUtils.isBlank((String)orgDepart.getDepartCode())) {
            orgDepart.setDepartCode(this.getNo(null, "orgDepart", "departCode", orgDepart.getTenantCode()));
        }
        if (StringUtils.isBlank((String)orgDepart.getDepartOrgin())) {
            orgDepart.setDepartOrgin("1");
        }
        if (StringUtils.isBlank((String)orgDepart.getDepartPcode())) {
            orgDepart.setDepartPcode("-1");
        }
    }

    private int getDepartMaxCode() {
        int code = 0;
        try {
            return this.orgDepartMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartServiceImpl.getDepartMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDepartUpdataDefault(OrgDepart orgDepart) {
        if (null == orgDepart) {
            return;
        }
        orgDepart.setGmtModified(this.getSysDate());
    }

    private void saveDepartModel(OrgDepart orgDepart) throws ApiException {
        if (null == orgDepart) {
            return;
        }
        try {
            this.orgDepartMapper.insert(orgDepart);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartServiceImpl.saveDepartModel.ex", (Throwable)e);
        }
    }

    private void saveDepartBatchModel(List<OrgDepart> orgDepartList) throws ApiException {
        if (null == orgDepartList || orgDepartList.isEmpty()) {
            return;
        }
        try {
            this.orgDepartMapper.insertBatch(orgDepartList);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartServiceImpl.saveDepartBatchModel.ex", (Throwable)e);
        }
    }

    private OrgDepart getDepartModelById(Integer departId) {
        if (null == departId) {
            return null;
        }
        try {
            return this.orgDepartMapper.selectByPrimaryKey(departId);
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartServiceImpl.getDepartModelById", (Throwable)e);
            return null;
        }
    }

    private OrgDepart getDepartModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.orgDepartMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartServiceImpl.getDepartModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDepartModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.orgDepartMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartServiceImpl.delDepartModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgDepartServiceImpl.delDepartModelByCode.num");
        }
    }

    private void deleteDepartModel(Integer departId) throws ApiException {
        if (null == departId) {
            return;
        }
        int i = 0;
        try {
            i = this.orgDepartMapper.deleteByPrimaryKey(departId);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartServiceImpl.deleteDepartModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgDepartServiceImpl.deleteDepartModel.num");
        }
    }

    private void updateDepartModel(OrgDepart orgDepart) throws ApiException {
        if (null == orgDepart) {
            return;
        }
        int i = 0;
        try {
            i = this.orgDepartMapper.updateByPrimaryKeySelective(orgDepart);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartServiceImpl.updateDepartModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgDepartServiceImpl.updateDepartModel.num");
        }
    }

    private void updateStateDepartModel(Integer departId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == departId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("departId", departId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.orgDepartMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartServiceImpl.updateStateDepartModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgDepartServiceImpl.updateStateDepartModel.null");
        }
    }

    private void updateStateDepartModelByCode(String tenantCode, String departCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)departCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("departCode", departCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.orgDepartMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartServiceImpl.updateStateDepartModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgDepartServiceImpl.updateStateDepartModelByCode.null");
        }
    }

    private OrgDepart makeDepart(OrgDepartDomain orgDepartDomain, OrgDepart orgDepart) {
        if (null == orgDepartDomain) {
            return null;
        }
        if (null == orgDepart) {
            orgDepart = new OrgDepart();
        }
        try {
            BeanUtils.copyAllPropertys((Object)orgDepart, (Object)orgDepartDomain);
            return orgDepart;
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartServiceImpl.makeDepart", (Throwable)e);
            return null;
        }
    }

    private OrgDepartReDomain makeOrgDepartReDomain(OrgDepart orgDepart) {
        if (null == orgDepart) {
            return null;
        }
        OrgDepartReDomain orgDepartReDomain = new OrgDepartReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)orgDepartReDomain, (Object)orgDepart);
            return orgDepartReDomain;
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartServiceImpl.makeOrgDepartReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OrgDepart> queryDepartModelPage(Map<String, Object> parammap) {
        try {
            return this.orgDepartMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartServiceImpl.queryDepartModel", (Throwable)e);
            return null;
        }
    }

    private int countDepart(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.orgDepartMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartServiceImpl.countDepart", (Throwable)e);
        }
        return i;
    }

    private OrgDepart createOrgDepart(OrgDepartDomain orgDepartDomain) {
        String msg = this.checkDepart(orgDepartDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("org.OrgDepartServiceImpl.saveDepart.checkDepart", msg);
        }
        OrgDepart orgDepart = this.makeDepart(orgDepartDomain, null);
        this.setDepartDefault(orgDepart);
        return orgDepart;
    }

    private String checkDepartemp(OrgDepartempDomain orgDepartempDomain) {
        if (null == orgDepartempDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)orgDepartempDomain.getCompanyCode())) {
            msg = msg + "CompanyCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)orgDepartempDomain.getDepartCode())) {
            msg = msg + "DepartCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)orgDepartempDomain.getEmployeeCode())) {
            msg = msg + "EmployeeCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)orgDepartempDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDepartempDefault(OrgDepartemp orgDepartemp) {
        if (null == orgDepartemp) {
            return;
        }
        if (null == orgDepartemp.getDataState()) {
            orgDepartemp.setDataState(0);
        }
        if (null == orgDepartemp.getGmtCreate()) {
            orgDepartemp.setGmtCreate(this.getSysDate());
        }
        orgDepartemp.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)orgDepartemp.getDepartempCode())) {
            orgDepartemp.setDepartempCode(this.createUUIDString());
        }
    }

    private int getDepartempMaxCode() {
        int code = 0;
        try {
            return this.orgDepartempMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartServiceImpl.getDepartempMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDepartempUpdataDefault(OrgDepartemp orgDepartemp) {
        if (null == orgDepartemp) {
            return;
        }
        orgDepartemp.setGmtModified(this.getSysDate());
    }

    private void saveDepartempModel(OrgDepartemp orgDepartemp) throws ApiException {
        if (null == orgDepartemp) {
            return;
        }
        try {
            this.orgDepartempMapper.insert(orgDepartemp);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartServiceImpl.saveDepartempModel.ex", (Throwable)e);
        }
    }

    private void saveDepartempBatchModel(List<OrgDepartemp> orgDepartempList) throws ApiException {
        if (null == orgDepartempList || orgDepartempList.isEmpty()) {
            return;
        }
        try {
            this.orgDepartempMapper.insertBatch(orgDepartempList);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartServiceImpl.saveDepartempBatchModel.ex", (Throwable)e);
        }
    }

    private OrgDepartemp getDepartempModelById(Integer departempId) {
        if (null == departempId) {
            return null;
        }
        try {
            return this.orgDepartempMapper.selectByPrimaryKey(departempId);
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartServiceImpl.getDepartempModelById", (Throwable)e);
            return null;
        }
    }

    private OrgDepartemp getDepartempModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.orgDepartempMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartServiceImpl.getDepartempModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDepartempModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.orgDepartempMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartServiceImpl.delDepartempModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgDepartServiceImpl.delDepartempModelByCode.num");
        }
    }

    private void deleteDepartempModel(Integer departempId) throws ApiException {
        if (null == departempId) {
            return;
        }
        int i = 0;
        try {
            i = this.orgDepartempMapper.deleteByPrimaryKey(departempId);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartServiceImpl.deleteDepartempModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgDepartServiceImpl.deleteDepartempModel.num");
        }
    }

    private void updateDepartempModel(OrgDepartemp orgDepartemp) throws ApiException {
        if (null == orgDepartemp) {
            return;
        }
        int i = 0;
        try {
            i = this.orgDepartempMapper.updateByPrimaryKeySelective(orgDepartemp);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartServiceImpl.updateDepartempModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("org.OrgDepartServiceImpl.updateDepartempModel.num");
        }
    }

    private void updateStateDepartempModel(Integer departempId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == departempId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("departempId", departempId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.orgDepartempMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartServiceImpl.updateStateDepartempModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgDepartServiceImpl.updateStateDepartempModel.null");
        }
    }

    private void updateStateDepartempModelByCode(String tenantCode, String departempCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)departempCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("departempCode", departempCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.orgDepartempMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartServiceImpl.updateStateDepartempModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgDepartServiceImpl.updateStateDepartempModelByCode.null");
        }
    }

    private OrgDepartemp makeDepartemp(OrgDepartempDomain orgDepartempDomain, OrgDepartemp orgDepartemp) {
        if (null == orgDepartempDomain) {
            return null;
        }
        if (null == orgDepartemp) {
            orgDepartemp = new OrgDepartemp();
        }
        try {
            BeanUtils.copyAllPropertys((Object)orgDepartemp, (Object)orgDepartempDomain);
            return orgDepartemp;
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartServiceImpl.makeDepartemp", (Throwable)e);
            return null;
        }
    }

    private OrgDepartempReDomain makeOrgDepartempReDomain(OrgDepartemp orgDepartemp) {
        if (null == orgDepartemp) {
            return null;
        }
        OrgDepartempReDomain orgDepartempReDomain = new OrgDepartempReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)orgDepartempReDomain, (Object)orgDepartemp);
            return orgDepartempReDomain;
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartServiceImpl.makeOrgDepartempReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OrgDepartemp> queryDepartempModelPage(Map<String, Object> parammap) {
        try {
            return this.orgDepartempMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartServiceImpl.queryDepartempModel", (Throwable)e);
            return null;
        }
    }

    private int countDepartemp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.orgDepartempMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("org.OrgDepartServiceImpl.countDepartemp", (Throwable)e);
        }
        return i;
    }

    private OrgDepartemp createOrgDepartemp(OrgDepartempDomain orgDepartempDomain) {
        String msg = this.checkDepartemp(orgDepartempDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("org.OrgDepartServiceImpl.saveDepartemp.checkDepartemp", msg);
        }
        OrgDepartemp orgDepartemp = this.makeDepartemp(orgDepartempDomain, null);
        this.setDepartempDefault(orgDepartemp);
        return orgDepartemp;
    }

    @Override
    public List<OrgChannelsend> saveDepart(OrgDepartDomain orgDepartDomain) throws ApiException {
        if (null == orgDepartDomain) {
            return null;
        }
        OrgDepart orgDepart = StringUtils.isNotBlank((String)orgDepartDomain.getDepartCode()) ? this.getDepartByCode(orgDepartDomain.getTenantCode(), orgDepartDomain.getDepartCode()) : this.getOrgDepart(orgDepartDomain);
        List<OrgChannelsend> list = this.saveEmployeeBatch(orgDepart, orgDepartDomain.getOrgEmployeeDomainList());
        if (null == list) {
            list = new ArrayList<OrgChannelsend>();
        }
        if (ListUtil.isNotEmpty(orgDepartDomain.getOrgEmployeeDomainList())) {
            for (OrgEmployeeDomain orgEmployeeDomain : orgDepartDomain.getOrgEmployeeDomainList()) {
                List<OrgChannelsend> emlist;
                OrgDepartempDomain orgDepartempDomain = new OrgDepartempDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)orgDepartempDomain, (Object)orgEmployeeDomain);
                    BeanUtils.copyAllPropertys((Object)orgDepartempDomain, (Object)orgDepart);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!ListUtil.isNotEmpty(emlist = this.saveDepartemp(orgDepartempDomain))) continue;
                list.addAll(emlist);
            }
        }
        ArrayList<OrgDepart> slist = new ArrayList<OrgDepart>();
        slist.add(orgDepart);
        List<OrgChannelsend> relist = this.buidPmChannelsend(slist, "insert");
        if (ListUtil.isNotEmpty(relist)) {
            relist.addAll(list);
        } else {
            relist = list;
        }
        return relist;
    }

    private List<OrgChannelsend> saveEmployeeBatch(OrgDepart orgDepart, List<OrgEmployeeDomain> orgEmployeeDomainList) {
        if (null == orgDepart || null == orgEmployeeDomainList || orgEmployeeDomainList.isEmpty()) {
            return null;
        }
        for (OrgEmployeeDomain orgEmployeeDomain : orgEmployeeDomainList) {
            orgEmployeeDomain.setCompanyCode(orgDepart.getCompanyCode());
            orgEmployeeDomain.setCompanyShortname(orgDepart.getDepartShortname());
            orgEmployeeDomain.setEmployeeDp("1");
            orgEmployeeDomain.setTenantCode(orgDepart.getTenantCode());
        }
        return this.orgEmployeeService.saveEmployeeBatch(orgEmployeeDomainList);
    }

    @Override
    public List<OrgChannelsend> saveDepartBatch(List<OrgDepartDomain> orgDepartDomainList) throws ApiException {
        if (null == orgDepartDomainList || orgDepartDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OrgChannelsend> relist = new ArrayList<OrgChannelsend>();
        for (OrgDepartDomain orgDepartDomain : orgDepartDomainList) {
            List<OrgChannelsend> list = this.saveDepart(orgDepartDomain);
            if (!ListUtil.isNotEmpty(list)) continue;
            relist.addAll(list);
        }
        return relist;
    }

    @Override
    public List<OrgChannelsend> updateDepartState(Integer departId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateDepartModel(departId, dataState, oldDataState);
        OrgDepart orgDepart = this.getDepart(departId);
        if (null == orgDepart) {
            throw new ApiException("org.OrgDepartServiceImpl.updateDepartState.orgDepart", "\u6570\u636e\u4e3a\u7a7a");
        }
        if (-1 == dataState) {
            this.delCache(orgDepart);
        } else {
            this.updateCache(orgDepart);
        }
        ArrayList<OrgDepart> list = new ArrayList<OrgDepart>();
        list.add(orgDepart);
        return this.buidPmChannelsend(list, "update");
    }

    private void delCache(OrgDepart orgDepart) {
        if (null == orgDepart) {
            return;
        }
        if (StringUtils.isNotBlank((String)orgDepart.getUserinfoCode())) {
            DisUtil.delMap((String)this.cachekeydomain, (String[])new String[]{orgDepart.getDepartCode() + "-" + orgDepart.getCompanyCode() + "-" + orgDepart.getTenantCode()});
            DisUtil.delMap((String)this.cachekeyinfoDomain, (String[])new String[]{orgDepart.getUserinfoCode() + "-" + orgDepart.getTenantCode()});
        }
        if ("2020050600004084".equals(orgDepart.getTenantCode())) {
            this.queryDepartLoadCache();
        }
    }

    private void updateCache(OrgDepart orgDepart) {
        if (null == orgDepart) {
            return;
        }
        if (StringUtils.isNotBlank((String)orgDepart.getUserinfoCode())) {
            DisUtil.setMap((String)this.cachekeydomain, (String)(orgDepart.getDepartCode() + "-" + orgDepart.getCompanyCode() + "-" + orgDepart.getTenantCode()), (String)orgDepart.getUserinfoCode());
            DisUtil.setMap((String)this.cachekeyinfoDomain, (String)(orgDepart.getUserinfoCode() + "-" + orgDepart.getTenantCode()), (String)orgDepart.getCompanyCode());
        }
        if ("2020050600004084".equals(orgDepart.getTenantCode())) {
            this.queryDepartLoadCache();
        }
    }

    @Override
    public List<OrgChannelsend> updateDepartStateByCode(String tenantCode, String departCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateDepartModelByCode(tenantCode, departCode, dataState, oldDataState);
        OrgDepart orgDepart = this.getDepartByCode(tenantCode, departCode);
        if (null == orgDepart) {
            throw new ApiException("org.OrgDepartServiceImpl.updateDepartStateByCode.orgDepart", "\u6570\u636e\u4e3a\u7a7a");
        }
        if (-1 == dataState) {
            this.delCache(orgDepart);
        } else {
            this.updateCache(orgDepart);
        }
        ArrayList<OrgDepart> list = new ArrayList<OrgDepart>();
        list.add(orgDepart);
        return this.buidPmChannelsend(list, "update");
    }

    @Override
    public List<OrgChannelsend> updateDepart(OrgDepartDomain orgDepartDomain) throws ApiException {
        String msg = this.checkDepart(orgDepartDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("org.OrgDepartServiceImpl.updateDepart.checkDepart", msg);
        }
        OrgDepart oldOrgDepart = this.getDepartModelById(orgDepartDomain.getDepartId());
        if (null == oldOrgDepart) {
            throw new ApiException("org.OrgDepartServiceImpl.updateDepart.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OrgDepart orgDepart = this.makeDepart(orgDepartDomain, oldOrgDepart);
        this.setDepartUpdataDefault(orgDepart);
        this.updateDepartModel(orgDepart);
        this.updateCache(orgDepart);
        ArrayList<OrgDepart> list = new ArrayList<OrgDepart>();
        list.add(orgDepart);
        return this.buidPmChannelsend(list, "update");
    }

    @Override
    public OrgDepart getDepart(Integer departId) {
        return this.getDepartModelById(departId);
    }

    @Override
    public List<OrgChannelsend> deleteDepart(Integer departId) throws ApiException {
        OrgDepart orgDepart = this.getOrgDepart(departId);
        ArrayList<OrgDepart> list = new ArrayList<OrgDepart>();
        list.add(orgDepart);
        return this.buidPmChannelsend(list, "delete");
    }

    @Override
    public QueryResult<OrgDepart> queryDepartPage(Map<String, Object> map) {
        List<OrgDepart> orgDepartList = this.queryDepartModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDepart(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(orgDepartList);
        return queryResult;
    }

    @Override
    public OrgDepart getDepartByCode(String tenantCode, String departCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("departCode", departCode);
        return this.getDepartModelByCode(map);
    }

    @Override
    public List<OrgChannelsend> deleteDepartByCode(String tenantCode, String departCode) throws ApiException {
        OrgDepart orgDepart = this.getOrgDepart(tenantCode, departCode);
        ArrayList<OrgDepart> list = new ArrayList<OrgDepart>();
        list.add(orgDepart);
        return this.buidPmChannelsend(list, "delete");
    }

    @Override
    public List<OrgChannelsend> saveDepartemp(OrgDepartempDomain orgDepartempDomain) throws ApiException {
        OrgDepartemp orgDepartemp = this.getOrgDepartemp(orgDepartempDomain);
        ArrayList<OrgDepartemp> list = new ArrayList<OrgDepartemp>();
        list.add(orgDepartemp);
        return this.buidPmChannelsendStr(list, "insert");
    }

    @Override
    public List<OrgChannelsend> saveDepartempBatch(List<OrgDepartempDomain> orgDepartempDomainList) throws ApiException {
        if (null == orgDepartempDomainList || orgDepartempDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OrgChannelsend> relist = new ArrayList<OrgChannelsend>();
        for (OrgDepartempDomain orgDepartempDomain : orgDepartempDomainList) {
            List<OrgChannelsend> list = this.saveDepartemp(orgDepartempDomain);
            if (!ListUtil.isNotEmpty(list)) continue;
            relist.addAll(list);
        }
        return relist;
    }

    @Override
    public List<OrgChannelsend> updateDepartempState(Integer departempId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateDepartempModel(departempId, dataState, oldDataState);
        OrgDepartemp orgDepartemp = this.getDepartemp(departempId);
        if (-1 == dataState) {
            this.deleteEmpCache(orgDepartemp);
        } else {
            this.updateEmpCache(orgDepartemp);
        }
        ArrayList<OrgDepartemp> list = new ArrayList<OrgDepartemp>();
        list.add(orgDepartemp);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public List<OrgChannelsend> updateDepartempStateByCode(String tenantCode, String departempCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateDepartempModelByCode(tenantCode, departempCode, dataState, oldDataState);
        OrgDepartemp orgDepartemp = this.getDepartempByCode(tenantCode, departempCode);
        if (-1 == dataState) {
            this.deleteEmpCache(orgDepartemp);
        } else {
            this.updateEmpCache(orgDepartemp);
        }
        ArrayList<OrgDepartemp> list = new ArrayList<OrgDepartemp>();
        list.add(orgDepartemp);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public List<OrgChannelsend> updateDepartemp(OrgDepartempDomain orgDepartempDomain) throws ApiException {
        String msg = this.checkDepartemp(orgDepartempDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("org.OrgDepartServiceImpl.updateDepartemp.checkDepartemp", msg);
        }
        OrgDepartemp oldOrgDepartemp = this.getDepartempModelById(orgDepartempDomain.getDepartempId());
        if (null == oldOrgDepartemp) {
            throw new ApiException("org.OrgDepartServiceImpl.updateDepartemp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.deleteEmpCache(oldOrgDepartemp);
        OrgDepartemp orgDepartemp = this.makeDepartemp(orgDepartempDomain, oldOrgDepartemp);
        this.setDepartempUpdataDefault(orgDepartemp);
        this.updateDepartempModel(orgDepartemp);
        this.updateEmpCache(orgDepartemp);
        ArrayList<OrgDepartemp> list = new ArrayList<OrgDepartemp>();
        list.add(orgDepartemp);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public OrgDepartemp getDepartemp(Integer departempId) {
        return this.getDepartempModelById(departempId);
    }

    @Override
    public List<OrgChannelsend> deleteDepartemp(Integer departempId) throws ApiException {
        OrgDepartemp orgDepartemp = this.getDepartemp(departempId);
        this.deleteDepartempModel(departempId);
        QueryResult<OrgDepartemp> queryResult = this.queryDepartempPage(this.getQueryMapParam("tenantCode,employeeCode", new Object[]{orgDepartemp.getTenantCode(), orgDepartemp.getEmployeeCode()}));
        if (ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.orgEmployeeService.updateEmployeeDpByCode(orgDepartemp.getTenantCode(), orgDepartemp.getEmployeeCode(), "0");
        }
        this.deleteEmpCache(orgDepartemp);
        ArrayList<OrgDepartemp> list = new ArrayList<OrgDepartemp>();
        list.add(orgDepartemp);
        return this.buidPmChannelsendStr(list, "delete");
    }

    @Override
    public QueryResult<OrgDepartemp> queryDepartempPage(Map<String, Object> map) {
        List<OrgDepartemp> orgDepartempList = this.queryDepartempModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDepartemp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(orgDepartempList);
        return queryResult;
    }

    @Override
    public OrgDepartemp getDepartempByCode(String tenantCode, String departempCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("departempCode", departempCode);
        return this.getDepartempModelByCode(map);
    }

    @Override
    public List<OrgChannelsend> deleteDepartempByCode(String tenantCode, String departempCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("departempCode", departempCode);
        this.delDepartempModelByCode(map);
        OrgDepartemp orgDepartemp = this.getDepartempByCode(tenantCode, departempCode);
        this.orgEmployeeService.updateEmployeeDpByCode(orgDepartemp.getTenantCode(), orgDepartemp.getEmployeeCode(), "0");
        this.deleteEmpCache(orgDepartemp);
        ArrayList<OrgDepartemp> list = new ArrayList<OrgDepartemp>();
        list.add(orgDepartemp);
        return this.buidPmChannelsendStr(list, "delete");
    }

    private void deleteEmpCache(OrgDepartemp orgDepartemp) {
        if (null == orgDepartemp) {
            return;
        }
        if (StringUtils.isBlank((String)orgDepartemp.getOrgUsercode())) {
            return;
        }
        OrgEmployee orgEmployee = this.orgEmployeeService.getEmployeeByCode(orgDepartemp.getTenantCode(), orgDepartemp.getEmployeeCode());
        if (null == orgEmployee) {
            return;
        }
        String json = DisUtil.getMap((String)this.cachekeyempdomain, (String)(orgEmployee.getUserCode() + "-" + orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode()));
        String str = "";
        if (StringUtils.isNotBlank((String)json)) {
            String[] s;
            for (String string : s = json.split(",")) {
                if (string.equals(this.getUser(orgDepartemp))) continue;
                str = str + "," + string;
            }
        }
        if (StringUtils.isBlank((String)str)) {
            DisUtil.delMap((String)this.cachekeyempdomain, (String[])new String[]{orgEmployee.getUserCode() + "-" + orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode()});
        } else {
            DisUtil.setMapVer((String)this.cachekeyempdomain, (String)(orgEmployee.getUserCode() + "-" + orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode()), (String)str);
        }
    }

    private void updateEmpCache(OrgDepartemp orgDepartemp) {
        if (null == orgDepartemp) {
            return;
        }
        if (StringUtils.isBlank((String)orgDepartemp.getOrgUsercode())) {
            return;
        }
        OrgEmployee orgEmployee = this.orgEmployeeService.getEmployeeByCode(orgDepartemp.getTenantCode(), orgDepartemp.getEmployeeCode());
        if (null == orgEmployee) {
            return;
        }
        String json = DisUtil.getMap((String)this.cachekeyempdomain, (String)(orgEmployee.getUserCode() + "-" + orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode()));
        boolean flag = true;
        if (StringUtils.isNotBlank((String)json)) {
            String[] s;
            for (String string : s = json.split(",")) {
                if (!string.equals(this.getUser(orgDepartemp))) continue;
                flag = false;
            }
            if (flag) {
                json = json + ",";
            }
        } else {
            json = "";
        }
        if (flag) {
            json = json + this.getUser(orgDepartemp);
        }
        DisUtil.setMapVer((String)this.cachekeyempdomain, (String)(orgEmployee.getUserCode() + "-" + orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode()), (String)json);
    }

    @Override
    public void queryDepartLoadCache() {
        this.logger.info("OrgDepartService.queryDepartLoadCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 0);
        List<OrgDepart> departList = this.queryDepartModelPage(parammap);
        if (null == departList || departList.isEmpty()) {
            DisUtil.delVer((String)this.cachekeydomain);
            DisUtil.delVer((String)this.cachekeyinfoDomain);
            DisUtil.delVer((String)this.cachekeyempdomain);
            this.logger.info("OrgDepartService.queryDepartLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> codeMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> infocodeMap = new ConcurrentHashMap<String, String>();
        for (OrgDepart orgDepart : departList) {
            if (StringUtils.isNotBlank((String)orgDepart.getUserinfoCode())) {
                codeMap.put(orgDepart.getDepartCode() + "-" + orgDepart.getCompanyCode() + "-" + orgDepart.getTenantCode(), orgDepart.getUserinfoCode());
                infocodeMap.put(orgDepart.getUserinfoCode() + "-" + orgDepart.getTenantCode(), orgDepart.getCompanyCode());
            }
            if (!"2020050600004084".equals(orgDepart.getTenantCode())) continue;
            String key = orgDepart.getDepartPcode() + "-" + orgDepart.getTenantCode();
            if (codeMap.containsKey(key)) {
                codeMap.put(key, (String)codeMap.get(key) + "," + orgDepart.getDepartCode());
                continue;
            }
            codeMap.put(key, orgDepart.getDepartCode());
        }
        DisUtil.setMapVer((String)this.cachekeydomain, codeMap);
        DisUtil.setMapVer((String)this.cachekeyinfoDomain, infocodeMap);
        this.logger.info("OrgDepartService.queryDepartLoadCache", (Object)"===========add-end==========");
        List<OrgDepartemp> emplist = this.queryDepartempModelPage(parammap);
        if (null == emplist || emplist.isEmpty()) {
            DisUtil.delVer((String)this.cachekeyempdomain);
            this.logger.info("OrgDepartService.queryDepartLoadCache", (Object)"===========delemp-end==========");
            return;
        }
        ConcurrentHashMap<String, String> empcodeMap = new ConcurrentHashMap<String, String>();
        for (OrgDepartemp orgDepartemp : emplist) {
            OrgEmployee orgEmployee;
            if (!StringUtils.isNotBlank((String)orgDepartemp.getOrgUsercode()) || null == (orgEmployee = this.orgEmployeeService.getEmployeeByCode(orgDepartemp.getTenantCode(), orgDepartemp.getEmployeeCode()))) continue;
            String valueorguserStr = (String)empcodeMap.get(orgEmployee.getUserCode() + "-" + orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode());
            valueorguserStr = null == valueorguserStr ? "" : valueorguserStr + ",";
            valueorguserStr = valueorguserStr + this.getUser(orgDepartemp);
            empcodeMap.put(orgEmployee.getUserCode() + "-" + orgEmployee.getUserinfoCode() + "-" + orgEmployee.getTenantCode(), valueorguserStr);
        }
        DisUtil.setMapVer((String)this.cachekeyempdomain, empcodeMap);
        this.logger.info("OrgDepartService.queryDepartLoadCache", (Object)"===========addemp-end==========");
    }

    private String getUser(OrgDepartemp orgDepartemp) {
        if (null == orgDepartemp) {
            return null;
        }
        return orgDepartemp.getOrgUsercode() + "|" + "DEP" + "|" + orgDepartemp.getCompanyCode() + "|" + orgDepartemp.getDepartCode();
    }

    private OrgDepart getOrgDepart(OrgDepartDomain orgDepartDomain) {
        OrgDepart orgDepart = this.createOrgDepart(orgDepartDomain);
        this.saveDepartModel(orgDepart);
        this.updateCache(orgDepart);
        return orgDepart;
    }

    private OrgDepart getOrgDepart(Integer departId) {
        OrgDepart orgDepart = this.getDepart(departId);
        if (null == orgDepart) {
            throw new ApiException("org.OrgDepartServiceImpl.deleteDepart.orgDepart", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.deleteDepartModel(departId);
        this.delCache(orgDepart);
        return orgDepart;
    }

    private OrgDepartemp getOrgDepartemp(OrgDepartempDomain orgDepartempDomain) {
        OrgDepartemp orgDepartemp = this.createOrgDepartemp(orgDepartempDomain);
        this.saveDepartempModel(orgDepartemp);
        this.orgEmployeeService.updateEmployeeDpByCode(orgDepartemp.getTenantCode(), orgDepartemp.getEmployeeCode(), "1");
        this.updateEmpCache(orgDepartemp);
        return orgDepartemp;
    }

    private OrgDepart getOrgDepart(String tenantCode, String departCode) {
        OrgDepart orgDepart = this.getDepartByCode(tenantCode, departCode);
        if (null == orgDepart) {
            throw new ApiException("org.OrgDepartServiceImpl.deleteDepartByCode.orgDepart", "\u6570\u636e\u4e3a\u7a7a");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("departCode", departCode);
        this.delDepartModelByCode(map);
        this.delCache(orgDepart);
        return orgDepart;
    }

    private List<OrgChannelsend> buidPmChannelsend(List<OrgDepart> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<OrgChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<OrgChannelsendDomain> disChannelsendDomainList = new ArrayList<OrgChannelsendDomain>();
        for (OrgDepart promotion : pmPromotionList) {
            OrgChannelsendDomain pmChannelsendDomain = new OrgChannelsendDomain();
            pmChannelsendDomain.setChannelsendOpcode(promotion.getDepartCode());
            pmChannelsendDomain.setChannelsendType("orgDepart");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)promotion));
            pmChannelsendDomain.setTenantCode(promotion.getTenantCode());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.orgChannelsendService.saveSendOrgChannelsendBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    private List<OrgChannelsend> buidPmChannelsendStr(List<OrgDepartemp> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<OrgChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<OrgChannelsendDomain> disChannelsendDomainList = new ArrayList<OrgChannelsendDomain>();
        for (OrgDepartemp promotion : pmPromotionList) {
            OrgChannelsendDomain pmChannelsendDomain = new OrgChannelsendDomain();
            pmChannelsendDomain.setChannelsendOpcode(promotion.getCompanyCode());
            pmChannelsendDomain.setChannelsendType("orgDepartemp");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)promotion));
            pmChannelsendDomain.setTenantCode(promotion.getTenantCode());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.orgChannelsendService.saveSendOrgChannelsendBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    @Override
    public List<OrgDepartReDomain> queryDepartTree(String tenantCode, String companyCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)companyCode)) {
            return null;
        }
        String departPcode = "-1";
        return this.chirdByPcode(tenantCode, departPcode);
    }

    private List<OrgDepartReDomain> chirdByPcode(String tenantCode, String departPcode) {
        List<OrgDepart> orgDepartList = this.queryDepartModelPage(this.getQueryMapParam("departCode,tenantCode", new Object[]{departPcode, tenantCode}));
        return this.makeTreePcode(orgDepartList);
    }

    @Override
    public List<OrgDepartReDomain> queryDepartByPcode(String tenantCode, String departPcode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)departPcode)) {
            return null;
        }
        ArrayList<OrgDepartReDomain> departReDomainList = new ArrayList<OrgDepartReDomain>();
        this.makeUpTreeByPCode(departReDomainList, tenantCode, departPcode);
        return departReDomainList;
    }

    private void makeUpTreeByPCode(List<OrgDepartReDomain> departReDomainList, String tenantCode, String departPcode) {
        OrgDepart depart = this.getDepartByCode(tenantCode, departPcode);
        if (depart != null) {
            OrgDepartReDomain orgDepartReDomain = new OrgDepartReDomain();
            try {
                BeanUtils.copyAllPropertys((Object)orgDepartReDomain, (Object)depart);
            }
            catch (Exception exception) {
                // empty catch block
            }
            departReDomainList.add(orgDepartReDomain);
            if (StringUtils.isNotBlank((String)orgDepartReDomain.getDepartPcode())) {
                this.makeUpTreeByPCode(departReDomainList, tenantCode, orgDepartReDomain.getDepartPcode());
            }
        }
    }

    @Override
    public String getDepartCodeByEmployeeCode(String tenantCode, String employeeCode) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("employeeCode", employeeCode);
        List<OrgDepartemp> orgDepartemps = this.queryDepartempModelPage(paramMap);
        if (ListUtil.isNotEmpty(orgDepartemps)) {
            return orgDepartemps.get(0).getDepartCode();
        }
        return "";
    }

    private List<OrgDepartReDomain> chird(String tenantCode, String companyCode, String departPcode) {
        List<OrgDepart> orgDepartList = this.queryDepartModelPage(this.getQueryMapParam("companyCode,departPcode,tenantCode", new Object[]{companyCode, departPcode, tenantCode}));
        return this.makeTree(orgDepartList);
    }

    private List<OrgDepartReDomain> makeTreePcode(List<OrgDepart> orgDepartList) {
        if (ListUtil.isEmpty(orgDepartList)) {
            return null;
        }
        ArrayList<OrgDepartReDomain> orgDepartReDomainList = new ArrayList<OrgDepartReDomain>();
        for (OrgDepart orgDepart : orgDepartList) {
            OrgDepartReDomain orgDepartReDomain = this.makeReDomainPcode(orgDepart);
            if (null == orgDepartReDomain) continue;
            orgDepartReDomainList.add(orgDepartReDomain);
        }
        return orgDepartReDomainList;
    }

    private OrgDepartReDomain makeReDomainPcode(OrgDepart orgDepart) {
        if (null == orgDepart) {
            return null;
        }
        OrgDepartReDomain orgDepartReDomain = new OrgDepartReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)orgDepartReDomain, (Object)orgDepart);
            orgDepartReDomain.setOrgDepartempReDomainList(this.makeEmp(orgDepart.getTenantCode(), orgDepart.getDepartCode()));
            orgDepartReDomain.setChileOrgDepartReDomainList(this.chirdByPcode(orgDepart.getTenantCode(), orgDepart.getDepartPcode()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return orgDepartReDomain;
    }

    private List<OrgDepartReDomain> makeTree(List<OrgDepart> orgDepartList) {
        if (ListUtil.isEmpty(orgDepartList)) {
            return null;
        }
        ArrayList<OrgDepartReDomain> orgDepartReDomainList = new ArrayList<OrgDepartReDomain>();
        for (OrgDepart orgDepart : orgDepartList) {
            OrgDepartReDomain orgDepartReDomain = this.makeReDomain(orgDepart);
            if (null == orgDepartReDomain) continue;
            orgDepartReDomainList.add(orgDepartReDomain);
        }
        return orgDepartReDomainList;
    }

    private OrgDepartReDomain makeReDomain(OrgDepart orgDepart) {
        if (null == orgDepart) {
            return null;
        }
        OrgDepartReDomain orgDepartReDomain = new OrgDepartReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)orgDepartReDomain, (Object)orgDepart);
            orgDepartReDomain.setOrgDepartempReDomainList(this.makeEmp(orgDepart.getTenantCode(), orgDepart.getDepartCode()));
            orgDepartReDomain.setChileOrgDepartReDomainList(this.chird(orgDepart.getTenantCode(), orgDepart.getCompanyCode(), orgDepart.getDepartCode()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return orgDepartReDomain;
    }

    private List<OrgDepartempReDomain> makeEmp(String tenantCode, String departCode) {
        List<OrgDepartemp> orgDepartempList = this.queryDepartempModelPage(this.getQueryMapParam("departCode,tenantCode", new Object[]{departCode, tenantCode}));
        return this.makeEmpReDomain(orgDepartempList);
    }

    private List<OrgDepartempReDomain> makeEmpReDomain(List<OrgDepartemp> orgDepartempList) {
        if (ListUtil.isEmpty(orgDepartempList)) {
            return null;
        }
        ArrayList<OrgDepartempReDomain> orgDepartempReDomainList = new ArrayList<OrgDepartempReDomain>();
        for (OrgDepartemp orgDepartemp : orgDepartempList) {
            OrgDepartempReDomain orgDepartempReDomain = this.makeempReDomain(orgDepartemp);
            if (null == orgDepartempReDomain) continue;
            orgDepartempReDomainList.add(orgDepartempReDomain);
        }
        return orgDepartempReDomainList;
    }

    private OrgDepartempReDomain makeempReDomain(OrgDepartemp orgDepartemp) {
        if (null == orgDepartemp) {
            return null;
        }
        OrgDepartempReDomain orgDepartempReDomain = new OrgDepartempReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)orgDepartempReDomain, (Object)orgDepartemp);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return orgDepartempReDomain;
    }

    private void updateUserinfoCode(String tenantCode, String departCode, String userinfoCode) {
        if (StringUtils.isBlank((String)departCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("departCode", departCode);
        map.put("userinfoCode", userinfoCode);
        int i = 0;
        try {
            i = this.orgDepartMapper.updateUserinfoCodeByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartServiceImpl.updateUserinfoCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgDepartServiceImpl.updateUserinfoCode.null", ((Object)map).toString());
        }
    }

    @Override
    public List<OrgChannelsend> updateUserinfoCodeByCode(String tenantCode, String departCode, String userinfoCode) throws ApiException {
        this.updateUserinfoCode(tenantCode, departCode, userinfoCode);
        OrgDepart orgDepart = this.getDepartByCode(tenantCode, departCode);
        if (null == orgDepart) {
            throw new ApiException("org.OrgDepartServiceImpl.updateUserinfoCodeByCode.orgDepart", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.updateCache(orgDepart);
        ArrayList<OrgDepart> list = new ArrayList<OrgDepart>();
        list.add(orgDepart);
        return this.buidPmChannelsend(list, "update");
    }

    @Override
    public void updatedepartPcode(Map<String, Object> map) throws ApiException {
        int i = 0;
        try {
            i = this.orgDepartMapper.updatedepartPcode(map);
        }
        catch (Exception e) {
            throw new ApiException("org.OrgDepartServiceImpl.updatedepartPcode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("org.OrgDepartServiceImpl.updatedepartPcode.null", map.toString());
        }
    }

    public static void main(String[] args) {
        String code = "466330185703510016";
        System.out.println(Long.valueOf(code));
        System.out.println(Integer.MAX_VALUE);
    }
}

