/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.eq.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.eq.domain.EqAuctionDomain;
import com.qjsoft.laser.controller.facade.eq.domain.EqAuctionGoodsDomain;
import com.qjsoft.laser.controller.facade.eq.domain.EqAuctionReDomain;
import com.qjsoft.laser.controller.facade.eq.repository.EqAuctionEnrollServiceRepository;
import com.qjsoft.laser.controller.facade.eq.repository.EqAuctionFileServiceRepository;
import com.qjsoft.laser.controller.facade.eq.repository.EqAuctionGinfoServiceRepository;
import com.qjsoft.laser.controller.facade.eq.repository.EqAuctionServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/eq/auction"}, name="\u8be2\u4ef7\u9700\u6c42")
public class AuctionCon
extends SpringmvcController {
    private static String CODE = "eq.auction.con";
    @Autowired
    private EqAuctionFileServiceRepository eqAuctionFileServiceRepository;
    @Autowired
    private EqAuctionEnrollServiceRepository eqAuctionEnrollServiceRepository;
    @Autowired
    private EqAuctionGinfoServiceRepository eqAuctionGinfoServiceRepository;
    @Autowired
    private EqAuctionServiceRepository eqAuctionServiceRepository;

    protected String getContext() {
        return "auction";
    }

    @RequestMapping(value={"saveAuction.json"}, name="\u589e\u52a0\u8be2\u4ef7\u9700\u6c42")
    @ResponseBody
    public HtmlJsonReBean saveAuction(HttpServletRequest request, EqAuctionReDomain eqAuctionReDomain) {
        UserSession userSession;
        this.logger.error(CODE + ".saveAuction----param-----", (Object)eqAuctionReDomain);
        if (null == eqAuctionReDomain) {
            this.logger.error(CODE + ".saveAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (null == eqAuctionReDomain) {
            this.logger.error(CODE + ".eqAuctionReDomain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (null != eqAuctionReDomain) {
            eqAuctionReDomain.setTenantCode(this.getTenantCode(request));
        }
        if (null != (userSession = this.getUserSession(request))) {
            eqAuctionReDomain.setMemberName(userSession.getUserRelname());
            eqAuctionReDomain.setMemberCode(userSession.getUserCode());
        }
        return this.eqAuctionServiceRepository.saveAuction(eqAuctionReDomain);
    }

    @RequestMapping(value={"getAuction.json"}, name="\u83b7\u53d6\u8be2\u4ef7\u9700\u6c42\u4fe1\u606f")
    @ResponseBody
    public EqAuctionReDomain getAuction(Integer auctionId) {
        if (StringUtils.isBlank((Integer)auctionId)) {
            this.logger.error(CODE + ".getAuction", (Object)"param is null");
            return null;
        }
        EqAuctionReDomain eqAuctionReDomain = this.eqAuctionServiceRepository.getAuction(auctionId);
        if (eqAuctionReDomain != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("auctionCode", eqAuctionReDomain.getAuctionCode());
            map.put("tenantCode", eqAuctionReDomain.getTenantCode());
            map.put("fuzzy", false);
            List fileList = null;
            List ginfoList = null;
            List enrollList = null;
            fileList = this.eqAuctionFileServiceRepository.queryAuctionFilePage(map).getList();
            if (fileList != null && fileList.size() != 0) {
                eqAuctionReDomain.setEqAuctionFileDomainList(fileList);
            }
            if ((ginfoList = this.eqAuctionGinfoServiceRepository.queryAuctionGinfoPage(map).getList()) != null && ginfoList.size() != 0) {
                eqAuctionReDomain.setEqAuctionGinfoDomainList(ginfoList);
            }
            if ((enrollList = this.eqAuctionEnrollServiceRepository.queryAuctionEnrollPage(map).getList()) != null && enrollList.size() != 0) {
                eqAuctionReDomain.setEqAuctionEnrollReDomainList(enrollList);
            }
        }
        return eqAuctionReDomain;
    }

    @RequestMapping(value={"updateAuction.json"}, name="\u66f4\u65b0\u8be2\u4ef7\u9700\u6c42")
    @ResponseBody
    public HtmlJsonReBean updateAuction(HttpServletRequest request, EqAuctionDomain eqAuctionDomain) {
        if (null == eqAuctionDomain) {
            this.logger.error(CODE + ".updateAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        eqAuctionDomain.setTenantCode(this.getTenantCode(request));
        return this.eqAuctionServiceRepository.updateAuction(eqAuctionDomain);
    }

    @RequestMapping(value={"deleteAuction.json"}, name="\u5220\u9664\u8be2\u4ef7\u9700\u6c42")
    @ResponseBody
    public HtmlJsonReBean deleteAuction(Integer auctionId) {
        if (StringUtils.isBlank((Integer)auctionId)) {
            this.logger.error(CODE + ".deleteAuction", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.eqAuctionServiceRepository.deleteAuction(auctionId);
    }

    @RequestMapping(value={"queryAuctionPage.json"}, name="\u67e5\u8be2\u8be2\u4ef7\u9700\u6c42\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<EqAuctionReDomain> queryAuctionPage(HttpServletRequest request) {
        SupQueryResult eqAuctionReDomain;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if ((eqAuctionReDomain = this.eqAuctionServiceRepository.queryAuctionPage(param)).getList() != null && eqAuctionReDomain.getList().size() != 0) {
            for (EqAuctionReDomain eq : eqAuctionReDomain.getList()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("auctionCode", eq.getAuctionCode());
                map.put("tenantCode", eq.getTenantCode());
                map.put("fuzzy", false);
                this.logger.error(CODE + ".eqAuctionReDomain", (Object)("map:" + map.toString()));
                List fileList = null;
                List ginfoList = null;
                List enrollList = null;
                fileList = this.eqAuctionFileServiceRepository.queryAuctionFilePage(map).getList();
                if (fileList != null && fileList.size() != 0) {
                    eq.setEqAuctionFileDomainList(fileList);
                }
                if ((ginfoList = this.eqAuctionGinfoServiceRepository.queryAuctionGinfoPage(map).getList()) != null && ginfoList.size() != 0) {
                    eq.setEqAuctionGinfoDomainList(ginfoList);
                }
                if ((enrollList = this.eqAuctionEnrollServiceRepository.queryAuctionEnrollPage(map).getList()) == null || enrollList.size() == 0) continue;
                eq.setEqAuctionEnrollReDomainList(enrollList);
            }
        }
        return eqAuctionReDomain;
    }

    @RequestMapping(value={"updateAuctionState.json"}, name="\u66f4\u65b0\u8be2\u4ef7\u9700\u6c42\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAuctionState(String auctionId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.eqAuctionServiceRepository.updateAuctionState(Integer.valueOf(auctionId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"priceRanks.json"}, name="\u4ef7\u683c\u6392\u884c\u5217\u8868")
    @ResponseBody
    public EqAuctionReDomain priceRanks(String auctionId) {
        if (StringUtils.isBlank((String)auctionId)) {
            this.logger.error(CODE + ".updateAuctionState", (Object)"param is null");
            return null;
        }
        return this.eqAuctionServiceRepository.priceRanks(Integer.valueOf(auctionId));
    }

    @RequestMapping(value={"saveAuctionAward.json"}, name="\u6388\u6807")
    @ResponseBody
    public HtmlJsonReBean saveAuctionAward(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".saveAuctionAward", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List eqAuctionGoodsDomainList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(paramStr, EqAuctionGoodsDomain.class);
        if (ListUtil.isEmpty((Collection)eqAuctionGoodsDomainList)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "list is null");
        }
        return this.eqAuctionServiceRepository.saveAuctionAward(eqAuctionGoodsDomainList);
    }
}

