/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.resources;

import cn.com.qj.bff.common.bean.DisChannel;
import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.core.util.HtmlUtil;
import cn.com.qj.bff.domain.rs.RsBrandDomain;
import cn.com.qj.bff.domain.rs.RsBrandReDomain;
import cn.com.qj.bff.domain.rs.RsBrandRelationReDomain;
import cn.com.qj.bff.domain.rs.RsResourceGoodsReDomain;
import cn.com.qj.bff.domain.um.UmUserinfoQuaDomain;
import cn.com.qj.bff.domain.um.UmUserinfoQuaReDomain;
import cn.com.qj.bff.interceptor.service.BaseInterUtil;
import cn.com.qj.bff.service.dis.DisChannelService;
import cn.com.qj.bff.service.rs.RsBrandRelationService;
import cn.com.qj.bff.service.rs.RsBrandService;
import cn.com.qj.bff.service.rs.RsResourceGoodsService;
import cn.com.qj.bff.service.um.UmUserinfoQuaService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/brand"}, name="\u5546\u54c1\u54c1\u724c")
public class RsBrandCon
extends SpringmvcController {
    private static String CODE = "rs.brand.con";
    @Autowired
    private RsBrandService rsBrandService;
    @Autowired
    private RsResourceGoodsService rsResourceGoodsService;
    @Autowired
    private RsBrandRelationService rsBrandRelationService;
    @Autowired
    private DisChannelService disChannelService;
    @Autowired
    private UmUserinfoQuaService umUserinfoQuaService;
    protected static String TYPE_PLAT = "plat";
    protected static String TYPE_BUS = "bus";
    protected static String TYPE_USER = "user";

    @Override
    protected String getContext() {
        return "brand";
    }

    @RequestMapping(value={"saveBrand.json"}, name="\u589e\u52a0\u5546\u54c1\u54c1\u724c")
    @ResponseBody
    public HtmlJsonReBean saveBrand(HttpServletRequest request, RsBrandDomain rsBrandDomain) {
        return this.saveBrand(request, rsBrandDomain, null);
    }

    @RequestMapping(value={"saveBrandForPlat.json"}, name="\u589e\u52a0\u5546\u54c1\u54c1\u724c(\u5e73\u53f0)")
    @ResponseBody
    public HtmlJsonReBean saveBrandForPlat(HttpServletRequest request, RsBrandDomain rsBrandDomain) {
        return this.saveBrand(request, rsBrandDomain, TYPE_PLAT);
    }

    @RequestMapping(value={"saveBrandForUser.json"}, name="\u589e\u52a0\u5546\u54c1\u54c1\u724c(\u7528\u6237)")
    @ResponseBody
    public HtmlJsonReBean saveBrandForUser(HttpServletRequest request, RsBrandDomain rsBrandDomain) {
        return this.saveBrand(request, rsBrandDomain, TYPE_USER);
    }

    private HtmlJsonReBean saveBrand(HttpServletRequest request, RsBrandDomain rsBrandDomain, String type) {
        if (null == rsBrandDomain) {
            this.logger.error(CODE + ".saveBrand", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (StringUtils.isBlank((String)type)) {
            DisChannel disChannel;
            if (this.checkMemquaPlat(request)) {
                rsBrandDomain.setMemberCode(this.getTeananMemberCode(request));
                rsBrandDomain.setMemberName("\u5e73\u53f0");
            } else {
                rsBrandDomain.setMemberCode(userSession.getUserPcode());
                rsBrandDomain.setMemberName(userSession.getMerberCompname());
            }
            if (StringUtils.isNotBlank((String)rsBrandDomain.getMemberCode()) && null != (disChannel = this.getChannelByMemRe(rsBrandDomain.getMemberCode(), request))) {
                rsBrandDomain.setGoodsClass(disChannel.getGoodsClass());
            }
        } else if (TYPE_PLAT.equals(type)) {
            rsBrandDomain.setMemberCode(this.getTeananMemberCode(request));
            rsBrandDomain.setMemberName("\u5e73\u53f0");
        } else if (TYPE_BUS.equals(type)) {
            if (StringUtils.isNotBlank((String)userSession.getUserinfoParentCode())) {
                rsBrandDomain.setMemberCode(userSession.getUserinfoParentCode());
                rsBrandDomain.setMemberName(userSession.getUserinfoParentName());
            } else {
                rsBrandDomain.setMemberCode(userSession.getUserPcode());
                rsBrandDomain.setMemberName(userSession.getMerberCompname());
            }
        } else if (TYPE_USER.equals(type)) {
            rsBrandDomain.setMemberCode(userSession.getUserPcode());
            rsBrandDomain.setMemberName(userSession.getMerberCompname());
        }
        rsBrandDomain.setTenantCode(this.getTenantCode(request));
        rsBrandDomain.setChannelCode(BaseInterUtil.getChannelCode((HttpServletRequest)request));
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", rsBrandDomain.getTenantCode());
        param.put("memberCode", rsBrandDomain.getMemberCode());
        param.put("brandName", rsBrandDomain.getBrandName());
        param.put("goodsClass", "B2B");
        SupQueryResult<RsBrandReDomain> result = this.rsBrandService.queryBrandPage(param);
        if (null != result && ListUtil.isNotEmpty((Collection)result.getList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u54c1\u724c\u91cd\u590d");
        }
        rsBrandDomain.setGoodsClass("B2B");
        this.makeChannel(rsBrandDomain, request);
        return this.rsBrandService.saveBrand(rsBrandDomain);
    }

    private void makeChannel(RsBrandDomain rsBrandDomain, HttpServletRequest request) {
        if (null == rsBrandDomain || null == request) {
            return;
        }
        String memberCode = rsBrandDomain.getMemberCode();
        if (StringUtils.isBlank((String)memberCode)) {
            return;
        }
        DisChannel disChannel = this.getChannelByMemRe(memberCode, request);
        if (null == disChannel) {
            return;
        }
        rsBrandDomain.setChannelCode(disChannel.getChannelCode());
        rsBrandDomain.setChannelName(disChannel.getChannelName());
    }

    @RequestMapping(value={"getBrand.json"}, name="\u83b7\u53d6\u5546\u54c1\u54c1\u724c\u4fe1\u606f")
    @ResponseBody
    public RsBrandDomain getBrand(String brandId) {
        if (StringUtils.isBlank((String)brandId)) {
            this.logger.error(CODE + ".getBrand", (Object)"param is null");
            return null;
        }
        return this.rsBrandService.getBrand(Integer.valueOf(brandId));
    }

    @RequestMapping(value={"updateBrand.json"}, name="\u7f16\u8f91\u5546\u54c1\u54c1\u724c")
    @ResponseBody
    public HtmlJsonReBean updateBrand(HttpServletRequest request, RsBrandDomain rsBrandDomain) {
        if (null == rsBrandDomain) {
            this.logger.error(CODE + ".updateBrand", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsBrandDomain.setTenantCode(this.getTenantCode(request));
        rsBrandDomain.setChannelCode(BaseInterUtil.getChannelCode((HttpServletRequest)request));
        return this.rsBrandService.updateBrand(rsBrandDomain);
    }

    @RequestMapping(value={"deleteBrand.json"}, name="\u5220\u9664\u5546\u54c1\u54c1\u724c")
    @ResponseBody
    public HtmlJsonReBean deleteBrand(HttpServletRequest request, String brandId) {
        if (StringUtils.isBlank((String)brandId)) {
            this.logger.error(CODE + ".deleteBrand", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RsBrandReDomain brandReDomain = this.rsBrandService.getBrand(Integer.valueOf(brandId));
        String brandCode = brandReDomain.getBrandCode();
        if (StringUtils.isBlank((String)brandCode)) {
            this.logger.error(CODE + ".deleteBrand", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("brandCode", brandCode);
        param.put("tenantCode", this.getTenantCode(request));
        param.put("channelCode", BaseInterUtil.getChannelCode((HttpServletRequest)request));
        param.put("fuzzy", true);
        param.put("validFlag", true);
        SupQueryResult<RsResourceGoodsReDomain> rsResourceGoodsReDomainSupQueryResult = this.rsResourceGoodsService.queryResourceGoodsPage(param);
        SupQueryResult<RsBrandRelationReDomain> brandRelationReDomainSupQueryResult = this.rsBrandRelationService.queryBrandRelationPage(param);
        if (null != rsResourceGoodsReDomainSupQueryResult.getList() && rsResourceGoodsReDomainSupQueryResult.getList().size() > 0 || null != brandRelationReDomainSupQueryResult.getList() && brandRelationReDomainSupQueryResult.getList().size() > 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u54c1\u724c\u4f7f\u7528\u4e2d");
        }
        return this.rsBrandService.deleteBrand(Integer.valueOf(brandId));
    }

    @RequestMapping(value={"queryBrandPageForDis.json"}, name="\u5206\u9500\u5546\u7528\u6237\u54c1\u724c")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandPageForDis(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        param.put("memberCode", userSession.getUserPcode());
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBrandPage.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868(\u5206\u9875)")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapMemberParam(request);
        param.remove("memberCode");
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBrandPageByUser.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868(\u5206\u9875)")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandPageByUser(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        param.put("memberCode", userSession.getUserPcode());
        param.put("channelCode", BaseInterUtil.getChannelCode((HttpServletRequest)request));
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBrandPageForCms.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868(\u5206\u9875)")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandPageForCms(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBrandPageForSh.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868(\u5206\u9875)-\u5206\u9500")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandPageForSh(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBrandFromFdRel.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868(\u5206\u9875)-\u798f\u70b9\u53d1\u5e03")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandFromFdRel(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBrandFromXnRel.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868(\u5206\u9875)-\u865a\u62df\u53d1\u5e03")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandFromXnRel(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBrandFromFdEdit.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868(\u5206\u9875)-\u798f\u70b9\u7f16\u8f91")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandFromFdEdit(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBrandFromXnEdit.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868(\u5206\u9875)-\u865a\u62df\u7f16\u8f91")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandFromXnEdit(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBrandFromTcEdit.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868(\u5206\u9875)-\u5957\u9910\u7f16\u8f91")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandFromTcEdit(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBrandFromGysEdit.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868(\u5206\u9875)-\u4f9b\u5e94\u5546\u7f16\u8f91")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandFromGysEdit(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBrandPageFromC.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868(\u5206\u9875)- C\u7aef")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandPageFromC(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBrandFromGoodsClass.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868- \u865a\u62df\u5206\u7c7b\u9875")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandFromGoodsClass(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.queryBrandMain(param, request);
    }

    private SupQueryResult<RsBrandReDomain> queryBrandMain(Map<String, Object> param, HttpServletRequest request) {
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        this.logger.error(CODE + "queryBrandMain" + JsonUtil.buildNormalBinder().toJson(param));
        String goodsClass = (String)this.assemMapParam(request).get("goodsClass");
        String channelCode = this.getChannelByMem(this.getMerchantCode(request), request);
        param.put("channelCode", channelCode);
        if (StringUtils.isNotBlank((String)goodsClass) && StringUtils.isBlank((String)channelCode)) {
            this.logger.error(CODE + ".queryBrandMain.goodsClass");
            return null;
        }
        return this.rsBrandService.queryBrandPage(param);
    }

    private SupQueryResult<RsBrandReDomain> queryBrandMainByMemberCode(Map<String, Object> param, HttpServletRequest request) {
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        String memberCode = BaseInterUtil.getMemberCode((HttpServletRequest)request);
        param.put("memberCode", memberCode);
        if (StringUtils.isBlank((String)memberCode)) {
            this.logger.error(CODE + ".queryBrandMain.goodsClass");
            return null;
        }
        return this.rsBrandService.queryBrandPage(param);
    }

    @RequestMapping(value={"updateBrandState.json"}, name="\u7f16\u8f91\u5546\u54c1\u54c1\u724c\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateBrandState(String brandId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)brandId)) {
            this.logger.error(CODE + ".updateBrandState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsBrandService.updateBrandState(Integer.valueOf(brandId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryBrandFromMsc.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868-\u9891\u9053\u5217\u8868")
    @ResponseBody
    public List<RsBrandReDomain> queryBrandFromMsc(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        SupQueryResult<RsBrandReDomain> qlist = this.queryBrandMain(param, request);
        if (null == qlist) {
            return null;
        }
        return qlist.getList();
    }

    @RequestMapping(value={"queryBrandFromDisGys.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868-\u6e20\u9053\u4f9b\u5e94\u5546")
    @ResponseBody
    public List<RsBrandReDomain> queryBrandFromDisGys(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        SupQueryResult<RsBrandReDomain> qlist = this.queryBrandMain(param, request);
        if (null == qlist) {
            return null;
        }
        return qlist.getList();
    }

    @RequestMapping(value={"queryBrandFromDisGysBySer.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868-\u6e20\u9053\u4f9b\u5e94\u5546 - \u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public List<RsBrandReDomain> queryBrandFromDisGysBySer(HttpServletRequest request) {
        HashMap<String, Object> param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null == param) {
            param = new HashMap<String, Object>();
        }
        String goodsClass = (String)this.assemMapParam(request).get("goodsClass");
        String channelCode = this.getChannelByMem(this.getMerchantCode(request), request);
        param.put("channelCode", channelCode);
        if (StringUtils.isNotBlank((String)goodsClass) && StringUtils.isBlank((String)channelCode)) {
            this.logger.error(CODE + ".queryBrandMain.goodsClass");
            return null;
        }
        String tenantCode = String.valueOf(param.get("tenantCode"));
        if (null == tenantCode || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".queryBrandFromDisGysBySer", (Object)"param is null");
            return null;
        }
        param.put("order", true);
        SupQueryResult<RsBrandReDomain> supQueryResult = this.rsBrandService.queryBrandPage(param);
        if (null == supQueryResult || null == supQueryResult.getList()) {
            this.logger.error(CODE + ".queryBrandFromDisGysBySer", (Object)"result is null");
            return null;
        }
        return supQueryResult.getList();
    }

    @RequestMapping(value={"queryBrandFromDisZx.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868-\u6e20\u9053\u76f4\u9500")
    @ResponseBody
    public List<RsBrandReDomain> queryBrandFromDisZx(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        SupQueryResult<RsBrandReDomain> qlist = this.queryBrandMain(param, request);
        if (null == qlist) {
            return null;
        }
        return qlist.getList();
    }

    @RequestMapping(value={"queryBrandFromDisSale.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868-\u9500\u552e\u6e20\u9053")
    @ResponseBody
    public List<RsBrandReDomain> queryBrandFromDisSale(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        SupQueryResult<RsBrandReDomain> qlist = this.queryBrandMain(param, request);
        if (null == qlist) {
            return null;
        }
        return qlist.getList();
    }

    @RequestMapping(value={"queryBrandFromDisStore.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868-\u95e8\u5e97\u6e20\u9053")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandFromDisStore(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBraFromDisZxBySer.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868-\u6e20\u9053\u76f4\u9500 - \u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public List<RsBrandReDomain> queryBraFromDisZxBySer(HttpServletRequest request) {
        HashMap<String, Object> param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null == param) {
            param = new HashMap<String, Object>();
        }
        String goodsClass = (String)this.assemMapParam(request).get("goodsClass");
        String channelCode = this.getChannelByMem(this.getMerchantCode(request), request);
        param.put("channelCode", channelCode);
        if (StringUtils.isNotBlank((String)goodsClass) && StringUtils.isBlank((String)channelCode)) {
            this.logger.error(CODE + ".queryBrandMain.goodsClass");
            return null;
        }
        String tenantCode = String.valueOf(param.get("tenantCode"));
        if (null == tenantCode || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".queryBrandFromDisGysBySer", (Object)"param is null");
            return null;
        }
        param.put("order", true);
        SupQueryResult<RsBrandReDomain> supQueryResult = this.rsBrandService.queryBrandPage(param);
        if (null == supQueryResult || null == supQueryResult.getList()) {
            this.logger.error(CODE + ".queryBrandFromDisGysBySer", (Object)"result is null");
            return null;
        }
        return supQueryResult.getList();
    }

    @RequestMapping(value={"queryBrandFromQy.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868-\u6743\u76ca")
    @ResponseBody
    public List<RsBrandReDomain> queryBrandFromQy(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        SupQueryResult<RsBrandReDomain> qlist = this.queryBrandMain(param, request);
        if (null == qlist) {
            return null;
        }
        return qlist.getList();
    }

    @RequestMapping(value={"queryBrandFromRs.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868-\u6bcd\u5b50\u5546\u54c1")
    @ResponseBody
    public List<RsBrandReDomain> queryBrandFromRs(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        SupQueryResult<RsBrandReDomain> qlist = this.queryBrandMain(param, request);
        if (null == qlist) {
            return null;
        }
        return qlist.getList();
    }

    @RequestMapping(value={"queryBrandFromQyForPlat.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868-\u6743\u76ca\u7ed9\u5e73\u53f0")
    @ResponseBody
    public List<RsBrandReDomain> queryBrandFromQyForPlat(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        SupQueryResult<RsBrandReDomain> qlist = this.queryBrandMain(param, request);
        if (null == qlist) {
            return null;
        }
        return qlist.getList();
    }

    @RequestMapping(value={"queryBrandFromTc.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868-\u5957\u9910\u5546\u54c1")
    @ResponseBody
    public List<RsBrandReDomain> queryBrandFromTc(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        SupQueryResult<RsBrandReDomain> qlist = this.queryBrandMain(param, request);
        if (null == qlist) {
            return null;
        }
        return qlist.getList();
    }

    @RequestMapping(value={"checkBrandName.json"}, name="\u68c0\u67e5\u5546\u54c1\u540d\u79f0")
    @ResponseBody
    public RsBrandReDomain checkBrandName(HttpServletRequest request, String brandName) {
        if (StringUtils.isBlank((String)brandName)) {
            this.logger.error(CODE + ".checkBrandName", (Object)"\u53c2\u6570\u4e3a\u7a7a");
            return null;
        }
        return this.rsBrandService.getBrandByName(brandName, this.getTenantCode(request));
    }

    private List<RsBrandReDomain> queryBrandMain(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        param.put("order", true);
        String goodsClass = (String)this.assemMapParam(request).get("goodsClass");
        String channelCode = this.getChannelByMem(this.getMerchantCode(request), request);
        param.put("channelCode", channelCode);
        if (StringUtils.isNotBlank((String)goodsClass) && StringUtils.isBlank((String)channelCode)) {
            this.logger.error(CODE + ".queryBrandMain.goodsClass");
            return null;
        }
        this.makeDefPage(param);
        SupQueryResult<RsBrandReDomain> supQueryResult = this.rsBrandService.queryBrandPage(param);
        if (null == supQueryResult || null == supQueryResult.getList()) {
            return null;
        }
        return supQueryResult.getList();
    }

    @RequestMapping(value={"queryBrandPageForC.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868(\u5206\u9875-C\u7aef)")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandPageForC(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBrandPageByMem.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandPageByMem(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapMemberParam(request);
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"queryBrandPageForRet.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868-\u5206\u9500\u5546")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandPageForRet(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapMemberParam(request);
        return this.queryBrandMain(param, request);
    }

    @RequestMapping(value={"brandStateStop.json"}, name="\u7f16\u8f91\u5546\u54c1\u54c1\u724c\u72b6\u6001-\u505c\u7528")
    @ResponseBody
    public HtmlJsonReBean brandStateStop(String brandId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)brandId)) {
            this.logger.error(CODE + ".updateBrandState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsBrandService.updateBrandState(Integer.valueOf(brandId), -1, 0);
    }

    @RequestMapping(value={"brandStateStart.json"}, name="\u7f16\u8f91\u5546\u54c1\u54c1\u724c\u72b6\u6001-\u542f\u7528")
    @ResponseBody
    public HtmlJsonReBean brandStateStart(String brandId) {
        if (StringUtils.isBlank((String)brandId)) {
            this.logger.error(CODE + ".updateBrandState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsBrandService.updateBrandState(Integer.valueOf(brandId), 0, -1);
    }

    @RequestMapping(value={"brandStateStartEdit.json"}, name="\u7f16\u8f91\u5546\u54c1\u54c1\u724c\u72b6\u6001-\u542f\u7528\u63a5\u53e32")
    @ResponseBody
    public HtmlJsonReBean brandStateStartEdit(String brandId) {
        if (StringUtils.isBlank((String)brandId)) {
            this.logger.error(CODE + ".updateBrandState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsBrandService.updateBrandState(Integer.valueOf(brandId), 0, -1);
    }

    @RequestMapping(value={"queryBrandPageByDisRetail.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868-\u5206\u9500\u5546\u6e20\u9053")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandPageByDisRetail(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapMemberParam(request);
        return this.queryBrandMainByMemberCode(param, request);
    }

    @RequestMapping(value={"queryBrandPageStr.json"}, name="\u5546\u54c1\u54c1\u724c\u5217\u8868(\u5206\u9875)")
    @ResponseBody
    public SupQueryResult<RsBrandReDomain> queryBrandPageStr(HttpServletRequest request, String memberBcode) {
        Map<String, Object> param = this.assemMapParam(request);
        param.put("order", true);
        UserSession session = this.getUserSession(request);
        if (null == session || StringUtils.isBlank((String)memberBcode)) {
            this.logger.error(CODE + ".queryBrandPage.session", (Object)("memberBcode:" + memberBcode));
            return new SupQueryResult();
        }
        param.put("userinfoCode", memberBcode);
        param.put("userinfoQuaVaule1", "1");
        param.put("userinfoQuaUrl1", session.getUserPcode());
        SupQueryResult<UmUserinfoQuaReDomain> userinfoQuaPage = this.umUserinfoQuaService.queryUserinfoQuaPage(param);
        if (null == userinfoQuaPage || ListUtil.isEmpty((Collection)userinfoQuaPage.getList())) {
            this.logger.error(CODE + ".queryBrandPage.userinfoQuaPage", param);
            return new SupQueryResult();
        }
        String userKeys = userinfoQuaPage.getList().stream().map(UmUserinfoQuaDomain::getUserinfoQuaKey).collect(Collectors.joining(","));
        param.put("brandCode", userKeys);
        return this.rsBrandService.queryBrandPage(param);
    }
}

