/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.dis;

import cn.com.qj.bff.common.bean.DisChannel;
import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.core.util.HtmlUtil;
import cn.com.qj.bff.domain.dis.DisChannelDomain;
import cn.com.qj.bff.domain.dis.DisChannelReDomain;
import cn.com.qj.bff.domain.dis.DisDgoodsDomain;
import cn.com.qj.bff.domain.dis.DisDgoodsReDomain;
import cn.com.qj.bff.domain.dis.DisDgoodsScopelistDomain;
import cn.com.qj.bff.domain.dis.DisDgoodsScopelistReDomain;
import cn.com.qj.bff.domain.msc.MscMschannelReDomain;
import cn.com.qj.bff.domain.org.OrgCompanyReDomain;
import cn.com.qj.bff.domain.org.OrgDepartReDomain;
import cn.com.qj.bff.domain.um.UmUserinfoReDomainBean;
import cn.com.qj.bff.interceptor.service.BaseInterUtil;
import cn.com.qj.bff.service.dis.DisChannelService;
import cn.com.qj.bff.service.dis.DisChannelsendBaseService;
import cn.com.qj.bff.service.dis.DisDgoodsService;
import cn.com.qj.bff.service.msc.MscMschannelService;
import cn.com.qj.bff.service.org.OrgCompanyService;
import cn.com.qj.bff.service.org.OrgDepartService;
import cn.com.qj.bff.service.um.UserService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/dis/channel"}, name="\u6e20\u9053\u5b9a\u4e49")
public class ChannelCon
extends SpringmvcController {
    private static String CODE = "dis.channel.con";
    @Autowired
    private DisChannelService disChannelService;
    @Autowired
    private DisChannelsendBaseService disChannelsendBaseService;
    @Autowired
    private DisDgoodsService disDgoodsService;
    @Autowired
    private MscMschannelService mscMschannelService;
    @Autowired
    private UserService userService;
    @Autowired
    private InternalRouter internalRouter;
    @Autowired
    private OrgCompanyService orgCompanyService;
    @Autowired
    private OrgDepartService orgDepartService;
    private String cacheDgoods = "DisDgoods-channelCode";
    private String cacheScopelist = "DisDgoodsScopelist-DgoodsCode";
    static String KEY = "SEND_DGOODS_RELEASE";

    @Override
    protected String getContext() {
        return "channel";
    }

    @RequestMapping(value={"updateChannel.json"}, name="\u66f4\u65b0\u6e20\u9053\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean updateChannel(HttpServletRequest request, DisChannelDomain disChannelDomain) {
        if (null == disChannelDomain) {
            this.logger.error(CODE + ".updateChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateChannelMain(this.getTenantCode(request), disChannelDomain);
    }

    @RequestMapping(value={"updateChannelSale.json"}, name="\u66f4\u65b0\u9500\u552e\u6e20\u9053\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean updateChannelSale(HttpServletRequest request, DisChannelDomain disChannelDomain) {
        if (null == disChannelDomain) {
            this.logger.error(CODE + ".updateChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateChannelMain(this.getTenantCode(request), disChannelDomain);
    }

    @RequestMapping(value={"updateChannelStore.json"}, name="\u66f4\u65b0\u95e8\u5e97\u6e20\u9053\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean updateChannelStore(HttpServletRequest request, DisChannelDomain disChannelDomain) {
        if (null == disChannelDomain) {
            this.logger.error(CODE + ".updateChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateChannelMain(this.getTenantCode(request), disChannelDomain);
    }

    @RequestMapping(value={"updateChannelBySer.json"}, name="\u66f4\u65b0\u6e20\u9053\u5b9a\u4e49-\u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public HtmlJsonReBean updateChannelBySer(HttpServletRequest request, DisChannelDomain disChannelDomain) {
        if (null == disChannelDomain) {
            this.logger.error(CODE + ".updateChannelBySer", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateChannelMain(this.getTenantCode(request), disChannelDomain);
    }

    @RequestMapping(value={"updateChannelFromZx.json"}, name="\u66f4\u65b0\u6e20\u9053\u5b9a\u4e49-\u76f4\u9500")
    @ResponseBody
    public HtmlJsonReBean updateChannelFromZx(HttpServletRequest request, DisChannelDomain disChannelDomain) {
        if (null == disChannelDomain) {
            this.logger.error(CODE + ".updateChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateChannelMain(this.getTenantCode(request), disChannelDomain);
    }

    @RequestMapping(value={"updateChaFromZxBySer.json"}, name="\u66f4\u65b0\u6e20\u9053\u5b9a\u4e49-\u76f4\u9500-\u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public HtmlJsonReBean updateChaFromZxBySer(HttpServletRequest request, DisChannelDomain disChannelDomain) {
        if (null == disChannelDomain) {
            this.logger.error(CODE + ".updateChaFromZxBySer", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateChannelMain(this.getTenantCode(request), disChannelDomain);
    }

    private HtmlJsonReBean updateChannelMain(String tenantCode, DisChannelDomain disChannelDomain) {
        if (null == disChannelDomain) {
            this.logger.error(CODE + ".updateChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        disChannelDomain.setTenantCode(tenantCode);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("channelName", disChannelDomain.getChannelName());
        SupQueryResult<DisChannelReDomain> supQueryResult = this.disChannelService.queryChannelPage(map);
        if (null != supQueryResult && null != supQueryResult.getList() && supQueryResult.getList().size() > 0 && !((DisChannelReDomain)supQueryResult.getList().get(0)).getChannelId().equals(disChannelDomain.getChannelId())) {
            this.logger.error(CODE + ".updateChannel", (Object)"\u6e20\u9053\u540d\u79f0\u5df2\u5b58\u5728\uff0c \u8bf7\u91cd\u65b0\u586b\u5199");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6e20\u9053\u540d\u79f0\u5df2\u5b58\u5728\uff0c \u8bf7\u91cd\u65b0\u586b\u5199");
        }
        return this.disChannelService.updateChannel(disChannelDomain);
    }

    @RequestMapping(value={"enableChannel.json"}, name="\u542f\u7528\u6e20\u9053")
    @ResponseBody
    public HtmlJsonReBean enableChannel(String channelId) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".enableChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateDateStateMain(Integer.valueOf(channelId), 0, -1);
    }

    @RequestMapping(value={"disconChannel.json"}, name="\u505c\u7528\u6e20\u9053")
    @ResponseBody
    public HtmlJsonReBean disconChannel(String channelId) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".disconChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateDateStateMain(Integer.valueOf(channelId), -1, 0);
    }

    @RequestMapping(value={"enableChannelSale.json"}, name="\u542f\u7528\u9500\u552e\u6e20\u9053")
    @ResponseBody
    public HtmlJsonReBean enableChannelSale(String channelId) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".enableChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateDateStateMain(Integer.valueOf(channelId), 0, -1);
    }

    @RequestMapping(value={"disconChannelSale.json"}, name="\u505c\u7528\u9500\u552e\u6e20\u9053")
    @ResponseBody
    public HtmlJsonReBean disconChannelSale(String channelId) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".disconChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateDateStateMain(Integer.valueOf(channelId), -1, 0);
    }

    @RequestMapping(value={"enableChannelStore.json"}, name="\u542f\u7528\u95e8\u5e97\u6e20\u9053")
    @ResponseBody
    public HtmlJsonReBean enableChannelStore(String channelId) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".enableChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateDateStateMain(Integer.valueOf(channelId), 0, -1);
    }

    @RequestMapping(value={"disconChannelStore.json"}, name="\u505c\u7528\u95e8\u5e97\u6e20\u9053")
    @ResponseBody
    public HtmlJsonReBean disconChannelStore(String channelId) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".disconChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateDateStateMain(Integer.valueOf(channelId), -1, 0);
    }

    @RequestMapping(value={"enableChannelBySer.json"}, name="\u542f\u7528\u6e20\u9053-\u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public HtmlJsonReBean enableChannelBySer(String channelId) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".enableChannelBySer", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateDateStateMain(Integer.valueOf(channelId), 0, -1);
    }

    @RequestMapping(value={"disconChannelBySer.json"}, name="\u505c\u7528\u6e20\u9053-\u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public HtmlJsonReBean disconChannelBySer(String channelId) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".disconChannelBySer", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateDateStateMain(Integer.valueOf(channelId), -1, 0);
    }

    @RequestMapping(value={"enableChannelFromZx.json"}, name="\u542f\u7528\u6e20\u9053-\u76f4\u9500")
    @ResponseBody
    public HtmlJsonReBean enableChannelFromZx(String channelId) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".enableChannelZx", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateDateStateMain(Integer.valueOf(channelId), 0, -1);
    }

    @RequestMapping(value={"disconChannelFromZx.json"}, name="\u505c\u7528\u6e20\u9053-\u76f4\u9500")
    @ResponseBody
    public HtmlJsonReBean disconChannelFromZx(String channelId) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".disconChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateDateStateMain(Integer.valueOf(channelId), -1, 0);
    }

    @RequestMapping(value={"enableChaFromZxBySer.json"}, name="\u542f\u7528\u6e20\u9053-\u76f4\u9500-\u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public HtmlJsonReBean enableChaFromZxBySer(String channelId) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".enableChaFromZxBySer", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateDateStateMain(Integer.valueOf(channelId), 0, -1);
    }

    @RequestMapping(value={"disconChaFromZxBySer.json"}, name="\u505c\u7528\u6e20\u9053-\u76f4\u9500-\u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public HtmlJsonReBean disconChaFromZxBySer(String channelId) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".disconChaFromZxBySer", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateDateStateMain(Integer.valueOf(channelId), -1, 0);
    }

    private HtmlJsonReBean updateDateStateMain(Integer id, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((Integer)id)) {
            this.logger.error(CODE + ".updateDateStateMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disChannelService.updateChannelState((int)id, dataState, oldDataState);
    }

    @RequestMapping(value={"queryChannelPage.json"}, name="\u67e5\u8be2\u6e20\u9053\u5b9a\u4e49\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelSort", "1");
        return this.disChannelService.queryChannelPage(param);
    }

    @RequestMapping(value={"queryChannelPageSale.json"}, name="\u67e5\u8be2\u9500\u552e\u6e20\u9053\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelPageSale(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelSort", "0");
        return this.disChannelService.queryChannelPage(param);
    }

    @RequestMapping(value={"queryChannelPageStore.json"}, name="\u67e5\u8be2\u7c7b\u578b\u662f\u95e8\u5e97\u7684\u6e20\u9053\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelPageStore(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelType", "1");
        return this.disChannelService.queryChannelPage(param);
    }

    @RequestMapping(value={"queryChannelBySer.json"}, name="\u67e5\u8be2\u6e20\u9053\u5b9a\u4e49\u5206\u9875\u5217\u8868-\u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelBySer(HttpServletRequest request) {
        HashMap<String, Object> param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null == param) {
            param = new HashMap<String, Object>();
        }
        param.put("order", true);
        param.put("fuzzy", true);
        return this.disChannelService.queryChannelPage(param);
    }

    @RequestMapping(value={"queryChannelFromConfigPageSale.json"}, name="\u9500\u552e\u6e20\u9053\u5b9a\u4e49\u5206\u9875\u5217\u8868 - \u6e20\u9053\u53d1\u5e03\u8bbe\u7f6e\u9875\u9762")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelFromConfigPageSale(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelSort", "0");
        return this.disChannelService.queryChannelPage(param);
    }

    @RequestMapping(value={"queryChannelFromConfigPageStore.json"}, name="\u95e8\u5e97\u6e20\u9053\u5b9a\u4e49\u5206\u9875\u5217\u8868 - \u6e20\u9053\u53d1\u5e03\u8bbe\u7f6e\u9875\u9762")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelFromConfigPageStore(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelType", "1");
        return this.disChannelService.queryChannelPage(param);
    }

    @RequestMapping(value={"queryChannelFromConfigPage.json"}, name="\u6e20\u9053\u5b9a\u4e49\u5206\u9875\u5217\u8868 - \u6e20\u9053\u53d1\u5e03\u8bbe\u7f6e\u9875\u9762")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelFromConfigPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelSort", "1");
        return this.disChannelService.queryChannelPage(param);
    }

    @RequestMapping(value={"queryChaFromConfigBySer.json"}, name="\u6e20\u9053\u5b9a\u4e49\u5206\u9875\u5217\u8868 - \u6e20\u9053\u53d1\u5e03\u8bbe\u7f6e\u9875\u9762 - \u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChaFromConfigBySer(HttpServletRequest request) {
        HashMap<String, Object> param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null == param) {
            param = new HashMap<String, Object>();
        }
        param.put("order", true);
        param.put("fuzzy", true);
        param.put("channelSort", "1");
        return this.disChannelService.queryChannelPage(param);
    }

    @RequestMapping(value={"queryChannelPageFromZx.json"}, name="\u67e5\u8be2\u6e20\u9053\u5b9a\u4e49\u5206\u9875\u5217\u8868-\u76f4\u9500")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelPageFromZx(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelSort", "2");
        return this.disChannelService.queryChannelPage(param);
    }

    @RequestMapping(value={"queryChaFromZxBySer.json"}, name="\u67e5\u8be2\u6e20\u9053\u5b9a\u4e49\u5206\u9875\u5217\u8868-\u76f4\u9500-\u6280\u672f\u4e2d\u53f0")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChaFromZxBySer(HttpServletRequest request) {
        HashMap<String, Object> param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null == param) {
            param = new HashMap<String, Object>();
        }
        param.put("order", true);
        param.put("fuzzy", true);
        param.put("channelSort", "2");
        return this.disChannelService.queryChannelPage(param);
    }

    @RequestMapping(value={"queryChannelFromConfigPageZx.json"}, name="\u6e20\u9053\u5b9a\u4e49\u5206\u9875\u5217\u8868 - \u6e20\u9053\u53d1\u5e03\u8bbe\u7f6e\u9875\u9762-\u76f4\u9500")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelFromConfigPageFromZx(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelSort", "2");
        return this.disChannelService.queryChannelPage(param);
    }

    @RequestMapping(value={"saveChannel.json"}, name="\u589e\u52a0\u6e20\u9053\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean saveChannel(HttpServletRequest request, DisChannelDomain disChannelDomain) {
        if (null == disChannelDomain) {
            this.logger.error(CODE + ".saveChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        disChannelDomain.setTenantCode(this.getTenantCode(request));
        return this.disChannelService.saveChannel(disChannelDomain);
    }

    @RequestMapping(value={"updateChannelState.json"}, name="\u66f4\u65b0\u6e20\u9053\u5b9a\u4e49\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateChannelState(String channelId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)channelId)) {
            this.logger.error(CODE + ".updateChannelState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disChannelService.updateChannelState(Integer.valueOf(channelId), dataState, oldDataState);
    }

    @RequestMapping(value={"deleteChannel.json"}, name="\u5220\u9664\u6e20\u9053\u5b9a\u4e49")
    @ResponseBody
    public HtmlJsonReBean deleteChannel(Integer channelId) {
        if (StringUtils.isBlank((Integer)channelId)) {
            this.logger.error(CODE + ".deleteChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disChannelService.deleteChannel(channelId);
    }

    @RequestMapping(value={"getChannel.json"}, name="\u83b7\u53d6\u6e20\u9053\u5b9a\u4e49\u4fe1\u606f")
    @ResponseBody
    public DisChannelReDomain getChannel(Integer channelId) {
        if (StringUtils.isBlank((Integer)channelId)) {
            this.logger.error(CODE + ".getChannel", (Object)"param is null");
            return null;
        }
        return this.disChannelService.getChannel(channelId);
    }

    @RequestMapping(value={"getMscByDisChaCode.json"}, name="\u6839\u636e\u6e20\u9053\u53d6\u9891\u9053")
    @ResponseBody
    public List<MscMschannelReDomain> getMscChannelByDisCha(HttpServletRequest request) {
        String channelCode = this.getNowChannel(request);
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isBlank((String)channelCode)) {
            return null;
        }
        Map<String, Object> scopeMap = this.getDgoodsScopeList(channelCode, tenantCode);
        if (null == scopeMap) {
            return null;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("order", true);
        param.put("fuzzy", true);
        param.put("tenantCode", tenantCode);
        SupQueryResult<MscMschannelReDomain> supQueryResult = this.mscMschannelService.queryMschannelPage(param);
        if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
            return null;
        }
        ArrayList<MscMschannelReDomain> reDomains = new ArrayList<MscMschannelReDomain>();
        for (MscMschannelReDomain mscMschannelReDomain : supQueryResult.getList()) {
            if (!mscMschannelReDomain.getMschannelCode().equals(scopeMap.get(mscMschannelReDomain.getMschannelCode()))) continue;
            reDomains.add(mscMschannelReDomain);
        }
        return ListUtil.isEmpty(reDomains) ? null : reDomains;
    }

    private Map<String, Object> getDgoodsScopeList(String channelCode, String tenantCode) {
        DisDgoodsReDomain disDgoods = (DisDgoodsReDomain)SupDisUtil.getMapJson((String)"DisDgoods-channelCode", (String)(channelCode + "-" + tenantCode), DisDgoodsReDomain.class);
        if (null == disDgoods) {
            return null;
        }
        List disDgoodsScopeLists = SupDisUtil.getMapListJson((String)"DisDgoodsScopelist-DgoodsCode", (String)(disDgoods.getDgoodsCode() + "-" + tenantCode), DisDgoodsScopelistReDomain.class);
        if (ListUtil.isEmpty((Collection)disDgoodsScopeLists)) {
            return null;
        }
        HashMap<String, Object> reMap = new HashMap<String, Object>();
        for (DisDgoodsScopelistReDomain dgsl : disDgoodsScopeLists) {
            reMap.put(dgsl.getDgoodsScopelistValue(), dgsl.getDgoodsScopelistValue());
        }
        return reMap;
    }

    @RequestMapping(value={"queryChannelThirdParty.json"}, name="\u6e20\u9053\u5b9a\u4e49\u5206\u9875\u5217\u8868 - \u7ed1\u5b9a\u5e97\u94fa")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelThirdParty(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelType", "2");
        return this.disChannelService.queryChannelPage(param);
    }

    @RequestMapping(value={"querySaleChannel.json"}, name="\u67e5\u8be2\u9500\u552e\u7c7b\u7684\u6e20\u9053(\u9500\u552e\u548c\u76f4\u9500)")
    @ResponseBody
    public List<DisChannelReDomain> querySaleChannel(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null == param) {
            return null;
        }
        param.put("channelSort", "0");
        ArrayList<DisChannelReDomain> relist = new ArrayList<DisChannelReDomain>();
        SupQueryResult<DisChannelReDomain> saleList = this.disChannelService.queryChannelPage(param);
        if (null != saleList && ListUtil.isNotEmpty((Collection)saleList.getList())) {
            relist.addAll(saleList.getList());
        }
        param.put("channelSort", "2");
        SupQueryResult<DisChannelReDomain> qList = this.disChannelService.queryChannelPage(param);
        if (null != qList && ListUtil.isNotEmpty((Collection)qList.getList())) {
            relist.addAll(qList.getList());
        }
        return relist;
    }

    @RequestMapping(value={"queryThirdPpartyChannel.json"}, name="\u67e5\u8be2\u7b2c\u4e09\u65b9\u6e20\u9053")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryThirdPpartyChannel(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        param.put("channelType", "2");
        param.put("channelSort", "0");
        return this.disChannelService.queryChannelPage(param);
    }

    @RequestMapping(value={"getUrl.json"}, name="\u83b7\u53d6\u6388\u6743\u8df3\u8f6c\u9875\u9762\u8def\u7531")
    @ResponseBody
    public HtmlJsonReBean getUrl(HttpServletRequest request, String channelCode, String memberCode) {
        String url = this.disChannelService.getUrl(channelCode, memberCode, this.getTenantCode(request));
        return new HtmlJsonReBean((Object)url);
    }

    @RequestMapping(value={"queryChannelPageBySS.json"}, name="\u67e5\u8be2\u4e0a\u852c\u6e20\u9053\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelPageBySS(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapPlatParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        String channelType = String.valueOf(param.get("channelType"));
        String channelSort = String.valueOf(param.get("channelSort"));
        param.put("channelType", channelType + ",0");
        param.put("channelSort", channelSort + ",0");
        param.put("memberCode", BaseInterUtil.getMemberCode((HttpServletRequest)request));
        return this.disChannelService.queryChannelPage(param);
    }

    @RequestMapping(value={"queryChannelPageA.json"}, name="\u67e5\u8be2\u4e0a\u852c\u6e20\u9053\u5546\u54c1\u5206\u9875\u5217\u8868A")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelPageA(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParamMHMpMprice(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if ("0".equals(String.valueOf(param.get("channelSort"))) && "0".equals(String.valueOf(param.get("channelType")))) {
            param.remove("channelSort");
            param.remove("channelType");
        }
        param.put("memberCode", BaseInterUtil.getMemberCode((HttpServletRequest)request));
        return this.disChannelService.queryChannelPage(param);
    }

    @RequestMapping(value={"queryChannelPageBySSStr.json"}, name="\u67e5\u8be2\u4e0a\u852c\u6e20\u9053\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelPageBySSStr(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
        }
        param.put("goodsClass", "B2B");
        return this.disChannelService.queryChannelPage(param);
    }

    @RequestMapping(value={"querySaleChannelPage.json"}, name="\u67e5\u8be2\u7528\u6237\u4e0b\u7684\u9500\u552e\u6e20\u9053\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> querySaleChannelPage(HttpServletRequest request) {
        Map<String, Object> param = this.getMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", false);
        }
        param.put("channelCode", BaseInterUtil.getChannelCode((HttpServletRequest)request));
        this.logger.error(CODE + ".querySaleChannelPage.param", (Object)param.toString());
        return this.disChannelService.queryChannelPage(param);
    }

    @RequestMapping(value={"queryChannelPageByMemberMoce.json"}, name="\u5f53\u524d\u767b\u5f55\u8005\u4e0b\u7ea7\u9500\u552e\u6e20\u9053\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryChannelPageByMemberMoce(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        UserSession userSession = this.getUserSession(request);
        param.put("memberMcode", userSession.getUserPcode());
        param.put("channelSort", "0");
        return this.disChannelService.queryChannelPage(param);
    }

    @RequestMapping(value={"saveChannelEx.json"}, name="\u6267\u884c\u6e20\u9053\u89c4\u5219")
    @ResponseBody
    public HtmlJsonReBean saveChannelEx(HttpServletRequest request, String channelCode) {
        if (StringUtils.isBlank((String)channelCode)) {
            this.logger.error(CODE + ".saveChannelEx", (Object)"param is null");
            return null;
        }
        return this.disChannelsendBaseService.sendSaveDgoodsUpdate(channelCode, this.getTenantCode(request));
    }

    @RequestMapping(value={"queryCompanyLoadCache.json"}, name="\u6267\u884c\u6e20\u9053\u89c4\u5219")
    @ResponseBody
    public HtmlJsonReBean queryCompanyLoadCache() {
        return this.disChannelService.queryChannelLoadCache();
    }

    @RequestMapping(value={"saveDealerChannel.json"}, name="\u589e\u52a0\u7ecf\u9500\u5546\u6e20\u9053")
    @ResponseBody
    public HtmlJsonReBean saveDealerChannel(HttpServletRequest request, String disChannelDomainJson) {
        if (null == disChannelDomainJson) {
            this.logger.error(CODE + ".saveDealerChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        DisChannelDomain disChannelDomain = (DisChannelDomain)JsonUtil.buildNormalBinder().getJsonToObject(disChannelDomainJson, DisChannelDomain.class);
        UserSession userSession = this.getUserSession(request);
        String tenantCode = this.getTenantCode(request);
        disChannelDomain.setTenantCode(tenantCode);
        disChannelDomain.setChannelType("3");
        disChannelDomain.setChannelSort("3");
        disChannelDomain.setProappCode(this.getProappCode(request));
        disChannelDomain.setMemberCode(userSession.getUserPcode());
        disChannelDomain.setMemberName(userSession.getUserName());
        UmUserinfoReDomainBean umUserinfo = this.userService.getUserinfoByCode(userSession.getUserPcode(), tenantCode);
        disChannelDomain.setMemberMcode(userSession.getUserPcode());
        disChannelDomain.setMemberMname(umUserinfo.getUserinfoCompname());
        return this.disChannelService.saveChannel(disChannelDomain);
    }

    @RequestMapping(value={"saveChannelByStr.json"}, name="\u589e\u52a0\u7ecf\u9500\u5546\u6e20\u9053")
    @ResponseBody
    public DisChannelReDomain saveChannelByStr(HttpServletRequest request, String channelByStr) {
        if (null == channelByStr) {
            this.logger.error(CODE + ".saveChannelByStr", (Object)"param is null");
            return null;
        }
        DisChannelDomain disChannelDomain = (DisChannelDomain)JsonUtil.buildNormalBinder().getJsonToObject(channelByStr, DisChannelDomain.class);
        UserSession userSession = this.getUserSession(request);
        String tenantCode = this.getTenantCode(request);
        disChannelDomain.setTenantCode(tenantCode);
        disChannelDomain.setChannelType("11");
        disChannelDomain.setChannelSort("11");
        disChannelDomain.setProappCode(this.getProappCode(request));
        disChannelDomain.setMemberCode(userSession.getUserPcode());
        disChannelDomain.setMemberName(userSession.getUserName());
        UmUserinfoReDomainBean umUserinfo = this.userService.getUserinfoByCode(userSession.getUserPcode(), tenantCode);
        disChannelDomain.setMemberMcode(userSession.getUserPcode());
        disChannelDomain.setMemberMname(umUserinfo.getUserinfoCompname());
        disChannelDomain.setChannelPcode(this.getProappChannel(request));
        disChannelDomain.setGoodsClass("B2B-DEA");
        disChannelDomain.setChannelMcode("3");
        disChannelDomain.setChannelCcode("1");
        disChannelDomain.setDgoodsBm("0");
        disChannelDomain.setDgoodsCl("0");
        disChannelDomain.setChanneltempCode("0005");
        HtmlJsonReBean htmlJsonReBean = this.disChannelService.saveChannel(disChannelDomain);
        DisChannelReDomain channelByCode = this.disChannelService.getChannelByCode(tenantCode, htmlJsonReBean.getDataObj().toString());
        return channelByCode;
    }

    @RequestMapping(value={"updateChannelByStr.json"}, name="\u589e\u52a0\u7ecf\u9500\u5546\u6e20\u9053")
    @ResponseBody
    public DisChannelReDomain updateChannelByStr(HttpServletRequest request, String channelByStr) {
        if (null == channelByStr) {
            this.logger.error(CODE + ".updateChannelByStr", (Object)"param is null");
            return null;
        }
        DisChannelDomain disChannelDomain = (DisChannelDomain)JsonUtil.buildNormalBinder().getJsonToObject(channelByStr, DisChannelDomain.class);
        UserSession userSession = this.getUserSession(request);
        String tenantCode = this.getTenantCode(request);
        disChannelDomain.setTenantCode(tenantCode);
        disChannelDomain.setChannelType("11");
        disChannelDomain.setChannelSort("11");
        disChannelDomain.setProappCode(this.getProappCode(request));
        disChannelDomain.setMemberCode(userSession.getUserPcode());
        disChannelDomain.setMemberName(userSession.getUserName());
        UmUserinfoReDomainBean umUserinfo = this.userService.getUserinfoByCode(userSession.getUserPcode(), tenantCode);
        disChannelDomain.setMemberMcode(userSession.getUserPcode());
        disChannelDomain.setMemberMname(umUserinfo.getUserinfoCompname());
        HtmlJsonReBean htmlJsonReBean = this.disChannelService.updateChannel(disChannelDomain);
        DisChannelReDomain channelByCode = this.disChannelService.getChannelByCode(tenantCode, htmlJsonReBean.getDataObj().toString());
        return channelByCode;
    }

    @RequestMapping(value={"updateDealerChannel.json"}, name="\u66f4\u65b0\u7ecf\u9500\u5546\u6e20\u9053")
    @ResponseBody
    public HtmlJsonReBean updateDealerChannel(HttpServletRequest request, String disChannelDomainJson) {
        if (null == disChannelDomainJson) {
            this.logger.error(CODE + ".saveDealerChannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        DisChannelDomain disChannelDomain = (DisChannelDomain)JsonUtil.buildNormalBinder().getJsonToObject(disChannelDomainJson, DisChannelDomain.class);
        UserSession userSession = this.getUserSession(request);
        String tenantCode = this.getTenantCode(request);
        disChannelDomain.setTenantCode(tenantCode);
        disChannelDomain.setChannelType("3");
        disChannelDomain.setChannelSort("3");
        disChannelDomain.setProappCode(this.getProappCode(request));
        disChannelDomain.setMemberCode(userSession.getUserPcode());
        disChannelDomain.setMemberName(userSession.getUserName());
        UmUserinfoReDomainBean umUserinfo = this.userService.getUserinfoByCode(userSession.getUserPcode(), tenantCode);
        disChannelDomain.setMemberMcode(userSession.getUserPcode());
        disChannelDomain.setMemberMname(umUserinfo.getUserinfoCompname());
        return this.disChannelService.updateChannel(disChannelDomain);
    }

    @RequestMapping(value={"queryDealerChannelPage.json"}, name="\u7ecf\u9500\u5546\u6e20\u9053\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryDealerChannelPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelType", "3");
        param.put("channelSort", "3");
        return this.disChannelService.queryChannelPage(param);
    }

    @RequestMapping(value={"deleteDealerChannelByCode.json"}, name="\u5220\u9664\u7ecf\u9500\u5546\u6e20\u9053")
    @ResponseBody
    public HtmlJsonReBean deleteDealerChannelByCode(HttpServletRequest request, String channelCode) {
        if (StringUtils.isBlank((String)channelCode)) {
            this.logger.error(CODE + ".deleteDealerChannelByCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disChannelService.deleteChannelByCode(this.getTenantCode(request), channelCode);
    }

    @RequestMapping(value={"querySaveDealerChannelPage.json"}, name="\u67e5\u8be2\u6e20\u9053\u5206\u9875\u5217\u8868\uff08\u6dfb\u52a0\u7ecf\u9500\u5546\uff09")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> querySaveDealerChannelPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelType", "3");
        param.put("channelSort", "3");
        return this.disChannelService.queryChannelPage(param);
    }

    @RequestMapping(value={"querySaleChannelStr.json"}, name="\u67e5\u8be2\u56fd\u5bb6\u6e20\u9053")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> querySaleChannelStr(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null == param) {
            return null;
        }
        param.put("channelSort", "8");
        return this.disChannelService.queryChannelPage(param);
    }

    @RequestMapping(value={"sendSaveDgoodsUpdate.json"}, name="\u6e20\u9053\u540c\u6b65\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean sendSaveDgoodsUpdate(HttpServletRequest request, String channelCode) {
        Map jsonToMap;
        Date nowTime;
        if (StringUtils.isBlank((String)channelCode)) {
            this.logger.error(CODE + ".sendSaveDgoodsUpdate", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Date endTime = nowTime = new Date();
        String key = "sendSaveDgoodsUpdatecache";
        String jsons = SupDisUtil.getMap((String)key, (String)(this.getTenantCode(request) + "-" + channelCode));
        if (StringUtils.isNotBlank((String)jsons) && MapUtil.isNotEmpty((Map)(jsonToMap = JsonUtil.buildNormalBinder().getJsonToMap(jsons, String.class, String.class)))) {
            this.logger.error(CODE + ".data--------------|||||   " + jsonToMap.get("dataState"));
            String dataState = (String)jsonToMap.get("dataState");
            Object time = jsonToMap.get("time");
            if (null != time) {
                Long times = Long.valueOf(String.valueOf(time));
                endTime = new Date(times);
            }
            if (StringUtils.isNotBlank((String)dataState) && "0".equals(dataState) && endTime.compareTo(nowTime) > 0) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u70b9\u51fb");
            }
        }
        Integer cacheSize = 0;
        Map mapAll = SupDisUtil.getMapAll((String)this.cacheDgoods);
        String dgoodsJson = (String)mapAll.get(channelCode + "-" + this.getTenantCode(request));
        DisDgoodsDomain dgoodsDomain = (DisDgoodsDomain)JsonUtil.buildNormalBinder().getJsonToObject(dgoodsJson, DisDgoodsDomain.class);
        StringBuffer stringBuffer = new StringBuffer();
        if (null != dgoodsDomain) {
            Map mapAll1 = SupDisUtil.getMapAll((String)(this.cacheScopelist + "-" + dgoodsDomain.getDgoodsCode() + "-" + dgoodsDomain.getTenantCode()));
            int i = 1;
            if (MapUtil.isNotEmpty((Map)mapAll1)) {
                cacheSize = mapAll1.size();
                for (String k : mapAll1.keySet()) {
                    DisDgoodsScopelistDomain scopelistReDomain = (DisDgoodsScopelistDomain)JsonUtil.buildNormalBinder().getJsonToObject((String)mapAll1.get(k), DisDgoodsScopelistDomain.class);
                    stringBuffer.append(scopelistReDomain.getDgoodsScopelistValue());
                    if (i < mapAll1.size()) {
                        stringBuffer.append(",");
                    }
                    ++i;
                }
            }
        } else {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "dgoodsDomain is null");
        }
        hashMap.put("dataState", "0");
        String saveDgoodsTime = this.getDdFalgSetting(this.getTenantCode(request), "saveDgoodsTime", "saveDgoodsTime", "");
        if (StringUtils.isNotBlank((String)saveDgoodsTime)) {
            hashMap.put("time", String.valueOf(new Date().getTime() + Long.parseLong(saveDgoodsTime) * 1000L));
        }
        String json = JsonUtil.buildNormalBinder().toJson(hashMap);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startRow", 0);
        map.put("endRow", 0);
        map.put("dgoodsCode", dgoodsDomain.getDgoodsCode());
        map.put("tenantCode", dgoodsDomain.getTenantCode());
        SupQueryResult<DisDgoodsScopelistReDomain> disDgoodsScopelistReDomainSupQueryResult1 = this.disDgoodsService.queryDgoodsScopelistPage(map);
        SupDisUtil.setMap((String)key, (String)(this.getTenantCode(request) + "-" + channelCode), (String)json);
        return this.disChannelsendBaseService.sendSaveDgoodsUpdate(channelCode, this.getTenantCode(request));
    }

    @RequestMapping(value={"sendDgoodsRelease.json"}, name="\u6e20\u90533.0\u53d1\u5e03")
    @ResponseBody
    public HtmlJsonReBean sendDgoodsRelease(HttpServletRequest request, String channelCode) {
        if (StringUtils.isBlank((String)channelCode)) {
            this.logger.error(CODE + ".sendDgoodsRelease", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String status = SupDisUtil.get((String)(KEY + this.getTenantCode(request) + "-" + channelCode));
        if (StringUtils.isNotBlank((String)status) && status.equals("0")) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53d1\u5e03\u4e2d,\u8bf7\u52ff\u91cd\u590d\u70b9\u51fb");
        }
        SupDisUtil.set((String)(KEY + this.getTenantCode(request) + "-" + channelCode), (String)"0");
        String batchCode = this.createUUIDString();
        this.logger.info(CODE + ".sendDgoodsRelease.\u6279\u6b21\u53f7", (Object)batchCode);
        HtmlJsonReBean htmlJsonReBean = this.disChannelsendBaseService.sendDgoodsRelease(channelCode, this.getTenantCode(request), batchCode);
        return htmlJsonReBean;
    }

    @RequestMapping(value={"getReleaseState.json"}, name="\u83b7\u53d6\u6e20\u9053\u53d1\u5e03\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean getReleaseState(HttpServletRequest request, String channelCode) {
        if (StringUtils.isBlank((String)channelCode)) {
            this.logger.error(CODE + ".getReleaseState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String status = SupDisUtil.get((String)(KEY + this.getTenantCode(request) + "-" + channelCode));
        if (status == null) {
            status = "-1";
        }
        return new HtmlJsonReBean("success", status);
    }

    public String getRedisValue(String key) {
        String redisValue = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)key);
        return redisValue;
    }

    public String getDdFalgSetting(String tenantCode, String flagSettingType, String flagSettingCode, String appmanageIcode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType + appmanageIcode).concat("-").concat(flagSettingCode + appmanageIcode);
        String value = this.getRedisValue(field);
        return value;
    }

    @RequestMapping(value={"getCompanyByChannelCode.json"}, name="\u901a\u8fc7\u6e20\u9053Code\u83b7\u53d6\u516c\u53f8\u4ee3\u7801")
    @ResponseBody
    public List<OrgCompanyReDomain> getCompanyByChannelCode(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        String channelCode = (String)param.get("channelCode");
        if (StringUtils.isBlank((String)channelCode)) {
            return null;
        }
        String strMemberCode = (String)this.internalRouter.inInvoke("dis.channel.getChannelByCode", param);
        if (strMemberCode == null) {
            return null;
        }
        DisChannel channel = (DisChannel)JsonUtil.buildNormalBinder().getJsonToObject(strMemberCode, DisChannel.class);
        String memberCode = channel.getMemberCode();
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("userinfoCode", memberCode);
        map1.put("tenantCode", param.get("tenantCode"));
        String strCompanyCode = (String)this.internalRouter.inInvoke("um.user.getUserinfoByUserCode", map1);
        if (strCompanyCode == null) {
            return null;
        }
        UmUserinfoReDomainBean domainBean = (UmUserinfoReDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(strCompanyCode, UmUserinfoReDomainBean.class);
        String companyCode = domainBean.getCompanyCode();
        return this.getCompanyAndDepart(request, companyCode);
    }

    public List<OrgCompanyReDomain> getCompanyAndDepart(HttpServletRequest request, String companyCode) {
        SupQueryResult<OrgCompanyReDomain> domainSupQueryResult;
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryCompanyAndDepart.userSession", (Object)"\u672a\u767b\u5f55");
            return null;
        }
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("companyCode", companyCode);
        }
        if (null == (domainSupQueryResult = this.orgCompanyService.queryCompanyPage(param)) || ListUtil.isEmpty((Collection)domainSupQueryResult.getList())) {
            this.logger.error(CODE + ".queryCompanyAndDepart.domainSupQueryResult", (Object)"domainSupQueryResult is null");
            return domainSupQueryResult.getList();
        }
        return this.queryDepartList(domainSupQueryResult.getList());
    }

    public List<OrgCompanyReDomain> queryDepartList(List<OrgCompanyReDomain> orgCompanyReDomainList) {
        if (ListUtil.isEmpty(orgCompanyReDomainList)) {
            this.logger.error(CODE + ".queryCompanyAndDepart.domainSupQueryResult", (Object)"domainSupQueryResult is null");
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, OrgCompanyReDomain> codeMap = new HashMap<String, OrgCompanyReDomain>();
        for (OrgCompanyReDomain companyReDomain : orgCompanyReDomainList) {
            buffer.append(companyReDomain.getCompanyCode() + ",");
            codeMap.put(companyReDomain.getCompanyCode(), companyReDomain);
        }
        param.put("companyCode", buffer);
        SupQueryResult<OrgDepartReDomain> orgDepartReDomain = this.orgDepartService.queryDepartPage(param);
        if (null == orgDepartReDomain || ListUtil.isEmpty((Collection)orgDepartReDomain.getList())) {
            return orgCompanyReDomainList;
        }
        List all = orgDepartReDomain.getList();
        ArrayList<OrgDepartReDomain> rootClass = new ArrayList<OrgDepartReDomain>();
        for (OrgDepartReDomain org : all) {
            if (!"-1".equals(org.getDepartPcode())) continue;
            rootClass.add(org);
        }
        this.logger.debug(CODE + ".queryDepartList.rootClass", (Object)JsonUtil.buildNormalBinder().toJson(rootClass));
        HashMap h = new HashMap();
        ArrayList<OrgDepartReDomain> orgDepartReDomainList = new ArrayList<OrgDepartReDomain>();
        HashMap listMap = new HashMap();
        List<OrgDepartReDomain> reDomainList = new ArrayList<OrgDepartReDomain>();
        for (OrgDepartReDomain rsGoodsClassReDomain : rootClass) {
            List<OrgDepartReDomain> childList = this.getChild(rsGoodsClassReDomain.getDepartCode(), all);
            rsGoodsClassReDomain.setChileOrgDepartReDomainList(childList);
            orgDepartReDomainList.add(rsGoodsClassReDomain);
            reDomainList = null == listMap.get(rsGoodsClassReDomain.getCompanyCode()) ? new ArrayList() : (List)listMap.get(rsGoodsClassReDomain.getCompanyCode());
            reDomainList.add(rsGoodsClassReDomain);
            listMap.put(rsGoodsClassReDomain.getCompanyCode(), reDomainList);
        }
        ArrayList<OrgCompanyReDomain> companyReDomains = new ArrayList<OrgCompanyReDomain>();
        for (String key : codeMap.keySet()) {
            OrgCompanyReDomain reDomain = (OrgCompanyReDomain)codeMap.get(key);
            if (null == reDomain) {
                this.logger.error(CODE + ".queryCompanyAndDepart.reDomain", (Object)"reDomain is null");
                return null;
            }
            List orgDepartReDomainList1 = (List)listMap.get(key);
            reDomain.setDepartList(orgDepartReDomainList1);
            companyReDomains.add(reDomain);
        }
        return companyReDomains;
    }

    public List<OrgDepartReDomain> getChild(String id, List<OrgDepartReDomain> all) {
        ArrayList<OrgDepartReDomain> childList = new ArrayList<OrgDepartReDomain>();
        ArrayList childList2 = new ArrayList();
        for (OrgDepartReDomain rsClasstreeReDomain : all) {
            if (!id.equals(rsClasstreeReDomain.getDepartPcode())) continue;
            childList.add(rsClasstreeReDomain);
        }
        for (OrgDepartReDomain rsClasstreeReDomain : childList) {
            rsClasstreeReDomain.setChileOrgDepartReDomainList(this.getChild(rsClasstreeReDomain.getDepartCode(), all));
        }
        if (childList.size() == 0) {
            return null;
        }
        return childList;
    }

    @RequestMapping(value={"queryOrderCommissionChannel.json"}, name="\u67e5\u8be2\u6e20\u9053\u5b9a\u4e49\u5206\u9875\u5217\u8868-\u6280\u672f\u4e2d\u53f0(\u8ba2\u5355\u62bd\u4f63)")
    @ResponseBody
    public SupQueryResult<DisChannelReDomain> queryOrderCommissionChannel(HttpServletRequest request) {
        HashMap<String, Object> param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null == param) {
            param = new HashMap<String, Object>();
        }
        param.put("order", true);
        param.put("fuzzy", true);
        param.put("channelCode", BaseInterUtil.getChannelCode((HttpServletRequest)request));
        return this.disChannelService.queryChannelPage(param);
    }
}

