/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.erp;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.erp.ErpOrderDomain;
import cn.com.qj.bff.domain.erp.ErpOrderReDomain;
import cn.com.qj.bff.service.erp.ErpOrderService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/erp/order"}, name="erp\u8ba2\u5355\u670d\u52a1")
public class ErpOrderCon
extends SpringmvcController {
    private static String CODE = "erp.order.con";
    @Autowired
    private ErpOrderService erpOrderService;

    @Override
    protected String getContext() {
        return "order";
    }

    @RequestMapping(value={"saveOrder.json"}, name="\u589e\u52a0erp\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveOrder(HttpServletRequest request, ErpOrderDomain erpOrderDomain) {
        if (null == erpOrderDomain) {
            this.logger.error(CODE + ".saveOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        erpOrderDomain.setTenantCode(this.getTenantCode(request));
        return this.erpOrderService.saveOrder(erpOrderDomain);
    }

    @RequestMapping(value={"getOrder.json"}, name="\u83b7\u53d6erp\u8ba2\u5355\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public ErpOrderReDomain getOrder(Integer pOrderId) {
        if (StringUtils.isBlank((Integer)pOrderId)) {
            this.logger.error(CODE + ".getOrder", (Object)"param is null");
            return null;
        }
        return this.erpOrderService.getOrder(pOrderId);
    }

    @RequestMapping(value={"updateOrder.json"}, name="\u66f4\u65b0erp\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateOrder(HttpServletRequest request, ErpOrderDomain erpOrderDomain) {
        if (null == erpOrderDomain) {
            this.logger.error(CODE + ".updateOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        erpOrderDomain.setTenantCode(this.getTenantCode(request));
        return this.erpOrderService.updateOrder(erpOrderDomain);
    }

    @RequestMapping(value={"deleteOrder.json"}, name="\u5220\u9664erp\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteOrder(Integer pOrderId) {
        if (StringUtils.isBlank((Integer)pOrderId)) {
            this.logger.error(CODE + ".deleteOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.erpOrderService.deleteOrder(pOrderId);
    }

    @RequestMapping(value={"queryOrderPage.json"}, name="\u67e5\u8be2erp\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ErpOrderReDomain> queryOrderPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.erpOrderService.queryOrderPage(param);
    }

    @RequestMapping(value={"updateOrderState.json"}, name="\u66f4\u65b0erp\u8ba2\u5355\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateOrderState(String pOrderId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)pOrderId)) {
            this.logger.error(CODE + ".updateOrderState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.erpOrderService.updateOrderState(Integer.valueOf(pOrderId), dataState, oldDataState, null);
    }
}

