/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.tenant;

import cn.com.qj.bff.common.bean.DisChannel;
import cn.com.qj.bff.controller.tenant.TenantCon;
import cn.com.qj.bff.core.auth.AuthService;
import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.core.util.HtmlUtil;
import cn.com.qj.bff.domain.tm.TmProappConfigDomain;
import cn.com.qj.bff.domain.tm.TmProappConfigReDomain;
import cn.com.qj.bff.domain.tm.TmProappDomain;
import cn.com.qj.bff.domain.tm.TmProappEnvDomain;
import cn.com.qj.bff.domain.tm.TmProappEnvReDomain;
import cn.com.qj.bff.domain.tm.TmProappMenuDomain;
import cn.com.qj.bff.domain.tm.TmProappMenuReDomain;
import cn.com.qj.bff.domain.tm.TmProappReDomain;
import cn.com.qj.bff.domain.tm.TmTenantReDomain;
import cn.com.qj.bff.domain.um.UmQualityProappReDomain;
import cn.com.qj.bff.domain.um.UmUserinfoQuaReDomain;
import cn.com.qj.bff.domain.um.UmUserinfoReDomainBean;
import cn.com.qj.bff.domain.up.UpMenuReDomainBean;
import cn.com.qj.bff.domain.up.UpOpPermissionReDomainBean;
import cn.com.qj.bff.service.cms.CmsTginfoService;
import cn.com.qj.bff.service.tm.TmProappService;
import cn.com.qj.bff.service.um.UmQualityProappService;
import cn.com.qj.bff.service.um.UmUserinfoQuaService;
import cn.com.qj.bff.service.um.UserService;
import cn.com.qj.bff.service.up.MenuService;
import cn.com.qj.bff.service.up.OpPermissionService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/tm/Proapp"}, name="\u79df\u6237\u4ea7\u54c1\u7ba1\u7406")
public class ProappCon
extends SpringmvcController {
    private static String CODE = "tm.Proapp.con";
    private static final String BUY_ROLE = "buy";
    @Autowired
    private TmProappService tmProappService;
    @Autowired
    private UmUserinfoQuaService umUserinfoQuaService;
    @Autowired
    private UmQualityProappService umQualityProappService;
    @Autowired
    private AuthService authService;
    @Autowired
    private OpPermissionService opPermissionService;
    @Autowired
    private MenuService menuService;
    @Autowired
    private UserService userService;
    @Autowired
    private CmsTginfoService cmsTginfoService;
    @Autowired
    private TenantCon tenantCon;
    public final String proappSortStr = "0,2";

    @Override
    protected String getContext() {
        return "Proapp";
    }

    @RequestMapping(value={"getroappConfigPageForUser.json"}, name="\u83b7\u53d6\u5f53\u524d\u4ea7\u54c1\u914d\u7f6e\u4fe1\u606f")
    @ResponseBody
    public TmProappConfigReDomain getroappConfigPageForUser(HttpServletRequest request, String proappConfigType) {
        SupQueryResult<TmProappConfigReDomain> qlist;
        Map<String, Object> param = this.makeMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("proappConfigType", proappConfigType);
            param.put("tenantCode", this.getTenantCode(request));
        }
        if (null == (qlist = this.tmProappService.queryProappConfigPage(param)) || ListUtil.isEmpty((Collection)qlist.getList())) {
            return null;
        }
        return (TmProappConfigReDomain)qlist.getList().get(0);
    }

    @RequestMapping(value={"saveProapp.json"}, name="\u589e\u52a0\u79df\u6237\u4ea7\u54c1\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean saveProapp(HttpServletRequest request, TmProappDomain tmProappDomain) {
        if (null == tmProappDomain) {
            this.logger.error(CODE + ".saveProapp", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        tmProappDomain.setTenantCode(this.getTenantCode(request));
        return this.tmProappService.saveProapp(tmProappDomain);
    }

    @RequestMapping(value={"getProapp.json"}, name="\u83b7\u53d6\u79df\u6237\u4ea7\u54c1\u7ba1\u7406\u4fe1\u606f")
    @ResponseBody
    public TmProappReDomain getProapp(String proappId) {
        if (StringUtils.isBlank((String)proappId)) {
            this.logger.error(CODE + ".getProapp", (Object)"param is null");
            return null;
        }
        return this.tmProappService.getProapp(Integer.valueOf(proappId));
    }

    @RequestMapping(value={"updateProapp.json"}, name="\u66f4\u65b0\u79df\u6237\u4ea7\u54c1\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean updateProapp(TmProappDomain tmProappDomain) {
        if (null == tmProappDomain) {
            this.logger.error(CODE + ".updateProapp", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tmProappService.updateProapp(tmProappDomain);
    }

    @RequestMapping(value={"deleteProapp.json"}, name="\u5220\u9664\u79df\u6237\u4ea7\u54c1\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean deleteProapp(String proappId) {
        if (StringUtils.isBlank((String)proappId)) {
            this.logger.error(CODE + ".deleteProapp", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tmProappService.deleteProapp(Integer.valueOf(proappId));
    }

    @RequestMapping(value={"queryProappPage.json"}, name="\u67e5\u8be2\u79df\u6237\u4ea7\u54c1\u7ba1\u7406\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<TmProappReDomain> queryProappPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.tmProappService.queryProappPage(param);
    }

    @RequestMapping(value={"queryProappPageByJS.json"}, name="\u5e73\u53f0\u7ba1\u7406\u89d2\u8272\u67e5\u8be2\u79df\u6237\u4ea7\u54c1\u7ba1\u7406\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<TmProappReDomain> queryProappPageByJS(HttpServletRequest request) {
        Map<String, Object> param = this.makeMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.tmProappService.queryProappPage(param);
    }

    @RequestMapping(value={"queryProappEnvPageByPTJS.json"}, name="\u5e73\u53f0\u7ba1\u7406\u89d2\u8272\u67e5\u8be2\u79df\u6237\u5df2\u5f00\u901a\u4ea7\u54c1\u7ba1\u7406\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<TmProappEnvReDomain> queryProappEnvPageByPTJS(HttpServletRequest request) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        String tenantCode = this.getTenantCode(request);
        if (null == tenantCode) {
            this.logger.error(CODE + ".queryProappEnvPageByPTJS", (Object)"param is null");
            return null;
        }
        param.put("tenantCode", tenantCode);
        param.put("channelCode", this.getNowChannel(request));
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.tmProappService.queryProappEnvPage(param);
    }

    @RequestMapping(value={"updateProappState.json"}, name="\u66f4\u65b0\u79df\u6237\u4ea7\u54c1\u7ba1\u7406\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateProappState(String proappId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)proappId)) {
            this.logger.error(CODE + ".updateProappEnvState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tmProappService.updateProappState(Integer.valueOf(proappId), dataState, oldDataState);
    }

    @RequestMapping(value={"saveProappEnv.json"}, name="\u589e\u52a0\u79df\u6237\u4ea7\u54c1\u73af\u5883\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean saveProappEnv(TmProappEnvDomain tmProappEnvDomain) {
        if (null == tmProappEnvDomain) {
            this.logger.error(CODE + ".saveProappEnv", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tmProappService.saveProappEnv(tmProappEnvDomain);
    }

    @RequestMapping(value={"getProappEnv.json"}, name="\u83b7\u53d6\u79df\u6237\u4ea7\u54c1\u73af\u5883\u7ba1\u7406\u4fe1\u606f")
    @ResponseBody
    public TmProappEnvReDomain getProappEnv(String proappEnvId) {
        if (StringUtils.isBlank((String)proappEnvId)) {
            this.logger.error(CODE + ".getProappEnv", (Object)"param is null");
            return null;
        }
        return this.tmProappService.getProappEnv(Integer.valueOf(proappEnvId));
    }

    @RequestMapping(value={"getProappEnvByCodeAndTenantCode.json"}, name="\u83b7\u53d6\u79df\u6237\u4ea7\u54c1\u73af\u5883\u7ba1\u7406\u4fe1\u606f")
    @ResponseBody
    public TmProappEnvDomain getProappEnv(HttpServletRequest request, String proappCode) {
        Map<String, Object> sceneParam = this.assemdataTenantParam(request);
        if (null == sceneParam) {
            return null;
        }
        String code = (String)sceneParam.get("dataTenant");
        this.logger.info(CODE + "tenantCode", (Object)("tenantCode====================" + code));
        if (StringUtils.isBlank((String)code) && !this.getTenantCode(request).equals("00000000")) {
            code = this.getTenantCode(request);
        }
        if (StringUtils.isBlank((String)code)) {
            this.logger.error(CODE + "tenantCode", (Object)"\u76ee\u6807\u79df\u6237code\u4e3anull");
            return null;
        }
        if (StringUtils.isBlank((String)proappCode)) {
            this.logger.error(CODE + ".proappCode", (Object)"\u6e20\u9053\u4ee3\u7801proappCode\u4e3anull");
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("proappCode", proappCode);
        map.put("tenantCode", code);
        return this.tmProappService.getProappEnvByCodeAndTenantCode(map);
    }

    @RequestMapping(value={"updateProappEnv.json"}, name="\u66f4\u65b0\u79df\u6237\u7ba1\u7406\u4ea7\u54c1\u73af\u5883")
    @ResponseBody
    public HtmlJsonReBean updateProappEnv(TmProappEnvDomain tmProappEnvDomain) {
        if (null == tmProappEnvDomain) {
            this.logger.error(CODE + ".updateProappEnv", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tmProappService.updateProappEnv(tmProappEnvDomain);
    }

    @RequestMapping(value={"deleteProappEnv.json"}, name="\u5220\u9664\u79df\u6237\u7ba1\u7406\u4ea7\u54c1\u73af\u5883")
    @ResponseBody
    public HtmlJsonReBean deleteProappEnv(String proappEnvId) {
        if (StringUtils.isBlank((String)proappEnvId)) {
            this.logger.error(CODE + ".deleteProappEnv", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tmProappService.deleteProappEnv(Integer.valueOf(proappEnvId));
    }

    @RequestMapping(value={"queryProappEnvPage.json"}, name="\u67e5\u8be2\u79df\u6237\u4ea7\u54c1\u73af\u5883\u7ba1\u7406\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<TmProappEnvReDomain> queryProappEnvPage(HttpServletRequest request, String tenantCode) {
        Map<String, Object> param = this.makeMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.tmProappService.queryProappEnvPage(param);
    }

    @RequestMapping(value={"queryProappEnvPageUser.json"}, name="\u67e5\u8be2\u5f53\u524d\u79df\u6237\u4ea7\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<TmProappEnvReDomain> queryProappEnvPageUser(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null == param) {
            return null;
        }
        param.put("order", true);
        param.put("fuzzy", true);
        return this.tmProappService.queryProappEnvPage(param);
    }

    @RequestMapping(value={"updateProappEnvState.json"}, name="\u66f4\u65b0\u79df\u6237\u4ea7\u54c1\u73af\u5883\u7ba1\u7406\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateProappEnvState(String proappEnvId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)proappEnvId)) {
            this.logger.error(CODE + ".updateProappEnvState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tmProappService.updateProappEnvState(Integer.valueOf(proappEnvId), dataState, oldDataState);
    }

    @RequestMapping(value={"saveProappConfig.json"}, name="\u589e\u52a0\u79df\u6237\u4ea7\u54c1\u914d\u7f6e\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean saveProappConfig(HttpServletRequest request, TmProappConfigDomain tmProappConfigDomain) {
        Map<String, Object> sceneParam = this.assemdataTenantParam(request);
        if (null == sceneParam) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u6570\u636e\u9519\u8bef!");
        }
        String tenantCode = (String)sceneParam.get("dataTenant");
        if (StringUtils.isBlank((String)tenantCode) && !this.getTenantCode(request).equals("00000000")) {
            tenantCode = this.getTenantCode(request);
        }
        if (null == tmProappConfigDomain || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".saveProappConfig", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        tmProappConfigDomain.setTenantCode(tenantCode);
        return this.tmProappService.saveProappConfig(tmProappConfigDomain);
    }

    @RequestMapping(value={"getProappConfigByMap.json"}, name="\u6839\u636ecode\u67e5\u8be2")
    @ResponseBody
    public TmProappConfigDomain getProappConfigByMap(HttpServletRequest request) {
        Map<String, Object> param = this.makeMapParam(request);
        if (null == param) {
            this.logger.error(CODE + ".getProappConfigByMap", (Object)"param is null");
            return null;
        }
        return this.tmProappService.getProappConfigByCode(param);
    }

    @RequestMapping(value={"getProappConfigByMapAgreement.json"}, name="\u6839\u636ecode\u67e5\u8be2\u63a5\u53e3")
    @ResponseBody
    public TmProappConfigDomain getProappConfigByMapAgreement(HttpServletRequest request) {
        Map<String, Object> param = this.makeMapParam(request);
        if (null == param) {
            this.logger.error(CODE + ".getProappConfigByMap", (Object)"param is null");
            return null;
        }
        return this.tmProappService.getProappConfigByCode(param);
    }

    @RequestMapping(value={"queryProappConfigByChannel.json"}, name="\u83b7\u53d6\u7528\u6237\u534f\u8bae/\u9690\u79c1")
    @ResponseBody
    public SupQueryResult<TmProappConfigReDomain> queryProappConfigByChannel(HttpServletRequest request) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        String memberCode = (String)HtmlUtil.tranMap((Map)request.getParameterMap()).remove("memberCode");
        param.put("tenantCode", this.getTenantCode(request));
        param.put("dataState", 0);
        param.put("proappConfigType", "buyer,privacy");
        param.put("memberCode", this.getTeananMemberCode(request));
        SupQueryResult result = new SupQueryResult();
        ArrayList<TmProappConfigReDomain> configReDomainList = new ArrayList<TmProappConfigReDomain>();
        this.logger.info(CODE + ".queryProappConfigByChannel.param.", (Object)(param + "=:=" + memberCode));
        SupQueryResult<TmProappConfigReDomain> tmProappConfigResult = this.tmProappService.queryProappConfigPage(param);
        if (null != tmProappConfigResult && ListUtil.isNotEmpty((Collection)tmProappConfigResult.getList())) {
            for (TmProappConfigReDomain tmProappConfigReDomain : tmProappConfigResult.getList()) {
                configReDomainList.add(tmProappConfigReDomain);
            }
        } else {
            this.logger.info(CODE + ".tmProappConfigResult", (Object)JsonUtil.buildNormalBinder().toJson(param));
        }
        if (StringUtils.isNotBlank((String)memberCode)) {
            param.put("proappConfigType", "dealer");
            param.put("memberCode", memberCode);
            this.logger.info(CODE + ".queryProappConfigByChannel.param22.", (Object)(param + "=:=" + memberCode + "=:=" + JsonUtil.buildNormalBinder().toJson(configReDomainList)));
            SupQueryResult<TmProappConfigReDomain> configResult = this.tmProappService.queryProappConfigPage(param);
            if (null != configResult && ListUtil.isNotEmpty((Collection)configResult.getList())) {
                for (TmProappConfigReDomain tmProappConfigReDomain : configResult.getList()) {
                    configReDomainList.add(tmProappConfigReDomain);
                }
            } else {
                this.logger.info(CODE + ".configResult", (Object)JsonUtil.buildNormalBinder().toJson(param));
            }
        } else {
            this.logger.info(CODE + ".memberCode", (Object)JsonUtil.buildNormalBinder().toJson(param));
        }
        result.setTotal((long)configReDomainList.size());
        result.setRows(configReDomainList);
        result.setList(configReDomainList);
        return result;
    }

    @RequestMapping(value={"getProappConfigByCode.json"}, name="\u6839\u636ecode\u67e5\u8be2\u534f\u8bae")
    @ResponseBody
    public TmProappConfigDomain getProappConfigByCode(HttpServletRequest request, String proappConfigCode) {
        if (StringUtils.isBlank((String)proappConfigCode)) {
            this.logger.error(CODE + ".getProappConfigByMap", (Object)"param is null");
            return null;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", this.getTenantCode(request));
        param.put("proappConfigCode", proappConfigCode);
        return this.tmProappService.getProappConfigByCode(param);
    }

    @RequestMapping(value={"queryProappConfigByChannelAgreement.json"}, name="\u83b7\u53d6\u7528\u6237\u534f\u8bae/\u9690\u79c1\u63a5\u53e3")
    @ResponseBody
    public SupQueryResult<TmProappConfigReDomain> queryProappConfigByChannelAgreement(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null == param) {
            this.logger.error(CODE + ".getProappConfigByMap", (Object)"param is null");
            return null;
        }
        param.put("order", true);
        param.put("fuzzy", true);
        UserSession userSession = this.getUserSession(request);
        param.put("memberCode", userSession.getUserPcode());
        return this.tmProappService.queryProappConfigPage(param);
    }

    @RequestMapping(value={"saveProappConfigForPlatAgreement.json"}, name="\u589e\u52a0\u79df\u6237\u4ea7\u54c1\u914d\u7f6e\u7ba1\u7406\u7ed9\u5e73\u53f0(\u4fdd\u5b58\u534f\u8bae)\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean saveProappConfigForPlatAgreement(HttpServletRequest request, TmProappConfigDomain tmProappConfigDomain) {
        UserSession userSession = this.getUserSession(request);
        if (null == tmProappConfigDomain) {
            this.logger.error(CODE + ".saveProappConfigForPlat", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        int proappConfigVer = 0;
        HashMap<String, Object> param = new HashMap<String, Object>();
        String tenantCode = this.getTenantCode(request);
        param.put("proappCode", tmProappConfigDomain.getProappCode());
        param.put("channelCode", tmProappConfigDomain.getChannelCode());
        param.put("tenantCode", tenantCode);
        param.put("proappConfigType", tmProappConfigDomain.getProappConfigType());
        param.put("dataState", 0);
        param.put("memberCode", userSession.getUserPcode());
        SupQueryResult<TmProappConfigReDomain> proappConfigReSupQueryResult = this.tmProappService.queryProappConfigPage(param);
        if (null != proappConfigReSupQueryResult && ListUtil.isNotEmpty((Collection)proappConfigReSupQueryResult.getList())) {
            for (TmProappConfigReDomain tmProappConfigReDomain : proappConfigReSupQueryResult.getList()) {
                Integer oldDataState;
                Integer dataState;
                Integer proappConfigId = tmProappConfigReDomain.getProappConfigId();
                HtmlJsonReBean htmlJsonReBean = this.tmProappService.updateProappConfigState(proappConfigId, dataState = Integer.valueOf(-1), oldDataState = Integer.valueOf(0));
                if (null != htmlJsonReBean && htmlJsonReBean.isSuccess()) continue;
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u64cd\u4f5c\u5931\u8d25");
            }
        }
        param.remove("dataState");
        param.put("orderStr", "PROAPP_CONFIG_VER DESC");
        param.put("order", true);
        param.put("startRow", 0);
        param.put("rows", 1);
        SupQueryResult<TmProappConfigReDomain> queryResult = this.tmProappService.queryProappConfigPage(param);
        Integer configVer = 0;
        if (null != queryResult && ListUtil.isNotEmpty((Collection)queryResult.getList()) && null != ((TmProappConfigReDomain)queryResult.getList().get(0)).getProappConfigVer()) {
            configVer = ((TmProappConfigReDomain)queryResult.getList().get(0)).getProappConfigVer();
        }
        proappConfigVer = configVer + 1;
        tmProappConfigDomain.setProappConfigVer(proappConfigVer);
        tmProappConfigDomain.setTenantCode(tenantCode);
        tmProappConfigDomain.setMemberName(userSession.getUserName());
        tmProappConfigDomain.setMemberCode(userSession.getUserPcode());
        return this.tmProappService.saveProappConfig(tmProappConfigDomain);
    }

    @RequestMapping(value={"saveProappConfigForPlat.json"}, name="\u589e\u52a0\u79df\u6237\u4ea7\u54c1\u914d\u7f6e\u7ba1\u7406\u7ed9\u5e73\u53f0(\u4fdd\u5b58\u534f\u8bae)")
    @ResponseBody
    public HtmlJsonReBean saveProappConfigForPlat(HttpServletRequest request, TmProappConfigDomain tmProappConfigDomain) {
        if (null == tmProappConfigDomain) {
            this.logger.error(CODE + ".saveProappConfigForPlat", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        tmProappConfigDomain.setChannelCode(this.getNowChannel(request));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("proappCode", tmProappConfigDomain.getProappCode());
        map.put("proappConfigType", tmProappConfigDomain.getProappConfigType());
        map.put("tenantCode", tmProappConfigDomain.getTenantCode());
        SupQueryResult<TmProappConfigReDomain> tmProappConfigReDomainSupQueryResult = this.tmProappService.queryProappConfigPage(map);
        if (tmProappConfigReDomainSupQueryResult != null && !CollectionUtils.isEmpty((Collection)tmProappConfigReDomainSupQueryResult.getList())) {
            List list = tmProappConfigReDomainSupQueryResult.getList();
            TmProappConfigReDomain tmProappConfigReDomain = (TmProappConfigReDomain)list.get(0);
            tmProappConfigReDomain.setProappConfigText2(tmProappConfigDomain.getProappConfigText2());
            return this.tmProappService.updateProappConfig(tmProappConfigReDomain);
        }
        return this.tmProappService.saveProappConfig(tmProappConfigDomain);
    }

    private void makeChannel(HttpServletRequest request, TmProappConfigDomain tmProappConfigDomain) {
        String[] s;
        String channelInfo = this.getChannel(request);
        if (StringUtils.isNotBlank((String)channelInfo) && null != (s = channelInfo.split(",")) && s.length > 1) {
            tmProappConfigDomain.setChannelCode(this.getChannelCode(request));
            tmProappConfigDomain.setChannelName(s[1]);
        }
    }

    @RequestMapping(value={"queryProappConfigPageForPlat.json"}, name="\u67e5\u8be2\u79df\u6237\u4ea7\u54c1\u914d\u7f6e\u7ba1\u7406\u5206\u9875\u5217\u8868\u7ed9\u5e73\u53f0(\u67e5\u8be2\u534f\u8bae)")
    @ResponseBody
    public SupQueryResult<TmProappConfigReDomain> queryProappConfigPageForPlat(HttpServletRequest request, String proappCode, String tenantCode) {
        Map<String, Object> param = this.makeMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("proappCode", proappCode);
            param.put("tenantCode", tenantCode);
            param.put("channelCode", this.getChannelCode(request));
        }
        return this.tmProappService.queryProappConfigPage(param);
    }

    @RequestMapping(value={"queryProappConfigPageForPlatStr.json"}, name="\u67e5\u8be2\u79df\u6237\u4ea7\u54c1\u914d\u7f6e\u7ba1\u7406\u5206\u9875\u5217\u8868\u7ed9\u5e73\u53f0(\u67e5\u8be2\u534f\u8bae)")
    @ResponseBody
    public SupQueryResult<TmProappConfigReDomain> queryProappConfigPageForPlatStr(HttpServletRequest request) {
        Map<String, Object> param = this.makeMapParam(request);
        UserSession userSession = this.getUserSession(request);
        param.put("userinfoCode", userSession.getUserPcode());
        SupQueryResult<UmUserinfoQuaReDomain> umUserinfoQuaReDomainSupQueryResult = this.umUserinfoQuaService.queryUserinfoQuaPage(param);
        if (ListUtil.isEmpty((Collection)umUserinfoQuaReDomainSupQueryResult.getList())) {
            return null;
        }
        ArrayList<TmProappConfigReDomain> list = new ArrayList<TmProappConfigReDomain>();
        SupQueryResult result = new SupQueryResult();
        for (UmUserinfoQuaReDomain umUserinfoQuaReDomain : umUserinfoQuaReDomainSupQueryResult.getList()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tenantCode", userSession.getTenantCode());
            map.put("proappConfigCode", umUserinfoQuaReDomain.getUserinfoQuaVaule());
            SupQueryResult<TmProappConfigReDomain> supQueryResult = this.tmProappService.queryProappConfigPage(map);
            if (!ListUtil.isNotEmpty((Collection)supQueryResult.getList())) continue;
            for (TmProappConfigReDomain tp : supQueryResult.getList()) {
                list.add(tp);
            }
        }
        result.setList(list);
        result.setTotal((long)list.size());
        return result;
    }

    @RequestMapping(value={"updateProappConfigForPlat.json"}, name="\u66f4\u65b0\u79df\u6237\u4ea7\u54c1\u914d\u7f6e\u7ba1\u7406\u7ed9\u5e73\u53f0(\u4fee\u6539\u534f\u8bae)")
    @ResponseBody
    public HtmlJsonReBean updateProappConfigForPlat(HttpServletRequest request, TmProappConfigDomain tmProappConfigDomain) {
        if (null == tmProappConfigDomain) {
            this.logger.error(CODE + ".updateProappConfigForPlat", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        tmProappConfigDomain.setChannelCode(this.getNowChannel(request));
        return this.tmProappService.updateProappConfig(tmProappConfigDomain);
    }

    @RequestMapping(value={"updateProappConfigForPlatAgreement.json"}, name="\u66f4\u65b0\u79df\u6237\u4ea7\u54c1\u914d\u7f6e\u7ba1\u7406\u7ed9\u5e73\u53f0(\u4fee\u6539\u534f\u8bae)\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean updateProappConfigForPlatAgreement(HttpServletRequest request, TmProappConfigDomain tmProappConfigDomain) {
        if (null == tmProappConfigDomain) {
            this.logger.error(CODE + ".updateProappConfigForPlat", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        this.makeChannel(request, tmProappConfigDomain);
        return this.tmProappService.updateProappConfig(tmProappConfigDomain);
    }

    @RequestMapping(value={"getProappConfig.json"}, name="\u83b7\u53d6\u79df\u6237\u4ea7\u54c1\u914d\u7f6e\u7ba1\u7406\u4fe1\u606f")
    @ResponseBody
    public TmProappConfigReDomain getProappConfig(String proappConfigId) {
        if (StringUtils.isBlank((String)proappConfigId)) {
            this.logger.error(CODE + ".getProappConfig", (Object)"param is null");
            return null;
        }
        return this.tmProappService.getProappConfig(Integer.valueOf(proappConfigId));
    }

    @RequestMapping(value={"getProappConfigAgreement.json"}, name="\u83b7\u53d6\u79df\u6237\u4ea7\u54c1\u914d\u7f6e\u7ba1\u7406\u4fe1\u606f")
    @ResponseBody
    public TmProappConfigReDomain getProappConfigAgreement(String proappConfigId) {
        if (StringUtils.isBlank((String)proappConfigId)) {
            this.logger.error(CODE + ".getProappConfig", (Object)"param is null");
            return null;
        }
        return this.tmProappService.getProappConfig(Integer.valueOf(proappConfigId));
    }

    @RequestMapping(value={"updateProappConfig.json"}, name="\u66f4\u65b0\u79df\u6237\u4ea7\u54c1\u914d\u7f6e\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean updateProappConfig(HttpServletRequest request, TmProappConfigDomain tmProappConfigDomain) {
        Map<String, Object> sceneParam = this.assemdataTenantParam(request);
        if (null == sceneParam) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u6570\u636e\u9519\u8bef!");
        }
        String tenantCode = (String)sceneParam.get("dataTenant");
        this.logger.info(CODE + "tenantCode", (Object)("tenantCode====================" + tenantCode));
        if (StringUtils.isBlank((String)tenantCode) && !this.getTenantCode(request).equals("00000000")) {
            tenantCode = this.getTenantCode(request);
        }
        if (null == tmProappConfigDomain || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".updateProappConfig", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        tmProappConfigDomain.setTenantCode(tenantCode);
        return this.tmProappService.updateProappConfig(tmProappConfigDomain);
    }

    @RequestMapping(value={"deleteProappConfig.json"}, name="\u5220\u9664\u79df\u6237\u4ea7\u54c1\u914d\u7f6e\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean deleteProappConfig(String proappConfigId) {
        if (StringUtils.isBlank((String)proappConfigId)) {
            this.logger.error(CODE + ".deleteProappConfig", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tmProappService.deleteProappConfig(Integer.valueOf(proappConfigId));
    }

    @RequestMapping(value={"queryProappConfigPage.json"}, name="\u67e5\u8be2\u79df\u6237\u4ea7\u54c1\u914d\u7f6e\u7ba1\u7406\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<TmProappConfigReDomain> queryProappConfigPage(HttpServletRequest request) {
        Map<String, Object> param = this.makeMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.tmProappService.queryProappConfigPage(param);
    }

    @RequestMapping(value={"updateProappConfigStatetAgreement.json"}, name="\u66f4\u65b0\u79df\u6237\u4ea7\u54c1\u914d\u7f6e\u7ba1\u7406\u72b6\u6001\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean updateProappConfigStatetAgreement(String proappConfigId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)proappConfigId)) {
            this.logger.error(CODE + ".updateProappConfigState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tmProappService.updateProappConfigState(Integer.valueOf(proappConfigId), dataState, oldDataState);
    }

    @RequestMapping(value={"updateProappConfigState.json"}, name="\u66f4\u65b0\u79df\u6237\u4ea7\u54c1\u914d\u7f6e\u7ba1\u7406\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateProappConfigState(String proappConfigId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)proappConfigId)) {
            this.logger.error(CODE + ".updateProappConfigState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tmProappService.updateProappConfigState(Integer.valueOf(proappConfigId), dataState, oldDataState);
    }

    @RequestMapping(value={"saveProappMenu.json"}, name="\u589e\u52a0\u79df\u6237\u4ea7\u54c1\u76ee\u5f55\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean saveProappMenu(TmProappMenuDomain tmProappMenuDomain) {
        if (null == tmProappMenuDomain) {
            this.logger.error(CODE + ".saveProappMenu", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tmProappService.saveProappMenu(tmProappMenuDomain);
    }

    @RequestMapping(value={"getProappMenu.json"}, name="\u83b7\u53d6\u79df\u6237\u4ea7\u54c1\u76ee\u5f55\u7ba1\u7406\u4fe1\u606f")
    @ResponseBody
    public TmProappMenuReDomain getProappMenu(String proappMenuId) {
        if (StringUtils.isBlank((String)proappMenuId)) {
            this.logger.error(CODE + ".getProappMenu", (Object)"param is null");
            return null;
        }
        return this.tmProappService.getProappMenu(Integer.valueOf(proappMenuId));
    }

    @RequestMapping(value={"updateProappMenu.json"}, name="\u66f4\u65b0\u79df\u6237\u4ea7\u54c1\u76ee\u5f55\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean updateProappMenu(TmProappMenuDomain tmProappMenuDomain) {
        if (null == tmProappMenuDomain) {
            this.logger.error(CODE + ".updateProappMenu", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tmProappService.updateProappMenu(tmProappMenuDomain);
    }

    @RequestMapping(value={"deleteProappMenu.json"}, name="\u5220\u9664\u79df\u6237\u4ea7\u54c1\u76ee\u5f55\u7ba1\u7406")
    @ResponseBody
    public HtmlJsonReBean deleteProappMenu(String proappMenuId) {
        if (StringUtils.isBlank((String)proappMenuId)) {
            this.logger.error(CODE + ".deleteProappMenu", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tmProappService.deleteProappMenu(Integer.valueOf(proappMenuId));
    }

    @RequestMapping(value={"queryProappMenuPage.json"}, name="\u67e5\u8be2\u79df\u6237\u4ea7\u54c1\u76ee\u5f55\u7ba1\u7406\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<TmProappMenuReDomain> queryProappMenuPage(HttpServletRequest request) {
        Map<String, Object> param = this.makeMapParam(request);
        param.put("order", true);
        param.put("fuzzy", true);
        return this.tmProappService.queryProappMenuPage(param);
    }

    @RequestMapping(value={"queryProappMenuTree.json"}, name="\u67e5\u8be2\u79df\u6237\u4ea7\u54c1\u76ee\u5f55\u7ba1\u7406\u6811\u5f62")
    @ResponseBody
    public List<TmProappMenuReDomain> queryProappMenuTree(HttpServletRequest request) {
        HashMap<String, Object> param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null == param) {
            param = new HashMap<String, Object>();
        }
        String tenantCode = (String)param.get("tenantCode");
        String proappCode = (String)param.get("proappCode");
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)proappCode)) {
            return null;
        }
        param.put("order", true);
        param.put("orderStr", "PROAPP_MENU_ORDER asc");
        param.put("proappMenuPcode", "-1");
        SupQueryResult<TmProappMenuReDomain> result = this.tmProappService.queryProappMenuPage(param);
        List list = result.getList();
        this.recursionMenu(request, list);
        for (TmProappMenuReDomain tmProappMenuReDomain : list) {
            if (1 == tmProappMenuReDomain.getDataState()) {
                tmProappMenuReDomain.setEnUsed(true);
                continue;
            }
            tmProappMenuReDomain.setEnUsed(false);
        }
        return this.parseTree(list);
    }

    private List<TmProappMenuReDomain> recursionMenu(HttpServletRequest request, List<TmProappMenuReDomain> list) {
        if (null != list && list.size() > 0) {
            List tmProappMenuReDomainTree = null;
            for (TmProappMenuReDomain tmProappMenu : list) {
                String proappMenuPcode = tmProappMenu.getProappMenuCode();
                Map<String, Object> param = this.makeMapParam(request);
                param.put("proappMenuPcode", proappMenuPcode);
                SupQueryResult<TmProappMenuReDomain> result = this.tmProappService.queryProappMenuPage(param);
                tmProappMenuReDomainTree = result.getList();
                tmProappMenu.setChildren(tmProappMenuReDomainTree);
                this.recursionMenu(request, tmProappMenuReDomainTree);
            }
        }
        return null;
    }

    @RequestMapping(value={"queryProappMenuTreeByProappCode.json"}, name="\u7528\u6237\u67e5\u8be2\u79df\u6237\u4ea7\u54c1\u76ee\u5f55\u7ba1\u7406\u6811\u5f62")
    @ResponseBody
    public Map<String, Object> queryProappMenuTreeByProappCode(HttpServletRequest request, String qualityCode, String userInfoCode) {
        if (StringUtils.isBlank((String)qualityCode) || StringUtils.isBlank((String)userInfoCode)) {
            this.logger.error(CODE + ".queryProappMenuTreeByProappCode", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> menuMap = new HashMap<String, Object>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("qualityCode", qualityCode);
        map.put("tenantCode", tenantCode);
        List qualityProappList = this.umQualityProappService.queryQualityProappPage(map).getList();
        if (null == qualityProappList || qualityProappList.size() <= 0) {
            this.logger.error(CODE + ".queryProappMenuTreeByProappCode", (Object)"param is null");
            return null;
        }
        Map<String, String> userperMap = this.opPermissionService.queryMuserPermission(tenantCode, "", userInfoCode);
        if (!userperMap.isEmpty()) {
            this.logger.error(CODE + ".queryProappMenuTreeByProappCode", (Object)"param is null");
            return null;
        }
        String proappCode = ((UmQualityProappReDomain)qualityProappList.get(0)).getProappCode();
        List menuInfoList = this.authService.getUserPerMenuTree(userperMap, proappCode, tenantCode);
        menuMap.put(proappCode, menuInfoList);
        HashMap<String, Object> buymap = new HashMap<String, Object>();
        buymap.put("proappCode", BUY_ROLE);
        buymap.put("tenantCode", tenantCode);
        List qualityList = this.tmProappService.queryProappPage(buymap).getList();
        if (null != qualityList && qualityList.size() > 0) {
            for (TmProappReDomain tmProappReDomain : qualityList) {
                List menuList = this.authService.getUserPerMenuTree(userperMap, tmProappReDomain.getProappCode(), tenantCode);
                menuMap.put(tmProappReDomain.getProappCode(), menuList);
            }
            return menuMap;
        }
        return menuMap;
    }

    @RequestMapping(value={"queryMenuTreeByUserInfo.json"}, name="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u6240\u62e5\u6709\u6743\u9650")
    @ResponseBody
    public Map<String, Object> queryMenuTreeByUserInfo(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession || StringUtils.isBlank((String)userSession.getUserPcode())) {
            this.logger.error(CODE + ".queryMenuTreeByUserInfo.userSession", (Object)"userSession\u6216userInfo\u4e3a\u7a7a");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        UmUserinfoReDomainBean userinfo = this.userService.getUserinfoByCode(userSession.getUserPcode(), tenantCode);
        if (null == userinfo || StringUtils.isBlank((String)userinfo.getRoleCode())) {
            this.logger.error(CODE + ".queryMenuTreeByUserInfo.userinfo", (Object)"\u8be5\u7528\u6237\u6ca1\u6709\u6743\u9650");
            return null;
        }
        List<String> opPermissionCodeStr = this.getList(userinfo.getRoleCode());
        if (ListUtil.isEmpty(opPermissionCodeStr)) {
            this.logger.error(CODE + ".queryMenuTreeByUserInfo.opPermissionCodeStr", (Object)"\u6743\u9650\u6709\u8bef");
            return null;
        }
        HashMap<String, Object> upopMap = new HashMap<String, Object>();
        upopMap.put("opPermissionType", 1);
        upopMap.put("opPermissionState", 1);
        upopMap.put("opPermissionCodeStr", opPermissionCodeStr);
        upopMap.put("tenantCode", tenantCode);
        SupQueryResult<UpOpPermissionReDomainBean> upopList = this.opPermissionService.queryUpOpPermissionList(upopMap);
        if (null == upopList || upopList.getList().size() <= 0) {
            this.logger.error(CODE + ".queryMenuTreeByUserInfo.upopList", (Object)("\u8be5\u7528\u6237\u6ca1\u6709\u6743\u9650" + ((Object)upopMap).toString()));
            return null;
        }
        HashMap userperMap = new HashMap();
        HashMap<String, String> umap = null;
        for (UpOpPermissionReDomainBean upOpPermissionReDomainBean : upopList.getList()) {
            if (!userperMap.containsKey(upOpPermissionReDomainBean.getAppmanageIcode())) {
                umap = new HashMap<String, String>();
                umap.put(upOpPermissionReDomainBean.getMenuCode(), upOpPermissionReDomainBean.getMenuCode());
                userperMap.put(upOpPermissionReDomainBean.getAppmanageIcode(), umap);
                continue;
            }
            umap.put(upOpPermissionReDomainBean.getMenuCode(), upOpPermissionReDomainBean.getMenuCode());
        }
        HashMap<String, Object> menuMap = new HashMap<String, Object>();
        for (String key : userperMap.keySet()) {
            List menuList = this.authService.getUserInfoPerMenuTree((Map)userperMap.get(key), key, tenantCode);
            if (null == menuList || menuList.size() <= 0) continue;
            menuMap.put(key, menuList);
        }
        return menuMap;
    }

    @RequestMapping(value={"queryProappMenuTreeByQualityByYH.json"}, name="\u7528\u6237\u8d44\u8d28\u67e5\u8be2\u79df\u6237\u4ea7\u54c1\u76ee\u5f55\u7ba1\u7406\u6811\u5f62")
    @ResponseBody
    public Map<String, Object> queryProappMenuTreeByQualityByYH(HttpServletRequest request, String qualityCode) {
        if (StringUtils.isBlank((String)qualityCode)) {
            this.logger.error(CODE + ".queryProappMenuTreeByQualityByYH", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        return this.queryMenuMap(tenantCode, qualityCode);
    }

    @RequestMapping(value={"queryProappMenuTreeForMem.json"}, name="\u5356\u5bb6\u6743\u9650\u5206\u914d")
    @ResponseBody
    public Map<String, Object> queryProappMenuTreeForMem(HttpServletRequest request, String qualityCodeStr) {
        List<String> qualityCodeList;
        String tenantCode = this.getTenantCode(request);
        List<String> proappByQuaList = this.getProappCodeQua(tenantCode, qualityCodeList = this.getList(qualityCodeStr));
        if (ListUtil.isEmpty(proappByQuaList)) {
            return null;
        }
        return this.getPerMenTreeByProappList(proappByQuaList, tenantCode);
    }

    @RequestMapping(value={"queryProappMenuTreeForC.json"}, name="\u8fd0\u8425\u7aef\u4e0b\u5c5eC\u7aef\u4ea7\u54c1\u76ee\u5f55\u7ba1\u7406\u6811\u5f62")
    @ResponseBody
    public Map<String, Object> queryProappMenuTreeForC(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        UserSession userSession = this.getUserSession(request);
        String channelCode = this.getChannelCodeMcode(userSession.getUserPcode(), tenantCode);
        List<String> proappSortList = this.getList("0,2");
        List<String> proappCode = this.getProappCodeByChannel(tenantCode, channelCode, proappSortList);
        return this.getPerMenTreeByProappList(proappCode, tenantCode);
    }

    public String getChannelCodeMcode(String memeberCode, String tenantCode) {
        DisChannel disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-memberCode", (String)(memeberCode + "-0-" + tenantCode), DisChannel.class);
        return null == disChannel ? null : disChannel.getChannelCode();
    }

    @RequestMapping(value={"queryProappMenuTreeByQualityByJS.json"}, name="\u89d2\u8272\u67e5\u8be2\u79df\u6237\u4ea7\u54c1\u76ee\u5f55\u7ba1\u7406\u6811\u5f62")
    @ResponseBody
    public Map<String, Object> queryProappMenuTreeByQualityByJS(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        UserSession userSession = this.getUserSession(request);
        List<String> proappSortList = this.getList("0,2");
        String channelCode = this.getChannelCodeMcode(userSession.getUserPcode(), tenantCode);
        this.logger.info("queryProappMenuTreeByQualityByJS +++++++++++ userSession.getUserinfoQuality()" + userSession.getUserinfoQuality());
        List<String> qualityCodeList = this.getList(userSession.getUserinfoQuality());
        if (ListUtil.isEmpty(qualityCodeList)) {
            return null;
        }
        this.logger.info("queryProappMenuTreeByQualityByJS +++++++++++ " + tenantCode + "+++++++++++ " + channelCode + "+++++++++++ ");
        List<String> proappCode = this.getProappCodeByChannel(tenantCode, channelCode, proappSortList);
        List<String> proappByQuaList = this.getProappCodeQua(tenantCode, qualityCodeList);
        if (ListUtil.isNotEmpty(proappByQuaList)) {
            if (ListUtil.isEmpty(proappCode)) {
                proappCode = proappByQuaList;
            } else {
                proappCode.addAll(proappByQuaList);
            }
        }
        if (ListUtil.isEmpty(proappCode)) {
            return null;
        }
        proappCode = new ArrayList<String>(new HashSet<String>(proappCode));
        this.logger.info("proappCode.size() +++++++++++ " + proappCode.size() + "+++++++++++ " + proappCode.get(0));
        return this.getPerMenTreeByProappList(proappCode, tenantCode);
    }

    public Map<String, Object> getPerMenTreeByProappList(List<String> proappCode, String tenantCode) {
        if (ListUtil.isEmpty(proappCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> menuMap = new HashMap<String, Object>();
        for (String pro : proappCode) {
            List menuInfoList = new ArrayList();
            menuInfoList = this.authService.getPerMenuTree(pro, tenantCode);
            menuMap.put(pro, menuInfoList);
        }
        return menuMap;
    }

    public List<String> getProappCodeByChannel(String tenantCode, String channelCode, List<String> proappSortStr) {
        List<String> proappCode;
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)channelCode) || ListUtil.isEmpty(proappSortStr)) {
            return null;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", tenantCode);
        param.put("channelCode", channelCode);
        param.put("proappSortStr", proappSortStr);
        try {
            proappCode = this.tmProappService.queryProappCodeEnv(param);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".getProappCodeByChannel.e", (Throwable)e);
            return null;
        }
        param.remove("proappSortStr");
        List<String> proappCms = this.cmsTginfoService.queryProappCodeCms(param);
        if (ListUtil.isEmpty(proappCode) && ListUtil.isEmpty(proappCms)) {
            this.logger.error(CODE + ".getProappCodeByChannel", (Object)"ProappEnv is null");
            return null;
        }
        proappCode.addAll(proappCms);
        return proappCode;
    }

    public List<String> getList(String qualityCodeStr) {
        String[] codeStr = qualityCodeStr.split(",");
        if (null == codeStr || codeStr.length == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String code : codeStr) {
            list.add(code);
        }
        return list;
    }

    public List<String> getProappCodeQua(String tenantCode, List<String> qualityCodeList) {
        if (StringUtils.isBlank((String)tenantCode) || ListUtil.isEmpty(qualityCodeList)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("qualityCodeStr", qualityCodeList);
        List<String> quaList = this.umQualityProappService.queryProappCodeQua(map);
        if (ListUtil.isEmpty(quaList)) {
            map.put("tenantCode", "00000000");
            quaList = this.umQualityProappService.queryProappCodeQua(map);
        }
        return quaList;
    }

    @RequestMapping(value={"queryProappEnvPageByJS.json"}, name="\u67e5\u8be2\u5df2\u5f00\u901a\u4ea7\u54c1\u540d\u79f0")
    @ResponseBody
    public Map<String, String> queryProappEnvPageByJS(HttpServletRequest request) {
        return this.structureProductInfoCommon(request);
    }

    @RequestMapping(value={"queryProappEnvPageByCZY.json"}, name="\u6784\u5efa\u5df2\u5f00\u901a\u4ea7\u54c1\u540d\u79f0")
    @ResponseBody
    public Map<String, String> queryProappEnvPageByCZY(HttpServletRequest request) {
        return this.structureProductInfoCommon(request);
    }

    @RequestMapping(value={"queryMenuTreeByQualityByJS.json"}, name="\u89d2\u8272\u6839\u636e\u8d44\u8d28\u67e5\u8be2\u79df\u6237\u4ea7\u54c1\u76ee\u5f55\u7ba1\u7406\u6811\u5f62")
    @ResponseBody
    public Map<String, Object> queryMenuTreeByQualityByJS(HttpServletRequest request, String proappCode) {
        if (StringUtils.isBlank((String)proappCode)) {
            this.logger.error(CODE + ".queryProappMenuTreeByQualityByCZY", (Object)"param is null");
            return null;
        }
        String[] code = proappCode.split(",");
        HashMap<String, Object> menumap = new HashMap<String, Object>();
        String tenantCode = this.getTenantCode(request);
        for (int i = 0; i < code.length; ++i) {
            String c = code[i];
            List menuinfoList = this.authService.getPerMenuTree(c, tenantCode);
            menumap.put(c, menuinfoList);
        }
        return menumap;
    }

    @RequestMapping(value={"queryProappMenuTreeByQualityByCZY.json"}, name="\u64cd\u4f5c\u5458\u67e5\u8be2\u79df\u6237\u4ea7\u54c1\u76ee\u5f55\u7ba1\u7406\u6811\u5f62")
    @ResponseBody
    public Map<String, Object> queryProappMenuTreeByQualityByCZY(HttpServletRequest request, String qualityCode) {
        if (StringUtils.isBlank((String)qualityCode)) {
            this.logger.error(CODE + ".queryProappMenuTreeByQualityByCZY", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        return this.queryMenuMap(tenantCode, qualityCode);
    }

    public Map<String, Object> queryMenuMap(String tenantCode, String qualityCode) {
        if (qualityCode.equals(BUY_ROLE)) {
            return this.queryMenuInfoMap(tenantCode);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("qualityCode", qualityCode);
        map.put("tenantCode", tenantCode);
        List qualityProappList = this.umQualityProappService.queryQualityProappPage(map).getList();
        if (null == qualityProappList || qualityProappList.size() <= 0) {
            map.put("tenantCode", "00000000");
            qualityProappList = this.umQualityProappService.queryQualityProappPage(map).getList();
        }
        if (null == qualityProappList || qualityProappList.size() <= 0) {
            this.logger.error(CODE + ".queryMenuMap", (Object)"proappList is null");
            return null;
        }
        String proappCode = ((UmQualityProappReDomain)qualityProappList.get(0)).getProappCode();
        Map<String, Object> menumap = this.queryMenuInfoMap(tenantCode);
        List menuinfoList = this.authService.getPerMenuTree(proappCode, tenantCode);
        menumap.put(proappCode, menuinfoList);
        return menumap;
    }

    public Map<String, Object> queryMenuInfoMap(String tenantCode) {
        HashMap<String, Object> menumap = new HashMap<String, Object>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("qualityCode", BUY_ROLE);
        map.put("tenantCode", tenantCode);
        List qualityProappList = this.umQualityProappService.queryQualityProappPage(map).getList();
        if (null == qualityProappList || qualityProappList.size() <= 0) {
            map.put("tenantCode", "00000000");
            qualityProappList = this.umQualityProappService.queryQualityProappPage(map).getList();
        }
        if (null == qualityProappList || qualityProappList.size() <= 0) {
            this.logger.error(CODE + ".queryMenuInfoMap", (Object)"proappList is null");
            return null;
        }
        for (UmQualityProappReDomain umQualityProappReDomain : qualityProappList) {
            List menuList = this.authService.getPerMenuTree(umQualityProappReDomain.getProappCode(), tenantCode);
            menumap.put(umQualityProappReDomain.getProappCode(), menuList);
        }
        return menumap;
    }

    @RequestMapping(value={"queryProappMenuTreeByBuyer.json"}, name="\u6839\u636e\u5df2\u6709\u6743\u9650\u67e5\u8be2\u4e70\u5bb6\u4ea7\u54c1\u76ee\u5f55\u7ba1\u7406\u6811\u5f62")
    @ResponseBody
    public List<TmProappMenuReDomain> queryProappMenuTreeByBuyer(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        param.put("proappCode", "003");
        param.put("order", true);
        param.put("fuzzy", true);
        SupQueryResult<TmProappMenuReDomain> result = this.tmProappService.queryProappMenuPage(param);
        List list = result.getList();
        for (TmProappMenuReDomain tmProappMenuReDomain : list) {
            if (1 == tmProappMenuReDomain.getDataState()) {
                tmProappMenuReDomain.setEnUsed(true);
                continue;
            }
            tmProappMenuReDomain.setEnUsed(false);
        }
        this.order(list);
        return this.parseTree(list);
    }

    private void order(List<TmProappMenuReDomain> menuList) {
        Collections.sort(menuList, new Comparator<TmProappMenuReDomain>(){

            @Override
            public int compare(TmProappMenuReDomain menu1, TmProappMenuReDomain menu2) {
                int order1 = menu1.getProappMenuOrder();
                int order2 = menu2.getProappMenuOrder();
                return Integer.compare(order1, order2);
            }
        });
    }

    private List<TmProappMenuReDomain> parseTree(List<TmProappMenuReDomain> list) {
        ArrayList<TmProappMenuReDomain> newList = new ArrayList<TmProappMenuReDomain>();
        for (TmProappMenuReDomain tmProappMenuReDomain : list) {
            boolean mark = false;
            for (TmProappMenuReDomain menuReDomain : list) {
                if ("-1".equals(tmProappMenuReDomain.getProappMenuPcode()) || !tmProappMenuReDomain.getProappMenuPcode().equals(menuReDomain.getProappMenuCode())) continue;
                mark = true;
                if (menuReDomain.getChildren() == null) {
                    menuReDomain.setChildren(new ArrayList<TmProappMenuReDomain>());
                }
                menuReDomain.getChildren().add(tmProappMenuReDomain);
                break;
            }
            if (mark) continue;
            newList.add(tmProappMenuReDomain);
        }
        return newList;
    }

    @RequestMapping(value={"updateProappMenuState.json"}, name="\u66f4\u65b0\u79df\u6237\u4ea7\u54c1\u76ee\u5f55\u7ba1\u7406\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateProappMenuState(String proappMenuId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)proappMenuId)) {
            this.logger.error(CODE + ".updateProappMenuState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tmProappService.updateProappMenuState(Integer.valueOf(proappMenuId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryProappMenuByTenantCode.json"}, name="\u6839\u636e\u79df\u6237id\u67e5\u8be2\u79df\u6237\u4ea7\u54c1\u76ee\u5f55\u7ba1\u7406")
    @ResponseBody
    public SupQueryResult<TmProappMenuReDomain> queryProappMenuByTenantCode(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.tmProappService.queryProappMenuPage(param);
    }

    @RequestMapping(value={"queryQualityProappPage.json"}, name="\u67e5\u8be2\u6240\u6709\u4ea7\u54c1\u8d44\u8d28")
    @ResponseBody
    public SupQueryResult<UmQualityProappReDomain> queryQualityProappPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.umQualityProappService.queryQualityProappPage(param);
    }

    @RequestMapping(value={"queryProappEnvLoadCache.json"}, name="\u52a0\u8f7d\u79df\u6237\u4ea7\u54c1\u6e20\u9053")
    @ResponseBody
    public HtmlJsonReBean queryProappEnvLoadCache() {
        return this.tmProappService.queryProappEnvLoadCache();
    }

    @RequestMapping(value={"queryProappMenuLoadCache.json"}, name="\u52a0\u8f7d\u79df\u6237\u4ea7\u54c1\u83dc\u5355")
    @ResponseBody
    public HtmlJsonReBean queryProappMenuLoadCache() {
        this.tmProappService.queryProappEnvLoadCache();
        return this.tmProappService.queryProappMenuLoadCache();
    }

    @RequestMapping(value={"queryProappMenuTreeLoadCache.json"}, name="\u52a0\u8f7d\u79df\u6237\u4ea7\u54c1\u5c42\u7ea7\u83dc\u5355")
    @ResponseBody
    public HtmlJsonReBean queryProappMenuTreeLoadCache() {
        return this.tmProappService.queryProappMenuTreeLoadCache();
    }

    @RequestMapping(value={"queryProappFromMsc.json"}, name="\u67e5\u8be2\u79df\u6237\u4ea7\u54c1\u7ba1\u7406\u5217\u8868-\u9891\u9053\u5217\u8868")
    @ResponseBody
    public List<TmProappReDomain> queryProappFromMsc(String tenantCode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("order", true);
        param.put("tenantCode", tenantCode);
        SupQueryResult<TmProappReDomain> supQueryResult = this.tmProappService.queryProappPage(param);
        if (null == supQueryResult || null == supQueryResult.getList()) {
            return null;
        }
        return supQueryResult.getList();
    }

    @RequestMapping(value={"queryProappEnvByCompany.json"}, name="\u5df2\u5f00\u901a\u4ea7\u54c1\u7ba1\u7406\u5217\u8868-\u516c\u53f8")
    @ResponseBody
    public SupQueryResult<TmProappEnvReDomain> queryProappEnvByCompany(HttpServletRequest request) {
        return this.queryProappEnvByCurrency(request);
    }

    @RequestMapping(value={"queryProappEnvByMerchant.json"}, name="\u5df2\u5f00\u901a\u4ea7\u54c1\u7ba1\u7406\u5217\u8868-\u5546\u5bb6")
    @ResponseBody
    public SupQueryResult<TmProappEnvReDomain> queryProappEnvByMerchant(HttpServletRequest request) {
        return this.queryProappEnvByCurrency(request);
    }

    @RequestMapping(value={"queryProappEnvByMsc.json"}, name="\u5df2\u5f00\u901a\u4ea7\u54c1\u7ba1\u7406\u5217\u8868-\u9891\u9053")
    @ResponseBody
    public SupQueryResult<TmProappEnvReDomain> queryProappEnvByMsc(String tenantCode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("order", true);
        param.put("fuzzy", true);
        param.put("tenantCode", tenantCode);
        return this.tmProappService.queryProappEnvPage(param);
    }

    @RequestMapping(value={"updateTmProappMenuRel.json"}, name="\u53d1\u5e03\u79df\u6237\u4ea7\u54c1\u9759\u6001\u5316")
    @ResponseBody
    public HtmlJsonReBean updateTmProappMenuRel(Integer proappMenuId) {
        return this.tmProappService.updateTmProappMenuRel(proappMenuId);
    }

    private SupQueryResult<TmProappEnvReDomain> queryProappEnvByCurrency(HttpServletRequest request) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        String tenantCode = this.getTenantCode(request);
        param.put("order", true);
        param.put("fuzzy", true);
        param.put("proappEnvType", "\u524d\u53f0");
        param.put("tenantCode", tenantCode);
        return this.tmProappService.queryProappEnvPage(param);
    }

    public Map<String, String> structureProductInfoCommon(HttpServletRequest request) {
        List tmProappEnvList;
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null == (tmProappEnvList = this.tmProappService.queryProappEnvPage(param).getList()) || tmProappEnvList.size() <= 0) {
            this.logger.error(CODE + ".queryProappMenuTreeByQualityByCZY", (Object)"param is null");
            return null;
        }
        HashMap<String, String> proappEnvMap = new HashMap<String, String>();
        for (TmProappEnvReDomain tmProappEnvReDomain : tmProappEnvList) {
            proappEnvMap.put(tmProappEnvReDomain.getProappCode(), tmProappEnvReDomain.getProappEnvName());
        }
        return proappEnvMap;
    }

    @RequestMapping(value={"queryMenuPage.json"}, name="\u67e5\u8be2\u4ea7\u54c1\u76ee\u5f55\u7ba1\u7406\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UpMenuReDomainBean> queryMenuPage(HttpServletRequest request) {
        Map<String, Object> param = this.makeMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.menuService.queryUpMenuPage(param);
    }

    @RequestMapping(value={"queryTenantPage.json"}, name="\u67e5\u8be2\u79df\u6237\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<TmTenantReDomain> queryTenantPage(HttpServletRequest request) {
        return this.tenantCon.fetchQuery(request);
    }

    @RequestMapping(value={"queryProappEnvPageByJSStr.json"}, name="\u67e5\u8be2\u5df2\u5f00\u901a\u4ea7\u54c1\u540d\u79f0")
    @ResponseBody
    public Map<String, String> queryProappEnvPageByJSStr(HttpServletRequest request) {
        return this.structureProductInfoCommon(request);
    }

    @RequestMapping(value={"queryProappMenuTreeByQualityByJSStr.json"}, name="\u89d2\u8272\u67e5\u8be2\u79df\u6237\u4ea7\u54c1\u76ee\u5f55\u7ba1\u7406\u6811\u5f62")
    @ResponseBody
    public Map<String, Object> queryProappMenuTreeByQualityByJSStr(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        UserSession userSession = this.getUserSession(request);
        List<String> proappSortList = this.getList("0,2");
        String channelCode = this.getChannelCodeMcode(userSession.getUserPcode(), tenantCode);
        this.logger.info("queryProappMenuTreeByQualityByJS +++++++++++ userSession.getUserinfoQuality()" + userSession.getUserinfoQuality());
        List<String> qualityCodeList = this.getList(userSession.getUserinfoQuality());
        if (ListUtil.isEmpty(qualityCodeList)) {
            return null;
        }
        this.logger.info("queryProappMenuTreeByQualityByJS +++++++++++ " + tenantCode + "+++++++++++ " + channelCode + "+++++++++++ ");
        List<String> proappCode = this.getProappCodeByChannel(tenantCode, channelCode, proappSortList);
        List<String> proappByQuaList = this.getProappCodeQua(tenantCode, qualityCodeList);
        if (ListUtil.isNotEmpty(proappByQuaList)) {
            if (ListUtil.isEmpty(proappCode)) {
                proappCode = proappByQuaList;
            } else {
                proappCode.addAll(proappByQuaList);
            }
        }
        if (ListUtil.isEmpty(proappCode)) {
            return null;
        }
        proappCode = new ArrayList<String>(new HashSet<String>(proappCode));
        this.logger.info("proappCode.size() +++++++++++ " + proappCode.size() + "+++++++++++ " + proappCode.get(0));
        return this.getPerMenTreeByProappList(proappCode, tenantCode);
    }

    @RequestMapping(value={"queryProappEnvPageByPTJSStr.json"}, name="\u5e73\u53f0\u7ba1\u7406\u89d2\u8272\u67e5\u8be2\u79df\u6237\u5df2\u5f00\u901a\u4ea7\u54c1\u7ba1\u7406\u5206\u9875\u5217\u8868")
    public SupQueryResult<TmProappEnvReDomain> queryProappEnvPageByPTJSStr(HttpServletRequest request) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        String tenantCode = this.getTenantCode(request);
        if (null == tenantCode) {
            this.logger.error(CODE + ".queryProappEnvPageByPTJS", (Object)"param is null");
            return null;
        }
        param.put("tenantCode", tenantCode);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.tmProappService.queryProappEnvPage(param);
    }

    @RequestMapping(value={"queryMenuTreeByQualityByJSStr.json"}, name="\u89d2\u8272\u6839\u636e\u8d44\u8d28\u67e5\u8be2\u79df\u6237\u4ea7\u54c1\u76ee\u5f55\u7ba1\u7406\u6811\u5f62")
    @ResponseBody
    public Map<String, Object> queryMenuTreeByQualityByJSStr(HttpServletRequest request, String proappCode) {
        if (StringUtils.isBlank((String)proappCode)) {
            this.logger.error(CODE + ".queryProappMenuTreeByQualityByCZY", (Object)"param is null");
            return null;
        }
        String[] code = proappCode.split(",");
        HashMap<String, Object> menumap = new HashMap<String, Object>();
        String tenantCode = this.getTenantCode(request);
        for (int i = 0; i < code.length; ++i) {
            String c = code[i];
            List menuinfoList = this.authService.getPerMenuTree(c, tenantCode);
            menumap.put(c, menuinfoList);
        }
        return menumap;
    }
}

