/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.mindex;

import cn.com.qj.bff.core.auth.AuthService;
import cn.com.qj.bff.core.auth.MenuInfoBean;
import cn.com.qj.bff.core.auth.UserInfo;
import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.gt.GtGiftUserReDomain;
import cn.com.qj.bff.domain.mindex.IndexBean;
import cn.com.qj.bff.domain.mindex.MenuFPcBean;
import cn.com.qj.bff.domain.pm.PmUserCouponReDomain;
import cn.com.qj.bff.domain.vd.VdFaccountInfo;
import cn.com.qj.bff.service.gt.GtGiftUserService;
import cn.com.qj.bff.service.pm.PmUserCouponService;
import cn.com.qj.bff.service.um.UserService;
import cn.com.qj.bff.service.vd.VdFaccountService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/mi/mindex"})
public class MindexCon
extends SpringmvcController {
    @Autowired
    private AuthService authService;
    @Autowired
    private UserService userService;
    @Autowired
    private VdFaccountService vdFaccountService;
    @Autowired
    private GtGiftUserService gtGiftUserService;
    @Autowired
    private PmUserCouponService pmUserCouponService;

    @Override
    protected String getContext() {
        return "mindex";
    }

    @RequestMapping(value={"getTopMenuList.json"})
    @ResponseBody
    public List<MenuInfoBean> getTopMenuList(HttpServletRequest request) {
        List<MenuInfoBean> menuList = this.getMenu(request);
        String tenantCode = this.getTenantCode(request);
        String proappCode = this.getProappCode(request);
        if (null != menuList && !menuList.isEmpty()) {
            List<MenuInfoBean> childList = null;
            for (MenuInfoBean menuBean : menuList) {
                childList = this.makeMenu(menuBean.getProappMenuCode(), proappCode, tenantCode);
                menuBean.setChildren(childList);
            }
        }
        return menuList;
    }

    @RequestMapping(value={"getTopPerMenuList.json"})
    @ResponseBody
    public List<MenuInfoBean> getTopPerMenuList(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        String proappCode = this.getProappCode(request);
        UserSession userSession = this.getUserSession(request);
        List<MenuInfoBean> menulist = null == userSession || StringUtils.isBlank((String)userSession.getTicketTokenid()) ? this.getTopMenuList(request) : this.getMenuPer(request, tenantCode, proappCode);
        return menulist;
    }

    @RequestMapping(value={"getTopPerMenuListFPc.json"})
    @ResponseBody
    public MenuFPcBean getTopPerMenuListFPc(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        String proappCode = this.getProappCode(request);
        UserSession userSession = this.getUserSession(request);
        MenuFPcBean menuFPcBean = new MenuFPcBean();
        List<MenuInfoBean> menulist = null == userSession || StringUtils.isBlank((String)userSession.getTicketTokenid()) ? this.getTopMenuList(request) : this.getMenuPer(request, tenantCode, proappCode);
        menuFPcBean.setMenuList(menulist);
        this.logger.info("...getTopPerMenuListFPc -> ", (Object)JsonUtil.buildNormalBinder().toJson((Object)menuFPcBean));
        menuFPcBean.setRouterMap(this.getGroupRouter(menulist));
        return menuFPcBean;
    }

    public static void main(String[] args) {
        ArrayList<MenuInfoBean> list = new ArrayList<MenuInfoBean>();
        MenuInfoBean menuInfoBean = new MenuInfoBean();
        list.add(menuInfoBean);
        menuInfoBean.setProappMenuCode("001");
        menuInfoBean.setProappMenuPcode("-1");
        ArrayList<MenuInfoBean> childlist = new ArrayList<MenuInfoBean>();
        menuInfoBean.setChildren(childlist);
        MenuInfoBean menuInfoBean2 = new MenuInfoBean();
        childlist.add(menuInfoBean2);
        menuInfoBean2.setProappMenuCode("001001");
        menuInfoBean2.setProappMenuPcode("001");
        ArrayList<MenuInfoBean> childlist1 = new ArrayList<MenuInfoBean>();
        menuInfoBean2.setChildren(childlist1);
        MenuInfoBean menuInfoBean4 = new MenuInfoBean();
        childlist1.add(menuInfoBean4);
        menuInfoBean4.setProappMenuCode("001001001");
        menuInfoBean4.setProappMenuPcode("001001");
        menuInfoBean4.setAppmanageIcode("inv");
        menuInfoBean4.setMenuCode("u002");
        MenuInfoBean menuInfoBean3 = new MenuInfoBean();
        childlist.add(menuInfoBean3);
        menuInfoBean3.setAppmanageIcode("goods");
        menuInfoBean3.setMenuCode("u001");
        menuInfoBean3.setProappMenuCode("001002");
        menuInfoBean3.setProappMenuPcode("001");
        MenuInfoBean menuInfoBean1 = new MenuInfoBean();
        list.add(menuInfoBean1);
        menuInfoBean1.setProappMenuCode("002");
        menuInfoBean1.setProappMenuPcode("-1");
        ArrayList<MenuInfoBean> childlist21 = new ArrayList<MenuInfoBean>();
        menuInfoBean1.setChildren(childlist21);
        MenuInfoBean menuInfoBean22 = new MenuInfoBean();
        childlist21.add(menuInfoBean22);
        menuInfoBean22.setProappMenuCode("002001");
        menuInfoBean22.setProappMenuPcode("002");
        ArrayList<MenuInfoBean> childlist22 = new ArrayList<MenuInfoBean>();
        menuInfoBean22.setChildren(childlist22);
        MenuInfoBean menuInfoBean41 = new MenuInfoBean();
        childlist22.add(menuInfoBean41);
        menuInfoBean41.setProappMenuCode("002002001");
        menuInfoBean41.setProappMenuPcode("002001");
        menuInfoBean41.setAppmanageIcode("inv");
        menuInfoBean41.setMenuCode("u022");
        MenuInfoBean menuInfoBean31 = new MenuInfoBean();
        childlist21.add(menuInfoBean31);
        menuInfoBean31.setAppmanageIcode("goods");
        menuInfoBean31.setMenuCode("u021");
        menuInfoBean31.setProappMenuCode("002002");
        menuInfoBean31.setProappMenuPcode("002");
        MindexCon mindexCon = new MindexCon();
        Map<String, List<MenuInfoBean>> map = mindexCon.getGroupRouter(list);
        System.out.println(map);
    }

    private Map<String, List<MenuInfoBean>> getGroupRouter(List<MenuInfoBean> menulist) {
        if (ListUtil.isEmpty(menulist)) {
            return null;
        }
        HashMap<String, MenuInfoBean> partMap = new HashMap<String, MenuInfoBean>();
        HashMap<String, MenuInfoBean> menuMap = new HashMap<String, MenuInfoBean>();
        HashMap<String, String> partCodeMap = new HashMap<String, String>();
        for (MenuInfoBean menuInfoBean : menulist) {
            this.makeGroupRouter(menuInfoBean, partCodeMap, partMap, menuMap, menuInfoBean.getProappMenuCode());
        }
        if (null == menuMap || menuMap.isEmpty()) {
            return null;
        }
        HashMap<String, List<MenuInfoBean>> returnmenuMap = new HashMap<String, List<MenuInfoBean>>();
        HashMap<String, MenuInfoBean> partListMap = new HashMap<String, MenuInfoBean>();
        for (String key : menuMap.keySet()) {
            MenuInfoBean menuInfoBean = (MenuInfoBean)menuMap.get(key);
            MenuInfoBean menuInfoBeanRouter = new MenuInfoBean();
            try {
                BeanUtils.copyAllPropertys((Object)menuInfoBeanRouter, (Object)menuInfoBean);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String appIcode = menuInfoBeanRouter.getAppmanageIcode();
            this.makeRe(returnmenuMap, partListMap, menuInfoBeanRouter, partCodeMap, partMap, appIcode);
        }
        return returnmenuMap;
    }

    private void makeRe(Map<String, List<MenuInfoBean>> returnmenuMap, Map<String, MenuInfoBean> partListMap, MenuInfoBean menuInfoBeanRouterChild, Map<String, String> partCodeMap, Map<String, MenuInfoBean> partMap, String appIcode) {
        ArrayList<MenuInfoBean> childList;
        if (null == returnmenuMap || null == partListMap || null == partCodeMap || null == partMap || null == menuInfoBeanRouterChild) {
            return;
        }
        String proappMenuPcode = menuInfoBeanRouterChild.getProappMenuPcode();
        if (StringUtils.isBlank((String)proappMenuPcode)) {
            return;
        }
        if ("-1".equals(proappMenuPcode)) {
            return;
        }
        MenuInfoBean menuInfoBean = partMap.get(proappMenuPcode);
        if (null == menuInfoBean) {
            return;
        }
        MenuInfoBean menuInfoBeanRouter = partListMap.get(proappMenuPcode + "-" + appIcode);
        if (null == menuInfoBeanRouter) {
            menuInfoBeanRouter = new MenuInfoBean();
            try {
                BeanUtils.copyAllPropertys((Object)menuInfoBeanRouter, (Object)menuInfoBean);
            }
            catch (Exception exception) {
                // empty catch block
            }
            partListMap.put(proappMenuPcode + "-" + appIcode, menuInfoBeanRouter);
            childList = new ArrayList();
            menuInfoBeanRouter.setRoutechildren(null);
            menuInfoBeanRouter.setChildren(childList);
            if ("-1".equals(menuInfoBeanRouter.getProappMenuPcode())) {
                List<MenuInfoBean> plist = returnmenuMap.get(appIcode);
                if (null == plist) {
                    plist = new ArrayList<MenuInfoBean>();
                    returnmenuMap.put(appIcode, plist);
                }
                plist.add(menuInfoBeanRouter);
            }
        } else {
            childList = menuInfoBeanRouter.getChildren();
            if (null == childList) {
                childList = new ArrayList<MenuInfoBean>();
                menuInfoBeanRouter.setChildren(childList);
            }
        }
        if (!childList.contains(menuInfoBeanRouterChild)) {
            childList.add(menuInfoBeanRouterChild);
        }
        this.makeRe(returnmenuMap, partListMap, menuInfoBeanRouter, partCodeMap, partMap, appIcode);
    }

    private void makeGroupRouter(MenuInfoBean menuInfoBean, Map<String, String> partCodeMap, Map<String, MenuInfoBean> partMap, Map<String, MenuInfoBean> menuMap, String proappMenuCode) {
        if (null == menuInfoBean || null == partMap || null == menuMap || null == partCodeMap) {
            return;
        }
        menuInfoBean.setProappModelCode(proappMenuCode);
        if (StringUtils.isNotBlank((String)menuInfoBean.getMenuCode()) && StringUtils.isNotBlank((String)menuInfoBean.getAppmanageIcode())) {
            partCodeMap.put(menuInfoBean.getProappMenuCode(), menuInfoBean.getProappMenuPcode());
            menuMap.put(menuInfoBean.getProappMenuCode(), menuInfoBean);
            if (ListUtil.isNotEmpty((Collection)menuInfoBean.getChildren()) || ListUtil.isNotEmpty((Collection)menuInfoBean.getRoutechildren())) {
                partMap.put(menuInfoBean.getProappMenuCode(), menuInfoBean);
            }
        } else {
            partMap.put(menuInfoBean.getProappMenuCode(), menuInfoBean);
            partCodeMap.put(menuInfoBean.getProappMenuCode(), menuInfoBean.getProappMenuPcode());
        }
        if (ListUtil.isNotEmpty((Collection)menuInfoBean.getChildren())) {
            for (MenuInfoBean menuInfoBean1 : menuInfoBean.getChildren()) {
                this.makeGroupRouter(menuInfoBean1, partCodeMap, partMap, menuMap, proappMenuCode);
            }
        }
    }

    @RequestMapping(value={"menuComQuery.json"})
    @ResponseBody
    public List<MenuInfoBean> menuComQuery(HttpServletRequest request, String appPath, String menuParentCode) {
        String tenantCode = this.getTenantCode(request);
        String proappCode = this.getProappCode(request);
        UserSession userSession = this.getUserSession(request);
        List<MenuInfoBean> menulist = null;
        if (null == userSession) {
            List<MenuInfoBean> menuList = this.getMenu(request);
            if (null != menuList && !menuList.isEmpty()) {
                List<MenuInfoBean> childList = null;
                for (MenuInfoBean menuBean : menuList) {
                    if (StringUtils.isNotBlank((String)appPath) && appPath.equals(menuBean.getMenuJspath())) {
                        childList = this.makeMenu(menuBean.getProappMenuCode(), proappCode, tenantCode);
                        return childList;
                    }
                    if (!StringUtils.isNotBlank((String)menuParentCode) || !menuBean.getProappMenuCode().equals(menuParentCode)) continue;
                    childList = this.makeMenu(menuBean.getProappMenuCode(), proappCode, tenantCode);
                    return childList;
                }
            }
        } else {
            menulist = this.getMenuPer(request, tenantCode, proappCode);
        }
        if (null == menulist || menulist.isEmpty()) {
            return null;
        }
        for (MenuInfoBean menuInfoBean : menulist) {
            if (StringUtils.isNotBlank((String)menuParentCode) && menuInfoBean.getProappMenuCode().equals(menuParentCode)) {
                return menuInfoBean.getChildren();
            }
            if (!StringUtils.isNotBlank((String)appPath) || !appPath.equals(menuInfoBean.getMenuJspath())) continue;
            return menuInfoBean.getChildren();
        }
        return null;
    }

    @RequestMapping(value={"menuPerQuery.json"})
    @ResponseBody
    public List<MenuInfoBean> menuPerQuery(HttpServletRequest request, String appPath, String menuParentCode) {
        String tenantCode = this.getTenantCode(request);
        String proappCode = this.getProappCode(request);
        List<MenuInfoBean> menulist = null;
        menulist = this.getMenuPer(request, tenantCode, proappCode);
        if (null == menulist || menulist.isEmpty()) {
            return null;
        }
        for (MenuInfoBean menuInfoBean : menulist) {
            if (StringUtils.isNotBlank((String)menuParentCode) && menuInfoBean.getProappMenuCode().equals(menuParentCode)) {
                return menuInfoBean.getChildren();
            }
            if (!StringUtils.isNotBlank((String)appPath) || !appPath.equals(menuInfoBean.getMenuJspath())) continue;
            return menuInfoBean.getChildren();
        }
        return null;
    }

    private List<MenuInfoBean> getMenu(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        String proappCode = this.getProappCode(request);
        List<MenuInfoBean> menuList = this.navQuery(proappCode, tenantCode);
        return menuList;
    }

    @RequestMapping(value={"index.json"})
    @ResponseBody
    public IndexBean index(HttpServletRequest request) {
        IndexBean indexBean = new IndexBean();
        UserInfo userInfo = this.getUserInfo(request);
        indexBean.setUserInfo(userInfo);
        return indexBean;
    }

    @RequestMapping(value={"indexMem.json"}, name="\u7528\u6237\u7aef\u4e2a\u4eba\u4e2d\u5fc3")
    @ResponseBody
    public IndexBean indexMem(HttpServletRequest request) {
        SupQueryResult<PmUserCouponReDomain> pmUserCouponReDomainQuery;
        String tenantCode;
        String faccountType;
        List<VdFaccountInfo> vdFaccountInfos;
        IndexBean indexBean = new IndexBean();
        UserInfo userInfo = this.getUserInfo(request);
        userInfo.setFlag(false);
        indexBean.setUserInfo(userInfo);
        indexBean.setFlag(false);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        indexBean.setDataMap(dataMap);
        UserSession session = this.getUserSession(request);
        String merchantCode = session.getUserPcode();
        String type = merchantCode.substring(0, 1);
        String fundType = "";
        if (StringUtils.isBlank((String)fundType)) {
            fundType = "01";
        }
        if (ListUtil.isNotEmpty(vdFaccountInfos = this.vdFaccountService.queryOuterFaccount(merchantCode, faccountType = type + fundType, tenantCode = this.getTenantCode(request)))) {
            VdFaccountInfo vdFaccountInfo = vdFaccountInfos.get(0);
            dataMap.put("myWalletEmp", vdFaccountInfo.getFaccountAmount());
        }
        Map<String, Object> param = this.assemMapParam(request);
        param.put("fuzzy", false);
        param.put("memberBcode", session.getUserPcode());
        param.put("tenantCode", tenantCode);
        param.put("dataState", 0);
        param.put("validState", 0);
        SupQueryResult<GtGiftUserReDomain> gtGiftUserReDomainQuey = this.gtGiftUserService.queryGiftUserPage(param);
        if (null != gtGiftUserReDomainQuey && null != gtGiftUserReDomainQuey.getList()) {
            dataMap.put("staGift", gtGiftUserReDomainQuey.getList().size());
        }
        if (null != (pmUserCouponReDomainQuery = this.pmUserCouponService.queryUserCouponPage(param)) && null != pmUserCouponReDomainQuery.getList()) {
            dataMap.put("couponList", pmUserCouponReDomainQuery.getList().size());
        }
        Map<String, Object> params = this.assemMapParam(request);
        params.put("fuzzy", false);
        UserSession userSession = this.getUserSession(request);
        params.put("giftUserType", "2");
        params.put("sendState", 1);
        params.put("dataState", 0);
        params.put("memberBcode", userSession.getUserPcode());
        params.put("validState", 0);
        SupQueryResult<GtGiftUserReDomain> gtGiftUserrelReDomainList = this.gtGiftUserService.queryGiftUserPage(params);
        if (null != gtGiftUserrelReDomainList && null != gtGiftUserrelReDomainList.getList()) {
            dataMap.put("vcompGift", gtGiftUserrelReDomainList.getList().size());
        }
        return indexBean;
    }

    private List<MenuInfoBean> getMenuPer(HttpServletRequest request, String tenantCode, String proappCode) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        HashMap<String, String> userperMap = userSession.getMap();
        if (null == userperMap) {
            userperMap = new HashMap<String, String>();
        }
        userperMap.put("userinfoCode", userSession.getUserPcode());
        userperMap.put("userType", String.valueOf(userSession.getUserType()));
        List menuList = this.authService.getUserPerMenuTree(userSession.getMap(), proappCode, tenantCode);
        return menuList;
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public List<MenuInfoBean> listQuery(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        String proappCode = this.getProappCode(request);
        return this.navQuery(proappCode, tenantCode);
    }

    @RequestMapping(value={"menuQuery.json"})
    @ResponseBody
    public List<MenuInfoBean> menuQuery(HttpServletRequest request, String menuParentCode) {
        String tenantCode = this.getTenantCode(request);
        String proappCode = this.getProappCode(request);
        return this.makeMenu(menuParentCode, proappCode, tenantCode);
    }

    private List<MenuInfoBean> navQuery(String proappCode, String tenantCode) {
        return this.authService.navQuery(proappCode, tenantCode);
    }

    private List<MenuInfoBean> makeMenu(String menuParentCode, String proappCode, String tenantCode) {
        return this.authService.makeMenu(menuParentCode, proappCode, tenantCode);
    }

    @RequestMapping(value={"defaultAccess.json"}, name="\u9ed8\u8ba4\u8bbf\u95ee")
    @ResponseBody
    public HtmlJsonReBean defaultAccess(HttpServletRequest request) {
        return new HtmlJsonReBean();
    }
}

