/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.upm;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.upm.PreviewReDomain;
import cn.com.qj.bff.domain.upm.UpmPointsDomain;
import cn.com.qj.bff.domain.upm.UpmPointsReDomain;
import cn.com.qj.bff.domain.upm.UpmPointsRuleReDomain;
import cn.com.qj.bff.interceptor.service.BaseInterUtil;
import cn.com.qj.bff.service.upm.UpmPointsRuleService;
import cn.com.qj.bff.service.upm.UpmPointsService;
import cn.com.qj.bff.service.upm.UpmUpointsService;
import cn.com.qj.bff.springmvc.SpringmvnNewController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/upm/upmpoints"}, name="\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1")
public class UpmpointsCon
extends SpringmvnNewController {
    private static String CODE = "upm.upmpoints.con";
    @Autowired
    private UpmUpointsService upmUpointsService;
    @Autowired
    private UpmPointsService upmPointsService;
    @Autowired
    private UpmPointsRuleService upmPointsRuleService;

    @Override
    protected String getContext() {
        return "upmpoints";
    }

    @RequestMapping(value={"saveUpmpoints.json"}, name="\u589e\u52a0\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveUpmpoints(HttpServletRequest request, UpmPointsDomain upmpointsDomain) {
        if (null == upmpointsDomain) {
            this.logger.error(CODE + ".saveUpmpoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveUpmpoints", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        upmpointsDomain.setTenantCode(this.getTenantCode(request));
        upmpointsDomain.setMemberCode(userSession.getUserPcode());
        upmpointsDomain.setUpointsType("0");
        return this.upmPointsService.savePoints(upmpointsDomain);
    }

    @RequestMapping(value={"addorupdateUpmpoints.json"}, name="\u79ef\u5206\u8bbe\u7f6e\u65b0\u589e\u6216\u4fee\u6539")
    @ResponseBody
    public HtmlJsonReBean addorupdateUpmpoints(HttpServletRequest request, UpmPointsDomain upmpointsDomain) {
        if (null == upmpointsDomain) {
            this.logger.error(CODE + ".saveUpmpoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (null == upmpointsDomain.getPointsLimit()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == upmpointsDomain.getPointsRatio()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u79ef\u5206\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == upmpointsDomain.getPointsId()) {
            UserSession userSession = this.getUserSession(request);
            if (null == userSession) {
                this.logger.error(CODE + ".saveUpmpoints", (Object)"userSession is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
            }
            upmpointsDomain.setTenantCode(this.getTenantCode(request));
            upmpointsDomain.setMemberCode(userSession.getUserPcode());
            upmpointsDomain.setUpointsType("0");
            return this.upmPointsService.savePoints(upmpointsDomain);
        }
        upmpointsDomain.setUpointsType("0");
        upmpointsDomain.setTenantCode(this.getTenantCode(request));
        return this.upmPointsService.updatePoints(upmpointsDomain);
    }

    @RequestMapping(value={"getUpmpoints.json"}, name="\u83b7\u53d6\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public UpmPointsReDomain getUpmpoints(Integer pointsId) {
        if (StringUtils.isBlank((Integer)pointsId)) {
            this.logger.error(CODE + ".getUpmpoints", (Object)"param is null");
            return null;
        }
        return this.upmPointsService.getPoints(pointsId);
    }

    @RequestMapping(value={"getPointsByCode.json"}, name="\u6839\u636eCODE\u67e5\u8be2\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public UpmPointsReDomain getPointsByCode(HttpServletRequest request, String pointsCode) {
        if (StringUtils.isBlank((String)pointsCode)) {
            this.logger.error(CODE + ".getPointsByCode", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        return this.upmPointsService.getPointsByCode(tenantCode, pointsCode);
    }

    @RequestMapping(value={"getRulePreview.json"}, name="\u79ef\u5206\u89c4\u5219\u9884\u89c8")
    @ResponseBody
    public PreviewReDomain getRulePreview(HttpServletRequest request) {
        SupQueryResult<UpmPointsReDomain> upmPoints;
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null == (upmPoints = this.upmPointsService.queryPointsPage(param)) || upmPoints.getList().size() < 0) {
            this.logger.error(CODE + ".getRulePreview", (Object)"param is null");
            return null;
        }
        PreviewReDomain previewReDomain = new PreviewReDomain();
        UpmPointsReDomain upmPointsReDomain = (UpmPointsReDomain)upmPoints.getList().get(0);
        previewReDomain.setPointsRatio(upmPointsReDomain.getPointsRatio());
        previewReDomain.setPointsLimit(upmPointsReDomain.getPointsLimit());
        SupQueryResult<UpmPointsRuleReDomain> upmPointsRule = this.upmPointsRuleService.queryPointsRulePage(param);
        if (null == upmPointsRule || upmPointsRule.getList().size() <= 0) {
            this.logger.error(CODE + ".getRulePreview", (Object)"param is null");
            return null;
        }
        List upmPointsRuleList = upmPointsRule.getList();
        previewReDomain.setPointsRuleRatioList(upmPointsRuleList);
        return previewReDomain;
    }

    @RequestMapping(value={"updateUpmpoints.json"}, name="\u66f4\u65b0\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateUpmpoints(HttpServletRequest request, UpmPointsDomain upmpointsDomain) {
        if (null == upmpointsDomain) {
            this.logger.error(CODE + ".updateUpmpoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        upmpointsDomain.setTenantCode(this.getTenantCode(request));
        return this.upmPointsService.updatePoints(upmpointsDomain);
    }

    @RequestMapping(value={"deleteUpmpoints.json"}, name="\u5220\u9664\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteUpmpoints(Integer pointsId) {
        if (StringUtils.isBlank((Integer)pointsId)) {
            this.logger.error(CODE + ".deleteUpmpoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.upmPointsService.deletePoints(pointsId);
    }

    @RequestMapping(value={"queryUpmpointsPage.json"}, name="\u67e5\u8be2\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UpmPointsReDomain> queryUpmpointsPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        BaseInterUtil.setMapRequest(param, (HttpServletRequest)request);
        return this.upmPointsService.queryPointsPage(param);
    }

    @RequestMapping(value={"queryUpmpointsTPage.json"}, name="\u67e5\u8be2\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1\u5206\u9875\u5217\u8868\u7248\u672c2")
    @ResponseBody
    public UpmPointsReDomain queryUpmpointsTPage(HttpServletRequest request) {
        SupQueryResult<UpmPointsReDomain> upmPointsResult;
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        BaseInterUtil.setMapRequest(param, (HttpServletRequest)request);
        if (null != param) {
            this.logger.info(HtmlJsonReBean.ERRORCODE, (Object)("-------\u67e5\u8be2\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1\u5206\u9875\u5217\u8868\u7248\u672c2------" + userSession.getUserPcode()));
            param.put("memberMcode", userSession.getUserPcode());
            param.put("tenantCode", userSession.getTenantCode());
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (ListUtil.isEmpty((Collection)(upmPointsResult = this.upmPointsService.queryPointsPage(param)).getList())) {
            param.put("memberMname", userSession.getMerberCompname());
            param.put("channelName", this.getChannelName(param.get("channelCode").toString(), request));
            HtmlJsonReBean htmlJsonReBean = this.upmPointsService.savePointsInitialization(param);
            param.remove("channelName");
            if (null != htmlJsonReBean && htmlJsonReBean.isSuccess()) {
                upmPointsResult = this.upmPointsService.queryPointsPage(param);
            }
            if (ListUtil.isEmpty((Collection)upmPointsResult.getList())) {
                return null;
            }
        }
        UpmPointsReDomain upmPointsReDomain = (UpmPointsReDomain)upmPointsResult.getList().get(0);
        HashMap<String, Object> pMap = new HashMap<String, Object>();
        pMap.put("order", true);
        pMap.put("fuzzy", true);
        pMap.put("tenantCode", userSession.getTenantCode());
        pMap.put("upointsType", upmPointsReDomain.getUpointsType());
        pMap.put("memberMcode", userSession.getUserPcode());
        SupQueryResult<UpmPointsRuleReDomain> upmPointsRuleResult = this.upmPointsRuleService.queryPointsRulePage(pMap);
        if (ListUtil.isEmpty((Collection)upmPointsRuleResult.getList())) {
            return null;
        }
        upmPointsReDomain.setUpmPointsRuleReDomains(upmPointsRuleResult.getList());
        return upmPointsReDomain;
    }

    @RequestMapping(value={"queryUpmpointsForC.json"}, name="\u67e5\u8be2\u79ef\u5206\u8bbe\u7f6e-\u5c0f\u7a0b\u5e8f")
    @ResponseBody
    public UpmPointsReDomain queryUpmpointsForC(HttpServletRequest request) {
        UserSession userSession;
        String channelCode;
        Map<String, Object> param = this.assemMapParam(request);
        String string = channelCode = null == param.get("channelCode") ? null : (String)param.get("channelCode");
        if (StringUtils.isNotBlank((String)channelCode)) {
            param.remove(channelCode);
        }
        if (null == (userSession = this.getUserSession(request))) {
            this.logger.error(CODE + ".queryUpmpointsForC", (Object)"\u672a\u767b\u9646");
            return null;
        }
        param.put("memberMcode", userSession.getUserinfoParentCode());
        param.put("tenantCode", userSession.getTenantCode());
        param.put("fuzzy", false);
        SupQueryResult<UpmPointsReDomain> upmPointsResult = this.upmPointsService.queryPointsPage(param);
        if (ListUtil.isEmpty((Collection)upmPointsResult.getList())) {
            param.put("memberMname", userSession.getMerberCompname());
            HtmlJsonReBean htmlJsonReBean = this.upmPointsService.savePointsInitialization(param);
            this.logger.info(HtmlJsonReBean.ERRORCODE + ".htmlJsonReBean", (Object)JsonUtil.buildNormalBinder().toJson((Object)htmlJsonReBean));
            if (null != htmlJsonReBean && htmlJsonReBean.isSuccess()) {
                upmPointsResult = this.upmPointsService.queryPointsPage(param);
            }
            if (ListUtil.isEmpty((Collection)upmPointsResult.getList())) {
                this.logger.error(CODE + ".queryUpmpointsForC.upmPointsResult.null", param);
                return null;
            }
        }
        UpmPointsReDomain upmPointsReDomain = (UpmPointsReDomain)upmPointsResult.getList().get(0);
        param.put("upointsType", upmPointsReDomain.getUpointsType());
        SupQueryResult<UpmPointsRuleReDomain> upmPointsRuleResult = this.upmPointsRuleService.queryPointsRulePage(param);
        if (ListUtil.isEmpty((Collection)upmPointsRuleResult.getList())) {
            this.logger.error(CODE + ".queryUpmpointsForC.upmPointsRuleResult.null", param);
            return null;
        }
        upmPointsReDomain.setUpmPointsRuleReDomains(upmPointsRuleResult.getList());
        return upmPointsReDomain;
    }

    @RequestMapping(value={"updateUpmpointsState.json"}, name="\u66f4\u65b0\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateUpmpointsState(String pointsId) {
        if (StringUtils.isBlank((String)pointsId)) {
            this.logger.error(CODE + ".updateUpmpointsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.upmPointsService.updatePointsState(Integer.valueOf(pointsId), 1, 0);
    }

    @RequestMapping(value={"stoppedUpmpointsState.json"}, name="\u505c\u7528\u79ef\u5206\u83b7\u53d6")
    @ResponseBody
    public HtmlJsonReBean stoppedUpmpointsState(String pointsId) {
        if (StringUtils.isBlank((String)pointsId)) {
            this.logger.error(CODE + ".stoppedUpmpointsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.upmPointsService.updatePointsState(Integer.valueOf(pointsId), 0, 1);
    }

    @RequestMapping(value={"loadCache.json"}, name="\u73b0\u91d1\u79ef\u5206\u540c\u6b65")
    @ResponseBody
    public HtmlJsonReBean loadCache() {
        return this.upmPointsService.loadCache();
    }

    @RequestMapping(value={"queryPointsCache.json"}, name="\u79ef\u5206\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean queryPointsCache() {
        return this.upmPointsService.queryPointsCache();
    }

    @RequestMapping(value={"saveUpmpointsStr.json"}, name="\u589e\u52a0\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveUpmpointsStr(HttpServletRequest request, String upmpointsDomainStr) {
        if (StringUtils.isBlank((String)upmpointsDomainStr)) {
            this.logger.error(CODE + ".saveUpmpointsStr", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UpmPointsDomain upmPointsDomain = (UpmPointsDomain)JsonUtil.buildNormalBinder().getJsonToObject(upmpointsDomainStr, UpmPointsDomain.class);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveUpmpointsStr", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        upmPointsDomain.setTenantCode(this.getTenantCode(request));
        upmPointsDomain.setMemberMcode(userSession.getUserPcode());
        upmPointsDomain.setMemberMname(userSession.getUserName());
        upmPointsDomain.setUpointsType("0");
        return this.upmPointsService.savePoints(upmPointsDomain);
    }

    @RequestMapping(value={"queryUpmpointsPageStr.json"}, name="\u67e5\u8be2\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UpmPointsReDomain> queryUpmpointsPageStr(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        UserSession userSession = this.getUserSession(request);
        param.put("memberMcode", userSession.getUserPcode());
        param.put("tenantCode", this.getTenantCode(request));
        param.put("upointsType", "0");
        return this.upmPointsService.queryPointsPage(param);
    }

    @RequestMapping(value={"queryUpmpointResulPageStr.json"}, name="\u67e5\u8be2\u79ef\u5206\u8bbe\u7f6e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public UpmPointsReDomain queryUpmpointResulPageStr(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
        }
        UserSession userSession = this.getUserSession(request);
        param.put("memberMcode", userSession.getUserPcode());
        param.put("tenantCode", this.getTenantCode(request));
        param.put("upointsType", "0");
        SupQueryResult<UpmPointsReDomain> result = this.upmPointsService.queryPointsPage(param);
        if (ListUtil.isEmpty((Collection)result.getList())) {
            return null;
        }
        UpmPointsReDomain upmPointsReDomain = (UpmPointsReDomain)result.getList().get(0);
        SupQueryResult<UpmPointsRuleReDomain> ruleResult = this.upmPointsRuleService.queryPointsRulePage(param);
        upmPointsReDomain.setUpmPointsRuleReDomains(ruleResult.getList());
        return upmPointsReDomain;
    }

    @Override
    protected List<Map<String, Object>> makeExcelData(String json, String apiRouter, String excelTemplate) {
        return null;
    }
}

