/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.promotion;

import cn.com.qj.bff.controller.promotion.ExcelExportTemplate;
import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.oc.OcContractGoodsDomain;
import cn.com.qj.bff.domain.oc.OcContractReDomain;
import cn.com.qj.bff.domain.pm.PmPromotionConditionDomain;
import cn.com.qj.bff.domain.pm.PmPromotionDisDomain;
import cn.com.qj.bff.domain.pm.PmPromotionDiscountDomain;
import cn.com.qj.bff.domain.pm.PmPromotionDiscountlistDomain;
import cn.com.qj.bff.domain.pm.PmPromotionDomain;
import cn.com.qj.bff.domain.pm.PmPromotionRangelistDomain;
import cn.com.qj.bff.domain.pm.PmPromotionRangelistReDomain;
import cn.com.qj.bff.domain.pm.PmPromotionReDomain;
import cn.com.qj.bff.domain.pm.PmPromotionSavgReDomain;
import cn.com.qj.bff.domain.pm.PmPromotionSupDomain;
import cn.com.qj.bff.domain.pm.PmPromotionTargetlistDomain;
import cn.com.qj.bff.domain.pm.PmUserCouponReDomain;
import cn.com.qj.bff.domain.rs.RsSkuReDomain;
import cn.com.qj.bff.domain.tm.TmProappEnvReDomain;
import cn.com.qj.bff.domain.um.UmUserinfoReDomainBean;
import cn.com.qj.bff.service.oc.OcContractService;
import cn.com.qj.bff.service.pm.PmPromotionRangelistService;
import cn.com.qj.bff.service.pm.PmPromotionSavgService;
import cn.com.qj.bff.service.pm.PmPromotionService;
import cn.com.qj.bff.service.pm.PmUserCouponService;
import cn.com.qj.bff.service.pm.PmUserCouponsendService;
import cn.com.qj.bff.service.rs.RsGoodsClassService;
import cn.com.qj.bff.service.rs.RsSkuService;
import cn.com.qj.bff.service.tm.TmProappService;
import cn.com.qj.bff.service.um.UserService;
import cn.com.qj.bff.springmvc.SpringmvnNewController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class PromotionSupCon
extends SpringmvnNewController {
    private static final String CODE = "pm.promotionsup.con";
    @Autowired
    private PmPromotionService pmPromotionService;
    @Autowired
    private RsGoodsClassService rsGoodsClassService;
    @Autowired
    private RsSkuService rsSkuService;
    @Autowired
    private TmProappService tmProappService;
    @Autowired
    private PmUserCouponService pmUserCouponService;
    @Autowired
    private UserService userService;
    @Autowired
    PmUserCouponsendService pmUserCouponsendService;
    @Autowired
    private PmPromotionRangelistService pmPromotionRangelistService;
    @Autowired
    protected OcContractService ocContractService;
    @Autowired
    protected PmPromotionSavgService pmPromotionSavgService;
    protected static String TYPE_PLAT = "plat";
    protected static String TYPE_BUS = "bus";
    protected static String TYPE_USER = "user";
    protected static String TYPE_STORE = "store";

    @Override
    protected String getContext() {
        return "promotionsup";
    }

    protected PmPromotionReDomain getPromotionPro(HttpServletRequest request, Integer promotionId) {
        return this.getPromotionplus(promotionId);
    }

    protected PmPromotionReDomain getPromotionByCodePro(HttpServletRequest request, String promotionCode) {
        if (StringUtils.isBlank((String)promotionCode)) {
            this.logger.error("pm.promotionsup.con.getPromotionByCode", (Object)"param is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession || StringUtils.isBlank((String)userSession.getUserPcode())) {
            this.logger.error("pm.promotionsup.con.userSession is null ", (Object)JsonUtil.buildNormalBinder().toJson((Object)userSession));
            return null;
        }
        return this.pmPromotionService.getPromotionByCode(this.getTenantCode(request), promotionCode);
    }

    protected HtmlJsonReBean updatePromotionStatePro(UserSession userSession, String promotionId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error("pm.promotionsup.con.updatePromotionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionService.updatePromotionState(userSession, Integer.valueOf(promotionId), dataState, oldDataState, null);
    }

    protected HtmlJsonReBean deletePromotionPlus(String promotionId) {
        String[] pidStrArray;
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error("pm.promotionsup.con.deletePromotion", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String pidStr : pidStrArray = promotionId.split(",")) {
            PmPromotionReDomain promotion = this.pmPromotionService.getPromotion(Integer.parseInt(pidStr));
            if (null == promotion || promotion.getDataState() != 0) {
                this.logger.error("pm.promotionsup.con.updatePromotion", (Object)" datastate canot update");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8425\u9500\u6d3b\u52a8\u5df2\u7ecf\u5f00\u59cb\u6216\u7ed3\u675f\u4e86\uff0c\u4e0d\u80fd\u4fee\u6539");
            }
            this.pmPromotionService.deletePromotion(Integer.parseInt(pidStr));
        }
        return new HtmlJsonReBean();
    }

    protected HtmlJsonReBean promotionStateStart(UserSession userSession, String promotionId) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error("pm.promotionsup.con.updatePromotionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionService.updatePromotionState(userSession, Integer.valueOf(promotionId), 1, 3, null);
    }

    protected HtmlJsonReBean promotionStateStop(UserSession userSession, String promotionId) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error("pm.promotionsup.con.updatePromotionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionService.updatePromotionState(userSession, Integer.valueOf(promotionId), 3, 1, null);
    }

    protected SupQueryResult<PmPromotionReDomain> promotionPageAll(HttpServletRequest request, String pbCode, String promotionType, String promotionPcode) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            if (StringUtils.isNotBlank((String)pbCode)) {
                param.put("pbCode", pbCode);
            }
            if (StringUtils.isNotBlank((String)promotionType)) {
                param.put("promotionType", promotionType);
            }
            if (StringUtils.isNotBlank((String)promotionPcode)) {
                param.put("promotionPcode", promotionPcode);
            }
        }
        return this.pmPromotionService.queryPromotionPage(param);
    }

    protected SupQueryResult<PmPromotionReDomain> promotionPage(HttpServletRequest request, String pbCode, String promotionType, String promotionPcode, Integer promotionOrgin, String type, Map<String, Object> map) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        Map<String, Object> param = this.assemMapMemberParam(request);
        String saveMemberCode = "";
        if (StringUtils.isBlank((String)type)) {
            saveMemberCode = this.checkMemquaPlat(request) ? this.getTeananMemberCode(request) : userSession.getUserPcode();
        } else if (TYPE_PLAT.equals(type)) {
            saveMemberCode = this.getTeananMemberCode(request);
        } else if (TYPE_BUS.equals(type)) {
            saveMemberCode = userSession.getUserPcode();
        } else if (TYPE_USER.equals(type)) {
            saveMemberCode = userSession.getUserPcode();
        } else if (TYPE_STORE.equals(type)) {
            param.put("memberCcode", userSession.getUserPcode());
        }
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            if (StringUtils.isNotBlank((String)saveMemberCode)) {
                param.put("memberCode", saveMemberCode);
            }
            if (StringUtils.isNotBlank((String)pbCode)) {
                param.put("pbCode", pbCode);
            }
            if (StringUtils.isNotBlank((String)promotionType)) {
                param.put("promotionType", promotionType);
            }
            if (StringUtils.isNotBlank((String)promotionPcode)) {
                param.put("promotionPcode", promotionPcode);
            }
            if (null != promotionOrgin) {
                param.put("promotionOrgin", promotionOrgin);
            }
            if ("0024".equals(pbCode)) {
                param.put("orderStr", "DEPART_SHORTNAME ASC");
            }
        }
        if (TYPE_STORE.equals(type)) {
            param.remove("memberCode");
        }
        if (MapUtil.isNotEmpty(map)) {
            param.putAll(map);
        }
        String exportFlag = null == param || null == param.get("exportFlag") ? "false" : (String)param.get("exportFlag");
        String excelTemplate = null == param || null == param.get("excelTemplate") ? "" : (String)param.get("excelTemplate");
        Boolean flag = Boolean.valueOf(exportFlag);
        if (flag.booleanValue()) {
            String userCode = null == userSession ? "" : userSession.getUserCode();
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            infoMap.put("fileName", null == param.get("fileName") ? "\u8425\u9500\u5bfc\u51fa" : param.get("fileName"));
            if ("promotionDiscount".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertPromotionDiscountExcelParam());
            } else if ("promotionPreference".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertPromotionPreferenceExcelParam());
            } else if ("promotionEnvelope".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertPromotionEnvelopeExcelParam());
            } else {
                if ("promotionPageFullSubRoll".equals(excelTemplate)) {
                    SupQueryResult<PmPromotionReDomain> pmPromotionReDomainSupQueryResult = this.pmPromotionService.queryPromotionPage(param);
                    ArrayList<Map<String, Object>> infofList = new ArrayList();
                    if (null != pmPromotionReDomainSupQueryResult && ListUtil.isNotEmpty((Collection)pmPromotionReDomainSupQueryResult.getList())) {
                        infofList = this.coverPromotionDomain(pmPromotionReDomainSupQueryResult.getList());
                    }
                    this.logger.info("pm.promotionsup.con.promotionPage.exportExcel.pmPromotionReDomainSupQueryResult", (Object)JsonUtil.buildNormalBinder().toJson(infofList));
                    this.exportExcelByData(request, "couponList", "promotionPageFullSubRoll", infofList);
                    this.logger.info("pm.promotionsup.con.promotionPage.exportExcel.promotionPageFullSubRoll", (Object)"\u5bfc\u51fa\u6210\u529f\uff01");
                    return null;
                }
                if ("GoodsTrackReport".equals(excelTemplate)) {
                    infoMap.put("fileName", "GoodsTrackReport");
                    infoMap.put("headMap", ExcelExportTemplate.covertGoodsTrackReportExcelParam());
                } else if ("OrderTrackReport".equals(excelTemplate)) {
                    infoMap.put("fileName", "OrderTrackReport");
                    infoMap.put("headMap", ExcelExportTemplate.covertOrderTrackReportExcelParam());
                } else if ("PromotionBargainPriceExport".equals(excelTemplate)) {
                    infoMap.put("fileName", "PromotionBargainPriceExport");
                    infoMap.put("headMap", ExcelExportTemplate.covertPromotionBargainPriceExportExcelParam());
                } else if ("UserTrackReport".equals(excelTemplate)) {
                    infoMap.put("fileName", "UserTrackReport");
                    infoMap.put("headMap", ExcelExportTemplate.covertUserTrackReportExcelParam());
                } else if ("UserDetailTrackReport".equals(excelTemplate)) {
                    param.put("list", "list");
                    infoMap.put("fileName", "UserDetailTrackReport");
                    infoMap.put("headMap", ExcelExportTemplate.covertUserDetailTrackReportExcelParam());
                } else if ("PromotionBargainPriceExportMJCX".equals(excelTemplate)) {
                    param.put("list", "list");
                    infoMap.put("fileName", "PromotionBargainPriceExport");
                    infoMap.put("headMap", ExcelExportTemplate.covertPromotionBargainPriceMJCXExportExcelParam());
                }
            }
            infoMap.put("userCode", userCode);
            this.logger.info("pm.promotionsup.con.promotionPage.1111", (Object)(param + "=:=" + infoMap));
            try {
                this.exportComExcel(request, param, infoMap, "pm.PmPromotion.queryPromotionPage", excelTemplate);
            }
            catch (Exception e) {
                this.logger.error("pm.promotionsup.con.promotionPage.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
                return null;
            }
            return null;
        }
        this.logger.info("pm.promotionsup.con.queryPromotionPage.param", (Object)param.toString());
        SupQueryResult<PmPromotionReDomain> pmPromotionReDomainSupQueryResult = this.pmPromotionService.queryPromotionPage(param);
        String gmvFlag = null == param || null == param.get("gmvFlag") ? "false" : (String)param.get("gmvFlag");
        Boolean gmvFlagB = Boolean.valueOf(gmvFlag);
        if (gmvFlagB.booleanValue() && null != pmPromotionReDomainSupQueryResult && ListUtil.isNotEmpty((Collection)pmPromotionReDomainSupQueryResult.getList())) {
            for (PmPromotionReDomain pmPromotionReDomain : pmPromotionReDomainSupQueryResult.getList()) {
                String promotionCode = pmPromotionReDomain.getPromotionCode();
                String tenantCode = pmPromotionReDomain.getTenantCode();
                HashMap<String, Object> parMap = new HashMap<String, Object>();
                parMap.put("promotionCode", promotionCode);
                parMap.put("tenantCode", tenantCode);
                parMap.put("dataState", 1);
                parMap.put("endRow", 1);
                parMap.put("page", 1);
                parMap.put("startRow", 0);
                parMap.put("rows", 1);
                parMap.put("pageSize", 1);
                pmPromotionReDomain.setWoTotal(this.pmUserCouponsendService.queryuserCouponsendPage(parMap).getTotal());
                parMap.put("dataState", 0);
                pmPromotionReDomain.setNotWoTotal(this.pmUserCouponsendService.queryuserCouponsendPage(parMap).getTotal());
            }
        }
        return pmPromotionReDomainSupQueryResult;
    }

    protected SupQueryResult<PmPromotionReDomain> getpromotionPageForStore(HttpServletRequest request, String pbCode, String promotionType, String promotionPcode, Integer promotionOrgin, String type) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            if (StringUtils.isNotBlank((String)pbCode)) {
                param.put("pbCode", pbCode);
            }
            if (StringUtils.isNotBlank((String)promotionType)) {
                param.put("promotionType", promotionType);
            }
            if (StringUtils.isNotBlank((String)promotionPcode)) {
                param.put("promotionPcode", promotionPcode);
            }
            if (null != promotionOrgin) {
                param.put("promotionOrgin", promotionOrgin);
            }
        }
        return this.pmPromotionService.queryPromotionPage(param);
    }

    protected PmPromotionReDomain getPromotionplus(Integer promotionId) {
        if (StringUtils.isBlank((Integer)promotionId)) {
            this.logger.error("pm.promotionsup.con.getPromotion", (Object)"param is null");
            return null;
        }
        PmPromotionReDomain pmPromotionReDomain = this.pmPromotionService.getPromotion(promotionId);
        return pmPromotionReDomain;
    }

    protected HtmlJsonReBean updatePromotionPlus(HttpServletRequest request, String paramStr, String type) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error("pm.promotionsup.con.updatePromotion", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error("pm.promotionsup.con.updatePromotion", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PmPromotionDomain promotionDomain = (PmPromotionDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, PmPromotionDomain.class);
        if (null == promotionDomain.getPromotionId()) {
            this.logger.error("pm.promotionsup.con.updatePromotion.PromotionId", (Object)"promotionId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "");
        }
        promotionDomain.setTenantCode(this.getTenantCode(request));
        String saveMemberCode = "";
        String saveMemberName = "";
        if (StringUtils.isBlank((String)type)) {
            if (this.checkMemquaPlat(request)) {
                saveMemberCode = this.getTeananMemberCode(request);
                saveMemberName = "\u5e73\u53f0";
            } else {
                saveMemberCode = userSession.getUserPcode();
                saveMemberName = userSession.getMerberCompname();
            }
        } else if (TYPE_PLAT.equals(type)) {
            saveMemberCode = this.getTeananMemberCode(request);
            saveMemberName = "\u5e73\u53f0";
        } else if (TYPE_BUS.equals(type)) {
            if (StringUtils.isNotBlank((String)userSession.getUserinfoParentCode())) {
                saveMemberCode = userSession.getUserinfoParentCode();
                saveMemberName = userSession.getUserinfoParentName();
            } else {
                saveMemberCode = userSession.getUserPcode();
                saveMemberName = userSession.getMerberCompname();
            }
            promotionDomain.setChannelCode(this.getChannelByMem(userSession.getUserPcode(), request));
            promotionDomain.setChannelName(this.getChannelName(promotionDomain.getChannelName(), request));
        } else if (TYPE_USER.equals(type)) {
            saveMemberCode = userSession.getUserPcode();
            saveMemberName = userSession.getMerberCompname();
        }
        promotionDomain.setMemberCode(saveMemberCode);
        promotionDomain.setMemberName(saveMemberName);
        PmPromotionReDomain pmPromotionReDomain = this.pmPromotionService.getPromotion(promotionDomain.getPromotionId());
        if (null == pmPromotionReDomain && 4 == pmPromotionReDomain.getDataState()) {
            this.pmPromotionService.updatePromotionState(userSession, pmPromotionReDomain.getPromotionId(), 0, 4, null);
        }
        return this.pmPromotionService.updatePromotion(promotionDomain);
    }

    protected HtmlJsonReBean savePromotionPlus(HttpServletRequest request, String paramStr, String channelCode, String memberCode, String pbCode, String type) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error("pm.promotionsup.con.savePromotionPlus", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error("pm.promotionsup.con.savePromotionPlus", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PmPromotionDomain promotionDomain = (PmPromotionDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, PmPromotionDomain.class);
        if (null == promotionDomain) {
            this.logger.error("pm.promotionsup.con.savePromotionPlus", (Object)"promotionDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        promotionDomain.setPbCode(pbCode);
        if (!this.checkPromotionDomain(promotionDomain).booleanValue()) {
            this.logger.error("pm.promotionsup.con.savePromotionPlus.checkPromotionDomain.error");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5f02\u5e38");
        }
        String saveMemberCode = "";
        String saveMemberName = "";
        if (StringUtils.isBlank((String)type)) {
            if (this.checkMemquaPlat(request)) {
                saveMemberCode = this.getTeananMemberCode(request);
                saveMemberName = "\u5e73\u53f0";
                promotionDomain.setGoodsClass("plat");
            } else {
                saveMemberCode = userSession.getUserPcode();
                saveMemberName = userSession.getMerberCompname();
                promotionDomain.setChannelCode(this.getChannelByMem(saveMemberCode, request));
            }
        } else if (TYPE_PLAT.equals(type)) {
            saveMemberCode = this.getTeananMemberCode(request);
            saveMemberName = "\u5e73\u53f0";
            promotionDomain.setGoodsClass("plat");
        } else if (TYPE_BUS.equals(type)) {
            saveMemberCode = userSession.getUserPcode();
            saveMemberName = userSession.getMerberCompname();
            promotionDomain.setChannelCode(this.getChannelByMem(saveMemberCode, request));
        } else if (TYPE_USER.equals(type)) {
            saveMemberCode = userSession.getUserPcode();
            saveMemberName = userSession.getMerberCompname();
            promotionDomain.setChannelCode(this.getChannelByMem(saveMemberCode, request));
            String check = "";
            check = PromotionSupCon.getCheck(userSession.getTenantCode(), "check", "check");
            if (StringUtils.isNotBlank((String)check)) {
                promotionDomain.setChannelCode(null);
            }
        }
        if (StringUtils.isNotBlank((String)promotionDomain.getChannelCode())) {
            promotionDomain.setChannelName(this.getChannelName(promotionDomain.getChannelCode(), request));
            promotionDomain.setGoodsClass(this.getGoodsClassByMem(promotionDomain.getChannelCode(), request));
        } else {
            promotionDomain.setGoodsClass("plat");
        }
        if (StringUtils.isNotBlank((String)channelCode)) {
            List<PmPromotionDisDomain> pmPromotionDisLists = promotionDomain.getPmPromotionDisList();
            if (null == pmPromotionDisLists) {
                pmPromotionDisLists = new ArrayList<PmPromotionDisDomain>();
                promotionDomain.setPmPromotionDisList(pmPromotionDisLists);
            }
            PmPromotionDisDomain pmPromotionDisDomain = new PmPromotionDisDomain();
            pmPromotionDisDomain.setMemberCode(saveMemberCode);
            pmPromotionDisDomain.setMemberName(saveMemberName);
            pmPromotionDisLists.add(pmPromotionDisDomain);
        }
        if (StringUtils.isNotBlank((String)memberCode)) {
            List<PmPromotionSupDomain> pmPromotionSupDomains = promotionDomain.getPmPromotionSupList();
            if (null == pmPromotionSupDomains) {
                pmPromotionSupDomains = new ArrayList<PmPromotionSupDomain>();
                promotionDomain.setPmPromotionSupList(pmPromotionSupDomains);
            }
            PmPromotionSupDomain pmPromotionSupDomain = new PmPromotionSupDomain();
            pmPromotionSupDomain.setPpsupMemcode(saveMemberCode);
            pmPromotionSupDomain.setPpsupName(saveMemberName);
            pmPromotionSupDomains.add(pmPromotionSupDomain);
        }
        promotionDomain.setAppmanageIcode(this.getProappCode(request));
        promotionDomain.setTenantCode(this.getTenantCode(request));
        promotionDomain.setMemberCode(saveMemberCode);
        promotionDomain.setMemberName(saveMemberName);
        promotionDomain.setPromotionId(null);
        promotionDomain.setPromotionCode(null);
        List<PmPromotionRangelistDomain> pmPromotionRangeList = promotionDomain.getPmPromotionRangeList();
        if (ListUtil.isNotEmpty(pmPromotionRangeList) && !EmptyUtil.isEmpty((Object)pmPromotionRangeList.get(0).getDiscountAmount()) && pmPromotionRangeList.get(0).getDiscountAmount() > 0) {
            promotionDomain.setCouponOnceNums(pmPromotionRangeList.get(0).getDiscountAmount());
        }
        return this.pmPromotionService.savePromotion(promotionDomain);
    }

    protected SupQueryResult<RsSkuReDomain> querySkuMotherPage(HttpServletRequest request, String type, String userMemberCode) {
        Map<String, Object> param = null;
        if (StringUtils.isBlank((String)type) && StringUtils.isNotBlank((String)userMemberCode) && null != (param = this.assemMapParam(request))) {
            param.put("memberCode", userMemberCode);
        }
        if (StringUtils.isBlank((String)type) && StringUtils.isBlank((String)userMemberCode)) {
            param = this.checkMemquaPlat(request) ? this.getPlatMemberCodeQueryMapParams(request) : this.getMemberCodeQueryMapParams(request);
        } else if (TYPE_PLAT.equals(type)) {
            param = this.getPlatMemberCodeQueryMapParams(request);
        } else if (TYPE_BUS.equals(type)) {
            param = this.getMemberCodeQueryMapParams(request);
        } else if (TYPE_USER.equals(type)) {
            param = this.getMemberCodeQueryMapParams(request);
        }
        if (null != param && null != param.get("goodsClassParentcode") && StringUtils.isNotBlank((String)param.get("goodsClassParentcode").toString())) {
            List<String> classList = this.rsGoodsClassService.getGoodsClass((String)param.get("goodsClassParentcode"), (String)param.get("goodsClassType"), this.getPmChannel(request), this.getTenantCode(request));
            if (ListUtil.isNotEmpty(classList)) {
                String classtreeCode = "";
                for (String string : classList) {
                    if (StringUtils.isNotBlank((String)classtreeCode)) {
                        classtreeCode = classtreeCode + ",";
                    }
                    classtreeCode = classtreeCode + string;
                }
                param.put("classtreeCode", classtreeCode);
            } else {
                return null;
            }
        }
        return this.querySkuMain(param);
    }

    protected SupQueryResult<RsSkuReDomain> querySkuMain(Map<String, Object> param) {
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsSkuService.querySkuOnePage(param);
    }

    public SupQueryResult<TmProappEnvReDomain> queryProappEnvPageUser(HttpServletRequest request, String type, String userMemberCode) {
        Map<String, Object> param = null;
        if (StringUtils.isBlank((String)type) && StringUtils.isBlank((String)userMemberCode)) {
            param = this.checkMemquaPlat(request) ? this.getPlatMemberCodeQueryMapParams(request) : this.getMemberCodeQueryMapParams(request);
        } else if (TYPE_PLAT.equals(type)) {
            param = this.getPlatMemberCodeQueryMapParams(request);
        } else if (TYPE_BUS.equals(type)) {
            UserSession userSession = this.getUserSession(request);
            param = this.assemMapParam(request);
            param.put("tginfoCode", userSession.getUserPcode());
        } else if (TYPE_USER.equals(type)) {
            param = this.getMemberCodeQueryMapParams(request);
        }
        return this.tmProappService.queryProappEnvPage(param);
    }

    public HtmlJsonReBean sendPromotion(Integer promotionId) {
        if (StringUtils.isBlank((Integer)promotionId)) {
            this.logger.error("pm.promotionsup.con.getPromotion", (Object)"param is null");
            return null;
        }
        PmPromotionReDomain pmPromotionReDomain = this.pmPromotionService.getPromotion(promotionId);
        if (null == pmPromotionReDomain) {
            return null;
        }
        return this.pmPromotionService.sendPromotionById(promotionId);
    }

    public HtmlJsonReBean sendPromotionDeleteGoods(Integer promotionId) {
        if (StringUtils.isBlank((Integer)promotionId)) {
            this.logger.error("pm.promotionsup.con.getPromotion", (Object)"param is null");
            return null;
        }
        PmPromotionReDomain pmPromotionReDomain = this.pmPromotionService.getPromotion(promotionId);
        if (null == pmPromotionReDomain) {
            return null;
        }
        return this.pmPromotionService.sendPromotionDeleteGoods(promotionId);
    }

    public SupQueryResult<PmUserCouponReDomain> queryUsercouponPagePlus(HttpServletRequest request, String pbCode, String type, String userMemberCode) {
        Map<String, Object> param = this.assemMapBuyParam(request);
        if (StringUtils.isBlank((String)type) && StringUtils.isNotBlank((String)userMemberCode) && null != (param = this.assemMapParam(request))) {
            param.put("memberCode", userMemberCode);
        }
        if (StringUtils.isBlank((String)type) && StringUtils.isBlank((String)userMemberCode)) {
            param = this.checkMemquaPlat(request) ? this.getPlatMemberCodeQueryMapParams(request) : this.getMemberCodeQueryMapParams(request);
        } else if (TYPE_PLAT.equals(type)) {
            param = this.assemMapParam(request);
        } else if (TYPE_BUS.equals(type)) {
            param = this.assemMapParam(request);
            UserSession userSession = this.getUserSession(request);
            param.put("channelCode", this.getChannelByMem(userSession.getUserPcode(), request));
        } else if (TYPE_USER.equals(type)) {
            param = this.getMemberCodeQueryMapParams(request);
        }
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            if (StringUtils.isNotBlank((String)pbCode)) {
                param.put("pbCode", pbCode);
            }
        }
        return this.pmUserCouponService.queryUserCouponPage(param);
    }

    public HtmlJsonReBean promotionStateStopAndDelete(UserSession userSession, String promotionId, Integer oldDataState) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error("pm.promotionsup.con.updatePromotionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionService.updatePromotionState(userSession, Integer.valueOf(promotionId), -1, oldDataState, null);
    }

    public HtmlJsonReBean updatePromotionRangelist(HttpServletRequest request, String paramStr) {
        PmPromotionDomain promotionDomain = (PmPromotionDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, PmPromotionDomain.class);
        if (null == promotionDomain) {
            this.logger.error("pm.promotionsup.con.savePromotionPlus", (Object)"promotionDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionService.updatePromotionRangelist(promotionDomain);
    }

    public static void main1(String[] args) {
        PmPromotionReDomain oc = new PmPromotionReDomain();
        oc.setDataState(0);
        Map objectToMap = JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)oc), String.class, Object.class);
        System.out.println(objectToMap.get("dataState"));
    }

    @Override
    protected List<Map<String, Object>> makeExcelData(String json, String apiRouter, String excelTemplate) {
        ArrayList<Map<String, Object>> mapList;
        block14: {
            List pmPromotionReDomainList;
            block21: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                block16: {
                                    block15: {
                                        block13: {
                                            SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, SupQueryResult.class);
                                            pmPromotionReDomainList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), PmPromotionReDomain.class);
                                            if (ListUtil.isEmpty((Collection)pmPromotionReDomainList)) {
                                                return null;
                                            }
                                            mapList = new ArrayList<Map<String, Object>>();
                                            if (!"promotionDiscount".equals(excelTemplate) && !"promotionPreference".equals(excelTemplate)) break block13;
                                            for (PmPromotionReDomain oc : pmPromotionReDomainList) {
                                                List<PmPromotionDiscountDomain> pmPromotionDiscountList = oc.getPmPromotionDiscountList();
                                                boolean flag = false;
                                                if (ListUtil.isNotEmpty(pmPromotionDiscountList)) {
                                                    for (PmPromotionDiscountDomain pmPromotionDiscountDomain : pmPromotionDiscountList) {
                                                        Map<String, Object> objectDetailToMap = this.covertMapWtite(pmPromotionDiscountDomain);
                                                        if (!flag) {
                                                            Map objectToMap = JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)oc), String.class, Object.class);
                                                            Map<String, Object> stringObjectMap = this.coverPromotionDiscountState(objectToMap);
                                                            objectDetailToMap.putAll(stringObjectMap);
                                                            flag = true;
                                                        }
                                                        mapList.add(objectDetailToMap);
                                                    }
                                                    continue;
                                                }
                                                Map objectToMap = JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson((Object)oc), String.class, Object.class);
                                                Map<String, Object> stringObjectMap = this.coverPromotionDiscountState(objectToMap);
                                                mapList.add(stringObjectMap);
                                            }
                                            break block14;
                                        }
                                        if (!"promotionEnvelope".equals(excelTemplate)) break block15;
                                        for (PmPromotionReDomain oc : pmPromotionReDomainList) {
                                            Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                            Map<String, Object> stringObjectMap = this.coverPromotionDiscountState(objectToMap);
                                            mapList.add(stringObjectMap);
                                        }
                                        break block14;
                                    }
                                    if (!"promotionPageFullSubRoll".equals(excelTemplate)) break block16;
                                    for (PmPromotionReDomain oc : pmPromotionReDomainList) {
                                        this.logger.error("promotionPageFullSubRoll\u5bfc\u51fa====", (Object)JsonUtil.buildNormalBinder().toJson((Object)oc));
                                        Map objectToMap = JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                        Map<String, Object> stringObjectMap = this.coverPromotionPageFullSubRoll(objectToMap, oc);
                                        mapList.add(stringObjectMap);
                                    }
                                    break block14;
                                }
                                if (!"PromotionBargainPriceExportMJCX".equals(excelTemplate)) break block17;
                                for (PmPromotionReDomain oc : pmPromotionReDomainList) {
                                    this.logger.error("PromotionBargainPriceExportMJCX====", (Object)JsonUtil.buildNormalBinder().toJson((Object)oc));
                                    Map objectToMap = JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                    Map<String, Object> stringObjectMap = this.coverPromotionPageFullSubRollMJCX(objectToMap, oc);
                                    mapList.add(stringObjectMap);
                                }
                                break block14;
                            }
                            if (!"GoodsTrackReport".equals(excelTemplate)) break block18;
                            for (PmPromotionReDomain oc : pmPromotionReDomainList) {
                                this.logger.error("GoodsTrackReport====", (Object)JsonUtil.buildNormalBinder().toJson((Object)oc));
                                Map objectToMap = JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                List<Map<String, Object>> stringObjectMap = this.coverGoodsTrackReport(objectToMap, oc);
                                mapList.addAll(stringObjectMap);
                            }
                            break block14;
                        }
                        if (!"OrderTrackReport".equals(excelTemplate)) break block19;
                        for (PmPromotionReDomain oc : pmPromotionReDomainList) {
                            this.logger.error("OrderTrackReport====", (Object)JsonUtil.buildNormalBinder().toJson((Object)oc));
                            Map objectToMap = JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                            List<Map<String, Object>> stringObjectMap = this.coverOrderTrackReport(objectToMap, oc);
                            mapList.addAll(stringObjectMap);
                        }
                        break block14;
                    }
                    if (!"PromotionBargainPriceExport".equals(excelTemplate)) break block20;
                    for (PmPromotionReDomain oc : pmPromotionReDomainList) {
                        this.logger.error("PromotionBargainPriceExport====", (Object)JsonUtil.buildNormalBinder().toJson((Object)oc));
                        Map objectToMap = JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                        Map<String, Object> stringObjectMap = this.coverPromotionBargainPriceExport(objectToMap, oc);
                        mapList.add(stringObjectMap);
                    }
                    break block14;
                }
                if (!"UserTrackReport".equals(excelTemplate)) break block21;
                for (PmPromotionReDomain oc : pmPromotionReDomainList) {
                    this.logger.error("UserTrackReport====", (Object)JsonUtil.buildNormalBinder().toJson((Object)oc));
                    Map objectToMap = JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                    List<Map<String, Object>> stringObjectMap = this.coverOrderTrackReport(objectToMap, oc);
                    mapList.addAll(stringObjectMap);
                }
                break block14;
            }
            if (!"UserDetailTrackReport".equals(excelTemplate)) break block14;
            for (PmPromotionReDomain oc : pmPromotionReDomainList) {
                this.logger.error("UserDetailTrackReport====", (Object)JsonUtil.buildNormalBinder().toJson((Object)oc));
                Map objectToMap = JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                List<Map<String, Object>> stringObjectMap = this.coverExportStore(objectToMap, oc);
                mapList.addAll(stringObjectMap);
            }
        }
        return mapList;
    }

    protected Map<String, Object> covertMapWtite(PmPromotionDiscountDomain pmPromotionDiscountDomain) {
        HashMap<String, Object> orderMaps = new HashMap<String, Object>();
        orderMaps.put("discName", pmPromotionDiscountDomain.getDiscName());
        return orderMaps;
    }

    protected Map<String, Object> coverPromotionDiscountState(Map<String, Object> map) {
        if (null == map.get("contractDepositdate")) {
            map.put("contractDepositdate", map.get("gmtModified"));
        }
        map.put("contractValidate", map.get("gmtCreate"));
        String lTime = map.get("promotionBegintime") + (String)map.get("promotionEndtime");
        String YTime = map.get("receiveStart") + (String)map.get("receiveEnd");
        map.put("lTime", lTime);
        map.put("YTime", YTime);
        Integer dataState = null == map.get("dataState") ? 8888 : Integer.valueOf(map.get("dataState").toString());
        switch (dataState) {
            case -1: {
                map.put("dataState", "\u5df2\u53d6\u6d88");
                break;
            }
            case 0: {
                map.put("dataState", "\u672a\u5ba1\u6838");
                break;
            }
            case 1: {
                map.put("dataState", "\u8fdb\u884c\u4e2d");
                break;
            }
            case 2: {
                map.put("dataState", "\u5df2\u7ed3\u675f");
                break;
            }
            case 3: {
                map.put("dataState", "\u5df2\u7ec8\u6b62");
                break;
            }
            case 4: {
                map.put("dataState", "\u672a\u5f00\u59cb");
                break;
            }
            case 5: {
                map.put("dataState", "\u5ba1\u6838\u5931\u8d25");
                break;
            }
            case -2: {
                map.put("dataState", "\u5df2\u53d6\u6d88");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        return map;
    }

    protected List<Map<String, Object>> coverPromotionDomain(List<PmPromotionReDomain> pmPromotionReDomainList) {
        List jsonToList = new ArrayList();
        if (ListUtil.isNotEmpty(pmPromotionReDomainList)) {
            jsonToList = JsonUtil.buildNonDefaultBinder().getJsonToListByMap(JsonUtil.getNotDefJsonUtil().toJson(pmPromotionReDomainList), Object.class);
        }
        List<Map<String, Object>> infofList = new ArrayList<Map<String, Object>>();
        if (ListUtil.isNotEmpty(jsonToList)) {
            infofList = jsonToList.stream().map(e -> {
                Integer couponOnceOdate;
                String sendtype = String.valueOf(e.getOrDefault("sendtype", "\u666e\u901a\u5238"));
                if ("6".equals(sendtype)) {
                    sendtype = "\u6ee1\u8d60\u5238";
                } else if ("4".equals(sendtype)) {
                    sendtype = "\u5b9a\u5411\u5238";
                } else if ("8".equals(sendtype)) {
                    sendtype = "\u6d3e\u9001\u5238";
                }
                e.put("sendtype", sendtype);
                String dataState = String.valueOf(e.getOrDefault("dataState", "\u672a\u5ba1\u6838"));
                if ("0".equals(dataState)) {
                    dataState = "\u672a\u5ba1\u6838";
                } else if ("4".equals(dataState)) {
                    dataState = "\u672a\u5f00\u59cb";
                } else if ("1".equals(dataState)) {
                    dataState = "\u8fdb\u884c\u4e2d";
                } else if ("2".equals(dataState)) {
                    dataState = "\u5df2\u7ed3\u675f";
                } else if ("-1".equals(dataState)) {
                    dataState = "\u5df2\u53d6\u6d88";
                } else if ("-2".equals(dataState)) {
                    dataState = "\u5df2\u53d6\u6d88";
                } else if ("3".equals(dataState)) {
                    dataState = "\u5df2\u7ec8\u6b62";
                } else if ("5".equals(dataState)) {
                    dataState = "\u5ba1\u6838\u62d2\u7edd";
                } else if ("6".equals(dataState)) {
                    dataState = "\u5df2\u7ec8\u6b62";
                }
                e.put("dataState", dataState);
                String receiveStart = e.getOrDefault("receiveStart", "");
                String receiveEnd = e.getOrDefault("receiveEnd", "");
                if (null != receiveStart && null != receiveEnd) {
                    e.put("receiveStart", receiveStart + "~" + receiveEnd);
                }
                if ((couponOnceOdate = Integer.valueOf(String.valueOf(e.getOrDefault("couponOnceOdate", "0")))) > 0) {
                    e.put("couponOnceOdate", couponOnceOdate + "\u5206\u949f");
                } else {
                    String promotionBegintime = e.getOrDefault("promotionBegintime", "");
                    String promotionEndtime = e.getOrDefault("promotionEndtime", "");
                    if (null != receiveStart && null != receiveEnd) {
                        e.put("couponOnceOdate", promotionBegintime + "~" + promotionEndtime);
                    }
                }
                return e;
            }).collect(Collectors.toList());
        }
        return infofList;
    }

    protected Map<String, Object> coverPromotionPageFullSubRoll(Map<String, Object> map, PmPromotionReDomain oc) {
        String receiveStart = DateUtil.getDateString((String)map.get("receiveStart").toString(), (String)"yyyy-MM-dd HH:mm:ss");
        this.logger.error("receiveStart===============" + JsonUtil.buildNormalBinder().toJson((Object)receiveStart));
        String receiveEnd = DateUtil.getDateString((String)map.get("receiveEnd").toString(), (String)"yyyy-MM-dd HH:mm:ss");
        this.logger.error("receiveEnd===============" + JsonUtil.buildNormalBinder().toJson((Object)receiveEnd));
        map.put("receiveStartReceiveEnd", receiveStart + "\u81f3" + receiveEnd);
        String promotionBegintime = map.get("promotionBegintime").toString();
        String promotionEndtime = map.get("promotionEndtime").toString();
        map.put("promotionBegintimePromotionEndtime", promotionBegintime + "\u81f3" + promotionEndtime);
        String promotionFrequency = oc.getPromotionFrequency() == 0 || oc.getPromotionFrequency() == null ? "\u4e0d\u9650\u5f20\u6570" : oc.getPromotionFrequency().toString();
        String couponOnceNums = oc.getCouponOnceNums() == 0 || oc.getPromotionFrequency() == null ? "\u4e0d\u9650\u5f20\u6570" : oc.getCouponOnceNums().toString();
        map.put("promotionFrequencyCouponOnceNums", "\u6bcf\u4e2aid\u9650\u9886\u5f20\u6570:" + promotionFrequency + ",\u53d1\u653e\u603b\u5f20\u6570" + couponOnceNums);
        List<PmPromotionDiscountDomain> pmPromotionDiscountList = oc.getPmPromotionDiscountList();
        if (ListUtil.isNotEmpty(pmPromotionDiscountList)) {
            String discount = "";
            for (PmPromotionDiscountDomain discountDomain : pmPromotionDiscountList) {
                discount = discount + discountDomain.getDiscName();
            }
            map.put("discName", discount);
        }
        map.put("dataState", oc.getDataState());
        Integer dataState = null == map.get("dataState") ? 8888 : Integer.valueOf(map.get("dataState").toString());
        if (dataState == null) {
            dataState = oc.getDataState();
        }
        switch (dataState) {
            case -2: 
            case -1: {
                map.put("dataState", "\u5df2\u53d6\u6d88");
                break;
            }
            case 0: {
                map.put("dataState", "\u672a\u5ba1\u6838");
                break;
            }
            case 1: {
                map.put("dataState", "\u8fdb\u884c\u4e2d");
                break;
            }
            case 2: {
                map.put("dataState", "\u5df2\u7ed3\u675f");
                break;
            }
            case 3: {
                map.put("dataState", "\u5df2\u7ec8\u6b62");
                break;
            }
            case 4: {
                map.put("dataState", "\u672a\u5f00\u59cb");
                break;
            }
            case 5: {
                map.put("dataState", "\u5ba1\u6838\u5931\u8d25");
                break;
            }
            case 6: {
                map.put("dataState", "\u5df2\u7ec8\u6b62");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        map.put("sendtype", oc.getSendtype());
        Integer sendtype = null == map.get("sendtype") ? 8888 : Integer.valueOf(map.get("sendtype").toString());
        if (sendtype == null) {
            sendtype = oc.getSendtype();
        }
        switch (sendtype) {
            case 0: {
                map.put("sendtype", "\u666e\u901a\u5238");
                break;
            }
            case 3: {
                map.put("sendtype", "\u6d3e\u9001\u5238");
                break;
            }
            case 4: {
                map.put("sendtype", "\u5b9a\u5411\u5238");
                break;
            }
            case 6: {
                map.put("sendtype", "\u6ee1\u8d60\u5238");
                break;
            }
            default: {
                map.put("sendtype", "\u672a\u77e5\u7c7b\u578b:" + map.get("sendtype"));
            }
        }
        return map;
    }

    protected Map<String, Object> coverPromotionPageFullSubRollMJCX(Map<String, Object> map, PmPromotionReDomain oc) {
        List<PmPromotionConditionDomain> pmPromotionConditionList;
        this.logger.error("\u6ee1\u51cf\u5bfc\u51fa=====map" + map, (Object)("\u6ee1\u51cf\u5bfc\u51fa=====PmPromotionReDomain" + JsonUtil.buildNonDefaultBinder().toJson((Object)oc)));
        String promotionFrequency = oc.getPromotionFrequency() == 0 || oc.getPromotionFrequency() == null ? "\u4e0d\u9650\u5f20\u6570" : oc.getPromotionFrequency().toString();
        String couponOnceNums = oc.getCouponOnceNums() == 0 || oc.getPromotionFrequency() == null ? "\u4e0d\u9650\u5f20\u6570" : oc.getCouponOnceNums().toString();
        map.put("couponOnceNums", couponOnceNums);
        map.put("promotionFrequency", promotionFrequency);
        List<PmPromotionDiscountDomain> pmPromotionDiscountList = oc.getPmPromotionDiscountList();
        if (ListUtil.isNotEmpty(pmPromotionDiscountList)) {
            String discount = "";
            for (PmPromotionDiscountDomain discountDomain : pmPromotionDiscountList) {
                discount = discount + discountDomain.getDiscName();
            }
            map.put("discName", discount);
        }
        if (ListUtil.isNotEmpty(pmPromotionConditionList = oc.getPmPromotionConditionList())) {
            PmPromotionConditionDomain conditionDomain = pmPromotionConditionList.get(0);
            map.put("condConstraint", 0 == conditionDomain.getCondConstraint() ? "\u6309\u91d1\u989d" : "\u6309\u4ef6\u6570");
        }
        map.put("rangListSize", ListUtil.isNotEmpty(oc.getPmPromotionRangeList()) ? oc.getPmPromotionRangeList().size() : 0);
        Integer dataState = null == oc.getDataState() ? 8888 : Integer.valueOf(oc.getDataState());
        switch (dataState) {
            case -2: 
            case -1: {
                map.put("dataState", "\u5df2\u53d6\u6d88");
                break;
            }
            case 0: {
                map.put("dataState", "\u672a\u5ba1\u6838");
                break;
            }
            case 1: {
                map.put("dataState", "\u8fdb\u884c\u4e2d");
                break;
            }
            case 2: {
                map.put("dataState", "\u5df2\u7ed3\u675f");
                break;
            }
            case 3: {
                map.put("dataState", "\u5df2\u7ec8\u6b62");
                break;
            }
            case 4: {
                map.put("dataState", "\u672a\u5f00\u59cb");
                break;
            }
            case 5: {
                map.put("dataState", "\u5ba1\u6838\u5931\u8d25");
                break;
            }
            case 6: {
                map.put("dataState", "\u5df2\u7ec8\u6b62");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + oc.getDataState());
            }
        }
        return map;
    }

    protected Map<String, Object> coverPromotionBargainPriceExport(Map<String, Object> map, PmPromotionReDomain oc) {
        String receiveStart = map.get("receiveStart").toString();
        String receiveEnd = map.get("receiveEnd").toString();
        map.put("receiveStart", receiveStart);
        map.put("receiveEnd", receiveEnd);
        map.put("rangListSize", ListUtil.isNotEmpty(oc.getPmPromotionRangeList()) ? oc.getPmPromotionRangeList().size() : 0);
        Integer dataState = null == map.get("dataState") ? 8888 : Integer.valueOf(map.get("dataState").toString());
        switch (dataState) {
            case -2: 
            case -1: {
                map.put("dataState", "\u5df2\u53d6\u6d88");
                break;
            }
            case 0: {
                map.put("dataState", "\u672a\u5ba1\u6838");
                break;
            }
            case 1: {
                map.put("dataState", "\u8fdb\u884c\u4e2d");
                break;
            }
            case 2: {
                map.put("dataState", "\u5df2\u7ed3\u675f");
                break;
            }
            case 3: {
                map.put("dataState", "\u5df2\u7ec8\u6b62");
                break;
            }
            case 4: {
                map.put("dataState", "\u672a\u5f00\u59cb");
                break;
            }
            case 5: {
                map.put("dataState", "\u5ba1\u6838\u5931\u8d25");
                break;
            }
            case 6: {
                map.put("dataState", "\u5df2\u7ec8\u6b62");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        return map;
    }

    protected List<Map<String, Object>> coverGoodsTrackReport(Map<String, Object> map, PmPromotionReDomain pm) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> rangMap = new HashMap<String, Object>();
        rangMap.put("promotionCode", pm.getPromotionCode());
        rangMap.put("tenantCode", pm.getTenantCode());
        SupQueryResult<PmPromotionRangelistReDomain> rangelistPage = this.pmPromotionRangelistService.queryPromotionRangelistPage(rangMap);
        if (rangelistPage != null && ListUtil.isNotEmpty((Collection)rangelistPage.getList())) {
            rangelistPage.getList().forEach(rangelist -> {
                HashMap<String, Object> rangeMaps = new HashMap<String, Object>();
                rangeMaps.putAll(map);
                rangeMaps.put("pprlOpname", rangelist.getPprlOpname());
                rangeMaps.put("skuNo", rangelist.getSkuNo());
                rangeMaps.put("discountAmount1", rangelist.getDiscountAmount1());
                rangeMaps.put("discountAmount3", rangelist.getDiscountAmount3());
                HashMap<String, Object> skuMap = new HashMap<String, Object>();
                skuMap.put("skuNo", rangelist.getSkuNo());
                skuMap.put("goodsClass", "plat");
                skuMap.put("tenantCode", pm.getTenantCode());
                SupQueryResult<RsSkuReDomain> skuOnePage = this.rsSkuService.querySkuOnePage(skuMap);
                if (skuOnePage != null && ListUtil.isNotEmpty((Collection)skuOnePage.getList())) {
                    RsSkuReDomain rsSkuReDomain = (RsSkuReDomain)skuOnePage.getList().get(0);
                    rangeMaps.put("skuBarcode", rsSkuReDomain.getSkuBarcode());
                    rangeMaps.put("pricesetAsprice", rsSkuReDomain.getPricesetAsprice());
                    String classtreeName = rsSkuReDomain.getClasstreeName();
                    if (StringUtils.isNotBlank((String)classtreeName) && classtreeName.contains("/")) {
                        String[] classtree = classtreeName.split("/");
                        for (int i = 0; i < classtree.length; ++i) {
                            if (i == 0) {
                                rangeMaps.put("classtreeName", classtree[i]);
                            }
                            if (i == 1) {
                                rangeMaps.put("classtreeName1", classtree[i]);
                            }
                            if (i == 2) {
                                rangeMaps.put("classtreeName2", classtree[i]);
                            }
                            if (i != 3) continue;
                            rangeMaps.put("classtreeName3", classtree[i]);
                        }
                    } else {
                        rangeMaps.put("classtreeName", classtreeName);
                        rangeMaps.put("classtreeName1", classtreeName);
                    }
                }
                HashMap<String, Object> pmPromotionSavgMap = new HashMap<String, Object>();
                pmPromotionSavgMap.put("pprlCode", rangelist.getPprlCode());
                pmPromotionSavgMap.put("promotionCode", rangelist.getPromotionCode());
                pmPromotionSavgMap.put("tenantCode", rangelist.getTenantCode());
                SupQueryResult<PmPromotionSavgReDomain> pmPromotionSavgReDomainSupQueryResult = this.pmPromotionSavgService.queryPromotionSavgPage(pmPromotionSavgMap);
                if (ListUtil.isNotEmpty((Collection)pmPromotionSavgReDomainSupQueryResult.getList())) {
                    for (PmPromotionSavgReDomain pmPromotionSavgReDomain : pmPromotionSavgReDomainSupQueryResult.getList()) {
                        HashMap<String, Object> sagMap = new HashMap<String, Object>();
                        sagMap.putAll(rangeMaps);
                        if (StringUtils.isNotBlank((String)pmPromotionSavgReDomain.getPromotionSavgOtype())) {
                            if (pmPromotionSavgReDomain.getPromotionSavgOtype().equals("0")) {
                                sagMap.put("UndertakerCode", "\u4f9b\u5e94\u5546");
                            } else {
                                sagMap.put("UndertakerCode", "\u90e8\u95e8");
                            }
                        }
                        if (StringUtils.isNotBlank((String)pmPromotionSavgReDomain.getMemberBname())) {
                            sagMap.put("UndertakerName", pmPromotionSavgReDomain.getMemberBname());
                        }
                        if (StringUtils.isNotBlank((String)pmPromotionSavgReDomain.getPromotionSavgRtype())) {
                            if (pmPromotionSavgReDomain.getPromotionSavgRtype().equals("0")) {
                                sagMap.put("promotionMolingType", "\u6bd4\u4f8b");
                                if (null != pmPromotionSavgReDomain.getPromotionSavgRa()) {
                                    sagMap.put("promotionPamtMoney", pmPromotionSavgReDomain.getPromotionSavgRa());
                                }
                            } else {
                                sagMap.put("promotionMolingType", "\u91d1\u989d");
                                if (null != pmPromotionSavgReDomain.getPromotionSavgAmount()) {
                                    sagMap.put("promotionPamtMoney", pmPromotionSavgReDomain.getPromotionSavgAmount());
                                }
                            }
                        }
                        mapList.add(sagMap);
                    }
                } else {
                    mapList.add(rangeMaps);
                }
            });
        } else {
            mapList.add(map);
        }
        return mapList;
    }

    protected List<Map<String, Object>> coverExportStore(Map<String, Object> map, PmPromotionReDomain pm) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        if (ListUtil.isNotEmpty(pm.getPmPromotionTargetList())) {
            for (PmPromotionTargetlistDomain pmPromotionTargetlistDomain : pm.getPmPromotionTargetList()) {
                HashMap<String, Object> rangeMaps = new HashMap<String, Object>();
                rangeMaps.putAll(map);
                if ("userinfoCode".equals(pmPromotionTargetlistDomain.getPptlType())) {
                    rangeMaps.put("userCode", pmPromotionTargetlistDomain.getUserCode());
                    rangeMaps.put("pptlName", pmPromotionTargetlistDomain.getPptlName());
                    UmUserinfoReDomainBean userinfoReDomainBean = this.userService.getUserInfoByUserinfoCode(pmPromotionTargetlistDomain.getTargetCode(), pm.getTenantCode());
                    if (null != userinfoReDomainBean) {
                        rangeMaps.put("areaName", userinfoReDomainBean.getUserinfoScope());
                    }
                    mapList.add(rangeMaps);
                }
                if ("provinceCode".equals(pmPromotionTargetlistDomain.getPptlType())) {
                    rangeMaps.put("provinceCode", pmPromotionTargetlistDomain.getPptlName());
                    mapList.add(rangeMaps);
                }
                if (!"cityCode".equals(pmPromotionTargetlistDomain.getPptlType())) continue;
                rangeMaps.put("cityCode", pmPromotionTargetlistDomain.getPptlName());
                mapList.add(rangeMaps);
            }
        } else {
            mapList.add(map);
        }
        return mapList;
    }

    protected List<Map<String, Object>> coverOrderTrackReport(Map<String, Object> map, PmPromotionReDomain pm) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> ocMap = new HashMap<String, Object>();
        ocMap.put("goodsSupplierCode", pm.getPromotionCode());
        ocMap.put("contractType", "80");
        ocMap.put("childFlag", true);
        ocMap.put("tenantCode", pm.getTenantCode());
        SupQueryResult<OcContractReDomain> contractDomain = this.ocContractService.queryMakeContractPageReDomain(ocMap);
        this.logger.error("pm.promotionsup.concoverOrderTrackReport======", (Object)JsonUtil.buildNormalBinder().toJson(ocMap));
        if (contractDomain != null && ListUtil.isNotEmpty((Collection)contractDomain.getList())) {
            contractDomain.getList().forEach(contract -> {
                this.logger.error("coverOrderTrackReport======", (Object)JsonUtil.buildNormalBinder().toJson(contract));
                HashMap<String, Object> ocMaps = new HashMap<String, Object>();
                ocMaps.putAll(map);
                BigDecimal goodsNumSumBefore = BigDecimal.ZERO;
                BigDecimal goodsSendNumSumNo = BigDecimal.ZERO;
                BigDecimal goodsSendNumSum = BigDecimal.ZERO;
                BigDecimal goodsNumSumNo = BigDecimal.ZERO;
                ocMap.put("contractType", "85,86,67");
                ocMap.put("contractBbillcode", contract.getContractBillcode());
                ocMap.remove("contractBillcode");
                SupQueryResult<OcContractReDomain> ocContractResult = this.ocContractService.queryContractPageReDomain(ocMap);
                this.logger.error("\u9884\u552e\u8f6c\u6b63\u5f0f\u8ba2\u5355====", (Object)JsonUtil.buildNonDefaultBinder().toJson(ocContractResult));
                if (ocContractResult != null && ListUtil.isNotEmpty((Collection)ocContractResult.getList())) {
                    for (OcContractReDomain contractReDomain : ocContractResult.getList()) {
                        if (contractReDomain.getDataState() == 1 || contractReDomain.getDataState().compareTo(1) == 0 || contractReDomain.getDataState().compareTo(-1) == 0 || contractReDomain.getDataState().compareTo(-1) == 0) {
                            if (ListUtil.isNotEmpty(contractReDomain.getGoodsList())) {
                                for (OcContractGoodsDomain contractGoodsDomain : contractReDomain.getGoodsList()) {
                                    goodsNumSumBefore = goodsNumSumBefore.add(contractGoodsDomain.getGoodsCamount());
                                }
                            }
                            this.logger.error("\u5df2\u6279\u5f85\u4ed8\u6b3e\u6570\u91cf====" + contractReDomain.getDataState(), (Object)(goodsNumSumBefore + "===="));
                        }
                        if (contractReDomain.getDataState() == 2 || contractReDomain.getDataState().compareTo(2) == 0) {
                            if (ListUtil.isNotEmpty(contractReDomain.getGoodsList())) {
                                for (OcContractGoodsDomain contractGoodsDomain : contractReDomain.getGoodsList()) {
                                    goodsSendNumSumNo = goodsSendNumSumNo.add(contractGoodsDomain.getGoodsCamount());
                                }
                            }
                            this.logger.error("\u5df2\u6279\u5f85\u53d1\u8d27\u6570\u91cf====" + contractReDomain.getDataState(), (Object)(goodsSendNumSumNo + "===="));
                        }
                        if (contractReDomain.getDataState() != 3 && contractReDomain.getDataState() != 4 && contractReDomain.getDataState().compareTo(3) != 0 && contractReDomain.getDataState().compareTo(4) != 0) continue;
                        if (ListUtil.isNotEmpty(contractReDomain.getGoodsList())) {
                            for (OcContractGoodsDomain contractGoodsDomain : contractReDomain.getGoodsList()) {
                                goodsSendNumSum = goodsSendNumSum.add(contractGoodsDomain.getContractGoodsSendnum());
                            }
                        }
                        this.logger.error("\u5df2\u53d1\u6570\u91cf====" + contractReDomain.getDataState(), (Object)(goodsSendNumSum + "===="));
                    }
                }
                goodsNumSumNo = goodsNumSumNo.add(contract.getDataBnum().subtract(goodsNumSumBefore).subtract(goodsSendNumSumNo).subtract(goodsSendNumSum));
                ocMaps.put("goodsNumSumBefore", goodsNumSumBefore);
                ocMaps.put("goodsSendNumSumNo", goodsSendNumSumNo);
                ocMaps.put("goodsSendNumSum", goodsSendNumSum);
                ocMaps.put("goodsNumSumNo", goodsNumSumNo);
                ocMaps.put("contractBillcode", contract.getContractBillcode());
                ocMaps.put("userName", contract.getMschannelCode());
                ocMaps.put("areaName", contract.getAreaName());
                ocMaps.put("memberName", contract.getMemberBname());
                contract.getGoodsList().forEach(goods -> {
                    HashMap<String, Object> goodsMaps = new HashMap<String, Object>();
                    goodsMaps.putAll(ocMaps);
                    goodsMaps.put("goodsName", goods.getGoodsName());
                    goodsMaps.put("skuNo", goods.getSkuNo());
                    goodsMaps.put("skuBarcode", goods.getSkuBarcode());
                    goodsMaps.put("skuName", goods.getSkuName());
                    goodsMaps.put("contractGoodsPrice", goods.getContractGoodsPrice());
                    goodsMaps.put("contractGoodsMoney", goods.getContractGoodsMoney());
                    goodsMaps.put("goodsCamount", goods.getGoodsCamount());
                    goodsMaps.put("goodsSupplynum", goods.getGoodsSupplynum());
                    goodsMaps.put("brandName", goods.getBrandName());
                    goodsMaps.put("pntreeName", goods.getPntreeName());
                    HashMap<String, Object> rangMap = new HashMap<String, Object>();
                    rangMap.put("promotionCode", pm.getPromotionCode());
                    rangMap.put("skuNo", goods.getSkuNo());
                    rangMap.put("tenantCode", pm.getTenantCode());
                    SupQueryResult<PmPromotionRangelistReDomain> rangelistPage = this.pmPromotionRangelistService.queryPromotionRangelistPage(rangMap);
                    if (rangelistPage != null && ListUtil.isNotEmpty((Collection)rangelistPage.getList())) {
                        for (PmPromotionRangelistReDomain pmPromotionRangelistReDomain : rangelistPage.getList()) {
                            goodsMaps.put("pprlOpcode", pmPromotionRangelistReDomain.getPprlOpcode());
                            HashMap<String, Object> savgMap = new HashMap<String, Object>();
                            savgMap.put("promotionCode", pmPromotionRangelistReDomain.getPromotionCode());
                            savgMap.put("pprlCode", pmPromotionRangelistReDomain.getPprlCode());
                            savgMap.put("tenantCode", pmPromotionRangelistReDomain.getTenantCode());
                            SupQueryResult<PmPromotionSavgReDomain> pmPromotionSavgReDomainSupQueryResult = this.pmPromotionSavgService.queryPromotionSavgPage(savgMap);
                            if (ListUtil.isNotEmpty((Collection)pmPromotionSavgReDomainSupQueryResult.getList())) {
                                for (PmPromotionSavgReDomain pmPromotionSavgReDomain : pmPromotionSavgReDomainSupQueryResult.getList()) {
                                    HashMap<String, Object> sagMap = new HashMap<String, Object>();
                                    sagMap.putAll(goodsMaps);
                                    if (StringUtils.isNotBlank((String)pmPromotionSavgReDomain.getPromotionSavgOtype())) {
                                        if (pmPromotionSavgReDomain.getPromotionSavgOtype().equals("0")) {
                                            sagMap.put("UndertakerCode", "\u4f9b\u5e94\u5546");
                                        } else {
                                            sagMap.put("UndertakerCode", "\u90e8\u95e8");
                                        }
                                    }
                                    if (StringUtils.isNotBlank((String)pmPromotionSavgReDomain.getMemberBname())) {
                                        sagMap.put("UndertakerName", pmPromotionSavgReDomain.getMemberBname());
                                    }
                                    if (StringUtils.isNotBlank((String)pmPromotionSavgReDomain.getPromotionSavgRtype())) {
                                        if (pmPromotionSavgReDomain.getPromotionSavgRtype().equals("0")) {
                                            sagMap.put("promotionMolingType", "\u6bd4\u4f8b");
                                            if (null != pmPromotionSavgReDomain.getPromotionSavgRa()) {
                                                sagMap.put("promotionPamtMoney", pmPromotionSavgReDomain.getPromotionSavgRa());
                                            }
                                        } else {
                                            sagMap.put("promotionMolingType", "\u91d1\u989d");
                                            if (null != pmPromotionSavgReDomain.getPromotionSavgAmount()) {
                                                sagMap.put("promotionPamtMoney", pmPromotionSavgReDomain.getPromotionSavgAmount());
                                            }
                                        }
                                    }
                                    mapList.add(sagMap);
                                }
                                continue;
                            }
                            mapList.add(goodsMaps);
                        }
                    } else {
                        mapList.add(goodsMaps);
                    }
                });
            });
        }
        return mapList;
    }

    protected HtmlJsonReBean savePromotionPlusStr(HttpServletRequest request, String paramStr, String channelCode, String memberCode, String pbCode, String type) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error("pm.promotionsup.con.savePromotionPlus", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error("pm.promotionsup.con.savePromotionPlus", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PmPromotionDomain promotionDomain = this.makeRangeList(request, paramStr);
        if (null == promotionDomain) {
            this.logger.error("pm.promotionsup.con.savePromotionPlus", (Object)"promotionDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        promotionDomain.setPbCode(pbCode);
        String saveMemberCode = "";
        String saveMemberName = "";
        if (StringUtils.isBlank((String)type)) {
            if (this.checkMemquaPlat(request)) {
                saveMemberCode = this.getTeananMemberCode(request);
                saveMemberName = "\u5e73\u53f0";
            } else {
                saveMemberCode = userSession.getUserPcode();
                saveMemberName = userSession.getMerberCompname();
                promotionDomain.setChannelCode(this.getChannelByMem(saveMemberCode, request));
            }
        } else if (TYPE_PLAT.equals(type)) {
            saveMemberCode = this.getTeananMemberCode(request);
            saveMemberName = "\u5e73\u53f0";
        } else if (TYPE_BUS.equals(type)) {
            if (StringUtils.isNotBlank((String)userSession.getUserinfoParentCode())) {
                saveMemberCode = userSession.getUserinfoParentCode();
                saveMemberName = userSession.getUserinfoParentName();
            } else {
                saveMemberCode = userSession.getUserPcode();
                saveMemberName = userSession.getMerberCompname();
            }
            promotionDomain.setChannelCode(this.getChannelByMem(saveMemberCode, request));
        } else if (TYPE_USER.equals(type)) {
            saveMemberCode = userSession.getUserPcode();
            saveMemberName = userSession.getMerberCompname();
            promotionDomain.setChannelCode(this.getChannelByMem(saveMemberCode, request));
        }
        if (StringUtils.isNotBlank((String)promotionDomain.getChannelCode())) {
            promotionDomain.setChannelName(this.getChannelName(promotionDomain.getChannelCode(), request));
            promotionDomain.setGoodsClass(this.getGoodsClassByMem(promotionDomain.getChannelCode(), request));
        } else {
            promotionDomain.setGoodsClass("plat");
        }
        if (StringUtils.isNotBlank((String)channelCode)) {
            List<PmPromotionDisDomain> pmPromotionDisLists = promotionDomain.getPmPromotionDisList();
            if (null == pmPromotionDisLists) {
                pmPromotionDisLists = new ArrayList<PmPromotionDisDomain>();
                promotionDomain.setPmPromotionDisList(pmPromotionDisLists);
            }
            PmPromotionDisDomain pmPromotionDisDomain = new PmPromotionDisDomain();
            pmPromotionDisDomain.setChannelCode(this.getChannelByMem(userSession.getUserPcode(), request));
            if (StringUtils.isNotBlank((String)pmPromotionDisDomain.getChannelCode())) {
                pmPromotionDisDomain.setChannelName(this.getChannelName(promotionDomain.getChannelCode(), request));
            }
            pmPromotionDisDomain.setMemberCode(saveMemberCode);
            pmPromotionDisDomain.setMemberName(saveMemberName);
            pmPromotionDisLists.add(pmPromotionDisDomain);
        }
        if (StringUtils.isNotBlank((String)memberCode)) {
            List<PmPromotionSupDomain> pmPromotionSupDomains = promotionDomain.getPmPromotionSupList();
            if (null == pmPromotionSupDomains) {
                pmPromotionSupDomains = new ArrayList<PmPromotionSupDomain>();
                promotionDomain.setPmPromotionSupList(pmPromotionSupDomains);
            }
            PmPromotionSupDomain pmPromotionSupDomain = new PmPromotionSupDomain();
            pmPromotionSupDomain.setPpsupMemcode(saveMemberCode);
            pmPromotionSupDomain.setPpsupName(saveMemberName);
            pmPromotionSupDomains.add(pmPromotionSupDomain);
        }
        promotionDomain.setAppmanageIcode(this.getProappCode(request));
        promotionDomain.setTenantCode(this.getTenantCode(request));
        promotionDomain.setMemberCode(saveMemberCode);
        promotionDomain.setMemberName(saveMemberName);
        return this.pmPromotionService.savePromotion(promotionDomain);
    }

    public PmPromotionDomain makeRangeList(HttpServletRequest request, String paramStr) {
        SupQueryResult<RsSkuReDomain> skuPage;
        PmPromotionDomain promotionDomain = (PmPromotionDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, PmPromotionDomain.class);
        if (null == promotionDomain) {
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        promotionDomain.setClasstreeShopcode(userSession.getUserCode());
        List<PmPromotionRangelistDomain> pmPromotionRangelistDomains = promotionDomain.getPmPromotionRangeList();
        List<PmPromotionDiscountDomain> pmPromotionDiscountList = promotionDomain.getPmPromotionDiscountList();
        if (ListUtil.isNotEmpty(pmPromotionDiscountList) && ListUtil.isNotEmpty(pmPromotionDiscountList.get(0).getPmPromotionDiscountlistList()) && "0001".equals(promotionDomain.getPbCode())) {
            HashMap<String, Object> para = new HashMap<String, Object>();
            para.put("tenantCode", this.getTenantCode(request));
            ArrayList<PmPromotionDiscountlistDomain> Discountlist = new ArrayList<PmPromotionDiscountlistDomain>();
            ArrayList<PmPromotionDiscountlistDomain> removeDiscountlist = new ArrayList<PmPromotionDiscountlistDomain>();
            for (PmPromotionDiscountlistDomain pmDiscountlistDomain : pmPromotionDiscountList.get(0).getPmPromotionDiscountlistList()) {
                para.put("goodsCode", pmDiscountlistDomain.getGoodsCode());
                para.put("spuCode", pmDiscountlistDomain.getPpdlOpurl3());
                skuPage = this.rsSkuService.querySkuPage(para);
                pmDiscountlistDomain.setPpdlOpurl3(null);
                if (null != skuPage && ListUtil.isNotEmpty((Collection)skuPage.getList())) {
                    for (RsSkuReDomain skuReDomain : skuPage.getList()) {
                        PmPromotionDiscountlistDomain promotionDiscountlistDomain = new PmPromotionDiscountlistDomain();
                        if (!StringUtils.isNotBlank((String)skuReDomain.getSkuCode())) continue;
                        try {
                            BeanUtils.copyAllPropertys((Object)promotionDiscountlistDomain, (Object)pmDiscountlistDomain);
                            BeanUtils.copyAllPropertys((Object)promotionDiscountlistDomain, (Object)skuReDomain);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        promotionDiscountlistDomain.setPpdlOpurl(skuReDomain.getDataPic());
                        promotionDiscountlistDomain.setPpdlOpname(skuReDomain.getSkuName());
                        promotionDiscountlistDomain.setSkuNo(skuReDomain.getSkuNo());
                        promotionDiscountlistDomain.setSkuShowno(skuReDomain.getSkuShowno());
                        promotionDiscountlistDomain.setGoodsCode(skuReDomain.getGoodsCode());
                        Discountlist.add(promotionDiscountlistDomain);
                    }
                }
                removeDiscountlist.add(pmDiscountlistDomain);
            }
            promotionDomain.getPmPromotionDiscountList().get(0).getPmPromotionDiscountlistList().removeAll(removeDiscountlist);
            promotionDomain.getPmPromotionDiscountList().get(0).setPmPromotionDiscountlistList(Discountlist);
        }
        if (ListUtil.isNotEmpty(pmPromotionRangelistDomains)) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("tenantCode", this.getTenantCode(request));
            ArrayList<PmPromotionRangelistDomain> rengelist = new ArrayList<PmPromotionRangelistDomain>();
            ArrayList<PmPromotionRangelistDomain> removeRengelist = new ArrayList<PmPromotionRangelistDomain>();
            for (PmPromotionRangelistDomain pmProRangelist : pmPromotionRangelistDomains) {
                param.put("goodsCode", pmProRangelist.getGoodsCode());
                param.put("spuCode", pmProRangelist.getPprlOpurl3());
                skuPage = this.rsSkuService.querySkuPage(param);
                pmProRangelist.setPprlOpurl3(null);
                if (null != skuPage && ListUtil.isNotEmpty((Collection)skuPage.getList())) {
                    for (RsSkuReDomain skuReDomain : skuPage.getList()) {
                        PmPromotionRangelistDomain pmProRangelistDomain = new PmPromotionRangelistDomain();
                        if (!StringUtils.isNotBlank((String)skuReDomain.getSkuCode())) continue;
                        try {
                            BeanUtils.copyAllPropertys((Object)pmProRangelistDomain, (Object)pmProRangelist);
                            BeanUtils.copyAllPropertys((Object)pmProRangelistDomain, (Object)skuReDomain);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        pmProRangelistDomain.setPprlOpurl(skuReDomain.getDataPic());
                        pmProRangelistDomain.setPprlOpname(skuReDomain.getSkuName());
                        pmProRangelistDomain.setSkuCode(skuReDomain.getSkuCode());
                        pmProRangelistDomain.setSkuNo(skuReDomain.getSkuNo());
                        pmProRangelistDomain.setSkuShowno(skuReDomain.getSkuShowno());
                        rengelist.add(pmProRangelistDomain);
                    }
                }
                removeRengelist.add(pmProRangelist);
            }
            this.logger.info("removeRengelist:" + JsonUtil.buildNonEmptyBinder().jsonObject(removeRengelist));
            this.logger.info("rengelist:" + JsonUtil.buildNonEmptyBinder().jsonObject(rengelist));
            promotionDomain.getPmPromotionRangeList().removeAll(removeRengelist);
            promotionDomain.setPmPromotionRangeList(rengelist);
            this.logger.info("promotionDomain:" + JsonUtil.buildNonEmptyBinder().toJson((Object)promotionDomain));
        }
        return promotionDomain;
    }

    protected HtmlJsonReBean updatePromotionPlusStr(HttpServletRequest request, String paramStr, String type) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error("pm.promotionsup.con.updatePromotion", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error("pm.promotionsup.con.updatePromotion", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PmPromotionDomain promotionDomain = this.makeRangeList(request, paramStr);
        if (null == promotionDomain) {
            this.logger.error("pm.promotionsup.con.updatePromotionPlusStr.promotionDomain", (Object)"promotionDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4fee\u6539\u6570\u636e\u4e3a\u7a7a");
        }
        if (!this.checkPromotionDomain(promotionDomain).booleanValue()) {
            this.logger.error("pm.promotionsup.con.updatePromotionPlus.checkPromotionDomain.error");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5f02\u5e38");
        }
        if (null == promotionDomain.getPromotionId()) {
            this.logger.error("pm.promotionsup.con.updatePromotion.PromotionId", (Object)"promotionId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "");
        }
        promotionDomain.setTenantCode(this.getTenantCode(request));
        String saveMemberCode = "";
        String saveMemberName = "";
        if (StringUtils.isBlank((String)type)) {
            if (this.checkMemquaPlat(request)) {
                saveMemberCode = this.getTeananMemberCode(request);
                saveMemberName = "\u5e73\u53f0";
            } else {
                saveMemberCode = userSession.getUserPcode();
                saveMemberName = userSession.getMerberCompname();
            }
        } else if (TYPE_PLAT.equals(type)) {
            saveMemberCode = this.getTeananMemberCode(request);
            saveMemberName = "\u5e73\u53f0";
        } else if (TYPE_BUS.equals(type)) {
            if (StringUtils.isNotBlank((String)userSession.getUserinfoParentCode())) {
                saveMemberCode = userSession.getUserinfoParentCode();
                saveMemberName = userSession.getUserinfoParentName();
            } else {
                saveMemberCode = userSession.getUserPcode();
                saveMemberName = userSession.getMerberCompname();
            }
            promotionDomain.setChannelCode(this.getChannelByMem(userSession.getUserPcode(), request));
            promotionDomain.setChannelName(this.getChannelName(promotionDomain.getChannelName(), request));
        } else if (TYPE_USER.equals(type)) {
            saveMemberCode = userSession.getUserPcode();
            saveMemberName = userSession.getMerberCompname();
        }
        promotionDomain.setMemberCode(saveMemberCode);
        promotionDomain.setMemberName(saveMemberName);
        PmPromotionReDomain pmPromotionReDomain = this.pmPromotionService.getPromotion(promotionDomain.getPromotionId());
        if (null == pmPromotionReDomain || pmPromotionReDomain.getDataState() != 5) {
            this.logger.error("pm.promotionsup.con.updatePromotion", (Object)" datastate canot update");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8425\u9500\u6d3b\u52a8\u5df2\u7ecf\u5f00\u59cb\u6216\u7ed3\u675f\u4e86\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        HtmlJsonReBean htmlJsonReBean = this.pmPromotionService.updatePromotion(promotionDomain);
        if (!"success".equals(htmlJsonReBean.getSysRecode())) {
            this.logger.error("pm.promotionsup.con.updatePromotion", (Object)"htmlJsonReBean.getSysRecode() is error");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4fee\u6539\u5931\u8d25");
        }
        PmPromotionReDomain pmPromotionReDo = this.pmPromotionService.getPromotion((int)promotionDomain.getPromotionId());
        return this.pmPromotionService.updatePromotionState(userSession, (int)promotionDomain.getPromotionId(), 0, pmPromotionReDo.getDataState(), null);
    }

    Boolean checkPromotionDomain(PmPromotionDomain promotionDomain) {
        if (null != promotionDomain.getPromotionFrequency() && 0 > promotionDomain.getPromotionFrequency()) {
            this.logger.error("pm.promotionsup.con.checkPromotionDomain.promotionFrequency", (Object)("\u53c2\u4e0e\u6b21\u6570\u5f02\u5e38" + promotionDomain.getPromotionFrequency()));
            return false;
        }
        if (null != promotionDomain.getCouponOnceNums() && 0 > promotionDomain.getCouponOnceNums()) {
            this.logger.error("pm.promotionsup.con.checkPromotionDomain.promotionFrequency", (Object)("\u4f18\u60e0\u5238\u5355\u6b21\u603b\u5f20\u6570" + promotionDomain.getCouponOnceNums()));
            return false;
        }
        if ("0002".equals(promotionDomain.getPbCode()) || "0004".equals(promotionDomain.getPbCode())) {
            List<PmPromotionDiscountDomain> pmPromotionDisList = promotionDomain.getPmPromotionDiscountList();
            if (ListUtil.isNotEmpty(pmPromotionDisList)) {
                for (PmPromotionDiscountDomain pmPromotionDisDomain : pmPromotionDisList) {
                    if (null != pmPromotionDisDomain.getDiscAmount() && 0 > pmPromotionDisDomain.getDiscAmount().compareTo(BigDecimal.ZERO)) {
                        this.logger.error("pm.promotionsup.con.checkPromotionDomain.discAmount", (Object)("\u4f18\u60e0\u6570\u76ee\u5f02\u5e38" + pmPromotionDisDomain.getDiscAmount()));
                        return false;
                    }
                    if (null != pmPromotionDisDomain.getDiscStart() && 0 > pmPromotionDisDomain.getDiscStart().compareTo(BigDecimal.ZERO)) {
                        this.logger.error("pm.promotionsup.con.checkPromotionDomain.discStart", (Object)("\u4f18\u60e0\u5f00\u59cb\u533a\u95f4\u5f02\u5e38" + pmPromotionDisDomain.getDiscStart()));
                        return false;
                    }
                    if (null == pmPromotionDisDomain.getDiscEnd() || 0 <= pmPromotionDisDomain.getDiscStart().compareTo(new BigDecimal(-1))) continue;
                    this.logger.error("pm.promotionsup.con.checkPromotionDomain.discStart", (Object)("\u4f18\u60e0\u7ed3\u675f\u533a\u95f4" + pmPromotionDisDomain.getDiscEnd()));
                    return false;
                }
            }
            if (ListUtil.isNotEmpty(promotionDomain.getPmPromotionConditionList())) {
                for (PmPromotionConditionDomain pmPromotionConditionDomain : promotionDomain.getPmPromotionConditionList()) {
                    if (null == pmPromotionConditionDomain.getCondAmount() || 0 <= pmPromotionConditionDomain.getCondAmount().compareTo(BigDecimal.ZERO)) continue;
                    this.logger.error("pm.promotionsup.con.checkPromotionDomain.condAmount", (Object)("\u6761\u4ef6\u6570\u76ee\u5f02\u5e38" + pmPromotionConditionDomain.getCondAmount()));
                    return false;
                }
            }
        }
        return true;
    }

    protected SupQueryResult<PmPromotionReDomain> queryPromotionPageForC(HttpServletRequest request, String pbCode, String promotionType, String promotionPcode, Integer promotionOrgin, String type, Map<String, Object> map) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            if (StringUtils.isNotBlank((String)pbCode)) {
                param.put("pbCode", pbCode);
            }
            if (StringUtils.isNotBlank((String)promotionType)) {
                param.put("promotionType", promotionType);
            }
            if (StringUtils.isNotBlank((String)promotionPcode)) {
                param.put("promotionPcode", promotionPcode);
            }
            if (null != promotionOrgin) {
                param.put("promotionOrgin", promotionOrgin);
            }
            param.put("list", "list");
        }
        SupQueryResult<PmPromotionReDomain> pmPromotionReDomainSupQueryResult = this.pmPromotionService.queryPromotionPage(param);
        return pmPromotionReDomainSupQueryResult;
    }

    protected HtmlJsonReBean updatePromotionShowStateCon(String promotionId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error("pm.promotionsup.con.updatePromotionShowState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionService.updatePromotionShowState(Integer.valueOf(promotionId), dataState, oldDataState);
    }

    public static String getCheck(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }
}

