/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.data;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.da.DaOpsumListBigDataReDomain;
import cn.com.qj.bff.domain.da.DaOpsumListDomain;
import cn.com.qj.bff.domain.da.DaOpsumListReDomain;
import cn.com.qj.bff.domain.da.DaOpsumReDomain;
import cn.com.qj.bff.domain.oc.OcContractReDomain;
import cn.com.qj.bff.domain.oc.OcRefundReDomain;
import cn.com.qj.bff.domain.um.UmUserinfoReDomainBean;
import cn.com.qj.bff.enums.OrderChargebackB02Enum;
import cn.com.qj.bff.enums.OrderContractEnum;
import cn.com.qj.bff.interceptor.service.BaseInterUtil;
import cn.com.qj.bff.service.da.DaOpsumListService;
import cn.com.qj.bff.service.da.DaOpsumService;
import cn.com.qj.bff.service.dd.DdFalgSettingService;
import cn.com.qj.bff.service.oc.OcContractService;
import cn.com.qj.bff.service.oc.OcRefundService;
import cn.com.qj.bff.service.um.UmUserInfoService;
import cn.com.qj.bff.service.um.UserService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import cn.com.qj.bff.thread.saveUserinfoSumThread;
import com.google.common.collect.Maps;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StopWatch;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/da/opsumlist"}, name="\u6c47\u603b\u6570\u636e\u660e\u7ec6")
public class OpsumlistCon
extends SpringmvcController {
    private static String CODE = "da.opsumlist.con";
    public static final String REDIS_KEY = "REDIS_KEY_BUS";
    @Autowired
    private DaOpsumListService daOpsumListService;
    @Autowired
    private DaOpsumService daOpsumService;
    @Autowired
    private UserService userService;
    @Autowired
    private DdFalgSettingService ddFalgSettingService;
    @Autowired
    private OcContractService ocContractService;
    @Autowired
    private OcRefundService ocRefundService;
    @Autowired
    private UmUserInfoService umUserInfoService;

    @Override
    protected String getContext() {
        return "opsumlist";
    }

    @RequestMapping(value={"saveOpsumlist.json"}, name="\u589e\u52a0\u6c47\u603b\u6570\u636e\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean saveOpsumlist(HttpServletRequest request, DaOpsumListDomain daOpsumListDomain) {
        if (null == daOpsumListDomain) {
            this.logger.error(CODE + ".saveOpsumlist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        daOpsumListDomain.setTenantCode(this.getTenantCode(request));
        return this.daOpsumListService.saveOpsumList(daOpsumListDomain);
    }

    @RequestMapping(value={"getOpsumlist.json"}, name="\u83b7\u53d6\u6c47\u603b\u6570\u636e\u660e\u7ec6\u4fe1\u606f")
    @ResponseBody
    public DaOpsumListReDomain getOpsumlist(Integer opsumlistId) {
        if (StringUtils.isBlank((Integer)opsumlistId)) {
            this.logger.error(CODE + ".getOpsumlist", (Object)"param is null");
            return null;
        }
        return this.daOpsumListService.getOpsumList(opsumlistId);
    }

    @RequestMapping(value={"updateOpsumlist.json"}, name="\u66f4\u65b0\u6c47\u603b\u6570\u636e\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean updateOpsumlist(HttpServletRequest request, DaOpsumListDomain daOpsumListDomain) {
        if (null == daOpsumListDomain) {
            this.logger.error(CODE + ".updateOpsumlist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        daOpsumListDomain.setTenantCode(this.getTenantCode(request));
        return this.daOpsumListService.updateOpsumList(daOpsumListDomain);
    }

    @RequestMapping(value={"deleteOpsumlist.json"}, name="\u5220\u9664\u6c47\u603b\u6570\u636e\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean deleteOpsumlist(Integer opsumlistId) {
        if (StringUtils.isBlank((Integer)opsumlistId)) {
            this.logger.error(CODE + ".deleteOpsumlist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.daOpsumListService.deleteOpsumList(opsumlistId);
    }

    @RequestMapping(value={"queryOpsumlistPage.json"}, name="\u67e5\u8be2\u6c47\u603b\u6570\u636e\u660e\u7ec6\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DaOpsumListReDomain> queryOpsumlistPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.daOpsumListService.queryOpsumListPage(param);
    }

    @RequestMapping(value={"updateOpsumlistState.json"}, name="\u66f4\u65b0\u6c47\u603b\u6570\u636e\u660e\u7ec6\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateOpsumlistState(String opsumlistId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)opsumlistId)) {
            this.logger.error(CODE + ".updateOpsumlistState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.daOpsumListService.updateOpsumListState(Integer.valueOf(opsumlistId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryOpsumListPageForPlat.json"}, name="\u67e5\u8be2\u6c47\u603b\u6570\u636e\u660e\u7ec6\u5206\u9875\u7ed9\u79df\u6237")
    @ResponseBody
    public Map<String, Object> queryOpsumListPageForPlat(HttpServletRequest request, String sumType) {
        String tenantCode = this.getTenantCode(request);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String redisResult = DisUtil.get((String)(REDIS_KEY + tenantCode));
        if (StringUtils.isNotBlank((String)redisResult)) {
            return JsonUtil.buildNormalBinder().getJsonToMap(redisResult, String.class, Object.class);
        }
        this.logger.info("Get redis cache is null");
        LocalDateTime dateTimeTodayStrat = LocalDateTime.now();
        dateTimeTodayStrat = dateTimeTodayStrat.withHour(0).withMinute(0).withSecond(0).withNano(0);
        String dateTimeTodayStartStr = dateTimeTodayStrat.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        LocalDateTime dateTimeTodayEnd = LocalDateTime.now();
        dateTimeTodayEnd = dateTimeTodayEnd.withHour(23).withMinute(59).withSecond(59).withNano(0);
        String dateTimeTodayEndStr = dateTimeTodayEnd.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        LocalDateTime dateTimeYesterdayStrat = LocalDateTime.now().plusDays(-1L);
        dateTimeYesterdayStrat = dateTimeYesterdayStrat.withHour(0).withMinute(0).withSecond(0).withNano(0);
        String dateTimeYesterdayStartStr = dateTimeYesterdayStrat.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        LocalDateTime dateTimeYesterdayEnd = LocalDateTime.now().plusDays(-1L);
        dateTimeYesterdayEnd = dateTimeYesterdayEnd.withHour(23).withMinute(59).withSecond(59).withNano(0);
        String dateTimeYesterdayEndStr = dateTimeYesterdayEnd.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        CompletableFuture<Long> todayPayOrderCount = CompletableFuture.supplyAsync(() -> {
            Map<String, Object> map = OpsumlistCon.getMap(tenantCode);
            map.put("gmtCreateQstart", dateTimeTodayStartStr);
            map.put("gmtCreateQend", dateTimeTodayEndStr);
            List<String> enums = Arrays.asList(OrderContractEnum.FAIL_2.contractDataStateInt().toString(), OrderContractEnum.FAIL_3.contractDataStateInt().toString(), OrderContractEnum.FAIL_4.contractDataStateInt().toString(), OrderContractEnum.CLOSE5.contractDataStateInt().toString(), OrderContractEnum.RECEIVED.contractDataStateInt().toString(), OrderContractEnum.SENDED.contractDataStateInt().toString(), OrderContractEnum.SUCCESS.contractDataStateInt().toString());
            String dataStateStr = String.join((CharSequence)",", enums);
            map.put("dataStateStr", dataStateStr);
            map.put("channelCode", BaseInterUtil.getChannelCode((HttpServletRequest)request));
            this.logger.info("\u67e5\u8be2\u4eca\u65e5\u652f\u4ed8\u8ba2\u5355\u6570\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
            SupQueryResult<OcContractReDomain> result = this.ocContractService.queryContractPageReDomain(map);
            this.logger.info("\u67e5\u8be2\u4eca\u65e5\u652f\u4ed8\u8ba2\u5355\u6570\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson(result));
            return result.getTotal();
        });
        CompletableFuture<Long> yesterdayPayOrderCount = CompletableFuture.supplyAsync(() -> {
            Map<String, Object> map = OpsumlistCon.getMap(tenantCode);
            map.put("gmtCreateQstart", dateTimeYesterdayStartStr);
            map.put("gmtCreateQend", dateTimeYesterdayEndStr);
            List<String> enums = Arrays.asList(OrderContractEnum.FAIL_2.contractDataStateInt().toString(), OrderContractEnum.FAIL_3.contractDataStateInt().toString(), OrderContractEnum.FAIL_4.contractDataStateInt().toString(), OrderContractEnum.CLOSE5.contractDataStateInt().toString(), OrderContractEnum.RECEIVED.contractDataStateInt().toString(), OrderContractEnum.SENDED.contractDataStateInt().toString(), OrderContractEnum.SUCCESS.contractDataStateInt().toString());
            String dataStateStr = String.join((CharSequence)",", enums);
            map.put("dataStateStr", dataStateStr);
            map.put("channelCode", BaseInterUtil.getChannelCode((HttpServletRequest)request));
            this.logger.info("\u67e5\u8be2\u6628\u65e5\u652f\u4ed8\u8ba2\u5355\u6570\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
            SupQueryResult<OcContractReDomain> result = this.ocContractService.queryContractPageReDomain(map);
            this.logger.info("\u67e5\u8be2\u6628\u65e5\u652f\u4ed8\u8ba2\u5355\u6570\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson(result));
            return result.getTotal();
        });
        CompletableFuture<BigDecimal> todayPayMoney = CompletableFuture.supplyAsync(() -> {
            Map<String, Object> map = OpsumlistCon.getMap(tenantCode);
            map.put("gmtCreateQstart", dateTimeTodayStartStr);
            map.put("gmtCreateQend", dateTimeTodayEndStr);
            List<String> enums = Arrays.asList(OrderContractEnum.FAIL_2.contractDataStateInt().toString(), OrderContractEnum.FAIL_3.contractDataStateInt().toString(), OrderContractEnum.FAIL_4.contractDataStateInt().toString(), OrderContractEnum.CLOSE5.contractDataStateInt().toString(), OrderContractEnum.RECEIVED.contractDataStateInt().toString(), OrderContractEnum.SENDED.contractDataStateInt().toString(), OrderContractEnum.SUCCESS.contractDataStateInt().toString());
            String dataStateStr = String.join((CharSequence)",", enums);
            map.put("dataStateStr", dataStateStr);
            map.put("channelCode", BaseInterUtil.getChannelCode((HttpServletRequest)request));
            this.logger.info("\u67e5\u8be2\u5f53\u5929\u652f\u4ed8\u91d1\u989d\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
            Map<String, BigDecimal> resultMap = this.ocContractService.querytotalContractSumMoney(map);
            this.logger.info("\u67e5\u8be2\u5f53\u5929\u652f\u4ed8\u91d1\u989d\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson(resultMap));
            return resultMap.get("contractSumMoney");
        });
        CompletableFuture<BigDecimal> yesterdayPayMoney = CompletableFuture.supplyAsync(() -> {
            Map<String, Object> map = OpsumlistCon.getMap(tenantCode);
            map.put("gmtCreateQstart", dateTimeYesterdayStartStr);
            map.put("gmtCreateQend", dateTimeYesterdayEndStr);
            List<String> enums = Arrays.asList(OrderContractEnum.FAIL_2.contractDataStateInt().toString(), OrderContractEnum.FAIL_3.contractDataStateInt().toString(), OrderContractEnum.FAIL_4.contractDataStateInt().toString(), OrderContractEnum.CLOSE5.contractDataStateInt().toString(), OrderContractEnum.RECEIVED.contractDataStateInt().toString(), OrderContractEnum.SENDED.contractDataStateInt().toString(), OrderContractEnum.SUCCESS.contractDataStateInt().toString());
            String dataStateStr = String.join((CharSequence)",", enums);
            map.put("dataStateStr", dataStateStr);
            map.put("channelCode", BaseInterUtil.getChannelCode((HttpServletRequest)request));
            this.logger.info("\u67e5\u8be2\u6628\u5929\u652f\u4ed8\u91d1\u989d\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
            Map<String, BigDecimal> resultMap = this.ocContractService.querytotalContractSumMoney(map);
            this.logger.info("\u67e5\u8be2\u6628\u5929\u652f\u4ed8\u91d1\u989d\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson(resultMap));
            return resultMap.get("contractSumMoney");
        });
        CompletableFuture<Integer> todayPersonCount = CompletableFuture.supplyAsync(() -> {
            Map<String, Object> map = OpsumlistCon.getMap(tenantCode);
            map.put("gmtCreateQstart", dateTimeTodayStartStr);
            map.put("gmtCreateQend", dateTimeTodayEndStr);
            List<String> enums = Arrays.asList(OrderContractEnum.FAIL_2.contractDataStateInt().toString(), OrderContractEnum.FAIL_3.contractDataStateInt().toString(), OrderContractEnum.FAIL_4.contractDataStateInt().toString(), OrderContractEnum.CLOSE5.contractDataStateInt().toString(), OrderContractEnum.RECEIVED.contractDataStateInt().toString(), OrderContractEnum.SENDED.contractDataStateInt().toString(), OrderContractEnum.SUCCESS.contractDataStateInt().toString());
            String dataStateStr = String.join((CharSequence)",", enums);
            map.put("dataStateStr", dataStateStr);
            map.put("channelCode", BaseInterUtil.getChannelCode((HttpServletRequest)request));
            this.logger.info("\u67e5\u8be2\u5f53\u5929\u652f\u4ed8\u4eba\u6570\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
            Map<String, Object> hashMap = this.ocContractService.querytotalContractSumBuyerNum(map);
            this.logger.info("\u67e5\u8be2\u5f53\u5929\u652f\u4ed8\u4eba\u6570\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson(hashMap));
            Object sumObj = hashMap.get("sum");
            this.logger.info("sumObj\uff1a", sumObj);
            if (sumObj instanceof Integer) {
                return (Integer)sumObj;
            }
            if (sumObj instanceof String) {
                return Integer.parseInt((String)sumObj);
            }
            return 0;
        });
        CompletableFuture<Integer> yesterdayPersonCount = CompletableFuture.supplyAsync(() -> {
            Map<String, Object> map = OpsumlistCon.getMap(tenantCode);
            map.put("gmtCreateQstart", dateTimeYesterdayStartStr);
            map.put("gmtCreateQend", dateTimeYesterdayEndStr);
            List<String> enums = Arrays.asList(OrderContractEnum.FAIL_2.contractDataStateInt().toString(), OrderContractEnum.FAIL_3.contractDataStateInt().toString(), OrderContractEnum.FAIL_4.contractDataStateInt().toString(), OrderContractEnum.CLOSE5.contractDataStateInt().toString(), OrderContractEnum.RECEIVED.contractDataStateInt().toString(), OrderContractEnum.SENDED.contractDataStateInt().toString(), OrderContractEnum.SUCCESS.contractDataStateInt().toString());
            String dataStateStr = String.join((CharSequence)",", enums);
            map.put("dataStateStr", dataStateStr);
            map.put("channelCode", BaseInterUtil.getChannelCode((HttpServletRequest)request));
            this.logger.info("\u67e5\u8be2\u6628\u5929\u652f\u4ed8\u4eba\u6570\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
            Map<String, Object> hashMap = this.ocContractService.querytotalContractSumBuyerNum(map);
            this.logger.info("\u67e5\u8be2\u6628\u5929\u652f\u4ed8\u4eba\u6570\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson(hashMap));
            Object sumObj = hashMap.get("sum");
            if (sumObj instanceof Integer) {
                return (Integer)sumObj;
            }
            if (sumObj instanceof String) {
                return Integer.parseInt((String)sumObj);
            }
            return 0;
        });
        CompletableFuture<Long> notPayOrderCount = CompletableFuture.supplyAsync(() -> {
            Map<String, Object> map = OpsumlistCon.getMap(tenantCode);
            map.put("dataState", OrderContractEnum.WAITFORPAY.contractDataStateInt().toString());
            map.put("channelCode", BaseInterUtil.getChannelCode((HttpServletRequest)request));
            this.logger.info("\u5f85\u652f\u4ed8\u8ba2\u5355\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
            SupQueryResult<OcContractReDomain> result = this.ocContractService.queryContractPageReDomain(map);
            this.logger.info("\u5f85\u652f\u4ed8\u8ba2\u5355\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson(result));
            return result.getTotal();
        });
        CompletableFuture<Long> notShipmentsOrderCount = CompletableFuture.supplyAsync(() -> {
            Map<String, Object> map = OpsumlistCon.getMap(tenantCode);
            map.put("dataState", OrderContractEnum.SUCCESS.contractDataStateInt().toString());
            map.put("channelCode", BaseInterUtil.getChannelCode((HttpServletRequest)request));
            this.logger.info("\u5f85\u53d1\u8d27\u8ba2\u5355\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
            SupQueryResult<OcContractReDomain> result = this.ocContractService.queryContractPageReDomain(map);
            this.logger.info("\u5f85\u53d1\u8d27\u8ba2\u5355\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson(result));
            return result.getTotal();
        });
        CompletableFuture<Long> refundNotAuditCount = CompletableFuture.supplyAsync(() -> {
            Map<String, Object> map = OpsumlistCon.getMap(tenantCode);
            map.put("dataState", OrderChargebackB02Enum.APPLY_RETURN.chargebackTypeInt().toString());
            map.put("channelCode", BaseInterUtil.getChannelCode((HttpServletRequest)request));
            this.logger.info("\u9000\u5355\u5f85\u5ba1\u6838\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
            SupQueryResult<OcRefundReDomain> result = this.ocRefundService.queryRefundPage(map);
            this.logger.info("\u9000\u5355\u5f85\u5ba1\u6838\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson(result));
            return result.getTotal();
        });
        CompletableFuture<BigDecimal> refundMoneyTodayCount = CompletableFuture.supplyAsync(() -> {
            ConcurrentMap map = Maps.newConcurrentMap();
            map.put("fuzzy", false);
            map.put("order", false);
            map.put("tenantCode", tenantCode);
            map.put("dataState", OrderChargebackB02Enum.RETURN_FINISH.chargebackTypeInt().toString());
            map.put("gmtCreateQstart", dateTimeTodayStartStr);
            map.put("gmtCreateQend", dateTimeTodayEndStr);
            map.put("channelCode", BaseInterUtil.getChannelCode((HttpServletRequest)request));
            this.logger.info("\u9000\u5355\u91d1\u989d\u4eca\u65e5 parm\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)map));
            Map<String, Object> refundSum = this.ocRefundService.queryOcRefundSum(map);
            this.logger.info("\u9000\u5355\u91d1\u989d\u4eca\u65e5Result\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson(refundSum));
            if (MapUtil.isEmpty(refundSum)) {
                return BigDecimal.ZERO;
            }
            BigDecimal refundMoney = (BigDecimal)refundSum.get("REFUND_MONEY");
            this.logger.info("\u9000\u5355\u91d1\u989d\u4eca\u65e5\uff1a", (Object)refundMoney);
            return refundMoney == null ? BigDecimal.ZERO : refundMoney;
        });
        CompletableFuture<BigDecimal> refundMoneyYesterDayCount = CompletableFuture.supplyAsync(() -> {
            ConcurrentMap map = Maps.newConcurrentMap();
            map.put("fuzzy", false);
            map.put("order", false);
            map.put("tenantCode", tenantCode);
            map.put("dataState", OrderChargebackB02Enum.RETURN_FINISH.chargebackTypeInt().toString());
            map.put("gmtCreateQstart", dateTimeYesterdayStartStr);
            map.put("gmtCreateQend", dateTimeYesterdayEndStr);
            map.put("channelCode", BaseInterUtil.getChannelCode((HttpServletRequest)request));
            this.logger.info("\u9000\u5355\u91d1\u989d\u6628\u65e5 parm\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)map));
            Map<String, Object> refundSum = this.ocRefundService.queryOcRefundSum(map);
            this.logger.info("\u9000\u5355\u91d1\u989d\u6628\u65e5Result\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson(refundSum));
            if (MapUtil.isEmpty(refundSum)) {
                return BigDecimal.ZERO;
            }
            BigDecimal refundMoney = (BigDecimal)refundSum.get("REFUND_MONEY");
            this.logger.info("\u9000\u5355\u91d1\u989d\u6628\u65e5\uff1a", (Object)refundMoney);
            return refundMoney == null ? BigDecimal.ZERO : refundMoney;
        });
        CompletableFuture<Integer> addUmUserInfoTodayNum = CompletableFuture.supplyAsync(() -> {
            ConcurrentMap map = Maps.newConcurrentMap();
            map.put("fuzzy", false);
            map.put("order", false);
            map.put("tenantCode", tenantCode);
            map.put("gmtCreateQstart", dateTimeTodayStartStr);
            map.put("gmtCreateQend", dateTimeTodayEndStr);
            this.logger.info("\u4eca\u65e5\u65b0\u589e\u4f1a\u5458\u6570 parm\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)map));
            Integer num = this.umUserInfoService.countUmUserInfoNum(map);
            this.logger.info("\u4eca\u65e5\u65b0\u589e\u4f1a\u5458\u6570  Result\uff1a", (Object)num);
            return num;
        });
        CompletableFuture<Integer> addUmUserInfoYesterNum = CompletableFuture.supplyAsync(() -> {
            ConcurrentMap map = Maps.newConcurrentMap();
            map.put("fuzzy", false);
            map.put("order", false);
            map.put("tenantCode", tenantCode);
            map.put("gmtCreateQstart", dateTimeYesterdayStartStr);
            map.put("gmtCreateQend", dateTimeYesterdayEndStr);
            this.logger.info("\u6628\u65e5\u65b0\u589e\u4f1a\u5458\u6570 parm\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)map));
            Integer num = this.umUserInfoService.countUmUserInfoNum(map);
            this.logger.info("\u6628\u65e5\u65b0\u589e\u4f1a\u5458\u6570  Result\uff1a", (Object)num);
            return num;
        });
        CompletableFuture<Integer> countUmUserInfoTodayNum = CompletableFuture.supplyAsync(() -> {
            ConcurrentMap map = Maps.newConcurrentMap();
            map.put("fuzzy", false);
            map.put("order", false);
            map.put("tenantCode", tenantCode);
            map.put("gmtCreateQend", dateTimeTodayEndStr);
            this.logger.info("\u4eca\u65e5\u7d2f\u8ba1\u4f1a\u5458\u6570 parm\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)map));
            Integer num = this.umUserInfoService.countUmUserInfoNum(map);
            this.logger.info("\u4eca\u65e5\u7d2f\u8ba1\u4f1a\u5458\u6570  Result\uff1a", (Object)num);
            return num;
        });
        CompletableFuture<Integer> countUmUserInfoYesterNum = CompletableFuture.supplyAsync(() -> {
            ConcurrentMap map = Maps.newConcurrentMap();
            map.put("fuzzy", false);
            map.put("order", false);
            map.put("tenantCode", tenantCode);
            map.put("gmtCreateQend", dateTimeYesterdayEndStr);
            this.logger.info("\u6628\u65e5\u7d2f\u8ba1\u4f1a\u5458\u6570 parm\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)map));
            Integer num = this.umUserInfoService.countUmUserInfoNum(map);
            this.logger.info("\u6628\u65e5\u7d2f\u8ba1\u4f1a\u5458\u6570  Result\uff1a", (Object)num);
            return num;
        });
        HashMap hashMap = Maps.newHashMap();
        try {
            CompletableFuture<Void> all = CompletableFuture.allOf(refundNotAuditCount, notShipmentsOrderCount, notPayOrderCount, yesterdayPayOrderCount, todayPayOrderCount, yesterdayPersonCount, todayPersonCount, todayPayMoney, yesterdayPayMoney, refundMoneyTodayCount, refundMoneyYesterDayCount);
            all.join();
            Long refundNotAuditNum = refundNotAuditCount.get();
            Long notShipmentsOrderNum = notShipmentsOrderCount.get();
            Long notPayOrderNum = notPayOrderCount.get();
            Long yesterdayPayOrderNum = yesterdayPayOrderCount.get();
            Long todayPayOrderNum = todayPayOrderCount.get();
            BigDecimal todayPayMoneyNum = todayPayMoney.get();
            BigDecimal yesterdayPayMoneyNum = yesterdayPayMoney.get();
            BigDecimal refundMoneyTodayNum = refundMoneyTodayCount.get();
            BigDecimal refundMoneyYesterNum = refundMoneyYesterDayCount.get();
            hashMap.put("notShipmentsOrderNum", notShipmentsOrderNum);
            hashMap.put("notPayOrderNum", notPayOrderNum);
            hashMap.put("yesterdayPayOrderNum", yesterdayPayOrderNum);
            hashMap.put("todayPayOrderNum", todayPayOrderNum);
            hashMap.put("todayPayMoneyNum", todayPayMoneyNum);
            hashMap.put("yesterdayPayMoneyNum", yesterdayPayMoneyNum);
            hashMap.put("refundMoneyTodayNum", refundMoneyTodayNum);
            hashMap.put("refundMoneyYesterNum", refundMoneyYesterNum);
            hashMap.put("refundNotAuditNum", refundNotAuditNum);
            hashMap.put("todayPersonNum", this.getIntegerValue(todayPersonCount));
            hashMap.put("yesterdayPersonNum", this.getIntegerValue(yesterdayPersonCount));
            hashMap.put("addUmUserInfoTodayCountNum", this.getIntegerValue(addUmUserInfoTodayNum));
            hashMap.put("addUmUserInfoYesterCountNum", this.getIntegerValue(addUmUserInfoYesterNum));
            hashMap.put("countUmUserInfoTodayCountNum", this.getIntegerValue(countUmUserInfoTodayNum));
            hashMap.put("countUmUserInfoYesterCountNum", this.getIntegerValue(countUmUserInfoYesterNum));
            DisUtil.set((String)(REDIS_KEY + tenantCode), (String)JsonUtil.buildNonDefaultBinder().toJson((Object)hashMap), (int)6);
        }
        catch (InterruptedException | ExecutionException e) {
            this.logger.error(CODE + ".queryOpsumListPageComm Error: ", (Object)e.getMessage());
            throw new ApiException("\u64cd\u4f5c\u5931\u8d25");
        }
        stopWatch.stop();
        this.logger.info(CODE + ".queryOpsumListPageComm \u8017\u65f6\uff1a", (Object)stopWatch.getTotalTimeMillis());
        this.logger.info(CODE + ".queryOpsumListPageComm \u7ed3\u679c\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)hashMap));
        return hashMap;
    }

    private Integer getIntegerValue(CompletableFuture<?> future) {
        try {
            Object result = future.get();
            if (result instanceof Integer) {
                return (Integer)result;
            }
            if (result instanceof String) {
                return Integer.parseInt((String)result);
            }
            return 0;
        }
        catch (InterruptedException | ExecutionException e) {
            return 0;
        }
    }

    private static Map<String, Object> getMap(String tenantCode) {
        ConcurrentMap map = Maps.newConcurrentMap();
        map.put("fuzzy", false);
        map.put("order", false);
        map.put("tenantCode", tenantCode);
        map.put("startRow", 0);
        map.put("rows", 1);
        return map;
    }

    @RequestMapping(value={"queryOpsumListPageForUser.json"}, name="\u67e5\u8be2\u6c47\u603b\u6570\u636e\u660e\u7ec6\u5206\u9875\u7ed9\u5356\u5bb6")
    @ResponseBody
    public Map<String, Object> queryOpsumListPageForUser(HttpServletRequest request, String sumType) {
        String tenantCode;
        String userPcode = this.getUserSession(request).getUserPcode();
        Map<String, Object> stringObjectMap = this.queryOpsumListPageComm(userPcode, sumType, tenantCode = this.getTenantCode(request), "\u7528\u6237");
        if (null != stringObjectMap) {
            return stringObjectMap;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("dataLast", "0");
        resultMap.put("dataToday", "0");
        return resultMap;
    }

    @RequestMapping(value={"queryOpsumListPageForYunying.json"}, name="\u67e5\u8be2\u6c47\u603b\u6570\u636e\u660e\u7ec6\u5206\u9875\u7ed9\u8fd0\u8425")
    @ResponseBody
    public Map<String, Object> queryOpsumListPageForYunying(HttpServletRequest request, String sumType) {
        String tenantCode;
        String userPcode = this.getUserSession(request).getUserPcode();
        Map<String, Object> stringObjectMap = this.queryOpsumListPageComm(userPcode, sumType, tenantCode = this.getTenantCode(request), "\u8fd0\u8425");
        if (null != stringObjectMap) {
            return stringObjectMap;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("dataLast", "0");
        resultMap.put("dataToday", "0");
        return resultMap;
    }

    private Map<String, Object> queryOpsumListPageComm(String userPcode, String sumType, String tenantCode, String opsumDimname) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        date = calendar.getTime();
        String pattern = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String formatDateLast = sdf.format(date);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", tenantCode);
        param.put("order", true);
        param.put("opsumDate", formatDateLast);
        param.put("opsumType", sumType);
        param.put("opsumDimcode", userPcode);
        param.put("opsumDimname", opsumDimname);
        SupQueryResult<DaOpsumReDomain> daOpsumReDomainSupQueryResult = this.daOpsumService.queryOpsumPage(param);
        if (null == daOpsumReDomainSupQueryResult || daOpsumReDomainSupQueryResult.getList().isEmpty()) {
            this.logger.info(CODE + ".queryOpsumListPageComm.daOpsumReDomainSupQueryResult", (Object)"result is null");
            return this.queryOpsumListPageCommToday(userPcode, sumType, tenantCode, resultMap);
        }
        DaOpsumReDomain daOpsumReDomain = (DaOpsumReDomain)daOpsumReDomainSupQueryResult.getList().get(0);
        String opsumCode = daOpsumReDomain.getOpsumCode();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opsumCode", opsumCode);
        map.put("opsumDate", formatDateLast);
        ArrayList<DaOpsumListReDomain> daOpsumListReDomainsResultLast = new ArrayList<DaOpsumListReDomain>();
        SupQueryResult<DaOpsumListReDomain> daOpsumListReDomainSupQueryResult = this.daOpsumListService.queryOpsumListPage(map);
        if (null != daOpsumListReDomainSupQueryResult) {
            List list = daOpsumListReDomainSupQueryResult.getList();
            for (DaOpsumListReDomain daOpsumListReDomain : list) {
                daOpsumListReDomain.setOpsumDate("\u6628\u65e5");
                daOpsumListReDomainsResultLast.add(daOpsumListReDomain);
            }
        }
        Date todayDate = new Date();
        Calendar calendarToday = Calendar.getInstance();
        calendarToday.setTime(todayDate);
        todayDate = calendarToday.getTime();
        SimpleDateFormat sdfToday = new SimpleDateFormat(pattern);
        String today = sdfToday.format(todayDate);
        HashMap<String, Object> paramToday = new HashMap<String, Object>();
        paramToday.put("tenantCode", tenantCode);
        paramToday.put("order", true);
        paramToday.put("opsumDate", today);
        paramToday.put("opsumType", sumType);
        paramToday.put("opsumDimcode", userPcode);
        SupQueryResult<DaOpsumReDomain> daOpsumReDomainSupQueryResult2 = this.daOpsumService.queryOpsumPage(paramToday);
        if (null == daOpsumReDomainSupQueryResult2 || daOpsumReDomainSupQueryResult2.getList().isEmpty()) {
            this.logger.error(CODE + ".queryOpsumListPageComm.daOpsumReDomainSupQueryResult2", (Object)"result is null");
            resultMap.put("dataLast", daOpsumListReDomainsResultLast);
            resultMap.put("dataToday", "0");
            return resultMap;
        }
        DaOpsumReDomain daOpsumReDomainToday = (DaOpsumReDomain)daOpsumReDomainSupQueryResult2.getList().get(0);
        String opsumCodeToday = daOpsumReDomainToday.getOpsumCode();
        HashMap<String, Object> mapmap = new HashMap<String, Object>();
        mapmap.put("opsumCode", opsumCodeToday);
        mapmap.put("tenantCode", tenantCode);
        mapmap.put("opsumDate", today);
        ArrayList<DaOpsumListReDomain> daOpsumListReDomainsResultToday = new ArrayList<DaOpsumListReDomain>();
        SupQueryResult<DaOpsumListReDomain> todayResult = this.daOpsumListService.queryOpsumListPage(mapmap);
        if (null != todayResult) {
            List listToday = todayResult.getList();
            for (DaOpsumListReDomain todayDomain : listToday) {
                todayDomain.setOpsumDate("\u4eca\u65e5");
                daOpsumListReDomainsResultToday.add(todayDomain);
            }
            SupQueryResult supQueryResult = new SupQueryResult();
            resultMap.put("dataLast", daOpsumListReDomainsResultLast);
            resultMap.put("dataToday", daOpsumListReDomainsResultToday);
            return resultMap;
        }
        return null;
    }

    private Map<String, Object> queryOpsumListPageCommWelfare(String userPcode, String sumType, String tenantCode, String opsumDimname) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        date = calendar.getTime();
        String pattern = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String formatDateLast = sdf.format(date);
        Date todayDate = new Date();
        Calendar calendarToday = Calendar.getInstance();
        calendarToday.setTime(todayDate);
        todayDate = calendarToday.getTime();
        SimpleDateFormat sdfToday = new SimpleDateFormat(pattern);
        String today = sdfToday.format(todayDate);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", tenantCode);
        param.put("order", true);
        param.put("opsumDate", formatDateLast);
        param.put("opsumType", sumType);
        param.put("opsumDimcode", userPcode);
        param.put("opsumDimname", opsumDimname);
        SupQueryResult<DaOpsumReDomain> daOpsumReDomainSupQueryResult = this.daOpsumService.queryOpsumPage(param);
        if (null == daOpsumReDomainSupQueryResult || daOpsumReDomainSupQueryResult.getList().isEmpty()) {
            this.logger.info(CODE + ".queryOpsumListPageComm.daOpsumReDomainSupQueryResult", (Object)"result is null");
            return this.queryOpsumListPageCommToday(userPcode, sumType, tenantCode, resultMap);
        }
        DaOpsumReDomain daOpsumReDomain = (DaOpsumReDomain)daOpsumReDomainSupQueryResult.getList().get(0);
        String opsumCode = daOpsumReDomain.getOpsumCode();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opsumCode", opsumCode);
        map.put("opsumDate", formatDateLast);
        ArrayList<DaOpsumListReDomain> daOpsumListReDomainsResultLast = new ArrayList<DaOpsumListReDomain>();
        SupQueryResult<DaOpsumListReDomain> daOpsumListReDomainSupQueryResult = this.daOpsumListService.queryOpsumListPage(map);
        if (null != daOpsumListReDomainSupQueryResult) {
            List list = daOpsumListReDomainSupQueryResult.getList();
            for (DaOpsumListReDomain daOpsumListReDomain : list) {
                daOpsumListReDomain.setOpsumDate("\u6628\u65e5");
                daOpsumListReDomainsResultLast.add(daOpsumListReDomain);
            }
        }
        HashMap<String, Object> paramToday = new HashMap<String, Object>();
        paramToday.put("tenantCode", tenantCode);
        paramToday.put("order", true);
        paramToday.put("opsumDate", today);
        paramToday.put("opsumType", sumType);
        paramToday.put("opsumDimcode", userPcode);
        this.logger.error(".queryOpsumListPageCommm.paramToday===", (Object)JsonUtil.buildNormalBinder().toJson(paramToday));
        SupQueryResult<DaOpsumReDomain> daOpsumReDomainSupQueryResult2 = this.daOpsumService.queryOpsumPage(paramToday);
        if (null == daOpsumReDomainSupQueryResult2 || ListUtil.isEmpty((Collection)daOpsumReDomainSupQueryResult2.getList())) {
            ArrayList<DaOpsumListReDomain> daOpsumListToday = new ArrayList<DaOpsumListReDomain>();
            DaOpsumListReDomain todayDomain = new DaOpsumListReDomain();
            todayDomain.setOpsetName("UmUserinfoSum");
            todayDomain.setOpsetType("UmUserinfoSum");
            todayDomain.setTenantCode(tenantCode);
            todayDomain.setOpsumDimname("\u79df\u6237");
            todayDomain.setOpsumDate("\u4eca\u65e5");
            todayDomain.setOpsumListNum(this.getZeroNum(tenantCode, null));
            daOpsumListToday.add(todayDomain);
            new saveUserinfoSumThread(this.daOpsumService, this.daOpsumListService, this.userService, userPcode, opsumDimname, sumType, tenantCode, today, null).start();
            resultMap.put("dataLast", daOpsumListReDomainsResultLast);
            resultMap.put("dataToday", daOpsumListToday);
            return resultMap;
        }
        DaOpsumReDomain daOpsumReDomainToday = (DaOpsumReDomain)daOpsumReDomainSupQueryResult2.getList().get(0);
        String opsumCodeToday = daOpsumReDomainToday.getOpsumCode();
        HashMap<String, Object> mapmap = new HashMap<String, Object>();
        mapmap.put("opsumCode", opsumCodeToday);
        mapmap.put("tenantCode", tenantCode);
        mapmap.put("opsumDate", today);
        ArrayList<DaOpsumListReDomain> daOpsumListReDomainsResultToday = new ArrayList<DaOpsumListReDomain>();
        SupQueryResult<DaOpsumListReDomain> todayResult = this.daOpsumListService.queryOpsumListPage(mapmap);
        if (null != todayResult) {
            boolean flag = false;
            List listToday = todayResult.getList();
            for (DaOpsumListReDomain todayDomain : listToday) {
                todayDomain.setOpsumDate("\u4eca\u65e5");
                this.logger.error(".queryOpsumListPageCommm.opsetType===", (Object)todayDomain.getOpsetType());
                if ("UmUserinfoSum".equals(todayDomain.getOpsetType())) {
                    flag = true;
                }
                daOpsumListReDomainsResultToday.add(todayDomain);
            }
            this.logger.error(".queryOpsumListPageCommm.flag===", (Object)flag);
            if (!flag) {
                DaOpsumListReDomain todayDomain = new DaOpsumListReDomain();
                todayDomain.setOpsetName("UmUserinfoSum");
                todayDomain.setOpsetType("UmUserinfoSum");
                todayDomain.setTenantCode(tenantCode);
                todayDomain.setOpsumDimname("\u79df\u6237");
                todayDomain.setOpsumDate("\u4eca\u65e5");
                todayDomain.setOpsumListNum(this.getZeroNum(tenantCode, null));
                daOpsumListReDomainsResultToday.add(todayDomain);
                new saveUserinfoSumThread(this.daOpsumService, this.daOpsumListService, this.userService, userPcode, opsumDimname, sumType, tenantCode, today, opsumCodeToday).start();
            }
            SupQueryResult supQueryResult = new SupQueryResult();
            resultMap.put("dataLast", daOpsumListReDomainsResultLast);
            resultMap.put("dataToday", daOpsumListReDomainsResultToday);
            return resultMap;
        }
        return null;
    }

    private BigDecimal getZeroNum(String tenantCode, String today) {
        HashMap<String, Object> paramUser = new HashMap<String, Object>();
        paramUser.put("userinfoPhoneNot", "true");
        paramUser.put("tenantCode", tenantCode);
        paramUser.put("endDate", today);
        paramUser.put("startRow", 0);
        paramUser.put("rows", 1);
        SupQueryResult<UmUserinfoReDomainBean> userinfoPage = this.userService.queryUserinfoPage(paramUser);
        if (null != userinfoPage) {
            return new BigDecimal(userinfoPage.getPageTools().getRecordCount());
        }
        return new BigDecimal(0);
    }

    private Map<String, Object> queryOpsumListPageCommToday(String userPcode, String sumType, String tenantCode, Map<String, Object> resultMap) {
        SupQueryResult<DaOpsumReDomain> QueryResult2;
        Date todayDate = new Date();
        Calendar calendarToday = Calendar.getInstance();
        calendarToday.setTime(todayDate);
        String pattern = "yyyy-MM-dd";
        todayDate = calendarToday.getTime();
        SimpleDateFormat sdfToday = new SimpleDateFormat(pattern);
        String today = sdfToday.format(todayDate);
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (null != param) {
            param.put("tenantCode", tenantCode);
            param.put("order", true);
            param.put("opsumDate", today);
            param.put("opsumType", sumType);
            param.put("opsumDimcode", userPcode);
        }
        if (null == (QueryResult2 = this.daOpsumService.queryOpsumPage(param)) || QueryResult2.getList().isEmpty()) {
            this.logger.error(CODE + "queryOpsumListPageCommToday.QueryResult.QueryResult", (Object)"result is null");
            return null;
        }
        DaOpsumReDomain daOpsumReDomainToday = (DaOpsumReDomain)QueryResult2.getList().get(0);
        String opsumCodeToday = daOpsumReDomainToday.getOpsumCode();
        HashMap<String, Object> paramToday = new HashMap<String, Object>();
        paramToday.put("opsumCode", opsumCodeToday);
        paramToday.put("tenantCode", tenantCode);
        paramToday.put("opsumDate", today);
        ArrayList<DaOpsumListReDomain> daOpsumListReDomainsResultToday = new ArrayList<DaOpsumListReDomain>();
        SupQueryResult<DaOpsumListReDomain> todayResult = this.daOpsumListService.queryOpsumListPage(paramToday);
        if (null != todayResult) {
            List listToday = todayResult.getList();
            for (DaOpsumListReDomain todayDomain : listToday) {
                todayDomain.setOpsumDate("\u4eca\u65e5");
                daOpsumListReDomainsResultToday.add(todayDomain);
            }
            SupQueryResult supQueryResult = new SupQueryResult();
            resultMap.put("dataLast", "0");
            resultMap.put("dataToday", daOpsumListReDomainsResultToday);
            return resultMap;
        }
        return null;
    }

    @RequestMapping(value={"queryOpsumListNextPageForSeller.json"}, name="\u67e5\u8be2\u5f85\u529e\u6570\u636e\u660e\u7ec6\u5206\u9875\u7ed9\u5546\u5bb6")
    @ResponseBody
    public SupQueryResult<DaOpsumListReDomain> queryOpsumListNextPageForSeller(HttpServletRequest request, String sumType) {
        String tenantCode;
        if (null == sumType) {
            this.logger.error(CODE + "queryOpsumListNextPageForSellerparam is null");
            return null;
        }
        String userPcode = this.getUserSession(request).getUserPcode();
        SupQueryResult<DaOpsumListReDomain> result = this.queryOpsumListNextPageComm(userPcode, sumType, tenantCode = this.getTenantCode(request));
        if (null == result) {
            this.logger.error(CODE + "queryOpsumListNextPageForSellerresult is null");
            return null;
        }
        return result;
    }

    @RequestMapping(value={"queryOpsumListNextPageForBusiness.json"}, name="\u67e5\u8be2\u5f85\u529e\u6570\u636e\u660e\u7ec6\u5206\u9875\u7ed9\u8fd0\u8425")
    @ResponseBody
    public SupQueryResult<DaOpsumListReDomain> queryOpsumListNextPageForBusiness(HttpServletRequest request, String sumType) {
        String tenantCode;
        if (null == sumType) {
            this.logger.error(CODE + "queryOpsumListNextPageForBusinessparam is null");
            return null;
        }
        String userPcode = this.getUserSession(request).getUserPcode();
        SupQueryResult<DaOpsumListReDomain> result = this.queryOpsumListNextPageComm(userPcode, sumType, tenantCode = this.getTenantCode(request));
        if (null == result) {
            this.logger.error(CODE + "queryOpsumListNextPageForBusinessresult is null");
            return null;
        }
        return result;
    }

    @RequestMapping(value={"queryOpsumListNextPageForPlat.json"}, name="\u67e5\u8be2\u5f85\u529e\u6570\u636e\u660e\u7ec6\u5206\u9875\u7ed9\u4e2d\u53f0")
    @ResponseBody
    public SupQueryResult<DaOpsumListReDomain> queryOpsumListNextPageForPlat(HttpServletRequest request, String sumType) {
        if (null == sumType) {
            this.logger.error(CODE + "queryOpsumListNextPageForPlatparam is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        SupQueryResult<DaOpsumListReDomain> result = this.queryOpsumListNextPageComm(tenantCode, sumType, tenantCode);
        if (null == result) {
            this.logger.error(CODE + "queryOpsumListNextPageForPlatresult is null");
            return null;
        }
        return result;
    }

    private SupQueryResult<DaOpsumListReDomain> queryOpsumListNextPageComm(String opsumDimcode, String sumType, String tenantCode) {
        SupQueryResult<DaOpsumReDomain> daOpsumReDomainSupQueryResult;
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (null != param) {
            param.put("order", true);
            param.put("tenantCode", tenantCode);
            param.put("opsumType", sumType);
            param.put("opsumDimcode", opsumDimcode);
        }
        if (null == (daOpsumReDomainSupQueryResult = this.daOpsumService.queryOpsumPage(param)) || daOpsumReDomainSupQueryResult.getList().isEmpty()) {
            this.logger.error(CODE + ".queryOpsumListNextPageForPlat.daOpsumReDomainSupQueryResult", (Object)"result is null");
            return null;
        }
        DaOpsumReDomain daOpsumReDomain = (DaOpsumReDomain)daOpsumReDomainSupQueryResult.getList().get(0);
        String opsumCode = daOpsumReDomain.getOpsumCode();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("opsumCode", opsumCode);
        map.put("tenantCode", tenantCode);
        SupQueryResult<DaOpsumListReDomain> daOpsumListReDomainSupQueryResult = this.daOpsumListService.queryOpsumListPage(map);
        if (null != daOpsumListReDomainSupQueryResult) {
            return daOpsumListReDomainSupQueryResult;
        }
        return null;
    }

    @RequestMapping(value={"queryOpsumlistPageNewForBus.json"}, name="\u67e5\u8be2\u8fd0\u8425\u7edf\u8ba1\u6570\u636e")
    @ResponseBody
    public SupQueryResult<DaOpsumListReDomain> queryOpsumlistPageNewForBus(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null == param) {
            param = new HashMap<String, Object>();
        }
        param.put("order", true);
        String tenantCode = this.getTenantCode(request);
        String userPcode = this.getUserSession(request).getUserinfoParentCode();
        if (StringUtils.isBlank((String)userPcode)) {
            userPcode = this.getUserSession(request).getUserPcode();
        }
        param.put("opsumDimcode", userPcode);
        if (null == param.get("orderStr") || StringUtils.isBlank((String)param.get("orderStr").toString())) {
            param.put("orderStr", "opsum_Date");
        }
        if (null == param.get("opsumDimcode1") || StringUtils.isBlank((String)param.get("opsumDimcode1").toString())) {
            param.put("opsumDimcode1", "all");
        }
        if (null == param.get("opsumDimcode2") || StringUtils.isBlank((String)param.get("opsumDimcode2").toString())) {
            param.put("opsumDimcode2", "all");
        }
        if (null == param.get("opsumDate") || StringUtils.isBlank((String)param.get("opsumDate").toString())) {
            param.put("opsumDate", DateUtil.getDateString((Date)new Date(), (String)"yyyy-MM-dd"));
        }
        param.put("tenantCode", tenantCode);
        return this.daOpsumListService.queryOpsumListPage(param);
    }

    @RequestMapping(value={"queryOpsumlistPageNewForPlat.json"}, name="\u67e5\u8be2\u5e73\u53f0\u7edf\u8ba1\u6570\u636e")
    @ResponseBody
    public SupQueryResult<DaOpsumListReDomain> queryOpsumlistPageNewForPlat(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null == param) {
            param = new HashMap<String, Object>();
        }
        param.put("order", true);
        String tenantCode = this.getTenantCode(request);
        param.put("opsumDimcode", tenantCode);
        if (null == param.get("orderStr") || StringUtils.isBlank((String)param.get("orderStr").toString())) {
            param.put("orderStr", "opsum_Date");
        }
        if (null == param.get("opsumDimcode1") || StringUtils.isBlank((String)param.get("opsumDimcode1").toString())) {
            param.put("opsumDimcode1", "all");
        }
        if (null == param.get("opsumDimcode2") || StringUtils.isBlank((String)param.get("opsumDimcode2").toString())) {
            param.put("opsumDimcode2", "all");
        }
        if (null != param.get("startDate") && null != param.get("endDate")) {
            Date startDate = DateUtil.getDateToString((String)String.valueOf(param.get("startDate")), (String)"yyyy-MM-dd");
            Date endDate = DateUtil.getDateToString((String)String.valueOf(param.get("endDate")), (String)"yyyy-MM-dd");
            List<Date> dates = OpsumlistCon.findDates(startDate, endDate);
            String opsumDate = "";
            if (ListUtil.isNotEmpty(dates)) {
                for (Date date : dates) {
                    opsumDate = opsumDate + DateUtil.getDateString((Date)date, (String)"yyyy-MM-dd") + ",";
                }
                opsumDate = opsumDate.substring(0, opsumDate.length() - 1);
            }
            param.put("opsumDate", opsumDate);
        } else {
            param.put("opsumDate", DateUtil.getDateString((Date)new Date(), (String)"yyyy-MM-dd"));
        }
        param.put("tenantCode", tenantCode);
        return this.daOpsumListService.queryOpsumListPage(param);
    }

    public static List<Date> findDates(Date dBegin, Date dEnd) {
        ArrayList<Date> lDate = new ArrayList<Date>();
        lDate.add(dBegin);
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(dBegin);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(dEnd);
        while (dEnd.after(calBegin.getTime())) {
            calBegin.add(5, 1);
            lDate.add(calBegin.getTime());
        }
        return lDate;
    }

    public static void main(String[] args) {
        OpsumlistCon.findDates(new Date(), new Date());
    }

    @RequestMapping(value={"queryOpsumlistPageNewForUser.json"}, name="\u67e5\u8be2\u7528\u6237\u7edf\u8ba1\u6570\u636e")
    @ResponseBody
    public SupQueryResult<DaOpsumListReDomain> queryOpsumlistPageNewForUser(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null == param) {
            param = new HashMap<String, Object>();
        }
        param.put("order", true);
        String userPcode = this.getUserSession(request).getUserPcode();
        String tenantCode = this.getTenantCode(request);
        param.put("opsumDimcode", userPcode);
        if (null == param.get("orderStr") || StringUtils.isBlank((String)param.get("orderStr").toString())) {
            param.put("orderStr", "opsum_Date");
        }
        if (null == param.get("opsumDimcode1") || StringUtils.isBlank((String)param.get("opsumDimcode1").toString())) {
            param.put("opsumDimcode1", "all");
        }
        if (null == param.get("opsumDimcode2") || StringUtils.isBlank((String)param.get("opsumDimcode2").toString())) {
            param.put("opsumDimcode2", "all");
        }
        if (null != param.get("startDate") && null != param.get("endDate")) {
            Date startDate = DateUtil.getDateToString((String)String.valueOf(param.get("startDate")), (String)"yyyy-MM-dd");
            Date endDate = DateUtil.getDateToString((String)String.valueOf(param.get("endDate")), (String)"yyyy-MM-dd");
            List<Date> dates = OpsumlistCon.findDates(startDate, endDate);
            String opsumDate = "";
            if (ListUtil.isNotEmpty(dates)) {
                for (Date date : dates) {
                    opsumDate = opsumDate + DateUtil.getDateString((Date)date, (String)"yyyy-MM-dd") + ",";
                }
                opsumDate = opsumDate.substring(0, opsumDate.length() - 1);
            }
            param.put("opsumDate", opsumDate);
        } else {
            param.put("opsumDate", DateUtil.getDateString((Date)new Date(), (String)"yyyy-MM-dd"));
        }
        param.put("tenantCode", tenantCode);
        return this.daOpsumListService.queryOpsumListPage(param);
    }

    @RequestMapping(value={"queryOpsumlistPageForAtPoPrice.json"}, name="\u67e5\u8be2\u7ade\u4ef7\u6b63\u5411\u6ea2\u4ef7\u6570\u636e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DaOpsumListBigDataReDomain> queryOpsumlistPageForAtPoPrice(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("opsetType", "PoAtGinfoPrice");
            param.put("groupByDate", true);
            param.put("opsumListNumSum", true);
        }
        return this.daOpsumListService.querySimpleOpsumListPage(param);
    }

    @RequestMapping(value={"queryOpsumlistPageForAtRePrice.json"}, name="\u67e5\u8be2\u7ade\u4ef7\u53cd\u5411\u6ea2\u4ef7\u6570\u636e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DaOpsumListBigDataReDomain> queryOpsumlistPageForAtRePrice(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("opsetType", "ReAtGinfoPrice");
            param.put("groupByDate", true);
            param.put("opsumListNumSum", true);
        }
        return this.daOpsumListService.querySimpleOpsumListPage(param);
    }
}

