/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.resources;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.rs.RsGoodsFileDomain;
import cn.com.qj.bff.domain.rs.RsGoodsRelDomain;
import cn.com.qj.bff.domain.rs.RsGoodsRelReDomain;
import cn.com.qj.bff.domain.rs.RsSkuReDomain;
import cn.com.qj.bff.service.rs.RsGoodsOtherService;
import cn.com.qj.bff.service.rs.RsSkuService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/goodsRel"}, name="\u5546\u54c1\u5176\u5b83\u4fe1\u606f")
public class GoodsRelCon
extends SpringmvcController {
    private static String CODE = "rs.goodsRel.con";
    @Autowired
    private RsGoodsOtherService rsGoodsOtherService;
    @Autowired
    private RsSkuService rsSkuService;

    @Override
    protected String getContext() {
        return "goodsRel";
    }

    @RequestMapping(value={"saveGoodsRel.json"}, name="\u589e\u52a0\u5546\u54c1\u5176\u5b83\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveGoodsRel(HttpServletRequest request, RsGoodsRelDomain goodsRelDomain) {
        if (null == goodsRelDomain) {
            this.logger.error(CODE + ".saveGoodsRel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveGoodsRel", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        goodsRelDomain.setMemberCode(this.getMemberCode(request));
        goodsRelDomain.setMemberName(userSession.getUserName());
        goodsRelDomain.setTenantCode(this.getTenantCode(request));
        return this.rsGoodsOtherService.saveGoodsRel(goodsRelDomain);
    }

    @RequestMapping(value={"getGoodsRel.json"}, name="\u83b7\u53d6\u5546\u54c1\u5176\u5b83\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public RsGoodsRelDomain getGoodsRel(String goodsRelId) {
        if (StringUtils.isBlank((String)goodsRelId)) {
            this.logger.error(CODE + ".getGoodsRel", (Object)"param is null");
            return null;
        }
        return this.rsGoodsOtherService.getGoodsRel(Integer.valueOf(goodsRelId));
    }

    @RequestMapping(value={"updateGoodsRel.json"}, name="\u66f4\u65b0\u5546\u54c1\u5176\u5b83\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateGoodsRel(HttpServletRequest request, RsGoodsRelDomain goodsRelDomain) {
        if (null == goodsRelDomain) {
            this.logger.error(CODE + ".updateGoodsRel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        goodsRelDomain.setTenantCode(this.getTenantCode(request));
        return this.rsGoodsOtherService.updateGoodsRel(goodsRelDomain);
    }

    @RequestMapping(value={"deleteGoodsRel.json"}, name="\u5220\u9664\u5546\u54c1\u5176\u5b83\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteGoodsRel(String goodsRelId) {
        if (StringUtils.isBlank((String)goodsRelId)) {
            this.logger.error(CODE + ".deleteGoodsRel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsGoodsOtherService.deleteGoodsRel(Integer.valueOf(goodsRelId));
    }

    @RequestMapping(value={"queryGoodsRelPage.json"}, name="\u67e5\u8be2\u5546\u54c1\u5176\u5b83\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsGoodsRelReDomain> queryGoodsRelPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsGoodsOtherService.queryGoodsRelPage(param);
    }

    @RequestMapping(value={"updateGoodsRelState.json"}, name="\u66f4\u65b0\u5546\u54c1\u5176\u5b83\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateGoodsRelState(String goodsRelId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)goodsRelId)) {
            this.logger.error(CODE + ".updateGoodsRelState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsGoodsOtherService.updateGoodsRelState(Integer.valueOf(goodsRelId), dataState, oldDataState);
    }

    @RequestMapping(value={"querySkuBySkuCode.json"}, name="\u83b7\u53d6\u5957\u9910sku")
    @ResponseBody
    public List<RsSkuReDomain> querySkuBySkuCode(HttpServletRequest request, String skuCodeStr) {
        if (StringUtils.isBlank((String)skuCodeStr)) {
            this.logger.error(CODE + ".querySkuBySkuCode", (Object)"param is null");
            return null;
        }
        ArrayList<RsSkuReDomain> rsSkuReDomains = new ArrayList<RsSkuReDomain>();
        List<String> skuCodeList = this.getGoodsIdList(skuCodeStr);
        ArrayList<RsGoodsRelDomain> rsGoodsRelDomains = null;
        RsGoodsRelDomain rsGoodsRelDomain = null;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", this.getTenantCode(request));
        HashMap<String, Object> skuParam = new HashMap<String, Object>();
        skuParam.put("tenantCode", this.getTenantCode(request));
        for (String skuCode : skuCodeList) {
            rsGoodsRelDomains = new ArrayList<RsGoodsRelDomain>();
            skuParam.put("skuCode", skuCode);
            RsSkuReDomain skuReDomain = this.rsSkuService.getSkuByCode(skuParam);
            if (null == skuReDomain) continue;
            param.put("goodsSkuCode", skuCode);
            SupQueryResult<RsGoodsRelReDomain> supQueryResult = this.rsGoodsOtherService.queryGoodsRelPage(param);
            if (null != supQueryResult && null != supQueryResult.getList() && supQueryResult.getList().size() > 0) {
                for (RsGoodsRelReDomain relReDomain : supQueryResult.getList()) {
                    rsGoodsRelDomain = new RsGoodsRelDomain();
                    rsGoodsRelDomain.setSkuName(relReDomain.getSkuName());
                    rsGoodsRelDomain.setSkuCode(relReDomain.getSkuCode());
                    rsGoodsRelDomain.setPricesetNprice(relReDomain.getPricesetNprice());
                    rsGoodsRelDomain.setDataPic(relReDomain.getDataPic());
                    rsGoodsRelDomains.add(rsGoodsRelDomain);
                }
                skuReDomain.setRsGoodsRelDomainList(rsGoodsRelDomains);
            }
            rsSkuReDomains.add(skuReDomain);
        }
        return rsSkuReDomains.size() > 0 ? rsSkuReDomains : null;
    }

    private List<String> getGoodsIdList(String skuCodeStr) {
        String[] codeStr = skuCodeStr.split(",");
        ArrayList<String> skuCodeList = new ArrayList<String>();
        for (String code : codeStr) {
            skuCodeList.add(code);
        }
        return skuCodeList;
    }

    @RequestMapping(value={"addFiles.json"}, name="\u6279\u91cf\u6dfb\u52a0\u6587\u4ef6")
    @ResponseBody
    public HtmlJsonReBean saveGoods(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsForMem", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsForMem", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        List rsGoodsFileDomainList = JsonUtil.buildNonDefaultBinder().getJsonToList(paramStr, RsGoodsFileDomain.class);
        if (rsGoodsFileDomainList == null) {
            new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "goods is null");
        }
        for (RsGoodsFileDomain RsResourceGoods : rsGoodsFileDomainList) {
            RsResourceGoods.setTenantCode(tenantCode);
        }
        this.rsGoodsOtherService.saveGoodsFileList(rsGoodsFileDomainList);
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateFiles.json"}, name="\u6279\u91cf\u4fee\u6539\u6587\u4ef6")
    @ResponseBody
    public HtmlJsonReBean updateFiles(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoodsForMem", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveResourceGoodsForMem", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        List rsGoodsFileDomainList = JsonUtil.buildNonDefaultBinder().getJsonToList(paramStr, RsGoodsFileDomain.class);
        if (rsGoodsFileDomainList == null) {
            new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "goods is null");
        }
        for (RsGoodsFileDomain RsResourceGoods : rsGoodsFileDomainList) {
            RsResourceGoods.setTenantCode(tenantCode);
        }
        this.rsGoodsOtherService.updGoodsFileList(rsGoodsFileDomainList);
        return new HtmlJsonReBean();
    }
}

