/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.outorder;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.oc.OrderContractGoodsBean;
import cn.com.qj.bff.domain.oc.OrderDomain;
import cn.com.qj.bff.domain.oc.PackageDomain;
import cn.com.qj.bff.domain.oc.TypeBean;
import cn.com.qj.bff.domain.outorder.Md5Util;
import cn.com.qj.bff.domain.rs.RsSkuReDomain;
import cn.com.qj.bff.service.oc.OcService;
import cn.com.qj.bff.service.rs.RsSkuService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/ooc/outorder"}, name="\u5916\u90e8\u8ba2\u5355")
public class OutorderCon
extends SpringmvcController {
    private static String CODE = "ooc.outorder.con";
    @Autowired
    private OcService ocService;
    @Autowired
    private RsSkuService rsSkuService;

    @Override
    protected String getContext() {
        return "outorder";
    }

    @RequestMapping(value={"getUnionFreeGoSignInfo.json"}, name="\u83b7\u53d6\u798f\u745e\u8d2d\u5546\u57ce\u8054\u901a8848\u624b\u673a\u9875\u9762\u4e0b\u5355\u7684\u7b7e\u540d\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean getUnionFreeGoSignInfo(HttpServletRequest request, String skuNo, String callBackUrl) {
        if (StringUtils.isBlank((String)skuNo)) {
            this.logger.error(CODE + ".transformSignRequest.skuNo", (Object)"skuNo is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param skuNo is null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".transformSignRequest.userSession", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        HashMap<String, String> map = new HashMap<String, String>();
        String timestamp = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        map.put("developerId", "3402974513");
        map.put("goodsId", skuNo);
        map.put("outTransId", userSession.getUserPcode());
        map.put("sourceSystemId", "0609");
        map.put("timeStamp", timestamp);
        map.put("callBackUrl", this.getUrl(userSession.getTenantCode()));
        try {
            map.put("sign", this.getSignByOrderInfo(skuNo, userSession.getUserPcode(), timestamp, callBackUrl));
            htmlJsonReBean.setDataObj(map);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".transformSignRequest.skuNo", (Throwable)e);
            htmlJsonReBean = new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "get sign error", (Object)e);
        }
        return htmlJsonReBean;
    }

    private String getUrl(String tenantCode) {
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-outorder-outorder"));
    }

    private String getSignByOrderInfo(String skuNo, String userPcode, String timeStamp, String callBackUrl) {
        String paramKeyValueStr = "";
        paramKeyValueStr = StringUtils.isNotBlank((String)callBackUrl) && callBackUrl.startsWith("http") ? "callBackUrl=".concat(callBackUrl).concat("&developerId=3402974513").concat("&goodsId=").concat(skuNo).concat("&outTransId=").concat(userPcode).concat("&sourceSystemId=0609").concat("&timeStamp=").concat(timeStamp).concat("&key=192006250b4c09247ec02edce69f6a2d") : "developerId=3402974513".concat("&goodsId=").concat(skuNo).concat("&outTransId=").concat(userPcode).concat("&sourceSystemId=0609").concat("&timeStamp=").concat(timeStamp).concat("&key=192006250b4c09247ec02edce69f6a2d");
        String sign = Md5Util.md5(paramKeyValueStr, "").toUpperCase();
        return sign;
    }

    @RequestMapping(value={"saveOutorder.json"}, name="\u4e0b\u5355")
    @ResponseBody
    public HtmlJsonReBean saveOutorder(HttpServletRequest request, String outStr) {
        if (StringUtils.isBlank((String)outStr)) {
            this.logger.error(CODE + ".saveOutorder.outStr", (Object)"outStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        Map map = JsonUtil.buildNormalBinder().getJsonToMap(outStr, String.class, Object.class);
        if (null == map || map.isEmpty()) {
            this.logger.error(CODE + ".saveOutorder.map", (Object)"map is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveOrder(request, map);
    }

    private HtmlJsonReBean saveOrder(HttpServletRequest request, Map<String, Object> paramMap) {
        if (null == paramMap || paramMap.isEmpty()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String skuNo = (String)paramMap.get("goodsId");
        String tenantCode = this.getTenantCode(request);
        String outTransId = (String)paramMap.get("outTransId");
        if (StringUtils.isBlank((String)outTransId)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "outTransId is null");
        }
        if (StringUtils.isBlank((String)skuNo)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "goodsId is null");
        }
        if (!userSession.getUserPcode().equals(outTransId)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u53d8\u66f4");
        }
        HashMap<String, Object> skuMap = new HashMap<String, Object>();
        skuMap.put("skuNo", skuNo);
        skuMap.put("tenantCode", tenantCode);
        SupQueryResult<RsSkuReDomain> qresult = this.rsSkuService.querySkuPage(skuMap);
        if (null == qresult || null == qresult.getList() || qresult.getList().isEmpty()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "skuNo is null");
        }
        RsSkuReDomain rsSkuReDomain = (RsSkuReDomain)qresult.getList().get(0);
        if (null == rsSkuReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "rsSkuReDomain is null");
        }
        OrderDomain orderDomain = new OrderDomain();
        String shoppingType = rsSkuReDomain.getGoodsType();
        if (StringUtils.isBlank((String)shoppingType)) {
            shoppingType = "00";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        TypeBean typeBean = this.ocService.getOcSetting(shoppingType, tenantCode);
        if (null != typeBean) {
            orderDomain.setContractBlance(typeBean.getBlance());
            orderDomain.setContractPmode(typeBean.getPmode());
            map.put("contractBlance", typeBean.getBlance());
            map.put("contractPmode", typeBean.getPmode());
        }
        orderDomain.setContractRemark(skuNo);
        orderDomain.setContractType(shoppingType);
        orderDomain.setContractTypepro("02");
        orderDomain.setGoodsReceiptPhone((String)paramMap.get("custPhone"));
        orderDomain.setContractNbillcode((String)paramMap.get("orderCenterId"));
        orderDomain.setContractNbbillcode((String)paramMap.get("trandNo"));
        orderDomain.setGoodsReceiptArrdess((null == (String)paramMap.get("provinceCityArea") ? "" : (String)paramMap.get("provinceCityArea")) + (null == (String)paramMap.get("detailAddress") ? "" : (String)paramMap.get("detailAddress")));
        orderDomain.setGoodsReceiptMem((String)paramMap.get("custName"));
        orderDomain.setGoodsReceiptPhone((String)paramMap.get("custPhone"));
        orderDomain.setAppmanageIcode(this.getProappCode(request));
        ArrayList<PackageDomain> packageList = new ArrayList<PackageDomain>();
        orderDomain.setPackageList(packageList);
        PackageDomain packageDomain = new PackageDomain();
        packageList.add(packageDomain);
        ArrayList<OrderContractGoodsBean> contractGoodsList = new ArrayList<OrderContractGoodsBean>();
        packageDomain.setContractGoodsList(contractGoodsList);
        OrderContractGoodsBean ocContractGoodsDomain = new OrderContractGoodsBean();
        contractGoodsList.add(ocContractGoodsDomain);
        try {
            BeanUtils.copyAllPropertys((Object)ocContractGoodsDomain, (Object)rsSkuReDomain);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".saveOutorder.e", (Throwable)e);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "e");
        }
        ocContractGoodsDomain.setAppmanageIcode(this.getProappCode(request));
        ocContractGoodsDomain.setContractGoodsInmoney(rsSkuReDomain.getPricesetNprice());
        ocContractGoodsDomain.setContractGoodsMoney(rsSkuReDomain.getPricesetNprice());
        ocContractGoodsDomain.setContractGoodsPrice(rsSkuReDomain.getPricesetNprice());
        ocContractGoodsDomain.setGoodsCamount(new BigDecimal("1"));
        ocContractGoodsDomain.setGoodsNum(new BigDecimal("1"));
        ocContractGoodsDomain.setMemberBcode(userSession.getUserPcode());
        ocContractGoodsDomain.setMemberBname(userSession.getMerberCompname());
        ArrayList<OrderDomain> orderDomainList = new ArrayList<OrderDomain>();
        orderDomainList.add(orderDomain);
        map.put("contractType", shoppingType);
        HtmlJsonReBean htmlJsonReBean = this.ocService.createOcOrder(orderDomainList, shoppingType, userSession, this.getProappCode(request), this.getOauthEnvCode(request), null);
        if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
            return htmlJsonReBean;
        }
        map.put("dataBmoney", rsSkuReDomain.getPricesetNprice());
        map.put("contractBillcode", htmlJsonReBean.getDataObj());
        htmlJsonReBean.setDataObj(map);
        return htmlJsonReBean;
    }
}

