/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.dis;

import cn.com.qj.bff.controller.dis.ResComCon;
import cn.com.qj.bff.controller.dis.RsClassBean;
import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.dis.DisDgnumDomain;
import cn.com.qj.bff.domain.dis.DisDgnumListDomain;
import cn.com.qj.bff.domain.dis.DisDgnumListReDomain;
import cn.com.qj.bff.domain.dis.DisDgnumReDomain;
import cn.com.qj.bff.service.dis.DisChannelService;
import cn.com.qj.bff.service.dis.DisDgnumService;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/dis/dgnum"}, name="\u5168\u6e20\u9053\u5546\u54c1\u5e93\u5b58")
public class DgnumCon
extends ResComCon {
    private static String CODE = "dis.dgnum.con";
    @Autowired
    private DisDgnumService disDgnumService;
    @Autowired
    private DisChannelService disChannelService;

    @Override
    protected String getContext() {
        return "dgnum";
    }

    @RequestMapping(value={"saveDgnum.json"}, name="\u589e\u52a0\u5168\u6e20\u9053\u5546\u54c1\u5e93\u5b58")
    @ResponseBody
    public HtmlJsonReBean saveDgnum(HttpServletRequest request, DisDgnumDomain disDgnumDomain) {
        if (null == disDgnumDomain) {
            this.logger.error(CODE + ".saveDgnum", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "session is null");
        }
        disDgnumDomain.setTenantCode(this.getTenantCode(request));
        this.copyChannel(disDgnumDomain, disDgnumDomain.getChannelCode(), disDgnumDomain.getTenantCode());
        return this.disDgnumService.saveDgnum(disDgnumDomain);
    }

    @RequestMapping(value={"getDgnum.json"}, name="\u83b7\u53d6\u5168\u6e20\u9053\u5546\u54c1\u5e93\u5b58\u4fe1\u606f")
    @ResponseBody
    public DisDgnumReDomain getDgnum(Integer dgnumId) {
        if (StringUtils.isBlank((Integer)dgnumId)) {
            this.logger.error(CODE + ".getDgnum", (Object)"param is null");
            return null;
        }
        return this.disDgnumService.getDgnum(dgnumId);
    }

    @RequestMapping(value={"updateDgnum.json"}, name="\u66f4\u65b0\u5168\u6e20\u9053\u5546\u54c1\u5e93\u5b58")
    @ResponseBody
    public HtmlJsonReBean updateDgnum(HttpServletRequest request, DisDgnumDomain disDgnumDomain) {
        if (null == disDgnumDomain) {
            this.logger.error(CODE + ".updateDgnum", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        disDgnumDomain.setTenantCode(this.getTenantCode(request));
        return this.disDgnumService.updateDgnum(disDgnumDomain);
    }

    @RequestMapping(value={"deleteDgnum.json"}, name="\u5220\u9664\u5168\u6e20\u9053\u5546\u54c1\u5e93\u5b58")
    @ResponseBody
    public HtmlJsonReBean deleteDgnum(Integer dgnumId) {
        if (StringUtils.isBlank((Integer)dgnumId)) {
            this.logger.error(CODE + ".deleteDgnum", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDgnumService.deleteDgnum(dgnumId);
    }

    @RequestMapping(value={"queryDgnumPage.json"}, name="\u67e5\u8be2\u5168\u6e20\u9053\u5546\u54c1\u5e93\u5b58\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisDgnumReDomain> queryDgnumPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.disDgnumService.queryDgnumPage(param);
    }

    @RequestMapping(value={"updateDgnumState.json"}, name="\u66f4\u65b0\u5168\u6e20\u9053\u5546\u54c1\u5e93\u5b58\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateDgnumState(String dgnumId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)dgnumId)) {
            this.logger.error(CODE + ".updateDgnumState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDgnumService.updateDgnumState(Integer.valueOf(dgnumId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryDgnumByGZPage.json"}, name="\u67e5\u8be2\u5168\u6e20\u9053\u5546\u54c1\u5e93\u5b58\u89c4\u683c\u8bbe\u7f6e")
    @ResponseBody
    public SupQueryResult<DisDgnumReDomain> queryDgnumByGZPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryDgnumCommon(param);
    }

    private SupQueryResult<DisDgnumReDomain> queryDgnumCommon(Map<String, Object> param) {
        return this.disDgnumService.queryDgnumPage(param);
    }

    @RequestMapping(value={"queryDgnumByZXPage.json"}, name="\u67e5\u8be2\u76f4\u9500\u6e20\u9053\u5546\u54c1\u5e93\u5b58\u89c4\u683c\u8bbe\u7f6e")
    @ResponseBody
    public SupQueryResult<DisDgnumReDomain> queryDgnumByZXPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryDgnumCommon(param);
    }

    @RequestMapping(value={"queryDgnumByMDPage.json"}, name="\u67e5\u8be2\u95e8\u5e97\u6e20\u9053\u5546\u54c1\u5e93\u5b58\u89c4\u683c\u8bbe\u7f6e")
    @ResponseBody
    public SupQueryResult<DisDgnumReDomain> queryDgnumByMDPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryDgnumCommon(param);
    }

    @RequestMapping(value={"saveDgnumByJson.json"}, name="\u589e\u52a0\u5168\u6e20\u9053\u5546\u54c1\u5e93\u5b58")
    @ResponseBody
    public HtmlJsonReBean saveDgnumByJson(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".saveDgnumByJson", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        DisDgnumDomain disDgnumDomain = (DisDgnumDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, DisDgnumDomain.class);
        if (null == disDgnumDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "session is null");
        }
        disDgnumDomain.setTenantCode(this.getTenantCode(request));
        this.copyChannel(disDgnumDomain, disDgnumDomain.getChannelCode(), disDgnumDomain.getTenantCode());
        return this.disDgnumService.saveDgnum(disDgnumDomain);
    }

    @RequestMapping(value={"saveBatchDgnumByJson.json"}, name="\u6279\u91cf\u589e\u52a0\u5168\u6e20\u9053\u5546\u54c1\u5e93\u5b58")
    @ResponseBody
    public HtmlJsonReBean saveBatchDgnumByJson(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".saveDgnumByJson", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u9009\u62e9\u4f60\u8981\u53d1\u5e03\u7684\u5185\u5bb9!");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "session is null");
        }
        List disDgnumDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, DisDgnumDomain.class);
        if (ListUtil.isEmpty((Collection)disDgnumDomainList)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53d1\u5e03\u7684\u5185\u5bb9\u4e3a\u7a7a!");
        }
        HashMap<String, String> brandMap = new HashMap<String, String>();
        HashMap<String, RsClassBean> classtreeMap = new HashMap<String, RsClassBean>();
        for (DisDgnumDomain disDgnumDomain : disDgnumDomainList) {
            disDgnumDomain.setTenantCode(this.getTenantCode(request));
            this.copyChannel(disDgnumDomain, disDgnumDomain.getChannelCode(), disDgnumDomain.getTenantCode());
            if (!ListUtil.isNotEmpty(disDgnumDomain.getDisDgnumListDomainList())) continue;
            ArrayList<DisDgnumListDomain> otherdisDgnumListList = new ArrayList<DisDgnumListDomain>();
            for (DisDgnumListDomain disDgnumListDomain : disDgnumDomain.getDisDgnumListDomainList()) {
                disDgnumListDomain.setTenantCode(this.getTenantCode(request));
                this.makeCode(disDgnumListDomain, disDgnumDomain, brandMap, classtreeMap, otherdisDgnumListList);
            }
            if (!ListUtil.isNotEmpty(otherdisDgnumListList)) continue;
            disDgnumDomain.getDisDgnumListDomainList().addAll(otherdisDgnumListList);
        }
        return this.disDgnumService.saveDgnumBatch(disDgnumDomainList);
    }

    private void setClass(DisDgnumListDomain disDgnumListDomain, List<DisDgnumListDomain> otherdisDgnumListList, List<RsClassBean> rsClassBeanList) {
        if (null == disDgnumListDomain || null == otherdisDgnumListList || ListUtil.isEmpty(rsClassBeanList)) {
            return;
        }
        for (int i = 0; i < rsClassBeanList.size(); ++i) {
            if (ListUtil.isEmpty(rsClassBeanList.get(i).getChildList())) {
                if (i == 0) {
                    disDgnumListDomain.setDgnumListValue(rsClassBeanList.get(i).getClasstreeCode());
                    disDgnumListDomain.setDgnumListValuen(rsClassBeanList.get(i).getClasstreeName());
                    continue;
                }
                DisDgnumListDomain newDisDgnumListDomain = new DisDgnumListDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)newDisDgnumListDomain, (Object)disDgnumListDomain);
                    newDisDgnumListDomain.setDgnumListValue(rsClassBeanList.get(i).getClasstreeCode());
                    newDisDgnumListDomain.setDgnumListValuen(rsClassBeanList.get(i).getClasstreeName());
                    otherdisDgnumListList.add(newDisDgnumListDomain);
                }
                catch (Exception exception) {}
                continue;
            }
            this.setClass(disDgnumListDomain, otherdisDgnumListList, rsClassBeanList.get(i).getChildList());
        }
    }

    private void makeCode(DisDgnumListDomain disDgnumListDomain, DisDgnumDomain disDgnumDomain, Map<String, String> brandMap, Map<String, RsClassBean> classtreeMap, List<DisDgnumListDomain> otherdisDgnumListList) {
        if (null == disDgnumListDomain || null == disDgnumDomain) {
            return;
        }
        disDgnumListDomain.setTenantCode(disDgnumDomain.getTenantCode());
        if ("classtreeCode".equals(disDgnumListDomain.getDgnumListType())) {
            if (StringUtils.isBlank((String)disDgnumListDomain.getDgnumListValue()) && StringUtils.isNotBlank((String)disDgnumListDomain.getDgnumListValuen())) {
                RsClassBean rsClassBean;
                if (MapUtil.isEmpty(classtreeMap)) {
                    this.getRsClasstree(null, disDgnumDomain.getChannelCode(), disDgnumDomain.getTenantCode(), classtreeMap);
                }
                if (null != (rsClassBean = classtreeMap.get(disDgnumListDomain.getDgnumListDes() + "-" + disDgnumListDomain.getDgnumListValue()))) {
                    if (ListUtil.isEmpty(rsClassBean.getChildList())) {
                        disDgnumListDomain.setDgnumListValue(rsClassBean.getClasstreeCode());
                    } else {
                        this.setClass(disDgnumListDomain, otherdisDgnumListList, rsClassBean.getChildList());
                    }
                }
            }
        } else if ("brandCode".equals(disDgnumListDomain.getDgnumListType())) {
            if (StringUtils.isBlank((String)disDgnumListDomain.getDgnumListValue()) && StringUtils.isNotBlank((String)disDgnumListDomain.getDgnumListValuen())) {
                if (MapUtil.isEmpty(brandMap)) {
                    this.getRsBrandAll(disDgnumDomain.getChannelCode(), disDgnumDomain.getTenantCode(), brandMap);
                }
                disDgnumListDomain.setDgnumListValue(brandMap.get(disDgnumListDomain.getDgnumListValuen()));
            }
        } else if ("warehouseCode".equals(disDgnumListDomain.getDgnumListType())) {
            // empty if block
        }
    }

    @RequestMapping(value={"queryDgnumPageBySS.json"}, name="\u67e5\u8be2\u4e0a\u852c\u6e20\u9053\u5546\u54c1\u5e93\u5b58\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisDgnumReDomain> queryDgnumPageBySS(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null != param.get("channelSort") && "3".equals(param.get("channelSort"))) {
            param.remove("channelSort");
            param.put("channelType", "1");
        }
        return this.disDgnumService.queryDgnumPage(param);
    }

    @RequestMapping(value={"saveDisDgnumListByJson.json"}, name="\u5e93\u5b58\u9002\u7528\u8303\u56f4\u589e\u52a0\u4ed3\u5e93")
    @ResponseBody
    public HtmlJsonReBean saveDisDgnumListByJson(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "paramStr is null");
        }
        List disDgnumListDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, DisDgnumListDomain.class);
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        if (ListUtil.isNotEmpty((Collection)disDgnumListDomainList)) {
            DisDgnumReDomain dgnumByCode = this.disDgnumService.getDgnumByCode(tenantCode, ((DisDgnumListDomain)disDgnumListDomainList.get(0)).getDgnumCode());
            if (null == dgnumByCode) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6240\u5c5e\u5e93\u5b58\u89c4\u5219\u4e3a\u7a7a");
            }
            String memberMcode = dgnumByCode.getMemberMcode();
            String memberMname = dgnumByCode.getMemberMname();
            String memberCode = dgnumByCode.getMemberCode();
            String memberName = dgnumByCode.getMemberName();
            for (DisDgnumListDomain disDgnumListDomain : disDgnumListDomainList) {
                disDgnumListDomain.setMemberMcode(memberMcode);
                disDgnumListDomain.setMemberMname(memberMname);
                disDgnumListDomain.setMemberCode(memberCode);
                disDgnumListDomain.setMemberName(memberName);
                disDgnumListDomain.setTenantCode(tenantCode);
            }
            return this.disDgnumService.saveDgnumListBatch(disDgnumListDomainList);
        }
        return new HtmlJsonReBean((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"deleteDgnumListByNumCode.json"}, name="\u5220\u9664\u5168\u6e20\u9053\u5546\u54c1\u5e93\u5b58")
    @ResponseBody
    public HtmlJsonReBean deleteDgnumListByNumCode(HttpServletRequest request, String dgnumCode) {
        if (StringUtils.isBlank((String)dgnumCode)) {
            this.logger.error(CODE + ".deleteDgnumListByNumCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDgnumService.deleteDgnumListByNumCode(this.getTenantCode(request), dgnumCode);
    }

    @RequestMapping(value={"getDgnumList.json"}, name="\u83b7\u53d6\u5168\u6e20\u9053\u5546\u54c1\u5e93\u5b58\u4fe1\u606f")
    @ResponseBody
    public DisDgnumListReDomain getDgnumList(Integer dgnumListId) {
        if (StringUtils.isBlank((Integer)dgnumListId)) {
            this.logger.error(CODE + ".getDgnum", (Object)"param is null");
            return null;
        }
        return this.disDgnumService.getDgnumList(dgnumListId);
    }

    @RequestMapping(value={"updateDgnumList.json"}, name="\u66f4\u65b0\u5168\u6e20\u9053\u5546\u54c1\u5e93\u5b58")
    @ResponseBody
    public HtmlJsonReBean updateDgnumList(HttpServletRequest request, DisDgnumListDomain disDgnumListDomain) {
        if (null == disDgnumListDomain) {
            this.logger.error(CODE + ".updateDgnum", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        disDgnumListDomain.setTenantCode(this.getTenantCode(request));
        return this.disDgnumService.updateDgnumList(disDgnumListDomain);
    }

    @RequestMapping(value={"deleteDgnumList.json"}, name="\u5220\u9664\u5168\u6e20\u9053\u5546\u54c1\u5e93\u5b58")
    @ResponseBody
    public HtmlJsonReBean deleteDgnumList(Integer dgnumListId) {
        if (StringUtils.isBlank((Integer)dgnumListId)) {
            this.logger.error(CODE + ".deleteDgnum", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.disDgnumService.deleteDgnumList(dgnumListId);
    }

    @RequestMapping(value={"deleteBatchDgnumList.json"}, name="\u6279\u91cf\u5220\u9664\u5168\u6e20\u9053\u5546\u54c1\u5e93\u5b58")
    @ResponseBody
    public HtmlJsonReBean deleteBatchDgnumList(String dgnumListIdList) {
        if (StringUtils.isBlank((String)dgnumListIdList)) {
            this.logger.error(CODE + ".dgnumListIdList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = null;
        List<Integer> dgnumListIdList1 = this.getDgnumListIdList(dgnumListIdList);
        for (Integer dgnum : dgnumListIdList1) {
            htmlJsonReBean = this.disDgnumService.deleteDgnumList(dgnum);
        }
        return htmlJsonReBean;
    }

    protected List<Integer> getDgnumListIdList(String goodsIdStr) {
        String[] idStr = goodsIdStr.split(",");
        ArrayList<Integer> getDpriceConfIdList = new ArrayList<Integer>();
        for (String id : idStr) {
            getDpriceConfIdList.add(Integer.parseInt(id));
        }
        return getDpriceConfIdList;
    }

    @RequestMapping(value={"queryDgnumListPage.json"}, name="\u67e5\u8be2\u5168\u6e20\u9053\u5546\u54c1\u5e93\u5b58\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DisDgnumListReDomain> queryDgnumListPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.disDgnumService.queryDgnumListPage(param);
    }
}

