/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.appmanage;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.am.AmCachekeyDomain;
import cn.com.qj.bff.domain.am.AmCachekeyReDomain;
import cn.com.qj.bff.service.am.AmCachekeyService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/am/cachekey"})
public class CachekeyCon
extends SpringmvcController {
    private static String CODE = "am.cachekey.con";
    @Autowired
    private AmCachekeyService amCachekeyService;

    @Override
    protected String getContext() {
        return "cachekey";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(AmCachekeyDomain amCachekeyDomain) {
        if (null == amCachekeyDomain) {
            this.logger.error(CODE + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.amCachekeyService.saveCachekey(amCachekeyDomain);
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, Integer cachekeyId, ModelMap modelMap) {
        modelMap.put((Object)"cachekeyReBean", (Object)this.getCachekey(cachekeyId));
        return this.getFtlTempPath(request) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, AmCachekeyDomain amCachekeyDomain) {
        if (null == amCachekeyDomain) {
            this.logger.error(CODE + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.amCachekeyService.updateCachekey(amCachekeyDomain);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, Integer cachekeyId) {
        if (StringUtils.isBlank((Integer)cachekeyId)) {
            this.logger.error(CODE + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.amCachekeyService.deleteCachekey(cachekeyId);
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, Integer cachekeyId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((Integer)cachekeyId) || StringUtils.isBlank((Integer)dataState) || StringUtils.isBlank((Integer)oldDataState)) {
            this.logger.error(CODE + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.amCachekeyService.updateCachekeyState(cachekeyId, dataState, oldDataState);
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, Integer cachekeyId, ModelMap modelMap) {
        modelMap.put((Object)"cachekeyReBean", (Object)this.getCachekey(cachekeyId));
        return this.getFtlTempPath(request) + "view";
    }

    private String getCachekey(Integer cachekeyId) {
        String rs = "{}";
        if (StringUtils.isBlank((Integer)cachekeyId)) {
            this.logger.error(CODE + ".getCachekey", (Object)"cachekeyId is null");
        } else {
            rs = JsonUtil.buildNormalBinder().toJson((Object)this.amCachekeyService.getCachekey(cachekeyId));
        }
        return rs;
    }

    @RequestMapping(value={"getCachekeyNew.json"})
    @ResponseBody
    public AmCachekeyReDomain getCachekeyNew(Integer cachekeyId) {
        if (StringUtils.isBlank((Integer)cachekeyId)) {
            this.logger.error(CODE + ".getCachekeyNew", (Object)"param is null");
            return null;
        }
        return this.amCachekeyService.getCachekeyNew(cachekeyId);
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public Object listQuery(HttpServletRequest request) {
        Map<String, Object> param = this.makeMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.amCachekeyService.queryCachekeyPage(param);
    }
}

