/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.lt;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.lt.LtLtinfoReDomain;
import cn.com.qj.bff.domain.lt.LtLtuserDomain;
import cn.com.qj.bff.domain.lt.LtLtuserReDomain;
import cn.com.qj.bff.domain.oc.OcContractGoodsDomain;
import cn.com.qj.bff.domain.oc.OrderDomain;
import cn.com.qj.bff.domain.oc.PackageDomain;
import cn.com.qj.bff.domain.oc.TypeBean;
import cn.com.qj.bff.service.lt.LtLtinfoService;
import cn.com.qj.bff.service.lt.LtLtuserService;
import cn.com.qj.bff.service.oc.OcService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/lt/ltuser"}, name="\u7528\u6237\u62bd\u5956")
public class LtuserCon
extends SpringmvcController {
    private static String CODE = "lt.ltuser.con";
    @Autowired
    private LtLtuserService ltLtuserService;
    @Autowired
    private LtLtinfoService ltLtinfoService;
    @Autowired
    private OcService ocService;

    @Override
    protected String getContext() {
        return "ltuser";
    }

    @RequestMapping(value={"saveLtuser.json"}, name="\u589e\u52a0\u7528\u6237\u62bd\u5956")
    @ResponseBody
    public HtmlJsonReBean saveLtuser(HttpServletRequest request, String ltinfoCode) {
        if (StringUtils.isBlank((String)ltinfoCode)) {
            this.logger.error(CODE + ".saveLtuser", (Object)"ltinfoCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        LtLtinfoReDomain ltLtinfoReDomain = this.ltLtinfoService.getLtinfoByCode(this.getTenantCode(request), ltinfoCode);
        if (null == ltLtinfoReDomain) {
            this.logger.error(CODE + ".saveLtuser", (Object)"ltLtinfoReDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveOrder(request, ltLtinfoReDomain);
    }

    private HtmlJsonReBean saveOrder(HttpServletRequest request, LtLtinfoReDomain ltLtinfoReDomain) {
        if (null == ltLtinfoReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OrderDomain orderDomain = new OrderDomain();
        String shoppingType = "09";
        HashMap<String, Object> map = new HashMap<String, Object>();
        TypeBean typeBean = this.ocService.getOcSetting(shoppingType, ltLtinfoReDomain.getTenantCode());
        if (null != typeBean) {
            orderDomain.setContractBlance(typeBean.getBlance());
            orderDomain.setContractPmode(typeBean.getPmode());
            map.put("contractBlance", typeBean.getBlance());
            map.put("contractPmode", typeBean.getPmode());
        }
        orderDomain.setContractRemark(ltLtinfoReDomain.getLtinfoName());
        orderDomain.setContractType(shoppingType);
        orderDomain.setContractTypepro("01");
        orderDomain.setGoodsReceiptPhone("");
        orderDomain.setContractNbillcode(ltLtinfoReDomain.getLtinfoCode());
        ArrayList<PackageDomain> packageList = new ArrayList<PackageDomain>();
        orderDomain.setPackageList(packageList);
        PackageDomain packageDomain = new PackageDomain();
        packageList.add(packageDomain);
        ArrayList<OcContractGoodsDomain> contractGoodsList = new ArrayList<OcContractGoodsDomain>();
        packageDomain.setContractGoodsList(contractGoodsList);
        OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
        contractGoodsList.add(ocContractGoodsDomain);
        ocContractGoodsDomain.setAppmanageIcode(this.getProappCode(request));
        ocContractGoodsDomain.setContractGoodsInmoney(ltLtinfoReDomain.getLtinfoMoney());
        ocContractGoodsDomain.setContractGoodsMoney(ltLtinfoReDomain.getLtinfoMoney());
        ocContractGoodsDomain.setContractGoodsPrice(ltLtinfoReDomain.getLtinfoMoney());
        ocContractGoodsDomain.setGoodsCamount(new BigDecimal("1"));
        ocContractGoodsDomain.setGoodsNum(new BigDecimal("1"));
        ocContractGoodsDomain.setGoodsName(ltLtinfoReDomain.getLtinfoName());
        ocContractGoodsDomain.setGoodsNo(ltLtinfoReDomain.getLtinfoCode());
        ocContractGoodsDomain.setGoodsCode(ltLtinfoReDomain.getLtinfoCode());
        ocContractGoodsDomain.setSkuCode(ltLtinfoReDomain.getLtinfoCode());
        ocContractGoodsDomain.setSkuNo(ltLtinfoReDomain.getLtinfoCode());
        ocContractGoodsDomain.setSkuName(ltLtinfoReDomain.getLtinfoName());
        ocContractGoodsDomain.setMemberBcode(userSession.getUserPcode());
        ocContractGoodsDomain.setMemberBname(userSession.getMerberCompname());
        ocContractGoodsDomain.setMemberCode(ltLtinfoReDomain.getMemberCode());
        ocContractGoodsDomain.setMemberName(ltLtinfoReDomain.getMemberName());
        ArrayList<OrderDomain> orderDomainList = new ArrayList<OrderDomain>();
        orderDomainList.add(orderDomain);
        map.put("contractType", shoppingType);
        HtmlJsonReBean htmlJsonReBean = this.ocService.createOcOrder(orderDomainList, shoppingType, userSession, this.getProappCode(request), this.getOauthEnvCode(request), null);
        if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
            return htmlJsonReBean;
        }
        map.put("dataBmoney", ltLtinfoReDomain.getLtinfoMoney());
        map.put("contractBillcode", htmlJsonReBean.getDataObj());
        htmlJsonReBean.setDataObj(map);
        return htmlJsonReBean;
    }

    @RequestMapping(value={"getLtuser.json"}, name="\u83b7\u53d6\u7528\u6237\u62bd\u5956\u4fe1\u606f")
    @ResponseBody
    public LtLtuserReDomain getLtuser(Integer ltuserId) {
        if (StringUtils.isBlank((Integer)ltuserId)) {
            this.logger.error(CODE + ".getLtuser", (Object)"param is null");
            return null;
        }
        return this.ltLtuserService.getLtuser(ltuserId);
    }

    @RequestMapping(value={"updateLtuser.json"}, name="\u66f4\u65b0\u7528\u6237\u62bd\u5956")
    @ResponseBody
    public HtmlJsonReBean updateLtuser(HttpServletRequest request, LtLtuserDomain ltLtuserDomain) {
        if (null == ltLtuserDomain) {
            this.logger.error(CODE + ".updateLtuser", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ltLtuserDomain.setTenantCode(this.getTenantCode(request));
        return this.ltLtuserService.updateLtuser(ltLtuserDomain);
    }

    @RequestMapping(value={"deleteLtuser.json"}, name="\u5220\u9664\u7528\u6237\u62bd\u5956")
    @ResponseBody
    public HtmlJsonReBean deleteLtuser(Integer ltuserId) {
        if (StringUtils.isBlank((Integer)ltuserId)) {
            this.logger.error(CODE + ".deleteLtuser", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ltLtuserService.deleteLtuser(ltuserId);
    }

    @RequestMapping(value={"queryLtuserPage.json"}, name="\u67e5\u8be2\u7528\u6237\u62bd\u5956\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<LtLtuserReDomain> queryLtuserPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ltLtuserService.queryLtuserPage(param);
    }

    @RequestMapping(value={"updateLtuserState.json"}, name="\u66f4\u65b0\u7528\u6237\u62bd\u5956\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateLtuserState(String ltuserId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)ltuserId)) {
            this.logger.error(CODE + ".updateLtuserState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ltLtuserService.updateLtuserState(Integer.valueOf(ltuserId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"getLtuserInfo.json"}, name="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u8005\u62bd\u5956\u4fe1\u606f\uff08\u53ef\u62bd\u5956\u6b21\u6570\u3001\u6d3b\u52a8\u3001\u5956\u54c1\u4fe1\u606f\uff09")
    @ResponseBody
    public LtLtinfoReDomain getLtuserInfo(HttpServletRequest request, String ltinfoCode) {
        Map<String, Object> param;
        LtLtinfoReDomain ltLtinfoReDomain;
        String memberCode = this.getNowChannel(request);
        if (StringUtils.isNotBlank((String)ltinfoCode)) {
            ltLtinfoReDomain = this.ltLtinfoService.getLtinfoByCode(this.getTenantCode(request), ltinfoCode);
            if (!memberCode.equals(ltLtinfoReDomain.getMemberCode())) {
                this.logger.error(CODE + ".getLtuserInfo.memberCode not exit", (Object)memberCode);
                return null;
            }
        } else {
            param = this.assemMapParam(request);
            if (null == param) {
                param = new HashMap<String, Object>();
                param.put("tenantCode", this.getTenantCode(request));
            }
            param.put("dataState", 1);
            param.put("memberCode", memberCode);
            SupQueryResult<LtLtinfoReDomain> qltinfo = this.ltLtinfoService.queryLtinfoPage(param);
            if (null == qltinfo || qltinfo.getList().isEmpty()) {
                this.logger.error(CODE + ".getLtuserInfo", (Object)"getLtuserInfo is null");
                return null;
            }
            ltLtinfoReDomain = (LtLtinfoReDomain)qltinfo.getList().get(0);
            ltLtinfoReDomain = this.ltLtinfoService.getLtinfoByCode(this.getTenantCode(request), ltLtinfoReDomain.getLtinfoCode());
        }
        if (null == (param = this.assemMapParam(request))) {
            param = new HashMap<String, Object>();
            param.put("tenantCode", this.getTenantCode(request));
        }
        param.put("ltinfoCode", ltLtinfoReDomain.getLtinfoCode());
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".getLtuserInfo", (Object)"userSession is null");
            return null;
        }
        param.put("memberBcode", userSession.getUserPcode());
        SupQueryResult<LtLtuserReDomain> qlist = this.ltLtuserService.queryLtuserPage(param);
        if (null != qlist && !qlist.getList().isEmpty()) {
            ltLtinfoReDomain.setLtuserNum(((LtLtuserReDomain)qlist.getList().get(0)).getLtuserNum());
        }
        return ltLtinfoReDomain;
    }

    @RequestMapping(value={"checkLtUserInfo.json"}, name="\u505c\u7528\u8f6c\u76d8\u8bbe\u7f6e\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean checkLtInfo(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (!param.containsKey("tenantCode") || !param.containsKey("ltInfoCode")) {
            this.logger.error(CODE + ".checkLtUserInfo.param is null", (Object)JsonUtil.buildNonDefaultBinder().toJson(param));
            return null;
        }
        String tenantCode = param.get("tenantCode").toString();
        String ltInfoCode = param.get("ltInfoCode").toString();
        LtLtinfoReDomain ltinfoByCode = this.ltLtinfoService.getLtinfoByCode(tenantCode, ltInfoCode);
        return null;
    }
}

