/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.pro;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.fm.FmFileReDomainBean;
import cn.com.qj.bff.domain.org.OrgEmployeeReDomain;
import cn.com.qj.bff.domain.pro.ProProjectCskuDomain;
import cn.com.qj.bff.domain.pro.ProProjectCskuReDomain;
import cn.com.qj.bff.domain.pro.ProProjectCustrelDomain;
import cn.com.qj.bff.domain.pro.ProProjectCustrelReDomain;
import cn.com.qj.bff.domain.pro.ProProjectDomain;
import cn.com.qj.bff.domain.pro.ProProjectFileDomain;
import cn.com.qj.bff.domain.pro.ProProjectFileReDomain;
import cn.com.qj.bff.domain.pro.ProProjectReDomain;
import cn.com.qj.bff.domain.pro.ProProjectSpecDomain;
import cn.com.qj.bff.domain.pro.ProProjectSpecReDomain;
import cn.com.qj.bff.domain.pro.ProProjectValueDomain;
import cn.com.qj.bff.domain.pro.ProProjectValueReDomain;
import cn.com.qj.bff.domain.rs.RsGoodsFileDomain;
import cn.com.qj.bff.domain.rs.RsPropertiesValueDomain;
import cn.com.qj.bff.domain.rs.RsResourceGoodsDomain;
import cn.com.qj.bff.domain.rs.RsResourceGoodsReDomain;
import cn.com.qj.bff.domain.rs.RsSpecValueDomain;
import cn.com.qj.bff.service.fm.FileService;
import cn.com.qj.bff.service.org.OrgEmployeeService;
import cn.com.qj.bff.service.pro.ProProjectCskuService;
import cn.com.qj.bff.service.pro.ProProjectCustrelService;
import cn.com.qj.bff.service.pro.ProProjectService;
import cn.com.qj.bff.service.rs.RsResourceGoodsService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/web/pro/project"}, name="\u9879\u76ee")
public class ProjectCon
extends SpringmvcController {
    private static String CODE = "pro.project.con";
    @Autowired
    private ProProjectService proProjectService;
    @Autowired
    private ProProjectCskuService proProjectCskuService;
    @Autowired
    private ProProjectCustrelService proProjectCustrelService;
    @Autowired
    private RsResourceGoodsService rsResourceGoodsService;
    @Autowired
    private OrgEmployeeService orgEmployeeService;
    @Autowired
    private FileService fileService;

    @Override
    protected String getContext() {
        return "project";
    }

    @RequestMapping(value={"saveProject.json"}, name="\u589e\u52a0\u9879\u76ee")
    @ResponseBody
    public HtmlJsonReBean saveProject(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveProject", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveProject", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ProProjectDomain proProjectDomain = (ProProjectDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, ProProjectDomain.class);
        if (null == proProjectDomain.getProProjectFileDomainList() || proProjectDomain.getProProjectFileDomainList().size() == 0) {
            this.logger.error(CODE + ".saveProject.fileList", (Object)"fileList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9879\u76ee\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == proProjectDomain.getProProjectSpecDomainList() || proProjectDomain.getProProjectSpecDomainList().size() == 0) {
            this.logger.error(CODE + ".saveProject.specList", (Object)"skuList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9879\u76ee\u89c4\u683c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (ProProjectSpecDomain projectSpec : proProjectDomain.getProProjectSpecDomainList()) {
            projectSpec.setSpecValueBillno(proProjectDomain.getProjectOcode());
        }
        if (null == proProjectDomain.getProProjectValueDomainList() || proProjectDomain.getProProjectValueDomainList().size() == 0) {
            this.logger.error(CODE + ".saveProject.valueList", (Object)"skuList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9879\u76ee\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        proProjectDomain.setTenantCode(this.getTenantCode(request));
        String userinfoCode = userSession.getUserPcode();
        String userCode = userSession.getUserCode();
        String tenantCode = this.getTenantCode(request);
        String json = SupDisUtil.getMap((String)"OrgEmployee-userCode", (String)(userCode + "-" + userinfoCode + "-" + tenantCode));
        proProjectDomain.setCompanyCode(json);
        this.logger.error("json==========" + json);
        this.logger.error("userinfoCode==========userCode tenantCode" + userinfoCode + userCode + tenantCode);
        return this.proProjectService.saveProject(proProjectDomain);
    }

    @RequestMapping(value={"getProject.json"}, name="\u83b7\u53d6\u9879\u76ee\u4fe1\u606f")
    @ResponseBody
    public ProProjectReDomain getProject(Integer projectId) {
        if (StringUtils.isBlank((Integer)projectId)) {
            this.logger.error(CODE + ".getProject", (Object)"param is null");
            return null;
        }
        return this.proProjectService.getProject(projectId);
    }

    @RequestMapping(value={"queryProjectBycode.json"}, name="\u6839\u636e\u5458\u5de5Code\u67e5\u8be2\u9879\u76ee\u4fe1\u606f")
    @ResponseBody
    public SupQueryResult<ProProjectReDomain> queryProjectBycode(HttpServletRequest request, String employeeCode) {
        Map<String, Object> map = this.assemMapParam(request);
        if (StringUtils.isBlank((String)employeeCode)) {
            this.logger.error(CODE + ".getProject", (Object)"param is null");
            return null;
        }
        map.put("employeeCode", employeeCode);
        return this.proProjectService.queryProjectPage(map);
    }

    @RequestMapping(value={"queryProjectFileBycode.json"}, name="\u83b7\u53d6\u9879\u76ee\u9644\u4ef6\u4fe1\u606f")
    @ResponseBody
    public SupQueryResult<ProProjectFileReDomain> queryProjectFileBycode(HttpServletRequest request, String projectCode) {
        Map<String, Object> map = this.assemMapParam(request);
        if (StringUtils.isBlank((String)projectCode)) {
            this.logger.error(CODE + ".getProjectFile", (Object)"param is null");
            return null;
        }
        map.put("projectCode", projectCode);
        return this.proProjectService.queryProjectFilePage(map);
    }

    @RequestMapping(value={"queryProjectSpecBycode.json"}, name="\u83b7\u53d6\u9879\u76ee\u89c4\u683c\u4fe1\u606f")
    @ResponseBody
    public SupQueryResult<ProProjectSpecReDomain> queryProjectSpecBycode(HttpServletRequest request, String projectCode) {
        Map<String, Object> map = this.assemMapParam(request);
        if (StringUtils.isBlank((String)projectCode)) {
            this.logger.error(CODE + ".getProject", (Object)"param is null");
            return null;
        }
        map.put("projectCode", projectCode);
        return this.proProjectService.queryProjectSpecPage(map);
    }

    @RequestMapping(value={"queryProjectValueBycode.json"}, name="\u83b7\u53d6\u9879\u76ee\u5c5e\u6027\u4fe1\u606f")
    @ResponseBody
    public SupQueryResult<ProProjectValueReDomain> queryProjectValueBycode(HttpServletRequest request, String projectCode) {
        Map<String, Object> map = this.assemMapParam(request);
        if (StringUtils.isBlank((String)projectCode)) {
            this.logger.error(CODE + ".getProject", (Object)"param is null");
            return null;
        }
        map.put("projectCode", projectCode);
        return this.proProjectService.queryProjectValuePage(map);
    }

    @RequestMapping(value={"updateProject.json"}, name="\u66f4\u65b0\u9879\u76ee")
    @ResponseBody
    public HtmlJsonReBean updateProject(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updateProject", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateProject", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ProProjectDomain proProjectDomain = (ProProjectDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, ProProjectDomain.class);
        proProjectDomain.setTenantCode(this.getTenantCode(request));
        if (null == proProjectDomain.getProProjectFileDomainList() || proProjectDomain.getProProjectFileDomainList().size() == 0) {
            this.logger.error(CODE + ".updateProject.fileList", (Object)"fileList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9879\u76ee\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == proProjectDomain.getProProjectSpecDomainList() || proProjectDomain.getProProjectSpecDomainList().size() == 0) {
            this.logger.error(CODE + ".updateProject.specList", (Object)"SpecList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9879\u76ee\u89c4\u683c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (ProProjectSpecDomain projectSpec : proProjectDomain.getProProjectSpecDomainList()) {
            projectSpec.setSpecValueBillno(proProjectDomain.getProjectOcode());
        }
        if (null == proProjectDomain.getProProjectValueDomainList() || proProjectDomain.getProProjectValueDomainList().size() == 0) {
            this.logger.error(CODE + ".updateProject.valueList", (Object)"valueList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9879\u76ee\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.proProjectService.updateProject(proProjectDomain);
    }

    @RequestMapping(value={"deleteProject.json"}, name="\u5220\u9664\u9879\u76ee")
    @ResponseBody
    public HtmlJsonReBean deleteProject(Integer projectId) {
        if (StringUtils.isBlank((Integer)projectId)) {
            this.logger.error(CODE + ".deleteProject", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.proProjectService.deleteProject(projectId);
    }

    @RequestMapping(value={"queryProjectPage.json"}, name="\u67e5\u8be2\u9879\u76ee\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ProProjectReDomain> queryProjectPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.proProjectService.queryProjectPage(param);
    }

    @RequestMapping(value={"updateProjectState.json"}, name="\u66f4\u65b0\u9879\u76ee\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateProjectState(String projectId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)projectId)) {
            this.logger.error(CODE + ".updateProjectState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.proProjectService.updateProjectState(Integer.valueOf(projectId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryProjectFilePage.json"}, name="\u9879\u76ee\u9644\u4ef6\u5206\u9875\u67e5\u8be2")
    @ResponseBody
    public SupQueryResult<ProProjectFileReDomain> queryProjectFilePage(HttpServletRequest request, String projectCode) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("projectCode", projectCode);
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.proProjectService.queryProjectFilePage(param);
    }

    @RequestMapping(value={"saveProjectFile.json"}, name="\u9879\u76ee\u9644\u4ef6\u65b0\u589e")
    @ResponseBody
    public HtmlJsonReBean saveProjectFile(HttpServletRequest request, ProProjectFileDomain proProjectFileDomain) {
        if (null == proProjectFileDomain) {
            this.logger.error(CODE + ".saveProject", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        proProjectFileDomain.setTenantCode(this.getTenantCode(request));
        return this.proProjectService.saveProjectFile(proProjectFileDomain);
    }

    private void makeChannel(RsResourceGoodsDomain rsResourceGoodsDomain, HttpServletRequest request) {
        String[] s;
        if (null == rsResourceGoodsDomain || null == request) {
            return;
        }
        String channelInfo = this.getChannel(request);
        if (StringUtils.isNotBlank((String)channelInfo) && null != (s = channelInfo.split(",")) && s.length > 1) {
            rsResourceGoodsDomain.setChannelCode(s[0]);
            rsResourceGoodsDomain.setChannelName(s[1]);
        }
    }

    @RequestMapping(value={"updateProjectShelfState.json"}, name="\u9879\u76ee\u4e0a\u67b6")
    @ResponseBody
    public HtmlJsonReBean updateProjectShelfState(HttpServletRequest request, String projectId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isBlank((String)projectId)) {
            this.logger.error(CODE + ".updateProjectShelfState", (Object)"param is null");
            return new HtmlJsonReBean((Object)HtmlJsonReBean.ERRORCODE);
        }
        ProProjectReDomain proProjectReDomain = this.proProjectService.getProjectReDomain(Integer.valueOf(projectId));
        if (null == proProjectReDomain) {
            this.logger.error(CODE + ".updateProjectShelfState", (Object)"proProjectReDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "proProjectReDomain");
        }
        map.put("goodsOrigin", "4");
        map.put("goodsNo", proProjectReDomain.getProjectCode());
        map.put("tenantCode", proProjectReDomain.getTenantCode());
        SupQueryResult<RsResourceGoodsReDomain> rsList = this.rsResourceGoodsService.queryResourceGoodsPage(map);
        if (null == rsList || null == rsList.getRows() || rsList.getRows().isEmpty()) {
            RsResourceGoodsDomain rsResourceGoodsDomain = this.make(request, proProjectReDomain);
            ArrayList<RsResourceGoodsDomain> goodsList = new ArrayList<RsResourceGoodsDomain>();
            goodsList.add(rsResourceGoodsDomain);
            HtmlJsonReBean htmlJsonReBean = this.rsResourceGoodsService.savePassResourceGoodsBatch(goodsList);
            String rs = htmlJsonReBean.getErrorCode();
            if (StringUtils.isNotBlank((String)rs)) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u64cd\u4f5c\u5931\u8d25");
            }
        }
        return this.proProjectService.updateProjectReleaseByCode(proProjectReDomain.getTenantCode(), proProjectReDomain.getProjectCode(), 1, 0);
    }

    private RsResourceGoodsDomain make(HttpServletRequest request, ProProjectReDomain proProjectReDomain) {
        List<ProProjectValueDomain> ProProjectValueList;
        List<ProProjectSpecDomain> ProProjectDomainSpecList;
        if (null == proProjectReDomain || null == request) {
            return null;
        }
        RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsResourceGoodsDomain, (Object)proProjectReDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        rsResourceGoodsDomain.setGoodsName(proProjectReDomain.getProjectName());
        rsResourceGoodsDomain.setGoodsNo(proProjectReDomain.getProjectCode());
        rsResourceGoodsDomain.setPntreeCode(proProjectReDomain.getPntreeCode());
        rsResourceGoodsDomain.setPntreeName(proProjectReDomain.getPntreeName());
        rsResourceGoodsDomain.setClasstreeCode(proProjectReDomain.getClasstreeCode());
        rsResourceGoodsDomain.setClasstreeName(proProjectReDomain.getClasstreeName());
        rsResourceGoodsDomain.setPricesetNprice(proProjectReDomain.getProjectMinprice());
        rsResourceGoodsDomain.setPricesetMakeprice(proProjectReDomain.getProjectMaxprice());
        rsResourceGoodsDomain.setBrandCode(proProjectReDomain.getBrandCode());
        rsResourceGoodsDomain.setBrandName(proProjectReDomain.getBrandName());
        rsResourceGoodsDomain.setGoodsProperty(proProjectReDomain.getProjectDes());
        rsResourceGoodsDomain.setGoodsProperty1(proProjectReDomain.getProjectOldcode());
        UserSession userSession = this.getUserSession(request);
        rsResourceGoodsDomain.setMemberCode(userSession.getUserPcode());
        rsResourceGoodsDomain.setMemberName(userSession.getUserName());
        rsResourceGoodsDomain.setTenantCode(this.getTenantCode(request));
        rsResourceGoodsDomain.setGoodsOrigin("4");
        rsResourceGoodsDomain.setGoodsType("04");
        rsResourceGoodsDomain.setPricesetMakeshow("1");
        rsResourceGoodsDomain.setPartsnameWeightunit("\u5428");
        rsResourceGoodsDomain.setGoodsWeight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsSupplyweight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsAhweight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsHangweight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsHangnum(new BigDecimal("999"));
        rsResourceGoodsDomain.setGoodsNum(new BigDecimal("99999"));
        rsResourceGoodsDomain.setGoodsAhnum(new BigDecimal("9999"));
        rsResourceGoodsDomain.setGoodsSupplynum(new BigDecimal("999"));
        this.makeChannel(rsResourceGoodsDomain, request);
        List<ProProjectFileDomain> proProjectFileDomainList = proProjectReDomain.getProProjectFileDomainList();
        if (!ListUtil.isEmpty(proProjectFileDomainList)) {
            ArrayList<RsGoodsFileDomain> rsGoodsFileList = new ArrayList<RsGoodsFileDomain>();
            for (ProProjectFileDomain proProjectFileDomain : proProjectFileDomainList) {
                RsGoodsFileDomain rsGoodsFile = new RsGoodsFileDomain();
                rsGoodsFile.setGoodsFileName(proProjectFileDomain.getProjectFilename());
                rsGoodsFile.setAppmanageIcode(proProjectFileDomain.getAppmanageIcode());
                rsGoodsFile.setGoodsFileSort(proProjectFileDomain.getProjectFileSort());
                rsGoodsFile.setGoodsFileType(proProjectFileDomain.getProjectFileType());
                rsGoodsFile.setGoodsFilesortName(proProjectFileDomain.getProjectFilesortName());
                rsGoodsFile.setGoodsFileUrl(proProjectFileDomain.getProjectFileUrl());
                rsGoodsFile.setTenantCode(proProjectFileDomain.getTenantCode());
                rsGoodsFileList.add(rsGoodsFile);
            }
            rsResourceGoodsDomain.setRsGoodsFileDomainList(rsGoodsFileList);
        }
        if (!ListUtil.isEmpty(ProProjectDomainSpecList = proProjectReDomain.getProProjectSpecDomainList())) {
            ArrayList<RsSpecValueDomain> RsSpecValueList = new ArrayList<RsSpecValueDomain>();
            for (ProProjectSpecDomain proProjectSpec : ProProjectDomainSpecList) {
                RsSpecValueDomain rsSpecValue = new RsSpecValueDomain();
                rsSpecValue.setAppmanageIcode(proProjectSpec.getAppmanageIcode());
                rsSpecValue.setSpecCode(proProjectSpec.getSpecCode());
                rsSpecValue.setSpecName(proProjectSpec.getSpecName());
                rsSpecValue.setSpecGroupCode(proProjectSpec.getSpecGroupCode());
                rsSpecValue.setSpecValueBillno(proProjectSpec.getSpecValueBillno());
                rsSpecValue.setSpecValueFlag(proProjectSpec.getSpecValueFlag());
                rsSpecValue.setSpecValueType(proProjectSpec.getSpecValueType());
                rsSpecValue.setSpecValueValue(proProjectSpec.getSpecValueValue());
                rsSpecValue.setTenantCode(proProjectSpec.getTenantCode());
                RsSpecValueList.add(rsSpecValue);
            }
            rsResourceGoodsDomain.setRsSpecValueDomainList(RsSpecValueList);
        }
        if (!ListUtil.isEmpty(ProProjectValueList = proProjectReDomain.getProProjectValueDomainList())) {
            ArrayList<RsPropertiesValueDomain> arrayList = new ArrayList<RsPropertiesValueDomain>();
            for (ProProjectValueDomain proProjectValue : ProProjectValueList) {
                RsPropertiesValueDomain rsPropertiesValue = new RsPropertiesValueDomain();
                rsPropertiesValue.setAppmanageIcode(proProjectValue.getAppmanageIcode());
                rsPropertiesValue.setTenantCode(proProjectValue.getTenantCode());
                rsPropertiesValue.setPropertiesCode(proProjectValue.getPropertiesCode());
                rsPropertiesValue.setPropertiesValueCode(proProjectValue.getProjectValueCode());
                rsPropertiesValue.setPropertiesValueType(proProjectValue.getPropertiesValueType());
                rsPropertiesValue.setPropertiesValueValue(proProjectValue.getPropertiesValueValue());
                arrayList.add(rsPropertiesValue);
            }
            rsResourceGoodsDomain.setRsPropertiesValueDomainList(arrayList);
        }
        return rsResourceGoodsDomain;
    }

    @RequestMapping(value={"updateProjectLowerState.json"}, name="\u9879\u76ee\u4e0b\u67b6")
    @ResponseBody
    public HtmlJsonReBean updateProjectLowerState(HttpServletRequest request, String projectCode) {
        HtmlJsonReBean htmlJsonReBean;
        String errorCode;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isBlank((String)projectCode)) {
            this.logger.error(CODE + ".updateProjectState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        map.put("goodsOrigin", "4");
        map.put("goodsNo", projectCode);
        map.put("tenantCode", tenantCode);
        SupQueryResult<RsResourceGoodsReDomain> rsResourceGoodsReDomainList = this.rsResourceGoodsService.queryResourceGoodsPage(map);
        List list = rsResourceGoodsReDomainList.getList();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (null != list && null != list.get(0)) {
            RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)list.get(0);
            String goodsCode = rsResourceGoodsReDomain.getGoodsCode();
            params.put("goodsOrigin", "4");
            params.put("goodsCode", goodsCode);
            params.put("tenantCode", tenantCode);
        }
        if (StringUtils.isNotBlank((String)(errorCode = (htmlJsonReBean = this.rsResourceGoodsService.delResourceGoodsByCode(params)).getErrorCode()))) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5220\u9664\u5546\u54c1\u5931\u8d25");
        }
        return this.proProjectService.updateProjectReleaseByCode(tenantCode, projectCode, 0, 1);
    }

    @RequestMapping(value={"queryProjectPageByUserCodeForC.json"}, name="C\u7aef\u67e5\u8be2\u9879\u76ee\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ProProjectReDomain> queryProjectPageByUserCodeForC(HttpServletRequest request, String userCode) {
        Map<String, Object> param = this.assemMapParam(request);
        if (StringUtils.isBlank((String)userCode)) {
            this.logger.error(CODE + ".queryProjectPageByUserCodeForC", (Object)"param is null");
            return null;
        }
        if (null != param) {
            param.put("custrelCode", userCode);
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.proProjectService.queryProjectPage(param);
    }

    @RequestMapping(value={"queryProjectFilePageByProjectCodeForC.json"}, name="C\u7aef\u67e5\u8be2\u9879\u76ee\u9644\u4ef6\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ProProjectFileReDomain> queryProjectFilePageByProjectCodeForC(HttpServletRequest request, String projectFileType, String projectCode) {
        Map<String, Object> param = this.assemMapParam(request);
        if (StringUtils.isBlank((String)projectCode)) {
            this.logger.error(CODE + ".queryProjectFilePageByProjectCodeForC", (Object)"param is null");
            return null;
        }
        if (StringUtils.isBlank((String)projectFileType)) {
            this.logger.error(CODE + ".queryProjectFilePageByProjectCodeForC", (Object)"param is null");
            return null;
        }
        if (null != param) {
            param.put("projectFileType", projectFileType);
            param.put("projectCode", projectCode);
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.proProjectService.queryProjectFilePage(param);
    }

    @RequestMapping(value={"updateProjectStartState.json"}, name="\u9879\u76ee\u5f00\u59cb\u5b9e\u65bd")
    @ResponseBody
    public HtmlJsonReBean updateProjectStartState(HttpServletRequest request, String projectCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((String)projectCode)) {
            this.logger.error(CODE + ".updateProjectStartState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        map.put("tenantCode", tenantCode);
        return this.proProjectService.updateProjectReleaseByCode(tenantCode, projectCode, 1, 2);
    }

    @RequestMapping(value={"updateProjectOverState.json"}, name="\u9879\u76ee\u5b8c\u6210")
    @ResponseBody
    public HtmlJsonReBean updateProjectOverState(HttpServletRequest request, String projectCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((String)projectCode)) {
            this.logger.error(CODE + ".updateProjectOverState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        map.put("tenantCode", tenantCode);
        return this.proProjectService.updateProjectReleaseByCode(tenantCode, projectCode, 2, 4);
    }

    @RequestMapping(value={"uploadGoodsFileForB.json"}, name="B\u7aef\u4e0a\u4f20\u5546\u54c1")
    @ResponseBody
    public FmFileReDomainBean uploadGoodsFileForB(HttpServletRequest request, MultipartFile file, String fileSort) {
        if (null == file) {
            this.logger.error(CODE + ".uploadGoodsFile", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        return this.fileService.saveFile(file, tenantCode, fileSort);
    }

    @RequestMapping(value={"saveProjectFileForB.json"}, name="B\u7aef\u9879\u76ee\u9644\u4ef6\u65b0\u589e")
    @ResponseBody
    public HtmlJsonReBean saveProjectFileForB(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".saveProjectFileForB", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List proProjectFileDomainList = JsonUtil.buildNonDefaultBinder().getJsonToList(paramStr, ProProjectFileDomain.class);
        return this.proProjectService.saveProjectFileBatch(proProjectFileDomainList);
    }

    @RequestMapping(value={"delProjectFileForBBatch.json"}, name="B\u7aef\u9879\u76ee\u9644\u4ef6\u6279\u91cf\u5220\u9664")
    @ResponseBody
    public HtmlJsonReBean delProjectFileForBBatch(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".delProjectFileForBBatch", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List projectIdList = JsonUtil.buildNonDefaultBinder().getJsonToList(paramStr, Integer.class);
        for (Integer projectIdId : projectIdList) {
            this.proProjectService.deleteProjectFile(projectIdId);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateProjectFileState.json"}, name="C\u7aef\u9644\u4ef6\u6279\u91cf\u4f2a\u5220\u9664")
    @ResponseBody
    public HtmlJsonReBean updateProjectFileState(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".updateProjectFileState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List projectIdList = JsonUtil.buildNonDefaultBinder().getJsonToList(paramStr, Integer.class);
        for (Integer projectIdId : projectIdList) {
            this.proProjectService.updateProjectFileState(projectIdId, 4, 0);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"saveProjectFileForM.json"}, name="\u8fd0\u8425\u7aef\u9879\u76ee\u9644\u4ef6\u65b0\u589e")
    @ResponseBody
    public HtmlJsonReBean saveProjectFileForM(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".saveProjectFileForM", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List proProjectFileDomainList = JsonUtil.buildNonDefaultBinder().getJsonToList(paramStr, ProProjectFileDomain.class);
        return this.proProjectService.saveProjectFileBatch(proProjectFileDomainList);
    }

    @RequestMapping(value={"queryProjectPageByUserCodeForB.json"}, name="B\u7aef\u67e5\u8be2\u9879\u76ee\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ProProjectReDomain> queryProjectPageByUserCodeForB(HttpServletRequest request, String userCode) {
        Map<String, Object> param = this.assemMapParam(request);
        if (StringUtils.isBlank((String)userCode)) {
            this.logger.error(CODE + ".queryProjectPageByUserCodeForB", (Object)"param is null");
            return null;
        }
        if (null != param) {
            param.put("employeeCode", userCode);
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.proProjectService.queryProjectPage(param);
    }

    @RequestMapping(value={"addProject.json"}, name="\u589e\u52a0\u9879\u76ee-\u9879\u76ee\u5ba2\u6237-\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean addProject(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveProject", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveProject", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ProProjectDomain proProjectDomain = (ProProjectDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, ProProjectDomain.class);
        if (null == proProjectDomain.getProProjectFileDomainList() || proProjectDomain.getProProjectFileDomainList().size() == 0) {
            this.logger.error(CODE + ".saveProject.fileList", (Object)"fileList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9879\u76ee\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == proProjectDomain.getProProjectSpecDomainList() || proProjectDomain.getProProjectSpecDomainList().size() == 0) {
            this.logger.error(CODE + ".saveProject.specList", (Object)"skuList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9879\u76ee\u89c4\u683c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == proProjectDomain.getProProjectValueDomainList() || proProjectDomain.getProProjectValueDomainList().size() == 0) {
            this.logger.error(CODE + ".saveProject.valueList", (Object)"skuList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9879\u76ee\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == proProjectDomain.getProProjectCskuDomainList() || proProjectDomain.getProProjectCskuDomainList().size() == 0) {
            this.logger.error(CODE + ".saveProject.CskuList", (Object)"CskuList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9879\u76ee\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == proProjectDomain.getProProjectCustrelDomainList() || proProjectDomain.getProProjectCustrelDomainList().size() == 0) {
            this.logger.error(CODE + ".saveProject.CustrelList", (Object)"CustrelList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9879\u76ee\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        proProjectDomain.setTenantCode(this.getTenantCode(request));
        String userinfoCode = userSession.getUserPcode();
        String tenantCode = this.getTenantCode(request);
        String companyCode = userSession.getCompanyCode();
        if (StringUtils.isBlank((String)companyCode)) {
            companyCode = UUID.randomUUID().toString().replace("-", "");
        }
        proProjectDomain.setCompanyCode(companyCode);
        proProjectDomain.setProjectOcode(this.createUUIDString());
        OrgEmployeeReDomain orgEmployeeReDomain = (OrgEmployeeReDomain)this.orgEmployeeService.queryEmployeePage(this.getQueryMapParam("userinfoCode,tenantCode", userinfoCode, tenantCode)).getList().get(0);
        proProjectDomain.setEmployeeCode(orgEmployeeReDomain.getEmployeeCode());
        proProjectDomain.setEmployeeName(orgEmployeeReDomain.getEmployeeName());
        this.logger.error("proProjectDomain++" + JsonUtil.buildNonDefaultBinder().toJson((Object)proProjectDomain));
        for (ProProjectValueDomain proProjectValueDomain : proProjectDomain.getProProjectValueDomainList()) {
            proProjectValueDomain.setPropertiesCode(this.createUUIDString());
        }
        HtmlJsonReBean htmlJsonReBean = this.proProjectService.saveProject(proProjectDomain);
        if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess() || null == htmlJsonReBean.getDataObj()) {
            return htmlJsonReBean;
        }
        this.logger.error("111===", (Object)JsonUtil.buildNormalBinder().toJson((Object)htmlJsonReBean.getDataObj().toString()));
        for (ProProjectCustrelDomain proProjectCustrelDomain : proProjectDomain.getProProjectCustrelDomainList()) {
            proProjectCustrelDomain.setProjectCode(htmlJsonReBean.getDataObj().toString());
            proProjectCustrelDomain.setProjectName(proProjectDomain.getProjectName());
            proProjectCustrelDomain.setProjectOcode(proProjectDomain.getProjectOcode());
            proProjectCustrelDomain.setCompanyCode(proProjectDomain.getCompanyCode());
            proProjectCustrelDomain.setCustrelCode(proProjectDomain.getCustrelCode());
            proProjectCustrelDomain.setCustrelName(proProjectDomain.getCustrelName());
            proProjectCustrelDomain.setTenantCode(this.getTenantCode(request));
        }
        this.proProjectCustrelService.saveProjectCustrelBatch(proProjectDomain.getProProjectCustrelDomainList());
        for (ProProjectCskuDomain proProjectCskuDomain : proProjectDomain.getProProjectCskuDomainList()) {
            proProjectCskuDomain.setCustrelCode(proProjectDomain.getCustrelCode());
            proProjectCskuDomain.setCustrelName(proProjectDomain.getCustrelName());
            proProjectCskuDomain.setCompanyCode(proProjectDomain.getCompanyCode());
            proProjectCskuDomain.setTenantCode(this.getTenantCode(request));
            proProjectCskuDomain.setGoodsNo(htmlJsonReBean.getDataObj().toString());
        }
        return this.proProjectCskuService.saveProjectCskuBatch(proProjectDomain.getProProjectCskuDomainList());
    }

    @RequestMapping(value={"saveProjectValue.json"}, name="\u589e\u52a0\u9879\u76ee\u5c5e\u6027")
    @ResponseBody
    public HtmlJsonReBean saveProjectValue(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveProject", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveProject", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ProProjectValueDomain proProjectValueDomain = (ProProjectValueDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, ProProjectValueDomain.class);
        proProjectValueDomain.setTenantCode(this.getTenantCode(request));
        proProjectValueDomain.setPropertiesCode(this.createUUIDString());
        return this.proProjectService.saveProjectValue(proProjectValueDomain);
    }

    @RequestMapping(value={"updateProjectValue.json"}, name="\u589e\u52a0\u9879\u76ee\u5c5e\u6027")
    @ResponseBody
    public HtmlJsonReBean updateProjectValue(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveProject", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveProject", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ProProjectValueDomain proProjectValueDomain = (ProProjectValueDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, ProProjectValueDomain.class);
        proProjectValueDomain.setTenantCode(this.getTenantCode(request));
        return this.proProjectService.updateProjectValue(proProjectValueDomain);
    }

    @RequestMapping(value={"queryProjectPages.json"}, name="\u67e5\u8be2\u9879\u76ee-\u5546\u54c1-\u5ba2\u6237\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<ProProjectReDomain> queryProjectPages(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        this.logger.error("param++", (Object)JsonUtil.buildNormalBinder().toJson(param));
        SupQueryResult<ProProjectReDomain> proProjectReDomainSupQueryResult = this.proProjectService.queryProjectPage(param);
        for (ProProjectReDomain proProjectReDomain : proProjectReDomainSupQueryResult.getList()) {
            ArrayList<ProProjectValueDomain> valueDomains = new ArrayList<ProProjectValueDomain>();
            ArrayList<ProProjectSpecDomain> specDomains = new ArrayList<ProProjectSpecDomain>();
            ArrayList<ProProjectCskuDomain> cskuDomains = new ArrayList<ProProjectCskuDomain>();
            ArrayList<ProProjectCustrelDomain> custrelDomains = new ArrayList<ProProjectCustrelDomain>();
            List provalueList = this.proProjectService.queryProjectValuePage(this.getQueryMapParam("projectCode,tenantCode", proProjectReDomain.getProjectCode(), this.getTenantCode(request))).getList();
            List specList = this.proProjectService.queryProjectSpecPage(this.getQueryMapParam("projectCode,tenantCode", proProjectReDomain.getProjectCode(), this.getTenantCode(request))).getList();
            List cskuList = this.proProjectCskuService.queryProjectCskuPage(this.getQueryMapParam("goodsNo,tenantCode", proProjectReDomain.getProjectCode(), this.getTenantCode(request))).getList();
            List custrelList = this.proProjectCustrelService.queryProjectCustrelPage(this.getQueryMapParam("projectCode,tenantCode", proProjectReDomain.getProjectCode(), this.getTenantCode(request))).getList();
            for (ProProjectValueReDomain proProjectValueReDomain : provalueList) {
                valueDomains.add(proProjectValueReDomain);
            }
            for (ProProjectSpecReDomain proProjectSpecReDomain : specList) {
                specDomains.add(proProjectSpecReDomain);
            }
            for (ProProjectCskuReDomain proProjectCskuReDomain : cskuList) {
                cskuDomains.add(proProjectCskuReDomain);
            }
            for (ProProjectCustrelReDomain proProjectCustrelReDomain : custrelList) {
                custrelDomains.add(proProjectCustrelReDomain);
            }
            proProjectReDomain.setProProjectSpecDomainList(specDomains);
            proProjectReDomain.setProProjectValueDomainList(valueDomains);
            proProjectReDomain.setProProjectCskuDomainList(cskuDomains);
            proProjectReDomain.setProProjectCustrelDomainList(custrelDomains);
        }
        return proProjectReDomainSupQueryResult;
    }

    @RequestMapping(value={"updateProjectbyprojectCode.json"}, name="\u4fee\u6539\u9879\u76ee-\u9879\u76ee\u5ba2\u6237-\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateProjectbyprojectCode(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveProject", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveProject", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ProProjectDomain proProjectDomain = (ProProjectDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, ProProjectDomain.class);
        if (null == proProjectDomain.getProProjectFileDomainList() || proProjectDomain.getProProjectFileDomainList().size() == 0) {
            this.logger.error(CODE + ".saveProject.fileList", (Object)"fileList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9879\u76ee\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == proProjectDomain.getProProjectSpecDomainList() || proProjectDomain.getProProjectSpecDomainList().size() == 0) {
            this.logger.error(CODE + ".saveProject.specList", (Object)"skuList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9879\u76ee\u89c4\u683c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (ProProjectSpecDomain projectSpec : proProjectDomain.getProProjectSpecDomainList()) {
            projectSpec.setSpecValueBillno(proProjectDomain.getProjectOcode());
        }
        if (null == proProjectDomain.getProProjectValueDomainList() || proProjectDomain.getProProjectValueDomainList().size() == 0) {
            this.logger.error(CODE + ".saveProject.valueList", (Object)"skuList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9879\u76ee\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == proProjectDomain.getProProjectCskuDomainList() || proProjectDomain.getProProjectCskuDomainList().size() == 0) {
            this.logger.error(CODE + ".saveProject.CskuList", (Object)"CskuList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9879\u76ee\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == proProjectDomain.getProProjectCustrelDomainList() || proProjectDomain.getProProjectCustrelDomainList().size() == 0) {
            this.logger.error(CODE + ".saveProject.CustrelList", (Object)"CustrelList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u9879\u76ee\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        proProjectDomain.setTenantCode(this.getTenantCode(request));
        String userinfoCode = userSession.getUserPcode();
        String userCode = userSession.getUserCode();
        String tenantCode = this.getTenantCode(request);
        String json = SupDisUtil.getMap((String)"OrgEmployee-userCode", (String)(userCode + "-" + userinfoCode + "-" + tenantCode));
        proProjectDomain.setCompanyCode(json);
        OrgEmployeeReDomain orgEmployeeReDomain = (OrgEmployeeReDomain)this.orgEmployeeService.queryEmployeePage(this.getQueryMapParam("userinfoCode,tenantCode", userinfoCode, tenantCode)).getList().get(0);
        proProjectDomain.setEmployeeCode(orgEmployeeReDomain.getEmployeeCode());
        proProjectDomain.setEmployeeName(orgEmployeeReDomain.getEmployeeName());
        for (ProProjectValueDomain proProjectValueDomain : proProjectDomain.getProProjectValueDomainList()) {
            proProjectValueDomain.setPropertiesCode(this.createUUIDString());
        }
        proProjectDomain.setProjectOcode(this.createUUIDString());
        this.proProjectService.deleteProjectByCode(this.getTenantCode(request), proProjectDomain.getProjectCode());
        List provalueList = this.proProjectService.queryProjectValuePage(this.getQueryMapParam("projectCode,tenantCode", proProjectDomain.getProjectCode(), tenantCode)).getList();
        List specList = this.proProjectService.queryProjectSpecPage(this.getQueryMapParam("projectCode,tenantCode", proProjectDomain.getProjectCode(), tenantCode)).getList();
        List cskuList = this.proProjectCskuService.queryProjectCskuPage(this.getQueryMapParam("goodsNo,tenantCode", proProjectDomain.getProjectCode(), tenantCode)).getList();
        List custrelList = this.proProjectCustrelService.queryProjectCustrelPage(this.getQueryMapParam("projectCode,tenantCode", proProjectDomain.getProjectCode(), tenantCode)).getList();
        for (ProProjectValueReDomain proProjectValueReDomain : provalueList) {
            this.proProjectService.deleteProjectValue(proProjectValueReDomain.getProjectValueId());
        }
        for (ProProjectSpecReDomain proProjectSpecReDomain : specList) {
            this.proProjectService.deleteProjectSpec(proProjectSpecReDomain.getProjectSpecId());
        }
        for (ProProjectCskuReDomain proProjectCskuReDomain : cskuList) {
            this.proProjectCskuService.deleteProjectCsku(proProjectCskuReDomain.getProjectCskuId());
        }
        for (ProProjectCustrelReDomain proProjectCustrelReDomain : custrelList) {
            this.proProjectCustrelService.deleteProjectCustrel(proProjectCustrelReDomain.getProjectCustrelId());
        }
        HtmlJsonReBean htmlJsonReBean = this.proProjectService.saveProject(proProjectDomain);
        if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess() || null == htmlJsonReBean.getDataObj()) {
            return htmlJsonReBean;
        }
        this.logger.error("111===", (Object)JsonUtil.buildNormalBinder().toJson((Object)htmlJsonReBean.getDataObj().toString()));
        for (ProProjectCustrelDomain proProjectCustrelDomain : proProjectDomain.getProProjectCustrelDomainList()) {
            proProjectCustrelDomain.setProjectCode(htmlJsonReBean.getDataObj().toString());
            proProjectCustrelDomain.setProjectName(proProjectDomain.getProjectName());
            proProjectCustrelDomain.setProjectOcode(proProjectDomain.getProjectOcode());
            proProjectCustrelDomain.setCompanyCode(proProjectDomain.getCompanyCode());
            proProjectCustrelDomain.setCustrelCode(proProjectDomain.getCustrelCode());
            proProjectCustrelDomain.setCustrelName(proProjectDomain.getCustrelName());
            proProjectCustrelDomain.setTenantCode(this.getTenantCode(request));
        }
        this.proProjectCustrelService.saveProjectCustrelBatch(proProjectDomain.getProProjectCustrelDomainList());
        for (ProProjectCskuDomain proProjectCskuDomain : proProjectDomain.getProProjectCskuDomainList()) {
            proProjectCskuDomain.setCustrelCode(proProjectDomain.getCustrelCode());
            proProjectCskuDomain.setCustrelName(proProjectDomain.getCustrelName());
            proProjectCskuDomain.setCompanyCode(proProjectDomain.getCompanyCode());
            proProjectCskuDomain.setTenantCode(this.getTenantCode(request));
            proProjectCskuDomain.setGoodsNo(htmlJsonReBean.getDataObj().toString());
        }
        return this.proProjectCskuService.saveProjectCskuBatch(proProjectDomain.getProProjectCskuDomainList());
    }
}

