/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.rec;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.rec.RecRecruitEnrollDomain;
import cn.com.qj.bff.domain.rec.RecRecruitPersonnelReDomain;
import cn.com.qj.bff.domain.rec.RecRecruitReDomain;
import cn.com.qj.bff.domain.rec.RecRecruitServiceAreaReDomain;
import cn.com.qj.bff.domain.um.UmQualityQtypeReDomain;
import cn.com.qj.bff.service.rec.RecRecruitEnrollService;
import cn.com.qj.bff.service.rec.RecRecruitFileService;
import cn.com.qj.bff.service.rec.RecRecruitOtherService;
import cn.com.qj.bff.service.rec.RecRecruitPersonnelService;
import cn.com.qj.bff.service.rec.RecRecruitService;
import cn.com.qj.bff.service.rec.RecRecruitServiceAreaService;
import cn.com.qj.bff.service.um.UmQualityQtypeService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rec/recruit"}, name="\u62db\u52df\u670d\u52a1")
public class RecruitCon
extends SpringmvcController {
    private static String CODE = "rec.recruit.con";
    @Autowired
    private RecRecruitService recRecruitService;
    @Autowired
    private RecRecruitEnrollService recRecruitEnrollService;
    @Autowired
    private RecRecruitOtherService recRecruitOtherService;
    @Autowired
    private RecRecruitFileService recRecruitFileService;
    @Autowired
    private RecRecruitPersonnelService recRecruitPersonnelService;
    @Autowired
    private RecRecruitServiceAreaService recRecruitServiceAreaService;
    @Autowired
    private UmQualityQtypeService umQualityQtypeService;

    @Override
    protected String getContext() {
        return "recruit";
    }

    @RequestMapping(value={"saveRecruit.json"}, name="\u589e\u52a0\u62db\u52df\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveRecruit(HttpServletRequest request, String paramStr) {
        UserSession userSession;
        this.logger.error("saveRecruit----------------------------------paramStr------------------------------" + paramStr);
        if (null == paramStr) {
            this.logger.error(CODE + ".saveRecruit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RecRecruitReDomain recRecruitReDomain = (RecRecruitReDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, RecRecruitReDomain.class);
        if (null == recRecruitReDomain) {
            this.logger.error(CODE + ".recRecruitReDomain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if ("02".equals(recRecruitReDomain.getRecruitType()) && (recRecruitReDomain.getRecRecruitPersonnelList() == null || recRecruitReDomain.getRecRecruitPersonnelList().size() < 3)) {
            this.logger.error(CODE + ".recRecruitReDomain", (Object)"recRecruitPersonnelList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u73ed\u7ec4\u7684\u521b\u5efa\u4e0d\u5f97\u5c11\u4e8e3\u4e2a\u4eba\uff01");
        }
        if (null != recRecruitReDomain) {
            recRecruitReDomain.setTenantCode(this.getTenantCode(request));
        }
        if (null != (userSession = this.getUserSession(request))) {
            recRecruitReDomain.setMemberBname(userSession.getUserName());
            recRecruitReDomain.setMemberBcode(userSession.getUserCode());
        }
        return this.recRecruitService.saveRecruit(recRecruitReDomain);
    }

    @RequestMapping(value={"getRecruit.json"}, name="\u83b7\u53d6\u62db\u52df\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public RecRecruitReDomain getRecruit(HttpServletRequest request, Integer recruitId) {
        if (StringUtils.isBlank((Integer)recruitId)) {
            this.logger.error(CODE + ".getRecruit", (Object)"param is null");
            return null;
        }
        RecRecruitReDomain recRecruitReDomain = this.recRecruitService.getRecruit(recruitId);
        List recRecruitEnrollDomainList = null;
        List recRecruitFileDomainList = null;
        List recRecruitOtherReDomainList = null;
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> map = null;
        if (null != recRecruitReDomain && StringUtils.isNotBlank((String)recRecruitReDomain.getRecruitCode())) {
            map = new HashMap<String, Object>();
            map.put("tenantCode", tenantCode);
            map.put("recruitCode", recRecruitReDomain.getRecruitCode());
            recRecruitEnrollDomainList = this.recRecruitEnrollService.queryRecruitEnrollPage(map).getList();
            recRecruitReDomain.setRecRecruitEnrollList(recRecruitEnrollDomainList);
            recRecruitFileDomainList = this.recRecruitFileService.queryRecruitFilePage(map).getList();
            recRecruitReDomain.setRecRecruitFileDomainList(recRecruitFileDomainList);
            recRecruitOtherReDomainList = this.recRecruitOtherService.queryRecruitOtherPage(map).getList();
            recRecruitReDomain.setRecRecruitOtherDomainList(recRecruitOtherReDomainList);
            System.out.println("recRecruitReDomain.getRecruitType------------------------888889----------------------------" + recRecruitReDomain.getRecruitType());
            if (StringUtils.isNotBlank((String)recRecruitReDomain.getRecruitType()) && recRecruitReDomain.getRecruitType().equals("02")) {
                SupQueryResult<RecRecruitPersonnelReDomain> supQueryResult = this.recRecruitPersonnelService.queryRecRecruitPersonnelPage(map);
                List recRecruitPersonnelReDomainList = null;
                System.out.println("supQueryResult.getList------------------------88888889---------------------------------" + supQueryResult.getList());
                if (ListUtil.isNotEmpty((Collection)supQueryResult.getList())) {
                    recRecruitPersonnelReDomainList = supQueryResult.getList();
                    for (int i = 0; i < recRecruitPersonnelReDomainList.size(); ++i) {
                        HashMap<String, Object> map0 = new HashMap<String, Object>();
                        map0.put("tenantCode", tenantCode);
                        map0.put("memberCode", ((RecRecruitPersonnelReDomain)recRecruitPersonnelReDomainList.get(i)).getMemberCode());
                        SupQueryResult<RecRecruitServiceAreaReDomain> supQueryResult0 = this.recRecruitServiceAreaService.queryRecRecruitServiceAreaPage(map0);
                        ((RecRecruitPersonnelReDomain)recRecruitPersonnelReDomainList.get(i)).setRecRecruitServiceAreaReDomainList(supQueryResult0.getList());
                    }
                }
                recRecruitReDomain.setRecRecruitPersonnelList(recRecruitPersonnelReDomainList);
            }
        }
        return recRecruitReDomain;
    }

    @RequestMapping(value={"updateRecruit.json"}, name="\u66f4\u65b0\u62db\u52df\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateRecruit(HttpServletRequest request, String paramStr) {
        RecRecruitReDomain recRecruitReDomain = (RecRecruitReDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, RecRecruitReDomain.class);
        if (null == recRecruitReDomain) {
            this.logger.error(CODE + ".updateRecruit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        recRecruitReDomain.setTenantCode(this.getTenantCode(request));
        return this.recRecruitService.updateRecruit(recRecruitReDomain);
    }

    @RequestMapping(value={"deleteRecruit.json"}, name="\u5220\u9664\u62db\u52df\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteRecruit(Integer recruitId) {
        if (StringUtils.isBlank((Integer)recruitId)) {
            this.logger.error(CODE + ".deleteRecruit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.recRecruitService.deleteRecruit(recruitId);
    }

    @RequestMapping(value={"queryRecruitPage.json"}, name="\u67e5\u8be2\u62db\u52df\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RecRecruitReDomain> queryRecruitPage(HttpServletRequest request, String qualityQtypeCode) {
        UserSession userSession = this.getUserSession(request);
        Map<String, Object> param = this.assemMapParam(request);
        String map = param.toString();
        String type = request.getParameter("type");
        StringBuffer childList = new StringBuffer();
        if (qualityQtypeCode != null && StringUtils.isNotBlank((String)qualityQtypeCode)) {
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("qualityQtypePcode", qualityQtypeCode);
            map1.put("tenantCode", this.getTenantCode(request));
            SupQueryResult<UmQualityQtypeReDomain> UmQualityQtype = this.umQualityQtypeService.queryQualityQtypePage(map1);
            if (UmQualityQtype == null || ListUtil.isEmpty((Collection)UmQualityQtype.getList())) {
                return new SupQueryResult();
            }
            for (UmQualityQtypeReDomain q : UmQualityQtype.getList()) {
                childList.append(q.getQualityQtypeCode() + ",");
            }
        }
        if (null != param) {
            if (StringUtils.isNotBlank((String)type) && "2".equals(type)) {
                param.put("memberBcode", userSession.getUserCode());
            }
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("orderStr", "GMT_CREATE desc");
            param.put("tenantCode", this.getTenantCode(request));
            if (childList != null) {
                param.put("qualityQtypeCode", childList);
            }
        }
        SupQueryResult<RecRecruitReDomain> supQueryResult = this.recRecruitService.queryRecruitPage(param);
        List list = supQueryResult.getList();
        for (int i = 0; i < list.size(); ++i) {
            HashMap<String, Object> mapParm = new HashMap<String, Object>();
            mapParm.put("fuzzy", true);
            mapParm.put("tenantCode", ((RecRecruitReDomain)list.get(i)).getTenantCode());
            mapParm.put("recruitCode", ((RecRecruitReDomain)list.get(i)).getRecruitCode());
            List enrollList = this.recRecruitEnrollService.queryRecruitEnrollPage(mapParm).getList();
            ((RecRecruitReDomain)list.get(i)).setRecruitEnrollCount(enrollList.size());
            this.logger.error("controller----------------------------\u62a5\u540d\u6570\u91cfcount-----------------------" + ((RecRecruitReDomain)list.get(i)).getRecruitEnrollCount());
            int count = 0;
            for (RecRecruitEnrollDomain rr : enrollList) {
                if (null == rr.getDataState() || rr.getDataState() != 1) continue;
                ++count;
            }
            ((RecRecruitReDomain)list.get(i)).setRecruitEnrollQstate(count);
            this.logger.error("controller----------------------------\u5ba1\u6838\u901a\u8fc7count-----------------------" + count);
        }
        supQueryResult.setList(list);
        return supQueryResult;
    }

    @RequestMapping(value={"updateRecruitState.json"}, name="\u66f4\u65b0\u62db\u52df\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateRecruitState(String recruitId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)recruitId)) {
            this.logger.error(CODE + ".updateRecruitState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.recRecruitService.updateRecruitState(Integer.valueOf(recruitId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryCountByState.json"}, name="\u62db\u52df\u5217\u8868\u7684\u7edf\u8ba1\u6570\u636e")
    @ResponseBody
    public HtmlJsonReBean queryCountByState(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        String recruitType = request.getParameter("recruitType");
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".queryCountByState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        int dataState = 0;
        return this.recRecruitService.queryCountByState(tenantCode, dataState);
    }

    @RequestMapping(value={"queryCountByState1.json"}, name="\u62db\u52df\u5217\u8868\u7684\u7edf\u8ba1\u6570\u636e1")
    @ResponseBody
    public HtmlJsonReBean queryCountByState1(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        String recruitType = request.getParameter("recruitType");
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".queryCountByState1", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        int dataState = 0;
        return this.recRecruitService.queryCountByState1(tenantCode, dataState, recruitType, userSession.getUserCode());
    }
}

