/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.um;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.bs.BsAreaReDomain;
import cn.com.qj.bff.domain.bs.BsProvinceReDomain;
import cn.com.qj.bff.domain.bs.BsRoadReDomain;
import cn.com.qj.bff.domain.dis.UmUserinfo;
import cn.com.qj.bff.domain.um.AmAddress;
import cn.com.qj.bff.domain.um.UmAddressDomain;
import cn.com.qj.bff.domain.um.UmAddressReDomain;
import cn.com.qj.bff.service.bs.BsAreaService;
import cn.com.qj.bff.service.bs.BsProvinceService;
import cn.com.qj.bff.service.bs.BsRoadService;
import cn.com.qj.bff.service.um.UmAddressService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/um/address"}, name="\u7528\u6237\u5730\u5740\u4fe1\u606f")
public class AddressCon
extends SpringmvcController {
    private static String CODE = "um.address.con";
    @Autowired
    UmAddressService umAddressService;
    @Autowired
    BsRoadService bsRoadService;
    @Autowired
    BsProvinceService bsProvinceService;
    @Autowired
    BsAreaService bsAreaService;
    public static final String PHONE_ENUM = "****";

    @Override
    protected String getContext() {
        return "address";
    }

    @RequestMapping(value={"saveAddress.json"}, name="\u589e\u52a0\u7528\u6237\u5730\u5740\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveAddress(HttpServletRequest request, UmAddressDomain umAddressDomain) {
        if (null == umAddressDomain) {
            this.logger.error(CODE + ".saveAddress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveAddress", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        umAddressDomain.setUserCode(userSession.getUserPcode());
        umAddressDomain.setUserName(userSession.getMerberCompname());
        umAddressDomain.setTenantCode(this.getTenantCode(request));
        return this.umAddressService.saveAddress(umAddressDomain);
    }

    @RequestMapping(value={"getAddress.json"}, name="\u83b7\u53d6\u7528\u6237\u5730\u5740\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public UmAddressReDomain getAddress(HttpServletRequest request, Integer addressId) {
        if (StringUtils.isBlank((Integer)addressId)) {
            this.logger.error(CODE + ".getAddress", (Object)"param is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveAddress", (Object)"UserSession is null");
            return null;
        }
        UmAddressReDomain umAddressReDomain = this.umAddressService.getAddress(addressId);
        if (null == umAddressReDomain) {
            return null;
        }
        if (!umAddressReDomain.getUserCode().equals(userSession.getUserPcode())) {
            return null;
        }
        return umAddressReDomain;
    }

    @RequestMapping(value={"updateAddress.json"}, name="\u66f4\u65b0\u7528\u6237\u5730\u5740\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateAddress(HttpServletRequest request, UmAddressDomain umAddressDomain) {
        if (null == umAddressDomain) {
            this.logger.error(CODE + ".updateAddress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateAddress", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UmAddressReDomain address = this.umAddressService.getAddress(umAddressDomain.getAddressId());
        if (null == address || !address.getUserCode().equals(userSession.getUserPcode())) {
            this.logger.error(CODE + ".updateAddress", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        umAddressDomain.setUserCode(userSession.getUserPcode());
        umAddressDomain.setUserName(userSession.getMerberCompname());
        umAddressDomain.setTenantCode(this.getTenantCode(request));
        return this.umAddressService.updateAddress(umAddressDomain);
    }

    @RequestMapping(value={"deleteAddress.json"}, name="\u5220\u9664\u7528\u6237\u5730\u5740\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteAddress(HttpServletRequest request, Integer addressId) {
        if (StringUtils.isBlank((Integer)addressId)) {
            this.logger.error(CODE + ".deleteAddress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveAddress", (Object)"UserSession is null");
            return null;
        }
        UmAddressReDomain umAddressReDomain = this.umAddressService.getAddress(addressId);
        if (null == umAddressReDomain) {
            return null;
        }
        if (!umAddressReDomain.getUserCode().equals(userSession.getUserPcode())) {
            this.logger.error(CODE + ".deleteAddress", (Object)"getUserCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5f02\u5e38\u64cd\u4f5c");
        }
        return this.umAddressService.deleteAddress(addressId);
    }

    @RequestMapping(value={"queryAddressPage.json"}, name="\u67e5\u8be2\u7528\u6237\u5730\u5740\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UmAddressReDomain> queryAddressPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.umAddressService.queryAddressPage(param);
    }

    @RequestMapping(value={"updateAddressState.json"}, name="\u66f4\u65b0\u7528\u6237\u5730\u5740\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAddressState(String addressId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)addressId)) {
            this.logger.error(CODE + ".updateAddressState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.umAddressService.updateAddressState(Integer.valueOf(addressId), dataState, oldDataState);
    }

    @RequestMapping(value={"updateAddressDefault.json"}, name="\u66f4\u65b0\u7528\u6237\u9ed8\u8ba4\u5730\u5740")
    @ResponseBody
    public HtmlJsonReBean updateAddressDefault(HttpServletRequest request, String addressCode) {
        if (StringUtils.isBlank((String)addressCode)) {
            this.logger.error(CODE + ".updateAddressDefault", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateAddressDefault", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.umAddressService.updateAddressDefault(userSession.getUserPcode(), addressCode, this.getTenantCode(request));
    }

    @RequestMapping(value={"getDefAddress.json"}, name="\u83b7\u53d6\u7528\u6237\u9ed8\u8ba4\u5730\u5740\u4fe1\u606f")
    @ResponseBody
    public UmAddressReDomain getDefAddress(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".getDefAddress", (Object)"UserSession is null");
            return null;
        }
        return this.umAddressService.getDefAddressBymerberCode(userSession.getUserPcode(), this.getTenantCode(request));
    }

    @RequestMapping(value={"queryAddressBymerberCode.json"}, name="\u83b7\u53d6\u7528\u6237\u5730\u5740\u5217\u8868")
    @ResponseBody
    public List<UmAddressReDomain> queryAddressBymerberCode(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryAddressBymerberCode", (Object)"UserSession is null");
            return null;
        }
        return this.umAddressService.queryAddressBymerberCode(userSession.getUserPcode(), this.getTenantCode(request));
    }

    @RequestMapping(value={"saveAddressByUser.json"}, name="\u589e\u52a0\u7528\u6237\u5730\u5740\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveAddressByUser(HttpServletRequest request, UmAddressDomain umAddressDomain) {
        if (null == umAddressDomain) {
            this.logger.error(CODE + ".saveAddress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveAddress", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        String msg = this.msg(tenantCode, umAddressDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, msg);
        }
        umAddressDomain.setUserCode(userSession.getUserPcode());
        umAddressDomain.setUserName(userSession.getMerberCompname());
        umAddressDomain.setTenantCode(tenantCode);
        return this.umAddressService.saveAddress(umAddressDomain);
    }

    @RequestMapping(value={"updateAddressByUser.json"}, name="\u66f4\u65b0\u7528\u6237\u5730\u5740\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateAddressByUser(HttpServletRequest request, UmAddressDomain umAddressDomain) {
        String tenantCode;
        String msg;
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".msg", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "UserSession is null");
        }
        UmAddressReDomain address = this.umAddressService.getAddress(umAddressDomain.getAddressId());
        if (null == address || !address.getUserCode().equals(userSession.getUserPcode())) {
            this.logger.error(CODE + ".msg.address", (Object)JsonUtil.buildNormalBinder().toJson((Object)umAddressDomain));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef");
        }
        if (address.getAddressPhone().contains("*")) {
            umAddressDomain.setAddressPhone(address.getAddressPhone());
        }
        if (StringUtils.isNotBlank((String)(msg = this.msg(tenantCode = this.getTenantCode(request), umAddressDomain)))) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, msg);
        }
        umAddressDomain.setUserCode(userSession.getUserPcode());
        umAddressDomain.setUserName(userSession.getMerberCompname());
        umAddressDomain.setTenantCode(tenantCode);
        return this.umAddressService.updateAddress(umAddressDomain);
    }

    private String msg(String tenantCode, UmAddressDomain umAddressDomain) {
        if (null == umAddressDomain) {
            this.logger.error(CODE + ".msg", (Object)"param is null");
            return "\u53c2\u6570\u4e3a\u7a7a\uff01";
        }
        if (StringUtils.isEmpty((String)umAddressDomain.getProvinceCode()) || StringUtils.isEmpty((String)umAddressDomain.getAddressPhone()) || StringUtils.isEmpty((String)umAddressDomain.getAreaCode()) || StringUtils.isEmpty((String)umAddressDomain.getCityCode())) {
            this.logger.error(CODE + ".msg.umAddressDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)umAddressDomain));
            return "\u53c2\u6570\u9519\u8bef\uff01";
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", tenantCode);
        param.put("provinceCode", umAddressDomain.getProvinceCode());
        param.put("provinceName", umAddressDomain.getProvinceName());
        SupQueryResult<BsProvinceReDomain> bsProvinceQueryResult = this.queryProvincePage(param);
        if (null == bsProvinceQueryResult || ListUtil.isEmpty((Collection)bsProvinceQueryResult.getList())) {
            this.logger.error(CODE + ".msg.bsProvinceQueryResult", (Object)JsonUtil.buildNormalBinder().toJson((Object)umAddressDomain));
            return "\u7701\u4efd\u9519\u8bef\uff01";
        }
        param = new HashMap();
        param.put("tenantCode", tenantCode);
        param.put("areaCode", umAddressDomain.getCityCode());
        param.put("areaName", umAddressDomain.getCityName());
        param.put("provinceCode", umAddressDomain.getProvinceCode());
        SupQueryResult<BsAreaReDomain> bsAreaQueryResult = this.queryAreaPage(param);
        if (null == bsAreaQueryResult || ListUtil.isEmpty((Collection)bsAreaQueryResult.getList())) {
            this.logger.error(CODE + ".msg.bsProvinceQueryResult", (Object)JsonUtil.buildNormalBinder().toJson((Object)umAddressDomain));
            return "\u5e02\u9519\u8bef\uff01";
        }
        param = new HashMap();
        param.put("tenantCode", tenantCode);
        param.put("areaParentCode", umAddressDomain.getCityCode());
        param.put("areaCode", umAddressDomain.getAreaCode());
        param.put("areaName", umAddressDomain.getAreaName());
        bsAreaQueryResult = this.queryAreaPage(param);
        if (null == bsAreaQueryResult || ListUtil.isEmpty((Collection)bsAreaQueryResult.getList())) {
            this.logger.error(CODE + ".msg.bsAreaQueryResult", (Object)JsonUtil.buildNormalBinder().toJson((Object)umAddressDomain));
            return "\u533a\u9519\u8bef\uff01";
        }
        if (StringUtils.isEmpty((String)umAddressDomain.getRoadCode())) {
            return null;
        }
        param = new HashMap();
        param.put("tenantCode", tenantCode);
        param.put("areaCode", umAddressDomain.getAreaCode());
        param.put("roadCode", umAddressDomain.getRoadCode());
        param.put("roadName", umAddressDomain.getRoadName());
        SupQueryResult<BsRoadReDomain> queryResult = this.queryRoadPage(param);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error(CODE + ".msg.bsAreaQueryResult", (Object)JsonUtil.buildNormalBinder().toJson((Object)umAddressDomain));
            return "\u8857\u9053\u9519\u8bef\uff01";
        }
        return null;
    }

    public SupQueryResult<BsRoadReDomain> queryRoadPage(Map<String, Object> param) {
        SupQueryResult<BsRoadReDomain> qest = this.bsRoadService.queryRoadPage(param);
        if (null == qest || ListUtil.isEmpty((Collection)qest.getList())) {
            param.put("tenantCode", "00000000");
        }
        return this.bsRoadService.queryRoadPage(param);
    }

    public SupQueryResult<BsProvinceReDomain> queryProvincePage(Map<String, Object> param) {
        SupQueryResult<BsProvinceReDomain> qest = this.bsProvinceService.queryProvincePage(param);
        if (null == qest || ListUtil.isEmpty((Collection)qest.getList())) {
            param.put("tenantCode", "00000000");
            qest = this.bsProvinceService.queryProvincePage(param);
        }
        return qest;
    }

    public SupQueryResult<BsAreaReDomain> queryAreaPage(Map<String, Object> param) {
        SupQueryResult<BsAreaReDomain> qest;
        if (null == param.get("areaParentCode")) {
            param.put("areaParentCode", "-1");
        }
        if (null == (qest = this.bsAreaService.queryAreaPage(param)) || ListUtil.isEmpty((Collection)qest.getList())) {
            param.put("tenantCode", "00000000");
            qest = this.bsAreaService.queryAreaPage(param);
        }
        if (null == qest || ListUtil.isEmpty((Collection)qest.getList())) {
            param.remove("tenantCode");
            qest = this.bsAreaService.queryAreaPage(param);
        }
        if (null == qest || ListUtil.isEmpty((Collection)qest.getList())) {
            param.remove("tenantCode");
            param.remove("areaParentCode");
            qest = this.bsAreaService.queryAreaPage(param);
        }
        return qest;
    }

    @RequestMapping(value={"queryAddressBymerberCodeB.json"}, name="\u83b7\u53d6\u7528\u6237\u5730\u5740\u5217\u8868")
    @ResponseBody
    public List<UmAddressReDomain> queryAddressBymerberCodeB(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryAddressBymerberCode", (Object)"UserSession is null");
            return null;
        }
        List<UmAddressReDomain> domainList = this.umAddressService.queryAddressBymerberCode(userSession.getUserPcode(), this.getTenantCode(request));
        for (UmAddressReDomain addressReDomain : domainList) {
            String addressPhone = addressReDomain.getAddressPhone();
            String phone = this.phoneHiderule(addressPhone);
            addressReDomain.setAddressPhone(phone);
        }
        return domainList;
    }

    @RequestMapping(value={"getAddressByUser.json"}, name="\u83b7\u53d6\u7528\u6237\u5730\u5740\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public UmAddressReDomain getAddressByUser(HttpServletRequest request, Integer addressId) {
        if (StringUtils.isBlank((Integer)addressId)) {
            this.logger.error(CODE + ".getAddress", (Object)"param is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveAddress", (Object)"UserSession is null");
            return null;
        }
        UmAddressReDomain umAddressReDomain = this.umAddressService.getAddress(addressId);
        if (null == umAddressReDomain) {
            return null;
        }
        if (!umAddressReDomain.getUserCode().equals(userSession.getUserPcode())) {
            return null;
        }
        String phone = this.phoneHiderule(umAddressReDomain.getAddressPhone());
        umAddressReDomain.setAddressPhone(phone);
        return umAddressReDomain;
    }

    public String phoneHiderule(String primary) {
        if (StringUtils.isEmpty((String)primary) || primary.length() != 11) {
            this.logger.error("==phoneHiderule===", (Object)("\u624b\u673a\u53f7\u5f02\u5e38===========" + primary));
            return primary;
        }
        String sub1 = String.valueOf(primary).substring(0, 3);
        String sub2 = String.valueOf(primary).substring(7, 11);
        return sub1 + PHONE_ENUM + sub2;
    }

    @RequestMapping(value={"queryAddressForUser.json"}, name="\u83b7\u53d6\u7528\u6237\u5730\u5740\u5217\u8868")
    @ResponseBody
    public List<UmAddressReDomain> queryAddressForUser(HttpServletRequest request, String userinfoCode) {
        if (StringUtils.isBlank((String)userinfoCode)) {
            return null;
        }
        return this.umAddressService.queryAddressBymerberCode(userinfoCode, this.getTenantCode(request));
    }

    @RequestMapping(value={"saveAddressForUser.json"}, name="\u589e\u52a0\u7528\u6237\u5730\u5740\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveAddressForUser(HttpServletRequest request, UmAddressDomain umAddressDomain) {
        if (null == umAddressDomain) {
            this.logger.error(CODE + ".saveAddress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveAddressForUser", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (StringUtils.isBlank((String)umAddressDomain.getUserCode())) {
            umAddressDomain.setUserCode(userSession.getUserPcode());
            umAddressDomain.setUserName(userSession.getMerberCompname());
        }
        umAddressDomain.setTenantCode(this.getTenantCode(request));
        return this.umAddressService.saveAddress(umAddressDomain);
    }

    @RequestMapping(value={"queryAmUserAddressByCode.json"}, name="\u83b7\u53d6\u7528\u6237\u5730\u5740\u5217\u8868(AM)")
    @ResponseBody
    public List<AmAddress> queryAmUserAddressByCode(HttpServletRequest request, String userinfoCode) {
        return this.umAddressService.queryAmUserAddressByCode(this.getUserSession(request).getUserPcode(), this.getTenantCode(request));
    }

    @RequestMapping(value={"updateAmUserAddressByCode.json"}, name="\u66f4\u65b0\u7528\u6237\u5730\u5740\u5217\u8868(AM)")
    @ResponseBody
    public HtmlJsonReBean updateAmUserAddressByCode(HttpServletRequest request, String userinfoCode, String amAddressesStr) {
        List amAddresses = JsonUtil.buildNonDefaultBinder().getJsonToList(amAddressesStr, AmAddress.class);
        if (ListUtil.isEmpty((Collection)amAddresses)) {
            this.logger.error(CODE + ".amAddresses", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u683c\u5f0f\u9519\u8bef");
        }
        return this.umAddressService.updateAmUserAddressByCode(this.getUserSession(request).getUserPcode(), this.getTenantCode(request), amAddresses);
    }

    @RequestMapping(value={"getAmUserByCode.json"}, name="\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f(AM)")
    @ResponseBody
    public UmUserinfo getAmUserByCode(HttpServletRequest request, String userinfoCode) {
        return this.umAddressService.getAmUserByCode(this.getUserSession(request).getUserPcode(), this.getTenantCode(request));
    }

    @RequestMapping(value={"queryUserAddressByCode.json"}, name="\u83b7\u53d6\u7528\u6237\u5730\u5740\u5217\u8868(address)")
    @ResponseBody
    public List<AmAddress> queryUserAddressByCode(HttpServletRequest request, String addressCode, String addressType) {
        return this.umAddressService.queryUserAddressByCode(this.getUserSession(request).getUserPcode(), this.getTenantCode(request), addressCode, addressType);
    }

    @RequestMapping(value={"updateUserAddressByCode.json"}, name="\u66f4\u65b0\u7528\u6237\u5730\u5740\u5217\u8868(address)")
    @ResponseBody
    public HtmlJsonReBean updateUserAddressByCode(HttpServletRequest request, String amAddressesStr) {
        List amAddresses = JsonUtil.buildNonDefaultBinder().getJsonToList(amAddressesStr, AmAddress.class);
        if (ListUtil.isEmpty((Collection)amAddresses)) {
            this.logger.error(CODE + ".amAddresses", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u683c\u5f0f\u9519\u8bef");
        }
        return this.umAddressService.updateUserAddressByCode(this.getUserSession(request).getUserPcode(), this.getTenantCode(request), amAddresses);
    }

    @RequestMapping(value={"deleteUserAddressByCode.json"}, name="\u751f\u4ea7\u5730\u5740\u5217\u8868(address)")
    @ResponseBody
    public HtmlJsonReBean deleteUserAddressByCode(HttpServletRequest request, String amAddressesStr) {
        List amAddresses = JsonUtil.buildNonDefaultBinder().getJsonToList(amAddressesStr, AmAddress.class);
        if (ListUtil.isEmpty((Collection)amAddresses)) {
            this.logger.error(CODE + ".amAddresses", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u683c\u5f0f\u9519\u8bef");
        }
        return this.umAddressService.deleteUserAddressByCode(this.getUserSession(request).getUserPcode(), this.getTenantCode(request), amAddresses);
    }

    @RequestMapping(value={"saveUserAddressByCode.json"}, name="\u65b0\u589e\u5730\u5740\u5217\u8868(address)")
    @ResponseBody
    public HtmlJsonReBean saveUserAddressByCode(HttpServletRequest request, String amAddressesStr) {
        List amAddresses = JsonUtil.buildNonDefaultBinder().getJsonToList(amAddressesStr, AmAddress.class);
        if (ListUtil.isEmpty((Collection)amAddresses)) {
            this.logger.error(CODE + ".amAddresses", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u683c\u5f0f\u9519\u8bef");
        }
        return this.umAddressService.saveUserAddressByCode(this.getUserSession(request).getUserPcode(), this.getTenantCode(request), amAddresses);
    }
}

