/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.express;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.wl.WlExporgDomain;
import cn.com.qj.bff.domain.wl.WlExporgReDomain;
import cn.com.qj.bff.service.wl.WlExporgService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/wl/exporg"}, name="\u7269\u6d41\u63a5\u53e3\u670d\u52a1")
public class ExporgCon
extends SpringmvcController {
    private static String CODE = "wl.exporg.con";
    @Autowired
    private WlExporgService wlExporgService;

    @Override
    protected String getContext() {
        return "exporg";
    }

    @RequestMapping(value={"saveExporg.json"}, name="\u589e\u52a0\u7269\u6d41\u63a5\u53e3\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveExporg(HttpServletRequest request, WlExporgDomain wlExporgDomain) {
        if (null == wlExporgDomain) {
            this.logger.error(CODE + ".saveExporg", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        wlExporgDomain.setTenantCode(this.getTenantCode(request));
        return this.wlExporgService.saveExporg(wlExporgDomain);
    }

    @RequestMapping(value={"getExporg.json"}, name="\u83b7\u53d6\u7269\u6d41\u63a5\u53e3\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public WlExporgReDomain getExporg(Integer exporgId) {
        if (StringUtils.isBlank((Integer)exporgId)) {
            this.logger.error(CODE + ".getExporg", (Object)"param is null");
            return null;
        }
        return this.wlExporgService.getExporg(exporgId);
    }

    @RequestMapping(value={"updateExporg.json"}, name="\u66f4\u65b0\u7269\u6d41\u63a5\u53e3\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateExporg(HttpServletRequest request, WlExporgDomain wlExporgDomain) {
        if (null == wlExporgDomain) {
            this.logger.error(CODE + ".updateExporg", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        wlExporgDomain.setTenantCode(this.getTenantCode(request));
        return this.wlExporgService.updateExporg(wlExporgDomain);
    }

    @RequestMapping(value={"deleteExporg.json"}, name="\u5220\u9664\u7269\u6d41\u63a5\u53e3\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteExporg(Integer exporgId) {
        if (StringUtils.isBlank((Integer)exporgId)) {
            this.logger.error(CODE + ".deleteExporg", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.wlExporgService.deleteExporg(exporgId);
    }

    @RequestMapping(value={"queryExpressInfo.json"}, name="\u67e5\u8be2\u7269\u6d41\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean queryExpressInfo(HttpServletRequest request, String expressType, String expressNo) {
        return this.queryExpInfo(request, expressType, expressNo);
    }

    @RequestMapping(value={"queryExpressInfoForC.json"}, name="\u67e5\u8be2\u7269\u6d41\u4fe1\u606f-C\u7aef")
    @ResponseBody
    public HtmlJsonReBean queryExpressInfoForC(HttpServletRequest request, String expressType, String expressNo) {
        return this.queryExpInfo(request, expressType, expressNo);
    }

    private HtmlJsonReBean queryExpInfo(HttpServletRequest request, String expressType, String expressNo) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.wlExporgService.queryExpInfo(expressType, expressNo, this.getTenantCode(request));
    }

    @RequestMapping(value={"updateExporgState.json"}, name="\u66f4\u65b0\u7269\u6d41\u63a5\u53e3\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateExporgState(String exporgId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)exporgId)) {
            this.logger.error(CODE + ".updateExporgState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.wlExporgService.updateExporgState(Integer.valueOf(exporgId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryExporgPage.json"}, name="\u67e5\u8be2\u7269\u6d41\u63a5\u53e3\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<WlExporgReDomain> queryExporgPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.wlExporgService.queryExporgPage(param);
    }
}

