/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.resources;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.rs.RsSkuOneDomain;
import cn.com.qj.bff.domain.rs.RsSkuOneReDomain;
import cn.com.qj.bff.domain.rs.RsSkuOnelistReDomain;
import cn.com.qj.bff.service.rs.RsSkuOneService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/skuOne"}, name="\u5546\u54c1\u8d77\u8ba2\u91cf\u8bbe\u7f6e")
public class SkuOneCon
extends SpringmvcController {
    private static String CODE = "rs.skuOne.con";
    @Autowired
    private RsSkuOneService rsSkuOneService;

    @Override
    protected String getContext() {
        return "skuOne";
    }

    @RequestMapping(value={"checkSkuOne.json"}, name="\u68c0\u67e5\u5546\u54c1\u8d77\u5b9a\u91cf")
    @ResponseBody
    public HtmlJsonReBean checkSkuOne(HttpServletRequest request, String rsSkuDomainListJson) {
        if (null == rsSkuDomainListJson) {
            this.logger.error(CODE + ".rsSkuDomainListJson", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        return this.rsSkuOneService.makeSkuOnebySku(rsSkuDomainListJson, userSession, this.getNowChannel(request), this.getTenantCode(request));
    }

    @RequestMapping(value={"saveSkuOne.json"}, name="\u589e\u52a0\u5546\u54c1\u8d77\u8ba2\u91cf\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean saveSkuOne(HttpServletRequest request, String rsSkuOneDomainJson) {
        if (null == rsSkuOneDomainJson) {
            this.logger.error(CODE + ".saveSkuOne", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RsSkuOneDomain rsSkuOneDomain = (RsSkuOneDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsSkuOneDomainJson, RsSkuOneDomain.class);
        rsSkuOneDomain.setTenantCode(this.getTenantCode(request));
        return this.rsSkuOneService.saveSkuOne(rsSkuOneDomain);
    }

    @RequestMapping(value={"saveOrUpdateSkuOneAndSkuOneList.json"}, name="\u589e\u52a0\u5546\u54c1\u8d77\u8ba2\u91cf\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean saveOrUpdateSkuOneAndSkuOneList(HttpServletRequest request, String rsSkuOneDomainJson) {
        if (null == rsSkuOneDomainJson) {
            this.logger.error(CODE + ".saveSkuOne", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RsSkuOneDomain rsSkuOneDomain = (RsSkuOneDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsSkuOneDomainJson, RsSkuOneDomain.class);
        rsSkuOneDomain.setTenantCode(this.getTenantCode(request));
        return this.rsSkuOneService.saveOrUpdateSkuOneAndSkuOneList(rsSkuOneDomain);
    }

    @RequestMapping(value={"getSkuOneByCode.json"}, name="\u83b7\u53d6\u5546\u54c1\u8d77\u8ba2\u91cf\u8bbe\u7f6e\u4fe1\u606f")
    @ResponseBody
    public RsSkuOneReDomain getSkuOne(HttpServletRequest request, String skuOneCode) {
        if (StringUtils.isBlank((String)skuOneCode)) {
            this.logger.error(CODE + ".getSkuOne", (Object)"param is null");
            return null;
        }
        return this.rsSkuOneService.getSkuOneByCode(this.getTenantCode(request), skuOneCode);
    }

    @RequestMapping(value={"updateSkuOne.json"}, name="\u66f4\u65b0\u5546\u54c1\u8d77\u8ba2\u91cf\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean updateSkuOne(HttpServletRequest request, String rsSkuOneDomainJson) {
        if (null == rsSkuOneDomainJson) {
            this.logger.error(CODE + ".updateSkuOne", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RsSkuOneDomain rsSkuOneDomain = (RsSkuOneDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsSkuOneDomainJson, RsSkuOneDomain.class);
        rsSkuOneDomain.setTenantCode(this.getTenantCode(request));
        return this.rsSkuOneService.updateSkuOne(rsSkuOneDomain);
    }

    @RequestMapping(value={"deleteSkuOneByCode.json"}, name="\u5220\u9664\u5546\u54c1\u8d77\u8ba2\u91cf\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean deleteSkuOneByCode(HttpServletRequest request, String skuOneCode) {
        if (StringUtils.isBlank((String)skuOneCode)) {
            this.logger.error(CODE + ".deleteSkuOne", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSkuOneService.deleteSkuOneByCode(this.getTenantCode(request), skuOneCode);
    }

    @RequestMapping(value={"deleteBatchSkuOneByCode.json"}, name="\u6279\u91cf\u5220\u9664\u5546\u54c1\u8d77\u8ba2\u91cf\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean deleteBatchSkuOneByCode(HttpServletRequest request, String skuOneCodesJson) {
        if (StringUtils.isBlank((String)skuOneCodesJson)) {
            this.logger.error(CODE + ".deleteBatchSkuOneByCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String[] codeStr = skuOneCodesJson.split(",");
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        String tenantCode = this.getTenantCode(request);
        for (String code : codeStr) {
            htmlJsonReBean = this.rsSkuOneService.deleteSkuOneByCode(tenantCode, code);
            if (null != htmlJsonReBean && htmlJsonReBean.isSuccess()) continue;
            return htmlJsonReBean;
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"querySkuOnePage.json"}, name="\u67e5\u8be2\u5546\u54c1\u8d77\u8ba2\u91cf\u8bbe\u7f6e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsSkuOneReDomain> querySkuOnePage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsSkuOneService.querySkuOnePage(param);
    }

    @RequestMapping(value={"updateSkuOneStateByCode.json"}, name="\u66f4\u65b0\u5546\u54c1\u8d77\u8ba2\u91cf\u8bbe\u7f6e\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateSkuOneState(HttpServletRequest request, String skuOneCode, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)skuOneCode)) {
            this.logger.error(CODE + ".updateSkuOneState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSkuOneService.updateSkuOneStateByCode(this.getTenantCode(request), skuOneCode, dataState, oldDataState, null);
    }

    @RequestMapping(value={"querySkuOneListPage.json"}, name="\u67e5\u8be2\u5546\u54c1\u8d77\u8ba2\u91cf\u7528\u6237\u8303\u56f4\u8bbe\u7f6e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsSkuOnelistReDomain> querySkuOneListPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsSkuOneService.querySkuOnelistPage(param);
    }

    @RequestMapping(value={"deleteSkuOneListByCode.json"}, name="\u5220\u9664\u5546\u54c1\u8d77\u8ba2\u91cf\u7528\u6237\u8303\u56f4\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean deleteSkuOneListByCode(HttpServletRequest request, String skuOneListCode) {
        if (StringUtils.isBlank((String)skuOneListCode)) {
            this.logger.error(CODE + ".deleteSkuOneListByCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSkuOneService.deleteSkuOnelistByCode(this.getTenantCode(request), skuOneListCode);
    }
}

