/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.thread;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.hl.StudentDataVo;
import cn.com.qj.bff.domain.org.OrgCompanyReDomain;
import cn.com.qj.bff.domain.org.OrgDepartempDomain;
import cn.com.qj.bff.domain.org.OrgDepartempReDomain;
import cn.com.qj.bff.domain.org.OrgEmployeeDomain;
import cn.com.qj.bff.domain.org.OrgEmployeeReDomain;
import cn.com.qj.bff.domain.um.UmUserDomainBean;
import cn.com.qj.bff.domain.um.UmUserReDomainBean;
import cn.com.qj.bff.domain.um.UmUserinfoReDomainBean;
import cn.com.qj.bff.service.hl.DataUserInfoService;
import cn.com.qj.bff.service.org.OrgCompanyService;
import cn.com.qj.bff.service.org.OrgDepartService;
import cn.com.qj.bff.service.org.OrgEmployeeService;
import cn.com.qj.bff.service.um.UserBaseService;
import cn.com.qj.bff.service.um.UserService;
import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;

public class SaveSynXfStuCallableImpl
implements Callable {
    private static final String CODE = "SaveSynXfStuCallableImpl";
    private String parentTelephone;
    private String userOpenid;
    private String tenantCode;
    private SupperLogUtil logger;
    private UserService userService;
    private UserBaseService userBaseService;
    private OrgEmployeeService orgEmployeeService;
    private OrgCompanyService orgCompanyService;
    private OrgDepartService orgDepartService;
    private DataUserInfoService dataUserInfoService;
    private static final Integer PAGE_NUM = 1;
    private static final Integer PAGE_SIZE = 20;
    private static final ExecutorService executorService = Executors.newFixedThreadPool(100);

    public SaveSynXfStuCallableImpl(String parentTelephone, String userOpenid, String tenantCode, SupperLogUtil logger, UserService userService, UserBaseService userBaseService, OrgEmployeeService orgEmployeeService, OrgCompanyService orgCompanyService, OrgDepartService orgDepartService, DataUserInfoService dataUserInfoService) {
        this.parentTelephone = parentTelephone;
        this.userOpenid = userOpenid;
        this.tenantCode = tenantCode;
        this.logger = logger;
        this.userService = userService;
        this.userBaseService = userBaseService;
        this.orgEmployeeService = orgEmployeeService;
        this.orgCompanyService = orgCompanyService;
        this.orgDepartService = orgDepartService;
        this.dataUserInfoService = dataUserInfoService;
    }

    public Set<String> call() throws Exception {
        long startTime = System.currentTimeMillis();
        HashSet<String> resultSet = new HashSet<String>();
        HashMap<String, Object> stuParam = new HashMap<String, Object>();
        HashMap<String, StudentDataVo> stuExistParam = new HashMap<String, StudentDataVo>();
        HashMap<String, Object> orgParam = new HashMap<String, Object>();
        stuParam.put("pageNum", PAGE_NUM);
        stuParam.put("pageSize", PAGE_SIZE);
        stuParam.put("tenantCode", this.tenantCode);
        stuParam.put("parentTelephone", this.parentTelephone);
        List<StudentDataVo> studentDataVos = this.dataUserInfoService.querySynXfStu(stuParam);
        long endTime = System.currentTimeMillis();
        this.logger.error("\u67e5\u8be2\u65f6\u95f4\u65f6\u95f4: " + (endTime - startTime) + " \u6beb\u79d2");
        this.logger.error("SaveSynXfStuCallableImpl.call.studentDataVos", (Object)JSON.toJSONString(studentDataVos));
        if (ListUtil.isEmpty(studentDataVos)) {
            return null;
        }
        StringBuffer stuNo = new StringBuffer();
        for (StudentDataVo studentDataVo : studentDataVos) {
            stuExistParam.put(studentDataVo.getSno(), studentDataVo);
            if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)stuNo.toString())) {
                stuNo.append(",");
            }
            stuNo.append(studentDataVo.getSno());
        }
        orgParam.put("tenantCode", this.tenantCode);
        orgParam.put("employeeTel", stuNo.toString());
        orgParam.put("employeePhone", this.parentTelephone);
        orgParam.put("employeeOcode", "1");
        SupQueryResult<OrgEmployeeReDomain> queryEmployeePage = this.orgEmployeeService.queryEmployeePage(orgParam);
        if (queryEmployeePage != null && ListUtil.isNotEmpty((Collection)queryEmployeePage.getList())) {
            for (OrgEmployeeReDomain orgEmployeeReDomain : queryEmployeePage.getList()) {
                if (!stuExistParam.containsKey(orgEmployeeReDomain.getEmployeeTel())) continue;
                if ("1".equals(orgEmployeeReDomain.getEmployeeOcode())) {
                    this.updateOrgEmp(orgEmployeeReDomain, (StudentDataVo)stuExistParam.get(orgEmployeeReDomain.getEmployeeTel()), this.tenantCode);
                }
                stuExistParam.remove(orgEmployeeReDomain.getEmployeeTel());
            }
            if (stuExistParam.keySet().size() != 0) {
                for (StudentDataVo value : stuExistParam.values()) {
                    resultSet.add(this.saveCheckUser(value, this.tenantCode, this.userOpenid, this.parentTelephone));
                }
            }
        } else {
            for (StudentDataVo studentDataVo : studentDataVos) {
                resultSet.add(this.saveCheckUser(studentDataVo, this.tenantCode, this.userOpenid, this.parentTelephone));
            }
        }
        endTime = System.currentTimeMillis();
        this.logger.error("\u6267\u884c\u65f6\u95f4: " + (endTime - startTime) + " \u6beb\u79d2");
        return resultSet;
    }

    private String saveCheckUser(StudentDataVo studentDataVo, String tenantCode, String openid, String parentTelephone) {
        HashMap<String, Object> orgParm = new HashMap<String, Object>();
        orgParm.put("companyShortname", studentDataVo.getCampusCode());
        orgParm.put("tenantCode", tenantCode);
        SupQueryResult<OrgCompanyReDomain> queryCompanyPage = this.orgCompanyService.queryCompanyPage(orgParm);
        if (queryCompanyPage == null || ListUtil.isEmpty((Collection)queryCompanyPage.getList())) {
            this.logger.error("SaveSynXfStuCallableImpl.saveCheckUser.orgParm", (Object)JSON.toJSONString(orgParm));
            throw new ApiException("\u5b66\u6821\u4e0d\u5b58\u5728");
        }
        String userinfoCode = null;
        String passWd = "HL123456";
        OrgCompanyReDomain orgCompanyReDomain = (OrgCompanyReDomain)queryCompanyPage.getList().get(0);
        HtmlJsonReBean htmlJsonReBean = this.saveUserCodeUmuser(this.getLockUUID(), parentTelephone, passWd, 1, tenantCode, null, null, orgCompanyReDomain.getCompanyCode(), orgCompanyReDomain.getCompanyName(), studentDataVo);
        if (!htmlJsonReBean.isSuccess()) {
            this.logger.error("SaveSynXfStuCallableImpl.saveCheckUser.\u4fdd\u5b58\u7528\u6237\u5931\u8d25");
            return null;
        }
        this.logger.error("SaveSynXfStuCallableImpl.saveCheckUser.htmlJsonReBean", (Object)JSON.toJSONString((Object)htmlJsonReBean));
        userinfoCode = htmlJsonReBean.getDataObj().toString();
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isBlank((String)userinfoCode)) {
            this.logger.error("SaveSynXfStuCallableImpl.saveCheckUser.userinfoCode.is null.\u4fdd\u5b58\u7528\u6237\u5931\u8d25");
            return null;
        }
        HashMap<String, Object> umParam = new HashMap<String, Object>();
        umParam.put("userPcode", userinfoCode);
        umParam.put("tenantCode", tenantCode);
        this.logger.error("SaveSynXfStuCallableImpl.saveCheckUser.queryUserPage", (Object)JSON.toJSONString(umParam));
        SupQueryResult<UmUserReDomainBean> queryResult = this.userService.queryUserPage(umParam);
        UmUserReDomainBean userByCode = null;
        if (queryResult == null || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error("SaveSynXfStuCallableImpl.saveCheckUser.\u7528\u6237\u4fe1\u606f\u5f02\u5e38");
            throw new ApiException("\u7528\u6237\u4fe1\u606f\u5f02\u5e38");
        }
        userByCode = (UmUserReDomainBean)queryResult.getList().get(0);
        UmUserinfoReDomainBean userinfo = this.userService.getUserinfoByCode(userinfoCode, tenantCode);
        userinfo.setUserinfoCert1No("0");
        userinfo.setUserinfoCompname(studentDataVo.getFullName());
        this.userService.updateUserinfo(userinfo);
        HtmlJsonReBean saveOrgEmp = this.saveOrgEmp(orgCompanyReDomain, tenantCode, userByCode.getUserCode(), userinfo.getUserinfoCode(), passWd, studentDataVo, parentTelephone);
        this.logger.error("SaveSynXfStuCallableImpl.saveCheckUser.saveOrgEmp", (Object)JSON.toJSONString((Object)saveOrgEmp));
        if (userByCode == null || saveOrgEmp == null || !saveOrgEmp.isSuccess()) {
            this.logger.error("SaveSynXfStuCallableImpl.saveCheckUser.\u4fdd\u5b58\u5458\u5de5\u5931\u8d25");
            return null;
        }
        if (com.yqbsoft.laser.service.tool.util.StringUtils.isNotBlank((String)openid)) {
            userByCode.setUserName(saveOrgEmp.getDataObj().toString());
            userByCode.setUserOpenid(openid);
            this.userService.updateUser(userByCode);
        }
        return userinfoCode;
    }

    private synchronized String getLockUUID() {
        return UUID.randomUUID().toString().replace("-", "").substring(0, 10);
    }

    private HtmlJsonReBean saveOrgEmp(OrgCompanyReDomain orgCompanyReDomain, String tenantCode, String userCode, String userinfoCode, String passWd, StudentDataVo studentDataVo, String parentTelephone) {
        OrgEmployeeDomain orgEmployeeDomain = new OrgEmployeeDomain();
        orgEmployeeDomain.setEmployeeType("0");
        orgEmployeeDomain.setEmployeeOcode("1");
        orgEmployeeDomain.setEmployeeTel(studentDataVo.getSno());
        orgEmployeeDomain.setEmployeeShortname(studentDataVo.getCampusCode());
        orgEmployeeDomain.setCompanyCode(orgCompanyReDomain.getCompanyCode());
        orgEmployeeDomain.setCompanyShortname(orgCompanyReDomain.getCompanyName());
        orgEmployeeDomain.setTenantCode(tenantCode);
        orgEmployeeDomain.setEmployeePhone(parentTelephone);
        orgEmployeeDomain.setUserPwsswd(passWd);
        orgEmployeeDomain.setUserCode(userCode);
        orgEmployeeDomain.setUserinfoCode(userinfoCode);
        orgEmployeeDomain.setEmployeeName(studentDataVo.getFullName());
        orgEmployeeDomain.setTeacherCode(studentDataVo.getStaffCode());
        orgEmployeeDomain.setTeacherName(studentDataVo.getStaffName());
        orgEmployeeDomain.setTeacherPhone(studentDataVo.getStaffTelephone());
        orgEmployeeDomain.setPositionName(studentDataVo.getClassName());
        orgEmployeeDomain.setPositionCode(studentDataVo.getClassCode());
        HtmlJsonReBean htmlJsonReBean = this.orgEmployeeService.saveEmployee(orgEmployeeDomain);
        if (!htmlJsonReBean.isSuccess()) {
            this.logger.error("SaveSynXfStuCallableImpl.saveOrgEmp.htmlJsonReBean", (Object)JSON.toJSONString((Object)orgEmployeeDomain));
            throw new ApiException("\u5458\u5de5\u521b\u5efa\u5931\u8d25\uff01");
        }
        OrgDepartempDomain orgDepartempDomain = new OrgDepartempDomain();
        orgDepartempDomain.setDepartName(studentDataVo.getDepartName());
        orgDepartempDomain.setDepartCode(studentDataVo.getDepartCode());
        orgDepartempDomain.setPositionName(studentDataVo.getGradeName());
        orgDepartempDomain.setPositionCode(studentDataVo.getGradeCode());
        orgDepartempDomain.setCompanyCode(orgEmployeeDomain.getCompanyCode());
        orgDepartempDomain.setUserinfoCode(userinfoCode);
        orgDepartempDomain.setEmployeeName(studentDataVo.getFullName());
        orgDepartempDomain.setEmployeeCode(htmlJsonReBean.getDataObj().toString());
        orgDepartempDomain.setTenantCode(tenantCode);
        HtmlJsonReBean htmlJsonReBean1 = this.orgDepartService.saveDepartemp(orgDepartempDomain);
        if (null == htmlJsonReBean1 || !htmlJsonReBean1.isSuccess()) {
            this.logger.error("SaveSynXfStuCallableImpl.saveOrgEmp.orgDepartService", (Object)JSON.toJSONString((Object)orgDepartempDomain));
            throw new ApiException("\u90e8\u95e8\u6210\u5458\u65b0\u589e\u5931\u8d25");
        }
        this.logger.error("SaveSynXfStuCallableImpl.saveOrgEmp.orgEmployeeDomain", (Object)JSON.toJSONString((Object)orgEmployeeDomain));
        return htmlJsonReBean;
    }

    private HtmlJsonReBean updateOrgEmp(OrgEmployeeReDomain orgEmployeeReDomain, StudentDataVo studentDataVo, String tenantCode) {
        HashMap<String, Object> orgParm = new HashMap<String, Object>();
        orgParm.put("companyShortname", studentDataVo.getCampusCode());
        orgParm.put("tenantCode", tenantCode);
        SupQueryResult<OrgCompanyReDomain> queryCompanyPage = this.orgCompanyService.queryCompanyPage(orgParm);
        if (queryCompanyPage == null || ListUtil.isEmpty((Collection)queryCompanyPage.getList())) {
            this.logger.error("SaveSynXfStuCallableImpl.updateOrgEmp.orgParm", (Object)JSON.toJSONString(orgParm));
            return null;
        }
        OrgCompanyReDomain orgCompanyReDomain = (OrgCompanyReDomain)queryCompanyPage.getList().get(0);
        orgEmployeeReDomain.setEmployeeName(studentDataVo.getFullName());
        this.synUpdateUerinfo(orgEmployeeReDomain, orgCompanyReDomain);
        orgEmployeeReDomain.setEmployeeType("0");
        orgEmployeeReDomain.setEmployeeOcode("1");
        orgEmployeeReDomain.setEmployeeTel(studentDataVo.getSno());
        orgEmployeeReDomain.setEmployeeShortname(studentDataVo.getCampusCode());
        orgEmployeeReDomain.setCompanyCode(orgCompanyReDomain.getCompanyCode());
        orgEmployeeReDomain.setCompanyShortname(orgCompanyReDomain.getCompanyName());
        orgEmployeeReDomain.setTenantCode(tenantCode);
        orgEmployeeReDomain.setEmployeePhone(this.parentTelephone);
        orgEmployeeReDomain.setTeacherCode(studentDataVo.getStaffCode());
        orgEmployeeReDomain.setTeacherName(studentDataVo.getStaffName());
        orgEmployeeReDomain.setTeacherPhone(studentDataVo.getStaffTelephone());
        orgEmployeeReDomain.setPositionName(studentDataVo.getClassName());
        orgEmployeeReDomain.setPositionCode(studentDataVo.getClassCode());
        HtmlJsonReBean htmlJsonReBean = this.orgEmployeeService.updateEmployee(orgEmployeeReDomain);
        if (!htmlJsonReBean.isSuccess()) {
            this.logger.error("SaveSynXfStuCallableImpl.updateOrgEmp.htmlJsonReBean", (Object)JSON.toJSONString((Object)orgEmployeeReDomain));
            return null;
        }
        this.logger.error("SaveSynXfStuCallableImpl.updateOrgEmp.orgEmployeeReDomain", (Object)JSON.toJSONString((Object)orgEmployeeReDomain));
        HashMap<String, Object> orgDept = new HashMap<String, Object>();
        orgDept.put("userinfoCode", orgEmployeeReDomain.getUserinfoCode());
        orgDept.put("tenantCode", tenantCode);
        SupQueryResult<OrgDepartempReDomain> departPage = this.orgDepartService.queryDepartempPage(orgDept);
        if (departPage != null && ListUtil.isNotEmpty((Collection)departPage.getList())) {
            OrgDepartempReDomain orgDepartempDomain = (OrgDepartempReDomain)departPage.getList().get(0);
            orgDepartempDomain.setDepartName(studentDataVo.getDepartName());
            orgDepartempDomain.setDepartCode(studentDataVo.getDepartCode());
            orgDepartempDomain.setPositionName(studentDataVo.getGradeName());
            orgDepartempDomain.setPositionCode(studentDataVo.getGradeCode());
            orgDepartempDomain.setCompanyCode(orgEmployeeReDomain.getCompanyCode());
            orgDepartempDomain.setEmployeeName(studentDataVo.getFullName());
            HtmlJsonReBean htmlJsonReBean1 = this.orgDepartService.updateDepartemp(orgDepartempDomain);
            if (null == htmlJsonReBean1 || !htmlJsonReBean1.isSuccess()) {
                this.logger.error("SaveSynXfStuCallableImpl.updateOrgEmp.orgDepartService", (Object)JSON.toJSONString((Object)orgDepartempDomain));
                return null;
            }
        } else {
            OrgDepartempDomain orgDepartempDomain = new OrgDepartempDomain();
            orgDepartempDomain.setDepartName(studentDataVo.getDepartName());
            orgDepartempDomain.setDepartCode(studentDataVo.getDepartCode());
            orgDepartempDomain.setPositionName(studentDataVo.getGradeName());
            orgDepartempDomain.setPositionCode(studentDataVo.getGradeCode());
            orgDepartempDomain.setCompanyCode(orgEmployeeReDomain.getCompanyCode());
            orgDepartempDomain.setUserinfoCode(orgEmployeeReDomain.getUserinfoCode());
            orgDepartempDomain.setEmployeeName(studentDataVo.getFullName());
            orgDepartempDomain.setEmployeeCode(orgEmployeeReDomain.getEmployeeCode());
            orgDepartempDomain.setTenantCode(tenantCode);
            HtmlJsonReBean htmlJsonReBean1 = this.orgDepartService.saveDepartemp(orgDepartempDomain);
            if (null == htmlJsonReBean1 || !htmlJsonReBean1.isSuccess()) {
                this.logger.error("SaveSynXfStuCallableImpl.updateOrgEmp.orgDepartService", (Object)JSON.toJSONString((Object)orgDepartempDomain));
                return null;
            }
        }
        this.logger.error("SaveSynXfStuCallableImpl.updateOrgEmp.orgEmployeeDomain", (Object)JSON.toJSONString((Object)orgEmployeeReDomain));
        return htmlJsonReBean;
    }

    private void synUpdateUerinfo(final OrgEmployeeReDomain orgEmployeeReDomain, final OrgCompanyReDomain orgCompanyReDomain) {
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                UmUserReDomainBean userByCode = SaveSynXfStuCallableImpl.this.userService.getUserByCode(orgEmployeeReDomain.getUserCode(), orgEmployeeReDomain.getTenantCode());
                if (userByCode != null) {
                    UmUserinfoReDomainBean userinfoByCode;
                    userByCode.setUserinfoParentCode(orgCompanyReDomain.getCompanyCode());
                    userByCode.setUserinfoParentName(orgCompanyReDomain.getCompanyName());
                    HtmlJsonReBean jsonReBean = SaveSynXfStuCallableImpl.this.userService.updateUser(userByCode);
                    if (jsonReBean.isSuccess() && (userinfoByCode = SaveSynXfStuCallableImpl.this.userService.getUserinfoByCode(orgEmployeeReDomain.getUserinfoCode(), orgCompanyReDomain.getTenantCode())) != null) {
                        userinfoByCode.setUserinfoParentCode(orgCompanyReDomain.getCompanyCode());
                        userinfoByCode.setUserinfoParentName(orgCompanyReDomain.getCompanyName());
                        userinfoByCode.setUserinfoCompname(orgEmployeeReDomain.getEmployeeName());
                        SaveSynXfStuCallableImpl.this.userService.updateUserinfo(userinfoByCode);
                    }
                }
            }
        });
    }

    public HtmlJsonReBean saveUserCodeUmuser(String userName, String userPhone, String userPwsswd, Integer userinfoType, String tenantCode, String userOpenid, String roleCode, String userinfoParentCode, String userinfoParentName, StudentDataVo studentDataVo) {
        UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
        umUserDomainBean.setTenantCode(tenantCode);
        umUserDomainBean.setUserName(userName);
        umUserDomainBean.setUserRelname(userPhone);
        umUserDomainBean.setUserinfoType(userinfoType);
        if (null == umUserDomainBean.getUserinfoType()) {
            umUserDomainBean.setUserinfoType(1);
        }
        umUserDomainBean.setUserType(1);
        umUserDomainBean.setUserPhone(userPhone);
        umUserDomainBean.setUserPwsswd(userPwsswd);
        umUserDomainBean.setUserinfoCompname(studentDataVo.getFullName());
        umUserDomainBean.setUserinfoQuality("buy");
        umUserDomainBean.setUserOpenid(userOpenid);
        umUserDomainBean.setRoleCode(roleCode);
        umUserDomainBean.setUserinfoParentCode(userinfoParentCode);
        umUserDomainBean.setUserinfoParentName(userinfoParentName);
        HtmlJsonReBean htmlJsonReBean = this.userService.sendOpenUserinfo(umUserDomainBean);
        this.userBaseService.sendUserBigData(umUserDomainBean);
        return htmlJsonReBean;
    }

    protected static String getDdFlag(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (tenantCode.lastIndexOf("\"") > 0) {
            tenantCode = tenantCode.substring(tenantCode.indexOf("\"") + 1, tenantCode.lastIndexOf("\""));
        }
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }
}

