/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.reb;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.reb.MaiHeRebPoints;
import cn.com.qj.bff.domain.reb.MaiHeRebPointsExt;
import cn.com.qj.bff.domain.reb.RebPointsDomain;
import cn.com.qj.bff.domain.reb.RebPointsGoodsDomain;
import cn.com.qj.bff.domain.reb.RebPointsGoodsReDomain;
import cn.com.qj.bff.domain.reb.RebPointsReDomain;
import cn.com.qj.bff.domain.reb.RebPointsUsersDomain;
import cn.com.qj.bff.domain.reb.RebPointsUsersReDomain;
import cn.com.qj.bff.service.reb.RebPointsGoodsService;
import cn.com.qj.bff.service.reb.RebPointsService;
import cn.com.qj.bff.service.reb.RebPointsUsersService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/reb/points"}, name="\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b")
public class RebPointsCon
extends SpringmvcController {
    private static String CODE = "reb.points.con";
    @Autowired
    private RebPointsService rebPointsService;
    @Autowired
    RebPointsGoodsService rebPointsGoodsService;
    @Autowired
    RebPointsUsersService rebPointsUsersService;

    @Override
    protected String getContext() {
        return "points";
    }

    @RequestMapping(value={"savePoints.json"}, name="\u589e\u52a0\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b")
    @ResponseBody
    public HtmlJsonReBean savePoints(HttpServletRequest request, String rebPointsDomainStr) {
        if (StringUtils.isBlank((String)rebPointsDomainStr)) {
            this.logger.error(CODE + ".savePoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RebPointsDomain rebPointsDomain = (RebPointsDomain)JsonUtil.buildNormalBinder().getJsonToObject(rebPointsDomainStr, RebPointsDomain.class);
        rebPointsDomain.setTenantCode(this.getTenantCode(request));
        return this.rebPointsService.savePoints(rebPointsDomain);
    }

    @RequestMapping(value={"getPoints.json"}, name="\u83b7\u53d6\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b\u4fe1\u606f")
    @ResponseBody
    public RebPointsReDomain getPoints(Integer pointsId) {
        if (StringUtils.isBlank((Integer)pointsId)) {
            this.logger.error(CODE + ".getPoints", (Object)"param is null");
            return null;
        }
        RebPointsReDomain points = this.rebPointsService.getPoints(pointsId);
        if (points == null) {
            return points;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", points.getTenantCode());
        map.put("pointsCode", points.getPointsCode());
        ArrayList<RebPointsGoodsDomain> rebPointsGoodsDomainList = new ArrayList<RebPointsGoodsDomain>();
        SupQueryResult<RebPointsGoodsReDomain> rebPointsGoodsReDomainSupQueryResult = this.rebPointsGoodsService.queryPointsGoodsPage(map);
        if (rebPointsGoodsReDomainSupQueryResult != null && CollectionUtils.isNotEmpty((Collection)rebPointsGoodsReDomainSupQueryResult.getList())) {
            for (RebPointsGoodsReDomain rebPointsGoodsReDomain : rebPointsGoodsReDomainSupQueryResult.getList()) {
                rebPointsGoodsDomainList.add(rebPointsGoodsReDomain);
            }
        }
        points.setRebPointsGoodsDomainList(rebPointsGoodsDomainList);
        ArrayList<RebPointsUsersDomain> rebPointsUsersDomainList = new ArrayList<RebPointsUsersDomain>();
        SupQueryResult<RebPointsUsersReDomain> rebPointsUsersReDomainSupQueryResult = this.rebPointsUsersService.queryPointsUsersPage(map);
        if (rebPointsUsersReDomainSupQueryResult != null && CollectionUtils.isNotEmpty((Collection)rebPointsUsersReDomainSupQueryResult.getList())) {
            for (RebPointsUsersReDomain rebPointsUsersReDomain : rebPointsUsersReDomainSupQueryResult.getList()) {
                rebPointsUsersDomainList.add(rebPointsUsersReDomain);
            }
        }
        points.setRebPointsUsersDomainList(rebPointsUsersDomainList);
        return points;
    }

    @RequestMapping(value={"updatePoints.json"}, name="\u66f4\u65b0\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b")
    @ResponseBody
    public HtmlJsonReBean updatePoints(HttpServletRequest request, String rebPointsDomainStr) {
        if (StringUtils.isBlank((String)rebPointsDomainStr)) {
            this.logger.error(CODE + ".updatePoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RebPointsDomain rebPointsDomain = (RebPointsDomain)JsonUtil.buildNormalBinder().getJsonToObject(rebPointsDomainStr, RebPointsDomain.class);
        rebPointsDomain.setTenantCode(this.getTenantCode(request));
        return this.rebPointsService.updatePoints(rebPointsDomain);
    }

    @RequestMapping(value={"deletePoints.json"}, name="\u5220\u9664\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b")
    @ResponseBody
    public HtmlJsonReBean deletePoints(Integer pointsId) {
        if (StringUtils.isBlank((Integer)pointsId)) {
            this.logger.error(CODE + ".deletePoints", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rebPointsService.deletePoints(pointsId);
    }

    @RequestMapping(value={"queryPointsPage.json"}, name="\u67e5\u8be2\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RebPointsReDomain> queryPointsPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rebPointsService.queryPointsPage(param);
    }

    @RequestMapping(value={"updatePointsState.json"}, name="\u66f4\u65b0\u8fd4\u5229\u5f00\u542f  \u4f7f\u7528\u6bd4\u4f8b\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updatePointsState(String pointsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)pointsId)) {
            this.logger.error(CODE + ".updatePointsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rebPointsService.updatePointsState(Integer.valueOf(pointsId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryPointsPageDetailes.json"}, name="\u67e5\u8be2\u8fd4\u5229\u5217\u8be6\u60c5")
    @ResponseBody
    public SupQueryResult<MaiHeRebPoints> queryPointsPageDetailes(HttpServletRequest request) {
        try {
            UserSession userSession;
            Map<String, Object> param = this.assemMapParam(request);
            if (null != param) {
                param.put("order", true);
                param.put("fuzzy", true);
            }
            if (null == (userSession = this.getUserSession(request))) {
                this.logger.error(CODE + ".queryPointsPageDetailes.userSession", (Object)"userSession is null");
                return new SupQueryResult();
            }
            String userinfoCode = userSession.getUserPcode();
            if (null == userinfoCode) {
                this.logger.error(CODE + ".queryPointsPageDetailes.userinfoCode", (Object)"userinfoCode is null");
                return new SupQueryResult();
            }
            param.put("userinfoCode", userinfoCode);
            param.put("tenantCode", this.getTenantCode(request));
            SupQueryResult<MaiHeRebPoints> maiHeRebPointsSupQueryQuery = this.rebPointsService.queryPointsPageDetailes(param);
            List maiHeRebPointsList = maiHeRebPointsSupQueryQuery.getList();
            this.logger.info(CODE + ".queryPointsPageDetailes.maiHeRebPointsSupQueryQuery", (Object)JsonUtil.buildNormalBinder().toJson((Object)maiHeRebPointsList));
            if (ListUtil.isEmpty((Collection)maiHeRebPointsList)) {
                this.logger.error(CODE + ".queryPointsPageDetailes.maiHeRebPointsList", (Object)"maiHeRebPointsList is null");
                return new SupQueryResult();
            }
            for (MaiHeRebPoints maiHeRebPoints : maiHeRebPointsList) {
                if ("2".equals(maiHeRebPoints.getPointsDatetype()) || "1".equals(maiHeRebPoints.getPointsDatetype())) {
                    if ("1".equals(maiHeRebPoints.getPointsDatetype())) {
                        maiHeRebPoints.setMemo("\u5355\u54c1\u8fd4\u5229");
                        continue;
                    }
                    if (!"2".equals(maiHeRebPoints.getPointsDatetype())) continue;
                    maiHeRebPoints.setMemo("\u6708\u8fd4");
                    continue;
                }
                String pointsCode = maiHeRebPoints.getPointsCode();
                HashMap<String, Object> pointsGoodsmap = new HashMap<String, Object>();
                pointsGoodsmap.put("pointsCode", pointsCode);
                SupQueryResult<RebPointsGoodsReDomain> rebPointsGoodsReDomainSupQueryResult = this.rebPointsGoodsService.queryPointsGoodsPage(pointsGoodsmap);
                List pointsGoodslist = rebPointsGoodsReDomainSupQueryResult.getList();
                if (ListUtil.isEmpty((Collection)pointsGoodslist)) {
                    this.logger.error(CODE + ".queryPointsPageDetailes.pointsGoodslist", (Object)"pointsGoodslist is null");
                    return new SupQueryResult();
                }
                if ("1".equals(maiHeRebPoints.getPointsDatatype())) {
                    maiHeRebPoints.setMemo("\u5b63\u8fd4");
                    BigDecimal orderTarget = BigDecimal.ZERO;
                    BigDecimal pointsGoodsOp1Sum = pointsGoodslist.stream().map(RebPointsGoodsDomain::getPointsGoodsOp1).filter(Objects::nonNull).map(BigDecimal::new).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal pointsGoodsOp2Sum = pointsGoodslist.stream().map(RebPointsGoodsDomain::getPointsGoodsOp2).filter(Objects::nonNull).map(BigDecimal::new).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal pointsGoodsOp3Sum = pointsGoodslist.stream().map(RebPointsGoodsDomain::getPointsGoodsOp3).filter(Objects::nonNull).map(BigDecimal::new).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal pointsGoodsOp4Sum = pointsGoodslist.stream().map(RebPointsGoodsDomain::getPointsGoodsTerm).filter(Objects::nonNull).map(BigDecimal::new).reduce(BigDecimal.ZERO, BigDecimal::add);
                    orderTarget = orderTarget.add(pointsGoodsOp1Sum).add(pointsGoodsOp2Sum).add(pointsGoodsOp3Sum).add(pointsGoodsOp4Sum);
                    maiHeRebPoints.setOrderTarget(orderTarget.toString());
                    ArrayList<MaiHeRebPointsExt> list = new ArrayList<MaiHeRebPointsExt>();
                    MaiHeRebPointsExt maiHeRebPointsExtQ1 = new MaiHeRebPointsExt();
                    maiHeRebPointsExtQ1.setOrderTarget(pointsGoodsOp1Sum.toString());
                    maiHeRebPointsExtQ1.setTargetProgressValue(maiHeRebPoints.getPointsuserUserRatio1().divide(pointsGoodsOp1Sum).toString());
                    maiHeRebPointsExtQ1.setQuarterlyAssessment("Q1");
                    MaiHeRebPointsExt maiHeRebPointsExtQ2 = new MaiHeRebPointsExt();
                    maiHeRebPointsExtQ2.setOrderTarget(pointsGoodsOp2Sum.toString());
                    maiHeRebPointsExtQ2.setTargetProgressValue(maiHeRebPoints.getPointsuserUserRatio2().divide(pointsGoodsOp2Sum).toString());
                    maiHeRebPointsExtQ2.setQuarterlyAssessment("Q2");
                    MaiHeRebPointsExt maiHeRebPointsExtQ3 = new MaiHeRebPointsExt();
                    maiHeRebPointsExtQ3.setOrderTarget(pointsGoodsOp3Sum.toString());
                    maiHeRebPointsExtQ3.setTargetProgressValue(maiHeRebPoints.getPointsuserUserRatio3().divide(pointsGoodsOp3Sum).toString());
                    maiHeRebPointsExtQ3.setQuarterlyAssessment("Q3");
                    MaiHeRebPointsExt maiHeRebPointsExtQ4 = new MaiHeRebPointsExt();
                    maiHeRebPointsExtQ4.setOrderTarget(pointsGoodsOp4Sum.toString());
                    maiHeRebPointsExtQ4.setTargetProgressValue(maiHeRebPoints.getPointsuserUserRatio4().divide(pointsGoodsOp4Sum).toString());
                    maiHeRebPointsExtQ4.setQuarterlyAssessment("Q4");
                    list.add(maiHeRebPointsExtQ1);
                    list.add(maiHeRebPointsExtQ2);
                    list.add(maiHeRebPointsExtQ3);
                    list.add(maiHeRebPointsExtQ4);
                    maiHeRebPoints.setMaiHeRebPointsExtlist(list);
                }
                if (!"2".equals(maiHeRebPoints.getPointsDatatype())) continue;
                maiHeRebPoints.setMemo("\u5e74\u8fd4");
                BigDecimal pointsGoodsOp1Sum = pointsGoodslist.stream().map(RebPointsGoodsDomain::getPointsGoodsOp1).filter(Objects::nonNull).map(BigDecimal::new).reduce(BigDecimal.ZERO, BigDecimal::add);
                maiHeRebPoints.setOrderTarget(pointsGoodsOp1Sum.toString());
                maiHeRebPoints.setPointsuserUserRatio1(maiHeRebPoints.getPointsuserUserRatio1().divide(pointsGoodsOp1Sum));
            }
            this.logger.info(CODE + ".queryPointsPageDetailes.maiHeRebPointsSupQueryQuery", (Object)JsonUtil.buildNormalBinder().toJson(maiHeRebPointsSupQueryQuery));
            return maiHeRebPointsSupQueryQuery;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

