/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.pay;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.oc.OcContractReDomain;
import cn.com.qj.bff.domain.oc.OcContractSettlDomain;
import cn.com.qj.bff.domain.oc.OcContractSubReDomain;
import cn.com.qj.bff.domain.oc.OcContractSublistDomain;
import cn.com.qj.bff.domain.pay.PayChannel;
import cn.com.qj.bff.domain.pay.PayCommit;
import cn.com.qj.bff.domain.pay.PayInfo;
import cn.com.qj.bff.domain.pte.BankHtmlForm;
import cn.com.qj.bff.domain.pte.PtePtfchannelReDomain;
import cn.com.qj.bff.domain.pte.PtePtradeParticipantDomain;
import cn.com.qj.bff.domain.pte.PtePtradeReDomain;
import cn.com.qj.bff.domain.pte.PtradeBean;
import cn.com.qj.bff.domain.um.UmUserReDomainBean;
import cn.com.qj.bff.interceptor.service.BaseInterUtil;
import cn.com.qj.bff.service.oc.OcContractEngineService;
import cn.com.qj.bff.service.oc.OcContractService;
import cn.com.qj.bff.service.pay.PayService;
import cn.com.qj.bff.service.pte.PtePtradeService;
import cn.com.qj.bff.service.um.UserService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import cn.com.qj.bff.springmvc.bean.TmProappEnv;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pte/pay"}, name="\u7528\u6237\u652f\u4ed8\u670d\u52a1")
public class PayCon
extends SpringmvcController {
    private static String CODE = "pte.pay.con";
    @Autowired
    private PtePtradeService ptePtradeService;
    @Autowired
    PayService payService;
    @Autowired
    UserService userService;
    @Autowired
    protected OcContractEngineService ocContractEngineService;
    @Autowired
    private OcContractService ocContractService;
    private static final ExecutorService pool = Executors.newFixedThreadPool(100);

    @Override
    protected String getContext() {
        return "pay";
    }

    @RequestMapping(value={"saveOrderSubToPay.json"}, name="\u5206\u6b21\u652f\u4ed8\u4e0b\u5355")
    @ResponseBody
    public PayInfo saveOrderSubToPay(HttpServletRequest request, String contractBillcode, String contractSubCode) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)contractSubCode)) {
            this.logger.error(CODE + ".saveOrderSubToPay.contractBillcode", (Object)"contractBillcode contractSubCode is null");
            return null;
        }
        String oauthEnvCode = this.getOauthEnvCode(request);
        if (StringUtils.isBlank((String)oauthEnvCode)) {
            this.logger.error(CODE + ".saveOrderSubToPay.oauthEnvCode", (Object)"oauthEnvCode is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveOrderSubToPay.userSession", (Object)"userSession is null");
            return null;
        }
        Map<String, Object> envmap = this.getEnvMap(request);
        PayInfo payInfo = this.payService.saveSubPay(envmap, userSession.getUserPcode(), contractBillcode, contractSubCode, oauthEnvCode, this.getTenantCode(request));
        if (null == payInfo) {
            return null;
        }
        List<PayChannel> payChannelList = this.payService.getPayChannel(userSession, oauthEnvCode, this.getTenantCode(request), "PAY", this.getTginfoCode(request), BaseInterUtil.getChannelCode((HttpServletRequest)request), this.getProappCode(request), userSession.getUserOcode());
        payInfo.setPayChannelList(payChannelList);
        return payInfo;
    }

    @RequestMapping(value={"saveOrderToPay.json"}, name="\u652f\u4ed8\u4e0b\u5355")
    @ResponseBody
    public PayInfo saveOrderToPay(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            this.logger.error(CODE + ".saveOrderToPay.contractBillcode", (Object)"contractBillcode is null");
            return null;
        }
        String oauthEnvCode = this.getOauthEnvCode(request);
        if (StringUtils.isBlank((String)oauthEnvCode)) {
            this.logger.error(CODE + ".saveOrderToPay.oauthEnvCode", (Object)"oauthEnvCode is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveOrderToPay.userSession", (Object)"userSession is null");
            return null;
        }
        Map<String, Object> envmap = this.getEnvMap(request);
        PayInfo payInfo = this.payService.savePay(request, envmap, userSession.getUserPcode(), contractBillcode, oauthEnvCode, this.getTenantCode(request));
        if (null == payInfo) {
            this.logger.error(CODE + ".saveOrderToPay.payInfo", (Object)"payInfo is null");
            return null;
        }
        List<PayChannel> payChannelList = this.payService.getPayChannel(userSession, oauthEnvCode, this.getTenantCode(request), "PAY", this.getTginfoCode(request), BaseInterUtil.getChannelCode((HttpServletRequest)request), this.getProappCode(request), userSession.getUserOcode());
        payInfo.setPayChannelList(payChannelList);
        return payInfo;
    }

    private Map<String, Object> getEnvMap(HttpServletRequest request) {
        UserSession userSession;
        String userAgent;
        HashMap<String, Object> envmap = new HashMap<String, Object>();
        String proappCode = this.getProappCode(request);
        String oauthEnvCode = this.getOauthEnvCode(request);
        if ("app".equals(oauthEnvCode) && StringUtils.isNotBlank((String)(userAgent = request.getHeader("User-Agent")))) {
            if (userAgent.contains("qj-ios")) {
                oauthEnvCode = "ios";
            } else if (userAgent.contains("qj-android")) {
                oauthEnvCode = "android";
            }
        }
        envmap.put("client_ip", this.getClientIp(request));
        envmap.put("wap_type", this.getOauthEnvCode(request));
        envmap.put("wap_name", proappCode);
        TmProappEnv tmProappEnv = (TmProappEnv)SupDisUtil.getMapJson((String)"TmProappEnv-tenant-ProappCode", (String)(this.getTenantCode(request) + "-" + proappCode), TmProappEnv.class);
        if (null != tmProappEnv) {
            envmap.put("wap_url", tmProappEnv.getProappEnvDomain());
            if (StringUtils.isNotBlank((String)tmProappEnv.getProappEnvDes())) {
                envmap.put("wap_name", tmProappEnv.getProappEnvDes());
            }
        }
        if (null != (userSession = this.getUserSession(request))) {
            UmUserReDomainBean umUserReDomainBean;
            envmap.put("userOcode", userSession.getUserOcode());
            envmap.put("openId", userSession.getOpenId());
            envmap.put("userPcode", userSession.getUserPcode());
            String oauthEncCode = this.getOauthEnvCode(request);
            if ("wechat".equals(oauthEncCode) && StringUtils.isBlank((String)userSession.getOpenId()) && null != (umUserReDomainBean = this.userService.getUserByUserCode(userSession.getUserCode(), userSession.getTenantCode()))) {
                envmap.put("openId", umUserReDomainBean.getUserOpenid());
            }
        }
        return envmap;
    }

    private static String getUrl(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    @RequestMapping(value={"saveOrderToBatchPay.json"}, name="\u6279\u91cf\u652f\u4ed8\u4e0b\u5355")
    @ResponseBody
    public PayInfo saveOrderToBatchPay(HttpServletRequest request, String contractBbillcode) {
        if (StringUtils.isBlank((String)contractBbillcode)) {
            this.logger.error(CODE + ".saveOrderToBatchPay.contractBbillcode", (Object)"contractBbillcode is null");
            return null;
        }
        String oauthEnvCode = this.getOauthEnvCode(request);
        if (StringUtils.isBlank((String)oauthEnvCode)) {
            this.logger.error(CODE + ".saveOrderToBatchPay.oauthEnvCode", (Object)"oauthEnvCode is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveOrderToBatchPay.userSession", (Object)"userSession is null");
            return null;
        }
        Map<String, Object> envmap = this.getEnvMap(request);
        PayInfo payInfo = this.payService.saveBatchPay(envmap, userSession.getUserPcode(), contractBbillcode, oauthEnvCode, this.getTenantCode(request));
        if (null == payInfo) {
            return null;
        }
        List<PayChannel> payChannelList = this.payService.getPayChannel(userSession, oauthEnvCode, this.getTenantCode(request), "PAY", this.getTginfoCode(request), BaseInterUtil.getChannelCode((HttpServletRequest)request), this.getProappCode(request), userSession.getUserOcode());
        payInfo.setPayChannelList(payChannelList);
        return payInfo;
    }

    public static void main(String[] args) {
        String notify_urlStr = "http://wewer/00000025/";
        String tenantCode = notify_urlStr.substring(notify_urlStr.length() - 9, notify_urlStr.length() - 1);
        System.out.println(tenantCode);
    }

    @RequestMapping(value={"mockQj.json"}, name="\u652f\u4ed8mock\uff08\u5343\u5320\u652f\u4ed8\uff09")
    public void mockQj(HttpServletRequest request, HttpServletResponse response) {
        Map<String, Object> map = this.getQueryMapParams(request);
        Object out_trade_no = map.get("out_trade_no");
        Object tenantCode = map.get("tenantCode");
        Object notify_url = map.get("notify_url");
        Object return_url = map.get("return_url");
        if (null != notify_url) {
            String notify_urlStr = String.valueOf(notify_url);
            tenantCode = notify_urlStr.substring(notify_urlStr.length() - 9, notify_urlStr.length() - 1);
        }
        HashMap<String, Object> mapRead = new HashMap<String, Object>();
        mapRead.put("\u5546\u6237\u8d26\u6237", map.get("seller_account_name"));
        mapRead.put("\u8d39\u7528", map.get("total_fee"));
        mapRead.put("\u63cf\u8ff0", map.get("subject"));
        mapRead.put("\u5546\u6237ID", map.get("seller_id"));
        mapRead.put("\u5408\u4f5cID", map.get("partner"));
        mapRead.put("E-mail", map.get("seller_email"));
        mapRead.put("\u6d41\u6c34\u53f7", out_trade_no);
        StringBuffer html = new StringBuffer();
        html.append("<!DOCTYPE html>\n");
        html.append("<html>");
        html.append("<head>\n");
        html.append("<meta charset=\"utf-8\">\n");
        html.append("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, user-scalable=no\">\n");
        html.append("<title>\u5343\u5320\u652f\u4ed8</title>\n");
        html.append("</head>\n");
        html.append("<style type=\"text/css\">                \n");
        html.append("*{                                       \n");
        html.append("\tpadding:0;                             \n");
        html.append("\tmargin:0;                              \n");
        html.append("\tfont-family: '\u5fae\u8f6f\u96c5\u9ed1';               \n");
        html.append("\tfont-size:13px;                        \n");
        html.append("}\t                                       \n");
        html.append("ul li{                                   \n");
        html.append("\tlist-style: none;                      \n");
        html.append("}                                        \n");
        html.append(".t-box{                                  \n");
        html.append("      display: -moz-box;                 \n");
        html.append("      display:-webkit-box;               \n");
        html.append("      display: box;                      \n");
        html.append("  }                                      \n");
        html.append("  .t-box-flex1{                          \n");
        html.append("      -moz-box-flex:1;                   \n");
        html.append("      -webkit-box-flex:1;                \n");
        html.append("      box-flex:1;                        \n");
        html.append("      width:0%                           \n");
        html.append("   }                                     \n");
        html.append(".auto{                                   \n");
        html.append("\twidth:90%;                             \n");
        html.append("\tmargin:0 5%;                           \n");
        html.append("}                                        \n");
        html.append(".pay-ul {                                \n");
        html.append("\tmargin-top:30px;                       \n");
        html.append("}                                        \n");
        html.append(".pay-ul li{                              \n");
        html.append("\tmargin:12px 0;                         \n");
        html.append("}                                        \n");
        html.append(".pay-ul label{                           \n");
        html.append("\twidth:6rem;                            \n");
        html.append("\tdisplay:block;                         \n");
        html.append("\tline-height:35px;                      \n");
        html.append("\ttext-align: right;                     \n");
        html.append("}                                        \n");
        html.append(".pay-ul input{                           \n");
        html.append("\tpadding:8px 3px;                       \n");
        html.append("\twidth:100%;                            \n");
        html.append("\tborder:1px solid #e0e0e0;              \n");
        html.append("\tborder-radius:2px;                     \n");
        html.append("}                                        \n");
        html.append(".pay-ul .pay-btn {                       \n");
        html.append("\tmargin-top:20px;                       \n");
        html.append("}                                        \n");
        html.append(".pay-btn input{                          \n");
        html.append("\twidth:80%;                             \n");
        html.append("\tcursor: pointer;                       \n");
        html.append("\tborder:0;                              \n");
        html.append("\tborder-radius:3px;                     \n");
        html.append("\toutline: none                          \n");
        html.append("}                                        \n");
        html.append(".pay-btn input[type=\"submit\"]{         \n");
        html.append("\tcolor:#fff;                            \n");
        html.append("\tbackground:#e52222;                    \n");
        html.append("\tmargin:0 5% 0 15%;                     \n");
        html.append("}                                        \n");
        html.append(".pay-btn input[type=\"button\"]{         \n");
        html.append("\tcolor:#fff;                            \n");
        html.append("\tbackground:#999;                       \n");
        html.append("\tmargin:0 15% 0 5%;                     \n");
        html.append("}                                        \n");
        html.append("</style>                                 \n");
        html.append("<body>\n");
        html.append("<ul class=\"auto pay-ul\">\n");
        String htmlStr = null;
        for (Map.Entry entry : mapRead.entrySet()) {
            htmlStr = "<li class=\"t-box\">";
            htmlStr = htmlStr + "<label>" + (String)entry.getKey() + "\uff1a</label><div class=\"t-box-flex1\"><input type=\"text\" value=\"" + entry.getValue().toString() + "\" readonly=\"true\"/></div><br/>\n";
            htmlStr = htmlStr + "</li>";
            html.append(htmlStr);
        }
        HashMap<String, Long> mapModify = new HashMap<String, Long>();
        mapModify.put("\u8d44\u91d1\u6d41\u6c34\u53f7", System.currentTimeMillis());
        for (Map.Entry entry : mapModify.entrySet()) {
            htmlStr = "<li class=\"t-box\">";
            htmlStr = htmlStr + "<label>" + (String)entry.getKey() + "\uff1a</label><div class=\"t-box-flex1\"><input id=\"trade_no\" type=\"text\" value=\"" + entry.getValue().toString() + "\"/></div><br/>\n";
            htmlStr = htmlStr + "</li>";
            html.append(htmlStr);
        }
        html.append("<li class=\"t-box pay-btn\" >\n");
        html.append("<div class=\"t-box-flex1\"><input type=\"submit\" value=\"\u6210\u529f\" onclick=\"ajax('TRADE_SUCCESS');\"></div>\n");
        html.append("<div class=\"t-box-flex1\"><input type=\"button\" value=\"\u5931\u8d25\" onclick=\"ajax('TRADE_FAULURE');\"></div>\n");
        html.append("</li>\n");
        html.append("</ul>\n");
        html.append("</body>\n");
        html.append("<script>\n");
        html.append("var xhr = new XMLHttpRequest();\n");
        html.append("var formData = new FormData();\n");
        html.append("formData.append('out_trade_no', '#{out_trade_no}');\n".replace("#{out_trade_no}", out_trade_no.toString()));
        html.append("formData.append('notify_url', '#{notify_url}');\n".replace("#{notify_url}", notify_url.toString()));
        html.append("formData.append('tenantCode', '#{tenantCode}');\n".replace("#{tenantCode}", tenantCode.toString()));
        html.append("formData.append('exterface', 'trade_status_sync');\n");
        html.append("xhr.withCredentials = true;\n");
        html.append("function ajax(trade_status) {\n");
        html.append("formData.append('trade_status', trade_status);\n");
        html.append("formData.append('trade_no', document.getElementById('trade_no').value);\n");
        html.append("xhr.open('POST', '#{commitUrl}');\n".replace("#{commitUrl}", notify_url.toString()));
        html.append("xhr.send(formData);\n");
        html.append("xhr.onreadystatechange = function () {\n");
        html.append("if (xhr.readyState==4 && xhr.status==200) {\n");
        html.append("location.href = '#{return_url}';\n".replace("#{return_url}", return_url.toString()));
        html.append("} else {console.log(xhr.readyState + '--' + xhr.status); }\n");
        html.append("}\n");
        html.append("}\n");
        html.append("</script>\n");
        html.append("</html>");
        try {
            response.getWriter().print(html.toString());
        }
        catch (IOException iOException) {
            this.logger.error(CODE + ".mockQj.print.ex", (Throwable)iOException);
        }
    }

    @RequestMapping(value={"paymentCommit.json"}, name="\u652f\u4ed8\u786e\u8ba4")
    @ResponseBody
    public HtmlJsonReBean paymentCommit(HttpServletRequest request, String payCommitStr, String ptradeSeqno, String paywd, String contractBlance) {
        BankHtmlForm bankHtmlForm;
        if (StringUtils.isBlank((String)ptradeSeqno) || StringUtils.isBlank((String)payCommitStr)) {
            this.logger.error(CODE + ".paymentCommit.param", (Object)"param is null");
            return new HtmlJsonReBean(CODE + ".paymentCommit.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        String oauthEnvCode = this.getOauthEnvCode(request);
        if (StringUtils.isBlank((String)oauthEnvCode)) {
            this.logger.error(CODE + ".paymentCommit.oauthEnvCode", (Object)"oauthEnvCode is null");
            return new HtmlJsonReBean(CODE + ".paymentCommit.oauthEnvCode", "\u6570\u636e\u4e3a\u7a7a");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".paymentCommit.userSession", (Object)"userSession is null");
            return new HtmlJsonReBean(CODE + ".paymentCommit.userSession", "\u6570\u636e\u4e3a\u7a7a");
        }
        List payCommitList = JsonUtil.buildNormalBinder().getJsonToList(payCommitStr, PayCommit.class);
        String tenantCode = this.getTenantCode(request);
        if (null == payCommitList || payCommitList.isEmpty()) {
            return null;
        }
        HashMap<String, Object> ptemap = new HashMap<String, Object>();
        ptemap.put("ptradeSeqno", ptradeSeqno);
        ptemap.put("tenantCode", tenantCode);
        PtePtradeReDomain ptePtradeReDomain = this.ptePtradeService.getPtradeByCode(ptemap);
        if (null == ptePtradeReDomain) {
            this.logger.error(CODE + ".paymentCommit.ptePtradeReDomain", (Object)((Object)ptemap).toString());
            return new HtmlJsonReBean(CODE + ".paymentCommit.ptePtradeReDomain", "\u652f\u4ed8\u6d41\u6c34\u4e00\u6b21");
        }
        String userPcode = userSession.getUserPcode();
        if (!userPcode.equals(ptePtradeReDomain.getOpuserCode())) {
            this.logger.error(CODE + ".paymentCommit.ptePtradeReDomain.userPcode", (Object)((Object)ptemap).toString());
            return new HtmlJsonReBean(CODE + ".paymentCommit.ptePtradeReDomain", "\u4e0d\u662f\u5f53\u524d\u767b\u5f55\u7528\u6237");
        }
        String check = "";
        check = PayCon.getCheck(this.getTenantCode(request), "check", "check");
        HashMap<String, Object> mapStr = new HashMap<String, Object>();
        mapStr.put("contractBillcode", ptePtradeReDomain.getBusinessOrderno());
        mapStr.put("tenantCode", tenantCode);
        OcContractReDomain ocContractReDomain = this.ocContractService.getContractOneByCode(mapStr);
        if (null != ocContractReDomain && null != ocContractReDomain.getDataState() && ocContractReDomain.getDataState() == -1) {
            this.logger.error(CODE + ".savePay.data", (Object)(":" + ocContractReDomain.getDataState()));
            return new HtmlJsonReBean(CODE + ".paymentCommit.ocContractReDomain", "\u8ba2\u5355\u5df2\u53d6\u6d88");
        }
        if (null != ocContractReDomain && null != ocContractReDomain.getDataState() && ocContractReDomain.getDataState() == 2) {
            this.logger.error(CODE + ".savePay.data", (Object)(":" + ocContractReDomain.getDataState()));
            return new HtmlJsonReBean(CODE + ".paymentCommit.ocContractReDomain2", "\u8ba2\u5355\u5df2\u652f\u4ed8");
        }
        Map<String, PtePtfchannelReDomain> channelMap = this.payService.queryChannel(oauthEnvCode, tenantCode, "PAY", userSession, this.getTginfoCode(request), this.getNowChannel(request), this.getProappCode(request));
        if (null == channelMap || channelMap.isEmpty()) {
            return null;
        }
        ArrayList<PtePtradeParticipantDomain> ptradeParticipantList = new ArrayList<PtePtradeParticipantDomain>();
        String fchannelMode = "0";
        boolean flag = true;
        BigDecimal orderMount = BigDecimal.ZERO;
        ArrayList<OcContractSettlDomain> settllist = new ArrayList<OcContractSettlDomain>();
        for (PayCommit payCommit : payCommitList) {
            if (null == payCommit.getOrderAmount()) {
                payCommit.setOrderAmount(BigDecimal.ZERO);
            }
            if (BigDecimal.ZERO.compareTo(payCommit.getOrderAmount()) == 0) continue;
            orderMount = orderMount.add(payCommit.getOrderAmount());
            PtePtfchannelReDomain ptePtfchannelReDomain = channelMap.get(payCommit.getFchannelCode());
            if (null == ptePtfchannelReDomain) {
                return new HtmlJsonReBean(CODE + ".paymentCommit.ptePtfchannelReDomain", "\u6570\u636e\u4e3a\u7a7a");
            }
            PtePtradeParticipantDomain ptePtradeParticipantDomain = new PtePtradeParticipantDomain();
            try {
                String balance;
                BeanUtils.copyAllPropertys((Object)ptePtradeParticipantDomain, (Object)ptePtfchannelReDomain);
                BeanUtils.copyAllPropertys((Object)ptePtradeParticipantDomain, (Object)payCommit);
                ptePtradeParticipantDomain.setFchannelClassifyCode(ptePtfchannelReDomain.getFchannelType());
                ptePtradeParticipantDomain.setPtePtradeType("0");
                fchannelMode = ptePtfchannelReDomain.getFchannelModel();
                if ("BUY_B".equals(ptePtfchannelReDomain.getDicActorCode())) {
                    if (StringUtils.isBlank((String)payCommit.getFaccountId())) {
                        return new HtmlJsonReBean(CODE + ".paymentCommit.getFaccountId", "\u8d26\u6237\u4fe1\u606f\u4e3a\u7a7a");
                    }
                    if (StringUtils.isNotBlank((String)ptePtfchannelReDomain.getFundIntype())) {
                        ptePtradeParticipantDomain.setFundType(ptePtfchannelReDomain.getFundIntype());
                    }
                    ptePtradeParticipantDomain.setOpuserCode(userSession.getUserPcode());
                    balance = "VD";
                } else {
                    balance = payCommit.getFchannelCode().equals("CRP") ? "CRP" : (payCommit.getFchannelCode().equals("BZJ") ? "BZJ" : "CAS");
                }
                settllist.add(this.make(payCommit, balance, ptradeSeqno));
            }
            catch (Exception e) {
                this.logger.error(CODE + ".paymentCommit.e", (Throwable)e);
                return new HtmlJsonReBean(CODE + ".paymentCommit.e", "\u6570\u636e\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((String)ptePtfchannelReDomain.getPtfchannelAmt())) {
                ptePtfchannelReDomain.setPtfchannelAmt("0");
            }
            if ("BANK".equals(ptePtfchannelReDomain.getDicActorCode()) && BigDecimal.ZERO.compareTo(payCommit.getOrderAmount()) == -1 && "0".equals(ptePtfchannelReDomain.getPtfchannelAmt())) {
                flag = false;
            }
            ptradeParticipantList.add(ptePtradeParticipantDomain);
        }
        if (StringUtils.isNotBlank((String)check)) {
            boolean falg2 = this.makesettllistNew(settllist, ptePtradeReDomain);
            this.logger.error(CODE + ".paymentCommit.step 3", (Object)falg2);
            if (falg2) {
                flag = falg2;
            }
        }
        if (flag) {
            if (StringUtils.isBlank((String)paywd)) {
                return new HtmlJsonReBean(CODE + ".paymentCommit.paywd", "\u5bc6\u7801\u4e3a\u7a7a");
            }
            Map<String, Object> map = this.userService.queryCheckPaywd(userSession.getUserCode(), tenantCode, paywd, this.getProappCode(request));
            if (null == map || !((Boolean)map.get("flag")).booleanValue()) {
                String msg = null == map ? "\u5bc6\u7801\u4e0d\u6b63\u786e" : (String)map.get("message");
                return new HtmlJsonReBean(CODE + ".paymentCommit.paywd", msg);
            }
        }
        if (null != ptePtradeReDomain && null != ptePtradeReDomain.getOrderOamount() && ptePtradeReDomain.getOrderOamount().compareTo(orderMount) != 0) {
            return new HtmlJsonReBean(CODE + ".paymentCommit.mount", "\u91d1\u989d\u4e0d\u4e00\u81f4");
        }
        this.saveSettlList(settllist, ocContractReDomain, tenantCode, ptePtradeReDomain, contractBlance);
        PtradeBean ptradeBean = new PtradeBean();
        ptradeBean.setPtradeSeqno(ptradeSeqno);
        if (StringUtils.isNotBlank((String)check)) {
            if (ListUtil.isNotEmpty(ptradeParticipantList)) {
                ArrayList<PtePtradeParticipantDomain> ptePtradeParticipantDomainList = new ArrayList<PtePtradeParticipantDomain>();
                for (PtePtradeParticipantDomain ptePtradeParticipantDomainStr : ptradeParticipantList) {
                    if (StringUtils.isNotBlank((String)ptePtradeParticipantDomainStr.getFchannelCode()) && ptePtradeParticipantDomainStr.getFchannelCode().equals("CRP")) {
                        this.logger.error(CODE + "\u8fc7\u6ee4\u6389\u6388\u4fe1\u652f\u4ed811");
                        continue;
                    }
                    ptePtradeParticipantDomainList.add(ptePtradeParticipantDomainStr);
                }
                ptradeBean.setPartList(ptePtradeParticipantDomainList);
            }
        } else {
            ptradeBean.setPartList(ptradeParticipantList);
        }
        ptradeBean.setTenantCode(tenantCode);
        ptradeBean.setFchannelMode(fchannelMode);
        this.logger.error(CODE + ".paymentCommit.step 1", settllist);
        if (StringUtils.isNotBlank((String)check)) {
            boolean falg1 = this.makesettllist(settllist, ptePtradeReDomain);
            this.logger.error(CODE + ".paymentCommit.step 3", (Object)falg1);
            if (falg1) {
                return new HtmlJsonReBean();
            }
        }
        if (StringUtils.isNotBlank((String)check)) {
            boolean falg1 = this.makeSettllistBzj(settllist, ptePtradeReDomain);
            this.logger.error(CODE + ".paymentCommit.step 3", (Object)falg1);
            if (falg1) {
                return new HtmlJsonReBean();
            }
        }
        if (null != (bankHtmlForm = this.ptePtradeService.sendParticipantByPtradeBase(ptradeBean))) {
            bankHtmlForm.setBusinessOrder(ptePtradeReDomain.getBusinessOrder());
        }
        this.logger.error(CODE + ".paymentCommit.step 2", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)bankHtmlForm));
        return new HtmlJsonReBean((Object)bankHtmlForm);
    }

    private boolean makesettllistNew(List<OcContractSettlDomain> settllist, PtePtradeReDomain ptePtradeReDomain) {
        boolean falg = false;
        this.logger.error(CODE + ".makesettllistNew 21", (Object)(settllist + "ptePtradeReDomain" + ptePtradeReDomain));
        if (ListUtil.isNotEmpty(settllist)) {
            for (OcContractSettlDomain ocContractSettlDomain : settllist) {
                if (!ocContractSettlDomain.getContractSettlBlance().equals("VD") && !ocContractSettlDomain.getContractSettlBlance().equals("CRP") && !ocContractSettlDomain.getContractSettlBlance().equals("BZJ")) continue;
                falg = true;
                break;
            }
        }
        return falg;
    }

    private boolean makesettllistBybzj(List<OcContractSettlDomain> settllist, PtePtradeReDomain ptePtradeReDomain) {
        OcContractSettlDomain ocContractSettlDomain;
        boolean falg = false;
        this.logger.error(CODE + ".makesettllistBybzj 21", (Object)(settllist + "ptePtradeReDomain" + ptePtradeReDomain));
        if (ListUtil.isNotEmpty(settllist) && settllist.size() == 1 && null != ptePtradeReDomain && (ocContractSettlDomain = settllist.get(0)).getContractSettlOpemo().equals("BZJ")) {
            falg = true;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                this.logger.error(CODE + ".makesettllist.sleep.ex", (Throwable)e);
            }
            this.sendContractNext(ptePtradeReDomain.getTenantCode(), ptePtradeReDomain.getBusinessOrderno());
        }
        return falg;
    }

    private boolean makesettllist(List<OcContractSettlDomain> settllist, PtePtradeReDomain ptePtradeReDomain) {
        OcContractSettlDomain ocContractSettlDomain;
        boolean falg = false;
        this.logger.error(CODE + ".paymentCommit.step 21", (Object)(settllist + "ptePtradeReDomain" + ptePtradeReDomain));
        if (ListUtil.isNotEmpty(settllist) && settllist.size() == 1 && null != ptePtradeReDomain && (ocContractSettlDomain = settllist.get(0)).getContractSettlOpemo().equals("CRP")) {
            falg = true;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                this.logger.error(CODE + ".makesettllist.sleep.ex", (Throwable)e);
            }
            this.sendContractNext(ptePtradeReDomain.getTenantCode(), ptePtradeReDomain.getBusinessOrderno());
        }
        return falg;
    }

    private boolean makeSettllistBzj(List<OcContractSettlDomain> settllist, PtePtradeReDomain ptePtradeReDomain) {
        OcContractSettlDomain ocContractSettlDomain;
        boolean falg = false;
        this.logger.error(CODE + ".makeSettllistBzj.step 21", (Object)(settllist + "ptePtradeReDomain" + ptePtradeReDomain));
        if (ListUtil.isNotEmpty(settllist) && settllist.size() == 1 && null != ptePtradeReDomain && (ocContractSettlDomain = settllist.get(0)).getContractSettlOpemo().equals("BZJ")) {
            falg = true;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                this.logger.error(CODE + ".makesettllist.sleep.ex", (Throwable)e);
            }
            this.sendContractNext(ptePtradeReDomain.getTenantCode(), ptePtradeReDomain.getBusinessOrderno());
        }
        return falg;
    }

    protected HtmlJsonReBean sendContractNext(String tenantCode, String contractBillcode) {
        this.logger.error(CODE + ".sendContractNext.sendContractNext", (Object)("tenantCode" + tenantCode + "contractBillcode" + contractBillcode));
        if (StringUtils.isEmpty((String)contractBillcode) || StringUtils.isEmpty((String)tenantCode)) {
            this.logger.error(CODE + ".sendContractNext.makesettllist", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractEngineService.sendContractNext(contractBillcode, tenantCode, null);
    }

    private void saveSettlList(final List<OcContractSettlDomain> settllist, final OcContractReDomain ocContractReDomain, final String tenantCode, final PtePtradeReDomain ptePtradeReDomain, final String contractBlance) {
        pool.execute(new Runnable(){

            @Override
            public void run() {
                if ("2".equals(contractBlance) || "3".equals(contractBlance)) {
                    ArrayList<OcContractSublistDomain> ocContractSublistDomainList = new ArrayList<OcContractSublistDomain>();
                    OcContractSubReDomain ocContractSubReDomain = PayCon.this.payService.getContractSub(tenantCode, ocContractReDomain.getContractBillcode());
                    if (null == ocContractSubReDomain) {
                        return;
                    }
                    for (OcContractSettlDomain ocContractSettlDomain : settllist) {
                        OcContractSublistDomain ocContractSublistDomain = new OcContractSublistDomain();
                        ocContractSublistDomain.setContractSublistGmoney(ocContractSettlDomain.getContractSettlGmoney());
                        ocContractSublistDomain.setContractSublistPmoney(ocContractSettlDomain.getContractSettlPmoney());
                        ocContractSublistDomain.setContractSublistOpemo(ocContractSettlDomain.getContractSettlOpemo());
                        ocContractSublistDomain.setContractSublistOpno(ocContractSettlDomain.getContractSettlOpno());
                        ocContractSublistDomain.setTenantCode(tenantCode);
                        ocContractSublistDomain.setContractBillcode(ocContractReDomain.getContractBillcode());
                        ocContractSublistDomain.setMemberName(ocContractSubReDomain.getMemberName());
                        ocContractSublistDomain.setMemberCode(ocContractSubReDomain.getMemberCode());
                        ocContractSublistDomain.setAppmanageIcode(ocContractSubReDomain.getAppmanageIcode());
                        ocContractSublistDomain.setContractSubCode(ocContractSubReDomain.getContractSubCode());
                        ocContractSublistDomainList.add(ocContractSublistDomain);
                    }
                    PayCon.this.payService.saveContractSublistBatch(ocContractSublistDomainList);
                } else {
                    ArrayList<OcContractSettlDomain> newSettllist = new ArrayList<OcContractSettlDomain>();
                    if (ListUtil.isNotEmpty((Collection)settllist)) {
                        newSettllist.addAll(settllist);
                    }
                    Map<String, OcContractSettlDomain> settlmap = PayCon.this.payService.queryContractSettl(ocContractReDomain.getContractBillcode(), tenantCode);
                    for (OcContractSettlDomain ocContractSettlDomain : newSettllist) {
                        OcContractSettlDomain oldOcContractSettlDomain;
                        ocContractSettlDomain.setTenantCode(tenantCode);
                        ocContractSettlDomain.setContractBillcode(ocContractReDomain.getContractBillcode());
                        ocContractSettlDomain.setMemberBcode(ptePtradeReDomain.getOpuserCode());
                        ocContractSettlDomain.setMemberBname(ptePtradeReDomain.getOpuserName());
                        ocContractSettlDomain.setMemberCode(ptePtradeReDomain.getMerchantCode());
                        if (null != ocContractReDomain.getContractType() && "80".equals(ocContractReDomain.getContractType())) {
                            if (null == ocContractReDomain.getContractPaymoney() || BigDecimal.ZERO.compareTo(ocContractReDomain.getContractPaymoney()) == 0) {
                                ocContractSettlDomain.setMemo("deposit");
                            } else {
                                ocContractSettlDomain.setMemo("tail");
                            }
                        }
                        if (null == settlmap || settlmap.isEmpty() || null == (oldOcContractSettlDomain = settlmap.get(ocContractSettlDomain.getContractSettlBlance()))) continue;
                        ocContractSettlDomain.setContractSettlId(oldOcContractSettlDomain.getContractSettlId());
                        ocContractSettlDomain.setAppmanageIcode(oldOcContractSettlDomain.getAppmanageIcode());
                        ocContractSettlDomain.setContractSettlBillcode(oldOcContractSettlDomain.getContractSettlBillcode());
                    }
                    PayCon.this.payService.saveContractSettlBatch(newSettllist);
                }
            }
        });
    }

    private OcContractSettlDomain make(PayCommit payCommit, String balance, String ptradeSeqno) {
        if (null == payCommit) {
            return null;
        }
        OcContractSettlDomain ocContractSettlDomain = new OcContractSettlDomain();
        ocContractSettlDomain.setContractSettlBlance(balance);
        ocContractSettlDomain.setContractSettlType("0");
        ocContractSettlDomain.setContractPmode("0");
        ocContractSettlDomain.setContractSettlGmoney(payCommit.getOrderAmount());
        ocContractSettlDomain.setContractSettlPmoney(payCommit.getOrderAmount());
        ocContractSettlDomain.setContractSettlOpno(ptradeSeqno);
        ocContractSettlDomain.setContractSettlOpemo(payCommit.getFchannelCode() + (StringUtils.isNotBlank((String)payCommit.getFchannelName()) ? "(" + payCommit.getFchannelName() + ")" : ""));
        return ocContractSettlDomain;
    }

    @ResponseBody
    @RequestMapping(value={"mockQjNotify.json"}, name="\u652f\u4ed8mock\uff08\u5343\u5320\u652f\u4ed8\uff09\u5f02\u6b65\u901a\u77e5\u652f\u4ed8\u7ed3\u679c")
    public String mockQjNotify(HttpServletRequest request) {
        String result;
        Map<String, Object> map = this.getQueryMapParams(request);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("trade_status", map.get("trade_status").toString());
        params.put("trade_no", map.get("trade_no").toString());
        params.put("out_trade_no", map.get("out_trade_no").toString());
        params.put("tenantCode", map.get("tenantCode").toString());
        params.put("exterface", "trade_status_sync");
        String notifyUrl = (String)map.get("notify_url");
        try {
            result = WebUtils.doPost((String)notifyUrl, params, (int)100000, (int)100000);
        }
        catch (IOException e) {
            this.logger.error(CODE + ".mockQjNotify.ex", (Throwable)e);
            return "\u53d1\u9001\u5931\u8d25";
        }
        if ("null".equals(result)) {
            return "ok";
        }
        this.logger.info(CODE + ".mockQjNotify.post.failure", (Object)result);
        return result;
    }

    public static String getCheck(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }
}

