/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.co;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.co.CoCorderDomain;
import cn.com.qj.bff.domain.co.CoCorderGoodsDomain;
import cn.com.qj.bff.domain.co.CoCorderGoodsReDomain;
import cn.com.qj.bff.domain.co.CoCorderReDomain;
import cn.com.qj.bff.domain.oc.OcShoppingGoodsDomain;
import cn.com.qj.bff.domain.um.UmUserinfoReDomainBean;
import cn.com.qj.bff.service.co.CoCorderService;
import cn.com.qj.bff.service.um.UserBaseService;
import cn.com.qj.bff.service.um.UserService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/co/corder"}, name="\u5408\u540c\u8ba2\u5355")
public class CorderCon
extends SpringmvcController {
    private static String CODE = "co.corder.con";
    @Autowired
    private CoCorderService coCorderService;
    @Autowired
    private UserBaseService userBaseService;
    @Autowired
    UserService userService;

    @Override
    protected String getContext() {
        return "corder";
    }

    @RequestMapping(value={"saveCorder.json"}, name="\u589e\u52a0\u5408\u540c\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean saveCorder(HttpServletRequest request, CoCorderDomain coCorderDomain) {
        if (null == coCorderDomain) {
            this.logger.error(CODE + ".saveCorder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        coCorderDomain.setTenantCode(this.getTenantCode(request));
        return this.coCorderService.saveCorder(coCorderDomain);
    }

    @RequestMapping(value={"getCorder.json"}, name="\u83b7\u53d6\u5408\u540c\u8ba2\u5355\u4fe1\u606f")
    @ResponseBody
    public CoCorderReDomain getCorder(Integer corderId) {
        if (StringUtils.isBlank((Integer)corderId)) {
            this.logger.error(CODE + ".getCorder", (Object)"param is null");
            return null;
        }
        return this.coCorderService.getCorder(corderId);
    }

    @RequestMapping(value={"updateCorder.json"}, name="\u66f4\u65b0\u5408\u540c\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean updateCorder(HttpServletRequest request, CoCorderDomain coCorderDomain) {
        if (null == coCorderDomain) {
            this.logger.error(CODE + ".updateCorder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        coCorderDomain.setTenantCode(this.getTenantCode(request));
        return this.coCorderService.updateCorder(coCorderDomain);
    }

    @RequestMapping(value={"deleteCorder.json"}, name="\u5220\u9664\u5408\u540c\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean deleteCorder(Integer corderId) {
        if (StringUtils.isBlank((Integer)corderId)) {
            this.logger.error(CODE + ".deleteCorder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.coCorderService.deleteCorder(corderId);
    }

    @RequestMapping(value={"queryCorderPage.json"}, name="\u67e5\u8be2\u5408\u540c\u8ba2\u5355\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CoCorderReDomain> queryCorderPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.coCorderService.queryCorderPage(param);
    }

    @RequestMapping(value={"updateCorderState.json"}, name="\u66f4\u65b0\u5408\u540c\u8ba2\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateCorderState(String corderId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)corderId)) {
            this.logger.error(CODE + ".updateCorderState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.coCorderService.updateCorderState(Integer.valueOf(corderId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"downLoadFile.json"}, name="\u4e0b\u8f7d\u6587\u4ef6")
    @ResponseBody
    public ResponseEntity<byte[]> downLoadFile(String fileName) {
        if (null == fileName) {
            this.logger.error(CODE + ".fileName", (Object)"param is null");
            return null;
        }
        return this.coCorderService.downLoadFile(fileName);
    }

    @RequestMapping(value={"saveCorderStr.json"}, name="\u589e\u52a0\u5408\u540c\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean saveCorderStr(HttpServletRequest request, String coCorderDomainStr) {
        CoCorderReDomain coCorderDomain = (CoCorderReDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(coCorderDomainStr, CoCorderReDomain.class);
        if (null == coCorderDomain) {
            this.logger.error(CODE + ".saveCorderStr", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        coCorderDomain.setMemberBcode(userSession.getUserPcode());
        coCorderDomain.setMemberBname(userSession.getMerberCompname());
        String channelCodec = this.getDisChannelCode(request);
        coCorderDomain.setChannelCode(channelCodec);
        if (ListUtil.isNotEmpty(coCorderDomain.getCoCorderGoodsReDomainList())) {
            List<CoCorderGoodsReDomain> reDomains = coCorderDomain.getCoCorderGoodsReDomainList();
            for (CoCorderGoodsReDomain reDomain : reDomains) {
                reDomain.setChannelCode(channelCodec);
            }
        } else if (ListUtil.isNotEmpty(coCorderDomain.getCoCorderGoodsDomainList())) {
            List<CoCorderGoodsDomain> domains = coCorderDomain.getCoCorderGoodsDomainList();
            for (CoCorderGoodsDomain domain : domains) {
                domain.setChannelCode(channelCodec);
            }
        }
        coCorderDomain.setTenantCode(this.getTenantCode(request));
        return this.coCorderService.saveCorderStr(coCorderDomain);
    }

    @RequestMapping(value={"saveCorderForShoppingGoods.json"}, name="\u4ece\u8d2d\u7269\u8f66\u589e\u52a0\u5408\u540c\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean saveCorderForShoppingGoods(HttpServletRequest request, String shppinGoodsListStr) {
        List ocShoppingGoodsDomainList = JsonUtil.buildNonDefaultBinder().getJsonToList(shppinGoodsListStr, OcShoppingGoodsDomain.class);
        HashSet<String> set = new HashSet<String>();
        set.add("1");
        set.add("2");
        set.add("3");
        if (null == ocShoppingGoodsDomainList) {
            this.logger.error(CODE + ".saveCorderForShoppingGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ArrayList<CoCorderDomain> coCorderDomainList = new ArrayList<CoCorderDomain>();
        Map<String, List<OcShoppingGoodsDomain>> collect = ocShoppingGoodsDomainList.stream().collect(Collectors.groupingBy(OcShoppingGoodsDomain::getGoodsProperty));
        for (String key : collect.keySet()) {
            if (!set.contains(key)) continue;
            CoCorderReDomain coCorderDomain = new CoCorderReDomain();
            HtmlJsonReBean htmlJsonReBeanR = this.initCorderDomain(request, coCorderDomain);
            if (!htmlJsonReBeanR.isSuccess()) {
                return htmlJsonReBeanR;
            }
            coCorderDomain.setContractProperty(key);
            ArrayList<CoCorderGoodsDomain> coCorderGoodsDomainList = new ArrayList<CoCorderGoodsDomain>();
            for (int i = 0; i < collect.get(key).size(); ++i) {
                OcShoppingGoodsDomain ocShoppingGoodsDomain = collect.get(key).get(i);
                CoCorderGoodsDomain coCorderGoodsDomain = this.initCorderGoodsDomain(request, ocShoppingGoodsDomain);
                coCorderGoodsDomainList.add(coCorderGoodsDomain);
                if (!"3".equals(key)) continue;
                coCorderGoodsDomain.setSkuNo("DZ01");
            }
            coCorderDomain.setCoCorderGoodsDomainList(coCorderGoodsDomainList);
            coCorderDomainList.add(coCorderDomain);
        }
        this.logger.info(CODE + ".saveCorderForShoppingGoods::", (Object)JsonUtil.buildNonDefaultBinder().toJson(coCorderDomainList));
        return this.coCorderService.saveCorderBatch(coCorderDomainList);
    }

    private CoCorderGoodsDomain initCorderGoodsDomain(HttpServletRequest request, OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        CoCorderGoodsDomain coCorderGoodsDomain = new CoCorderGoodsDomain();
        UserSession userSession = this.getUserSession(request);
        try {
            BeanUtils.copyAllPropertys((Object)coCorderGoodsDomain, (Object)ocShoppingGoodsDomain);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".saveCorderForShoppingGoods.initCorderGoodsDomain", (Object)("\u5c5e\u6027\u62f7\u8d1d." + e));
            throw new RuntimeException(e);
        }
        coCorderGoodsDomain.setContractGoodsCode(ocShoppingGoodsDomain.getShoppingGoodsCode());
        coCorderGoodsDomain.setDataOpbillstate(0);
        coCorderGoodsDomain.setChannelCode(this.getDisChannelCode(request));
        coCorderGoodsDomain.setTenantCode(this.getTenantCode(request));
        return coCorderGoodsDomain;
    }

    private HtmlJsonReBean initCorderDomain(HttpServletRequest request, CoCorderDomain corderdDomain) {
        UserSession userSession = this.getUserSession(request);
        corderdDomain.setMemberBcode(userSession.getUserPcode());
        corderdDomain.setMemberBname(userSession.getMerberCompname());
        corderdDomain.setChannelCode(this.getDisChannelCode(request));
        corderdDomain.setTenantCode(this.getTenantCode(request));
        corderdDomain.setContractAppraise(0);
        corderdDomain.setCorderSdate(new Date());
        UmUserinfoReDomainBean userinfo = this.userService.getUserInfoByUserinfoCode(userSession.getUserPcode(), this.getTenantCode(request));
        if (null == userinfo) {
            this.logger.error(CODE + ".saveCorderForShoppingGoods.initCorder", (Object)"userInfo is null");
            return new HtmlJsonReBean(null, "userInfo is null");
        }
        String employeeCode = userinfo.getEmployeeCode();
        String employeeName = userinfo.getEmployeeName();
        String goodsSupplierCode = userinfo.getUserinfoDiscode();
        String goodsSupplierName = userinfo.getUserinfoDisname();
        if (StringUtils.isBlank((String)employeeCode)) {
            this.logger.error(CODE + ".saveCorderForShoppingGoods.initCorder", (Object)"EmployeeCode is null");
            return new HtmlJsonReBean(null, "EmployeeCode is null");
        }
        corderdDomain.setEmployeeCode(employeeCode);
        corderdDomain.setEmployeeName(employeeName);
        corderdDomain.setGoodsSupplierCode(goodsSupplierCode);
        corderdDomain.setGoodsSupplierName(goodsSupplierName);
        corderdDomain.setAreaCode(userinfo.getCityCode());
        corderdDomain.setAreaName(userinfo.getCityName());
        corderdDomain.setCoCorderGoodsDomainList(new ArrayList<CoCorderGoodsDomain>());
        return new HtmlJsonReBean((Object)corderdDomain);
    }
}

