/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.version;

import cn.com.qj.bff.controller.version.UserManager;
import com.offbytwo.jenkins.JenkinsServer;
import com.offbytwo.jenkins.client.JenkinsHttpClient;
import com.offbytwo.jenkins.client.JenkinsHttpConnection;
import com.offbytwo.jenkins.model.Build;
import com.offbytwo.jenkins.model.BuildResult;
import com.offbytwo.jenkins.model.JobWithDetails;
import com.offbytwo.jenkins.model.QueueItem;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.http.message.BasicNameValuePair;

public class JenkinsUtils
extends JenkinsServer {
    private URI serverUri;
    private final JenkinsHttpConnection client;
    private String userName;
    private String passwordOrToken;

    public JenkinsUtils(URI serverUri, String username, String passwordOrToken) {
        this((JenkinsHttpConnection)new JenkinsHttpClient(serverUri, username, passwordOrToken));
        this.passwordOrToken = passwordOrToken;
        this.userName = username;
    }

    public JenkinsUtils(URI serverUri) {
        this((JenkinsHttpConnection)new JenkinsHttpClient(serverUri));
        this.serverUri = serverUri;
    }

    public JenkinsUtils(JenkinsHttpConnection client) {
        super(client);
        this.client = client;
    }

    public URI getServerUri() {
        return this.serverUri;
    }

    public JenkinsHttpConnection getClient() {
        return this.client;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPasswordOrToken() {
        return this.passwordOrToken;
    }

    public String toString() {
        return "JenkinsUtils [serverUri=" + this.serverUri + ", client=" + this.client + ", userName=" + this.userName + ", passwordOrToken=" + this.passwordOrToken + "]";
    }

    public String getJobConsoleOutputText(String jobName, int buildNumber) {
        String resq = null;
        if (super.isRunning() && !jobName.equals("") && null != jobName) {
            JobWithDetails job = null;
            JobWithDetails jobWithDetails = null;
            try {
                job = super.getJob(jobName);
            }
            catch (IOException e) {
                e.printStackTrace();
                return resq;
            }
            try {
                jobWithDetails = job.details();
            }
            catch (IOException e) {
                e.printStackTrace();
                return resq;
            }
            try {
                resq = buildNumber < 1 ? jobWithDetails.getLastBuild().details().getConsoleOutputText() : jobWithDetails.getBuildByNumber(buildNumber).details().getConsoleOutputText();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return resq;
        }
        return resq;
    }

    @Deprecated
    public String getJobConsoleOutString(String jobName, Integer buildNumber) {
        String consoleText = null;
        if (jobName != null && !jobName.equals("") && buildNumber > 0) {
            try {
                JobWithDetails job = super.getJob(jobName);
                String url = job.getUrl();
                String consoleUrl = url + buildNumber + "/consoleText";
                consoleText = job.getClient().get(consoleUrl);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return consoleText;
    }

    public String getJobLastConsoleOutputText(String jobName) {
        return this.getJobConsoleOutputText(jobName, -1);
    }

    public Integer getJobLastBuildNumber(String jobName) {
        Integer lastBuildNumber = 0;
        if (null != jobName && !lastBuildNumber.equals("")) {
            try {
                lastBuildNumber = super.getJob(jobName).getLastBuild().getNumber();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return lastBuildNumber;
    }

    public BuildResult getJobBuildResult(String jobName, int number) {
        BuildResult result = null;
        if (jobName == null || jobName.equals("")) {
            return result;
        }
        if (number > 0) {
            try {
                result = super.getJob(jobName).getBuildByNumber(number).details().getResult();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                result = super.getJob(jobName).getLastBuild().details().getResult();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public BuildResult getJobBuildResult(String jobName) {
        return this.getJobBuildResult(jobName, -1);
    }

    public Integer getJobLastBuildFaileNumber(String jobName) {
        if (null != jobName && !jobName.equals("")) {
            try {
                return super.getJob(jobName).getLastFailedBuild().getNumber();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public boolean clearJobWorkSpace(String jobName, String crumb) {
        boolean TF = false;
        try {
            String url = super.getJob(jobName).getUrl();
            JobWithDetails job = super.getJob(jobName);
            job.getClient().post(url + "/doWipeOutWorkspace", (Object)new HashMap<String, String>().put("Jenkins-Crumb", crumb), null);
            return TF;
        }
        catch (IOException e) {
            e.printStackTrace();
            return TF;
        }
    }

    public UserManager getUserManager() {
        UserManager userManager = null;
        ArrayList<Map<String, String>> userBasicInfo = new ArrayList<Map<String, String>>();
        JSONObject json = null;
        try {
            json = JSONObject.fromObject((Object)this.client.get("/asynchPeople/api/json?pretty=true"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONArray userInfoArr = JSONArray.fromObject((Object)JSONArray.fromObject((Object)json.get("users")));
        JSONArray userInfo = null;
        for (int i = 0; i < userInfoArr.size(); ++i) {
            userInfo = JSONArray.fromObject((Object)userInfoArr.get(i));
            userBasicInfo.add((Map<String, String>)JSONObject.fromObject((Object)JSONObject.fromObject((Object)userInfo.get(0)).get("user")));
        }
        userManager = new UserManager("/asynchPeople/api/json?pretty=true", userBasicInfo);
        userManager.setClient(this.client);
        return userManager;
    }

    public int getJobInBuildQueueCount(String jobName) {
        int count = 0;
        if (null == jobName || jobName.equals("")) {
            return count;
        }
        try {
            List queue = super.getQueue().getItems();
            Iterator iterator = queue.iterator();
            QueueItem queueItem = null;
            while (iterator.hasNext()) {
                queueItem = (QueueItem)iterator.next();
                if (!queueItem.getTask().getName().equals(jobName)) continue;
                ++count;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
        return count;
    }

    public int getJobInBuildQueueCount() {
        try {
            return super.getQueue().getItems().size();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean isJobParamRun(String jobName, BasicNameValuePair param) {
        if (null == jobName || jobName.equals("")) {
            return false;
        }
        String paramsKv = String.valueOf(param);
        try {
            List queue = super.getQueue().getItems();
            Iterator iterator = queue.iterator();
            QueueItem queueItem = null;
            while (iterator.hasNext()) {
                queueItem = (QueueItem)iterator.next();
                System.err.println(queueItem.getParams());
                if (!queueItem.getTask().getName().equals(jobName) || !paramsKv.trim().equals(queueItem.getParams().trim())) continue;
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public boolean isJobRun(String jobName) {
        if (null == jobName || jobName.equals("")) {
            return false;
        }
        try {
            List queue = super.getQueue().getItems();
            Iterator iterator = queue.iterator();
            QueueItem queueItem = null;
            while (iterator.hasNext()) {
                queueItem = (QueueItem)iterator.next();
                System.err.println(queueItem.getParams());
                if (!queueItem.getTask().getName().equals(jobName)) continue;
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public boolean isJobParamRun(String jobName, List<BasicNameValuePair> param) {
        if (null == jobName || jobName.equals("") || 0 == param.size()) {
            return false;
        }
        String paramsKv = "";
        Iterator<BasicNameValuePair> paramIterator = param.iterator();
        while (paramIterator.hasNext()) {
            paramsKv = paramsKv + String.valueOf(paramIterator.next());
        }
        try {
            List queue = super.getQueue().getItems();
            Iterator iterator = queue.iterator();
            QueueItem queueItem = null;
            while (iterator.hasNext()) {
                queueItem = (QueueItem)iterator.next();
                if (!queueItem.getTask().getName().equals(jobName) || !paramsKv.trim().equals(queueItem.getParams().replace("\n", "").trim())) continue;
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public int getBuildJobInQueueSerialNumber(String jobName, List<BasicNameValuePair> param) {
        int number = 0;
        String paramsKv = "";
        if (null == jobName || jobName.equals("")) {
            return 0;
        }
        if (null != param) {
            Iterator<BasicNameValuePair> paramIterator = param.iterator();
            while (paramIterator.hasNext()) {
                paramsKv = paramsKv + String.valueOf(paramIterator.next());
            }
        }
        try {
            List queue = super.getQueue().getItems();
            Iterator iterator = queue.iterator();
            QueueItem queueItem = null;
            while (iterator.hasNext()) {
                queueItem = (QueueItem)iterator.next();
                if (!queueItem.getTask().getName().equals(jobName)) continue;
                ++number;
                if (!paramsKv.trim().equals(queueItem.getParams().replace("\n", "").trim())) continue;
                return number;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
        return number;
    }

    public int getBuildJobInQueueSerialNumber(String jobName) {
        int number = 0;
        if (null == jobName || jobName.equals("")) {
            return 0;
        }
        try {
            List queue = super.getQueue().getItems();
            Iterator iterator = queue.iterator();
            QueueItem queueItem = null;
            while (iterator.hasNext()) {
                queueItem = (QueueItem)iterator.next();
                if (!queueItem.getTask().getName().equals(jobName)) continue;
                ++number;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
        return number;
    }

    public int getPredictionsNumber(String jobName, List<BasicNameValuePair> param) {
        if (null == jobName || jobName.equals("")) {
            return 0;
        }
        int number = 0;
        try {
            Build lastBuild = super.getJob(jobName).getLastBuild();
            number += lastBuild.getNumber();
            int buildJobInQueueSerialNumber = this.getBuildJobInQueueSerialNumber(jobName, param);
            number = 0 != buildJobInQueueSerialNumber ? (number += buildJobInQueueSerialNumber) : ++number;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return number;
    }
}

