/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.eq;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.eq.DataState;
import cn.com.qj.bff.domain.eq.EqAuctionEnrollDomain;
import cn.com.qj.bff.domain.eq.EqAuctionEnrollReDomain;
import cn.com.qj.bff.domain.eq.EqAuctionGoodsDomain;
import cn.com.qj.bff.domain.eq.TransferState;
import cn.com.qj.bff.domain.rs.RsSkuReDomain;
import cn.com.qj.bff.domain.um.MemQua;
import cn.com.qj.bff.domain.um.UmUserinfoReDomainBean;
import cn.com.qj.bff.service.eq.EqAuctionEnrollServiceRepository;
import cn.com.qj.bff.service.eq.EqAuctionGoodsServiceRepository;
import cn.com.qj.bff.service.rs.RsSkuService;
import cn.com.qj.bff.service.um.UserService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import cn.hutool.core.collection.CollectionUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/web/eq/eqAuctionEnroll"}, name="\u62a5\u4ef7\u5355")
public class EqAuctionEnrollCon
extends SpringmvcController {
    @Autowired
    private EqAuctionEnrollServiceRepository eqAuctionEnrollServiceRepository;
    @Autowired
    private EqAuctionGoodsServiceRepository eqAuctionGoodsServiceRepository;
    @Autowired
    private RsSkuService rsSkuService;
    @Autowired
    private UserService userService;

    @Override
    protected String getContext() {
        return "eqAuctionEnroll";
    }

    @RequestMapping(value={"createEqAuctionEnroll.json"}, name="\u6dfb\u52a0\u62a5\u4ef7\u5355")
    @ResponseBody
    public HtmlJsonReBean createEqAuctionEnroll(HttpServletRequest request, String eqAuctionEnrollStr) {
        String FUNC_CODE = "createEqAuctionEnroll ----> ";
        this.logger.error("createEqAuctionEnroll ----> ", (Object)"start");
        this.logger.error("createEqAuctionEnroll ----> eqAuctionEnrollStr", (Object)eqAuctionEnrollStr);
        if (StringUtils.isBlank((String)eqAuctionEnrollStr)) {
            return new HtmlJsonReBean("error", "param eqAuctionEnrollStr is required but null");
        }
        EqAuctionEnrollReDomain eqAuctionEnroll = (EqAuctionEnrollReDomain)JsonUtil.buildNormalBinder().getJsonToObject(eqAuctionEnrollStr, EqAuctionEnrollReDomain.class);
        this.logger.error("createEqAuctionEnroll ----> eqAuctionEnroll", (Object)JsonUtil.buildNonNullBinder().toJson((Object)eqAuctionEnroll));
        if (eqAuctionEnroll == null) {
            return new HtmlJsonReBean("error", "json serialization error");
        }
        if (eqAuctionEnroll.getAuctionEdate().before(new Date())) {
            return new HtmlJsonReBean("error", "The auction end time of the bidding cannot be less than the current time");
        }
        UserSession userSession = this.getUserSession(request);
        eqAuctionEnroll.setTenantCode(userSession.getTenantCode());
        eqAuctionEnroll.setMemberBcode(userSession.getUserPcode());
        eqAuctionEnroll.setMemberBname(userSession.getMerberCompname());
        eqAuctionEnroll.setParentCode("0");
        eqAuctionEnroll.setAuctionEnrollType("1");
        eqAuctionEnroll.setChannelCode(this.getChannelCode(request));
        if (eqAuctionEnroll.getEqAuctionGoodsDomainList() != null) {
            for (EqAuctionGoodsDomain target : eqAuctionEnroll.getEqAuctionGoodsDomainList()) {
                String skuCode = target.getSkuCode();
                if (StringUtils.isBlank((String)skuCode)) {
                    return new HtmlJsonReBean((Object)"skuCode is empty");
                }
                HashMap<String, Object> dParam = new HashMap<String, Object>();
                dParam.put("tenantCode", this.getTenantCode(request));
                dParam.put("skuCode", skuCode);
                this.logger.error("createEqAuctionEnroll ----> getSkuByCode", dParam);
                RsSkuReDomain skuByCode = this.rsSkuService.getSkuByCode(dParam);
                this.logger.error("createEqAuctionEnroll ----> skuByCode", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)skuByCode));
                if (skuByCode == null) {
                    return new HtmlJsonReBean((Object)String.format("sku of skuCode(%s) is not exists", skuCode));
                }
                BigDecimal goodsNum = target.getGoodsNum();
                String goodsWebremark = target.getGoodsWebremark();
                BeanUtils.copyProperties((Object)skuByCode, (Object)target);
                target.setGoodsNum(goodsNum);
                target.setGoodsWebremark(goodsWebremark);
                target.setGoodsSpec1(skuByCode.getSkuName());
            }
        }
        List<EqAuctionEnrollDomain> eqAuctionEnrollDomainList = this.splitEqAuctionEnroll(eqAuctionEnroll);
        return this.eqAuctionEnrollServiceRepository.saveAuctionEnrollBatch(eqAuctionEnrollDomainList);
    }

    private List<EqAuctionEnrollDomain> splitEqAuctionEnroll(EqAuctionEnrollReDomain eqAuctionEnroll) {
        ArrayList<EqAuctionEnrollDomain> eqAuctionEnrollDomainList = new ArrayList<EqAuctionEnrollDomain>();
        ArrayList<EqAuctionGoodsDomain> merchantEqAuctionGoodsDomainList = new ArrayList<EqAuctionGoodsDomain>();
        ArrayList<EqAuctionGoodsDomain> platformEqAuctionGoodsDomainList = new ArrayList<EqAuctionGoodsDomain>();
        eqAuctionEnroll.setMemberCode(null);
        eqAuctionEnroll.setTransferState(TransferState.NOT_TRANSFERRED.getCode());
        boolean hasSupplierGoodsDomain = Boolean.FALSE;
        for (EqAuctionGoodsDomain eqAuctionGoodsDomain : eqAuctionEnroll.getEqAuctionGoodsDomainList()) {
            String memberCode = eqAuctionGoodsDomain.getMemberCode();
            String string = eqAuctionGoodsDomain.getTenantCode();
            UmUserinfoReDomainBean umUserinfoReDomainBean = this.userService.getUserInfoByUserinfoCode(memberCode, string);
            if (MemQua.MERCHANT.getCode().equals(umUserinfoReDomainBean.getUserinfoQuality())) {
                merchantEqAuctionGoodsDomainList.add(eqAuctionGoodsDomain);
                continue;
            }
            if (MemQua.SUPPLIER.getCode().equals(umUserinfoReDomainBean.getUserinfoQuality())) {
                hasSupplierGoodsDomain = Boolean.TRUE;
            }
            platformEqAuctionGoodsDomainList.add(eqAuctionGoodsDomain);
        }
        boolean used = Boolean.FALSE;
        if (CollectionUtil.isNotEmpty(merchantEqAuctionGoodsDomainList)) {
            HashMap<String, List> eqAuctionGoodsDomainMap = new HashMap<String, List>();
            for (EqAuctionGoodsDomain eqAuctionGoodsDomain : merchantEqAuctionGoodsDomainList) {
                List goodsList = eqAuctionGoodsDomainMap.computeIfAbsent(eqAuctionGoodsDomain.getMemberCode(), k -> new ArrayList());
                goodsList.add(eqAuctionGoodsDomain);
            }
            for (Map.Entry entry : eqAuctionGoodsDomainMap.entrySet()) {
                EqAuctionEnrollDomain target = new EqAuctionEnrollDomain();
                BeanUtils.copyProperties((Object)eqAuctionEnroll, (Object)target);
                target.setParentCode("0");
                if (used) {
                    target.setAuctionEnrollId(null);
                    target.setAuctionEnrollCode(null);
                }
                String memberCode = (String)entry.getKey();
                target.setMemberCode(memberCode);
                target.setEqAuctionGoodsDomainList((List)entry.getValue());
                target.setTransferState(TransferState.TRANSFERRED.getCode());
                eqAuctionEnrollDomainList.add(target);
                used = Boolean.TRUE;
            }
        }
        if (CollectionUtil.isNotEmpty(platformEqAuctionGoodsDomainList)) {
            EqAuctionEnrollDomain target = new EqAuctionEnrollDomain();
            BeanUtils.copyProperties((Object)eqAuctionEnroll, (Object)target);
            target.setParentCode("0");
            if (used) {
                target.setAuctionEnrollId(null);
                target.setAuctionEnrollCode(null);
            }
            if (hasSupplierGoodsDomain) {
                target.setTransferState(TransferState.WAITING_TRANSFERRED.getCode());
            }
            target.setEqAuctionGoodsDomainList(platformEqAuctionGoodsDomainList);
            eqAuctionEnrollDomainList.add(target);
        }
        return eqAuctionEnrollDomainList;
    }

    @RequestMapping(value={"queryEqAuctionEnrollPage.json"}, name="\u67e5\u8be2\u62a5\u4ef7\u5355")
    @ResponseBody
    public SupQueryResult<EqAuctionEnrollReDomain> queryEqAuctionEnrollPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            UserSession userSession = this.getUserSession(request);
            param.put("tenantCode", userSession.getTenantCode());
            param.put("memberBcode", userSession.getUserPcode());
            param.put("auctionEnrollType", "1");
        }
        return this.eqAuctionEnrollServiceRepository.queryAuctionEnrollPage(param);
    }

    @RequestMapping(value={"queryEqAuctionGoodsPage.json"}, name="\u67e5\u8be2\u62a5\u4ef7\u5355\u5546\u54c1")
    @ResponseBody
    public SupQueryResult<EqAuctionGoodsDomain> queryEqAuctionGoodsPage(HttpServletRequest request, String auctionEnrollCode) {
        String FUNC_CODE = "queryEqAuctionGoodsPage ----> ";
        this.logger.error("queryEqAuctionGoodsPage ----> ", (Object)"start");
        this.logger.error("queryEqAuctionGoodsPage ----> auctionEnrollCode", (Object)auctionEnrollCode);
        if (StringUtils.isBlank((String)auctionEnrollCode)) {
            return new SupQueryResult();
        }
        Map<String, Object> map = this.assemMapParam(request);
        this.logger.error("queryEqAuctionGoodsPage ----> map", map);
        if (map == null) {
            return new SupQueryResult();
        }
        map.put("tenantCode", this.getTenantCode(request));
        map.put("auctionEnrollCode", auctionEnrollCode);
        return this.eqAuctionGoodsServiceRepository.queryAuctionGoodsPage(map);
    }

    @RequestMapping(value={"updateEqAuctionEnrollState.json"}, name="\u66f4\u65b0\u62a5\u4ef7\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateEqAuctionEnrollState(HttpServletRequest request, String auctionEnrollCode, Integer oldDataState, Integer newDataState) {
        String FUNC_CODE = "updateEqAuctionEnrollState ----> ";
        this.logger.error("updateEqAuctionEnrollState ----> start", (Object)String.format("auctionEnrollCode: %s, oldDataState: %d, newDataState: %d", auctionEnrollCode, oldDataState, newDataState));
        if (StringUtils.isBlank((String)auctionEnrollCode)) {
            return new HtmlJsonReBean("error", "auctionEnrollCode is required but is empty");
        }
        if (oldDataState == null) {
            return new HtmlJsonReBean("error", "oldDataState is required but is empty");
        }
        if (newDataState == null) {
            return new HtmlJsonReBean("error", "newDataState is required but is empty");
        }
        EqAuctionEnrollReDomain eqAuctionEnroll = this.eqAuctionEnrollServiceRepository.getAuctionEnrollByCode(this.getTenantCode(request), auctionEnrollCode);
        if (eqAuctionEnroll == null) {
            return new HtmlJsonReBean("error", "auctionEnrollCode not found");
        }
        if (DataState.DATASTATE_MINUS_TWO.getCode().equals(eqAuctionEnroll.getDataState()) || DataState.DATASTATE_MINUS_ONE.getCode().equals(eqAuctionEnroll.getDataState())) {
            return new HtmlJsonReBean("error", "The auction state is not available");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (1 == newDataState) {
            map.put("auctionAudit", new Date());
        }
        return this.eqAuctionEnrollServiceRepository.updateAuctionEnrollStateByCode(this.getTenantCode(request), auctionEnrollCode, newDataState, oldDataState, map);
    }

    @RequestMapping(value={"readEqAuctionEnroll.json"}, name="\u67e5\u770b\u62a5\u4ef7\u5355")
    @ResponseBody
    public HtmlJsonReBean readEqAuctionEnroll(HttpServletRequest request, String auctionEnrollCode) {
        if (StringUtils.isBlank((String)auctionEnrollCode)) {
            return new HtmlJsonReBean("error", "auctionEnrollCode is required but is empty");
        }
        EqAuctionEnrollReDomain auctionEnrollByCode = this.eqAuctionEnrollServiceRepository.getAuctionEnrollByCode(this.getTenantCode(request), auctionEnrollCode);
        return new HtmlJsonReBean((Object)auctionEnrollByCode);
    }

    @RequestMapping(value={"updateEqAuctionEnroll.json"}, name="\u66f4\u65b0\u62a5\u4ef7\u5355(\u66f4\u65b0\u5546\u54c1)")
    @ResponseBody
    public HtmlJsonReBean updateEqAuctionEnroll(HttpServletRequest request, String eqAuctionEnrollStr) {
        String FUNC_CODE = "addEqAuctionGoods ----> ";
        this.logger.error("addEqAuctionGoods ----> ", (Object)"start");
        this.logger.error("addEqAuctionGoods ----> eqAuctionEnrollStr", (Object)eqAuctionEnrollStr);
        if (StringUtils.isBlank((String)eqAuctionEnrollStr)) {
            return new HtmlJsonReBean("error", "param eqAuctionEnrollStr is required but is empty");
        }
        EqAuctionEnrollReDomain eqAuctionEnroll = (EqAuctionEnrollReDomain)JsonUtil.buildNormalBinder().getJsonToObject(eqAuctionEnrollStr, EqAuctionEnrollReDomain.class);
        this.logger.error("addEqAuctionGoods ----> eqAuctionEnroll", (Object)JsonUtil.buildNonNullBinder().toJson((Object)eqAuctionEnroll));
        if (eqAuctionEnroll == null) {
            return new HtmlJsonReBean("error", "json serialization error");
        }
        if (eqAuctionEnroll.getAuctionEnrollCode() == null) {
            return new HtmlJsonReBean("error", "param eqAuctionEnrollStr.auctionEnrollCode is required but is null");
        }
        List<EqAuctionEnrollDomain> eqAuctionEnrollDomainList = this.splitEqAuctionEnroll(eqAuctionEnroll);
        ArrayList<EqAuctionEnrollDomain> createEqAuctionEnrollDomainList = new ArrayList<EqAuctionEnrollDomain>();
        eqAuctionEnrollDomainList.forEach(eqAuctionEnrollDomain -> {
            if (StringUtils.isBlank((String)eqAuctionEnrollDomain.getAuctionEnrollCode())) {
                createEqAuctionEnrollDomainList.add((EqAuctionEnrollDomain)eqAuctionEnrollDomain);
            } else {
                this.eqAuctionEnrollServiceRepository.updateAuctionEnroll(eqAuctionEnroll);
            }
        });
        if (CollectionUtils.isNotEmpty(createEqAuctionEnrollDomainList)) {
            this.eqAuctionEnrollServiceRepository.saveAuctionEnrollBatch(createEqAuctionEnrollDomainList);
        }
        return new HtmlJsonReBean((Object)"success");
    }

    @RequestMapping(value={"deleteAuctionEnrollByCode.json"}, name="\u5220\u9664\u62a5\u4ef7\u5355")
    @ResponseBody
    public HtmlJsonReBean deleteAuctionEnrollByCode(HttpServletRequest request, String auctionEnrollCode) {
        UserSession userSession = this.getUserSession(request);
        EqAuctionEnrollReDomain auctionEnrollByCode = this.eqAuctionEnrollServiceRepository.getAuctionEnrollByCode(userSession.getTenantCode(), auctionEnrollCode);
        if (null == auctionEnrollByCode) {
            return new HtmlJsonReBean("error", "\u53c2\u6570\u9519\u8bef\uff01");
        }
        if (!auctionEnrollByCode.getMemberBcode().equals(userSession.getUserPcode())) {
            return new HtmlJsonReBean("error", "\u6743\u9650\u9519\u8bef\uff01");
        }
        return this.eqAuctionEnrollServiceRepository.deleteAuctionEnrollByCode(userSession.getTenantCode(), auctionEnrollCode);
    }
}

