/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.order;

import cn.com.qj.bff.controller.es.SearchengineCon;
import cn.com.qj.bff.controller.order.ShoppingComCon;
import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.eq.EqAuctionGoodsDomain;
import cn.com.qj.bff.domain.oc.GoodsBean;
import cn.com.qj.bff.domain.oc.OcContractDomain;
import cn.com.qj.bff.domain.oc.OcContractSettlDomain;
import cn.com.qj.bff.domain.oc.OcShoppingDomain;
import cn.com.qj.bff.domain.oc.OcShoppingGoodsDomain;
import cn.com.qj.bff.domain.oc.OcShoppingGoodsReDomain;
import cn.com.qj.bff.domain.oc.OcShoppingReDomain;
import cn.com.qj.bff.domain.oc.OcShoppingSkuDomain;
import cn.com.qj.bff.domain.oc.RsSkuDomain;
import cn.com.qj.bff.domain.order.AppImportGoodsListDomian;
import cn.com.qj.bff.domain.order.GoodsBeanDomain;
import cn.com.qj.bff.domain.rs.RsSkuReDomain;
import cn.com.qj.bff.service.eq.EqAuctionGoodsServiceRepository;
import cn.com.qj.bff.service.rs.RsSkuService;
import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/shopping"}, name="\u7528\u6237\u7aef\u8d2d\u7269\u8f66\u670d\u52a1")
public class ShoppingCon
extends ShoppingComCon {
    @Autowired
    private SearchengineCon searchengineCon;
    @Autowired
    private EqAuctionGoodsServiceRepository eqAuctionGoodsServiceRepository;
    @Autowired
    private RsSkuService rsSkuService;
    private static String CODE = "oc.shopping.con";

    @Override
    protected String getContext() {
        return "shopping";
    }

    @RequestMapping(value={"querySkuToContract.json"}, name="\u62a5\u4ef7\u5355\u76f4\u63a5\u7ed3\u7b97\u9875\u9762")
    @ResponseBody
    public HtmlJsonReBean querySkuToContract(HttpServletRequest request, String auctionEnrollCode) {
        if (StringUtils.isBlank((String)auctionEnrollCode)) {
            this.logger.error(CODE + ".queryToContract", (Object)"auctionEnrollCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        ArrayList<OcShoppingSkuDomain> ocShoppingSkuDomains = new ArrayList<OcShoppingSkuDomain>();
        ArrayList ocShoppingReDomainList = new ArrayList();
        HashMap<String, Object> GoodsMap = new HashMap<String, Object>();
        GoodsMap.put("auctionEnrollCode", auctionEnrollCode);
        GoodsMap.put("tenantCode", tenantCode);
        GoodsMap.put("fuzzy", false);
        SupQueryResult<EqAuctionGoodsDomain> supQueryResult = this.eqAuctionGoodsServiceRepository.queryAuctionGoodsPage(GoodsMap);
        if (supQueryResult != null && ListUtil.isNotEmpty((Collection)supQueryResult.getList())) {
            for (EqAuctionGoodsDomain auctionGoodsDomain : supQueryResult.getList()) {
                OcShoppingSkuDomain ocShoppingSkuDomain = new OcShoppingSkuDomain();
                GoodsMap.clear();
                GoodsMap.put("skuCode", auctionGoodsDomain.getSkuCode());
                RsSkuReDomain skuByCode = this.rsSkuService.getSkuByCode(GoodsMap);
                if (skuByCode == null) continue;
                this.logger.error(CODE + ".querySkuToContract.skuByCode", (Object)JSON.toJSONString((Object)skuByCode));
                ocShoppingSkuDomain.setSkuId(skuByCode.getSkuId());
                ocShoppingSkuDomain.setGoodsNum(auctionGoodsDomain.getGoodsNum());
                ocShoppingSkuDomain.setPreferentialPrice(auctionGoodsDomain.getPricesetPrefprice());
                ocShoppingSkuDomain.setChannelCode(skuByCode.getChannelCode());
                ocShoppingSkuDomain.setSkuCode(skuByCode.getSkuCode());
                ocShoppingSkuDomains.add(ocShoppingSkuDomain);
            }
            if (supQueryResult.getList().size() != ocShoppingSkuDomains.size()) {
                this.logger.error(CODE + ".querySkuToContract.skuSize", (Object)"\u7ed3\u7b97\u5546\u54c1\u6570\u91cf\u5f02\u5e38");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7ed3\u7b97\u5546\u54c1\u5f02\u5e38\uff01");
            }
        }
        try {
            List<OcShoppingReDomain> reDomains = this.queryToSkuContractCom(request, ocShoppingSkuDomains, null, null, null, null);
            if (ListUtil.isNotEmpty(reDomains)) {
                return new HtmlJsonReBean(reDomains);
            }
        }
        catch (Exception exception) {
            this.logger.error(CODE + ".querySkuToContract.ex", (Throwable)exception);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, exception.getMessage());
        }
        return new HtmlJsonReBean(ocShoppingReDomainList);
    }

    @RequestMapping(value={"saveShopping.json"}, name="\u589e\u52a0\u8d2d\u7269\u8f66\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveShopping(HttpServletRequest request, OcShoppingDomain ocShoppingDomain) {
        if (null == ocShoppingDomain) {
            this.logger.error(CODE + ".saveShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveShoppingCom(request, ocShoppingDomain);
    }

    @RequestMapping(value={"getShopping.json"}, name="\u83b7\u53d6\u8d2d\u7269\u8f66\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcShoppingReDomain getShopping(String shoppingId) {
        if (StringUtils.isBlank((String)shoppingId)) {
            this.logger.error(CODE + ".getShopping", (Object)"param is null");
            return null;
        }
        return this.getShoppingCom(shoppingId);
    }

    @RequestMapping(value={"updateShopping.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateShopping(HttpServletRequest request, OcShoppingDomain ocShoppingDomain) {
        if (null == ocShoppingDomain) {
            this.logger.error(CODE + ".updateShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateShoppingCom(request, ocShoppingDomain);
    }

    @RequestMapping(value={"deleteShopping.json"}, name="\u5220\u9664\u8d2d\u7269\u8f66\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteShopping(String shoppingId) {
        if (StringUtils.isBlank((String)shoppingId)) {
            this.logger.error(CODE + ".deleteShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.deleteShoppingCom(shoppingId);
    }

    @RequestMapping(value={"wishLists.json"}, name="\u6e20\u9053\u8d2d\u7269\u8f66\u6570\u91cf")
    @ResponseBody
    public SupQueryResult<Integer> wishLists(HttpServletRequest request) {
        String memberCode;
        Map<String, Object> param = this.assemMapParam(request);
        if (null == param) {
            param = new HashMap<String, Object>();
        }
        if (StringUtils.isBlank((String)(memberCode = this.getMerchantCode(request)))) {
            this.logger.error(CODE + ".queryShoppingPage", (Object)"memberCode");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        param.put("memberBcode", memberCode);
        param.put("tenantCode", tenantCode);
        if (null != param) {
            param.put("order", true);
        }
        return this.wishListsCom(request, param);
    }

    @RequestMapping(value={"shoppingList.json"}, name="\u8d2d\u7269\u8f66\u6570\u91cf")
    @ResponseBody
    public SupQueryResult<Integer> shoppingList(HttpServletRequest request) {
        String memberCode;
        String channelCode;
        Map<String, Object> param = this.assemMapParam(request);
        if (null == param) {
            param = new HashMap<String, Object>();
        }
        if (StringUtils.isNotBlank((String)(channelCode = this.getNowChannel(request)))) {
            param.put("channelCode", channelCode);
        }
        if (StringUtils.isBlank((String)(memberCode = this.getMerchantCode(request)))) {
            this.logger.error(CODE + ".queryShoppingPage", (Object)"memberCode");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        param.put("memberBcode", memberCode);
        param.put("tenantCode", tenantCode);
        if (null != param) {
            param.put("order", true);
        }
        return this.shoppingListCom(request, param);
    }

    @RequestMapping(value={"queryShoppingPage.json"}, name="\u67e5\u8be2\u8d2d\u7269\u8f66\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcShoppingReDomain> queryShoppingPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapBuyParam(request);
        param.put("order", true);
        param.remove("channelCode");
        return this.queryShoppingPageCom(request, param, null);
    }

    @RequestMapping(value={"updateShoppingGoodsPmInfo.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u5546\u54c1\u7684\u8425\u9500\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateShoppingGoodsPmInfo(HttpServletRequest request, String shoppingGoodsId, String promotionCode) {
        if (StringUtils.isBlank((String)shoppingGoodsId) || StringUtils.isBlank((String)promotionCode)) {
            this.logger.error(CODE + ".updateShoppingGoodsPmInfo", (Object)" param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OcShoppingGoodsReDomain ocShoppingGoodsReDomain = this.getShoppingGoods(shoppingGoodsId);
        if (null == ocShoppingGoodsReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u65e0\u6570\u636e");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u767b\u5f55");
        }
        String userPcode = userSession.getUserPcode();
        if (!userPcode.equals(ocShoppingGoodsReDomain.getMemberBcode())) {
            this.logger.error(CODE + ".updateShoppingGoodsPmInfo", (Object)(" userPcode\uff1a" + userPcode));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d8a\u6743\u64cd\u4f5c");
        }
        return this.updateShoppingGoodsPmInfoCom(request, shoppingGoodsId, promotionCode);
    }

    @RequestMapping(value={"updateShoppingGoodsCheckState.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u5546\u54c1\u7684\u9009\u4e2d\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateShoppingGoodsCheckState(HttpServletRequest request, String shoppingGoodsIdStr, String shoppingCode, Integer checkState) {
        this.logger.info(CODE + ".queryShopping.updateShoppingGoodsCheckState.start", (Object)new Date().getTime());
        HtmlJsonReBean htmlJsonReBean = this.updateShoppingGoodsCheckStateCom(request, shoppingGoodsIdStr, shoppingCode, checkState);
        this.logger.info(CODE + ".queryShopping.updateShoppingGoodsCheckState.start", (Object)new Date().getTime());
        return htmlJsonReBean;
    }

    @RequestMapping(value={"updateShoppingGoodsNum.json"}, name="\u4fee\u6539\u8d2d\u7269\u8f66\u6570\u91cf")
    @ResponseBody
    public HtmlJsonReBean updateShoppingGoodsNum(HttpServletRequest request, Integer shoppingGoodsId, BigDecimal amount, BigDecimal goodWeight, String goodsDay) {
        if (StringUtils.isBlank((Integer)shoppingGoodsId) || null == amount && null == goodWeight) {
            this.logger.error(CODE + ".updateShoppingGoodsNum", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        SupQueryResult<OcShoppingReDomain> ocShoppingReDomainSupQueryResult = this.queryShoppingPage(request);
        if (ListUtil.isEmpty((Collection)ocShoppingReDomainSupQueryResult.getList())) {
            this.logger.error(CODE + ".updateShoppingGoodsNum", (Object)" ocShoppingReDomainSupQueryResult is null");
            return null;
        }
        return this.updateShoppingGoodsNumCom(request, shoppingGoodsId, amount, goodWeight, goodsDay);
    }

    @RequestMapping(value={"updateShoppingGoodsNumList.json"}, name="\u6279\u91cf\u4fee\u6539\u8d2d\u7269\u8f66\u6570\u91cf")
    @ResponseBody
    public HtmlJsonReBean updateShoppingGoodsNumList(HttpServletRequest request, String shoppingGoodsStr) {
        if (StringUtils.isBlank((String)shoppingGoodsStr)) {
            this.logger.error(CODE + ".updateShoppingGoodsNum", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null");
        }
        SupQueryResult<OcShoppingReDomain> ocShoppingReDomainSupQueryResult = this.queryShoppingPage(request);
        if (ListUtil.isEmpty((Collection)ocShoppingReDomainSupQueryResult.getList())) {
            this.logger.error(CODE + ".updateShoppingGoodsNum", (Object)" ocShoppingReDomainSupQueryResult is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d2d\u7269\u8f66\u4e3a\u7a7a");
        }
        List ocShoppingGoodsDomainList = JsonUtil.buildNonDefaultBinder().getJsonToList(shoppingGoodsStr, OcShoppingGoodsDomain.class);
        if (ListUtil.isNotEmpty((Collection)ocShoppingGoodsDomainList)) {
            for (OcShoppingGoodsDomain ocShoppingGoodsDomain : ocShoppingGoodsDomainList) {
                this.logger.error(CODE + ".updateShoppingGoodsNum", (Object)(ocShoppingGoodsDomain.getShoppingGoodsId() + "-" + ocShoppingGoodsDomain.getGoodsNum() + "-" + ocShoppingGoodsDomain.getGoodsWeight() + "-" + ocShoppingGoodsDomain.getMemo()));
                this.updateShoppingGoodsNumCom(request, ocShoppingGoodsDomain.getShoppingGoodsId(), ocShoppingGoodsDomain.getGoodsNum(), ocShoppingGoodsDomain.getGoodsWeight(), ocShoppingGoodsDomain.getMemo());
            }
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateShoppingState.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateShoppingState(String shoppingId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)shoppingId)) {
            this.logger.error(CODE + ".updateShoppingState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateShoppingStateCom(shoppingId, dataState, oldDataState);
    }

    @RequestMapping(value={"saveContractByOcShopping.json"}, name="\u4ece\u8d2d\u7269\u8f66\u4e2d\u4e0b\u5355")
    @ResponseBody
    public HtmlJsonReBean saveContractByOcShopping(HttpServletRequest request, OcShoppingDomain ocShoppingDomain, String contractTypepro) {
        if (null == ocShoppingDomain) {
            this.logger.error(CODE + ".saveContractByOcShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveContractByOcShoppingCom(request, ocShoppingDomain, contractTypepro);
    }

    @RequestMapping(value={"insertShoppingGoods.json"}, name="\u589e\u52a0\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean insertShoppingGoods(HttpServletRequest request, OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        if (null == ocShoppingGoodsDomain) {
            this.logger.error(CODE + ".insertShoppingGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.insertShoppingGoodsCom(request, ocShoppingGoodsDomain);
    }

    @RequestMapping(value={"addShoppingGoodsBySpec.json"}, name="\u901a\u8fc7\u89c4\u683c\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean addShoppingGoodsBySpec(HttpServletRequest request, String goodsCode, String specStr) {
        if (StringUtils.isBlank((String)specStr) || StringUtils.isBlank((String)goodsCode)) {
            this.logger.error(CODE + ".addShoppingGoodsBySpec", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.addShoppingGoodsBySpecCom(request, goodsCode, specStr, null);
    }

    @RequestMapping(value={"addBatchShoppingGoodsBySpec.json"}, name="\u901a\u8fc7\u89c4\u683c\u6279\u91cf\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean addBatchShoppingGoodsBySpec(HttpServletRequest request, String rsSkuDomainListJson) {
        if (StringUtils.isBlank((String)rsSkuDomainListJson)) {
            this.logger.error(CODE + ".addBatchShoppingGoodsBySpec", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List rsSkuDomainList = JsonUtil.buildNormalBinder().getJsonToList(rsSkuDomainListJson, RsSkuDomain.class);
        boolean errorCode = true;
        HashMap<String, String> map = new HashMap<String, String>();
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        for (RsSkuDomain rsSkuDomain : rsSkuDomainList) {
            htmlJsonReBean = this.addShoppingGoodsBySpecCom(request, rsSkuDomain.getGoodsCode(), rsSkuDomain.getGoodsName(), null);
            if (!"-1".equals(htmlJsonReBean.getErrorCode())) continue;
            errorCode = false;
            map.put(rsSkuDomain.getGoodsCode() + "-" + rsSkuDomain.getGoodsName(), htmlJsonReBean.getMsg());
        }
        if (!errorCode) {
            htmlJsonReBean.setDataObj(map);
            return htmlJsonReBean;
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"addShoppingGoodss.json"}, name="\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean addShoppingGoodss(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght) {
        return this.addShoppingGoodsCustCom(request, skuId, shoppingGoodsPm, goodsNum, goodsWeght, null);
    }

    @RequestMapping(value={"addShoppingGoods.json"}, name="\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean addShoppingGoods(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght) {
        return this.addShoppingGoodsCom(request, skuId, shoppingGoodsPm, goodsNum, goodsWeght, null);
    }

    @RequestMapping(value={"addBatchShoppingGoods.json"}, name="\u6279\u91cf\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean addBatchShoppingGoods(HttpServletRequest request, String goodsBeanListJson) {
        if (StringUtils.isBlank((String)goodsBeanListJson)) {
            this.logger.error(CODE + ".addBatchShoppingGoodsBySpec", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List goodsBeanList = JsonUtil.buildNormalBinder().getJsonToList(goodsBeanListJson, GoodsBean.class);
        return this.addShoppingGoodsComBean(request, goodsBeanList, null);
    }

    @RequestMapping(value={"addShoppingGoodsByCode.json"}, name="\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean addShoppingGoodsByCode(HttpServletRequest request, String skuCode, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, String goodsType) {
        if (StringUtils.isBlank((String)skuCode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "skuCode\u4e3a\u7a7a");
        }
        RsSkuReDomain rsSkuReDomain = this.getRsByCode(skuCode, this.getTenantCode(request));
        if (null == rsSkuReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "");
        }
        return this.addShoppingGoodsCom(request, rsSkuReDomain.getSkuId(), shoppingGoodsPm, goodsNum, goodsWeght, null);
    }

    @RequestMapping(value={"addShoppingGoodsByNo.json"}, name="\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean addShoppingGoodsByNo(HttpServletRequest request, String skuNo, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, String goodsType) {
        if (StringUtils.isBlank((String)skuNo)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d27\u53f7\u4e3a\u7a7a");
        }
        RsSkuReDomain rsSkuReDomain = this.getRsByNo(skuNo, this.getMemberCcode(request), this.getNowChannel(request), this.getTenantCode(request), goodsType);
        this.logger.error(CODE + ".addShoppingGoodsByNo", (Object)(skuNo + ":" + this.getMemberCcode(request) + ":" + this.getNowChannel(request) + ":" + this.getTenantCode(request)));
        if (null == rsSkuReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "");
        }
        return this.addShoppingGoodsCom(request, rsSkuReDomain.getSkuId(), shoppingGoodsPm, goodsNum, goodsWeght, null);
    }

    @RequestMapping(value={"addShoppingGoodsForNo.json"}, name="\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean addShoppingGoodsForNo(HttpServletRequest request, String skuNo, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, String goodsType) {
        if (StringUtils.isBlank((String)skuNo)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d27\u53f7\u4e3a\u7a7a");
        }
        RsSkuReDomain rsSkuReDomain = this.getRsByNo(skuNo, this.getMemberCcode(request), this.getNowChannel(request), this.getTenantCode(request), goodsType);
        if (null == rsSkuReDomain) {
            this.logger.error(CODE + ".addShoppingGoodsForNo", (Object)(skuNo + ":" + this.getMemberCcode(request) + ":" + this.getNowChannel(request) + ":" + this.getTenantCode(request)));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "");
        }
        return this.addShoppingGoodsCustCom(request, rsSkuReDomain.getSkuId(), shoppingGoodsPm, goodsNum, goodsWeght, null);
    }

    @RequestMapping(value={"addShoppingGoodsForCh.json"}, name="\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean addShoppingGoodsForCh(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght) {
        return this.addShoppingGoodsCustCom(request, skuId, shoppingGoodsPm, goodsNum, goodsWeght, null);
    }

    @RequestMapping(value={"addShoppingGoodsCode.json"}, name="\u901a\u8fc7SKUcode\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1,\u53ef\u4f20\u7c7b\u578b")
    @ResponseBody
    public HtmlJsonReBean addShoppingGoodsCode(HttpServletRequest request, String goodsBeanStr) {
        return this.addShoppingGoodsCodeCom(request, goodsBeanStr, null);
    }

    @RequestMapping(value={"getShoppingGoods.json"}, name="\u83b7\u53d6\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcShoppingGoodsReDomain getShoppingGoods(String shoppingGoodsId) {
        if (StringUtils.isBlank((String)shoppingGoodsId)) {
            this.logger.error(CODE + ".getShoppingGoods", (Object)"param is null");
            return null;
        }
        return this.getShoppingGoodsCom(shoppingGoodsId);
    }

    @RequestMapping(value={"updateShoppingGoods.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateShoppingGoods(HttpServletRequest request, OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        if (null == ocShoppingGoodsDomain) {
            this.logger.error(CODE + ".updateShoppingGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateShoppingGoodsCom(request, ocShoppingGoodsDomain);
    }

    @RequestMapping(value={"updateShoppingGood.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateShoppingGood(HttpServletRequest request, String goodsStr) {
        if (StringUtils.isBlank((String)goodsStr)) {
            this.logger.error(CODE + ".updateShoppingGoodsNumBatchCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OcShoppingGoodsDomain ocShoppingGoodsDomain = (OcShoppingGoodsDomain)JsonUtil.buildNormalBinder().getJsonToObject(goodsStr, OcShoppingGoodsDomain.class);
        return this.updateShoppingGoodsCom(request, ocShoppingGoodsDomain);
    }

    @RequestMapping(value={"deleteShoppingGoods.json"}, name="\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteShoppingGoods(HttpServletRequest request, String shoppingGoodsId) {
        if (StringUtils.isBlank((String)shoppingGoodsId)) {
            this.logger.error(CODE + ".deleteShoppingGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.deleteShoppingGoodsCom(request, shoppingGoodsId);
    }

    @RequestMapping(value={"deleteShoppingGoodsBatch.json"}, name="\u6279\u91cf\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteShoppingGoodsBatch(HttpServletRequest request, String shoppingGoodsIdStr) {
        if (StringUtils.isBlank((String)shoppingGoodsIdStr)) {
            this.logger.error(CODE + ".deleteShoppingGoodsBatch", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        Map<String, Object> paramStr = this.assemMapBuyParam(request);
        return this.deleteShoppingGoodsBatchCom(shoppingGoodsIdStr, paramStr);
    }

    @RequestMapping(value={"updateShoppingGoodsNumBatch.json"}, name="\u6279\u91cf\u4fee\u6539")
    @ResponseBody
    public HtmlJsonReBean updateShoppingGoodsNumBatch(String goodsListStr) {
        if (StringUtils.isBlank((String)goodsListStr)) {
            this.logger.error(CODE + ".updateShoppingGoodsNumBatch", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateShoppingGoodsNumBatchCom(goodsListStr);
    }

    @RequestMapping(value={"queryShoppingGoodsPage.json"}, name="\u67e5\u8be2\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcShoppingGoodsReDomain> queryShoppingGoodsPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryShoppingGoodsPageCom(request, param);
    }

    @RequestMapping(value={"updateShoppingGoodsState.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateShoppingGoodsState(String shoppingGoodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)shoppingGoodsId)) {
            this.logger.error(CODE + ".updateShoppingGoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateShoppingGoodsStateCom(shoppingGoodsId, dataState, oldDataState);
    }

    @RequestMapping(value={"queryShoppingToContract.json"}, name="\u8d2d\u7269\u8f66\u7ed3\u7b97\u9875\u9762")
    @ResponseBody
    public List<OcShoppingReDomain> queryShoppingToContract(HttpServletRequest request, String shoppingGoodsIdStr, String contractPmode) {
        if (StringUtils.isBlank((String)shoppingGoodsIdStr)) {
            this.logger.error(CODE + ".queryShoppingToContract", (Object)"param is null");
            return null;
        }
        return this.queryShoppingToContractCom(request, shoppingGoodsIdStr, null, contractPmode);
    }

    @RequestMapping(value={"queryToContractCode.json"}, name="\u76f4\u63a5\u7ed3\u7b97\u9875\u9762\u901a\u8fc7skuCode,\u4f20\u7c7b\u578b")
    @ResponseBody
    public List<OcShoppingReDomain> queryToContractCode(HttpServletRequest request, String skuCode, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, String shoppingType, String contractNbillcode, String pricesetType, String contractPmode) throws Exception {
        if (StringUtils.isBlank((String)skuCode)) {
            this.logger.error(CODE + ".queryToContractCode", (Object)"param is null");
            return null;
        }
        return this.queryToContractCodeCom(request, skuCode, shoppingGoodsPm, goodsNum, goodsWeght, shoppingType, contractNbillcode, pricesetType, null, contractPmode);
    }

    @RequestMapping(value={"queryToContractCodeList.json"}, name="\u76f4\u63a5\u7ed3\u7b97\u9875\u9762\u901a\u8fc7skuCodeList,\u4f20\u7c7b\u578b")
    @ResponseBody
    public List<OcShoppingReDomain> queryToContractCodeList(HttpServletRequest request, String goodsBeanStr, String contractPmode) throws Exception {
        if (StringUtils.isBlank((String)goodsBeanStr)) {
            this.logger.error(CODE + ".queryToContractCodeList", (Object)"param is null");
            return null;
        }
        return this.queryToContractCodeListCom(request, goodsBeanStr, null, contractPmode);
    }

    @RequestMapping(value={"importGoodsList.json"}, name="\u5bfc\u5165\u5546\u54c1\u6e05\u5355")
    @ResponseBody
    public HtmlJsonReBean importGoodsList(HttpServletRequest request, String data, String channelCodeStr) throws Exception {
        if (StringUtils.isBlank((String)data) || StringUtils.isBlank((String)channelCodeStr)) {
            this.logger.error(CODE + ".importGoodsList", (Object)"param is null");
            return new HtmlJsonReBean("error", "\u4f20\u53c2\u4e3a\u7a7a");
        }
        this.logger.info("importGoodsList.input data", (Object)data);
        List appImportGoodsListDomianList = JsonUtil.buildNormalBinder().getJsonToList(data, AppImportGoodsListDomian.class);
        if (appImportGoodsListDomianList == null) {
            this.logger.error(CODE + ".appImportGoodsListDomianList", (Object)"param is null");
            return new HtmlJsonReBean("error", "tolist\u6709\u8bef");
        }
        String msg = "";
        ArrayList<String> errorList = new ArrayList<String>();
        ArrayList<GoodsBeanDomain> goodsBeanDomainList = new ArrayList<GoodsBeanDomain>();
        ArrayList<String> goodsNoList = new ArrayList<String>();
        for (int i = 0; i < appImportGoodsListDomianList.size(); ++i) {
            GoodsBeanDomain goodsBeanDomain = new GoodsBeanDomain();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("ykflag", "true");
            map.put("channelCodeStr", channelCodeStr);
            map.put("searchType", "match_phrase");
            map.put("searchParam", ((AppImportGoodsListDomian)appImportGoodsListDomianList.get(i)).getGoodsNo());
            SupQueryResult<Map<String, Object>> supQueryResult = this.searchengineCon.find(request, map);
            String goodsNum = ((AppImportGoodsListDomian)appImportGoodsListDomianList.get(i)).getGoodsNum();
            if (!goodsNum.matches("\\d+")) {
                msg = i + ":" + ((AppImportGoodsListDomian)appImportGoodsListDomianList.get(i)).getGoodsNo();
                msg = msg + "\u7684\u6570\u91cf\u4e0d\u662f\u7eaf\u6570\u5b57\u3002";
                errorList.add(msg);
                continue;
            }
            if (supQueryResult.getList().size() == 0) {
                msg = i + ":" + ((AppImportGoodsListDomian)appImportGoodsListDomianList.get(i)).getGoodsNo();
                msg = msg + "\u4e0d\u5b58\u5728\u3002";
                errorList.add(msg);
                continue;
            }
            if (goodsNoList.contains(((AppImportGoodsListDomian)appImportGoodsListDomianList.get(i)).getGoodsNo())) {
                msg = i + ":" + ((AppImportGoodsListDomian)appImportGoodsListDomianList.get(i)).getGoodsNo();
                msg = msg + "\u5df2\u7ecf\u5b58\u5728\u3002";
                errorList.add(msg);
                continue;
            }
            Map jsonToMap = new HashMap();
            jsonToMap = JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(supQueryResult.getList().get(0)), String.class, Object.class);
            goodsBeanDomain.setSkuCode(String.valueOf(jsonToMap.get("skuCode")));
            goodsBeanDomain.setGoodsNum(Integer.valueOf(((AppImportGoodsListDomian)appImportGoodsListDomianList.get(i)).getGoodsNum()));
            goodsBeanDomain.setChannelCode(channelCodeStr);
            goodsBeanDomain.setCheckGoodsNum("nck");
            goodsBeanDomain.setGoodsDay(((AppImportGoodsListDomian)appImportGoodsListDomianList.get(i)).getOperationsTime());
            goodsBeanDomainList.add(goodsBeanDomain);
            goodsNoList.add(((AppImportGoodsListDomian)appImportGoodsListDomianList.get(i)).getGoodsNo());
        }
        if (!errorList.isEmpty()) {
            return new HtmlJsonReBean("error", "\u68c0\u67e5\u6570\u636e\u5b58\u5728\u9519\u8bef", errorList);
        }
        String s = JsonUtil.buildNormalBinder().toJson(goodsBeanDomainList);
        ArrayList<List> list = new ArrayList<List>();
        list.add(this.queryToContractCodeList(request, s, null));
        list.add(appImportGoodsListDomianList);
        return new HtmlJsonReBean(list);
    }

    @RequestMapping(value={"queryToContract.json"}, name="\u76f4\u63a5\u7ed3\u7b97\u9875\u9762")
    @ResponseBody
    public List<OcShoppingReDomain> queryToContract(HttpServletRequest request, Integer skuId, String shoppingGoodsPm, BigDecimal goodsNum, BigDecimal goodsWeght, String contractPmode) throws Exception {
        if (null == skuId) {
            this.logger.error(CODE + ".queryToContract", (Object)"skuId is null");
            return null;
        }
        try {
            return this.queryToContractCom(request, skuId, shoppingGoodsPm, goodsNum, goodsWeght, null, contractPmode);
        }
        catch (Exception exception) {
            this.logger.error(CODE + ".queryToContract.ex", (Throwable)exception);
            return null;
        }
    }

    @RequestMapping(value={"addBatchShoppingsGoods.json"}, name="\u6279\u91cf\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean addBatchShoppingsGoods(HttpServletRequest request, String goodsBeanListJson) {
        if (StringUtils.isBlank((String)goodsBeanListJson)) {
            this.logger.error(CODE + ".addBatchShoppingGoodsBySpec", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List goodsBeanList = JsonUtil.buildNormalBinder().getJsonToList(goodsBeanListJson, GoodsBean.class);
        return this.addShoppingGoodsComBean(request, goodsBeanList, null);
    }

    @RequestMapping(value={"importShoppingGoods.json"}, name="\u5546\u54c1\u6279\u91cf\u5bfc\u5165\u8d2d\u7269\u8f66")
    @ResponseBody
    public HtmlJsonReBean importShoppingGoods(HttpServletRequest request, String goodsBeannStr) {
        if (StringUtils.isEmpty((String)goodsBeannStr)) {
            this.logger.error(CODE + ".importShoppingGoods", (Object)"goodsBeannStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List goodsBeanList = JsonUtil.buildNormalBinder().getJsonToList(goodsBeannStr, GoodsBean.class);
        return this.importShoppingGoodsCom(request, goodsBeanList, null);
    }

    @RequestMapping(value={"addBatchShoppingGoodsNew.json"}, name="\u6279\u91cf\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1(\u518d\u6b21\u8d2d\u4e70)")
    @ResponseBody
    public HtmlJsonReBean addBatchShoppingGoodsNew(HttpServletRequest request, String goodsBeanListJson) {
        if (StringUtils.isBlank((String)goodsBeanListJson)) {
            this.logger.error(CODE + ".addBatchShoppingGoodsBySpec", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List goodsBeanList = JsonUtil.buildNormalBinder().getJsonToList(goodsBeanListJson, GoodsBean.class);
        return this.addShoppingGoodsComBeanNew(request, goodsBeanList, null);
    }

    @RequestMapping(value={"querySettlementToReb.json"}, name="\u8fd4\u5229\u5e73\u644a\u8fd4\u5229\u91d1\u989d")
    @ResponseBody
    public HtmlJsonReBean querySettlementToReb(HttpServletRequest request, String ocContract) {
        if (StringUtils.isBlank((String)ocContract)) {
            this.logger.error(CODE + ".querySettlementToReb", (Object)"param is null");
            return new HtmlJsonReBean("error", "param is null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".querySettlementToReb.userSession", (Object)"\u672a\u767b\u5f55");
            return new HtmlJsonReBean("error", "\u672a\u767b\u5f55");
        }
        OcContractDomain ocContractDomain = (OcContractDomain)JsonUtil.buildNormalBinder().getJsonToObject(ocContract, OcContractDomain.class);
        if (null == ocContractDomain) {
            this.logger.error(CODE + ".querySettlementToReb", (Object)("\u6570\u636e\u7c7b\u578b\u9519\u8bef" + JsonUtil.buildNonNullBinder().toJson((Object)ocContractDomain)));
            return new HtmlJsonReBean("error", "\u6570\u636e\u7c7b\u578b\u9519\u8bef");
        }
        List<OcContractSettlDomain> settlDomains = ocContractDomain.getOcContractSettlList();
        if (ListUtil.isEmpty(settlDomains) || ListUtil.isEmpty(ocContractDomain.getGoodsList()) || StringUtils.isBlank((String)ocContractDomain.getMemberBcode())) {
            this.logger.error(CODE + ".querySettlementToReb.settlDomains", (Object)JsonUtil.buildNonNullBinder().toJson((Object)ocContractDomain));
            return new HtmlJsonReBean("error", "\u6570\u636e\u9519\u8bef");
        }
        if (!ocContractDomain.getMemberBcode().equals(userSession.getUserPcode())) {
            this.logger.error(CODE + ".querySettlementToReb.settlDomains.userPcode", (Object)("userPcode:" + userSession.getUserPcode() + "memberCode:" + ocContractDomain.getMemberBcode()));
            return new HtmlJsonReBean("error", "\u8d26\u6237\u4e0d\u4e00\u81f4");
        }
        return this.querySettlementToComReb(request, ocContractDomain);
    }

    @RequestMapping(value={"queryShoppingGoodsByUser.json"}, name="\u67e5\u8be2\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcShoppingGoodsReDomain> queryShoppingGoodsByUser(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new SupQueryResult();
        }
        param.put("memberBcode", userSession.getUserPcode());
        param.remove("channelCode");
        return this.queryShoppingGoodsPageCom(request, param);
    }
}

