/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.gst.service.impl;

import com.yqbsoft.laser.bus.ext.data.gst.domain.CallbackResult;
import com.yqbsoft.laser.bus.ext.data.gst.domain.PtePtrade;
import com.yqbsoft.laser.bus.ext.data.gst.response.HtmlJsonBean;
import com.yqbsoft.laser.bus.ext.data.gst.service.GstPayService;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GstPayServiceImpl
extends BaseServiceImpl
implements GstPayService {
    private static final String SYS_CODE = "GstPayServiceImpl";
    private static final Logger logger = LoggerFactory.getLogger(GstPayServiceImpl.class);

    @Override
    public String savePay(PtePtrade ptePtrade) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        Map extMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(ptePtrade.getExtension(), String.class, Object.class);
        param.put("thirdOrderNumber", ptePtrade.getPtradeSeqno());
        param.put("appCode", "");
        param.put("sdkVersion", "");
        param.put("systemCode", "LNShopIntegral");
        param.put("appUUID", extMap.get("openId"));
        param.put("payType", "20201");
        param.put("orderForm", "20201");
        param.put("payDesc", "\u79ef\u5206\u5c0f\u7a0b\u5e8f\u5546\u57ce\u652f\u4ed8");
        int payMoney = ptePtrade.getOrderAmount().multiply(new BigDecimal(100)).intValue();
        param.put("payMoney", payMoney);
        param.put("businessType", "");
        return null;
    }

    @Override
    public HtmlJsonBean payCallback(Map<String, Object> param) {
        String json = JsonUtil.buildNormalBinder().toJson(param);
        logger.error("GstPayServiceImpl.payCallback.param", (Object)json);
        if (null == param.get("thirdOrderNumber")) {
            return new HtmlJsonBean("-1", "\u53c2\u6570\u9519\u8bef\uff0c\u4e1a\u52a1\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        String thirdOrderNumber = param.get("thirdOrderNumber").toString();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ptradeSeqno", thirdOrderNumber);
        map.put("ptradeExtension", json);
        map.put("tenantCode", param.get("tenantCode"));
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        String jsonResult = this.internalInvoke("pte.ptradeBase.sendCallBack", paramMap);
        CallbackResult callbackResult = CallbackResult.SUCCESS;
        if (StringUtils.isNotBlank((String)jsonResult) && (callbackResult = (CallbackResult)JsonUtil.buildNormalBinder().getJsonToObject(jsonResult, CallbackResult.class)).isSuccess()) {
            return new HtmlJsonBean();
        }
        return new HtmlJsonBean("-1", "\u64cd\u4f5c\u5931\u8d25");
    }

    @Override
    public String saveRefund(PtePtrade ptePtrade) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        Map extMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(ptePtrade.getExtension(), String.class, Object.class);
        param.put("appCode", "appCode");
        param.put("sdkVersion", "appCode");
        param.put("appUUID", extMap.get("openId"));
        param.put("payDesc", "\u79ef\u5206\u5c0f\u7a0b\u5e8f\u5546\u57ce\u9000\u6b3e");
        param.put("thirdOrderNumber", ptePtrade.getPtradeOldseqno());
        param.put("systemCode", "LNShopIntegral");
        param.put("payType", "20201");
        param.put("orderForm", "20201");
        int refundFee = ptePtrade.getOrderAmount().multiply(new BigDecimal(100)).intValue();
        param.put("refundFee", refundFee);
        param.put("userId", ptePtrade.getOpuserCode());
        param.put("userName", ptePtrade.getOpuserName());
        return null;
    }

    @Override
    public HtmlJsonBean refundCallback(Map<String, Object> param) {
        String json = JsonUtil.buildNormalBinder().toJson(param);
        logger.error("GstPayServiceImpl.refundCallback.param", (Object)json);
        if (null == param.get("out_refund_no")) {
            return new HtmlJsonBean("-1", "\u53c2\u6570\u9519\u8bef\uff0c\u4e1a\u52a1\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        String thirdOrderNumber = param.get("out_refund_no").toString();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ptradeSeqno", thirdOrderNumber);
        map.put("ptradeExtension", json);
        map.put("tenantCode", param.get("tenantCode"));
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        String jsonResult = this.internalInvoke("pte.ptradeBase.sendCallBack", paramMap);
        CallbackResult callbackResult = CallbackResult.SUCCESS;
        if (StringUtils.isNotBlank((String)jsonResult) && (callbackResult = (CallbackResult)JsonUtil.buildNormalBinder().getJsonToObject(jsonResult, CallbackResult.class)).isSuccess()) {
            return new HtmlJsonBean();
        }
        return new HtmlJsonBean("-1", "\u64cd\u4f5c\u5931\u8d25");
    }
}

