/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.gst.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.yqbsoft.laser.bus.ext.data.gst.response.GstQueryResult;
import com.yqbsoft.laser.bus.ext.data.gst.response.GstQueryResult2;
import com.yqbsoft.laser.bus.ext.data.gst.response.HtmlJsonReBean;
import com.yqbsoft.laser.bus.ext.data.gst.service.GstTokenService;
import com.yqbsoft.laser.bus.ext.data.gst.util.JsonUtil;
import com.yqbsoft.laser.bus.ext.data.gst.util.SslUtil;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class HttpClientUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientUtil.class);
    @Autowired
    private static GstTokenService gstTokenService;
    public static final String DdFalgSettingKey = "DdFalgSetting-key";
    public static final String TENANT_CODE = "00000000";
    private static PoolingHttpClientConnectionManager httpClientConnectionManager;
    private static CloseableHttpClient httpClient;
    private static CloseableHttpClient httpsClient;
    private static HttpConfig httpConfig;
    private static SSLConnectionSocketFactory sslsf;
    private static final String HTTP_CONF_FILE_NAME = "fenxiao-httpconf.properties";
    private static final int MAX_TOTAL_CONNECTION = 800;
    private static final int MAX_PER_ROUTE = 150;
    private static String UTF_8;

    public static void setGstTokenService(GstTokenService gstTokenService) {
        HttpClientUtil.gstTokenService = gstTokenService;
    }

    private HttpClientUtil() {
    }

    private static void loadConf() {
        if (httpConfig == null) {
            httpConfig = new HttpConfig();
        }
        Properties properties = new Properties();
        try {
            InputStream inputStream = HttpClientUtil.class.getClassLoader().getResourceAsStream(HTTP_CONF_FILE_NAME);
            if (inputStream == null) {
                LOGGER.warn("httpConfig file={} does not exist", (Object)HTTP_CONF_FILE_NAME);
                return;
            }
            properties.load(inputStream);
            int maxTotalConnection = Integer.parseInt(properties.getProperty("max_total_connection"));
            int maxPerRoute = Integer.parseInt(properties.getProperty("max_per_route"));
            LOGGER.info("max_total_connection={}, max_per_route={}", (Object)maxTotalConnection, (Object)maxPerRoute);
            httpConfig.setMaxTotalConnection(maxTotalConnection);
            httpConfig.setMaxPerRoute(maxPerRoute);
        }
        catch (IOException e) {
            LOGGER.warn("read httpConfig from file={} failed", (Object)HTTP_CONF_FILE_NAME, (Object)e);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("read httpConfig from file={} failed", (Object)HTTP_CONF_FILE_NAME, (Object)e);
        }
        catch (Exception e) {
            LOGGER.warn("read httpConfig from file={} failed", (Object)HTTP_CONF_FILE_NAME, (Object)e);
        }
    }

    private static void initHttps() {
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(new KeyManager[0], new TrustManager[]{trustManager}, new SecureRandom());
            sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("\u521d\u59cb\u5316https\u652f\u6301\u5931\u8d25", (Throwable)e);
        }
        catch (KeyManagementException e) {
            LOGGER.error("\u521d\u59cb\u5316https\u652f\u6301\u5931\u8d25", (Throwable)e);
        }
    }

    public static void checkPage(Map<String, Object> param) {
        if (null != param) {
            int page = 1;
            int rows = 10;
            if (null == param.get("page")) {
                param.put("size", rows);
                param.put("current", page);
            } else {
                rows = Integer.parseInt(String.valueOf(param.get("rows")));
                page = Integer.parseInt(String.valueOf(param.get("page")));
                if (rows > 100) {
                    rows = 100;
                }
                param.remove("rows");
                param.remove("page");
                param.put("size", rows);
                param.put("current", page);
            }
        } else {
            param = new HashMap<String, Object>();
            param.put("size", 1);
            param.put("current", 10);
        }
    }

    public static <T> GstQueryResult<T> postToQueryResult(String url, Map<String, Object> param, Class<T> clazz) {
        String responseStr = HttpClientUtil.post(url, param);
        if (StringUtils.isBlank((String)responseStr)) {
            return new GstQueryResult();
        }
        TypeReference typeRef = new TypeReference<GstQueryResult<T>>(){};
        return (GstQueryResult)JsonUtil.json2Object(responseStr, typeRef);
    }

    public static <T> GstQueryResult2<T> postToQueryResult2(String url, Map<String, Object> param) {
        String responseStr = HttpClientUtil.post(url, param);
        if (StringUtils.isBlank((String)responseStr)) {
            return new GstQueryResult2();
        }
        TypeReference typeRef = new TypeReference<GstQueryResult2<T>>(){};
        return (GstQueryResult2)JsonUtil.json2Object(responseStr, typeRef);
    }

    public static <T> GstQueryResult2<T> postToQueryResult3(String url, Map<String, Object> param) {
        String responseStr = HttpClientUtil.postFrom(url, param);
        if (StringUtils.isBlank((String)responseStr)) {
            return new GstQueryResult2();
        }
        TypeReference typeRef = new TypeReference<GstQueryResult2<T>>(){};
        return (GstQueryResult2)JsonUtil.json2Object(responseStr, typeRef);
    }

    public static String post(String url, Map<String, Object> param) {
        try {
            String body = JsonUtil.object2Json(param, false);
            LOGGER.info("HttpClient \u8bf7\u6c42\u53c2\u6570, url:{}, body:{}", (Object)url, (Object)body);
            String responseStr = HttpClientUtil.invokePost(url, body, "application/json; charset=utf-8");
            LOGGER.info("HttpClient \u54cd\u5e94\u7ed3\u679c, url:{}, responseStr:{}", (Object)url, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u5931\u8d25, url:{}, e:{} ", (Object)url, (Object)e);
            return null;
        }
    }

    public static String postFrom(String url, Map<String, Object> param) {
        try {
            LOGGER.info("HttpClient \u8bf7\u6c42\u53c2\u6570, url:{}, body:{}", (Object)url, (Object)JsonUtil.object2Json(param));
            String responseStr = HttpClientUtil.invokePost(url, param);
            LOGGER.info("HttpClient \u54cd\u5e94\u7ed3\u679c, url:{}, responseStr:{}", (Object)url, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u5931\u8d25, url:{}, e:{} ", (Object)url, (Object)e);
            return null;
        }
    }

    public static String postinv(String url, Map<String, Object> param) {
        try {
            String body = JsonUtil.object2Json(param, false);
            LOGGER.info("HttpClient \u8bf7\u6c42\u53c2\u6570, url:{}, body:{}", (Object)url, (Object)body);
            String responseStr = HttpClientUtil.invokePost(url, body, "application/json; charset=utf-8");
            LOGGER.info("HttpClient \u54cd\u5e94\u7ed3\u679c, url:{}, responseStr:{}", (Object)url, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u5931\u8d25, url:{}, e:{} ", (Object)url, (Object)e);
            return null;
        }
    }

    public static <T> HtmlJsonReBean<T> post(String url, Map<String, Object> param, Class<T> clazz) {
        String json = HttpClientUtil.post(url, param);
        return new HtmlJsonReBean<T>(JsonUtil.json2Object(json, clazz));
    }

    public static String invokePost(String url, Map<String, String> headers, Map<String, String> params) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> param : headers.entrySet()) {
                httpPost.addHeader(param.getKey(), param.getValue());
            }
        }
        if (params != null && params.size() > 0) {
            ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> param : params.entrySet()) {
                pairs.add(new BasicNameValuePair(param.getKey(), param.getValue()));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, UTF_8));
        }
        return HttpClientUtil.sendRequest(url, (HttpRequestBase)httpPost);
    }

    public static String invokePost(String url, Map<String, String> headers, String body) throws Exception {
        URIBuilder uriBuilder = new URIBuilder();
        HttpClientUtil.valueForUriBuilder(url, uriBuilder);
        HttpPost httpPost = new HttpPost(uriBuilder.build());
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> param : headers.entrySet()) {
                httpPost.addHeader(param.getKey(), param.getValue());
            }
        }
        if (body != null) {
            httpPost.setEntity((HttpEntity)new StringEntity(body, Charset.forName(UTF_8)));
        }
        return HttpClientUtil.sendRequest(url, (HttpRequestBase)httpPost);
    }

    public static String invokePost(String url, String body, String contentType) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Authorization", HttpClientUtil.getAuthorization(null));
        httpPost.addHeader("Content-type", contentType);
        httpPost.setHeader("Blade-Auth", "bearer " + HttpClientUtil.getToken());
        httpPost.setEntity((HttpEntity)new StringEntity(body, Charset.forName(UTF_8)));
        return HttpClientUtil.sendRequest(url, (HttpRequestBase)httpPost);
    }

    public static String invokePost(String url, Map<String, Object> body) throws Exception {
        ArrayList<NameValuePair> formParams = new ArrayList<NameValuePair>();
        for (String key : body.keySet()) {
            formParams.add((NameValuePair)new BasicNameValuePair(key, body.get(key).toString()));
        }
        return HttpClientUtil.postFormData(url, formParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String postFormData(String url, List<NameValuePair> params) {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                HttpEntity entity = response.getEntity();
                if (entity == null) return null;
                String string = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                return string;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String getToken() {
        String token = gstTokenService.getToken();
        return token;
    }

    private static String getAuthorization(String tenantCode) {
        return HttpClientUtil.getDdFalgSetting(tenantCode, "gst", "Authorization");
    }

    public static String invokeGet(String url) throws Exception {
        HttpGet httpGet = new HttpGet(url);
        return HttpClientUtil.sendRequest(url, (HttpRequestBase)httpGet);
    }

    private static String sendRequest(String url, HttpRequestBase request) throws Exception {
        String responseStr;
        CloseableHttpClient client = url.startsWith("https") ? httpsClient : httpClient;
        long st = System.currentTimeMillis();
        int status = 0;
        try {
            SslUtil.ignoreSsl();
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            HttpEntity entity = response.getEntity();
            status = response.getStatusLine().getStatusCode();
            if (entity != null) {
                responseStr = EntityUtils.toString((HttpEntity)entity, (String)UTF_8);
                response.close();
            } else {
                responseStr = "";
            }
        }
        catch (SocketTimeoutException e) {
            LOGGER.error("HttpClient.sendRequest, url:{}, use_time:{} ms", new Object[]{request.getURI(), System.currentTimeMillis() - st, e});
            throw e;
        }
        catch (ClientProtocolException e) {
            LOGGER.error("HttpClient.sendRequest, url:{}, use_time:{} ms", new Object[]{request.getURI(), System.currentTimeMillis() - st, e});
            throw e;
        }
        catch (IOException e) {
            LOGGER.error("HttpClient.sendRequest, url:{}, use_time:{} ms", new Object[]{request.getURI(), System.currentTimeMillis() - st, e});
            throw e;
        }
        finally {
            request.releaseConnection();
        }
        LOGGER.info("HttpClient Success, status:{}, url:{}, use_time:{} ms", new Object[]{status, request.getURI(), System.currentTimeMillis() - st});
        return responseStr;
    }

    private static RequestConfig buildRequestConfig(Integer connTimeout, Integer readTimeout) {
        RequestConfig.Builder customReqConf = RequestConfig.custom();
        if (connTimeout != null) {
            customReqConf.setConnectTimeout(connTimeout.intValue());
        }
        if (readTimeout != null) {
            customReqConf.setSocketTimeout(connTimeout.intValue());
        }
        return customReqConf.build();
    }

    private static void valueForUriBuilder(String url, URIBuilder uriBuilder) {
        Integer apartIndex = url.indexOf("?");
        if (apartIndex == -1) {
            uriBuilder.setPath(url);
        } else {
            uriBuilder.setPath(url.substring(0, apartIndex));
            uriBuilder.setCustomQuery(url.substring(apartIndex + 1, url.length()));
        }
    }

    public static String getDdFalgSetting(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            tenantCode = TENANT_CODE;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)DdFalgSettingKey, (String)field);
    }

    static {
        httpClientConnectionManager = new PoolingHttpClientConnectionManager();
        httpClient = null;
        httpsClient = null;
        httpConfig = null;
        sslsf = null;
        UTF_8 = "UTF-8";
        HttpClientUtil.initHttps();
        HttpClientUtil.loadConf();
        httpClientConnectionManager.setMaxTotal(httpConfig.getMaxTotalConnection());
        httpClientConnectionManager.setDefaultMaxPerRoute(httpConfig.getMaxPerRoute());
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)httpClientConnectionManager).build();
        httpsClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setConnectionManager((HttpClientConnectionManager)httpClientConnectionManager).build();
        LOGGER.info("HttpClient initialization");
    }

    static class HttpConfig {
        private int maxTotalConnection = 800;
        private int maxPerRoute = 150;

        HttpConfig() {
        }

        public int getMaxTotalConnection() {
            return this.maxTotalConnection;
        }

        public void setMaxTotalConnection(int maxTotalConnection) {
            this.maxTotalConnection = maxTotalConnection;
        }

        public int getMaxPerRoute() {
            return this.maxPerRoute;
        }

        public void setMaxPerRoute(int maxPerRoute) {
            this.maxPerRoute = maxPerRoute;
        }
    }

    static interface AcceptType {
        public static final String ACCEPT_JSON = "application/json";
        public static final String ACCEPT_ANNY = "*/*";
    }

    static interface ContentType {
        public static final String FORM_URLENCODED = "application/x-www-form-urlencoded";
        public static final String JSON = "application/json; charset=utf-8";
    }
}

