/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.gst.service.impl;

import com.yqbsoft.laser.bus.ext.data.gst.response.Token;
import com.yqbsoft.laser.bus.ext.data.gst.service.GstTokenService;
import com.yqbsoft.laser.bus.ext.data.gst.util.HttpClientUtil;
import com.yqbsoft.laser.bus.ext.data.gst.util.JsonUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GstTokenServiceImpl
implements GstTokenService {
    private static final String SYS_CODE = "GstTokenServiceImpl";
    private static final Object lock = new Object();
    private static final String GST_ACCESS_TOKEN = "gst_access_token";
    private static final String GST_REFRESH_TOKEN = "gst_refresh_token";
    public static final String DdFalgSettingKey = "DdFalgSetting-key";
    public static final String TENANT_CODE = "00000000";
    private static final String FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final Logger logger = LoggerFactory.getLogger(GstTokenServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getToken() {
        String token = DisUtil.getRemot((String)GST_ACCESS_TOKEN);
        if (StringUtils.isNotBlank((String)token)) {
            return token;
        }
        Object object = lock;
        synchronized (object) {
            token = DisUtil.getRemot((String)GST_ACCESS_TOKEN);
            if (StringUtils.isNotBlank((String)token)) {
                return token;
            }
            String tokenStr = this.getTokenMain();
            Token tokenDomain = this.makeTokenDomain(tokenStr);
            String accessToken = tokenDomain.getAccess_token();
            if (StringUtils.isBlank((String)accessToken)) {
                logger.error("GstTokenServiceImpl.getToken.tokenDomain:{}", (Object)JsonUtil.object2Json(tokenDomain));
                throw new ApiException("access_token\u4e3a\u7a7a");
            }
            DisUtil.set((String)GST_ACCESS_TOKEN, (String)accessToken, (int)tokenDomain.getExpires_in());
            DisUtil.set((String)GST_REFRESH_TOKEN, (String)tokenDomain.getRefresh_token());
            return accessToken;
        }
    }

    String getTokenMain() {
        Map<String, String> body = this.makeBodyMap();
        Map<String, String> headers = this.makeHeadersMap();
        String tokenStr = null;
        try {
            logger.info("GstTokenServiceImpl.getTokenMain \u8bf7\u6c42\u53c2\u6570, url:{}, headers:{}, body:{}", new Object[]{"http://192.168.174.102:8000/sopapi/api/wft/blade-auth/oauth/token", JsonUtil.object2Json(headers), JsonUtil.object2Json(body)});
            tokenStr = HttpClientUtil.invokePost("http://192.168.174.102:8000/sopapi/api/wft/blade-auth/oauth/token", headers, body);
            logger.info("GstTokenServiceImpl.getTokenMain \u54cd\u5e94\u7ed3\u679c, url:{}, responseStr:{}", (Object)"http://192.168.174.102:8000/sopapi/api/wft/blade-auth/oauth/token", (Object)tokenStr);
        }
        catch (Exception e) {
            logger.error("GstTokenServiceImpl.getTokenMain.e:{}", (Throwable)e);
            return null;
        }
        return tokenStr;
    }

    private Token makeTokenDomain(String tokenStr) {
        if (tokenStr == null) {
            throw new ApiException("\u83b7\u53d6token\u5931\u8d25");
        }
        Token tokenDomain = JsonUtil.json2Object(tokenStr, Token.class);
        if (tokenDomain == null) {
            logger.error("GstTokenServiceImpl.getToken.tokenStr:{}", (Object)tokenStr);
            throw new ApiException("\u8f6c\u6362token\u5931\u8d25");
        }
        return tokenDomain;
    }

    private Map<String, String> makeHeadersMap() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-type", FORM_URLENCODED);
        headers.put("Tenant-Id", GstTokenServiceImpl.getTenantId(null));
        headers.put("Authorization", GstTokenServiceImpl.getAuthorization(null));
        return headers;
    }

    private Map<String, String> makeBodyMap() {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("grant_type", "password");
        param.put("username", GstTokenServiceImpl.getUsername(null));
        param.put("password", GstTokenServiceImpl.getPassword(null));
        String refreshToken = DisUtil.getRemot((String)GST_REFRESH_TOKEN);
        if (StringUtils.isNotBlank((String)refreshToken)) {
            param.put("refresh_token", refreshToken);
        }
        return param;
    }

    private static String getAuthorization(String tenantCode) {
        return GstTokenServiceImpl.getDdFalgSetting(tenantCode, "gst", "Authorization");
    }

    private static String getTenantId(String tenantCode) {
        return GstTokenServiceImpl.getDdFalgSetting(tenantCode, "gst", "Tenant-Id");
    }

    private static String getUsername(String tenantCode) {
        return GstTokenServiceImpl.getDdFalgSetting(tenantCode, "gst", "username");
    }

    private static String getPassword(String tenantCode) {
        return GstTokenServiceImpl.getDdFalgSetting(tenantCode, "gst", "password");
    }

    public static String getDdFalgSetting(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            tenantCode = TENANT_CODE;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)DdFalgSettingKey, (String)field);
    }
}

