/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.gst.service.impl;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.yqbsoft.laser.bus.ext.data.gst.response.GstQueryResult;
import com.yqbsoft.laser.bus.ext.data.gst.response.HtmlJsonBean;
import com.yqbsoft.laser.bus.ext.data.gst.response.HtmlJsonReBean;
import com.yqbsoft.laser.bus.ext.data.gst.response.SupHtmlJsonBean;
import com.yqbsoft.laser.bus.ext.data.gst.service.GstSupplierService;
import com.yqbsoft.laser.bus.ext.data.gst.util.HttpClientUtil;
import com.yqbsoft.laser.bus.ext.data.gst.vo.GstUserSupplierVo;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

public class GstSupplierServiceImpl
extends BaseServiceImpl
implements GstSupplierService {
    private static final String SYS_CODE = "GstUserServiceImpl";

    @Override
    public HtmlJsonReBean<GstUserSupplierVo> getUserSupplierDetail(Map<String, Object> param) {
        if (param.get("orgNo") == null) {
            return HtmlJsonReBean.error("param error, please read document or sourcecode");
        }
        return HttpClientUtil.SupPost("http://192.168.174.41:8102/api/cmsmch/pointsMallGetMch", param, GstUserSupplierVo.class);
    }

    @Override
    public HtmlJsonReBean supplierLogin(Map<String, Object> param) {
        if (param.get("userName") == null || param.get("passwd") == null) {
            return new HtmlJsonReBean("-1", "\u53c2\u6570\u4e3a\u7a7a");
        }
        return HttpClientUtil.post("http://192.168.174.41:8102/api/cmsmch/pointsMallLogin", param, Object.class);
    }

    @Override
    public GstQueryResult<GstUserSupplierVo> queryUserSupplierPage(Map<String, Object> param) {
        HttpClientUtil.checkPage(param);
        return HttpClientUtil.spuPostToQueryResult("http://192.168.174.41:8102/api/cmsmch/pointsMallGetMch", param, GstUserSupplierVo.class);
    }

    @Override
    public HtmlJsonBean passwordUpdate(Map<String, Object> map) {
        return null;
    }

    @Override
    public SupHtmlJsonBean statusUpdate(Map<String, Object> param) {
        if (MapUtil.isEmpty(param)) {
            return new SupHtmlJsonBean("-1", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String json = JsonUtil.buildNormalBinder().toJson(param);
        this.logger.error("GstUserServiceImpl.statusUpdate.param", (Object)json);
        if (null == param.get("payStatus")) {
            return new SupHtmlJsonBean("-1", "\u53c2\u6570\u9519\u8bef\uff0c\u6253\u6b3e\u72b6\u6001\u4e3a\u7a7a");
        }
        if (null == param.get("stlNo")) {
            return new SupHtmlJsonBean("-1", "\u53c2\u6570\u9519\u8bef\uff0c\u7ed3\u7b97\u5355\u53f7\u4e3a\u7a7a");
        }
        if (null == param.get("payDate")) {
            return new SupHtmlJsonBean("-1", "\u53c2\u6570\u9519\u8bef\uff0c\u7ed3\u7b97\u65f6\u95f4\u4e3a\u7a7a");
        }
        return new SupHtmlJsonBean();
    }

    @Override
    public HtmlJsonBean fileUpload(Map<String, Object> map) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String currentDate = sdf.format(new Date());
        String fileName = "JFSC_ParkPay_" + currentDate;
        GstSupplierServiceImpl.generateTxtFile(fileName);
        GstSupplierServiceImpl.compressFile(fileName);
        GstSupplierServiceImpl.downloadFileFromSftp(fileName + ".gz", currentDate);
        return null;
    }

    public static void main(String[] args) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String currentDate = sdf.format(new Date());
        String fileName = "JFSC_ParkPay_" + currentDate;
        GstSupplierServiceImpl.generateTxtFile(fileName);
        GstSupplierServiceImpl.compressFile(fileName);
    }

    public static void generateTxtFile(String fileName) {
        File directory = new File("/data/doc/");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        fileName = "/data/doc/" + fileName;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));){
            writer.write("1234567|0.06|20240601|20240630|20240639|1\u6708|1|1|0|1|0|0.06|0.94|2023072819990105|\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void compressFile(String fileName) {
        File directory = new File("/data/doc/");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        fileName = "/data/doc/" + fileName;
        try (GZIPOutputStream gzipOut = new GZIPOutputStream(new FileOutputStream(fileName + ".gz"));){
            File file = new File(fileName);
            byte[] buffer = new byte[1024];
            try (FileInputStream in = new FileInputStream(file);){
                int len;
                while ((len = in.read(buffer)) > 0) {
                    gzipOut.write(buffer, 0, len);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFileFromSftp(String fileName, String currentDate) {
        String host = "192.168.174.43";
        int port = 22;
        String user = "swift";
        String password = "qazwsx@1331";
        String remoteDir = "/home/sftp/swift/acc/checkfile/pointsMall/" + currentDate + "/";
        File directory = new File("/data/doc/");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        fileName = "/data/doc/" + fileName;
        JSch jsch = new JSch();
        Session session = null;
        Channel channel = null;
        ChannelSftp sftpChannel = null;
        try {
            session = jsch.getSession(user, host, port);
            session.setPassword(password);
            session.setConfig("StrictHostKeyChecking", "no");
            session.connect();
            channel = session.openChannel("sftp");
            channel.connect();
            sftpChannel = (ChannelSftp)channel;
            File localFile = new File(fileName);
            FileOutputStream outputStream = new FileOutputStream(localFile);
            sftpChannel.get(remoteDir + fileName, (OutputStream)outputStream);
            outputStream.close();
        }
        catch (JSchException | SftpException | IOException e) {
            e.printStackTrace();
        }
        finally {
            if (sftpChannel != null) {
                sftpChannel.exit();
            }
            if (channel != null) {
                channel.disconnect();
            }
            if (session != null) {
                session.disconnect();
            }
        }
    }
}

