/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.gst.service.impl;

import com.yqbsoft.laser.bus.ext.data.gst.domain.InvInvlist;
import com.yqbsoft.laser.bus.ext.data.gst.domain.InvInvlistDomain;
import com.yqbsoft.laser.bus.ext.data.gst.domain.InvInvlistGoodsDomain;
import com.yqbsoft.laser.bus.ext.data.gst.domain.InvReturn;
import com.yqbsoft.laser.bus.ext.data.gst.domain.InvUserinv;
import com.yqbsoft.laser.bus.ext.data.gst.domain.Invoice;
import com.yqbsoft.laser.bus.ext.data.gst.domain.OrderDetail;
import com.yqbsoft.laser.bus.ext.data.gst.service.GstInvService;
import com.yqbsoft.laser.bus.ext.data.gst.supbase.InvoiceBaseService;
import com.yqbsoft.laser.bus.ext.data.gst.util.EncryptUtil;
import com.yqbsoft.laser.bus.ext.data.gst.util.HttpClientUtil;
import com.yqbsoft.laser.bus.ext.data.gst.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GstInvServiceImpl
extends InvoiceBaseService
implements GstInvService {
    private static final String SYS_CODE = "GstInvServiceImpl";
    private static final Logger logger = LoggerFactory.getLogger(GstInvServiceImpl.class);

    @Override
    public String saveInv(InvInvlistDomain invInvlist) {
        HashMap<String, Object> map;
        Invoice invoice = new Invoice();
        invoice.setSysNo(invInvlist.getInvlistCode());
        invoice.setOrderNo(invInvlist.getInvlistOpcode());
        if ("1".equals(invInvlist.getUserinvType())) {
            invoice.setFplxdm("82");
        } else if ("2".equals(invInvlist.getUserinvType())) {
            invoice.setFplxdm("81");
        } else {
            return "error";
        }
        if ("1".equals(invInvlist.getUserinvSort())) {
            invoice.setTitleType("1");
        } else if ("2".equals(invInvlist.getUserinvSort())) {
            invoice.setTitleType("2");
        } else {
            return "error";
        }
        invoice.setXhdwsbh(GstInvServiceImpl.getDdFalgSetting(null, "gst", "Inv_xhdwsbh"));
        InvUserinv invUserinv = JsonUtil.json2Object(invInvlist.getInvlistText(), InvUserinv.class);
        invoice.setGhdwmc(invInvlist.getUserinvMember());
        invoice.setGhdwsbh(invUserinv.getUserinvNo());
        invoice.setGhdwdzdh(invUserinv.getUserinvPhone());
        invoice.setGhdwyhzh(invUserinv.getUserinvBankno());
        invoice.setBz(invInvlist.getInvlistMeno());
        invoice.setEmail(invUserinv.getUserinvUeamil());
        ArrayList<OrderDetail> orderDetails = new ArrayList<OrderDetail>();
        for (InvInvlistGoodsDomain invInvlistGoods : invInvlist.getInvInvlistGoodsDomainList()) {
            OrderDetail orderDetail = new OrderDetail();
            orderDetail.setSpmc(invInvlistGoods.getGoodsName() + "" + invInvlistGoods.getSkuName());
            if (null == invInvlistGoods.getContractGoodsRefnum()) {
                invInvlistGoods.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            BigDecimal subtract = invInvlistGoods.getGoodsCamount().subtract(invInvlistGoods.getContractGoodsRefnum());
            orderDetail.setSpsl(subtract.setScale(2, 1).toString());
            orderDetail.setHsbz("1");
            orderDetail.setHsdj(invInvlistGoods.getPricesetNprice().setScale(2, 1).toString());
            BigDecimal multiply = invInvlistGoods.getPricesetNprice().multiply(subtract);
            orderDetail.setHsje(multiply.setScale(2, 1).toString());
            orderDetail.setSpbm(invInvlistGoods.getGoodsProperty1());
            orderDetail.setZkzje("0");
            orderDetails.add(orderDetail);
        }
        invoice.setOrderDetails(orderDetails);
        String postinv = HttpClientUtil.postinv("http://8.142.135.139/jfsc-test/services/orderReceive", JsonUtil.json2Map(JsonUtil.object2Json(invoice)));
        if (StringUtils.isBlank((String)postinv)) {
            return "error";
        }
        InvReturn invReturn = JsonUtil.json2Object(postinv, InvReturn.class);
        if ("10000".equals(invReturn.getCode())) {
            map = new HashMap<String, Object>();
            this.updateInvlistStateByCode(invInvlist.getTenantCode(), invInvlist.getInvlistCode(), 1, 0, map);
            return "success";
        }
        map = new HashMap();
        map.put("invlistDatastr", invReturn.getMsg());
        this.updateInvlistStateByCode(invInvlist.getTenantCode(), invInvlist.getInvlistCode(), -1, 0, map);
        return "error";
    }

    @Override
    public String queryInvPage(Map<String, Object> param) {
        return HttpClientUtil.postinv("http://8.142.135.139/jfsc-test/services/invoiceInfo", JsonUtil.json2Map(JsonUtil.object2Json(param)));
    }

    @Override
    public String queryInvStatus(Map<String, Object> param) {
        return HttpClientUtil.postinv("http://8.142.135.139/jfsc-test/services/orderStatus", JsonUtil.json2Map(JsonUtil.object2Json(param)));
    }

    @Override
    public void loadInvStatus(String tenantCode) {
        List<InvInvlist> invInvlists = this.queryInvlistPage(tenantCode);
        if (ListUtil.isEmpty(invInvlists)) {
            return;
        }
        for (InvInvlist invInvlist : invInvlists) {
            this.updateInvStatus(invInvlist);
        }
    }

    @Override
    public void updateInvStatus(InvInvlist invInvlist) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("sysNo", invInvlist.getInvlistCode());
        param.put("orderNos", invInvlist.getInvlistOpcode());
        String postinv = this.queryInvStatus(param);
        if (StringUtils.isBlank((String)postinv)) {
            return;
        }
        InvReturn invReturn = JsonUtil.json2Object(postinv, InvReturn.class);
        if ("10000".equals(invReturn.getCode())) {
            try {
                String ddFalgSetting = GstInvServiceImpl.getDdFalgSetting(null, "gst", "Inv_Aes_Key");
                String datajson = EncryptUtil.aesDecrypt(invReturn.getData(), ddFalgSetting);
                List<Map> mapList = JsonUtil.json2ObjectList(datajson, Map.class);
                for (Map kpztmap : mapList) {
                    if ("2".equals(kpztmap.get("kpzt"))) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("invlistDatastr", invReturn.getMsg());
                        this.updateInvlistStateByCode(invInvlist.getTenantCode(), invInvlist.getInvlistCode(), -1, 1, map);
                        return;
                    }
                    if (!"1".equals(kpztmap.get("kpzt"))) {
                        return;
                    }
                    HashMap<String, Object> queryparam = new HashMap<String, Object>();
                    queryparam.put("sysNo", invInvlist.getInvlistCode());
                    queryparam.put("orderNo", invInvlist.getInvlistOpcode());
                    String json = this.queryInvPage(queryparam);
                    if (StringUtils.isBlank((String)json) || !"10000".equals((invReturn = JsonUtil.json2Object(json, InvReturn.class)).getCode())) continue;
                    String invjson = EncryptUtil.aesDecrypt(invReturn.getData(), ddFalgSetting);
                    Map datamap = JsonUtil.json2Map(invjson);
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("invlistOurl", datamap.get("pdfUrl"));
                    map.put("invlistOcode2", datamap.get("fphm"));
                    this.updateInvlistStateByCode(invInvlist.getTenantCode(), invInvlist.getInvlistCode(), 2, 1, map);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sysNo", "202408050000001");
        map.put("orderNos", "202408050000002");
        String key = "RpuNqrH+LrH4Kfn3MSp4qQ==";
        System.out.println("\u5bc6\u94a5\uff1a" + key);
        try {
            String json = JsonUtil.object2Json(map);
            System.out.println("\u660e\u6587\uff1a" + json);
            String s = EncryptUtil.aesEncrypt(json, key);
            System.out.println("\u52a0\u5bc6\uff1a" + s);
            String s1 = EncryptUtil.aesDecrypt(s, key);
            System.out.println("\u89e3\u5bc6\uff1a" + s1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

