/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.gst.service.impl;

import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.bus.ext.data.gst.response.Token;
import com.yqbsoft.laser.bus.ext.data.gst.service.GstTokenService;
import com.yqbsoft.laser.bus.ext.data.gst.util.AES256ECB;
import com.yqbsoft.laser.bus.ext.data.gst.util.HttpClientUtil;
import com.yqbsoft.laser.bus.ext.data.gst.util.JsonUtil;
import com.yqbsoft.laser.bus.ext.data.gst.util.RequestUrl;
import com.yqbsoft.laser.bus.ext.data.gst.util.SecretUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.SHA1Utils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GstTokenServiceImpl
implements GstTokenService {
    private static final String SYS_CODE = "GstTokenServiceImpl";
    private static final Object lock = new Object();
    private static final String GST_ACCESS_TOKEN = "gst_access_token";
    private static final String GST_REFRESH_TOKEN = "gst_refresh_token";
    public static final String DdFalgSettingKey = "DdFalgSetting-key";
    public static final String TENANT_CODE = "00000000";
    private static final String FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final Logger logger = LoggerFactory.getLogger(GstTokenServiceImpl.class);
    private static final String GST_ACCESS_SMSTOKEN = "gst_Sms_access_token";
    private static final String GST_REFRESH_SMSTOKEN = "gst_Sms_refresh_token";
    private static final String GST_DATA_TOKEN = "gst_data_token";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getToken() {
        String token = DisUtil.getRemot((String)GST_ACCESS_TOKEN);
        if (StringUtils.isNotBlank((String)token)) {
            return token;
        }
        Object object = lock;
        synchronized (object) {
            token = DisUtil.getRemot((String)GST_ACCESS_TOKEN);
            if (StringUtils.isNotBlank((String)token)) {
                return token;
            }
            String tokenStr = this.getTokenMain();
            Token tokenDomain = this.makeTokenDomain(tokenStr);
            String accessToken = tokenDomain.getAccess_token();
            if (StringUtils.isBlank((String)accessToken)) {
                logger.error("GstTokenServiceImpl.getToken.tokenDomain:{}", (Object)JsonUtil.object2Json(tokenDomain));
                throw new ApiException("access_token\u4e3a\u7a7a");
            }
            DisUtil.set((String)GST_ACCESS_TOKEN, (String)accessToken, (int)tokenDomain.getExpires_in());
            DisUtil.set((String)GST_REFRESH_TOKEN, (String)tokenDomain.getRefresh_token());
            return accessToken;
        }
    }

    String getTokenMain() {
        Map<String, String> body = this.makeBodyMap();
        Map<String, String> headers = this.makeHeadersMap();
        String tokenStr = null;
        logger.info("GstTokenServiceImpl.getTokenMain \u8bf7\u6c42\u53c2\u6570, url:{}, headers:{}, body:{}", new Object[]{RequestUrl.getTokenUrl, JsonUtil.object2Json(headers), JsonUtil.object2Json(body)});
        try {
            tokenStr = HttpClientUtil.invokePost(RequestUrl.getTokenUrl, headers, body);
            logger.info("GstTokenServiceImpl.getTokenMain \u54cd\u5e94\u7ed3\u679c, url:{}, responseStr:{}", (Object)RequestUrl.getTokenUrl, (Object)tokenStr);
        }
        catch (Exception e) {
            logger.error("GstTokenServiceImpl.getTokenMain.e:{}", (Throwable)e);
            return null;
        }
        return tokenStr;
    }

    private Token makeTokenDomain(String tokenStr) {
        if (tokenStr == null) {
            throw new ApiException("\u83b7\u53d6token\u5931\u8d25");
        }
        Token tokenDomain = JsonUtil.json2Object(tokenStr, Token.class);
        if (tokenDomain == null) {
            logger.error("GstTokenServiceImpl.getToken.tokenStr:{}", (Object)tokenStr);
            throw new ApiException("\u8f6c\u6362token\u5931\u8d25");
        }
        return tokenDomain;
    }

    private Map<String, String> makeHeadersMap() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-type", FORM_URLENCODED);
        headers.put("Tenant-Id", GstTokenServiceImpl.getTenantId(null));
        headers.put("Authorization", GstTokenServiceImpl.getAuthorization(null));
        return headers;
    }

    private static String getSecretkey(String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            tenantCode = TENANT_CODE;
        }
        return GstTokenServiceImpl.getDdFalgSetting(tenantCode, "gst", "secretkey");
    }

    private Map<String, String> makeBodyMap() {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("grant_type", "password");
        param.put("username", GstTokenServiceImpl.getUsername(null));
        param.put("password", GstTokenServiceImpl.getPassword(null));
        String refreshToken = DisUtil.getRemot((String)GST_REFRESH_TOKEN);
        if (StringUtils.isNotBlank((String)refreshToken)) {
            param.put("refresh_token", refreshToken);
        }
        return param;
    }

    private static String getAuthorization(String tenantCode) {
        return GstTokenServiceImpl.getDdFalgSetting(tenantCode, "gst", "Authorization");
    }

    private static String getTenantId(String tenantCode) {
        return GstTokenServiceImpl.getDdFalgSetting(tenantCode, "gst", "Tenant-Id");
    }

    private static String getUsername(String tenantCode) {
        return GstTokenServiceImpl.getDdFalgSetting(tenantCode, "gst", "username");
    }

    private static String getPassword(String tenantCode) {
        return GstTokenServiceImpl.getDdFalgSetting(tenantCode, "gst", "password");
    }

    public static String getDdFalgSetting(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            tenantCode = TENANT_CODE;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)DdFalgSettingKey, (String)field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSmsToken() {
        String token = DisUtil.getRemot((String)GST_ACCESS_SMSTOKEN);
        if (StringUtils.isNotBlank((String)token)) {
            logger.error("GstTokenServiceImpl.getSmsToken.token.2", (Object)token);
            return token;
        }
        Object object = lock;
        synchronized (object) {
            token = DisUtil.getRemot((String)GST_ACCESS_SMSTOKEN);
            if (StringUtils.isNotBlank((String)token)) {
                logger.error("GstTokenServiceImpl.getSmsToken.token.2", (Object)token);
                return token;
            }
            String tokenStr = this.sendGetToken();
            Token tokenDomain = this.makeTokenDomain(tokenStr);
            String accessToken = tokenDomain.getAccess_token();
            if (StringUtils.isBlank((String)accessToken)) {
                logger.error("GstTokenServiceImpl.getSmsToken.tokenDomain:{}", (Object)JsonUtil.object2Json(tokenDomain));
                throw new ApiException("access_token\u4e3a\u7a7a");
            }
            DisUtil.set((String)GST_ACCESS_SMSTOKEN, (String)accessToken, (int)tokenDomain.getExpires_in());
            DisUtil.set((String)GST_REFRESH_SMSTOKEN, (String)tokenDomain.getRefresh_token());
            return accessToken;
        }
    }

    private String sendGetToken() {
        Map<String, String> body = this.makeSmsBody();
        Map<String, String> headers = this.makeSmsHeader();
        String tokenStr = null;
        try {
            logger.info("GstTokenServiceImpl.getTokenMain \u8bf7\u6c42\u53c2\u6570, url:{}, headers:{}, body:{}", new Object[]{RequestUrl.getSmsTokenUrl, JsonUtil.object2Json(headers), JsonUtil.object2Json(body)});
            tokenStr = HttpClientUtil.invokePost(RequestUrl.getSmsTokenUrl, headers, body);
            logger.info("GstTokenServiceImpl.getTokenMain \u54cd\u5e94\u7ed3\u679c, url:{}, responseStr:{}", (Object)RequestUrl.getSmsTokenUrl, (Object)tokenStr);
        }
        catch (Exception e) {
            logger.error("GstTokenServiceImpl.sendGetToken.e:{}", (Throwable)e);
            return null;
        }
        return tokenStr;
    }

    private String sendPostBasicToken() {
        Map<String, Object> body = this.makeBasicBody();
        Map<String, String> headers = this.makeBasicHeader();
        String tokenStr = null;
        try {
            logger.info("GstTokenServiceImpl.sendPostBasicToken \u8bf7\u6c42\u53c2\u6570, url:{}, headers:{}, body:{}", new Object[]{RequestUrl.getBasicTokenUrl, JsonUtil.object2Json(headers), JsonUtil.object2Json(body)});
            tokenStr = HttpClientUtil.invokePost(RequestUrl.getBasicTokenUrl, body);
            logger.info("GstTokenServiceImpl.sendPostBasicToken \u54cd\u5e94\u7ed3\u679c, url:{}, responseStr:{}", (Object)RequestUrl.getBasicTokenUrl, (Object)tokenStr);
        }
        catch (Exception e) {
            logger.error("GstTokenServiceImpl.sendPostBasicToken.e:{}", (Throwable)e);
            return null;
        }
        return tokenStr;
    }

    private Map<String, String> makeSmsBody() {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("grant_type", "password");
        param.put("username", GstTokenServiceImpl.getDdFalgSetting(null, "gst", "Sms_username"));
        param.put("password", GstTokenServiceImpl.getDdFalgSetting(null, "gst", "Sms_password"));
        String refreshToken = DisUtil.getRemot((String)GST_REFRESH_SMSTOKEN);
        if (StringUtils.isNotBlank((String)refreshToken)) {
            param.put("refresh_token", refreshToken);
        }
        return param;
    }

    private Map<String, String> makeSmsHeader() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-type", FORM_URLENCODED);
        headers.put("Tenant-Id", GstTokenServiceImpl.getDdFalgSetting(null, "gst", "Sms_Tenant-Id"));
        headers.put("Authorization", GstTokenServiceImpl.getDdFalgSetting(null, "gst", "Sms_Authorization"));
        return headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBasicToken() {
        String token = DisUtil.getRemot((String)GST_DATA_TOKEN);
        if (StringUtils.isNotBlank((String)token)) {
            return token;
        }
        Object object = lock;
        synchronized (object) {
            token = DisUtil.getRemot((String)GST_DATA_TOKEN);
            if (StringUtils.isNotBlank((String)token)) {
                return token;
            }
            String tokenStr = this.sendPostBasicToken();
            Map resMap = (Map)JSON.parseObject((String)tokenStr, Map.class);
            String accessToken = null;
            if (resMap == null) {
                logger.error("GstTokenServiceImpl.dataToken.tokenStr:{}", (Object)tokenStr);
                throw new ApiException("\u8f6c\u6362token\u5931\u8d25");
            }
            if ("01".equals(resMap.get("status"))) {
                logger.error("GstTokenServiceImpl.dataToken.Status:{}", (Object)tokenStr);
                throw new ApiException("\u83b7\u53d6token\u5931\u8d25");
            }
            String data = resMap.get("data").toString();
            String secret = SecretUtil.DdFalgSettingKey(null, "secretUserkey");
            Map map = null;
            try {
                String decrypt = AES256ECB.Decrypt(data, secret);
                map = (Map)JSON.parseObject((String)decrypt, Map.class);
                accessToken = map.get("token").toString();
            }
            catch (Exception e) {
                logger.error("GstTokenServiceImpl.dataToken.AES256ECB.Decrypt:{}", (Object)data);
                throw new ApiException("\u89e3\u5bc6\u7b7e\u540d\u5931\u8d25");
            }
            if (StringUtils.isBlank((String)accessToken)) {
                logger.error("GstTokenServiceImpl.getBasicToken.tokenDomain:{}", (Object)JsonUtil.object2Json(map));
                throw new ApiException("access_token\u4e3a\u7a7a");
            }
            DisUtil.set((String)GST_DATA_TOKEN, (String)accessToken, (int)20000);
            return accessToken;
        }
    }

    private Map<String, Object> makeBasicBody() {
        String timestamp = String.valueOf(System.currentTimeMillis());
        String appid = SecretUtil.DdFalgSettingKey(null, "userAppid");
        String secret = SecretUtil.DdFalgSettingKey(null, "userSecret");
        String aesdevkey = SecretUtil.DdFalgSettingKey(null, "secretUserkey");
        String sha1 = SHA1Utils.getSha1((String)(appid + secret + timestamp));
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("sign", sha1);
        param.put("appid", appid);
        param.put("timestamp", timestamp);
        String parMsg = JSON.toJSONString(param);
        try {
            String data = AES256ECB.Encrypt(parMsg, aesdevkey);
            param.clear();
            param.put("sign", sha1);
            param.put("appid", appid);
            param.put("timestamp", timestamp);
            param.put("data", data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return param;
    }

    private Map<String, String> makeBasicHeader() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-type", FORM_URLENCODED);
        return headers;
    }
}

