/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.hegii.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.exceptions.ValidateException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.bus.data.hegii.common.InvokeUtils;
import com.yqbsoft.laser.service.ext.bus.data.hegii.domain.org.OrgCompanyDomain;
import com.yqbsoft.laser.service.ext.bus.data.hegii.domain.org.OrgDepartDomain;
import com.yqbsoft.laser.service.ext.bus.data.hegii.domain.org.OrgDepartempDomain;
import com.yqbsoft.laser.service.ext.bus.data.hegii.domain.org.OrgEmployeeDomain;
import com.yqbsoft.laser.service.ext.bus.data.hegii.domain.org.OrgPositionDomain;
import com.yqbsoft.laser.service.ext.bus.data.hegii.facade.request.org.SaveEmployeeRequest;
import com.yqbsoft.laser.service.ext.bus.data.hegii.service.DepartService;
import com.yqbsoft.laser.service.ext.bus.data.hegii.service.PositionService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.core.JsonReBean;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmployeeService
extends BaseServiceImpl {
    @Autowired
    PositionService positionExtendService;
    @Autowired
    DepartService departExtendService;
    @Autowired
    InvokeUtils invokeUtils;
    private static String CODE = "org.employee.con";

    public String saveOrUpdateEmployee(SaveEmployeeRequest saveEmployeeVO, String tenantCode) {
        OrgDepartDomain orgDepartReDomain = this.departExtendService.getByShortCode(saveEmployeeVO.getDepartCode(), tenantCode);
        if (orgDepartReDomain == null) {
            throw new ValidateException(saveEmployeeVO.getDepartCode() + ":\u90e8\u95e8\u4e0d\u5b58\u5728");
        }
        OrgPositionDomain positionReDomain = this.positionExtendService.getByRoleCode(saveEmployeeVO.getPositionCode(), tenantCode);
        if (positionReDomain == null) {
            throw new ValidateException(saveEmployeeVO.getPositionCode() + ":\u804c\u4f4d\u4e0d\u5b58\u5728");
        }
        OrgEmployeeDomain employeeReDomain = this.getByShortCode(saveEmployeeVO.getEmployeeCode());
        OrgEmployeeDomain employeeDomain = new OrgEmployeeDomain();
        employeeDomain.setCompanyCode("20000210479445");
        employeeDomain.setCompanyShortname("\u6052\u6d01\u536b\u6d74\u96c6\u56e2");
        employeeDomain.setEmployeePhone(saveEmployeeVO.getEmployeePhone());
        employeeDomain.setEmployeeEmail(saveEmployeeVO.getEmployeeEmail());
        employeeDomain.setEmployeeName(saveEmployeeVO.getEmployeeName());
        employeeDomain.setEmployeeShortcode(saveEmployeeVO.getEmployeeCode());
        employeeDomain.setTenantCode(tenantCode);
        employeeDomain.setPositionCode(positionReDomain.getPositionCode());
        employeeDomain.setPositionName(positionReDomain.getPositionName());
        OrgEmployeeDomain employeeDomainPhone = this.getByPhone(saveEmployeeVO.getEmployeePhone());
        if (employeeDomainPhone != null && !saveEmployeeVO.getEmployeeCode().equals(employeeDomainPhone.getEmployeeShortcode())) {
            throw new ValidateException(saveEmployeeVO.getEmployeePhone() + ":\u624b\u673a\u53f7\u5df2\u5b58\u5728");
        }
        if (employeeReDomain == null) {
            this.saveEmployeePlus(employeeDomain, orgDepartReDomain, positionReDomain, tenantCode);
        } else {
            employeeDomain.setEmployeeId(employeeReDomain.getEmployeeId());
            this.updateEmployeePlus(employeeDomain, tenantCode);
        }
        return "success";
    }

    public OrgEmployeeDomain getByShortCode(String shortCode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("employeeShortcode", shortCode);
        param.put("order", true);
        SupQueryResult<OrgEmployeeDomain> result = this.queryEmployeePage(param);
        if (CollectionUtil.isNotEmpty((Collection)result.getList())) {
            param.remove("employeeShortcode", shortCode);
            return (OrgEmployeeDomain)result.getList().get(0);
        }
        return null;
    }

    public OrgEmployeeDomain getByPhone(String telephone) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("employeePhone", telephone);
        param.put("order", true);
        SupQueryResult<OrgEmployeeDomain> result = this.queryEmployeePage(param);
        if (CollectionUtil.isNotEmpty((Collection)result.getList())) {
            return (OrgEmployeeDomain)result.getList().get(0);
        }
        return null;
    }

    public SupQueryResult<OrgEmployeeDomain> queryEmployeePage(Map<String, Object> map) {
        String code = "org.employee.queryEmployeePage";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult queryResult = this.sendReSupObject(code, param, OrgEmployeeDomain.class);
        this.logger.error("\u8c03\u7528queryDepartPage\u8fd4\u56de{}", (Object)queryResult);
        return queryResult;
    }

    private void saveEmployeePlus(OrgEmployeeDomain orgEmployeeDomain, OrgDepartDomain orgDepartReDomain, OrgPositionDomain positionReDomain, String tenantCode) {
        OrgCompanyDomain companyByCode = this.getCompanyByCode(tenantCode, orgEmployeeDomain.getCompanyCode());
        if (companyByCode == null) {
            throw new ValidateException("\u516c\u53f8\u4e0d\u5b58\u5728");
        }
        String password = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-default-password"));
        if (StringUtils.isNotBlank((String)password)) {
            orgEmployeeDomain.setUserPwsswd(password);
        }
        orgEmployeeDomain.setTenantCode(tenantCode);
        Boolean success = this.saveEmployee(orgEmployeeDomain);
        if (!success.booleanValue()) {
            throw new ValidateException("\u4fdd\u5b58\u5458\u5de5\u5931\u8d25");
        }
        OrgDepartempDomain orgDepartempDomain = new OrgDepartempDomain();
        orgDepartempDomain.setDepartCode(orgDepartReDomain.getDepartCode());
        orgDepartempDomain.setDepartName(orgDepartReDomain.getDepartName());
        orgDepartempDomain.setPositionName(positionReDomain.getPositionName());
        orgDepartempDomain.setPositionCode(positionReDomain.getPositionCode());
        orgDepartempDomain.setCompanyCode(orgEmployeeDomain.getCompanyCode());
        orgDepartempDomain.setUserinfoCode(orgEmployeeDomain.getUserinfoCode());
        orgDepartempDomain.setEmployeeName(orgEmployeeDomain.getEmployeeName());
        orgDepartempDomain.setEmployeeCode(orgEmployeeDomain.getEmployeeCode());
        orgDepartempDomain.setTenantCode(tenantCode);
        success = this.saveDepartemp(orgDepartempDomain);
        if (!success.booleanValue()) {
            throw new ValidateException("\u4fdd\u5b58\u90e8\u95e8\u5931\u8d25");
        }
    }

    private void updateEmployeePlus(OrgEmployeeDomain orgEmployeeDomain, String tenantCode) {
        Boolean success;
        SupQueryResult<OrgDepartempDomain> supQueryResult = this.queryDepartempPage(this.getQueryMapParam("employeeCode,tenantCode", new Object[]{orgEmployeeDomain.getEmployeeCode(), orgEmployeeDomain.getTenantCode()}));
        List orgDepartemps = supQueryResult.getList();
        if (ListUtil.isNotEmpty((Collection)orgDepartemps)) {
            OrgDepartempDomain orgDepartempDomain = new OrgDepartempDomain();
            for (OrgDepartempDomain orgDepartemp : orgDepartemps) {
                orgDepartempDomain.setEmployeeName(orgEmployeeDomain.getEmployeeName());
                orgDepartempDomain.setPositionName(orgEmployeeDomain.getPositionName());
                orgDepartempDomain.setTenantCode(tenantCode);
                orgDepartempDomain.setCompanyCode(orgEmployeeDomain.getCompanyCode());
                orgDepartempDomain.setEmployeeCode(orgEmployeeDomain.getEmployeeCode());
                orgDepartempDomain.setDepartempCode(orgDepartemp.getDepartempCode());
                orgDepartempDomain.setDepartempId(orgDepartemp.getDepartempId());
                orgDepartempDomain.setDepartCode(orgDepartemp.getDepartCode());
                Boolean success2 = this.updateDepartemp(orgDepartempDomain);
                if (success2.booleanValue()) continue;
                throw new ValidateException("\u66f4\u65b0\u90e8\u95e8\u5931\u8d25 departTempId:" + orgDepartemp.getDepartempId());
            }
        }
        if (!(success = this.updateEmployee(orgEmployeeDomain)).booleanValue()) {
            throw new ValidateException("\u66f4\u65b0\u5458\u5de5\u5931\u8d25");
        }
    }

    public OrgCompanyDomain getCompanyByCode(String tenantCode, String companyCode) {
        String code = "org.company.getCompanyByCode";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", tenantCode);
        param.put("companyCode", companyCode);
        OrgCompanyDomain orgCompanyDomain = this.invokeUtils.invoke(code, param, OrgCompanyDomain.class);
        return orgCompanyDomain;
    }

    public Boolean updateEmployee(OrgEmployeeDomain orgEmployeeDomain) {
        String code = "org.ChannelsendBase.sendUpdateEmployee";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgEmployeeDomain", JsonUtil.buildNormalBinder().toJson((Object)orgEmployeeDomain));
        JsonReBean reBean = this.invokeUtils.invoke(code, param, JsonReBean.class);
        return reBean != null && reBean.isSuccess();
    }

    public Boolean saveEmployee(OrgEmployeeDomain orgEmployeeDomain) {
        String code = "org.ChannelsendBase.sendSaveEmployee";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgEmployeeDomain", JsonUtil.buildNormalBinder().toJson((Object)orgEmployeeDomain));
        JsonReBean reBean = this.invokeUtils.invoke(code, param, JsonReBean.class);
        return reBean != null && reBean.isSuccess();
    }

    public Boolean saveDepartemp(OrgDepartempDomain orgDepartempDomain) {
        String code = "org.ChannelsendBase.sendSaveDepartemp";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgDepartempDomain", JsonUtil.buildNormalBinder().toJson((Object)orgDepartempDomain));
        JsonReBean reBean = this.invokeUtils.invoke(code, param, JsonReBean.class);
        return reBean != null && reBean.isSuccess();
    }

    public SupQueryResult<OrgDepartempDomain> queryDepartempPage(Map<String, Object> param) {
        String code = "org.depart.queryDepartempPage";
        QueryResult queryResult = this.sendReSupObject(code, param, OrgDepartempDomain.class);
        this.logger.error("\u8c03\u7528queryDepartPage\u8fd4\u56de{}", (Object)queryResult);
        return queryResult;
    }

    public Boolean updateDepartemp(OrgDepartempDomain orgDepartempDomain) {
        String code = "org.ChannelsendBase.sendUpdateDepartemp";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgDepartempDomain", JsonUtil.buildNormalBinder().toJson((Object)orgDepartempDomain));
        JsonReBean reBean = this.invokeUtils.invoke(code, param, JsonReBean.class);
        return reBean != null && reBean.isSuccess();
    }
}

