/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl;

import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.DisOauthTokenDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.OauthResponse;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.OauthResponseData;
import com.yqbsoft.laser.service.ext.bus.jushuitan.service.OauthService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl.DateBaseService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.util.SignUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OauthServiceImpl
extends DateBaseService
implements OauthService {
    private static final Logger log = LoggerFactory.getLogger(OauthServiceImpl.class);
    private static String SYS_CODE = "jst.OauthServiceImpl";

    @Override
    public String refreshToken(String tenantCode) {
        String refToken = this.getRefToken("jushuitan", tenantCode);
        if (StringUtils.isBlank((String)refToken)) {
            logger.error(SYS_CODE + "refreshToken refToken is null");
            return "error";
        }
        String url = OauthServiceImpl.getDdFalgSetting(tenantCode, "refreshTokenUrl", "refreshTokenUrl", "");
        String appkey = OauthServiceImpl.getDdFalgSetting(tenantCode, "jstappkey", "jstappkey", "");
        String secret = OauthServiceImpl.getDdFalgSetting(tenantCode, "jstsecret", "jstsecret", "");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appkey);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("grant_type", "authorization_code");
        params.put("charset", "utf-8");
        params.put("refresh_token", refToken);
        params.put("scope", "all");
        String sign = SignUtil.getSign(secret, params);
        params.put("sign", sign);
        String parmStr = OauthServiceImpl.buildQuery(params);
        String responseStr = OauthServiceImpl.execute(parmStr, url);
        if (StringUtils.isBlank((String)responseStr)) {
            logger.error(SYS_CODE + ".refreshToken responseStr is null");
            return "error";
        }
        OauthResponse oauthResponse = (OauthResponse)JsonUtil.buildNormalBinder().getJsonToObject(responseStr, OauthResponse.class);
        if (0 != oauthResponse.getCode()) {
            logger.error(SYS_CODE + ".refreshToken responseStr is error", (Object)oauthResponse.getMsg());
            return "error";
        }
        if (null == oauthResponse.getData()) {
            logger.error(SYS_CODE + ".refreshToken oauthResponse is error", (Object)responseStr);
            return "error";
        }
        String res = this.saveDisTokenForJst(oauthResponse.getData(), tenantCode);
        if (!"success".equals(res)) {
            logger.error(SYS_CODE + ".refreshToken saveDisTokenForJst is error", (Object)responseStr);
            return "error";
        }
        return "success";
    }

    @Override
    public String getOauthUrl(String tenantCode) {
        String appkey = this.getDdFalgSetting("jstappkey", tenantCode);
        String secret = this.getDdFalgSetting("jstsecret", tenantCode);
        String url = this.getDdFalgSetting("jstSerUrl", tenantCode);
        StringBuilder stringBuffer = new StringBuilder();
        HashMap<String, String> map = new HashMap<String, String>();
        String time = String.valueOf(System.currentTimeMillis() / 1000L);
        map.put("app_key", appkey);
        map.put("timestamp", time);
        map.put("state", "test");
        map.put("charset", "utf-8");
        stringBuffer.append(url).append("?").append("app_key=").append(appkey).append("&timestamp=").append(time).append("&charset=utf-8&sign=").append(SignUtil.getSign(secret, map)).append("&state=").append("test");
        return stringBuffer.toString();
    }

    @Override
    public String getOauthUrlByCode(String tenantCode, String state) {
        logger.error("\u751f\u6210erp" + tenantCode + "---" + state);
        String appkey = this.getDdFalgSetting("jstappkey", tenantCode);
        String secret = this.getDdFalgSetting("jstsecret", tenantCode);
        String url = this.getDdFalgSetting("jstSerUrl", tenantCode);
        StringBuilder stringBuffer = new StringBuilder();
        HashMap<String, String> map = new HashMap<String, String>();
        String time = String.valueOf(System.currentTimeMillis() / 1000L);
        map.put("app_key", appkey);
        map.put("timestamp", time);
        map.put("state", state);
        map.put("charset", "utf-8");
        stringBuffer.append(url).append("?").append("app_key=").append(appkey).append("&timestamp=").append(time).append("&charset=utf-8&sign=").append(SignUtil.getSign(secret, map)).append("&state=").append(state);
        return stringBuffer.toString();
    }

    public static void main(String[] args) {
        String url = "https://isv-openweb.jushuitan.com/auth";
        String appkey = "1efbf09e32a047879711da12be4aff08";
        String secret = "ecf3e001e5414f7a8b750dc166198668";
        StringBuilder stringBuffer = new StringBuilder();
        HashMap<String, String> map = new HashMap<String, String>();
        String time = String.valueOf(System.currentTimeMillis() / 1000L);
        map.put("app_key", appkey);
        map.put("timestamp", time);
        map.put("state", "test");
        map.put("charset", "utf-8");
        stringBuffer.append(url).append("?").append("app_key=").append(appkey).append("&timestamp=").append(time).append("&charset=utf-8&sign=").append(SignUtil.getSign(secret, map)).append("&state=").append("test");
        System.out.println(stringBuffer.toString());
    }

    private String saveDisTokenForJst(OauthResponseData oauthResponseData, String tenantCode) {
        if (null == oauthResponseData) {
            logger.error(SYS_CODE + ".saveDisToken.json");
            return "error";
        }
        String api = "dis.oauth.saveOauthToken";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        DisOauthTokenDomain disOauthTokenDomain = new DisOauthTokenDomain();
        disOauthTokenDomain.setChannelCode("jushuitan");
        disOauthTokenDomain.setChannelName("\u805a\u6c34\u6f6d");
        disOauthTokenDomain.setMemberCode("jushuitan");
        disOauthTokenDomain.setMemberName("\u805a\u6c34\u6f6d");
        disOauthTokenDomain.setOauthTokenExpireIn(Integer.valueOf(oauthResponseData.getExpires_in()));
        disOauthTokenDomain.setOauthTokenRefreshToken(oauthResponseData.getRefresh_token());
        disOauthTokenDomain.setOauthTokenToken(oauthResponseData.getAccess_token());
        Long updateTime = new Date().getTime() + (long)disOauthTokenDomain.getOauthTokenExpireIn().intValue();
        disOauthTokenDomain.setOauthTokenUpdateTime(new Date(updateTime));
        disOauthTokenDomain.setTenantCode(tenantCode);
        paramMap.put("disOauthTokenDomain", JsonUtil.buildNormalBinder().toJson((Object)disOauthTokenDomain));
        this.internalInvoke(api, paramMap);
        return "success";
    }
}

