/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.wangdian.service.impl;

import com.yqbsoft.laser.bus.ext.data.wangdian.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.bus.ext.data.wangdian.domain.OcContractReDomain;
import com.yqbsoft.laser.bus.ext.data.wangdian.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.bus.ext.data.wangdian.domain.OcRefundReDomain;
import com.yqbsoft.laser.bus.ext.data.wangdian.domain.WdGoodsOrder;
import com.yqbsoft.laser.bus.ext.data.wangdian.domain.WdOrder;
import com.yqbsoft.laser.bus.ext.data.wangdian.domain.WdTrade;
import com.yqbsoft.laser.bus.ext.data.wangdian.service.SendrefundService;
import com.yqbsoft.laser.bus.ext.data.wangdian.utils.DateUtils;
import com.yqbsoft.laser.bus.ext.data.wangdian.utils.DmUtil;
import com.yqbsoft.laser.bus.ext.data.wangdian.utils.WdtClient;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SendrefundServicelmpl
extends BaseServiceImpl
implements SendrefundService {
    private static final String SYS_CODE = "wd.WdSendrefundService";
    private static final String OC_REFUND_UPDATE_DATE = "oc.refundEngine.sendRefundNext";

    @Override
    public String sendrefund2(OcRefundReDomain ocRefundDomain) throws ApiException {
        this.logger.error("wd.WdSendrefundService.saveSendrefund:ocRefundDomain" + JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        if (null == ocRefundDomain) {
            this.logger.error("wd.WdSendrefundService.saveSendrefund", (Object)"is null");
            return "error";
        }
        String url = DmUtil.getUrl(ocRefundDomain.getTenantCode(), "wdUrl", "url");
        String sid = DmUtil.getUrl(ocRefundDomain.getTenantCode(), "wdSid", "app_id");
        String appkey = DmUtil.getUrl(ocRefundDomain.getTenantCode(), "wdAppkey", "appkey");
        String appsecret = DmUtil.getUrl(ocRefundDomain.getTenantCode(), "wdAppsecret", "appsecret");
        String shop_no = DmUtil.getUrl(ocRefundDomain.getTenantCode(), "zsSendgoodsShop_no", "shop_no");
        this.logger.error("wd.WdSendrefundService.saveSendrefund:url" + url + "sid" + sid + "appkey" + appkey + "appsecret" + appsecret + "shop_no" + shop_no);
        WdtClient client = new WdtClient(sid, appkey, appsecret, url);
        ArrayList api_refund_list = new ArrayList();
        ArrayList<WdGoodsOrder> order_list = new ArrayList<WdGoodsOrder>();
        if (ListUtil.isEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
            this.logger.error("wd.WdSendrefundService.saveSendrefund:OcRefundGoodsDomainisnull");
            return "error";
        }
        if ("B01".equals(ocRefundDomain.getRefundType())) {
            return this.trade_push(client, ocRefundDomain, shop_no, 2);
        }
        HashMap<String, String> map1 = new HashMap<String, String>();
        HashMap<String, String> contractMap = new HashMap<String, String>();
        contractMap.put("contractBillcode", ocRefundDomain.getContractBillcode());
        contractMap.put("tenantCode", ocRefundDomain.getTenantCode());
        map1.put("map", JsonUtil.buildNormalBinder().toJson(contractMap));
        String ocContractReDomainStr = (String)this.getInternalRouter().inInvoke("oc.contract.getContractByCode", map1);
        OcContractReDomain contractReDomain = (OcContractReDomain)JsonUtil.buildNonNullBinder().getJsonToObject(ocContractReDomainStr, OcContractReDomain.class);
        HashMap<String, OcContractGoodsDomain> map = new HashMap<String, OcContractGoodsDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : contractReDomain.getGoodsList()) {
            map.put(ocContractGoodsDomain.getContractGoodsCode(), ocContractGoodsDomain);
        }
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
            WdGoodsOrder wdGoodsOrder = new WdGoodsOrder();
            wdGoodsOrder.setOid(ocRefundGoodsDomain.getContractGoodsCode());
            wdGoodsOrder.setNum(ocRefundGoodsDomain.getRefundGoodsNum());
            wdGoodsOrder.setPrice(ocRefundGoodsDomain.getPricesetNprice());
            wdGoodsOrder.setStatus(80);
            wdGoodsOrder.setRefund_status(4);
            wdGoodsOrder.setGoods_id(ocRefundGoodsDomain.getGoodsNo());
            wdGoodsOrder.setSpec_id(ocRefundGoodsDomain.getSkuNo());
            wdGoodsOrder.setSpec_no(ocRefundGoodsDomain.getSkuNo());
            wdGoodsOrder.setGoods_name(ocRefundGoodsDomain.getGoodsName());
            wdGoodsOrder.setDiscount(BigDecimal.ZERO);
            wdGoodsOrder.setAdjust_amount(BigDecimal.ZERO);
            OcContractGoodsDomain ocContractGoodsDomain = (OcContractGoodsDomain)map.get(ocRefundGoodsDomain.getContractGoodsCode());
            BigDecimal sum = ocRefundGoodsDomain.getPricesetNprice().subtract(ocContractGoodsDomain.getContractGoodsPrice());
            wdGoodsOrder.setShare_discount(sum.multiply(ocRefundGoodsDomain.getRefundGoodsNum()));
            order_list.add(wdGoodsOrder);
        }
        HashMap<String, Object> api_refund_1 = new HashMap<String, Object>();
        api_refund_1.put("tid", ocRefundDomain.getContractBillcode());
        api_refund_1.put("platform_id", "127");
        api_refund_1.put("shop_no", shop_no);
        api_refund_1.put("refund_no", ocRefundDomain.getRefundCode());
        String type = ocRefundDomain.getRefundType();
        String status = "";
        if (StringUtils.isNotBlank((String)ocRefundDomain.getRefundType())) {
            if (type.equals("B02")) {
                type = "3";
                status = "goods_receiving";
                api_refund_1.put("logistics_no", ocRefundDomain.getPackageBillno());
                api_refund_1.put("logistics_name", ocRefundDomain.getPackageName());
            } else if (type.equals("B01")) {
                type = "1";
                status = "success";
            }
        }
        api_refund_1.put("type", new BigDecimal(type));
        api_refund_1.put("status", status);
        api_refund_1.put("buyer_nick", ocRefundDomain.getMemberBname());
        api_refund_1.put("refund_fee", ocRefundDomain.getRefundMoney());
        api_refund_1.put("refund_time", DateUtils.getCurrentTime());
        api_refund_1.put("reason", ocRefundDomain.getRefundEx());
        api_refund_1.put("desc", ocRefundDomain.getRefundMeo());
        api_refund_1.put("order_list", order_list);
        api_refund_list.add(api_refund_1);
        String api_refund_list_json = JsonUtil.buildNonNullBinder().toJson(api_refund_list);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("api_refund_list", api_refund_list_json);
        try {
            String response = client.execute("sales_refund_push.php", params, ocRefundDomain.getTenantCode());
            this.logger.error("wd.WdSendrefundService.sales_refund_push.php", (Object)("response" + JsonUtil.buildNonDefaultBinder().toJson((Object)response)));
            if (StringUtils.isNotBlank((String)response)) {
                Map jsonToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(response, String.class, String.class);
                if (MapUtil.isEmpty((Map)jsonToMap)) {
                    this.logger.error("wd.WdSendrefundService.saveSendgoods.jsonToMap", (Object)("response" + JsonUtil.buildNonDefaultBinder().toJson((Object)response)));
                    return "error";
                }
                if ("0".equals(jsonToMap.get("code"))) {
                    return "success";
                }
                this.logger.error("wd.WdSendrefundService.saveSendgoods.jsonToMapStr", (Object)("jsonToMap" + JsonUtil.buildNonDefaultBinder().toJson((Object)jsonToMap)));
                throw new ApiException("wd.WdSendrefundService\u8bf7\u6c42\u62a5\u9519");
            }
            this.logger.error("wd.WdSendrefundService.saveSendgoods.responseStr", (Object)("params" + JsonUtil.buildNonDefaultBinder().toJson(params)));
            return "error";
        }
        catch (IOException e) {
            this.logger.error("wd.WdSendrefundService.saveSendgoods.responseStr1", (Object)("params" + JsonUtil.buildNonDefaultBinder().toJson(params) + "e" + e));
            throw new ApiException("wd.WdSendrefundService\u8bf7\u6c42\u62a5\u9519");
        }
    }

    @Override
    public String querySendrefund(String tenantCode) throws ApiException {
        String url = "";
        url = DmUtil.getUrl(tenantCode, "wdUrl", "url");
        String sid = DmUtil.getUrl(tenantCode, "wdSid", "app_id");
        String appkey = DmUtil.getUrl(tenantCode, "wdAppkey", "appkey");
        String appsecret = DmUtil.getUrl(tenantCode, "wdAppsecret", "appsecret");
        String shop_no = DmUtil.getUrl(tenantCode, "zsSendgoodsShop_no", "shop_no");
        WdtClient client = new WdtClient(sid, appkey, appsecret, url);
        HashMap<String, String> params = new HashMap<String, String>();
        String start_time = DmUtil.getUrl(tenantCode, "start_time", "start_time");
        if (StringUtils.isNotBlank((String)start_time)) {
            params.put("start_time", start_time);
        } else {
            params.put("start_time", DateUtils.getYesterMinute());
        }
        params.put("end_time", DateUtils.getCurrentTime());
        if (StringUtils.isNotBlank((String)shop_no)) {
            params.put("shop_no", shop_no);
        }
        try {
            String response = client.execute("refund_query.php", params, tenantCode);
            this.logger.error("wd.WdSendrefundService.saveSendgoods.querySendrefund", (Object)("response" + JsonUtil.buildNonDefaultBinder().toJson((Object)response)));
            HashMap<String, String> parmra = new HashMap<String, String>();
            HashMap<String, String> map = new HashMap<String, String>();
            if (StringUtils.isNotBlank((String)response)) {
                Map jsonToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(response, String.class, Object.class);
                if (MapUtil.isEmpty((Map)jsonToMap)) {
                    this.logger.error("wd.WdSendrefundService.saveSendrefund.response:responseisnull");
                    return "error";
                }
                List list = (List)jsonToMap.get("refunds");
                HashMap<String, String> mapStr1 = new HashMap<String, String>();
                HashMap<String, String> mapStr2 = new HashMap<String, String>();
                for (Map mapStr : list) {
                    String refund_no = mapStr.get("src_no").toString();
                    String process_status = mapStr.get("process_status").toString();
                    BigDecimal data = new BigDecimal(process_status);
                    mapStr2.put("refundCode", refund_no);
                    mapStr2.put("tenantCode", tenantCode);
                    mapStr1.put("map", JsonUtil.buildNonNullBinder().toJson(mapStr2));
                    OcRefundReDomain ocContractReDomain = (OcRefundReDomain)this.getForObject("oc.refund.getRefundByCode", OcRefundReDomain.class, mapStr1);
                    if (ocContractReDomain == null) {
                        this.logger.info("wd.WdSendrefundService.querySendrefund", (Object)JsonUtil.buildNormalBinder().toJson(mapStr1));
                        continue;
                    }
                    if (2 != ocContractReDomain.getDataState()) {
                        this.logger.error("wd.WdSendrefundService.querySendrefundStr", (Object)("\u5df2\u5904\u7406" + mapStr1));
                        continue;
                    }
                    this.logger.error("wd.WdSendrefundService.saveSendgoods.querySendrefund.refund_no", (Object)("refund_no" + JsonUtil.buildNonDefaultBinder().toJson((Object)refund_no)));
                    if (data.compareTo(new BigDecimal("90")) == 0) {
                        parmra.put("refundCode", refund_no);
                        parmra.put("tenantCode", tenantCode);
                        map.put("newDataStatestr", process_status);
                        parmra.put("map", JsonUtil.buildNonNullBinder().toJson(map));
                        this.getInternalRouter().inInvoke(OC_REFUND_UPDATE_DATE, parmra);
                    }
                    if (data.compareTo(new BigDecimal("40")) != 0) continue;
                    parmra.put("refundCode", refund_no);
                    parmra.put("tenantCode", tenantCode);
                    map.put("newDataStatestr", process_status);
                    parmra.put("map", JsonUtil.buildNonNullBinder().toJson(map));
                    this.getInternalRouter().inInvoke("oc.refundEngine.sendRefundBack", parmra);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String sendrefund(OcRefundReDomain ocRefundDomain) throws ApiException {
        this.logger.error("wd.WdSendrefundService.sendrefund:ocRefundDomain" + JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        if (null == ocRefundDomain) {
            this.logger.error("wd.WdSendrefundService.sendrefund", (Object)"is null");
            return "error";
        }
        String url = DmUtil.getUrl(ocRefundDomain.getTenantCode(), "wdUrl", "url");
        String sid = DmUtil.getUrl(ocRefundDomain.getTenantCode(), "wdSid", "app_id");
        String appkey = DmUtil.getUrl(ocRefundDomain.getTenantCode(), "wdAppkey", "appkey");
        String appsecret = DmUtil.getUrl(ocRefundDomain.getTenantCode(), "wdAppsecret", "appsecret");
        String shop_no = DmUtil.getUrl(ocRefundDomain.getTenantCode(), "zsSendgoodsShop_no", "shop_no");
        this.logger.error("wd.WdSendrefundService.sendrefund:url" + url + "sid" + sid + "appkey" + appkey + "appsecret" + appsecret + "shop_no" + shop_no);
        WdtClient client = new WdtClient(sid, appkey, appsecret, url);
        return this.trade_push(client, ocRefundDomain, shop_no, 1);
    }

    private String trade_push(WdtClient client, OcRefundReDomain ocRefundDomain, String shop_no, Integer refund_status) {
        if (ListUtil.isEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
            this.logger.error("wd.WdSendrefundService.trade_push:OcRefundGoodsDomainisnull");
            return "error";
        }
        HashMap<String, OcRefundGoodsDomain> rGoodsMap = new HashMap<String, OcRefundGoodsDomain>();
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
            rGoodsMap.put(ocRefundGoodsDomain.getContractGoodsCode(), ocRefundGoodsDomain);
        }
        HashMap<String, String> map1 = new HashMap<String, String>();
        HashMap<String, String> contractMap = new HashMap<String, String>();
        contractMap.put("contractBillcode", ocRefundDomain.getContractBillcode());
        contractMap.put("tenantCode", ocRefundDomain.getTenantCode());
        map1.put("map", JsonUtil.buildNormalBinder().toJson(contractMap));
        String ocContractReDomainStr = (String)this.getInternalRouter().inInvoke("oc.contract.getContractByCode", map1);
        OcContractReDomain contractReDomain = (OcContractReDomain)JsonUtil.buildNonNullBinder().getJsonToObject(ocContractReDomainStr, OcContractReDomain.class);
        ArrayList<WdOrder> trade_list = new ArrayList<WdOrder>();
        Boolean refundStatus = true;
        BigDecimal goodsAllPrice = BigDecimal.ZERO;
        WdOrder wdOrder = new WdOrder();
        ArrayList<WdGoodsOrder> order_list = new ArrayList<WdGoodsOrder>();
        for (OcContractGoodsDomain goods : contractReDomain.getGoodsList()) {
            if (null == goods.getContractGoodsPrice()) {
                goods.setContractGoodsPrice(BigDecimal.ZERO);
            }
            if (null == goods.getPricesetNprice()) {
                goods.setPricesetNprice(BigDecimal.ZERO);
            }
            WdGoodsOrder wdGoodsOrder = new WdGoodsOrder();
            wdGoodsOrder.setOid(goods.getContractGoodsCode());
            wdGoodsOrder.setPrice(goods.getPricesetNprice());
            wdGoodsOrder.setNum(goods.getGoodsCamount());
            wdGoodsOrder.setStatus(30);
            wdGoodsOrder.setGoods_id(goods.getGoodsNo());
            wdGoodsOrder.setSpec_id(goods.getSkuNo());
            wdGoodsOrder.setSpec_no(goods.getSkuNo());
            wdGoodsOrder.setGoods_name(goods.getGoodsName());
            BigDecimal sum = goods.getPricesetNprice().subtract(goods.getContractGoodsPrice());
            wdGoodsOrder.setDiscount(BigDecimal.ZERO);
            wdGoodsOrder.setAdjust_amount(BigDecimal.ZERO);
            wdGoodsOrder.setShare_discount(sum.multiply(goods.getGoodsCamount()));
            wdGoodsOrder.setRefund_status(0);
            OcRefundGoodsDomain ocRefundGoodsDomain = (OcRefundGoodsDomain)rGoodsMap.get(goods.getContractGoodsCode());
            if (null != ocRefundGoodsDomain) {
                wdGoodsOrder.setRefund_status(refund_status);
                if (5 == refund_status) {
                    wdGoodsOrder.setStatus(80);
                }
            } else {
                if (null != goods.getRefundFlag() && 1 == goods.getRefundFlag()) {
                    wdGoodsOrder.setRefund_status(2);
                }
                if (null != goods.getRefundFlag() && 2 == goods.getRefundFlag()) {
                    wdGoodsOrder.setStatus(80);
                    wdGoodsOrder.setRefund_status(5);
                }
            }
            if (5 != wdGoodsOrder.getRefund_status()) {
                refundStatus = false;
            }
            if (0 == wdGoodsOrder.getRefund_status() || 1 == wdGoodsOrder.getRefund_status() || 2 == wdGoodsOrder.getRefund_status()) {
                goodsAllPrice = goodsAllPrice.add(wdGoodsOrder.getPrice().multiply(wdGoodsOrder.getNum()).add(wdGoodsOrder.getAdjust_amount()).subtract(wdGoodsOrder.getDiscount()).subtract(wdGoodsOrder.getShare_discount()));
            }
            order_list.add(wdGoodsOrder);
        }
        wdOrder.setTid(contractReDomain.getContractBillcode());
        if (refundStatus.booleanValue()) {
            wdOrder.setTrade_status(80);
        } else {
            wdOrder.setTrade_status(30);
        }
        wdOrder.setDelivery_term(1);
        wdOrder.setTrade_time(contractReDomain.getGmtCreate());
        wdOrder.setBuyer_nick(contractReDomain.getMemberBname());
        String arrdress = contractReDomain.getGoodsReceiptArrdess();
        String receiver_province = "";
        String receiver_city = "";
        String receiver_district = "";
        String receiver_address = "";
        if (StringUtils.isNotBlank((String)arrdress)) {
            receiver_province = arrdress.substring(0, 2);
            receiver_city = arrdress.substring(2, 5);
            receiver_district = arrdress.substring(5, 8);
            receiver_address = arrdress.substring(8);
        }
        wdOrder.setReceiver_province(receiver_province);
        wdOrder.setReceiver_city(receiver_city);
        wdOrder.setReceiver_district(receiver_district);
        wdOrder.setReceiver_address(receiver_address);
        wdOrder.setReceiver_mobile(contractReDomain.getGoodsReceiptPhone());
        wdOrder.setBuyer_message(contractReDomain.getContractRemark());
        wdOrder.setReceiver_name(contractReDomain.getGoodsReceiptMem());
        wdOrder.setPost_amount(contractReDomain.getGoodsLogmoney());
        wdOrder.setCod_amount(BigDecimal.ZERO);
        wdOrder.setOther_amount(BigDecimal.ZERO);
        wdOrder.setPaid(goodsAllPrice.add(wdOrder.getPost_amount()));
        wdOrder.setPay_status("2");
        wdOrder.setOrder_list(order_list);
        trade_list.add(wdOrder);
        String trade_list_json = JsonUtil.buildNormalBinder().toJson(trade_list);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("shop_no", shop_no);
        params.put("trade_list", trade_list_json);
        this.logger.error("wd.WdSendrefundService.trade_push.responseStr", (Object)("params" + JsonUtil.buildNonDefaultBinder().toJson(params)));
        String response = "";
        try {
            response = client.execute("trade_push.php", params, ocRefundDomain.getTenantCode());
            if (StringUtils.isNotBlank((String)response)) {
                Map jsonToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(response, String.class, String.class);
                if (MapUtil.isEmpty((Map)jsonToMap)) {
                    this.logger.error("wd.WdSendrefundService.trade_push.jsonToMap", (Object)("response" + JsonUtil.buildNonDefaultBinder().toJson((Object)response)));
                    return "error";
                }
                if ("0".equals(jsonToMap.get("code"))) {
                    return "success";
                }
                this.logger.error("wd.WdSendrefundService.trade_push.jsonToMapStr", (Object)("jsonToMap" + JsonUtil.buildNonDefaultBinder().toJson((Object)jsonToMap)));
                throw new ApiException("wd.WdSendrefundService\u8bf7\u6c42\u62a5\u9519");
            }
            this.logger.error("wd.WdSendrefundService.trade_push.responseStr", (Object)("params" + JsonUtil.buildNonDefaultBinder().toJson(params)));
            throw new ApiException("wd.WdSendrefundService\u8bf7\u6c42\u62a5\u9519");
        }
        catch (IOException e) {
            this.logger.error("wd.WdSendrefundService.trade_push.trade_push.php", (Object)("response" + JsonUtil.buildNonDefaultBinder().toJson((Object)response)));
            throw new ApiException("wd.WdSendrefundService\u8bf7\u6c42\u62a5\u9519");
        }
    }

    @Override
    public String sendrefund5(OcRefundReDomain ocRefundDomain) throws ApiException {
        this.logger.error("wd.WdSendrefundService.sendrefund5:ocRefundDomain" + JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        if (null == ocRefundDomain) {
            this.logger.error("wd.WdSendrefundService.sendrefund5", (Object)"is null");
            return "error";
        }
        String url = DmUtil.getUrl(ocRefundDomain.getTenantCode(), "wdUrl", "url");
        String sid = DmUtil.getUrl(ocRefundDomain.getTenantCode(), "wdSid", "app_id");
        String appkey = DmUtil.getUrl(ocRefundDomain.getTenantCode(), "wdAppkey", "appkey");
        String appsecret = DmUtil.getUrl(ocRefundDomain.getTenantCode(), "wdAppsecret", "appsecret");
        String shop_no = DmUtil.getUrl(ocRefundDomain.getTenantCode(), "zsSendgoodsShop_no", "shop_no");
        this.logger.error("wd.WdSendrefundService.sendrefund5:url" + url + "sid" + sid + "appkey" + appkey + "appsecret" + appsecret + "shop_no" + shop_no);
        WdtClient client = new WdtClient(sid, appkey, appsecret, url);
        return this.trade_push(client, ocRefundDomain, shop_no, 5);
    }

    public List<WdTrade> queryContract(WdtClient client, String tenantCode, String contractBillcode, String shop_no) throws ApiException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("src_tid", contractBillcode);
        params.put("shop_no", shop_no);
        String response = "";
        try {
            response = client.execute("trade_query.php", params, tenantCode);
        }
        catch (IOException e) {
            this.logger.error("wd.WdSendrefundService.queryContract.response", (Object)("params" + JsonUtil.buildNonDefaultBinder().toJson(params)));
            return null;
        }
        if (StringUtils.isNotBlank((String)response)) {
            Map jsonToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(response, String.class, Object.class);
            if (MapUtil.isEmpty((Map)jsonToMap)) {
                this.logger.error("wd.WdSendrefundService.queryContract.jsonToMap", (Object)("response" + response));
                return null;
            }
            if ("0".equals(String.valueOf(jsonToMap.get("code")))) {
                List trade_list = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(jsonToMap.get("trades")), WdTrade.class);
                return trade_list;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        String url = "https://sandbox.wangdian.cn/openapi2/";
        String sid = "apidevnew2";
        String appkey = "zihexin2-test";
        String appsecret = "d81f6ac3a";
        WdtClient client = new WdtClient(sid, appkey, appsecret, url);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("shop_no", "zihexin2-test");
        params.put("trade_list", "[{\"tid\":\"785452682375221259\",\"trade_status\":30,\"pay_status\":\"2\",\"delivery_term\":1,\"trade_time\":\"2023-12-08 16:17:41\",\"buyer_nick\":\"18800000000\",\"receiver_province\":\"\u5317\u4eac\",\"receiver_city\":\"\u5317\u4eac\u5e02\",\"receiver_district\":\"\u671d\u9633\u533a\",\"receiver_address\":\"\u516b\u91cc\u5e84\u8857\u905313213\",\"receiver_mobile\":\"19836985621\",\"buyer_message\":null,\"receiver_name\":\"\u6d4b\u8bd5\",\"post_amount\":33.00000000,\"cod_amount\":0,\"other_amount\":0,\"paid\":63.00000000,\"order_list\":[{\"oid\":\"4bed669773f644d89074b16fa5856977\",\"price\":5.00000000,\"num\":6.000000,\"status\":30,\"refund_status\":2,\"goods_id\":\"121lb\",\"spec_id\":\"121lb\",\"spec_no\":\"121lb\",\"goods_name\":\"121\u6d4b\u793c\u5305\u8d77\u8ba2\u91cf\",\"discount\":0,\"adjust_amount\":0,\"share_discount\":0E-14}]}]");
        String response = "";
        try {
            response = client.execute("trade_push.php", params);
            System.out.println(JsonUtil.buildNonDefaultBinder().toJson((Object)response));
            if (!StringUtils.isNotBlank((String)response)) return;
            Map jsonToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(response, String.class, String.class);
            System.out.println(JsonUtil.buildNonDefaultBinder().toJson((Object)jsonToMap));
            if (!"0".equals(jsonToMap.get("code"))) return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

