/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.wangdian.utils;

import com.yqbsoft.laser.bus.ext.data.wangdian.domain.LogRouterlogDomain;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.suppercore.SupperApiException;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;

public class WdtClient
extends BaseServiceImpl {
    private String appkey;
    private String appsecret;
    private String sid;
    private String baseUrl;
    private int connectTimeout = 3000;
    private int readTimeout = 15000;
    String api_code = "log.logRouterlog.saveRouterlog";
    private static final ExecutorService pool = Executors.newFixedThreadPool(50);
    @Autowired
    private InternalRouter internalRouter;

    public WdtClient(String sid, String appkey, String appsecret, String baseUrl) {
        this.sid = sid;
        this.appkey = appkey;
        this.appsecret = appsecret;
        this.baseUrl = baseUrl;
        if (!this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl + "/";
        }
    }

    public void setTimeout(int connectTimeout, int readTimeout) {
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    private static String getStringFromException(Throwable e) {
        String result = "";
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        e.printStackTrace(ps);
        try {
            result = bos.toString("UTF-8");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private static byte[] encryptMD5(String data) throws IOException {
        byte[] bytes = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            bytes = md.digest(data.getBytes("UTF-8"));
        }
        catch (GeneralSecurityException gse) {
            String msg = WdtClient.getStringFromException(gse);
            throw new IOException(msg);
        }
        return bytes;
    }

    private static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex);
        }
        return sign.toString();
    }

    public static String signRequest(Map<String, String> params, String appsecret) throws IOException {
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder query = new StringBuilder();
        for (Object key : keys) {
            if ("sign".equals(key)) continue;
            if (query.length() > 0) {
                query.append(';');
            }
            int len = ((String)key).length();
            query.append(String.format("%02d", len)).append('-').append((String)key).append(':');
            String value = params.get(key);
            len = value.length();
            query.append(String.format("%04d", len)).append('-').append(value);
        }
        query.append(appsecret);
        byte[] bytes = WdtClient.encryptMD5(query.toString());
        return WdtClient.byte2hex(bytes);
    }

    public String execute(String relativeUrl, Map<String, String> params, String tenantCode) throws IOException {
        params.put("appkey", this.appkey);
        params.put("sid", this.sid);
        params.put("timestamp", Long.toString(System.currentTimeMillis() / 1000L));
        params.put("sign", WdtClient.signRequest(params, this.appsecret));
        String response = WebUtils.doPost((String)(this.baseUrl + relativeUrl), params, (String)"UTF-8", (int)this.connectTimeout, (int)this.readTimeout, null);
        this.addlog(relativeUrl, response, params, tenantCode);
        return response;
    }

    public String execute(String relativeUrl, Map<String, String> params) throws IOException {
        params.put("appkey", this.appkey);
        params.put("sid", this.sid);
        params.put("timestamp", Long.toString(System.currentTimeMillis() / 1000L));
        params.put("sign", WdtClient.signRequest(params, this.appsecret));
        String response = WebUtils.doPost((String)(this.baseUrl + relativeUrl), params, (String)"UTF-8", (int)this.connectTimeout, (int)this.readTimeout, null);
        return response;
    }

    private void addlog(String relativeUrl, String execute, Map<String, String> map, String tenantCode) {
        try {
            LogRouterlogDomain logRouterlogDomain = new LogRouterlogDomain();
            logRouterlogDomain.setAppapiCode(relativeUrl);
            logRouterlogDomain.setAppapiVersion("1.0");
            logRouterlogDomain.setRouteDire("wd");
            logRouterlogDomain.setRouterlogName("wd");
            String msg = JsonUtil.buildNormalBinder().toJson(map);
            logRouterlogDomain.setRouterlogMessage(msg);
            logRouterlogDomain.setRouterlogMesid("wd");
            logRouterlogDomain.setTenantCode(tenantCode);
            logRouterlogDomain.setRouterlogReturn(execute);
            this.sendLog(logRouterlogDomain);
        }
        catch (Exception e) {
            throw new ApiException((Throwable)e);
        }
    }

    public void sendLog(LogRouterlogDomain logRouterlogDomain) {
        if (null == logRouterlogDomain) {
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("logRouterlogDomain", JsonUtil.buildNormalBinder().toJson((Object)logRouterlogDomain));
        this.inAsyncInvoke(this.api_code, paramMap);
    }

    public void inAsyncInvoke(final String apiCode, final Map<String, Object> paramMap) throws SupperApiException {
        if (pool != null) {
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    WdtClient.this.internalInvoke(apiCode, paramMap);
                }
            });
        }
    }

    public String internalInvoke(String apiCode, Map<String, Object> paramMap) {
        Object object;
        if (null == this.internalRouter) {
            this.internalRouter = (InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter");
        }
        if ((object = this.internalRouter.inInvoke(apiCode, "1.0", "0", paramMap)) == null) {
            return null;
        }
        return (String)object;
    }
}

