/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.service.impl;

import com.yqbsoft.laser.service.ext.bus.data.ComConstants;
import com.yqbsoft.laser.service.ext.bus.data.domain.ct.InventoryMessageRequestIn;
import com.yqbsoft.laser.service.ext.bus.data.domain.ct.InventoryMessageRequestInDatas;
import com.yqbsoft.laser.service.ext.bus.data.domain.ct.OrderMessageReturn;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsBrandDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsClasstreeDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsGoodsClassDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSkuDomain;
import com.yqbsoft.laser.service.ext.bus.data.facade.http.Esbfacade;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.rs.RsEsbGoodsRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.rs.RsEsbGoodsResponse;
import com.yqbsoft.laser.service.ext.bus.data.service.BusRsGoodsService;
import com.yqbsoft.laser.service.ext.bus.data.supbase.RsGoodsBaseService;
import com.yqbsoft.laser.service.ext.bus.data.util.HttpClientUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BusRsGoodsServiceImpl
extends RsGoodsBaseService
implements BusRsGoodsService {
    private String SYS_CODE = "busdata.BusRsGoodsServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusRsGoodsServiceImpl.class);

    @Override
    public String sendSaveBusGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        return null;
    }

    @Override
    public String sendSaveBusSku(RsSkuDomain rsSkuDomain) {
        return null;
    }

    @Override
    public String sendSaveBusClass(RsClasstreeDomain rsClasstreeDomain) {
        return null;
    }

    @Override
    public String sendSaveBusGoodsClass(RsGoodsClassDomain rsGoodsClassDomain) {
        return null;
    }

    @Override
    public String sendSaveBusBrand(RsBrandDomain rsBrandDomain) {
        return null;
    }

    @Override
    public String checkSkuByESB(String sku, String tenantCode) {
        String esbKey = this.getDdFlag(tenantCode, "EsbKey", "EsbKey");
        String esbSecret = this.getDdFlag(tenantCode, "EsbSecret", "EsbSecret");
        String url = this.getDdFlag(tenantCode, "EsbGoodsUrl", "EsbGoodsUrl");
        Esbfacade esbfacade = new Esbfacade(url, esbKey, esbSecret, null);
        String[] split = sku.split(",");
        RsEsbGoodsRequest rsEsbGoodsRequest = new RsEsbGoodsRequest();
        rsEsbGoodsRequest.setClientsecret(esbSecret);
        rsEsbGoodsRequest.setClientid(esbKey);
        rsEsbGoodsRequest.setHost(url);
        rsEsbGoodsRequest.setIT_MATNR(split);
        RsEsbGoodsResponse ocContractResponse = esbfacade.execute(rsEsbGoodsRequest);
        if (null == ocContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.ocContractResponse");
            return this.makeErrorReturn("-1", ocContractResponse.getDataObj());
        }
        if (!ocContractResponse.getSuccess().booleanValue()) {
            return this.makeErrorReturn("-1", ocContractResponse.getDataObj());
        }
        return this.makeSuccessReturn(ocContractResponse.getDataObj());
    }

    public static void main(String[] args) {
        String esbKey = "WYDS-TRMF98BC";
        String esbSecret = "WYDS#@YFD";
        String url = "https://ipaasqas.rifeng.com.cn:31443/298153907928989696/SAP/Z_NRS_003/1.0.0";
        String sku = "";
        Esbfacade esbfacade = new Esbfacade(url, esbKey, esbSecret, null);
        String[] split = sku.split(",");
        RsEsbGoodsRequest rsEsbGoodsRequest = new RsEsbGoodsRequest();
        rsEsbGoodsRequest.setClientsecret(esbSecret);
        rsEsbGoodsRequest.setClientid(esbKey);
        rsEsbGoodsRequest.setHost(url);
        rsEsbGoodsRequest.setIT_MATNR(split);
        RsEsbGoodsResponse ocContractResponse = esbfacade.execute(rsEsbGoodsRequest);
        if (null == ocContractResponse) {
            // empty if block
        }
        System.out.println(ocContractResponse.getDataObj());
    }

    @Override
    public OrderMessageReturn StockSearch(String tenantCode, String skus, String warehouse_code, String start_created, String end_created, String end_modified, Double page_size, Double page_no) {
        OrderMessageReturn orderMessageReturn = new OrderMessageReturn();
        if (StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".inventoryUpload tenantCode is null");
            orderMessageReturn.setCode("-1");
            orderMessageReturn.setMsg("\u79df\u6237\u4e3a\u7a7a");
            return orderMessageReturn;
        }
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("app_key", "1722319224");
        mapStr.put("timestamp", ComConstants.requestTimestamp());
        mapStr.put("app_sign", "CABAEE47A484A85FFC7CC217B61B4228");
        mapStr.put("start_modified", "2024-07-31 11:00:00");
        mapStr.put("owner_code", "HEGII");
        if (skus != null) {
            mapStr.put("skus", skus);
        }
        if (warehouse_code != null) {
            mapStr.put("warehouse_code", warehouse_code);
        }
        if (start_created != null) {
            mapStr.put("start_created", start_created);
        }
        if (end_created != null) {
            mapStr.put("end_created", end_created);
        }
        if (end_modified != null) {
            mapStr.put("end_modified", end_modified);
        }
        if (page_size != null) {
            mapStr.put("page_size", String.valueOf(page_size));
        }
        if (page_no != null) {
            mapStr.put("page_no", String.valueOf(page_no));
        }
        String url = "http://omsdev.hegii.com:9110/oms/webservice.php/?method=Stock.Search";
        String json = HttpClientUtil.doGet(url, mapStr);
        logger.error(this.SYS_CODE + "inventoryUpload json", (Object)json);
        InventoryMessageRequestIn inventoryMessageRequestIn = (InventoryMessageRequestIn)JsonUtil.buildNormalBinder().getJsonToObject(json, InventoryMessageRequestIn.class);
        if (null == inventoryMessageRequestIn) {
            logger.error(this.SYS_CODE + ".inventoryUpload inventoryMessageRequestIn is null");
            orderMessageReturn.setCode("-1");
            orderMessageReturn.setMsg("\u6570\u636e\u5f02\u5e381");
            return orderMessageReturn;
        }
        List<InventoryMessageRequestInDatas> datas = inventoryMessageRequestIn.getDatas();
        if (ListUtil.isEmpty(datas)) {
            logger.error(this.SYS_CODE + ".inventoryUpload datas is null", (Object)json);
            orderMessageReturn.setCode("-1");
            orderMessageReturn.setMsg("\u6570\u636e\u5f02\u5e382");
            return orderMessageReturn;
        }
        HashMap<String, Object> stockmap = new HashMap<String, Object>();
        for (InventoryMessageRequestInDatas data : datas) {
            String shop_sku_id = data.getShop_sku_id();
            Integer qty = data.getQty();
            if (StringUtils.isBlank((String)shop_sku_id)) {
                logger.error(this.SYS_CODE + ".inventoryUpload datas is error", (Object)json);
                orderMessageReturn.setCode("-1");
                orderMessageReturn.setMsg("\u6570\u636e\u5f02\u5e383");
            }
            stockmap.put(data.getShop_sku_id(), data.getQty());
        }
        try {
            this.updateStockJst(stockmap, tenantCode);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".updateStockJst datas is error", (Object)e.getMessage());
            orderMessageReturn.setMsg("\u66f4\u65b0\u5e93\u5b58\u5931\u8d25");
            orderMessageReturn.setCode("-1");
            return orderMessageReturn;
        }
        orderMessageReturn.setMsg("\u6267\u884c\u6210\u529f");
        orderMessageReturn.setCode("0");
        return orderMessageReturn;
    }

    public void updateStockJst(Map<String, Object> stockMap, String tenantCode) {
        String apiCode = "rs.resourceGoods.updateStockJst";
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(stockMap));
        param.put("tenantCode", tenantCode);
        this.internalInvoke(apiCode, param);
    }

    @Override
    public String sendUpBusGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        return null;
    }

    @Override
    public String sendUpBusSku(RsSkuDomain rsSkuDomain) {
        return null;
    }

    @Override
    public String sendDownBusGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        return null;
    }

    @Override
    public String sendDownBusSku(RsSkuDomain rsSkuDomain) {
        return null;
    }
}

