/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.data.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.bus.data.ComConstants;
import com.yqbsoft.laser.service.ext.bus.data.domain.dis.DisChannelReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcContractReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcContractproDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.oc.OcRefundReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.DataDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.DataRefundDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.OrderExpress;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.QueryDataResult;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.QueryResultDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RefundResult;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RefundResultDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsGoodsRelReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.rs.RsSkuReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoodsLogReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.sg.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmAddressReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.wh.WhGoodsBean;
import com.yqbsoft.laser.service.ext.bus.data.facade.http.Esbfacade;
import com.yqbsoft.laser.service.ext.bus.data.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.oc.OcContractRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.oc.OcEsbContractRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.oc.OcSapContractRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.sg.SgSendgoodsLogRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.sg.SgSendgoodsRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.wh.WhFreightFeeRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.request.wh.WhStockStateFeeRequest;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.oc.EsbContractResponse;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.oc.SapContractResponse;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.sg.SgSendgoodsLogResponse;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.sg.SgSendgoodsResponse;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.wh.WhFreightFeeResponse;
import com.yqbsoft.laser.service.ext.bus.data.facade.response.wh.WhStockStateResponse;
import com.yqbsoft.laser.service.ext.bus.data.service.BusOrderService;
import com.yqbsoft.laser.service.ext.bus.data.supbase.OrderBaseService;
import com.yqbsoft.laser.service.ext.bus.data.util.HttpClientUtil;
import com.yqbsoft.laser.service.ext.bus.data.util.OKHttpClientUtil;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class BusOrderServiceImpl
extends OrderBaseService
implements BusOrderService {
    private String SYS_CODE = "busdata.BusOrderServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusOrderServiceImpl.class);
    private String ddcode = "order";
    @Autowired
    RestTempfacade restTempfacade;

    @Override
    public String sendSaveBusOrder(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrder.ocContractDomain");
            return "error";
        }
        String tenantCode = ocContractDomain.getTenantCode();
        OcContractRequest ocContractRequest = new OcContractRequest();
        ocContractRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        this.makeOcContractReDomain(ocContractDomain);
        ocContractRequest.setOrgTenantCode(ocContractDomain.getTenantCode());
        String t = this.getTenantCodeBuUrl(ocContractRequest.getHost());
        if (StringUtils.isNotBlank((String)t)) {
            ocContractDomain.setTenantCode(t);
        }
        ocContractRequest.getSendMap().put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        logger.info(this.SYS_CODE + ".sendSaveExGoods.req", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        String s = this.restTempfacade.internalInvoke("app.exOrder.sendSaveExOrder", paramMap);
        logger.info(this.SYS_CODE + ".sendSaveExGoods.res", (Object)s);
        return "success";
    }

    @Override
    public String getFreight(List<WhGoodsBean> whGoodsBeanList, String areaStr, String memberCode, String tenantCode) throws ApiException {
        if (ListUtil.isEmpty(whGoodsBeanList) || StringUtils.isBlank((String)areaStr) || StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".getFreight.param");
            return "error";
        }
        WhFreightFeeRequest whFreightFeeRequest = new WhFreightFeeRequest();
        whFreightFeeRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        whFreightFeeRequest.setOrgTenantCode(tenantCode);
        String t = this.getTenantCodeBuUrl(whFreightFeeRequest.getHost());
        if (StringUtils.isBlank((String)t)) {
            t = tenantCode;
        }
        whFreightFeeRequest.getSendMap().put("whGoodsBeanList", JsonUtil.buildNormalBinder().toJson(whGoodsBeanList));
        whFreightFeeRequest.getSendMap().put("areaStr", areaStr);
        whFreightFeeRequest.getSendMap().put("memberCode", memberCode);
        whFreightFeeRequest.getSendMap().put("tenantCode", tenantCode);
        WhFreightFeeResponse whFreightFeeResponse = this.restTempfacade.execute(whFreightFeeRequest);
        if (null == whFreightFeeResponse) {
            logger.error(this.SYS_CODE + ".getFreight.whFreightFeeResponse");
            return "error";
        }
        if (!whFreightFeeResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".getFreight.whFreightFeeResponsemsg", (Object)whFreightFeeResponse.getMsg());
            return whFreightFeeResponse.getMsg();
        }
        return whFreightFeeResponse.getFreightFee().toString();
    }

    @Override
    public List<WhGoodsBean> getNewStockById(List<WhGoodsBean> whGoodsBeanList, String areaStr, String memberCode, String tenantCode) throws ApiException {
        if (ListUtil.isEmpty(whGoodsBeanList) || StringUtils.isBlank((String)areaStr) || StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".getNewStockById.param");
            return null;
        }
        WhStockStateFeeRequest whStockStateFeeRequest = new WhStockStateFeeRequest();
        whStockStateFeeRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        whStockStateFeeRequest.setOrgTenantCode(tenantCode);
        String t = this.getTenantCodeBuUrl(whStockStateFeeRequest.getHost());
        if (StringUtils.isBlank((String)t)) {
            t = tenantCode;
        }
        whStockStateFeeRequest.getSendMap().put("whGoodsBeanList", JsonUtil.buildNormalBinder().toJson(whGoodsBeanList));
        whStockStateFeeRequest.getSendMap().put("areaStr", areaStr);
        whStockStateFeeRequest.getSendMap().put("memberCode", memberCode);
        whStockStateFeeRequest.getSendMap().put("tenantCode", tenantCode);
        WhStockStateResponse whStockStateResponse = this.restTempfacade.execute(whStockStateFeeRequest);
        if (null == whStockStateResponse) {
            logger.error(this.SYS_CODE + ".getNewStockById.whStockStateResponse");
            return null;
        }
        if (!whStockStateResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".getNewStockById.whStockStateResponse", (Object)whStockStateResponse.getMsg());
            return null;
        }
        return whStockStateResponse.getWhGoodsBeanList();
    }

    private void makeOcContractReDomain(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            return;
        }
        String memberCcode = ocContractDomain.getMemberCcode();
        if (StringUtils.isBlank((String)memberCcode)) {
            return;
        }
        DisChannelReDomain disChannelReDomain = this.getDisChannelByMemberCcode(memberCcode, ocContractDomain.getTenantCode());
        if (null == disChannelReDomain) {
            return;
        }
        ocContractDomain.setChannelCode(disChannelReDomain.getChannelOcode());
    }

    @Override
    public String sendSaveBusRefund(OcRefundReDomain ocRefundDomain) {
        logger.error(this.SYS_CODE + ".sendSaveBusRefund.ocRefundDomain.1", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        Long startTime = System.currentTimeMillis();
        if (null == ocRefundDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefund.ocRefundDomain", (Object)"isnull");
            return "error";
        }
        String url = "";
        url = this.getdd(ocRefundDomain.getTenantCode(), "omsUrl", "omsUrl");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefund.url", (Object)"url\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String appKey = "";
        appKey = this.getdd(ocRefundDomain.getTenantCode(), "appKey", "appKey");
        if (StringUtils.isBlank((String)appKey)) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefund\uff0cappKey", (Object)"appKey\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String appSecret = "";
        appSecret = this.getdd(ocRefundDomain.getTenantCode(), "appSecret", "appSecret");
        if (StringUtils.isBlank((String)appSecret)) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefund\uff0cappSecret", (Object)"appSecret\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String GshopCode = "";
        GshopCode = this.getdd(ocRefundDomain.getTenantCode(), "GshopCode", "GshopCode");
        if (StringUtils.isBlank((String)GshopCode)) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefund\uff0cGshopCode", (Object)"GshopCode\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String NshopCode = "";
        NshopCode = this.getdd(ocRefundDomain.getTenantCode(), "NshopCode", "NshopCode");
        if (StringUtils.isBlank((String)NshopCode)) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefund\uff0cNshopCode", (Object)"NshopCode\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("method", "oms.SdkRefundAdd");
        mapStr.put("app_key", appKey);
        mapStr.put("timestamp", ComConstants.requestTimestamp());
        mapStr.put("app_sign", "1722319224");
        String data = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        map.put("shop_code", GshopCode);
        if ("738401021359284283".equals(ocRefundDomain.getChannelCode())) {
            map.put("shop_code", NshopCode);
        }
        map.put("refund_type", "");
        map.put("refund_id", ocRefundDomain.getRefundCode());
        map.put("tid", ocRefundDomain.getRefundCode());
        map.put("refund_fee", ocRefundDomain.getRefundMoney());
        map.put("refund_express_code", "");
        map.put("status", "1");
        if (2 == ocRefundDomain.getDataState()) {
            map.put("c_status", "1");
        }
        if (3 == ocRefundDomain.getDataState()) {
            map.put("c_status", "2");
        }
        if (-1 == ocRefundDomain.getDataState()) {
            map.put("c_status", "3");
        }
        map.put("refund_express_no", "");
        map.put("warehouse_code", "");
        map.put("refund_mode", "");
        map.put("refundment_type", "");
        map.put("refund_reason", "");
        map.put("refund_remarks", ocRefundDomain.getContractRemark());
        map.put("refund_person_account", "");
        map.put("refund_person_name", "");
        map.put("refund_postage", "");
        map.put("install_price", "");
        map.put("delivery_price", "");
        map.put("demolition_price", "");
        List<OcRefundGoodsDomain> ocRefundGoodsList = ocRefundDomain.getOcRefundGoodsDomainList();
        HashMap<String, Object> hashmap = new HashMap<String, Object>();
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundGoodsList) {
            hashmap.put("sku", ocRefundGoodsDomain.getSkuNo());
            hashmap.put("num", ocRefundGoodsDomain.getGoodsContract());
            hashmap.put("refund_fee", ocRefundGoodsDomain.getContractGoodsMoney());
            hashmap.put("is_change", "");
            hashmap.put("is_gift", "0");
            if ("1".equals(ocRefundGoodsDomain.getContractGoodsGtype())) {
                hashmap.put("is_gift", "1");
            }
            list.add(hashmap);
        }
        map.put("list", list);
        mapStr.put("refund", JsonUtil.buildNormalBinder().toJson(map));
        logger.error(this.SYS_CODE + ".sendSaveBusRefund.returnResultsMap.map" + JsonUtil.buildNormalBinder().toJson(map));
        try {
            data = HttpClientUtil.doGet(url, mapStr);
            System.out.println(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.error(this.SYS_CODE + ".sendSaveBusRefund.returnResultsMap.code" + JsonUtil.buildNormalBinder().toJson(mapStr), (Object)(data + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefund.returnResultsMap" + JsonUtil.buildNormalBinder().toJson(mapStr), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("status");
        long code1 = Long.parseLong(code.toString());
        if (code1 > 0L) {
            return "success";
        }
        return "error";
    }

    @Override
    public String sendSaveBusSendgoods(SgSendgoodsReDomain sgSendgoodsDomain) {
        if (null == sgSendgoodsDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoods.sgSendgoodsDomain");
            return "error";
        }
        String tenantCode = sgSendgoodsDomain.getTenantCode();
        SgSendgoodsRequest sgSendgoodsRequest = new SgSendgoodsRequest();
        sgSendgoodsRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        try {
            BeanUtils.copyAllPropertys((Object)sgSendgoodsRequest, (Object)sgSendgoodsDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.e", (Object)e);
            return "error";
        }
        SgSendgoodsResponse sgSendgoodsResponse = this.restTempfacade.execute(sgSendgoodsRequest);
        if (null == sgSendgoodsResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.sgSendgoodsResponse");
            return "error";
        }
        if (!sgSendgoodsResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.sgSendgoodsResponse", (Object)sgSendgoodsResponse.getMsg());
            return sgSendgoodsResponse.getMsg();
        }
        return "success";
    }

    public OcContractReDomain getContractDomain(String contractBillcode, String tenantCode) {
        String apiCode = "oc.contract.getContractByCode";
        HashMap<String, String> param = new HashMap<String, String>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("contractBillcode", contractBillcode);
        paramMap.put("tenantCode", tenantCode);
        param.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        String OcContractReDomainStr = this.internalInvoke(apiCode, param);
        if (StringUtils.isBlank((String)OcContractReDomainStr)) {
            return null;
        }
        return (OcContractReDomain)JsonUtil.buildNormalBinder().getJsonToObject(OcContractReDomainStr, OcContractReDomain.class);
    }

    @Override
    public String sendSaveBusSendgoodsOms(String tenantCode, String tid) {
        if (StringUtils.isBlank((String)tenantCode)) {
            tenantCode = "2023072819990101";
        }
        if (StringUtils.isBlank((String)tid)) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsOms\uff0ctid", (Object)"tid\u4e3a\u7a7a");
            return "error";
        }
        String url = "";
        url = this.getdd(tenantCode, "omsUrl", "omsUrl");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsOms\uff0curl", (Object)"url\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String appKey = "";
        appKey = this.getdd(tenantCode, "appKey", "appKey");
        if (StringUtils.isBlank((String)appKey)) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsOms\uff0cappKey", (Object)"appKey\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String appSecret = "";
        appSecret = this.getdd(tenantCode, "appSecret", "appSecret");
        if (StringUtils.isBlank((String)appSecret)) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsOms\uff0cappSecret", (Object)"appSecret\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String GshopCode = "";
        GshopCode = this.getdd(tenantCode, "GshopCode", "GshopCode");
        if (StringUtils.isBlank((String)GshopCode)) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsOms\uff0cGshopCode", (Object)"GshopCode\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String NshopCode = "";
        NshopCode = this.getdd(tenantCode, "NshopCode", "NshopCode");
        if (StringUtils.isBlank((String)NshopCode)) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsOms\uff0cNshopCode", (Object)"NshopCode\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        OcContractReDomain ocContractDomain = this.getContractDomain(tid, tenantCode);
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsOms\uff0cocContractDomain", (Object)(tid + "==" + tenantCode));
            return "error";
        }
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("method", "oms.OrderQueryInfoByTid");
        mapStr.put("app_key", appKey);
        mapStr.put("timestamp", ComConstants.requestTimestamp());
        mapStr.put("app_sign", "");
        mapStr.put("shop_code", GshopCode);
        if ("738401021359284283".equals(ocContractDomain.getChannelCode())) {
            mapStr.put("shop_code", NshopCode);
        }
        mapStr.put("tid", tid);
        String data = null;
        try {
            data = HttpClientUtil.doGet(url, mapStr);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsOms.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(mapStr));
        }
        QueryResultDomain queryResultDomain = (QueryResultDomain)JsonUtil.buildNormalBinder().getJsonToObject(data, QueryResultDomain.class);
        DataDomain data1 = queryResultDomain.getData();
        List<QueryDataResult> result = data1.getResult();
        if (ListUtil.isEmpty(result)) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsOms result is null");
            return "error";
        }
        for (QueryDataResult queryResult : result) {
            String orderNo = queryResult.getOrderNo();
            OcContractReDomain contractDomain = this.getContractDomain(orderNo, tenantCode);
            String res = this.saveSgSendGoods(this.makeSgSendGoodsDomain(queryResultDomain, tenantCode, contractDomain));
            if (!StringUtils.isBlank((String)res) && "success".equals(res)) continue;
            return "error";
        }
        return "success";
    }

    @Override
    public String sendSaveBusSendgoodsLog(SgSendgoodsLogReDomain sgSendgoodsLogDomain) {
        if (null == sgSendgoodsLogDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogDomain");
            return "error";
        }
        String tenantCode = sgSendgoodsLogDomain.getTenantCode();
        SgSendgoodsLogRequest sgSendgoodsLogRequest = new SgSendgoodsLogRequest();
        sgSendgoodsLogRequest.init(this.getDdMap(tenantCode, this.ddcode, "busdata"));
        try {
            BeanUtils.copyAllPropertys((Object)sgSendgoodsLogRequest, (Object)sgSendgoodsLogDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.e", (Object)e);
            return "error";
        }
        SgSendgoodsLogResponse sgSendgoodsLogResponse = this.restTempfacade.execute(sgSendgoodsLogRequest);
        if (null == sgSendgoodsLogResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogResponse");
            return "error";
        }
        if (!sgSendgoodsLogResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogResponse", (Object)sgSendgoodsLogResponse.getMsg());
            return sgSendgoodsLogResponse.getMsg();
        }
        return "success";
    }

    private String saveSgSendGoods(SgSendgoodsDomain sgSendgoodsDomain) {
        String apiCode = "sg.sgOccontract.sendSaveManyPoolSendgoodsJst";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("sgSendgoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
        return this.internalInvoke(apiCode, paramMap);
    }

    private SgSendgoodsDomain makeSgSendGoodsDomain(QueryResultDomain orderMessageRequestIn, String tenantCode, OcContractReDomain contractReDomain) {
        logger.info(this.SYS_CODE + ".makeSgSendGoodsDomain", (Object)(JsonUtil.buildNormalBinder().toJson((Object)orderMessageRequestIn) + "==" + JsonUtil.buildNormalBinder().toJson((Object)contractReDomain)));
        SgSendgoodsDomain sgSendgoodsDomain = new SgSendgoodsDomain();
        ArrayList<SgSendgoodsGoodsDomain> sgSendgoodsGoodsDomains = new ArrayList<SgSendgoodsGoodsDomain>();
        BigDecimal sendNum = BigDecimal.ZERO;
        BigDecimal money = BigDecimal.ZERO;
        try {
            BeanUtils.copyAllPropertys((Object)sgSendgoodsDomain, (Object)contractReDomain);
        }
        catch (Exception e) {
            throw new ApiException(this.SYS_CODE + ".makeSgSendGoodsDomain.copy.e", (Throwable)e);
        }
        HashMap<String, OcContractGoodsDomain> ocContractGoodsDomainMap = new HashMap<String, OcContractGoodsDomain>();
        List<OcContractGoodsDomain> goodsList = contractReDomain.getGoodsList();
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getGoodsPro()) && ocContractGoodsDomain.getGoodsPro().equals("5")) {
                List ocContractGoodsDomains = null;
                if (!ListUtil.isNotEmpty(ocContractGoodsDomains)) continue;
                for (OcContractGoodsDomain item : ocContractGoodsDomains) {
                    ocContractGoodsDomainMap.put(item.getSkuNo(), item);
                }
                continue;
            }
            ocContractGoodsDomainMap.put(ocContractGoodsDomain.getSkuNo(), ocContractGoodsDomain);
        }
        DataDomain data = orderMessageRequestIn.getData();
        List<QueryDataResult> result = data.getResult();
        for (QueryDataResult queryDataResult : result) {
            List<OrderExpress> orderExpress = queryDataResult.getOrderExpress();
            for (OrderExpress orderExpres : orderExpress) {
                SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain = null;
                sgSendgoodsGoodsDomain = new SgSendgoodsGoodsDomain();
                sendNum = sendNum.add(new BigDecimal(orderExpres.getNum()));
                OcContractGoodsDomain ocContractGoodsDomain = (OcContractGoodsDomain)ocContractGoodsDomainMap.get(orderExpres.getSku());
                if (null == ocContractGoodsDomain) {
                    logger.error(this.SYS_CODE + ".makeSgSendGoodsDomain is null", (Object)(contractReDomain.getContractBillcode() + "==" + orderExpres.getSku()));
                    continue;
                }
                try {
                    BeanUtils.copyAllPropertys((Object)sgSendgoodsGoodsDomain, (Object)ocContractGoodsDomain);
                }
                catch (Exception e) {
                    throw new ApiException(this.SYS_CODE + ".makeSgSendGoodsDomain.copy.e", (Throwable)e);
                }
                sgSendgoodsGoodsDomain.setContractGoodsMoney(ocContractGoodsDomain.getContractGoodsPrice().multiply(new BigDecimal(orderExpres.getNum())));
                money = money.add(sgSendgoodsGoodsDomain.getContractGoodsMoney());
                sgSendgoodsGoodsDomain.setSendgoodsGoodsCamount(new BigDecimal(orderExpres.getNum()));
                sgSendgoodsGoodsDomain.setGoodsNum(new BigDecimal(orderExpres.getNum()));
                sgSendgoodsGoodsDomain.setGoodsCamount(new BigDecimal(orderExpres.getNum()));
                sgSendgoodsGoodsDomains.add(sgSendgoodsGoodsDomain);
            }
        }
        sgSendgoodsDomain.setContractSendnum(sendNum);
        sgSendgoodsDomain.setGoodsNum(sendNum);
        sgSendgoodsDomain.setGoodsMoney(money);
        sgSendgoodsDomain.setDataBmoney(money);
        sgSendgoodsDomain.setDataBnum(sendNum);
        sgSendgoodsDomain.setSgSendgoodsGoodsDomainList(sgSendgoodsGoodsDomains);
        return sgSendgoodsDomain;
    }

    @Override
    public String sendSaveBusRefundToEsb(OcRefundReDomain ocRefundDomain) {
        logger.error(this.SYS_CODE + ".sendSaveBusRefundToEsb.ocRefundDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        if (null == ocRefundDomain) {
            return "error";
        }
        String esbKey = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbRefundUrl", "EsbRefundUrl");
        String EsbWarehouseCode = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbWarehouseCode", "EsbWarehouseCode");
        String EsbOwnerCode = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbOwnerCode", "EsbOwnerCode");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap request = new HashMap();
        HashMap<String, String> entryOrder = new HashMap<String, String>();
        entryOrder.put("entryOrderCode", ocRefundDomain.getRefundCode());
        entryOrder.put("orderType", "THRK");
        entryOrder.put("warehouseCode", EsbWarehouseCode);
        entryOrder.put("ownerCode", EsbOwnerCode);
        HashMap orderLines = new HashMap();
        ArrayList orderLineList = new ArrayList();
        List<OcRefundGoodsDomain> refundGoodsList = ocRefundDomain.getOcRefundGoodsDomainList();
        for (OcRefundGoodsDomain goods : refundGoodsList) {
            if ("5".equals(goods.getGoodsPro())) {
                HashMap<String, Object> relmap = new HashMap<String, Object>();
                relmap.put("tenantCode", ocRefundDomain.getTenantCode());
                relmap.put("goodsSkuCode", goods.getGoodsCode());
                QueryResult<RsGoodsRelReDomain> relQueryResult = this.queryGoodsRelPage(relmap);
                if (null == relQueryResult && ListUtil.isEmpty((Collection)relQueryResult.getList())) {
                    logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse,relQueryResult is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
                    return "error";
                }
                for (RsGoodsRelReDomain rsGoodsRelReDomain : relQueryResult.getList()) {
                    HashMap<String, Object> orderLine = new HashMap<String, Object>();
                    orderLine.put("itemCode", rsGoodsRelReDomain.getSkuNo());
                    orderLine.put("ownerCode", EsbOwnerCode);
                    orderLine.put("itemName", rsGoodsRelReDomain.getGoodsName());
                    orderLine.put("planQty", goods.getGoodsCamount().multiply(rsGoodsRelReDomain.getGoodsRelNum()));
                    orderLineList.add(orderLine);
                }
                continue;
            }
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("ownerCode", EsbOwnerCode);
            orderLine.put("itemName", goods.getGoodsName());
            orderLine.put("itemCode", goods.getSkuNo());
            orderLine.put("planQty", goods.getRefundGoodsNum());
            orderLineList.add(orderLine);
        }
        orderLines.put("orderLine", orderLineList);
        request.put("entryOrder", entryOrder);
        request.put("orderLines", orderLines);
        map.put("request", request);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    @Override
    public String sendSaveBusRefundConfirmToEsb(OcRefundReDomain ocRefundDomain) {
        BigDecimal multiply;
        logger.error(this.SYS_CODE + ".sendSaveBusRefundConfirmToEsb.ocRefundDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        if (null == ocRefundDomain) {
            return "error";
        }
        String esbKey = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbOutConfirmUrl", "EsbOutConfirmUrl");
        String KUNNR = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbKUNNR", "EsbKUNNR");
        String NAME1 = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbNAME1", "EsbNAME1");
        String LGORT = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbLGORT", "EsbLGORT");
        String WERKS = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbWERKS", "EsbWERKS");
        String DLSBM = "";
        if (StringUtils.isNotBlank((String)ocRefundDomain.getMemberGcode())) {
            UmUserinfoReDomain userinfoByCode = this.getUserinfoByCode(ocRefundDomain.getMemberGcode(), ocRefundDomain.getTenantCode());
            DLSBM = userinfoByCode.getUserinfoOcode();
        }
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcSapContractRequest ocSapContractRequest = new OcSapContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        List<OcRefundGoodsDomain> ocRefundGoodsList = ocRefundDomain.getOcRefundGoodsDomainList();
        String date = BusOrderServiceImpl.getDate();
        int POSEX = 0;
        BigDecimal goodsmoney = ocRefundDomain.getContractMoney().subtract(ocRefundDomain.getGoodsLogmoney());
        BigDecimal totalCost = BigDecimal.ZERO;
        HashMap<String, BigDecimal> skuCostMap = new HashMap<String, BigDecimal>();
        HashMap<String, List> goodsRelList = new HashMap<String, List>();
        for (OcRefundGoodsDomain goods : ocRefundGoodsList) {
            if ("5".equals(goods.getGoodsPro())) {
                HashMap<String, Object> relmap = new HashMap<String, Object>();
                relmap.put("tenantCode", ocRefundDomain.getTenantCode());
                relmap.put("goodsSkuCode", goods.getGoodsCode());
                Iterator relQueryResult = this.queryGoodsRelPage(relmap);
                if (null == relQueryResult || ListUtil.isEmpty((Collection)relQueryResult.getList())) {
                    logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse,relQueryResult is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
                    return "error";
                }
                for (RsGoodsRelReDomain rsGoodsRelReDomain : relQueryResult.getList()) {
                    RsSkuReDomain skuByCode = this.getSkuByCode(rsGoodsRelReDomain.getSkuCode(), ocRefundDomain.getTenantCode());
                    if (null == skuByCode) {
                        logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse,skuByCode is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
                        return "error";
                    }
                    multiply = goods.getGoodsCamount().multiply(rsGoodsRelReDomain.getGoodsRelNum());
                    BigDecimal skuCost = skuByCode.getPricesetAsprice().multiply(multiply);
                    totalCost = totalCost.add(skuCost);
                    skuCostMap.put(rsGoodsRelReDomain.getSkuCode(), skuCost);
                }
                goodsRelList.put(goods.getGoodsCode(), relQueryResult.getList());
                continue;
            }
            BigDecimal skuCost = goods.getPricesetAsprice().multiply(goods.getGoodsCamount());
            totalCost = totalCost.add(skuCost);
            skuCostMap.put(goods.getSkuCode(), skuCost);
        }
        for (OcRefundGoodsDomain goods : ocRefundGoodsList) {
            if ("5".equals(goods.getGoodsPro())) {
                List rsGoodsRelReDomains = (List)goodsRelList.get(goods.getGoodsCode());
                for (RsGoodsRelReDomain rsGoodsRelReDomain : rsGoodsRelReDomains) {
                    BigDecimal skuCost = (BigDecimal)skuCostMap.get(rsGoodsRelReDomain.getSkuCode());
                    HashMap<String, Object> orderLine = new HashMap<String, Object>();
                    orderLine.put("BSTKD", ocRefundDomain.getRefundCode());
                    orderLine.put("POSEX", ++POSEX);
                    orderLine.put("AUART", "ZG02");
                    orderLine.put("KUNNR", KUNNR);
                    orderLine.put("NAME1", NAME1);
                    orderLine.put("FKDAT", date);
                    orderLine.put("KUNNR2", DLSBM);
                    orderLine.put("MATNR", rsGoodsRelReDomain.getSkuNo());
                    orderLine.put("ARKTX", rsGoodsRelReDomain.getGoodsName());
                    multiply = goods.getGoodsCamount().multiply(rsGoodsRelReDomain.getGoodsRelNum());
                    orderLine.put("KWMENG", multiply);
                    BigDecimal WRBTR = skuCost.divide(totalCost, 8, 5).multiply(goodsmoney);
                    orderLine.put("ACTPR", WRBTR.divide(multiply, 2, 5));
                    orderLine.put("WRBTR", WRBTR.setScale(2, 5));
                    orderLine.put("WERKS", WERKS);
                    orderLine.put("LGORT", LGORT);
                    list.add(orderLine);
                }
                continue;
            }
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("BSTKD", ocRefundDomain.getRefundCode());
            orderLine.put("POSEX", ++POSEX);
            orderLine.put("AUART", "ZG02");
            orderLine.put("KUNNR", KUNNR);
            orderLine.put("NAME1", NAME1);
            orderLine.put("FKDAT", date);
            orderLine.put("KUNNR2", DLSBM);
            orderLine.put("MATNR", goods.getSkuNo());
            orderLine.put("ARKTX", goods.getGoodsName());
            BigDecimal skuCost = (BigDecimal)skuCostMap.get(goods.getSkuCode());
            BigDecimal WRBTR = skuCost.divide(totalCost, 8, 5).multiply(goodsmoney);
            orderLine.put("KWMENG", goods.getGoodsCamount());
            orderLine.put("ACTPR", WRBTR.divide(goods.getGoodsCamount(), 2, 5));
            orderLine.put("WRBTR", WRBTR.setScale(2, 5));
            orderLine.put("WERKS", WERKS);
            orderLine.put("LGORT", LGORT);
            list.add(orderLine);
        }
        if (ocRefundDomain.getGoodsLogmoney().compareTo(BigDecimal.ZERO) > 0) {
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("BSTKD", ocRefundDomain.getRefundCode());
            orderLine.put("POSEX", ++POSEX);
            orderLine.put("AUART", "ZG01");
            orderLine.put("KUNNR", KUNNR);
            orderLine.put("KUNNR2", DLSBM);
            orderLine.put("NAME1", NAME1);
            orderLine.put("FKDAT", date);
            orderLine.put("MATNR", "9100000273");
            orderLine.put("ARKTX", "\u4ef7\u5916\u8d39\u7528");
            orderLine.put("KWMENG", 1);
            orderLine.put("ACTPR", ocRefundDomain.getGoodsLogmoney());
            orderLine.put("WRBTR", ocRefundDomain.getGoodsLogmoney().setScale(2, 5));
            orderLine.put("WERKS", WERKS);
            orderLine.put("LGORT", LGORT);
            list.add(orderLine);
        }
        map.put("list", list);
        ocSapContractRequest.setMap(map);
        ocSapContractRequest.setClientsecret(esbSecret);
        ocSapContractRequest.setClientid(esbKey);
        ocSapContractRequest.setHost(url);
        SapContractResponse sapContractResponse = invoicefacade.execute(ocSapContractRequest);
        if (null == sapContractResponse) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefundConfirmToEsb.esbContractResponse");
            return "error";
        }
        if (!sapContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    @Override
    public String sendContractDomainToEsb(OcContractReDomain ocContractDomain) {
        String[] split;
        logger.error(this.SYS_CODE + ".sendContractDomainToEsb.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain) {
            return "error";
        }
        String esbKey = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbOrderUrl", "EsbOrderUrl");
        String EsbWarehouseCode = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbWarehouseCode", "EsbWarehouseCode");
        String EsbOwnerCode = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbOwnerCode", "EsbOwnerCode");
        String EsbSourcePlatformCode = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbSourcePlatformCode", "EsbSourcePlatformCode");
        String EsbLogisticsCode = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbLogisticsCode", "EsbLogisticsCode");
        String EsbShopNick = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbShopNick", "EsbShopNick");
        String EsbSenderInfo = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbSenderInfo", "EsbSenderInfo");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap request = new HashMap();
        HashMap<String, Object> deliveryOrder = new HashMap<String, Object>();
        deliveryOrder.put("deliveryOrderCode", ocContractDomain.getContractBillcode());
        deliveryOrder.put("orderType", "XSDD");
        deliveryOrder.put("warehouseCode", EsbWarehouseCode);
        deliveryOrder.put("ownerCode", EsbOwnerCode);
        deliveryOrder.put("sourcePlatformCode", EsbSourcePlatformCode);
        deliveryOrder.put("logisticsCode", EsbLogisticsCode);
        deliveryOrder.put("shopNick", EsbShopNick);
        HashMap orderLines = new HashMap();
        Map senderInfo = new HashMap();
        if (StringUtils.isNotBlank((String)EsbSenderInfo)) {
            senderInfo = (Map)JsonUtil.buildNormalBinder().getJsonToMap(EsbSenderInfo, String.class, Object.class);
            deliveryOrder.put("senderInfo", senderInfo);
        }
        HashMap<String, String> receiverInfo = new HashMap<String, String>();
        receiverInfo.put("name", ocContractDomain.getGoodsReceiptMem());
        receiverInfo.put("mobile", ocContractDomain.getGoodsReceiptPhone());
        if (ListUtil.isNotEmpty(ocContractDomain.getOcContractproDomainList())) {
            for (OcContractproDomain ocContractproDomain : ocContractDomain.getOcContractproDomainList()) {
                String[] umAddressReDomain;
                if (!"address".equals(ocContractproDomain.getContractproKey()) || null == (umAddressReDomain = (UmAddressReDomain)JsonUtil.buildNormalBinder().getJsonToObject(ocContractproDomain.getContractproValue(), UmAddressReDomain.class))) continue;
                receiverInfo.put("province", umAddressReDomain.getProvinceName());
                receiverInfo.put("city", umAddressReDomain.getCityName());
                String detailAddress = "";
                if (StringUtils.isNotBlank((String)umAddressReDomain.getProvinceName())) {
                    detailAddress = umAddressReDomain.getProvinceName();
                }
                if (StringUtils.isNotBlank((String)umAddressReDomain.getCityName())) {
                    detailAddress = detailAddress + umAddressReDomain.getCityName();
                }
                if (StringUtils.isNotBlank((String)umAddressReDomain.getAreaName())) {
                    detailAddress = detailAddress + umAddressReDomain.getAreaName();
                }
                if (StringUtils.isNotBlank((String)umAddressReDomain.getRoadName())) {
                    detailAddress = detailAddress + umAddressReDomain.getRoadName();
                }
                if (StringUtils.isNotBlank((String)umAddressReDomain.getAddressDetail())) {
                    detailAddress = detailAddress + umAddressReDomain.getAddressDetail();
                }
                receiverInfo.put("detailAddress", detailAddress);
            }
        }
        if (null == receiverInfo.get("detailAddress") && (split = ocContractDomain.getGoodsReceiptArrdess().split(",")).length > 3) {
            receiverInfo.put("province", split[0]);
            receiverInfo.put("city", split[1]);
            String detailAddress = "";
            for (String str : split) {
                detailAddress = detailAddress + str;
            }
            receiverInfo.put("detailAddress", detailAddress);
        }
        deliveryOrder.put("receiverInfo", receiverInfo);
        ArrayList orderLineList = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        for (OcContractGoodsDomain goods : goodsList) {
            if ("5".equals(goods.getGoodsPro())) {
                HashMap<String, Object> relmap = new HashMap<String, Object>();
                relmap.put("tenantCode", ocContractDomain.getTenantCode());
                relmap.put("goodsSkuCode", goods.getGoodsCode());
                QueryResult<RsGoodsRelReDomain> relQueryResult = this.queryGoodsRelPage(relmap);
                if (null == relQueryResult && ListUtil.isEmpty((Collection)relQueryResult.getList())) {
                    logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse,relQueryResult is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
                    return "error";
                }
                for (RsGoodsRelReDomain rsGoodsRelReDomain : relQueryResult.getList()) {
                    HashMap<String, Object> orderLine = new HashMap<String, Object>();
                    orderLine.put("itemCode", rsGoodsRelReDomain.getSkuNo());
                    orderLine.put("planQty", goods.getGoodsCamount().multiply(rsGoodsRelReDomain.getGoodsRelNum()));
                    orderLineList.add(orderLine);
                }
                continue;
            }
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("itemCode", goods.getSkuNo());
            orderLine.put("planQty", goods.getGoodsCamount());
            orderLineList.add(orderLine);
        }
        orderLines.put("orderLine", orderLineList);
        request.put("deliveryOrder", deliveryOrder);
        request.put("orderLines", orderLines);
        map.put("request", request);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    @Override
    public String sendContractDomainEndToEsb(OcContractReDomain ocContractDomain) {
        logger.error(this.SYS_CODE + ".sendContractDomainEndToEsb.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain) {
            return "error";
        }
        String esbKey = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbOderCancelUrl", "EsbOderCancelUrl");
        String EsbWarehouseCode = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbWarehouseCode", "EsbWarehouseCode");
        String EsbOwnerCode = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbOwnerCode", "EsbOwnerCode");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("warehouseCode", EsbWarehouseCode);
        request.put("ownerCode", EsbOwnerCode);
        request.put("orderCode", ocContractDomain.getContractBillcode());
        request.put("orderType", "XSDD");
        request.put("cancelType", "out");
        map.put("request", request);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    private static String getDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyMMdd");
        return df.format(new Date());
    }

    @Override
    public String sendContractDomainConfirmToEsb(OcContractReDomain ocContractDomain) {
        BigDecimal multiply;
        logger.error(this.SYS_CODE + ".sendContractDomainConfirmToEsb.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain) {
            return "error";
        }
        String esbKey = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbOutConfirmUrl", "EsbOutConfirmUrl");
        String DLSBM = "";
        if (StringUtils.isNotBlank((String)ocContractDomain.getMemberGcode())) {
            UmUserinfoReDomain userinfoByCode = this.getUserinfoByCode(ocContractDomain.getMemberGcode(), ocContractDomain.getTenantCode());
            DLSBM = userinfoByCode.getUserinfoOcode();
        }
        String KUNNR = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbKUNNR", "EsbKUNNR");
        String NAME1 = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbNAME1", "EsbNAME1");
        String LGORT = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbLGORT", "EsbLGORT");
        String WERKS = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbWERKS", "EsbWERKS");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcSapContractRequest ocEsbContractRequest = new OcSapContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        String date = BusOrderServiceImpl.getDate();
        int POSEX = 0;
        BigDecimal goodsmoney = ocContractDomain.getDataBmoney().subtract(ocContractDomain.getGoodsLogmoney());
        BigDecimal totalCost = BigDecimal.ZERO;
        HashMap<String, BigDecimal> skuCostMap = new HashMap<String, BigDecimal>();
        HashMap<String, List> goodsRelList = new HashMap<String, List>();
        for (OcContractGoodsDomain goods : goodsList) {
            if ("5".equals(goods.getGoodsPro())) {
                HashMap<String, Object> relmap = new HashMap<String, Object>();
                relmap.put("tenantCode", ocContractDomain.getTenantCode());
                relmap.put("goodsSkuCode", goods.getGoodsCode());
                Iterator relQueryResult = this.queryGoodsRelPage(relmap);
                if (null == relQueryResult || ListUtil.isEmpty((Collection)relQueryResult.getList())) {
                    logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse,relQueryResult is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
                    return "error";
                }
                for (RsGoodsRelReDomain rsGoodsRelReDomain : relQueryResult.getList()) {
                    RsSkuReDomain skuByCode = this.getSkuByCode(rsGoodsRelReDomain.getSkuCode(), ocContractDomain.getTenantCode());
                    if (null == skuByCode) {
                        logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse,skuByCode is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
                        return "error";
                    }
                    multiply = goods.getGoodsCamount().multiply(rsGoodsRelReDomain.getGoodsRelNum());
                    BigDecimal skuCost = skuByCode.getPricesetAsprice().multiply(multiply);
                    totalCost = totalCost.add(skuCost);
                    skuCostMap.put(rsGoodsRelReDomain.getSkuCode(), skuCost);
                }
                goodsRelList.put(goods.getGoodsCode(), relQueryResult.getList());
                continue;
            }
            BigDecimal skuCost = goods.getPricesetAsprice().multiply(goods.getGoodsCamount());
            totalCost = totalCost.add(skuCost);
            skuCostMap.put(goods.getSkuCode(), skuCost);
        }
        for (OcContractGoodsDomain goods : goodsList) {
            if ("5".equals(goods.getGoodsPro())) {
                List rsGoodsRelReDomains = (List)goodsRelList.get(goods.getGoodsCode());
                for (RsGoodsRelReDomain rsGoodsRelReDomain : rsGoodsRelReDomains) {
                    BigDecimal skuCost = (BigDecimal)skuCostMap.get(rsGoodsRelReDomain.getSkuCode());
                    HashMap<String, Object> orderLine = new HashMap<String, Object>();
                    orderLine.put("BSTKD", ocContractDomain.getContractBillcode());
                    orderLine.put("POSEX", ++POSEX);
                    orderLine.put("AUART", "ZG01");
                    orderLine.put("KUNNR", KUNNR);
                    orderLine.put("NAME1", NAME1);
                    orderLine.put("KUNNR2", DLSBM);
                    orderLine.put("FKDAT", date);
                    orderLine.put("MATNR", rsGoodsRelReDomain.getSkuNo());
                    orderLine.put("ARKTX", rsGoodsRelReDomain.getGoodsName());
                    multiply = goods.getGoodsCamount().multiply(rsGoodsRelReDomain.getGoodsRelNum());
                    orderLine.put("KWMENG", multiply);
                    BigDecimal WRBTR = skuCost.divide(totalCost, 8, 5).multiply(goodsmoney);
                    orderLine.put("ACTPR", WRBTR.divide(multiply, 2, 5));
                    orderLine.put("WRBTR", WRBTR.setScale(2, 5));
                    orderLine.put("WERKS", WERKS);
                    orderLine.put("LGORT", LGORT);
                    list.add(orderLine);
                }
                continue;
            }
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("BSTKD", ocContractDomain.getContractBillcode());
            orderLine.put("POSEX", ++POSEX);
            orderLine.put("AUART", "ZG01");
            orderLine.put("KUNNR", KUNNR);
            orderLine.put("KUNNR2", DLSBM);
            orderLine.put("NAME1", NAME1);
            orderLine.put("FKDAT", date);
            orderLine.put("MATNR", goods.getSkuNo());
            orderLine.put("ARKTX", goods.getGoodsName());
            BigDecimal skuCost = (BigDecimal)skuCostMap.get(goods.getSkuCode());
            BigDecimal WRBTR = skuCost.divide(totalCost, 8, 5).multiply(goodsmoney);
            orderLine.put("KWMENG", goods.getGoodsCamount());
            orderLine.put("ACTPR", WRBTR.divide(goods.getGoodsCamount(), 2, 5));
            orderLine.put("WRBTR", WRBTR.setScale(2, 5));
            orderLine.put("WERKS", WERKS);
            orderLine.put("LGORT", LGORT);
            list.add(orderLine);
        }
        if (ocContractDomain.getGoodsLogmoney().compareTo(BigDecimal.ZERO) > 0) {
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("BSTKD", ocContractDomain.getContractBillcode());
            orderLine.put("POSEX", ++POSEX);
            orderLine.put("AUART", "ZG01");
            orderLine.put("KUNNR", KUNNR);
            orderLine.put("KUNNR2", DLSBM);
            orderLine.put("NAME1", NAME1);
            orderLine.put("FKDAT", date);
            orderLine.put("MATNR", "9100000273");
            orderLine.put("ARKTX", "\u4ef7\u5916\u8d39\u7528");
            orderLine.put("KWMENG", 1);
            orderLine.put("ACTPR", ocContractDomain.getGoodsLogmoney());
            orderLine.put("WRBTR", ocContractDomain.getGoodsLogmoney().setScale(2, 5));
            orderLine.put("WERKS", WERKS);
            orderLine.put("LGORT", LGORT);
            list.add(orderLine);
        }
        map.put("list", list);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        logger.error(this.SYS_CODE + "ocEsbContractRequest", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocEsbContractRequest));
        SapContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    public static void mainww(String[] args) {
        HashMap<String, String> orderMap = new HashMap<String, String>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> hashmap = new HashMap<String, String>();
        ArrayList<HashMap<String, String>> list = new ArrayList<HashMap<String, String>>();
        map.put("shop_code", "");
        map.put("refund_id", "");
        map.put("tid", "");
        map.put("c_status", "");
        map.put("refund_fee", "");
        map.put("created", "");
        hashmap.put("sku", "");
        hashmap.put("num", "");
        list.add(hashmap);
        map.put("list", list);
        String app_key = "1521596792";
        String timestamp = "2024-07-2610:50:44";
        String app_sign = "D01EBF3E6081711E9DAF788651D781CF";
        String url = "http://47.92.210.173/oms_test/webservice.php/?method=oms.RefundAdd&app_key=1521596792&timestamp=2024-07-2610:50:44&app_sign=D01EBF3E6081711E9DAF788651D781CF";
        orderMap.put("refund", JsonUtil.buildNormalBinder().toJson(map));
        System.out.println(JsonUtil.buildNormalBinder().toJson(orderMap) + "======");
        try {
            String data = HttpClientUtil.doGet(url, orderMap);
            System.out.println(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void mainFEF(String[] args) {
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("app_key", "1722319224");
        mapStr.put("timestamp", ComConstants.requestTimestamp());
        mapStr.put("app_sign", "CABAEE47A484A85FFC7CC217B61B4228");
        mapStr.put("start_modified", "2024-07-31 11:00:00");
        mapStr.put("owner_code", "HEGII");
        mapStr.put("skus", "");
        mapStr.put("warehouse_code", "");
        mapStr.put("start_created", "");
        mapStr.put("end_created", "");
        mapStr.put("end_modified", "");
        mapStr.put("page_size", "40");
        mapStr.put("page_no", "1");
        String url = "http://omsdev.hegii.com:9110/oms/webservice.php/?method=Stock.Search";
        String data = "";
        data = HttpClientUtil.doGet(url, mapStr);
        System.out.println(data);
    }

    public static void main9(String[] args) {
        String app_key = "1521596792";
        String timestamp = "2024-07-26 14:25:34";
        String app_sign = "B36B4EAAD7341B87FD4006C8EC386107";
        String url = "http://47.92.210.173/oms_test/webservice.php/?method=Stock.Search";
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        HttpPost httpPost = new HttpPost(url);
        ArrayList<BasicNameValuePair> paramlist = new ArrayList<BasicNameValuePair>();
        paramlist.add(new BasicNameValuePair("app_key", app_key));
        paramlist.add(new BasicNameValuePair("timestamp", timestamp));
        paramlist.add(new BasicNameValuePair("app_sign", app_sign));
        paramlist.add(new BasicNameValuePair("owner_code", "CS39"));
        UrlEncodedFormEntity urlEncodedFormEntity = null;
        try {
            urlEncodedFormEntity = new UrlEncodedFormEntity(paramlist, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
        try {
            response = httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int statusCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        String s = null;
        try {
            s = EntityUtils.toString((HttpEntity)entity);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(s);
        System.out.println(statusCode);
    }

    public static void main1(String[] args) {
        String app_key = "1521596792";
        String timestamp = "2024-07-26 14:25:34";
        String app_sign = "1F7D16577F8DA71B474E518FC309A299";
        String url = "http://47.92.210.173/oms_test/webservice.php/?method=oms.InstallOrderQueryList";
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        HttpPost httpPost = new HttpPost(url);
        ArrayList<BasicNameValuePair> paramlist = new ArrayList<BasicNameValuePair>();
        paramlist.add(new BasicNameValuePair("app_key", app_key));
        paramlist.add(new BasicNameValuePair("timestamp", timestamp));
        paramlist.add(new BasicNameValuePair("app_sign", app_sign));
        UrlEncodedFormEntity urlEncodedFormEntity = null;
        try {
            urlEncodedFormEntity = new UrlEncodedFormEntity(paramlist, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
        try {
            response = httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int statusCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        String s = null;
        try {
            s = EntityUtils.toString((HttpEntity)entity);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(s);
        System.out.println(statusCode);
    }

    public static void main5(String[] args) {
        String app_key = "1521596792";
        String timestamp = "2024-07-26 14:25:34";
        String app_sign = "0A11C404C27B4DAC4555AA659C606892";
        String url = "http://47.92.210.173/oms_test/webservice.php/?method=oms.RefundQueryInfoByTid";
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        HttpPost httpPost = new HttpPost(url);
        ArrayList<BasicNameValuePair> paramlist = new ArrayList<BasicNameValuePair>();
        paramlist.add(new BasicNameValuePair("app_key", app_key));
        paramlist.add(new BasicNameValuePair("timestamp", timestamp));
        paramlist.add(new BasicNameValuePair("app_sign", app_sign));
        paramlist.add(new BasicNameValuePair("shop_code", "CS39"));
        paramlist.add(new BasicNameValuePair("tid", "103152853719"));
        UrlEncodedFormEntity urlEncodedFormEntity = null;
        try {
            urlEncodedFormEntity = new UrlEncodedFormEntity(paramlist, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
        try {
            response = httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int statusCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        String s = null;
        try {
            s = EntityUtils.toString((HttpEntity)entity);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(s);
        System.out.println(statusCode);
    }

    public static void main4(String[] args) {
        String app_key = "1521596792";
        String timestamp = "2024-07-26 14:25:34";
        String app_sign = "026C944021187BDB4A353B52E687AE8F";
        String url = "http://47.92.210.173/oms_test/webservice.php/?method=oms.SdkOrderChangeStatus";
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        HttpPost httpPost = new HttpPost(url);
        ArrayList<BasicNameValuePair> paramlist = new ArrayList<BasicNameValuePair>();
        paramlist.add(new BasicNameValuePair("app_key", app_key));
        paramlist.add(new BasicNameValuePair("timestamp", timestamp));
        paramlist.add(new BasicNameValuePair("app_sign", app_sign));
        paramlist.add(new BasicNameValuePair("shop_code", "CS39"));
        paramlist.add(new BasicNameValuePair("tid", "103152853719"));
        paramlist.add(new BasicNameValuePair("c_status", "1"));
        UrlEncodedFormEntity urlEncodedFormEntity = null;
        try {
            urlEncodedFormEntity = new UrlEncodedFormEntity(paramlist, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
        try {
            response = httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int statusCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        String s = null;
        try {
            s = EntityUtils.toString((HttpEntity)entity);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(s);
        System.out.println(statusCode);
    }

    @Override
    public String sendCreateBusOrder(OcContractReDomain ocContractDomain) {
        logger.error(this.SYS_CODE + ".sendCreateBusOrder.ocContractDomain.1", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrder.ocContractDomain", (Object)"isnull");
            return "error";
        }
        String url = "";
        url = this.getdd(ocContractDomain.getTenantCode(), "omsUrl", "omsUrl");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".ocContractDomain\uff0curl", (Object)"url\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String appKey = "";
        appKey = this.getdd(ocContractDomain.getTenantCode(), "appKey", "appKey");
        if (StringUtils.isBlank((String)appKey)) {
            logger.error(this.SYS_CODE + ".ocContractDomain\uff0cappKey", (Object)"appKey\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String GshopCode = "";
        GshopCode = this.getdd(ocContractDomain.getTenantCode(), "GshopCode", "GshopCode");
        if (StringUtils.isBlank((String)GshopCode)) {
            logger.error(this.SYS_CODE + ".ocContractDomain\uff0cGshopCode", (Object)"GshopCode\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String NshopCode = "";
        NshopCode = this.getdd(ocContractDomain.getTenantCode(), "NshopCode", "NshopCode");
        if (StringUtils.isBlank((String)NshopCode)) {
            logger.error(this.SYS_CODE + ".ocContractDomain\uff0cNshopCode", (Object)"NshopCode\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String json = "";
        Long startTime = System.currentTimeMillis();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        map.put("shop_code", GshopCode);
        if ("738401021359284283".equals(ocContractDomain.getChannelCode())) {
            map.put("shop_code", NshopCode);
        }
        map.put("warehouse_code", "");
        map.put("seller_nick", ocContractDomain.getMemberCname());
        map.put("tid", ocContractDomain.getContractBillcode());
        map.put("c_status", "0");
        map.put("status", ocContractDomain.getDataState());
        map.put("express_code", "");
        map.put("designated_express", "0");
        map.put("user_nick", ocContractDomain.getMemberBname());
        map.put("consignee", ocContractDomain.getGoodsReceiptMem());
        map.put("phone", ocContractDomain.getGoodsReceiptPhone());
        map.put("address", ocContractDomain.getGoodsReceiptArrdess());
        map.put("state", "\u4e2d\u56fd");
        String goodsReceiptArrdess = ocContractDomain.getGoodsReceiptArrdess();
        boolean status = goodsReceiptArrdess.contains("-");
        if (status) {
            String[] split = goodsReceiptArrdess.split("-");
            if (null != split && split.length != 0) {
                map.put("province", split[0]);
            }
            map.put("city", split[1]);
            map.put("area", split[2]);
        }
        map.put("town", "");
        map.put("zipcode", "");
        map.put("consignee_doc_type", "");
        map.put("consignee_doc_no", "");
        map.put("notice_send_date", ocContractDomain.getContractDepositdate());
        map.put("trans_priority", "");
        map.put("seller_flag", "");
        map.put("buyer_remark", ocContractDomain.getContractRemark());
        map.put("seller_remark", "");
        map.put("order_price", ocContractDomain.getDataBmoney());
        map.put("postage", ocContractDomain.getGoodsLogmoney());
        map.put("cod_price", ocContractDomain.getDataBmoney());
        map.put("pre_tax_price", "");
        map.put("tax_price", "");
        map.put("discount_price", ocContractDomain.getGoodsPmoney());
        map.put("order_time", ocContractDomain.getGmtCreate());
        map.put("payment_type", "0");
        map.put("payment_time", ComConstants.requestTimestamp());
        map.put("invoice_type", "");
        map.put("invoice_title", "");
        map.put("invoice_content", "");
        map.put("invoice_amount", "");
        map.put("payment_way", "WEIXIN");
        map.put("distribution_status", "1");
        map.put("plat_lastchanged", ocContractDomain.getGmtModified());
        map.put("distribution_mode", "");
        map.put("distribution_name", "");
        map.put("express_no", "");
        map.put("payment_number", "");
        map.put("gross_weight", ocContractDomain.getGoodsWeight());
        map.put("paint_marker", "");
        map.put("express_print_data", "");
        map.put("pre_sale_status", "0");
        map.put("invtno", "");
        map.put("order_flag", "");
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        if (ListUtil.isNotEmpty(goodsList)) {
            for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                HashMap<String, Object> hashmap = new HashMap<String, Object>();
                hashmap.put("oid", ocContractGoodsDomain.getContractBillcode());
                hashmap.put("title", ocContractGoodsDomain.getGoodsName());
                hashmap.put("sku", ocContractGoodsDomain.getSkuNo());
                hashmap.put("num", ocContractGoodsDomain.getGoodsCamount());
                hashmap.put("goods_price", ocContractGoodsDomain.getPricesetNprice());
                hashmap.put("avg_money", ocContractGoodsDomain.getContractGoodsPrice());
                hashmap.put("tax_price", "");
                hashmap.put("discount_price", "");
                hashmap.put("install_price", ocContractGoodsDomain.getContractGoodsBoxamt());
                hashmap.put("return_status", "");
                hashmap.put("is_install", "");
                hashmap.put("sku_properties", "");
                hashmap.put("net_weight", ocContractGoodsDomain.getGoodsWeight());
                list.add(hashmap);
            }
        }
        map.put("detail", list);
        ArrayList customlist = new ArrayList();
        HashMap<String, String> hashmap1 = new HashMap<String, String>();
        hashmap1.put("_custom_fld", "");
        customlist.add(hashmap1);
        ArrayList detaillist = new ArrayList();
        HashMap<String, String> hashmap2 = new HashMap<String, String>();
        hashmap2.put("sku", "");
        hashmap2.put("_custom_fld", "");
        detaillist.add(hashmap2);
        map.put("detaillist", detaillist);
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("method", "oms.SdkOrderAdd");
        mapStr.put("app_key", appKey);
        mapStr.put("timestamp", ComConstants.requestTimestamp());
        mapStr.put("app_sign", "");
        mapStr.put("order", JsonUtil.buildNormalBinder().toJson(map));
        logger.error(this.SYS_CODE + ".sendCreateBusOrder.returnResultsMap.map" + JsonUtil.buildNormalBinder().toJson(map));
        String data = null;
        try {
            data = HttpClientUtil.doGet(url, mapStr);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrder.url" + url, (Object)(JsonUtil.buildNormalBinder().toJson(mapStr) + "e" + e));
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendCreateBusOrder.returnResultsMap.code" + JsonUtil.buildNormalBinder().toJson(mapStr), (Object)(data + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrder.returnResultsMap" + JsonUtil.buildNormalBinder().toJson(mapStr), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("status");
        long code1 = Long.parseLong(code.toString());
        if (code1 > 0L) {
            return "success";
        }
        return "error";
    }

    @Override
    public String queryContractDomainPage(Map<String, Object> map) {
        String app_key = "1521596792";
        String timestamp = "2024-07-23 15:59:28";
        String app_sign = "980CF4F3334F775B0300C9975FB62EE3";
        String url = "http://47.92.210.173/oms_test/webservice.php/?method=oms.InstallOrderQueryList&app_key=1521596792&timestamp=2024-07-23 15:59:28&app_sign=980CF4F3334F775B0300C9975FB62EE3";
        String data = OKHttpClientUtil.sendPost(url, JsonUtil.buildNormalBinder().toJson(map));
        return data;
    }

    @Override
    public String queryInstallOrderQueryList(Map<String, Object> map) {
        logger.error(this.SYS_CODE + ".queryInstallOrderQueryList.ocContractDomain.1", (Object)JsonUtil.buildNormalBinder().toJson(map));
        Long startTime = System.currentTimeMillis();
        if (null == map) {
            logger.error(this.SYS_CODE + ".queryInstallOrderQueryList.ocContractDomain", (Object)"isnull");
            return "error";
        }
        String url = "";
        url = this.getdd((String)map.get("tenantCode"), "omsUrl", "omsUrl");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".queryInstallOrderQueryList\uff0curl", (Object)"url\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String appKey = "";
        appKey = this.getdd((String)map.get("tenantCode"), "appKey", "appKey");
        if (StringUtils.isBlank((String)appKey)) {
            logger.error(this.SYS_CODE + ".queryInstallOrderQueryList\uff0cappKey", (Object)"appKey\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String appSecret = "";
        appSecret = this.getdd((String)map.get("tenantCode"), "appSecret", "appSecret");
        if (StringUtils.isBlank((String)appSecret)) {
            logger.error(this.SYS_CODE + ".queryInstallOrderQueryList\uff0cappSecret", (Object)"appSecret\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("method", "oms.SdkOrderChangeStatus");
        mapStr.put("app_key", appKey);
        mapStr.put("timestamp", ComConstants.requestTimestamp());
        mapStr.put("app_sign", "");
        String data = null;
        try {
            data = HttpClientUtil.doGet(url, mapStr);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".queryInstallOrderQueryList.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(mapStr));
            return "error";
        }
        logger.error(this.SYS_CODE + ".queryInstallOrderQueryList.returnResultsMap.code" + JsonUtil.buildNormalBinder().toJson(mapStr), (Object)(data + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".queryInstallOrderQueryList.returnResultsMap" + JsonUtil.buildNormalBinder().toJson(mapStr), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("status");
        long code1 = Long.parseLong(code.toString());
        if (code1 > 0L) {
            return "success";
        }
        return "error";
    }

    @Override
    public String sendSaveBusRefundOms(String tenantCode, String tid) {
        Long startTime = System.currentTimeMillis();
        if (StringUtils.isBlank((String)tenantCode)) {
            tenantCode = "2023072819990101";
        }
        if (StringUtils.isBlank((String)tid)) {
            return "error";
        }
        String url = "";
        url = this.getdd(tenantCode, "omsUrl", "omsUrl");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefundOms\uff0curl", (Object)"url\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String appKey = "";
        appKey = this.getdd(tenantCode, "appKey", "appKey");
        if (StringUtils.isBlank((String)appKey)) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefundOms\uff0cappKey", (Object)"appKey\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String appSecret = "";
        appSecret = this.getdd(tenantCode, "appSecret", "appSecret");
        if (StringUtils.isBlank((String)appSecret)) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefundOms\uff0cappSecret", (Object)"appSecret\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String NshopCode = "";
        NshopCode = this.getdd(tenantCode, "NshopCode", "NshopCode");
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("method", "oms.RefundQueryInfoByTid");
        mapStr.put("app_key", appKey);
        mapStr.put("timestamp", ComConstants.requestTimestamp());
        mapStr.put("app_sign", appSecret);
        mapStr.put("shop_code", NshopCode);
        mapStr.put("tid", tid);
        String data = null;
        try {
            data = HttpClientUtil.doGet(url, mapStr);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefundOms.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(mapStr));
            return "error";
        }
        RefundResultDomain refundResultDomain = (RefundResultDomain)JsonUtil.buildNormalBinder().getJsonToObject(data, RefundResultDomain.class);
        DataRefundDomain data1 = refundResultDomain.getData();
        List<RefundResult> result = data1.getResult();
        if (ListUtil.isEmpty(result)) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefundOms result is null");
            return "error";
        }
        return "success";
    }

    @Override
    public String sendCreateBusOrderStatus(OcContractReDomain ocContractDomain) {
        logger.error(this.SYS_CODE + ".sendCreateBusOrderStatus.ocContractDomain.1", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        Long startTime = System.currentTimeMillis();
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrderStatus.ocContractDomain", (Object)"isnull");
            return "error";
        }
        String GshopCode = "";
        GshopCode = this.getdd(ocContractDomain.getTenantCode(), "GshopCode", "GshopCode");
        if (StringUtils.isBlank((String)GshopCode)) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrderStatus\uff0cGshopCode", (Object)"GshopCode\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String NshopCode = "";
        NshopCode = this.getdd(ocContractDomain.getTenantCode(), "NshopCode", "NshopCode");
        if (StringUtils.isBlank((String)NshopCode)) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrderStatus\uff0cNshopCode", (Object)"NshopCode\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String url = "";
        url = this.getdd(ocContractDomain.getTenantCode(), "omsUrl", "omsUrl");
        if (StringUtils.isBlank((String)url)) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrderStatus\uff0curl", (Object)"url\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String appKey = "";
        appKey = this.getdd(ocContractDomain.getTenantCode(), "appKey", "appKey");
        if (StringUtils.isBlank((String)appKey)) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrderStatus\uff0cappKey", (Object)"appKey\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        String appSecret = "";
        appSecret = this.getdd(ocContractDomain.getTenantCode(), "appSecret", "appSecret");
        if (StringUtils.isBlank((String)appSecret)) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrderStatus\uff0cappSecret", (Object)"appSecret\u5730\u5740\u4e3a\u7a7a");
            return "error";
        }
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("method", "oms.SdkOrderChangeStatus");
        mapStr.put("app_key", appKey);
        mapStr.put("timestamp", ComConstants.requestTimestamp());
        mapStr.put("app_sign", "");
        mapStr.put("shop_code", GshopCode);
        if ("738401021359284283".equals(ocContractDomain.getChannelCode())) {
            mapStr.put("shop_code", NshopCode);
        }
        mapStr.put("tid", ocContractDomain.getContractBillcode());
        if (2 == ocContractDomain.getDataState()) {
            mapStr.put("c_status", "1");
        }
        if (3 == ocContractDomain.getDataState()) {
            mapStr.put("c_status", "2");
        }
        if (-1 == ocContractDomain.getDataState()) {
            mapStr.put("c_status", "3");
        }
        String data = null;
        try {
            data = HttpClientUtil.doGet(url, mapStr);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrderStatus.url" + url, (Object)JsonUtil.buildNormalBinder().toJson(mapStr));
            return "error";
        }
        logger.error(this.SYS_CODE + ".sendCreateBusOrderStatus.returnResultsMap.code" + JsonUtil.buildNormalBinder().toJson(mapStr), (Object)(data + "startTime" + (System.currentTimeMillis() - startTime)));
        Map returnResultsMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(data, String.class, Object.class);
        if (MapUtil.isEmpty((Map)returnResultsMap)) {
            logger.error(this.SYS_CODE + ".sendCreateBusOrderStatus.returnResultsMap" + JsonUtil.buildNormalBinder().toJson(mapStr), (Object)data);
            return "error";
        }
        Object code = returnResultsMap.get("status");
        long code1 = Long.parseLong(code.toString());
        if (code1 > 0L) {
            return "success";
        }
        return "error";
    }

    public static void main(String[] args) {
    }

    public static void main8(String[] args) {
        String app_key = "1521596792";
        String timestamp = "2024-07-26 14:25:34";
        String app_sign = "0A11C404C27B4DAC4555AA659C606892";
        String url = "http://47.92.210.173/oms_test/webservice.php/?method=oms.RefundQueryInfoByTid";
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        HttpPost httpPost = new HttpPost(url);
        ArrayList<BasicNameValuePair> paramlist = new ArrayList<BasicNameValuePair>();
        paramlist.add(new BasicNameValuePair("app_key", app_key));
        paramlist.add(new BasicNameValuePair("timestamp", timestamp));
        paramlist.add(new BasicNameValuePair("app_sign", app_sign));
        paramlist.add(new BasicNameValuePair("shop_code", "CS39"));
        paramlist.add(new BasicNameValuePair("tid", "103152853719"));
        UrlEncodedFormEntity urlEncodedFormEntity = null;
        try {
            urlEncodedFormEntity = new UrlEncodedFormEntity(paramlist, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
        try {
            response = httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int statusCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        String s = null;
        try {
            s = EntityUtils.toString((HttpEntity)entity);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected String getdd(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }
}

